=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::PhantomElement;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::MathElement;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Specifies an instance of mathematical text that contained within a MathParagraph and starts on its own line.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ type } = 'Phantom';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Specifies an instance of mathematical text that contained within a MathParagraph and starts on its own line.',
                                  class => 'PhantomElement',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'type' => {
    	datatype => 'string',
    	base_name => 'Type',
    	description => 'Element type',
    	format => '',
    	read_only => '',
    		},
    'base' => {
    	datatype => 'MathElement',
    	base_name => 'Base',
    	description => 'Base element',
    	format => '',
    	read_only => '',
    		},
    'show' => {
    	datatype => 'boolean',
    	base_name => 'Show',
    	description => 'true if the base element is displayed.',
    	format => '',
    	read_only => '',
    		},
    'zero_width' => {
    	datatype => 'boolean',
    	base_name => 'ZeroWidth',
    	description => 'true if the the width of the base element should be treated as zero.',
    	format => '',
    	read_only => '',
    		},
    'zero_asc' => {
    	datatype => 'boolean',
    	base_name => 'ZeroAsc',
    	description => 'true if the the ascent (height above baseline) of the base element should be treated as zero.',
    	format => '',
    	read_only => '',
    		},
    'zero_desc' => {
    	datatype => 'boolean',
    	base_name => 'ZeroDesc',
    	description => 'true if the the descent (depth below baseline) of the base element should be treated as zero.',
    	format => '',
    	read_only => '',
    		},
    'transp' => {
    	datatype => 'boolean',
    	base_name => 'Transp',
    	description => 'true if operators and symbols inside the phantom still affect mathematical spacing around the phantom (as if visible).',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'type' => 'string',
    'base' => 'MathElement',
    'show' => 'boolean',
    'zero_width' => 'boolean',
    'zero_asc' => 'boolean',
    'zero_desc' => 'boolean',
    'transp' => 'boolean'
} );

__PACKAGE__->attribute_map( {
    'type' => 'Type',
    'base' => 'Base',
    'show' => 'Show',
    'zero_width' => 'ZeroWidth',
    'zero_asc' => 'ZeroAsc',
    'zero_desc' => 'ZeroDesc',
    'transp' => 'Transp'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
