/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UPolygon uPolygon = (UPolygon)uShape;
        double[] dArray = uPolygon.getPointArray(d, d2);
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            for (int i = 0; i < dArray.length; i += 2) {
                if (uClip.isInside(dArray[i], dArray[i + 1])) continue;
                return;
            }
        }
        String string = StringUtils.getAsSvg(colorMapper, uParam.getColor());
        HtmlColor htmlColor = uParam.getBackcolor();
        if (htmlColor instanceof HtmlColorGradient) {
            HtmlColorGradient htmlColorGradient = (HtmlColorGradient)htmlColor;
            String string2 = svgGraphics.createSvgGradient(StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor1())), StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor2())), htmlColorGradient.getPolicy());
            svgGraphics.setFillColor("url(#" + string2 + ")");
        } else {
            String string3 = StringUtils.getAsSvg(colorMapper, htmlColor);
            svgGraphics.setFillColor(string3);
        }
        svgGraphics.setStrokeColor(string);
        svgGraphics.setStrokeWidth(uParam.getStroke().getThickness(), uParam.getStroke().getDasharraySvg());
        svgGraphics.svgPolygon(uPolygon.getDeltaShadow(), dArray);
    }
}

