#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 250_Slurm-SAWCKey-echo.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::WCKey;

my $testDir = dirname(abs_path($0));
our $num_tests_run = 0;

require "$testDir/helpers/echo-help.pl";

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/echo_cmdline");
my $sawckey = 'Slurm::Sacctmgr::WCKey';

my $results;
my $args;
my $err;
my $argstr;
my (@temp, @temp2);
my ($temp, $temp2);

#Test various commands with echo sacctmgr


my @listtmp1 = ( 'list', 'wckey', 'format=wckey,cluster,user' );
my @listtmp2 = ( '--parsable2', '--noheader', '--readonly' );
@temp = ( user=>'payerle', );
$results = $sawckey->sacctmgr_list($sa,@temp);
$results = $sawckey->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list wckey (single field)');

@temp = ( user=>'payerle', cluster=>'yottascale'  );
$results = $sawckey->sacctmgr_list($sa,@temp);
$results = $sawckey->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list wckey multi-fields');

#Listable only, no add, modify or delete commands to check

#Now verify that nothing is run when we are in debug mode
#Except that we are only listable, so everything should run
#note('The remaining tests generate [DRYRUN] lines, which you can ignore');
#note('We just want to make sure they dont actually _do_ anything');
$sa->dryrun(1);

#This one actually _should_ run, as is just a list
@temp = ( user=>'payerle', );
$results = $sawckey->sacctmgr_list($sa,@temp);
$results = $sawckey->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single wckey (dryrun mode)');

done_testing($num_tests_run);

