# Generated by default/object.tt
package Paws::Robomaker::WorldExportJobSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has Worlds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'worlds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::WorldExportJobSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::WorldExportJobSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Worlds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::WorldExportJobSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Information about a world export job.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the world export job.


=head2 CreatedAt => Str

The time, in milliseconds since the epoch, when the world export job
was created.


=head2 Status => Str

The status of the world export job.

=over

=item Pending

The world export job request is pending.

=item Running

The world export job is running.

=item Completed

The world export job completed.

=item Failed

The world export job failed. See C<failureCode> for more information.

=item Canceled

The world export job was cancelled.

=item Canceling

The world export job is being cancelled.

=back



=head2 Worlds => ArrayRef[Str|Undef]

A list of worlds.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

