# Generated by default/object.tt
package Paws::LookoutMetrics::TimeSeriesFeedback;
  use Moose;
  has IsAnomaly => (is => 'ro', isa => 'Bool');
  has TimeSeriesId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::TimeSeriesFeedback

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::TimeSeriesFeedback object:

  $service_obj->Method(Att1 => { IsAnomaly => $value, ..., TimeSeriesId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::TimeSeriesFeedback object:

  $result = $service_obj->Method(...);
  $result->Att1->IsAnomaly

=head1 DESCRIPTION

Details about feedback submitted for an anomalous metric.

=head1 ATTRIBUTES


=head2 IsAnomaly => Bool

Feedback on whether the metric is a legitimate anomaly.


=head2 TimeSeriesId => Str

The ID of the metric.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

