#!/usr/bin/perl
use FindBin;
BEGIN { chdir $FindBin::Bin };

### include lib, inc and lib/cpanplus/inc to @INC ###
BEGIN { use File::Spec;
        require lib;
        my $l = 'lib'; $l->import( qw[lib] );
}

### we /need/ perl5.6.1 or higher -- we use coderefs in @INC,
### and 5.6.0 is just too buggy
use 5.006001;


use strict;
use CPANPLUS::inc;
use Config;
use File::Copy                  qw[copy];
use IPC::Cmd                    qw[can_run];
use Module::Load::Conditional   qw[check_install];
use ExtUtils::MakeMaker;
use CPANPLUS::Internals::Constants;
use inc::Module::Install;

use constant BASIC_TESTS =>     qq[t/00_CPANPLUS-Internals-Utils.t];

###################################################################

require Term::UI;
require Term::ReadLine;
require Locale::Maketext::Simple;

require CPANPLUS::Configure;
require CPANPLUS::Configure::Setup;

Locale::Maketext::Simple->import(
    Class => 'CPANPLUS',
    Style => 'gettext',
);

### we need to auto_install() stuff still, because the included modules
### are just for b-strapping; $AutoInstall will be used to control that
my $ConfigObj;      # config object
my $AutoInstall;    # flag to really perform autoinstallation
my $HasPrev;        # flag to indicate a config from previous versions found
my $HasOld;         
my $RunSetup;       # should we run setup at all?
my $Prereq_pm = {}; # any prereqs we find we have
my $JFDI;           # just write the bloody makefile.pl already


### first, look for SETUP=1 or SETUP=yes, AUTOINSTALL=.., JFDI=.. in @ARGV
{   foreach my $arg (@ARGV) {
        $RunSetup    = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^SETUP=(.)/i;
        $AutoInstall = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^AUTOINSTALL=(.)/i;
        $JFDI        = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^JFDI=(.)/i;
    
    }

    ### removes the SETUP=* and AUTOINSTALL=*, JFDI=* to make MakeMaker happier
    @ARGV = grep { $_ !~ /^(?:SETUP|AUTOINSTALL|JFDI)=./i } @ARGV;
}

### XXX prereq_pm doesn't deal with the 'perl' keyword as expected
### find out from sqrn what to do
if(0){
#if( $^O eq 'cygwin' and $] < '5.008' ) {
    print loc("
### IMPORTANT! ######################################################

You are using $^O with a perl version lower than perl-5.8 (namely $]).
This is sadly not supported, because 'IPC::Run' doesn't work properly,
meaning we cannot run commandline programs reliably.

I'm afraid you will have to upgrade to perl-5.8 or higher to be able
to use CPANPLUS on this operating system. This will be added to the
Makefile.PL's 'PREREQ_PM' section so automated installers will 'Do
The Right Thing'.

We're sorry for the inconvenience.
    \n");

    $Prereq_pm->{'perl'} = '5.8.0';

    sleep 3;
}
else {
    $Prereq_pm->{'perl'} = '5.6.1';
}

### just f***ing do it
if( $JFDI ) {
    write_makefile(); 
    exit;
}

print loc("
### PLEASE NOTE ###################################################

CPANPLUS will be shipped alongside CPAN.pm in the 5.10 core. 
Although you should *NOT* expect it to work just like CPAN.pm, 
there is a compatible shell available. See perldoc CPANPLUS::Shell 
after installation

You are strongly urged to configure CPANPLUS now, since otherwise
non-privileged (non-root) users may be unable to use CPANPLUS until
you configure it properly.

###################################################################
");

### check if we found some config that we can use as a base config;
### if not, put a copy of the config.pm-orig in place;
unless( $HasPrev = is_configured() ) {
    my $lc = local_config();
    
    ### you might already have a config.pm generated by a 
    ### previous invocation of perl Makefile.PL
    unless( $HasOld ) {
        copy( $lc.'-orig', $lc )
            or die loc("Cannot write to %1", $lc );
    }
    
    ### now we read in the config from the local tree 
    ### note that is_configured() may have already require another
    ### CPANPLUS::Config too, and we don't want it to start warning about 
    ### redefined subroutines
    { local $^W; require $lc; }      
}

### XXX fetch nmake? (module::install does that, can't get it to work properly)

### by now we have required a workable CPANPLUS::Config, which we can
### pass to setup.pm's constructor.

my $term = Term::ReadLine->new('');
if( setup_needed() ) {
    $ConfigObj = CPANPLUS::Configure->new;

    my $setup = CPANPLUS::Configure::Setup->new(
                    term                => $term,
                    configure_object    => $ConfigObj,
                );

    $setup->autosetup(1)    if $AutoInstall;
    #$setup->skip_mirrors(1) if $HasPrev;
    $setup->use_previous(1) if $HasPrev;
    
    $setup->init or die loc("Setup failed");
    
    write_makefile();

### you don't want to set up ###
} elsif ( $HasOld ) {
    write_makefile();

} else {
    print loc("Skipping setup; Advanced tests disabled!");
    
    ### XXX what to do with the tests??? ###
    write_makefile( BASIC_TESTS );
}    

### check if the user wants to run setup ###
sub setup_needed {
    my $run_setup;

    ### first, look for SETUP=1 or SETUP=yes in @ARGV
    foreach my $arg (@ARGV) {
        $run_setup   = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^SETUP=(.)/i;
        $AutoInstall = (($1 =~ /[1yY]/) ? 1 : 0) 
                                    if $arg =~ /^AUTOINSTALL=(.)/i;
    }

    ### removes the SETUP=* and AUTOINSTALL=* to make MakeMaker happier
    if (defined $run_setup) {
        @ARGV = grep { $_ !~ /^(?:SETUP|AUTOINSTALL)=./i } @ARGV;
    
    
    ### can't tell from @ARGV, so ask the user instead
    } else {     
        my $prompt = (
            $HasPrev ? loc("Manually configure CPANPLUS ".
                            "based on previous settings?") :
            $HasOld  ? loc("Old settings detected. Do you " .
                            "want to modify them?")
                      : loc("Do you want to configure CPANPLUS now?")
        );
    
        $run_setup = $term->ask_yn(
            prompt  => $prompt,
            default => (($HasOld and not $HasPrev) ? 'n' : 'y'),
        );
    
        print loc("Okay, existing settings are preserved") . $/
            unless $run_setup;
    
    }
    
    ### ok, if you have previous settings, but you don't want to 
    ### manually reconfigure, then we still have to run setup, 
    ### just automatically.
    if( $HasPrev and !$run_setup ) {
        $AutoInstall = 1; $run_setup = 1;
    }
    
    return $run_setup;
}

sub is_configured {
    ### perhaps you ran perl Makefile.PL already, and there's a 
    ### config.pm in this tree. In that case, we should use it.
    ### if the fie exists, and the file size is not the same as the
    ### config template, we'll assume you configured it.
    my $local_conf = local_config();
    return $HasOld = 1 if -e $local_conf and 
                          (-s $local_conf != -s $local_conf."-orig");    
    
    ### no config found in the local tree, let's go looking on the rest
    ### of the filesystem
    ### silence any error coming out of this, 
    eval {  local $CPANPLUS::Error::ERROR_FH;
            CPANPLUS::Configure->_load_cpanplus_config };
   
    ### so we couldn't load a suitable config ###
    return 0 if $@;
    
    ### ok, we found a config.pm, but is it a high enough version? 
    return 1 if CPANPLUS::Configure->_config_version_sufficient;

    ### all failed, no config.pm found ###
    return 0;
}    
    
sub local_config { return File::Spec->catfile(qw|lib CPANPLUS Config.pm|); }

sub write_makefile {
    my $tests = shift;

    ### XXX skip autoinstall stuff now, as EU::AI doesn't know about CPANPLUS'
    ### new API and therefore will die in annoying ways. --kane
    ### we require a config object for autoinstall to determine defaults
    #try_autoinstall() if $ConfigObj;  

    print loc("
### PLEASE NOTE ###################################################

Since CPANPLUS 0.050 has a changed API, we cannot automatically 
install extra modules for you using ExtUtils::AutoInstall. All 
required non-core modules are therefore bundled with CPANPLUS and 
you will not need to install anything extra to run CPANPLUS.

If you wish to facilitate some of the features you've chosen, you
should install them yourself once CPANPLUS is installed.

###################################################################
    
    ");    


    my $string;
    my $mods = CPANPLUS::inc->interesting_modules;
    for my $mod ( sort keys %$mods ) {
        $string .= sprintf( "\t%-26s %-8s\n", $mod, $mods->{$mod} );
    }       

    print loc("
### PLEASE NOTE ###################################################

Since CPANPLUS 0.050 has a few prerequisites that are not core
perl (yet), they are bundled with the distribution. CPANPLUS will
do it's best to use the right version of a module when it can, by
looking in the bundle directory, if your systemwide module version
is too low. However, ideally use you should really install these 
modules yourself. You can do this as soon as you've installed
CPANPLUS:

%1

###################################################################
    
    ", $string);  

### don't mention this yet, not quite supported
#If you wish to run cpanpd.pl, the CPANPLUS daemon, you should
#install recent versions of 'POE' and 'IO::String'

    name            ('CPANPLUS');
    author          ('Jos Boumans <kane@cpan.org>');
    abstract        ('Ameliorated interface to the CPAN');
    version_from    ('lib/CPANPLUS/Internals.pm');
    license         ('perl');
    no_index        ( directory => 'lib/CPANPLUS/inc' );
    install_script  ($_) for glob('bin/*');
    requires        (%$Prereq_pm);
    makemaker_args  ( TESTS => $tests ) if $tests;
    makemaker_args  ( clean => { FILES => 't/.*.output' } );

    ### write the makefile ###
    &WriteAll( check_nmake => 1, sign => 1 );

    print loc("Now, please type '%1' to test, and '%2' to install.",
              "$Config{make} test", "$Config{make} install"), "\n";

    ### make an educated guess of whether we'll need root permission.
    ### here '$>' needs to be in eval"" because some platforms don't 
    ### support it, and will die promptly just by seeing that variable.
    ### XXX not installing any dependencies now, so don't bother warning
    ### either
    #if (eval '$>' and $AutoInstall) {
    #    print loc("You may need to do that as the 'root' user to " .
    #              "install dependencies."), "\n";
    #}
}



__END__


sub try_autoinstall {
    print loc("
### PLEASE NOTE ###################################################

Although the core features of CPANPLUS do not require external
modules, they may depend on other modules to work according to your
configuration.  If you skip the probing, or answer 'n' to questions
that defaults to 'Y', there might be _unpredictable failures_!

###################################################################
");

    my $install = $AutoInstall || 
                  $term->ask_yn(
                    prompt  => loc('Let the installer probe for dependencies?'),
                    default => 'y' 
                  );

    
    my $has_cc      = $Config::Config{'cc'};
    my $has_gpg     = can_run('gpg') 
                        || check_install( module => 'Crypt::OpenPGP' );
    
    if( $install ) {
        ExtUtils::AutoInstall->import(
            -core                   => 'all',
            -config                 => [
                ### Skip all tests to speed up installation.
                ### Also, following modules are particularly bad:
                ### - LWP takes lots of time to finish.
                ### - Term::ReadLine::Perl's test is interactive.
                ### - Compress::Zlib works but fails tests on Darwin.
                -skiptest           => 1,
                -prereqs            => 1,
                -do_once            => 1,
            ],               
    
            ### source files and friends ###
            loc('Uncompress .tar.gz files')     => [
                -default            => ($has_cc && 
                                        !$ConfigObj->get_program('tar')),
                'Compress::Zlib'    => 0.01,
                'IO::Zlib'          => 1.03,
                'Archive::Tar'      => 1.10,
            ],
            loc('Uncompress .zip files')        => [
                -default            => !$ConfigObj->get_program('unzip'),
                'Archive::Zip'      => 0.01,
            ],
            
            ### need a compiler for these ###
            $has_cc ? (
                loc('Uncompress .gz files')     => [
                    -default            => !$ConfigObj->get_program('gzip'),
                    'Compress::Zlib'    => 1.00,
                ],
                loc('Cached metadata')          => [
                    -default            => $ConfigObj->get_conf('storable'),
                    'Storable'          => 1.00,
                ],
                loc('MD5 checksum')             => [
                    -default            => $ConfigObj->get_conf('md5'),
                    'Digest::MD5'       => 2.00,
                ],
            ) : (),
            
            
            ### networking stuff ###
            loc('Net::FTP support')             => [
                -default            => 1,
                'Net::FTP'          => 2.00,
            ],
            loc('File::RsyncP support')         => [
                -default            => 0,
                'File::RsyncP'      => 0,
            ],
            
            loc('Local file support & CPAN test query') => [
                -default            => 0,
                'URI'               => 1.00,
                'HTML::HeadParser'  => 0,
                'Net::FTP'          => 2.00,
                'MIME::Base64'      => 2.00,
                'Digest::MD5'       => 2.00,
                'LWP'               => 5.60,
            ],
            
            loc('CPAN Test reporting')          => [
                -default            => $ConfigObj->get_conf('cpantest'),
                'Net::SMTP'         => 0.01,
                'Test::Reporter'    => 1.20,
                'YAML'              => 0,
            ],
            
            ### XXX term::size/win32console? ###
            
            ### XXX IPC::Run probing? (bundled now)
            
            ### XXX Distributions? (not yet done)
            
            ### XXX Shells (interface changed, not working)
            
            ### XXX Poe/IO::String for cpanpd? (experimental, wait)
            
            ### want to have signature checks? ###
            $has_gpg ? (
                loc('PGP signatures')           => [
                    -default            => $ConfigObj->get_conf('signature'),
                    'Module::Signature' => 0.33,
                ],
            ) : (),
            
            ### L10N?
            loc('Localized messages')           => [
                -default                    => 0,
                'Locale::Maketext'          => 0.20,
                'Locale::Maketext::Lexicon' => 0.28,
            ],
        );
    }
    
    ### XXX import keys to gnupg? ###
}    



__END__


