#!/usr/bin/perl

package eBay::API::XML::Call::GetStore::GetStoreResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetStoreResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetStore::GetStoreResponseType

=head1 DESCRIPTION

Returns the data describing a seller's eBay store, including name, description,
URL, and other information. The caller making the request must be the owner
of an eBay store. If the authenticated caller does not have an eBay store, the
response is an error. A successful response contains either the complete store
configuration or information about the category hierarchy for the store only.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetStore::GetStoreResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::StoreType;


my @gaProperties = ( [ 'Store', 'ns:StoreType', ''
	     ,'eBay::API::XML::DataType::StoreType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setStore()

The data describing the store configuration.

#    Argument: 'ns:StoreType'

=cut

sub setStore {
  my $self = shift;
  $self->{'Store'} = shift
}

=head2 getStore()

  Returned: Always
#    Returns: 'ns:StoreType'

=cut

sub getStore {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Store'
		,'eBay::API::XML::DataType::StoreType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
