use Unicode::Collate::CJK::JISX0208;
+{
   overrideCJK => \&Unicode::Collate::CJK::JISX0208::weightJISX0208,
   entry => <<'ENTRY', # for DUCET v5.2.0
3041      ; [.2B15.0020.000F.3041] # HIRAGANA LETTER SMALL A
3042      ; [.2B15.0020.0011.3042] # HIRAGANA LETTER A
3043      ; [.2B16.0020.000F.3043] # HIRAGANA LETTER SMALL I
3044      ; [.2B16.0020.0011.3044] # HIRAGANA LETTER I
3045      ; [.2B17.0020.000F.3045] # HIRAGANA LETTER SMALL U
3046      ; [.2B17.0020.0011.3046] # HIRAGANA LETTER U
3047      ; [.2B18.0020.000F.3047] # HIRAGANA LETTER SMALL E
3048      ; [.2B18.0020.0011.3048] # HIRAGANA LETTER E
3049      ; [.2B19.0020.000F.3049] # HIRAGANA LETTER SMALL O
304A      ; [.2B19.0020.0011.304A] # HIRAGANA LETTER O
304B      ; [.2B1A.0020.0011.304B] # HIRAGANA LETTER KA
304C      ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099] # HIRAGANA LETTER GA
304D      ; [.2B1B.0020.0011.304D] # HIRAGANA LETTER KI
304E      ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099] # HIRAGANA LETTER GI
304F      ; [.2B1C.0020.0011.304F] # HIRAGANA LETTER KU
3050      ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099] # HIRAGANA LETTER GU
3051      ; [.2B1D.0020.0011.3051] # HIRAGANA LETTER KE
3052      ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099] # HIRAGANA LETTER GE
3053      ; [.2B1E.0020.0011.3053] # HIRAGANA LETTER KO
3054      ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099] # HIRAGANA LETTER GO
3055      ; [.2B1F.0020.0011.3055] # HIRAGANA LETTER SA
3056      ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099] # HIRAGANA LETTER ZA
3057      ; [.2B20.0020.0011.3057] # HIRAGANA LETTER SI
3058      ; [.2B20.0020.0011.3057][.0000.0148.0002.3099] # HIRAGANA LETTER ZI
3059      ; [.2B21.0020.0011.3059] # HIRAGANA LETTER SU
305A      ; [.2B21.0020.0011.3059][.0000.0148.0002.3099] # HIRAGANA LETTER ZU
305B      ; [.2B22.0020.0011.305B] # HIRAGANA LETTER SE
305C      ; [.2B22.0020.0011.305B][.0000.0148.0002.3099] # HIRAGANA LETTER ZE
305D      ; [.2B23.0020.0011.305D] # HIRAGANA LETTER SO
305E      ; [.2B23.0020.0011.305D][.0000.0148.0002.3099] # HIRAGANA LETTER ZO
305F      ; [.2B24.0020.0011.305F] # HIRAGANA LETTER TA
3060      ; [.2B24.0020.0011.305F][.0000.0148.0002.3099] # HIRAGANA LETTER DA
3061      ; [.2B25.0020.0011.3061] # HIRAGANA LETTER TI
3062      ; [.2B25.0020.0011.3061][.0000.0148.0002.3099] # HIRAGANA LETTER DI
3063      ; [.2B26.0020.000F.3063] # HIRAGANA LETTER SMALL TU
3064      ; [.2B26.0020.0011.3064] # HIRAGANA LETTER TU
3065      ; [.2B26.0020.0011.3064][.0000.0148.0002.3099] # HIRAGANA LETTER DU
3066      ; [.2B27.0020.0011.3066] # HIRAGANA LETTER TE
3067      ; [.2B27.0020.0011.3066][.0000.0148.0002.3099] # HIRAGANA LETTER DE
3068      ; [.2B28.0020.0011.3068] # HIRAGANA LETTER TO
3069      ; [.2B28.0020.0011.3068][.0000.0148.0002.3099] # HIRAGANA LETTER DO
306A      ; [.2B29.0020.0011.306A] # HIRAGANA LETTER NA
306B      ; [.2B2A.0020.0011.306B] # HIRAGANA LETTER NI
306C      ; [.2B2B.0020.0011.306C] # HIRAGANA LETTER NU
306D      ; [.2B2C.0020.0011.306D] # HIRAGANA LETTER NE
306E      ; [.2B2D.0020.0011.306E] # HIRAGANA LETTER NO
306F      ; [.2B2E.0020.0011.306F] # HIRAGANA LETTER HA
3070      ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099] # HIRAGANA LETTER BA
3071      ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A] # HIRAGANA LETTER PA
3072      ; [.2B2F.0020.0011.3072] # HIRAGANA LETTER HI
3073      ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099] # HIRAGANA LETTER BI
3074      ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A] # HIRAGANA LETTER PI
3075      ; [.2B30.0020.0011.3075] # HIRAGANA LETTER HU
3076      ; [.2B30.0020.0011.3075][.0000.0148.0002.3099] # HIRAGANA LETTER BU
3077      ; [.2B30.0020.0011.3075][.0000.0149.0002.309A] # HIRAGANA LETTER PU
3078      ; [.2B31.0020.0011.3078] # HIRAGANA LETTER HE
3079      ; [.2B31.0020.0011.3078][.0000.0148.0002.3099] # HIRAGANA LETTER BE
307A      ; [.2B31.0020.0011.3078][.0000.0149.0002.309A] # HIRAGANA LETTER PE
307B      ; [.2B32.0020.0011.307B] # HIRAGANA LETTER HO
307C      ; [.2B32.0020.0011.307B][.0000.0148.0002.3099] # HIRAGANA LETTER BO
307D      ; [.2B32.0020.0011.307B][.0000.0149.0002.309A] # HIRAGANA LETTER PO
307E      ; [.2B33.0020.0011.307E] # HIRAGANA LETTER MA
307F      ; [.2B34.0020.0011.307F] # HIRAGANA LETTER MI
3080      ; [.2B35.0020.0011.3080] # HIRAGANA LETTER MU
3081      ; [.2B36.0020.0011.3081] # HIRAGANA LETTER ME
3082      ; [.2B37.0020.0011.3082] # HIRAGANA LETTER MO
3083      ; [.2B38.0020.000F.3083] # HIRAGANA LETTER SMALL YA
3084      ; [.2B38.0020.0011.3084] # HIRAGANA LETTER YA
3085      ; [.2B39.0020.000F.3085] # HIRAGANA LETTER SMALL YU
3086      ; [.2B39.0020.0011.3086] # HIRAGANA LETTER YU
3087      ; [.2B3A.0020.000F.3087] # HIRAGANA LETTER SMALL YO
3088      ; [.2B3A.0020.0011.3088] # HIRAGANA LETTER YO
3089      ; [.2B3B.0020.0011.3089] # HIRAGANA LETTER RA
308A      ; [.2B3C.0020.0011.308A] # HIRAGANA LETTER RI
308B      ; [.2B3D.0020.0011.308B] # HIRAGANA LETTER RU
308C      ; [.2B3E.0020.0011.308C] # HIRAGANA LETTER RE
308D      ; [.2B3F.0020.0011.308D] # HIRAGANA LETTER RO
308E      ; [.2B40.0020.000F.308E] # HIRAGANA LETTER SMALL WA
308F      ; [.2B40.0020.0011.308F] # HIRAGANA LETTER WA
3090      ; [.2B41.0020.0011.3090] # HIRAGANA LETTER WI
3091      ; [.2B42.0020.0011.3091] # HIRAGANA LETTER WE
3092      ; [.2B43.0020.0011.3092] # HIRAGANA LETTER WO
3093      ; [.2B44.0020.0011.3093] # HIRAGANA LETTER N
3094      ; [.2B17.0020.0011.3046][.0000.0148.0002.3099] # HIRAGANA LETTER VU
3095      ; [.2B1A.0020.000F.3095] # HIRAGANA LETTER SMALL KA
3096      ; [.2B1D.0020.000F.3096] # HIRAGANA LETTER SMALL KE
3000      ; [*020A.0020.0002.0020] # IDEOGRAPHIC SPACE
FF01      ; [*026E.0020.0002.0021] # FULLWIDTH EXCLAMATION MARK
FF02      ; [*02F5.0020.0002.0022] # FULLWIDTH QUOTATION MARK
FF03      ; [*0362.0020.0002.0023] # FULLWIDTH NUMBER SIGN
FF04      ; [.11E1.0020.0002.0024] # FULLWIDTH DOLLAR SIGN
FF05      ; [*0363.0020.0002.0025] # FULLWIDTH PERCENT SIGN
FF06      ; [*035F.0020.0002.0026] # FULLWIDTH AMPERSAND
FF07      ; [*02EE.0020.0002.0027] # FULLWIDTH APOSTROPHE
FF08      ; [*02FF.0020.0002.0028] # FULLWIDTH LEFT PARENTHESIS
FF09      ; [*0300.0020.0002.0029] # FULLWIDTH RIGHT PARENTHESIS
FF0A      ; [*0357.0020.0002.002A] # FULLWIDTH ASTERISK
FF0B      ; [*0550.0020.0002.002B] # FULLWIDTH PLUS SIGN
FF0C      ; [*0234.0020.0002.002C] # FULLWIDTH COMMA
FF0D      ; [*0223.0020.0002.002D] # FULLWIDTH HYPHEN-MINUS
FF0E      ; [*0281.0020.0002.002E] # FULLWIDTH FULL STOP
FF0F      ; [*035C.0020.0002.002F] # FULLWIDTH SOLIDUS
FF10      ; [.1205.0020.0002.0030] # FULLWIDTH DIGIT ZERO
FF11      ; [.1206.0020.0002.0031] # FULLWIDTH DIGIT ONE
FF12      ; [.1207.0020.0002.0032] # FULLWIDTH DIGIT TWO
FF13      ; [.1208.0020.0002.0033] # FULLWIDTH DIGIT THREE
FF14      ; [.1209.0020.0002.0034] # FULLWIDTH DIGIT FOUR
FF15      ; [.120A.0020.0002.0035] # FULLWIDTH DIGIT FIVE
FF16      ; [.120B.0020.0002.0036] # FULLWIDTH DIGIT SIX
FF17      ; [.120C.0020.0002.0037] # FULLWIDTH DIGIT SEVEN
FF18      ; [.120D.0020.0002.0038] # FULLWIDTH DIGIT EIGHT
FF19      ; [.120E.0020.0002.0039] # FULLWIDTH DIGIT NINE
FF1A      ; [*0247.0020.0002.003A] # FULLWIDTH COLON
FF1B      ; [*0243.0020.0002.003B] # FULLWIDTH SEMICOLON
FF1C      ; [*0554.0020.0002.003C] # FULLWIDTH LESS-THAN SIGN
FF1D      ; [*0555.0020.0002.003D] # FULLWIDTH EQUALS SIGN
FF1E      ; [*0556.0020.0002.003E] # FULLWIDTH GREATER-THAN SIGN
FF1F      ; [*0273.0020.0002.003F] # FULLWIDTH QUESTION MARK
FF20      ; [*0356.0020.0002.0040] # FULLWIDTH COMMERCIAL AT
FF21      ; [.120F.0020.0008.0041] # FULLWIDTH LATIN CAPITAL LETTER A
FF22      ; [.1225.0020.0008.0042] # FULLWIDTH LATIN CAPITAL LETTER B
FF23      ; [.123D.0020.0008.0043] # FULLWIDTH LATIN CAPITAL LETTER C
FF24      ; [.1250.0020.0008.0044] # FULLWIDTH LATIN CAPITAL LETTER D
FF25      ; [.126B.0020.0008.0045] # FULLWIDTH LATIN CAPITAL LETTER E
FF26      ; [.12A3.0020.0008.0046] # FULLWIDTH LATIN CAPITAL LETTER F
FF27      ; [.12B0.0020.0008.0047] # FULLWIDTH LATIN CAPITAL LETTER G
FF28      ; [.12D3.0020.0008.0048] # FULLWIDTH LATIN CAPITAL LETTER H
FF29      ; [.12EC.0020.0008.0049] # FULLWIDTH LATIN CAPITAL LETTER I
FF2A      ; [.1305.0020.0008.004A] # FULLWIDTH LATIN CAPITAL LETTER J
FF2B      ; [.131E.0020.0008.004B] # FULLWIDTH LATIN CAPITAL LETTER K
FF2C      ; [.1330.0020.0008.004C] # FULLWIDTH LATIN CAPITAL LETTER L
FF2D      ; [.135F.0020.0008.004D] # FULLWIDTH LATIN CAPITAL LETTER M
FF2E      ; [.136D.0020.0008.004E] # FULLWIDTH LATIN CAPITAL LETTER N
FF2F      ; [.138E.0020.0008.004F] # FULLWIDTH LATIN CAPITAL LETTER O
FF30      ; [.13B3.0020.0008.0050] # FULLWIDTH LATIN CAPITAL LETTER P
FF31      ; [.13C8.0020.0008.0051] # FULLWIDTH LATIN CAPITAL LETTER Q
FF32      ; [.13DA.0020.0008.0052] # FULLWIDTH LATIN CAPITAL LETTER R
FF33      ; [.1410.0020.0008.0053] # FULLWIDTH LATIN CAPITAL LETTER S
FF34      ; [.1433.0020.0008.0054] # FULLWIDTH LATIN CAPITAL LETTER T
FF35      ; [.1453.0020.0008.0055] # FULLWIDTH LATIN CAPITAL LETTER U
FF36      ; [.147B.0020.0008.0056] # FULLWIDTH LATIN CAPITAL LETTER V
FF37      ; [.148D.0020.0008.0057] # FULLWIDTH LATIN CAPITAL LETTER W
FF38      ; [.1497.0020.0008.0058] # FULLWIDTH LATIN CAPITAL LETTER X
FF39      ; [.149C.0020.0008.0059] # FULLWIDTH LATIN CAPITAL LETTER Y
FF3A      ; [.14AD.0020.0008.005A] # FULLWIDTH LATIN CAPITAL LETTER Z
FF3B      ; [*0301.0020.0002.005B] # FULLWIDTH LEFT SQUARE BRACKET
FF3C      ; [*02EE.0020.0002.0027] # FULLWIDTH REVERSE SOLIDUS
FF3D      ; [*0302.0020.0002.005D] # FULLWIDTH RIGHT SQUARE BRACKET
FF3E      ; [*0211.0020.0002.005E] # FULLWIDTH CIRCUMFLEX ACCENT
FF3F      ; [*021D.0020.0002.005F] # FULLWIDTH LOW LINE
FF40      ; [*020E.0020.0002.0060] # FULLWIDTH GRAVE ACCENT
FF41      ; [.120F.0020.0002.0061] # FULLWIDTH LATIN SMALL LETTER A
FF42      ; [.1225.0020.0002.0062] # FULLWIDTH LATIN SMALL LETTER B
FF43      ; [.123D.0020.0002.0063] # FULLWIDTH LATIN SMALL LETTER C
FF44      ; [.1250.0020.0002.0064] # FULLWIDTH LATIN SMALL LETTER D
FF45      ; [.126B.0020.0002.0065] # FULLWIDTH LATIN SMALL LETTER E
FF46      ; [.12A3.0020.0002.0066] # FULLWIDTH LATIN SMALL LETTER F
FF47      ; [.12B0.0020.0002.0067] # FULLWIDTH LATIN SMALL LETTER G
FF48      ; [.12D3.0020.0002.0068] # FULLWIDTH LATIN SMALL LETTER H
FF49      ; [.12EC.0020.0002.0069] # FULLWIDTH LATIN SMALL LETTER I
FF4A      ; [.1305.0020.0002.006A] # FULLWIDTH LATIN SMALL LETTER J
FF4B      ; [.131E.0020.0002.006B] # FULLWIDTH LATIN SMALL LETTER K
FF4C      ; [.1330.0020.0002.006C] # FULLWIDTH LATIN SMALL LETTER L
FF4D      ; [.135F.0020.0002.006D] # FULLWIDTH LATIN SMALL LETTER M
FF4E      ; [.136D.0020.0002.006E] # FULLWIDTH LATIN SMALL LETTER N
FF4F      ; [.138E.0020.0002.006F] # FULLWIDTH LATIN SMALL LETTER O
FF50      ; [.13B3.0020.0002.0070] # FULLWIDTH LATIN SMALL LETTER P
FF51      ; [.13C8.0020.0002.0071] # FULLWIDTH LATIN SMALL LETTER Q
FF52      ; [.13DA.0020.0002.0072] # FULLWIDTH LATIN SMALL LETTER R
FF53      ; [.1410.0020.0002.0073] # FULLWIDTH LATIN SMALL LETTER S
FF54      ; [.1433.0020.0002.0074] # FULLWIDTH LATIN SMALL LETTER T
FF55      ; [.1453.0020.0002.0075] # FULLWIDTH LATIN SMALL LETTER U
FF56      ; [.147B.0020.0002.0076] # FULLWIDTH LATIN SMALL LETTER V
FF57      ; [.148D.0020.0002.0077] # FULLWIDTH LATIN SMALL LETTER W
FF58      ; [.1497.0020.0002.0078] # FULLWIDTH LATIN SMALL LETTER X
FF59      ; [.149C.0020.0002.0079] # FULLWIDTH LATIN SMALL LETTER Y
FF5A      ; [.14AD.0020.0002.007A] # FULLWIDTH LATIN SMALL LETTER Z
FF5B      ; [*0303.0020.0002.007B] # FULLWIDTH LEFT CURLY BRACKET
FF5C      ; [*0558.0020.0002.007C] # FULLWIDTH VERTICAL LINE
FF5D      ; [*0304.0020.0002.007D] # FULLWIDTH RIGHT CURLY BRACKET
FF5E      ; [*055B.0020.0002.007E] # FULLWIDTH TILDE
FF5F      ; [*0311.0020.0002.2985] # FULLWIDTH LEFT WHITE PARENTHESIS
FF60      ; [*0312.0020.0002.2986] # FULLWIDTH RIGHT WHITE PARENTHESIS
FF61      ; [*0291.0020.0002.3002] # HALFWIDTH IDEOGRAPHIC FULL STOP
FF62      ; [*0341.0020.0002.300C] # HALFWIDTH LEFT CORNER BRACKET
FF63      ; [*0342.0020.0002.300D] # HALFWIDTH RIGHT CORNER BRACKET
FF64      ; [*0240.0020.0002.3001] # HALFWIDTH IDEOGRAPHIC COMMA
FF65      ; [*0233.0020.0002.30FB] # HALFWIDTH KATAKANA MIDDLE DOT
FF66      ; [.2B43.0020.0011.30F2] # HALFWIDTH KATAKANA LETTER WO
FF67      ; [.2B15.0020.000F.30A1] # HALFWIDTH KATAKANA LETTER SMALL A
FF68      ; [.2B16.0020.000F.30A3] # HALFWIDTH KATAKANA LETTER SMALL I
FF69      ; [.2B17.0020.000F.30A5] # HALFWIDTH KATAKANA LETTER SMALL U
FF6A      ; [.2B18.0020.000F.30A7] # HALFWIDTH KATAKANA LETTER SMALL E
FF6B      ; [.2B19.0020.000F.30A9] # HALFWIDTH KATAKANA LETTER SMALL O
FF6C      ; [.2B38.0020.000F.30E3] # HALFWIDTH KATAKANA LETTER SMALL YA
FF6D      ; [.2B39.0020.000F.30E5] # HALFWIDTH KATAKANA LETTER SMALL YU
FF6E      ; [.2B3A.0020.000F.30E7] # HALFWIDTH KATAKANA LETTER SMALL YO
FF6F      ; [.2B26.0020.000F.30C3] # HALFWIDTH KATAKANA LETTER SMALL TU
FF70      ; [.11DD.0020.0002.30FC] # HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
FF71      ; [.2B15.0020.0011.30A2] # HALFWIDTH KATAKANA LETTER A
FF72      ; [.2B16.0020.0011.30A4] # HALFWIDTH KATAKANA LETTER I
FF73      ; [.2B17.0020.0011.30A6] # HALFWIDTH KATAKANA LETTER U
FF74      ; [.2B18.0020.0011.30A8] # HALFWIDTH KATAKANA LETTER E
FF75      ; [.2B19.0020.0011.30AA] # HALFWIDTH KATAKANA LETTER O
FF76      ; [.2B1A.0020.0011.30AB] # HALFWIDTH KATAKANA LETTER KA
FF77      ; [.2B1B.0020.0011.30AD] # HALFWIDTH KATAKANA LETTER KI
FF78      ; [.2B1C.0020.0011.30AF] # HALFWIDTH KATAKANA LETTER KU
FF79      ; [.2B1D.0020.0011.30B1] # HALFWIDTH KATAKANA LETTER KE
FF7A      ; [.2B1E.0020.0011.30B3] # HALFWIDTH KATAKANA LETTER KO
FF7B      ; [.2B1F.0020.0011.30B5] # HALFWIDTH KATAKANA LETTER SA
FF7C      ; [.2B20.0020.0011.30B7] # HALFWIDTH KATAKANA LETTER SI
FF7D      ; [.2B21.0020.0011.30B9] # HALFWIDTH KATAKANA LETTER SU
FF7E      ; [.2B22.0020.0011.30BB] # HALFWIDTH KATAKANA LETTER SE
FF7F      ; [.2B23.0020.0011.30BD] # HALFWIDTH KATAKANA LETTER SO
FF80      ; [.2B24.0020.0011.30BF] # HALFWIDTH KATAKANA LETTER TA
FF81      ; [.2B25.0020.0011.30C1] # HALFWIDTH KATAKANA LETTER TI
FF82      ; [.2B26.0020.0011.30C4] # HALFWIDTH KATAKANA LETTER TU
FF83      ; [.2B27.0020.0011.30C6] # HALFWIDTH KATAKANA LETTER TE
FF84      ; [.2B28.0020.0011.30C8] # HALFWIDTH KATAKANA LETTER TO
FF85      ; [.2B29.0020.0011.30CA] # HALFWIDTH KATAKANA LETTER NA
FF86      ; [.2B2A.0020.0011.30CB] # HALFWIDTH KATAKANA LETTER NI
FF87      ; [.2B2B.0020.0011.30CC] # HALFWIDTH KATAKANA LETTER NU
FF88      ; [.2B2C.0020.0011.30CD] # HALFWIDTH KATAKANA LETTER NE
FF89      ; [.2B2D.0020.0011.30CE] # HALFWIDTH KATAKANA LETTER NO
FF8A      ; [.2B2E.0020.0011.30CF] # HALFWIDTH KATAKANA LETTER HA
FF8B      ; [.2B2F.0020.0011.30D2] # HALFWIDTH KATAKANA LETTER HI
FF8C      ; [.2B30.0020.0011.30D5] # HALFWIDTH KATAKANA LETTER HU
FF8D      ; [.2B31.0020.0011.30D8] # HALFWIDTH KATAKANA LETTER HE
FF8E      ; [.2B32.0020.0011.30DB] # HALFWIDTH KATAKANA LETTER HO
FF8F      ; [.2B33.0020.0011.30DE] # HALFWIDTH KATAKANA LETTER MA
FF90      ; [.2B34.0020.0011.30DF] # HALFWIDTH KATAKANA LETTER MI
FF91      ; [.2B35.0020.0011.30E0] # HALFWIDTH KATAKANA LETTER MU
FF92      ; [.2B36.0020.0011.30E1] # HALFWIDTH KATAKANA LETTER ME
FF93      ; [.2B37.0020.0011.30E2] # HALFWIDTH KATAKANA LETTER MO
FF94      ; [.2B38.0020.0011.30E4] # HALFWIDTH KATAKANA LETTER YA
FF95      ; [.2B39.0020.0011.30E6] # HALFWIDTH KATAKANA LETTER YU
FF96      ; [.2B3A.0020.0011.30E8] # HALFWIDTH KATAKANA LETTER YO
FF97      ; [.2B3B.0020.0011.30E9] # HALFWIDTH KATAKANA LETTER RA
FF98      ; [.2B3C.0020.0011.30EA] # HALFWIDTH KATAKANA LETTER RI
FF99      ; [.2B3D.0020.0011.30EB] # HALFWIDTH KATAKANA LETTER RU
FF9A      ; [.2B3E.0020.0011.30EC] # HALFWIDTH KATAKANA LETTER RE
FF9B      ; [.2B3F.0020.0011.30ED] # HALFWIDTH KATAKANA LETTER RO
FF9C      ; [.2B40.0020.0011.30EF] # HALFWIDTH KATAKANA LETTER WA
FF9D      ; [.2B44.0020.0011.30F3] # HALFWIDTH KATAKANA LETTER N
FF9E      ; [.0000.0148.0002.3099] # HALFWIDTH KATAKANA VOICED SOUND MARK
FF9F      ; [.0000.0149.0002.309A] # HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
FFE0      ; [.11E0.0020.0002.00A2] # FULLWIDTH CENT SIGN
FFE1      ; [.11E2.0020.0002.00A3] # FULLWIDTH POUND SIGN
FFE2      ; [*0557.0020.0002.00AC] # FULLWIDTH NOT SIGN
FFE3      ; [*020A.0020.0002.0020] # FULLWIDTH MACRON
FFE4      ; [*0559.0020.0002.00A6] # FULLWIDTH BROKEN BAR
FFE5      ; [.11E3.0020.0002.00A5] # FULLWIDTH YEN SIGN
FFE6      ; [.11F5.0020.0002.20A9] # FULLWIDTH WON SIGN
FFE8      ; [*0740.0020.0002.2502] # HALFWIDTH FORMS LIGHT VERTICAL
FFE9      ; [*04D6.0020.0002.2190] # HALFWIDTH LEFTWARDS ARROW
FFEA      ; [*04D8.0020.0002.2191] # HALFWIDTH UPWARDS ARROW
FFEB      ; [*04D7.0020.0002.2192] # HALFWIDTH RIGHTWARDS ARROW
FFEC      ; [*04D9.0020.0002.2193] # HALFWIDTH DOWNWARDS ARROW
FFED      ; [*07DE.0020.0002.25A0] # HALFWIDTH BLACK SQUARE
FFEE      ; [*0809.0020.0002.25CB] # HALFWIDTH WHITE CIRCLE
30A1 30FC ; [.2B15.0020.000F.30A1][.2B15.0020.0007.30A1] # <KATAKANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF67 30FC ; [.2B15.0020.000F.30A1][.2B15.0020.0007.30A1] # <HALFWIDTH KATAKANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF67 FF70 ; [.2B15.0020.000F.30A1][.2B15.0020.0007.30A1] # <HALFWIDTH KATAKANA LETTER SMALL A, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3041 30FC ; [.2B15.0020.000F.3041][.2B15.0020.0007.3041] # <HIRAGANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A2 30FC ; [.2B15.0020.0011.30A2][.2B15.0020.0007.30A2] # <KATAKANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF71 30FC ; [.2B15.0020.0011.30A2][.2B15.0020.0007.30A2] # <HALFWIDTH KATAKANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF71 FF70 ; [.2B15.0020.0011.30A2][.2B15.0020.0007.30A2] # <HALFWIDTH KATAKANA LETTER A, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3042 30FC ; [.2B15.0020.0011.3042][.2B15.0020.0007.3042] # <HIRAGANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AB 30FC ; [.2B1A.0020.0011.30AB][.2B15.0020.0007.30AB] # <KATAKANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 30FC ; [.2B1A.0020.0011.30AB][.2B15.0020.0007.30AB] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF70 ; [.2B1A.0020.0011.30AB][.2B15.0020.0007.30AB] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304B 30FC ; [.2B1A.0020.0011.304B][.2B15.0020.0007.304B] # <HIRAGANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AC 30FC ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B15.0020.0007.30AC] # <KATAKANA LETTER GA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AB 3099 30FC ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B15.0020.0007.30AC] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF9E 30FC ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B15.0020.0007.30AC] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF9E FF70 ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B15.0020.0007.30AC] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304C 30FC ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099][.2B15.0020.0007.304C] # <HIRAGANA LETTER GA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304B 3099 30FC ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099][.2B15.0020.0007.304C] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B5 30FC ; [.2B1F.0020.0011.30B5][.2B15.0020.0007.30B5] # <KATAKANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B 30FC ; [.2B1F.0020.0011.30B5][.2B15.0020.0007.30B5] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF70 ; [.2B1F.0020.0011.30B5][.2B15.0020.0007.30B5] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3055 30FC ; [.2B1F.0020.0011.3055][.2B15.0020.0007.3055] # <HIRAGANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B6 30FC ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B15.0020.0007.30B6] # <KATAKANA LETTER ZA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B5 3099 30FC ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B15.0020.0007.30B6] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF9E 30FC ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B15.0020.0007.30B6] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF9E FF70 ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B15.0020.0007.30B6] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3056 30FC ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099][.2B15.0020.0007.3056] # <HIRAGANA LETTER ZA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3055 3099 30FC ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099][.2B15.0020.0007.3056] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BF 30FC ; [.2B24.0020.0011.30BF][.2B15.0020.0007.30BF] # <KATAKANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 30FC ; [.2B24.0020.0011.30BF][.2B15.0020.0007.30BF] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF70 ; [.2B24.0020.0011.30BF][.2B15.0020.0007.30BF] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305F 30FC ; [.2B24.0020.0011.305F][.2B15.0020.0007.305F] # <HIRAGANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C0 30FC ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B15.0020.0007.30C0] # <KATAKANA LETTER DA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BF 3099 30FC ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B15.0020.0007.30C0] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF9E 30FC ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B15.0020.0007.30C0] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF9E FF70 ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B15.0020.0007.30C0] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3060 30FC ; [.2B24.0020.0011.305F][.0000.0148.0002.3099][.2B15.0020.0007.3060] # <HIRAGANA LETTER DA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305F 3099 30FC ; [.2B24.0020.0011.305F][.0000.0148.0002.3099][.2B15.0020.0007.3060] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CA 30FC ; [.2B29.0020.0011.30CA][.2B15.0020.0007.30CA] # <KATAKANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF85 30FC ; [.2B29.0020.0011.30CA][.2B15.0020.0007.30CA] # <HALFWIDTH KATAKANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF85 FF70 ; [.2B29.0020.0011.30CA][.2B15.0020.0007.30CA] # <HALFWIDTH KATAKANA LETTER NA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306A 30FC ; [.2B29.0020.0011.306A][.2B15.0020.0007.306A] # <HIRAGANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 30FC ; [.2B2E.0020.0011.30CF][.2B15.0020.0007.30CF] # <KATAKANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A 30FC ; [.2B2E.0020.0011.30CF][.2B15.0020.0007.30CF] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF70 ; [.2B2E.0020.0011.30CF][.2B15.0020.0007.30CF] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 30FC ; [.2B2E.0020.0011.306F][.2B15.0020.0007.306F] # <HIRAGANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D0 30FC ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B15.0020.0007.30D0] # <KATAKANA LETTER BA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 3099 30FC ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B15.0020.0007.30D0] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9E 30FC ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B15.0020.0007.30D0] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9E FF70 ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B15.0020.0007.30D0] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3070 30FC ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099][.2B15.0020.0007.3070] # <HIRAGANA LETTER BA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 3099 30FC ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099][.2B15.0020.0007.3070] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D1 30FC ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B15.0020.0007.30D1] # <KATAKANA LETTER PA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 309A 30FC ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B15.0020.0007.30D1] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9F 30FC ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B15.0020.0007.30D1] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9F FF70 ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B15.0020.0007.30D1] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3071 30FC ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A][.2B15.0020.0007.3071] # <HIRAGANA LETTER PA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 309A 30FC ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A][.2B15.0020.0007.3071] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DE 30FC ; [.2B33.0020.0011.30DE][.2B15.0020.0007.30DE] # <KATAKANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8F 30FC ; [.2B33.0020.0011.30DE][.2B15.0020.0007.30DE] # <HALFWIDTH KATAKANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8F FF70 ; [.2B33.0020.0011.30DE][.2B15.0020.0007.30DE] # <HALFWIDTH KATAKANA LETTER MA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307E 30FC ; [.2B33.0020.0011.307E][.2B15.0020.0007.307E] # <HIRAGANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E3 30FC ; [.2B38.0020.000F.30E3][.2B15.0020.0007.30E3] # <KATAKANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6C 30FC ; [.2B38.0020.000F.30E3][.2B15.0020.0007.30E3] # <HALFWIDTH KATAKANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6C FF70 ; [.2B38.0020.000F.30E3][.2B15.0020.0007.30E3] # <HALFWIDTH KATAKANA LETTER SMALL YA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3083 30FC ; [.2B38.0020.000F.3083][.2B15.0020.0007.3083] # <HIRAGANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E4 30FC ; [.2B38.0020.0011.30E4][.2B15.0020.0007.30E4] # <KATAKANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF94 30FC ; [.2B38.0020.0011.30E4][.2B15.0020.0007.30E4] # <HALFWIDTH KATAKANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF94 FF70 ; [.2B38.0020.0011.30E4][.2B15.0020.0007.30E4] # <HALFWIDTH KATAKANA LETTER YA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3084 30FC ; [.2B38.0020.0011.3084][.2B15.0020.0007.3084] # <HIRAGANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E9 30FC ; [.2B3B.0020.0011.30E9][.2B15.0020.0007.30E9] # <KATAKANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF97 30FC ; [.2B3B.0020.0011.30E9][.2B15.0020.0007.30E9] # <HALFWIDTH KATAKANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF97 FF70 ; [.2B3B.0020.0011.30E9][.2B15.0020.0007.30E9] # <HALFWIDTH KATAKANA LETTER RA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3089 30FC ; [.2B3B.0020.0011.3089][.2B15.0020.0007.3089] # <HIRAGANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EE 30FC ; [.2B40.0020.000F.30EE][.2B15.0020.0007.30EE] # <KATAKANA LETTER SMALL WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308E 30FC ; [.2B40.0020.000F.308E][.2B15.0020.0007.308E] # <HIRAGANA LETTER SMALL WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EF 30FC ; [.2B40.0020.0011.30EF][.2B15.0020.0007.30EF] # <KATAKANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C 30FC ; [.2B40.0020.0011.30EF][.2B15.0020.0007.30EF] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF70 ; [.2B40.0020.0011.30EF][.2B15.0020.0007.30EF] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308F 30FC ; [.2B40.0020.0011.308F][.2B15.0020.0007.308F] # <HIRAGANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F7 30FC ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B15.0020.0007.30F7] # <KATAKANA LETTER VA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EF 3099 30FC ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B15.0020.0007.30F7] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF9E 30FC ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B15.0020.0007.30F7] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF9E FF70 ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B15.0020.0007.30F7] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F5 30FC ; [.2B1A.0020.000F.30F5][.2B15.0020.0007.30F5] # <KATAKANA LETTER SMALL KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3095 30FC ; [.2B1A.0020.000F.3095][.2B15.0020.0007.3095] # <HIRAGANA LETTER SMALL KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F5 30FC ; [.2B2E.0020.000F.31F5][.2B15.0020.0007.31F5] # <KATAKANA LETTER SMALL HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FB 30FC ; [.2B3B.0020.000F.31FB][.2B15.0020.0007.31FB] # <KATAKANA LETTER SMALL RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A3 30FC ; [.2B16.0020.000F.30A3][.2B16.0020.0007.30A3] # <KATAKANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF68 30FC ; [.2B16.0020.000F.30A3][.2B16.0020.0007.30A3] # <HALFWIDTH KATAKANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF68 FF70 ; [.2B16.0020.000F.30A3][.2B16.0020.0007.30A3] # <HALFWIDTH KATAKANA LETTER SMALL I, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3043 30FC ; [.2B16.0020.000F.3043][.2B16.0020.0007.3043] # <HIRAGANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A4 30FC ; [.2B16.0020.0011.30A4][.2B16.0020.0007.30A4] # <KATAKANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF72 30FC ; [.2B16.0020.0011.30A4][.2B16.0020.0007.30A4] # <HALFWIDTH KATAKANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF72 FF70 ; [.2B16.0020.0011.30A4][.2B16.0020.0007.30A4] # <HALFWIDTH KATAKANA LETTER I, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3044 30FC ; [.2B16.0020.0011.3044][.2B16.0020.0007.3044] # <HIRAGANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AD 30FC ; [.2B1B.0020.0011.30AD][.2B16.0020.0007.30AD] # <KATAKANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 30FC ; [.2B1B.0020.0011.30AD][.2B16.0020.0007.30AD] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF70 ; [.2B1B.0020.0011.30AD][.2B16.0020.0007.30AD] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304D 30FC ; [.2B1B.0020.0011.304D][.2B16.0020.0007.304D] # <HIRAGANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AE 30FC ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B16.0020.0007.30AE] # <KATAKANA LETTER GI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AD 3099 30FC ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B16.0020.0007.30AE] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF9E 30FC ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B16.0020.0007.30AE] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF9E FF70 ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B16.0020.0007.30AE] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304E 30FC ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099][.2B16.0020.0007.304E] # <HIRAGANA LETTER GI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304D 3099 30FC ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099][.2B16.0020.0007.304E] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B7 30FC ; [.2B20.0020.0011.30B7][.2B16.0020.0007.30B7] # <KATAKANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C 30FC ; [.2B20.0020.0011.30B7][.2B16.0020.0007.30B7] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF70 ; [.2B20.0020.0011.30B7][.2B16.0020.0007.30B7] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3057 30FC ; [.2B20.0020.0011.3057][.2B16.0020.0007.3057] # <HIRAGANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B8 30FC ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B16.0020.0007.30B8] # <KATAKANA LETTER ZI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B7 3099 30FC ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B16.0020.0007.30B8] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF9E 30FC ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B16.0020.0007.30B8] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF9E FF70 ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B16.0020.0007.30B8] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3058 30FC ; [.2B20.0020.0011.3057][.0000.0148.0002.3099][.2B16.0020.0007.3058] # <HIRAGANA LETTER ZI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3057 3099 30FC ; [.2B20.0020.0011.3057][.0000.0148.0002.3099][.2B16.0020.0007.3058] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C1 30FC ; [.2B25.0020.0011.30C1][.2B16.0020.0007.30C1] # <KATAKANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 30FC ; [.2B25.0020.0011.30C1][.2B16.0020.0007.30C1] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF70 ; [.2B25.0020.0011.30C1][.2B16.0020.0007.30C1] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3061 30FC ; [.2B25.0020.0011.3061][.2B16.0020.0007.3061] # <HIRAGANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C2 30FC ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B16.0020.0007.30C2] # <KATAKANA LETTER DI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C1 3099 30FC ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B16.0020.0007.30C2] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF9E 30FC ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B16.0020.0007.30C2] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF9E FF70 ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B16.0020.0007.30C2] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3062 30FC ; [.2B25.0020.0011.3061][.0000.0148.0002.3099][.2B16.0020.0007.3062] # <HIRAGANA LETTER DI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3061 3099 30FC ; [.2B25.0020.0011.3061][.0000.0148.0002.3099][.2B16.0020.0007.3062] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CB 30FC ; [.2B2A.0020.0011.30CB][.2B16.0020.0007.30CB] # <KATAKANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF86 30FC ; [.2B2A.0020.0011.30CB][.2B16.0020.0007.30CB] # <HALFWIDTH KATAKANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF86 FF70 ; [.2B2A.0020.0011.30CB][.2B16.0020.0007.30CB] # <HALFWIDTH KATAKANA LETTER NI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306B 30FC ; [.2B2A.0020.0011.306B][.2B16.0020.0007.306B] # <HIRAGANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 30FC ; [.2B2F.0020.0011.30D2][.2B16.0020.0007.30D2] # <KATAKANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B 30FC ; [.2B2F.0020.0011.30D2][.2B16.0020.0007.30D2] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF70 ; [.2B2F.0020.0011.30D2][.2B16.0020.0007.30D2] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 30FC ; [.2B2F.0020.0011.3072][.2B16.0020.0007.3072] # <HIRAGANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D3 30FC ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B16.0020.0007.30D3] # <KATAKANA LETTER BI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 3099 30FC ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B16.0020.0007.30D3] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9E 30FC ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B16.0020.0007.30D3] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9E FF70 ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B16.0020.0007.30D3] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3073 30FC ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099][.2B16.0020.0007.3073] # <HIRAGANA LETTER BI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 3099 30FC ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099][.2B16.0020.0007.3073] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D4 30FC ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B16.0020.0007.30D4] # <KATAKANA LETTER PI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 309A 30FC ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B16.0020.0007.30D4] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9F 30FC ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B16.0020.0007.30D4] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9F FF70 ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B16.0020.0007.30D4] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3074 30FC ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A][.2B16.0020.0007.3074] # <HIRAGANA LETTER PI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 309A 30FC ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A][.2B16.0020.0007.3074] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DF 30FC ; [.2B34.0020.0011.30DF][.2B16.0020.0007.30DF] # <KATAKANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF90 30FC ; [.2B34.0020.0011.30DF][.2B16.0020.0007.30DF] # <HALFWIDTH KATAKANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF90 FF70 ; [.2B34.0020.0011.30DF][.2B16.0020.0007.30DF] # <HALFWIDTH KATAKANA LETTER MI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307F 30FC ; [.2B34.0020.0011.307F][.2B16.0020.0007.307F] # <HIRAGANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EA 30FC ; [.2B3C.0020.0011.30EA][.2B16.0020.0007.30EA] # <KATAKANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF98 30FC ; [.2B3C.0020.0011.30EA][.2B16.0020.0007.30EA] # <HALFWIDTH KATAKANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF98 FF70 ; [.2B3C.0020.0011.30EA][.2B16.0020.0007.30EA] # <HALFWIDTH KATAKANA LETTER RI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308A 30FC ; [.2B3C.0020.0011.308A][.2B16.0020.0007.308A] # <HIRAGANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F0 30FC ; [.2B41.0020.0011.30F0][.2B16.0020.0007.30F0] # <KATAKANA LETTER WI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3090 30FC ; [.2B41.0020.0011.3090][.2B16.0020.0007.3090] # <HIRAGANA LETTER WI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F8 30FC ; [.2B41.0020.0011.30F0][.0000.0148.0002.3099][.2B16.0020.0007.30F8] # <KATAKANA LETTER VI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F0 3099 30FC ; [.2B41.0020.0011.30F0][.0000.0148.0002.3099][.2B16.0020.0007.30F8] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F1 30FC ; [.2B20.0020.000F.31F1][.2B16.0020.0007.31F1] # <KATAKANA LETTER SMALL SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F6 30FC ; [.2B2F.0020.000F.31F6][.2B16.0020.0007.31F6] # <KATAKANA LETTER SMALL HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FC 30FC ; [.2B3C.0020.000F.31FC][.2B16.0020.0007.31FC] # <KATAKANA LETTER SMALL RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A5 30FC ; [.2B17.0020.000F.30A5][.2B17.0020.0007.30A5] # <KATAKANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF69 30FC ; [.2B17.0020.000F.30A5][.2B17.0020.0007.30A5] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF69 FF70 ; [.2B17.0020.000F.30A5][.2B17.0020.0007.30A5] # <HALFWIDTH KATAKANA LETTER SMALL U, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3045 30FC ; [.2B17.0020.000F.3045][.2B17.0020.0007.3045] # <HIRAGANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A6 30FC ; [.2B17.0020.0011.30A6][.2B17.0020.0007.30A6] # <KATAKANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 30FC ; [.2B17.0020.0011.30A6][.2B17.0020.0007.30A6] # <HALFWIDTH KATAKANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF70 ; [.2B17.0020.0011.30A6][.2B17.0020.0007.30A6] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3046 30FC ; [.2B17.0020.0011.3046][.2B17.0020.0007.3046] # <HIRAGANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AF 30FC ; [.2B1C.0020.0011.30AF][.2B17.0020.0007.30AF] # <KATAKANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 30FC ; [.2B1C.0020.0011.30AF][.2B17.0020.0007.30AF] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF70 ; [.2B1C.0020.0011.30AF][.2B17.0020.0007.30AF] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304F 30FC ; [.2B1C.0020.0011.304F][.2B17.0020.0007.304F] # <HIRAGANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B0 30FC ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B17.0020.0007.30B0] # <KATAKANA LETTER GU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AF 3099 30FC ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B17.0020.0007.30B0] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF9E 30FC ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B17.0020.0007.30B0] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF9E FF70 ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B17.0020.0007.30B0] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3050 30FC ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099][.2B17.0020.0007.3050] # <HIRAGANA LETTER GU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304F 3099 30FC ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099][.2B17.0020.0007.3050] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B9 30FC ; [.2B21.0020.0011.30B9][.2B17.0020.0007.30B9] # <KATAKANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D 30FC ; [.2B21.0020.0011.30B9][.2B17.0020.0007.30B9] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF70 ; [.2B21.0020.0011.30B9][.2B17.0020.0007.30B9] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3059 30FC ; [.2B21.0020.0011.3059][.2B17.0020.0007.3059] # <HIRAGANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BA 30FC ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B17.0020.0007.30BA] # <KATAKANA LETTER ZU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B9 3099 30FC ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B17.0020.0007.30BA] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF9E 30FC ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B17.0020.0007.30BA] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF9E FF70 ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B17.0020.0007.30BA] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305A 30FC ; [.2B21.0020.0011.3059][.0000.0148.0002.3099][.2B17.0020.0007.305A] # <HIRAGANA LETTER ZU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3059 3099 30FC ; [.2B21.0020.0011.3059][.0000.0148.0002.3099][.2B17.0020.0007.305A] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C3 30FC ; [.2B26.0020.000F.30C3][.2B17.0020.0007.30C3] # <KATAKANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6F 30FC ; [.2B26.0020.000F.30C3][.2B17.0020.0007.30C3] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6F FF70 ; [.2B26.0020.000F.30C3][.2B17.0020.0007.30C3] # <HALFWIDTH KATAKANA LETTER SMALL TU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3063 30FC ; [.2B26.0020.000F.3063][.2B17.0020.0007.3063] # <HIRAGANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C4 30FC ; [.2B26.0020.0011.30C4][.2B17.0020.0007.30C4] # <KATAKANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 30FC ; [.2B26.0020.0011.30C4][.2B17.0020.0007.30C4] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF70 ; [.2B26.0020.0011.30C4][.2B17.0020.0007.30C4] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3064 30FC ; [.2B26.0020.0011.3064][.2B17.0020.0007.3064] # <HIRAGANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C5 30FC ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B17.0020.0007.30C5] # <KATAKANA LETTER DU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C4 3099 30FC ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B17.0020.0007.30C5] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF9E 30FC ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B17.0020.0007.30C5] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF9E FF70 ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B17.0020.0007.30C5] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3065 30FC ; [.2B26.0020.0011.3064][.0000.0148.0002.3099][.2B17.0020.0007.3065] # <HIRAGANA LETTER DU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3064 3099 30FC ; [.2B26.0020.0011.3064][.0000.0148.0002.3099][.2B17.0020.0007.3065] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CC 30FC ; [.2B2B.0020.0011.30CC][.2B17.0020.0007.30CC] # <KATAKANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF87 30FC ; [.2B2B.0020.0011.30CC][.2B17.0020.0007.30CC] # <HALFWIDTH KATAKANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF87 FF70 ; [.2B2B.0020.0011.30CC][.2B17.0020.0007.30CC] # <HALFWIDTH KATAKANA LETTER NU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306C 30FC ; [.2B2B.0020.0011.306C][.2B17.0020.0007.306C] # <HIRAGANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 30FC ; [.2B30.0020.0011.30D5][.2B17.0020.0007.30D5] # <KATAKANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C 30FC ; [.2B30.0020.0011.30D5][.2B17.0020.0007.30D5] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF70 ; [.2B30.0020.0011.30D5][.2B17.0020.0007.30D5] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 30FC ; [.2B30.0020.0011.3075][.2B17.0020.0007.3075] # <HIRAGANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D6 30FC ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B17.0020.0007.30D6] # <KATAKANA LETTER BU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 3099 30FC ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B17.0020.0007.30D6] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9E 30FC ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B17.0020.0007.30D6] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9E FF70 ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B17.0020.0007.30D6] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3076 30FC ; [.2B30.0020.0011.3075][.0000.0148.0002.3099][.2B17.0020.0007.3076] # <HIRAGANA LETTER BU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 3099 30FC ; [.2B30.0020.0011.3075][.0000.0148.0002.3099][.2B17.0020.0007.3076] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D7 30FC ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B17.0020.0007.30D7] # <KATAKANA LETTER PU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 309A 30FC ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B17.0020.0007.30D7] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9F 30FC ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B17.0020.0007.30D7] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9F FF70 ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B17.0020.0007.30D7] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3077 30FC ; [.2B30.0020.0011.3075][.0000.0149.0002.309A][.2B17.0020.0007.3077] # <HIRAGANA LETTER PU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 309A 30FC ; [.2B30.0020.0011.3075][.0000.0149.0002.309A][.2B17.0020.0007.3077] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E0 30FC ; [.2B35.0020.0011.30E0][.2B17.0020.0007.30E0] # <KATAKANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF91 30FC ; [.2B35.0020.0011.30E0][.2B17.0020.0007.30E0] # <HALFWIDTH KATAKANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF91 FF70 ; [.2B35.0020.0011.30E0][.2B17.0020.0007.30E0] # <HALFWIDTH KATAKANA LETTER MU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3080 30FC ; [.2B35.0020.0011.3080][.2B17.0020.0007.3080] # <HIRAGANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E5 30FC ; [.2B39.0020.000F.30E5][.2B17.0020.0007.30E5] # <KATAKANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6D 30FC ; [.2B39.0020.000F.30E5][.2B17.0020.0007.30E5] # <HALFWIDTH KATAKANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6D FF70 ; [.2B39.0020.000F.30E5][.2B17.0020.0007.30E5] # <HALFWIDTH KATAKANA LETTER SMALL YU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3085 30FC ; [.2B39.0020.000F.3085][.2B17.0020.0007.3085] # <HIRAGANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E6 30FC ; [.2B39.0020.0011.30E6][.2B17.0020.0007.30E6] # <KATAKANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF95 30FC ; [.2B39.0020.0011.30E6][.2B17.0020.0007.30E6] # <HALFWIDTH KATAKANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF95 FF70 ; [.2B39.0020.0011.30E6][.2B17.0020.0007.30E6] # <HALFWIDTH KATAKANA LETTER YU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3086 30FC ; [.2B39.0020.0011.3086][.2B17.0020.0007.3086] # <HIRAGANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EB 30FC ; [.2B3D.0020.0011.30EB][.2B17.0020.0007.30EB] # <KATAKANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF99 30FC ; [.2B3D.0020.0011.30EB][.2B17.0020.0007.30EB] # <HALFWIDTH KATAKANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF99 FF70 ; [.2B3D.0020.0011.30EB][.2B17.0020.0007.30EB] # <HALFWIDTH KATAKANA LETTER RU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308B 30FC ; [.2B3D.0020.0011.308B][.2B17.0020.0007.308B] # <HIRAGANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F4 30FC ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0007.30F4] # <KATAKANA LETTER VU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A6 3099 30FC ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0007.30F4] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF9E 30FC ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0007.30F4] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF9E FF70 ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0007.30F4] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3094 30FC ; [.2B17.0020.0011.3046][.0000.0148.0002.3099][.2B17.0020.0007.3094] # <HIRAGANA LETTER VU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3046 3099 30FC ; [.2B17.0020.0011.3046][.0000.0148.0002.3099][.2B17.0020.0007.3094] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F0 30FC ; [.2B1C.0020.000F.31F0][.2B17.0020.0007.31F0] # <KATAKANA LETTER SMALL KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F2 30FC ; [.2B21.0020.000F.31F2][.2B17.0020.0007.31F2] # <KATAKANA LETTER SMALL SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F4 30FC ; [.2B2B.0020.000F.31F4][.2B17.0020.0007.31F4] # <KATAKANA LETTER SMALL NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F7 30FC ; [.2B30.0020.000F.31F7][.2B17.0020.0007.31F7] # <KATAKANA LETTER SMALL HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FA 30FC ; [.2B35.0020.000F.31FA][.2B17.0020.0007.31FA] # <KATAKANA LETTER SMALL MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FD 30FC ; [.2B3D.0020.000F.31FD][.2B17.0020.0007.31FD] # <KATAKANA LETTER SMALL RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A7 30FC ; [.2B18.0020.000F.30A7][.2B18.0020.0007.30A7] # <KATAKANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6A 30FC ; [.2B18.0020.000F.30A7][.2B18.0020.0007.30A7] # <HALFWIDTH KATAKANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6A FF70 ; [.2B18.0020.000F.30A7][.2B18.0020.0007.30A7] # <HALFWIDTH KATAKANA LETTER SMALL E, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3047 30FC ; [.2B18.0020.000F.3047][.2B18.0020.0007.3047] # <HIRAGANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A8 30FC ; [.2B18.0020.0011.30A8][.2B18.0020.0007.30A8] # <KATAKANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF74 30FC ; [.2B18.0020.0011.30A8][.2B18.0020.0007.30A8] # <HALFWIDTH KATAKANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF74 FF70 ; [.2B18.0020.0011.30A8][.2B18.0020.0007.30A8] # <HALFWIDTH KATAKANA LETTER E, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3048 30FC ; [.2B18.0020.0011.3048][.2B18.0020.0007.3048] # <HIRAGANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B1 30FC ; [.2B1D.0020.0011.30B1][.2B18.0020.0007.30B1] # <KATAKANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 30FC ; [.2B1D.0020.0011.30B1][.2B18.0020.0007.30B1] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF70 ; [.2B1D.0020.0011.30B1][.2B18.0020.0007.30B1] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3051 30FC ; [.2B1D.0020.0011.3051][.2B18.0020.0007.3051] # <HIRAGANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B2 30FC ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B18.0020.0007.30B2] # <KATAKANA LETTER GE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B1 3099 30FC ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B18.0020.0007.30B2] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF9E 30FC ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B18.0020.0007.30B2] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF9E FF70 ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B18.0020.0007.30B2] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3052 30FC ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099][.2B18.0020.0007.3052] # <HIRAGANA LETTER GE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3051 3099 30FC ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099][.2B18.0020.0007.3052] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BB 30FC ; [.2B22.0020.0011.30BB][.2B18.0020.0007.30BB] # <KATAKANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E 30FC ; [.2B22.0020.0011.30BB][.2B18.0020.0007.30BB] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF70 ; [.2B22.0020.0011.30BB][.2B18.0020.0007.30BB] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305B 30FC ; [.2B22.0020.0011.305B][.2B18.0020.0007.305B] # <HIRAGANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BC 30FC ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B18.0020.0007.30BC] # <KATAKANA LETTER ZE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BB 3099 30FC ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B18.0020.0007.30BC] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF9E 30FC ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B18.0020.0007.30BC] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF9E FF70 ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B18.0020.0007.30BC] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305C 30FC ; [.2B22.0020.0011.305B][.0000.0148.0002.3099][.2B18.0020.0007.305C] # <HIRAGANA LETTER ZE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305B 3099 30FC ; [.2B22.0020.0011.305B][.0000.0148.0002.3099][.2B18.0020.0007.305C] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C6 30FC ; [.2B27.0020.0011.30C6][.2B18.0020.0007.30C6] # <KATAKANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 30FC ; [.2B27.0020.0011.30C6][.2B18.0020.0007.30C6] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF70 ; [.2B27.0020.0011.30C6][.2B18.0020.0007.30C6] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3066 30FC ; [.2B27.0020.0011.3066][.2B18.0020.0007.3066] # <HIRAGANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C7 30FC ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B18.0020.0007.30C7] # <KATAKANA LETTER DE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C6 3099 30FC ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B18.0020.0007.30C7] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF9E 30FC ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B18.0020.0007.30C7] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF9E FF70 ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B18.0020.0007.30C7] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3067 30FC ; [.2B27.0020.0011.3066][.0000.0148.0002.3099][.2B18.0020.0007.3067] # <HIRAGANA LETTER DE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3066 3099 30FC ; [.2B27.0020.0011.3066][.0000.0148.0002.3099][.2B18.0020.0007.3067] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CD 30FC ; [.2B2C.0020.0011.30CD][.2B18.0020.0007.30CD] # <KATAKANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF88 30FC ; [.2B2C.0020.0011.30CD][.2B18.0020.0007.30CD] # <HALFWIDTH KATAKANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF88 FF70 ; [.2B2C.0020.0011.30CD][.2B18.0020.0007.30CD] # <HALFWIDTH KATAKANA LETTER NE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306D 30FC ; [.2B2C.0020.0011.306D][.2B18.0020.0007.306D] # <HIRAGANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 30FC ; [.2B31.0020.0011.30D8][.2B18.0020.0007.30D8] # <KATAKANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D 30FC ; [.2B31.0020.0011.30D8][.2B18.0020.0007.30D8] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF70 ; [.2B31.0020.0011.30D8][.2B18.0020.0007.30D8] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 30FC ; [.2B31.0020.0011.3078][.2B18.0020.0007.3078] # <HIRAGANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D9 30FC ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B18.0020.0007.30D9] # <KATAKANA LETTER BE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 3099 30FC ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B18.0020.0007.30D9] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9E 30FC ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B18.0020.0007.30D9] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9E FF70 ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B18.0020.0007.30D9] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3079 30FC ; [.2B31.0020.0011.3078][.0000.0148.0002.3099][.2B18.0020.0007.3079] # <HIRAGANA LETTER BE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 3099 30FC ; [.2B31.0020.0011.3078][.0000.0148.0002.3099][.2B18.0020.0007.3079] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DA 30FC ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B18.0020.0007.30DA] # <KATAKANA LETTER PE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 309A 30FC ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B18.0020.0007.30DA] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9F 30FC ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B18.0020.0007.30DA] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9F FF70 ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B18.0020.0007.30DA] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307A 30FC ; [.2B31.0020.0011.3078][.0000.0149.0002.309A][.2B18.0020.0007.307A] # <HIRAGANA LETTER PE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 309A 30FC ; [.2B31.0020.0011.3078][.0000.0149.0002.309A][.2B18.0020.0007.307A] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E1 30FC ; [.2B36.0020.0011.30E1][.2B18.0020.0007.30E1] # <KATAKANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF92 30FC ; [.2B36.0020.0011.30E1][.2B18.0020.0007.30E1] # <HALFWIDTH KATAKANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF92 FF70 ; [.2B36.0020.0011.30E1][.2B18.0020.0007.30E1] # <HALFWIDTH KATAKANA LETTER ME, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3081 30FC ; [.2B36.0020.0011.3081][.2B18.0020.0007.3081] # <HIRAGANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EC 30FC ; [.2B3E.0020.0011.30EC][.2B18.0020.0007.30EC] # <KATAKANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9A 30FC ; [.2B3E.0020.0011.30EC][.2B18.0020.0007.30EC] # <HALFWIDTH KATAKANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9A FF70 ; [.2B3E.0020.0011.30EC][.2B18.0020.0007.30EC] # <HALFWIDTH KATAKANA LETTER RE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308C 30FC ; [.2B3E.0020.0011.308C][.2B18.0020.0007.308C] # <HIRAGANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F1 30FC ; [.2B42.0020.0011.30F1][.2B18.0020.0007.30F1] # <KATAKANA LETTER WE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3091 30FC ; [.2B42.0020.0011.3091][.2B18.0020.0007.3091] # <HIRAGANA LETTER WE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F9 30FC ; [.2B42.0020.0011.30F1][.0000.0148.0002.3099][.2B18.0020.0007.30F9] # <KATAKANA LETTER VE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F1 3099 30FC ; [.2B42.0020.0011.30F1][.0000.0148.0002.3099][.2B18.0020.0007.30F9] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F6 30FC ; [.2B1D.0020.000F.30F6][.2B18.0020.0007.30F6] # <KATAKANA LETTER SMALL KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3096 30FC ; [.2B1D.0020.000F.3096][.2B18.0020.0007.3096] # <HIRAGANA LETTER SMALL KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F8 30FC ; [.2B31.0020.000F.31F8][.2B18.0020.0007.31F8] # <KATAKANA LETTER SMALL HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FE 30FC ; [.2B3E.0020.000F.31FE][.2B18.0020.0007.31FE] # <KATAKANA LETTER SMALL RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A9 30FC ; [.2B19.0020.000F.30A9][.2B19.0020.0007.30A9] # <KATAKANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6B 30FC ; [.2B19.0020.000F.30A9][.2B19.0020.0007.30A9] # <HALFWIDTH KATAKANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6B FF70 ; [.2B19.0020.000F.30A9][.2B19.0020.0007.30A9] # <HALFWIDTH KATAKANA LETTER SMALL O, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3049 30FC ; [.2B19.0020.000F.3049][.2B19.0020.0007.3049] # <HIRAGANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AA 30FC ; [.2B19.0020.0011.30AA][.2B19.0020.0007.30AA] # <KATAKANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF75 30FC ; [.2B19.0020.0011.30AA][.2B19.0020.0007.30AA] # <HALFWIDTH KATAKANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF75 FF70 ; [.2B19.0020.0011.30AA][.2B19.0020.0007.30AA] # <HALFWIDTH KATAKANA LETTER O, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304A 30FC ; [.2B19.0020.0011.304A][.2B19.0020.0007.304A] # <HIRAGANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B3 30FC ; [.2B1E.0020.0011.30B3][.2B19.0020.0007.30B3] # <KATAKANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A 30FC ; [.2B1E.0020.0011.30B3][.2B19.0020.0007.30B3] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF70 ; [.2B1E.0020.0011.30B3][.2B19.0020.0007.30B3] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3053 30FC ; [.2B1E.0020.0011.3053][.2B19.0020.0007.3053] # <HIRAGANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B4 30FC ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B19.0020.0007.30B4] # <KATAKANA LETTER GO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B3 3099 30FC ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B19.0020.0007.30B4] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF9E 30FC ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B19.0020.0007.30B4] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF9E FF70 ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B19.0020.0007.30B4] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3054 30FC ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099][.2B19.0020.0007.3054] # <HIRAGANA LETTER GO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3053 3099 30FC ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099][.2B19.0020.0007.3054] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BD 30FC ; [.2B23.0020.0011.30BD][.2B19.0020.0007.30BD] # <KATAKANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F 30FC ; [.2B23.0020.0011.30BD][.2B19.0020.0007.30BD] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF70 ; [.2B23.0020.0011.30BD][.2B19.0020.0007.30BD] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305D 30FC ; [.2B23.0020.0011.305D][.2B19.0020.0007.305D] # <HIRAGANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BE 30FC ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B19.0020.0007.30BE] # <KATAKANA LETTER ZO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BD 3099 30FC ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B19.0020.0007.30BE] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF9E 30FC ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B19.0020.0007.30BE] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF9E FF70 ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B19.0020.0007.30BE] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305E 30FC ; [.2B23.0020.0011.305D][.0000.0148.0002.3099][.2B19.0020.0007.305E] # <HIRAGANA LETTER ZO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305D 3099 30FC ; [.2B23.0020.0011.305D][.0000.0148.0002.3099][.2B19.0020.0007.305E] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C8 30FC ; [.2B28.0020.0011.30C8][.2B19.0020.0007.30C8] # <KATAKANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 30FC ; [.2B28.0020.0011.30C8][.2B19.0020.0007.30C8] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF70 ; [.2B28.0020.0011.30C8][.2B19.0020.0007.30C8] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3068 30FC ; [.2B28.0020.0011.3068][.2B19.0020.0007.3068] # <HIRAGANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C9 30FC ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B19.0020.0007.30C9] # <KATAKANA LETTER DO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C8 3099 30FC ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B19.0020.0007.30C9] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF9E 30FC ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B19.0020.0007.30C9] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF9E FF70 ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B19.0020.0007.30C9] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3069 30FC ; [.2B28.0020.0011.3068][.0000.0148.0002.3099][.2B19.0020.0007.3069] # <HIRAGANA LETTER DO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3068 3099 30FC ; [.2B28.0020.0011.3068][.0000.0148.0002.3099][.2B19.0020.0007.3069] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CE 30FC ; [.2B2D.0020.0011.30CE][.2B19.0020.0007.30CE] # <KATAKANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF89 30FC ; [.2B2D.0020.0011.30CE][.2B19.0020.0007.30CE] # <HALFWIDTH KATAKANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF89 FF70 ; [.2B2D.0020.0011.30CE][.2B19.0020.0007.30CE] # <HALFWIDTH KATAKANA LETTER NO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306E 30FC ; [.2B2D.0020.0011.306E][.2B19.0020.0007.306E] # <HIRAGANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 30FC ; [.2B32.0020.0011.30DB][.2B19.0020.0007.30DB] # <KATAKANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E 30FC ; [.2B32.0020.0011.30DB][.2B19.0020.0007.30DB] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF70 ; [.2B32.0020.0011.30DB][.2B19.0020.0007.30DB] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 30FC ; [.2B32.0020.0011.307B][.2B19.0020.0007.307B] # <HIRAGANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DC 30FC ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B19.0020.0007.30DC] # <KATAKANA LETTER BO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 3099 30FC ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B19.0020.0007.30DC] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9E 30FC ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B19.0020.0007.30DC] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9E FF70 ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B19.0020.0007.30DC] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307C 30FC ; [.2B32.0020.0011.307B][.0000.0148.0002.3099][.2B19.0020.0007.307C] # <HIRAGANA LETTER BO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 3099 30FC ; [.2B32.0020.0011.307B][.0000.0148.0002.3099][.2B19.0020.0007.307C] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DD 30FC ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B19.0020.0007.30DD] # <KATAKANA LETTER PO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 309A 30FC ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B19.0020.0007.30DD] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9F 30FC ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B19.0020.0007.30DD] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9F FF70 ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B19.0020.0007.30DD] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307D 30FC ; [.2B32.0020.0011.307B][.0000.0149.0002.309A][.2B19.0020.0007.307D] # <HIRAGANA LETTER PO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 309A 30FC ; [.2B32.0020.0011.307B][.0000.0149.0002.309A][.2B19.0020.0007.307D] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E2 30FC ; [.2B37.0020.0011.30E2][.2B19.0020.0007.30E2] # <KATAKANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF93 30FC ; [.2B37.0020.0011.30E2][.2B19.0020.0007.30E2] # <HALFWIDTH KATAKANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF93 FF70 ; [.2B37.0020.0011.30E2][.2B19.0020.0007.30E2] # <HALFWIDTH KATAKANA LETTER MO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3082 30FC ; [.2B37.0020.0011.3082][.2B19.0020.0007.3082] # <HIRAGANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E7 30FC ; [.2B3A.0020.000F.30E7][.2B19.0020.0007.30E7] # <KATAKANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6E 30FC ; [.2B3A.0020.000F.30E7][.2B19.0020.0007.30E7] # <HALFWIDTH KATAKANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6E FF70 ; [.2B3A.0020.000F.30E7][.2B19.0020.0007.30E7] # <HALFWIDTH KATAKANA LETTER SMALL YO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3087 30FC ; [.2B3A.0020.000F.3087][.2B19.0020.0007.3087] # <HIRAGANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E8 30FC ; [.2B3A.0020.0011.30E8][.2B19.0020.0007.30E8] # <KATAKANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF96 30FC ; [.2B3A.0020.0011.30E8][.2B19.0020.0007.30E8] # <HALFWIDTH KATAKANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF96 FF70 ; [.2B3A.0020.0011.30E8][.2B19.0020.0007.30E8] # <HALFWIDTH KATAKANA LETTER YO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3088 30FC ; [.2B3A.0020.0011.3088][.2B19.0020.0007.3088] # <HIRAGANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30ED 30FC ; [.2B3F.0020.0011.30ED][.2B19.0020.0007.30ED] # <KATAKANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9B 30FC ; [.2B3F.0020.0011.30ED][.2B19.0020.0007.30ED] # <HALFWIDTH KATAKANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9B FF70 ; [.2B3F.0020.0011.30ED][.2B19.0020.0007.30ED] # <HALFWIDTH KATAKANA LETTER RO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308D 30FC ; [.2B3F.0020.0011.308D][.2B19.0020.0007.308D] # <HIRAGANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F2 30FC ; [.2B43.0020.0011.30F2][.2B19.0020.0007.30F2] # <KATAKANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 30FC ; [.2B43.0020.0011.30F2][.2B19.0020.0007.30F2] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF70 ; [.2B43.0020.0011.30F2][.2B19.0020.0007.30F2] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3092 30FC ; [.2B43.0020.0011.3092][.2B19.0020.0007.3092] # <HIRAGANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30FA 30FC ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B19.0020.0007.30FA] # <KATAKANA LETTER VO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F2 3099 30FC ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B19.0020.0007.30FA] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF9E 30FC ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B19.0020.0007.30FA] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF9E FF70 ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B19.0020.0007.30FA] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F3 30FC ; [.2B28.0020.000F.31F3][.2B19.0020.0007.31F3] # <KATAKANA LETTER SMALL TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F9 30FC ; [.2B32.0020.000F.31F9][.2B19.0020.0007.31F9] # <KATAKANA LETTER SMALL HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FF 30FC ; [.2B3F.0020.000F.31FF][.2B19.0020.0007.31FF] # <KATAKANA LETTER SMALL RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A1 30FD ; [.2B15.0020.000F.30A1][.2B15.0020.0010.30A1] # <KATAKANA LETTER SMALL A, KATAKANA ITERATION MARK>
FF67 30FD ; [.2B15.0020.000F.30A1][.2B15.0020.0010.30A1] # <HALFWIDTH KATAKANA LETTER SMALL A, KATAKANA ITERATION MARK>
3041 309D ; [.2B15.0020.000F.3041][.2B15.0020.0010.3041] # <HIRAGANA LETTER SMALL A, HIRAGANA ITERATION MARK>
30A2 30FD ; [.2B15.0020.0011.30A2][.2B15.0020.0010.30A2] # <KATAKANA LETTER A, KATAKANA ITERATION MARK>
FF71 30FD ; [.2B15.0020.0011.30A2][.2B15.0020.0010.30A2] # <HALFWIDTH KATAKANA LETTER A, KATAKANA ITERATION MARK>
3042 309D ; [.2B15.0020.0011.3042][.2B15.0020.0010.3042] # <HIRAGANA LETTER A, HIRAGANA ITERATION MARK>
30A3 30FD ; [.2B16.0020.000F.30A3][.2B16.0020.0010.30A3] # <KATAKANA LETTER SMALL I, KATAKANA ITERATION MARK>
FF68 30FD ; [.2B16.0020.000F.30A3][.2B16.0020.0010.30A3] # <HALFWIDTH KATAKANA LETTER SMALL I, KATAKANA ITERATION MARK>
3043 309D ; [.2B16.0020.000F.3043][.2B16.0020.0010.3043] # <HIRAGANA LETTER SMALL I, HIRAGANA ITERATION MARK>
30A4 30FD ; [.2B16.0020.0011.30A4][.2B16.0020.0010.30A4] # <KATAKANA LETTER I, KATAKANA ITERATION MARK>
FF72 30FD ; [.2B16.0020.0011.30A4][.2B16.0020.0010.30A4] # <HALFWIDTH KATAKANA LETTER I, KATAKANA ITERATION MARK>
3044 309D ; [.2B16.0020.0011.3044][.2B16.0020.0010.3044] # <HIRAGANA LETTER I, HIRAGANA ITERATION MARK>
30A5 30FD ; [.2B17.0020.000F.30A5][.2B17.0020.0010.30A5] # <KATAKANA LETTER SMALL U, KATAKANA ITERATION MARK>
FF69 30FD ; [.2B17.0020.000F.30A5][.2B17.0020.0010.30A5] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA ITERATION MARK>
3045 309D ; [.2B17.0020.000F.3045][.2B17.0020.0010.3045] # <HIRAGANA LETTER SMALL U, HIRAGANA ITERATION MARK>
30A5 30FE ; [.2B17.0020.000F.30A5][.2B17.0020.0010.30A5][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL U, KATAKANA VOICED ITERATION MARK>
FF69 30FE ; [.2B17.0020.000F.30A5][.2B17.0020.0010.30A5][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA VOICED ITERATION MARK>
3045 309E ; [.2B17.0020.000F.3045][.2B17.0020.0010.3045][.0000.0148.0002.3099] # <HIRAGANA LETTER SMALL U, HIRAGANA VOICED ITERATION MARK>
30A6 30FD ; [.2B17.0020.0011.30A6][.2B17.0020.0010.30A6] # <KATAKANA LETTER U, KATAKANA ITERATION MARK>
FF73 30FD ; [.2B17.0020.0011.30A6][.2B17.0020.0010.30A6] # <HALFWIDTH KATAKANA LETTER U, KATAKANA ITERATION MARK>
3046 309D ; [.2B17.0020.0011.3046][.2B17.0020.0010.3046] # <HIRAGANA LETTER U, HIRAGANA ITERATION MARK>
30A6 30FE ; [.2B17.0020.0011.30A6][.2B17.0020.0010.30A6][.0000.0148.0002.3099] # <KATAKANA LETTER U, KATAKANA VOICED ITERATION MARK>
FF73 30FE ; [.2B17.0020.0011.30A6][.2B17.0020.0010.30A6][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER U, KATAKANA VOICED ITERATION MARK>
3046 309E ; [.2B17.0020.0011.3046][.2B17.0020.0010.3046][.0000.0148.0002.3099] # <HIRAGANA LETTER U, HIRAGANA VOICED ITERATION MARK>
30A7 30FD ; [.2B18.0020.000F.30A7][.2B18.0020.0010.30A7] # <KATAKANA LETTER SMALL E, KATAKANA ITERATION MARK>
FF6A 30FD ; [.2B18.0020.000F.30A7][.2B18.0020.0010.30A7] # <HALFWIDTH KATAKANA LETTER SMALL E, KATAKANA ITERATION MARK>
3047 309D ; [.2B18.0020.000F.3047][.2B18.0020.0010.3047] # <HIRAGANA LETTER SMALL E, HIRAGANA ITERATION MARK>
30A8 30FD ; [.2B18.0020.0011.30A8][.2B18.0020.0010.30A8] # <KATAKANA LETTER E, KATAKANA ITERATION MARK>
FF74 30FD ; [.2B18.0020.0011.30A8][.2B18.0020.0010.30A8] # <HALFWIDTH KATAKANA LETTER E, KATAKANA ITERATION MARK>
3048 309D ; [.2B18.0020.0011.3048][.2B18.0020.0010.3048] # <HIRAGANA LETTER E, HIRAGANA ITERATION MARK>
30A9 30FD ; [.2B19.0020.000F.30A9][.2B19.0020.0010.30A9] # <KATAKANA LETTER SMALL O, KATAKANA ITERATION MARK>
FF6B 30FD ; [.2B19.0020.000F.30A9][.2B19.0020.0010.30A9] # <HALFWIDTH KATAKANA LETTER SMALL O, KATAKANA ITERATION MARK>
3049 309D ; [.2B19.0020.000F.3049][.2B19.0020.0010.3049] # <HIRAGANA LETTER SMALL O, HIRAGANA ITERATION MARK>
30AA 30FD ; [.2B19.0020.0011.30AA][.2B19.0020.0010.30AA] # <KATAKANA LETTER O, KATAKANA ITERATION MARK>
FF75 30FD ; [.2B19.0020.0011.30AA][.2B19.0020.0010.30AA] # <HALFWIDTH KATAKANA LETTER O, KATAKANA ITERATION MARK>
304A 309D ; [.2B19.0020.0011.304A][.2B19.0020.0010.304A] # <HIRAGANA LETTER O, HIRAGANA ITERATION MARK>
30AB 30FD ; [.2B1A.0020.0011.30AB][.2B1A.0020.0010.30AB] # <KATAKANA LETTER KA, KATAKANA ITERATION MARK>
FF76 30FD ; [.2B1A.0020.0011.30AB][.2B1A.0020.0010.30AB] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA ITERATION MARK>
304B 309D ; [.2B1A.0020.0011.304B][.2B1A.0020.0010.304B] # <HIRAGANA LETTER KA, HIRAGANA ITERATION MARK>
30AB 30FE ; [.2B1A.0020.0011.30AB][.2B1A.0020.0010.30AB][.0000.0148.0002.3099] # <KATAKANA LETTER KA, KATAKANA VOICED ITERATION MARK>
FF76 30FE ; [.2B1A.0020.0011.30AB][.2B1A.0020.0010.30AB][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA VOICED ITERATION MARK>
304B 309E ; [.2B1A.0020.0011.304B][.2B1A.0020.0010.304B][.0000.0148.0002.3099] # <HIRAGANA LETTER KA, HIRAGANA VOICED ITERATION MARK>
30AC 30FD ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B1A.0020.0010.30AC] # <KATAKANA LETTER GA, KATAKANA ITERATION MARK>
30AB 3099 30FD ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B1A.0020.0010.30AC] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF76 FF9E 30FD ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B1A.0020.0010.30AC] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
304C 309D ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099][.2B1A.0020.0010.304C] # <HIRAGANA LETTER GA, HIRAGANA ITERATION MARK>
304B 3099 309D ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099][.2B1A.0020.0010.304C] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30AC 30FE ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B1A.0020.0010.30AC][.0000.0148.0002.3099] # <KATAKANA LETTER GA, KATAKANA VOICED ITERATION MARK>
30AB 3099 30FE ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B1A.0020.0010.30AC][.0000.0148.0002.3099] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF76 FF9E 30FE ; [.2B1A.0020.0011.30AB][.0000.0148.0002.3099][.2B1A.0020.0010.30AC][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
304C 309E ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099][.2B1A.0020.0010.304C][.0000.0148.0002.3099] # <HIRAGANA LETTER GA, HIRAGANA VOICED ITERATION MARK>
304B 3099 309E ; [.2B1A.0020.0011.304B][.0000.0148.0002.3099][.2B1A.0020.0010.304C][.0000.0148.0002.3099] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30AD 30FD ; [.2B1B.0020.0011.30AD][.2B1B.0020.0010.30AD] # <KATAKANA LETTER KI, KATAKANA ITERATION MARK>
FF77 30FD ; [.2B1B.0020.0011.30AD][.2B1B.0020.0010.30AD] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA ITERATION MARK>
304D 309D ; [.2B1B.0020.0011.304D][.2B1B.0020.0010.304D] # <HIRAGANA LETTER KI, HIRAGANA ITERATION MARK>
30AD 30FE ; [.2B1B.0020.0011.30AD][.2B1B.0020.0010.30AD][.0000.0148.0002.3099] # <KATAKANA LETTER KI, KATAKANA VOICED ITERATION MARK>
FF77 30FE ; [.2B1B.0020.0011.30AD][.2B1B.0020.0010.30AD][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA VOICED ITERATION MARK>
304D 309E ; [.2B1B.0020.0011.304D][.2B1B.0020.0010.304D][.0000.0148.0002.3099] # <HIRAGANA LETTER KI, HIRAGANA VOICED ITERATION MARK>
30AE 30FD ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B1B.0020.0010.30AE] # <KATAKANA LETTER GI, KATAKANA ITERATION MARK>
30AD 3099 30FD ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B1B.0020.0010.30AE] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF77 FF9E 30FD ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B1B.0020.0010.30AE] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
304E 309D ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099][.2B1B.0020.0010.304E] # <HIRAGANA LETTER GI, HIRAGANA ITERATION MARK>
304D 3099 309D ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099][.2B1B.0020.0010.304E] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30AE 30FE ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B1B.0020.0010.30AE][.0000.0148.0002.3099] # <KATAKANA LETTER GI, KATAKANA VOICED ITERATION MARK>
30AD 3099 30FE ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B1B.0020.0010.30AE][.0000.0148.0002.3099] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF77 FF9E 30FE ; [.2B1B.0020.0011.30AD][.0000.0148.0002.3099][.2B1B.0020.0010.30AE][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
304E 309E ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099][.2B1B.0020.0010.304E][.0000.0148.0002.3099] # <HIRAGANA LETTER GI, HIRAGANA VOICED ITERATION MARK>
304D 3099 309E ; [.2B1B.0020.0011.304D][.0000.0148.0002.3099][.2B1B.0020.0010.304E][.0000.0148.0002.3099] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30AF 30FD ; [.2B1C.0020.0011.30AF][.2B1C.0020.0010.30AF] # <KATAKANA LETTER KU, KATAKANA ITERATION MARK>
FF78 30FD ; [.2B1C.0020.0011.30AF][.2B1C.0020.0010.30AF] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA ITERATION MARK>
304F 309D ; [.2B1C.0020.0011.304F][.2B1C.0020.0010.304F] # <HIRAGANA LETTER KU, HIRAGANA ITERATION MARK>
30AF 30FE ; [.2B1C.0020.0011.30AF][.2B1C.0020.0010.30AF][.0000.0148.0002.3099] # <KATAKANA LETTER KU, KATAKANA VOICED ITERATION MARK>
FF78 30FE ; [.2B1C.0020.0011.30AF][.2B1C.0020.0010.30AF][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA VOICED ITERATION MARK>
304F 309E ; [.2B1C.0020.0011.304F][.2B1C.0020.0010.304F][.0000.0148.0002.3099] # <HIRAGANA LETTER KU, HIRAGANA VOICED ITERATION MARK>
30B0 30FD ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B1C.0020.0010.30B0] # <KATAKANA LETTER GU, KATAKANA ITERATION MARK>
30AF 3099 30FD ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B1C.0020.0010.30B0] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF78 FF9E 30FD ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B1C.0020.0010.30B0] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3050 309D ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099][.2B1C.0020.0010.3050] # <HIRAGANA LETTER GU, HIRAGANA ITERATION MARK>
304F 3099 309D ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099][.2B1C.0020.0010.3050] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B0 30FE ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B1C.0020.0010.30B0][.0000.0148.0002.3099] # <KATAKANA LETTER GU, KATAKANA VOICED ITERATION MARK>
30AF 3099 30FE ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B1C.0020.0010.30B0][.0000.0148.0002.3099] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF78 FF9E 30FE ; [.2B1C.0020.0011.30AF][.0000.0148.0002.3099][.2B1C.0020.0010.30B0][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3050 309E ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099][.2B1C.0020.0010.3050][.0000.0148.0002.3099] # <HIRAGANA LETTER GU, HIRAGANA VOICED ITERATION MARK>
304F 3099 309E ; [.2B1C.0020.0011.304F][.0000.0148.0002.3099][.2B1C.0020.0010.3050][.0000.0148.0002.3099] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B1 30FD ; [.2B1D.0020.0011.30B1][.2B1D.0020.0010.30B1] # <KATAKANA LETTER KE, KATAKANA ITERATION MARK>
FF79 30FD ; [.2B1D.0020.0011.30B1][.2B1D.0020.0010.30B1] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA ITERATION MARK>
3051 309D ; [.2B1D.0020.0011.3051][.2B1D.0020.0010.3051] # <HIRAGANA LETTER KE, HIRAGANA ITERATION MARK>
30B1 30FE ; [.2B1D.0020.0011.30B1][.2B1D.0020.0010.30B1][.0000.0148.0002.3099] # <KATAKANA LETTER KE, KATAKANA VOICED ITERATION MARK>
FF79 30FE ; [.2B1D.0020.0011.30B1][.2B1D.0020.0010.30B1][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA VOICED ITERATION MARK>
3051 309E ; [.2B1D.0020.0011.3051][.2B1D.0020.0010.3051][.0000.0148.0002.3099] # <HIRAGANA LETTER KE, HIRAGANA VOICED ITERATION MARK>
30B2 30FD ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B1D.0020.0010.30B2] # <KATAKANA LETTER GE, KATAKANA ITERATION MARK>
30B1 3099 30FD ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B1D.0020.0010.30B2] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF79 FF9E 30FD ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B1D.0020.0010.30B2] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3052 309D ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099][.2B1D.0020.0010.3052] # <HIRAGANA LETTER GE, HIRAGANA ITERATION MARK>
3051 3099 309D ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099][.2B1D.0020.0010.3052] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B2 30FE ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B1D.0020.0010.30B2][.0000.0148.0002.3099] # <KATAKANA LETTER GE, KATAKANA VOICED ITERATION MARK>
30B1 3099 30FE ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B1D.0020.0010.30B2][.0000.0148.0002.3099] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF79 FF9E 30FE ; [.2B1D.0020.0011.30B1][.0000.0148.0002.3099][.2B1D.0020.0010.30B2][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3052 309E ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099][.2B1D.0020.0010.3052][.0000.0148.0002.3099] # <HIRAGANA LETTER GE, HIRAGANA VOICED ITERATION MARK>
3051 3099 309E ; [.2B1D.0020.0011.3051][.0000.0148.0002.3099][.2B1D.0020.0010.3052][.0000.0148.0002.3099] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B3 30FD ; [.2B1E.0020.0011.30B3][.2B1E.0020.0010.30B3] # <KATAKANA LETTER KO, KATAKANA ITERATION MARK>
FF7A 30FD ; [.2B1E.0020.0011.30B3][.2B1E.0020.0010.30B3] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA ITERATION MARK>
3053 309D ; [.2B1E.0020.0011.3053][.2B1E.0020.0010.3053] # <HIRAGANA LETTER KO, HIRAGANA ITERATION MARK>
30B3 30FE ; [.2B1E.0020.0011.30B3][.2B1E.0020.0010.30B3][.0000.0148.0002.3099] # <KATAKANA LETTER KO, KATAKANA VOICED ITERATION MARK>
FF7A 30FE ; [.2B1E.0020.0011.30B3][.2B1E.0020.0010.30B3][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA VOICED ITERATION MARK>
3053 309E ; [.2B1E.0020.0011.3053][.2B1E.0020.0010.3053][.0000.0148.0002.3099] # <HIRAGANA LETTER KO, HIRAGANA VOICED ITERATION MARK>
30B4 30FD ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B1E.0020.0010.30B4] # <KATAKANA LETTER GO, KATAKANA ITERATION MARK>
30B3 3099 30FD ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B1E.0020.0010.30B4] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7A FF9E 30FD ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B1E.0020.0010.30B4] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3054 309D ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099][.2B1E.0020.0010.3054] # <HIRAGANA LETTER GO, HIRAGANA ITERATION MARK>
3053 3099 309D ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099][.2B1E.0020.0010.3054] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B4 30FE ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B1E.0020.0010.30B4][.0000.0148.0002.3099] # <KATAKANA LETTER GO, KATAKANA VOICED ITERATION MARK>
30B3 3099 30FE ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B1E.0020.0010.30B4][.0000.0148.0002.3099] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7A FF9E 30FE ; [.2B1E.0020.0011.30B3][.0000.0148.0002.3099][.2B1E.0020.0010.30B4][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3054 309E ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099][.2B1E.0020.0010.3054][.0000.0148.0002.3099] # <HIRAGANA LETTER GO, HIRAGANA VOICED ITERATION MARK>
3053 3099 309E ; [.2B1E.0020.0011.3053][.0000.0148.0002.3099][.2B1E.0020.0010.3054][.0000.0148.0002.3099] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B5 30FD ; [.2B1F.0020.0011.30B5][.2B1F.0020.0010.30B5] # <KATAKANA LETTER SA, KATAKANA ITERATION MARK>
FF7B 30FD ; [.2B1F.0020.0011.30B5][.2B1F.0020.0010.30B5] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA ITERATION MARK>
3055 309D ; [.2B1F.0020.0011.3055][.2B1F.0020.0010.3055] # <HIRAGANA LETTER SA, HIRAGANA ITERATION MARK>
30B5 30FE ; [.2B1F.0020.0011.30B5][.2B1F.0020.0010.30B5][.0000.0148.0002.3099] # <KATAKANA LETTER SA, KATAKANA VOICED ITERATION MARK>
FF7B 30FE ; [.2B1F.0020.0011.30B5][.2B1F.0020.0010.30B5][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA VOICED ITERATION MARK>
3055 309E ; [.2B1F.0020.0011.3055][.2B1F.0020.0010.3055][.0000.0148.0002.3099] # <HIRAGANA LETTER SA, HIRAGANA VOICED ITERATION MARK>
30B6 30FD ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B1F.0020.0010.30B6] # <KATAKANA LETTER ZA, KATAKANA ITERATION MARK>
30B5 3099 30FD ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B1F.0020.0010.30B6] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7B FF9E 30FD ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B1F.0020.0010.30B6] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3056 309D ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099][.2B1F.0020.0010.3056] # <HIRAGANA LETTER ZA, HIRAGANA ITERATION MARK>
3055 3099 309D ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099][.2B1F.0020.0010.3056] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B6 30FE ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B1F.0020.0010.30B6][.0000.0148.0002.3099] # <KATAKANA LETTER ZA, KATAKANA VOICED ITERATION MARK>
30B5 3099 30FE ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B1F.0020.0010.30B6][.0000.0148.0002.3099] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7B FF9E 30FE ; [.2B1F.0020.0011.30B5][.0000.0148.0002.3099][.2B1F.0020.0010.30B6][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3056 309E ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099][.2B1F.0020.0010.3056][.0000.0148.0002.3099] # <HIRAGANA LETTER ZA, HIRAGANA VOICED ITERATION MARK>
3055 3099 309E ; [.2B1F.0020.0011.3055][.0000.0148.0002.3099][.2B1F.0020.0010.3056][.0000.0148.0002.3099] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B7 30FD ; [.2B20.0020.0011.30B7][.2B20.0020.0010.30B7] # <KATAKANA LETTER SI, KATAKANA ITERATION MARK>
FF7C 30FD ; [.2B20.0020.0011.30B7][.2B20.0020.0010.30B7] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA ITERATION MARK>
3057 309D ; [.2B20.0020.0011.3057][.2B20.0020.0010.3057] # <HIRAGANA LETTER SI, HIRAGANA ITERATION MARK>
30B7 30FE ; [.2B20.0020.0011.30B7][.2B20.0020.0010.30B7][.0000.0148.0002.3099] # <KATAKANA LETTER SI, KATAKANA VOICED ITERATION MARK>
FF7C 30FE ; [.2B20.0020.0011.30B7][.2B20.0020.0010.30B7][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA VOICED ITERATION MARK>
3057 309E ; [.2B20.0020.0011.3057][.2B20.0020.0010.3057][.0000.0148.0002.3099] # <HIRAGANA LETTER SI, HIRAGANA VOICED ITERATION MARK>
30B8 30FD ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B20.0020.0010.30B8] # <KATAKANA LETTER ZI, KATAKANA ITERATION MARK>
30B7 3099 30FD ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B20.0020.0010.30B8] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7C FF9E 30FD ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B20.0020.0010.30B8] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3058 309D ; [.2B20.0020.0011.3057][.0000.0148.0002.3099][.2B20.0020.0010.3058] # <HIRAGANA LETTER ZI, HIRAGANA ITERATION MARK>
3057 3099 309D ; [.2B20.0020.0011.3057][.0000.0148.0002.3099][.2B20.0020.0010.3058] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B8 30FE ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B20.0020.0010.30B8][.0000.0148.0002.3099] # <KATAKANA LETTER ZI, KATAKANA VOICED ITERATION MARK>
30B7 3099 30FE ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B20.0020.0010.30B8][.0000.0148.0002.3099] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7C FF9E 30FE ; [.2B20.0020.0011.30B7][.0000.0148.0002.3099][.2B20.0020.0010.30B8][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3058 309E ; [.2B20.0020.0011.3057][.0000.0148.0002.3099][.2B20.0020.0010.3058][.0000.0148.0002.3099] # <HIRAGANA LETTER ZI, HIRAGANA VOICED ITERATION MARK>
3057 3099 309E ; [.2B20.0020.0011.3057][.0000.0148.0002.3099][.2B20.0020.0010.3058][.0000.0148.0002.3099] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B9 30FD ; [.2B21.0020.0011.30B9][.2B21.0020.0010.30B9] # <KATAKANA LETTER SU, KATAKANA ITERATION MARK>
FF7D 30FD ; [.2B21.0020.0011.30B9][.2B21.0020.0010.30B9] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA ITERATION MARK>
3059 309D ; [.2B21.0020.0011.3059][.2B21.0020.0010.3059] # <HIRAGANA LETTER SU, HIRAGANA ITERATION MARK>
30B9 30FE ; [.2B21.0020.0011.30B9][.2B21.0020.0010.30B9][.0000.0148.0002.3099] # <KATAKANA LETTER SU, KATAKANA VOICED ITERATION MARK>
FF7D 30FE ; [.2B21.0020.0011.30B9][.2B21.0020.0010.30B9][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA VOICED ITERATION MARK>
3059 309E ; [.2B21.0020.0011.3059][.2B21.0020.0010.3059][.0000.0148.0002.3099] # <HIRAGANA LETTER SU, HIRAGANA VOICED ITERATION MARK>
30BA 30FD ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B21.0020.0010.30BA] # <KATAKANA LETTER ZU, KATAKANA ITERATION MARK>
30B9 3099 30FD ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B21.0020.0010.30BA] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7D FF9E 30FD ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B21.0020.0010.30BA] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305A 309D ; [.2B21.0020.0011.3059][.0000.0148.0002.3099][.2B21.0020.0010.305A] # <HIRAGANA LETTER ZU, HIRAGANA ITERATION MARK>
3059 3099 309D ; [.2B21.0020.0011.3059][.0000.0148.0002.3099][.2B21.0020.0010.305A] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BA 30FE ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B21.0020.0010.30BA][.0000.0148.0002.3099] # <KATAKANA LETTER ZU, KATAKANA VOICED ITERATION MARK>
30B9 3099 30FE ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B21.0020.0010.30BA][.0000.0148.0002.3099] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7D FF9E 30FE ; [.2B21.0020.0011.30B9][.0000.0148.0002.3099][.2B21.0020.0010.30BA][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305A 309E ; [.2B21.0020.0011.3059][.0000.0148.0002.3099][.2B21.0020.0010.305A][.0000.0148.0002.3099] # <HIRAGANA LETTER ZU, HIRAGANA VOICED ITERATION MARK>
3059 3099 309E ; [.2B21.0020.0011.3059][.0000.0148.0002.3099][.2B21.0020.0010.305A][.0000.0148.0002.3099] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BB 30FD ; [.2B22.0020.0011.30BB][.2B22.0020.0010.30BB] # <KATAKANA LETTER SE, KATAKANA ITERATION MARK>
FF7E 30FD ; [.2B22.0020.0011.30BB][.2B22.0020.0010.30BB] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA ITERATION MARK>
305B 309D ; [.2B22.0020.0011.305B][.2B22.0020.0010.305B] # <HIRAGANA LETTER SE, HIRAGANA ITERATION MARK>
30BB 30FE ; [.2B22.0020.0011.30BB][.2B22.0020.0010.30BB][.0000.0148.0002.3099] # <KATAKANA LETTER SE, KATAKANA VOICED ITERATION MARK>
FF7E 30FE ; [.2B22.0020.0011.30BB][.2B22.0020.0010.30BB][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA VOICED ITERATION MARK>
305B 309E ; [.2B22.0020.0011.305B][.2B22.0020.0010.305B][.0000.0148.0002.3099] # <HIRAGANA LETTER SE, HIRAGANA VOICED ITERATION MARK>
30BC 30FD ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B22.0020.0010.30BC] # <KATAKANA LETTER ZE, KATAKANA ITERATION MARK>
30BB 3099 30FD ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B22.0020.0010.30BC] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7E FF9E 30FD ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B22.0020.0010.30BC] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305C 309D ; [.2B22.0020.0011.305B][.0000.0148.0002.3099][.2B22.0020.0010.305C] # <HIRAGANA LETTER ZE, HIRAGANA ITERATION MARK>
305B 3099 309D ; [.2B22.0020.0011.305B][.0000.0148.0002.3099][.2B22.0020.0010.305C] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BC 30FE ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B22.0020.0010.30BC][.0000.0148.0002.3099] # <KATAKANA LETTER ZE, KATAKANA VOICED ITERATION MARK>
30BB 3099 30FE ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B22.0020.0010.30BC][.0000.0148.0002.3099] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7E FF9E 30FE ; [.2B22.0020.0011.30BB][.0000.0148.0002.3099][.2B22.0020.0010.30BC][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305C 309E ; [.2B22.0020.0011.305B][.0000.0148.0002.3099][.2B22.0020.0010.305C][.0000.0148.0002.3099] # <HIRAGANA LETTER ZE, HIRAGANA VOICED ITERATION MARK>
305B 3099 309E ; [.2B22.0020.0011.305B][.0000.0148.0002.3099][.2B22.0020.0010.305C][.0000.0148.0002.3099] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BD 30FD ; [.2B23.0020.0011.30BD][.2B23.0020.0010.30BD] # <KATAKANA LETTER SO, KATAKANA ITERATION MARK>
FF7F 30FD ; [.2B23.0020.0011.30BD][.2B23.0020.0010.30BD] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA ITERATION MARK>
305D 309D ; [.2B23.0020.0011.305D][.2B23.0020.0010.305D] # <HIRAGANA LETTER SO, HIRAGANA ITERATION MARK>
30BD 30FE ; [.2B23.0020.0011.30BD][.2B23.0020.0010.30BD][.0000.0148.0002.3099] # <KATAKANA LETTER SO, KATAKANA VOICED ITERATION MARK>
FF7F 30FE ; [.2B23.0020.0011.30BD][.2B23.0020.0010.30BD][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA VOICED ITERATION MARK>
305D 309E ; [.2B23.0020.0011.305D][.2B23.0020.0010.305D][.0000.0148.0002.3099] # <HIRAGANA LETTER SO, HIRAGANA VOICED ITERATION MARK>
30BE 30FD ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B23.0020.0010.30BE] # <KATAKANA LETTER ZO, KATAKANA ITERATION MARK>
30BD 3099 30FD ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B23.0020.0010.30BE] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7F FF9E 30FD ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B23.0020.0010.30BE] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305E 309D ; [.2B23.0020.0011.305D][.0000.0148.0002.3099][.2B23.0020.0010.305E] # <HIRAGANA LETTER ZO, HIRAGANA ITERATION MARK>
305D 3099 309D ; [.2B23.0020.0011.305D][.0000.0148.0002.3099][.2B23.0020.0010.305E] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BE 30FE ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B23.0020.0010.30BE][.0000.0148.0002.3099] # <KATAKANA LETTER ZO, KATAKANA VOICED ITERATION MARK>
30BD 3099 30FE ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B23.0020.0010.30BE][.0000.0148.0002.3099] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7F FF9E 30FE ; [.2B23.0020.0011.30BD][.0000.0148.0002.3099][.2B23.0020.0010.30BE][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305E 309E ; [.2B23.0020.0011.305D][.0000.0148.0002.3099][.2B23.0020.0010.305E][.0000.0148.0002.3099] # <HIRAGANA LETTER ZO, HIRAGANA VOICED ITERATION MARK>
305D 3099 309E ; [.2B23.0020.0011.305D][.0000.0148.0002.3099][.2B23.0020.0010.305E][.0000.0148.0002.3099] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BF 30FD ; [.2B24.0020.0011.30BF][.2B24.0020.0010.30BF] # <KATAKANA LETTER TA, KATAKANA ITERATION MARK>
FF80 30FD ; [.2B24.0020.0011.30BF][.2B24.0020.0010.30BF] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA ITERATION MARK>
305F 309D ; [.2B24.0020.0011.305F][.2B24.0020.0010.305F] # <HIRAGANA LETTER TA, HIRAGANA ITERATION MARK>
30BF 30FE ; [.2B24.0020.0011.30BF][.2B24.0020.0010.30BF][.0000.0148.0002.3099] # <KATAKANA LETTER TA, KATAKANA VOICED ITERATION MARK>
FF80 30FE ; [.2B24.0020.0011.30BF][.2B24.0020.0010.30BF][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA VOICED ITERATION MARK>
305F 309E ; [.2B24.0020.0011.305F][.2B24.0020.0010.305F][.0000.0148.0002.3099] # <HIRAGANA LETTER TA, HIRAGANA VOICED ITERATION MARK>
30C0 30FD ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B24.0020.0010.30C0] # <KATAKANA LETTER DA, KATAKANA ITERATION MARK>
30BF 3099 30FD ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B24.0020.0010.30C0] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF80 FF9E 30FD ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B24.0020.0010.30C0] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3060 309D ; [.2B24.0020.0011.305F][.0000.0148.0002.3099][.2B24.0020.0010.3060] # <HIRAGANA LETTER DA, HIRAGANA ITERATION MARK>
305F 3099 309D ; [.2B24.0020.0011.305F][.0000.0148.0002.3099][.2B24.0020.0010.3060] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C0 30FE ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B24.0020.0010.30C0][.0000.0148.0002.3099] # <KATAKANA LETTER DA, KATAKANA VOICED ITERATION MARK>
30BF 3099 30FE ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B24.0020.0010.30C0][.0000.0148.0002.3099] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF80 FF9E 30FE ; [.2B24.0020.0011.30BF][.0000.0148.0002.3099][.2B24.0020.0010.30C0][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3060 309E ; [.2B24.0020.0011.305F][.0000.0148.0002.3099][.2B24.0020.0010.3060][.0000.0148.0002.3099] # <HIRAGANA LETTER DA, HIRAGANA VOICED ITERATION MARK>
305F 3099 309E ; [.2B24.0020.0011.305F][.0000.0148.0002.3099][.2B24.0020.0010.3060][.0000.0148.0002.3099] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C1 30FD ; [.2B25.0020.0011.30C1][.2B25.0020.0010.30C1] # <KATAKANA LETTER TI, KATAKANA ITERATION MARK>
FF81 30FD ; [.2B25.0020.0011.30C1][.2B25.0020.0010.30C1] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA ITERATION MARK>
3061 309D ; [.2B25.0020.0011.3061][.2B25.0020.0010.3061] # <HIRAGANA LETTER TI, HIRAGANA ITERATION MARK>
30C1 30FE ; [.2B25.0020.0011.30C1][.2B25.0020.0010.30C1][.0000.0148.0002.3099] # <KATAKANA LETTER TI, KATAKANA VOICED ITERATION MARK>
FF81 30FE ; [.2B25.0020.0011.30C1][.2B25.0020.0010.30C1][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA VOICED ITERATION MARK>
3061 309E ; [.2B25.0020.0011.3061][.2B25.0020.0010.3061][.0000.0148.0002.3099] # <HIRAGANA LETTER TI, HIRAGANA VOICED ITERATION MARK>
30C2 30FD ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B25.0020.0010.30C2] # <KATAKANA LETTER DI, KATAKANA ITERATION MARK>
30C1 3099 30FD ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B25.0020.0010.30C2] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF81 FF9E 30FD ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B25.0020.0010.30C2] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3062 309D ; [.2B25.0020.0011.3061][.0000.0148.0002.3099][.2B25.0020.0010.3062] # <HIRAGANA LETTER DI, HIRAGANA ITERATION MARK>
3061 3099 309D ; [.2B25.0020.0011.3061][.0000.0148.0002.3099][.2B25.0020.0010.3062] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C2 30FE ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B25.0020.0010.30C2][.0000.0148.0002.3099] # <KATAKANA LETTER DI, KATAKANA VOICED ITERATION MARK>
30C1 3099 30FE ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B25.0020.0010.30C2][.0000.0148.0002.3099] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF81 FF9E 30FE ; [.2B25.0020.0011.30C1][.0000.0148.0002.3099][.2B25.0020.0010.30C2][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3062 309E ; [.2B25.0020.0011.3061][.0000.0148.0002.3099][.2B25.0020.0010.3062][.0000.0148.0002.3099] # <HIRAGANA LETTER DI, HIRAGANA VOICED ITERATION MARK>
3061 3099 309E ; [.2B25.0020.0011.3061][.0000.0148.0002.3099][.2B25.0020.0010.3062][.0000.0148.0002.3099] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C3 30FD ; [.2B26.0020.000F.30C3][.2B26.0020.0010.30C3] # <KATAKANA LETTER SMALL TU, KATAKANA ITERATION MARK>
FF6F 30FD ; [.2B26.0020.000F.30C3][.2B26.0020.0010.30C3] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA ITERATION MARK>
3063 309D ; [.2B26.0020.000F.3063][.2B26.0020.0010.3063] # <HIRAGANA LETTER SMALL TU, HIRAGANA ITERATION MARK>
30C3 30FE ; [.2B26.0020.000F.30C3][.2B26.0020.0010.30C3][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL TU, KATAKANA VOICED ITERATION MARK>
FF6F 30FE ; [.2B26.0020.000F.30C3][.2B26.0020.0010.30C3][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA VOICED ITERATION MARK>
3063 309E ; [.2B26.0020.000F.3063][.2B26.0020.0010.3063][.0000.0148.0002.3099] # <HIRAGANA LETTER SMALL TU, HIRAGANA VOICED ITERATION MARK>
30C4 30FD ; [.2B26.0020.0011.30C4][.2B26.0020.0010.30C4] # <KATAKANA LETTER TU, KATAKANA ITERATION MARK>
FF82 30FD ; [.2B26.0020.0011.30C4][.2B26.0020.0010.30C4] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA ITERATION MARK>
3064 309D ; [.2B26.0020.0011.3064][.2B26.0020.0010.3064] # <HIRAGANA LETTER TU, HIRAGANA ITERATION MARK>
30C4 30FE ; [.2B26.0020.0011.30C4][.2B26.0020.0010.30C4][.0000.0148.0002.3099] # <KATAKANA LETTER TU, KATAKANA VOICED ITERATION MARK>
FF82 30FE ; [.2B26.0020.0011.30C4][.2B26.0020.0010.30C4][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA VOICED ITERATION MARK>
3064 309E ; [.2B26.0020.0011.3064][.2B26.0020.0010.3064][.0000.0148.0002.3099] # <HIRAGANA LETTER TU, HIRAGANA VOICED ITERATION MARK>
30C5 30FD ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B26.0020.0010.30C5] # <KATAKANA LETTER DU, KATAKANA ITERATION MARK>
30C4 3099 30FD ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B26.0020.0010.30C5] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF82 FF9E 30FD ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B26.0020.0010.30C5] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3065 309D ; [.2B26.0020.0011.3064][.0000.0148.0002.3099][.2B26.0020.0010.3065] # <HIRAGANA LETTER DU, HIRAGANA ITERATION MARK>
3064 3099 309D ; [.2B26.0020.0011.3064][.0000.0148.0002.3099][.2B26.0020.0010.3065] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C5 30FE ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B26.0020.0010.30C5][.0000.0148.0002.3099] # <KATAKANA LETTER DU, KATAKANA VOICED ITERATION MARK>
30C4 3099 30FE ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B26.0020.0010.30C5][.0000.0148.0002.3099] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF82 FF9E 30FE ; [.2B26.0020.0011.30C4][.0000.0148.0002.3099][.2B26.0020.0010.30C5][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3065 309E ; [.2B26.0020.0011.3064][.0000.0148.0002.3099][.2B26.0020.0010.3065][.0000.0148.0002.3099] # <HIRAGANA LETTER DU, HIRAGANA VOICED ITERATION MARK>
3064 3099 309E ; [.2B26.0020.0011.3064][.0000.0148.0002.3099][.2B26.0020.0010.3065][.0000.0148.0002.3099] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C6 30FD ; [.2B27.0020.0011.30C6][.2B27.0020.0010.30C6] # <KATAKANA LETTER TE, KATAKANA ITERATION MARK>
FF83 30FD ; [.2B27.0020.0011.30C6][.2B27.0020.0010.30C6] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA ITERATION MARK>
3066 309D ; [.2B27.0020.0011.3066][.2B27.0020.0010.3066] # <HIRAGANA LETTER TE, HIRAGANA ITERATION MARK>
30C6 30FE ; [.2B27.0020.0011.30C6][.2B27.0020.0010.30C6][.0000.0148.0002.3099] # <KATAKANA LETTER TE, KATAKANA VOICED ITERATION MARK>
FF83 30FE ; [.2B27.0020.0011.30C6][.2B27.0020.0010.30C6][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA VOICED ITERATION MARK>
3066 309E ; [.2B27.0020.0011.3066][.2B27.0020.0010.3066][.0000.0148.0002.3099] # <HIRAGANA LETTER TE, HIRAGANA VOICED ITERATION MARK>
30C7 30FD ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B27.0020.0010.30C7] # <KATAKANA LETTER DE, KATAKANA ITERATION MARK>
30C6 3099 30FD ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B27.0020.0010.30C7] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF83 FF9E 30FD ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B27.0020.0010.30C7] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3067 309D ; [.2B27.0020.0011.3066][.0000.0148.0002.3099][.2B27.0020.0010.3067] # <HIRAGANA LETTER DE, HIRAGANA ITERATION MARK>
3066 3099 309D ; [.2B27.0020.0011.3066][.0000.0148.0002.3099][.2B27.0020.0010.3067] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C7 30FE ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B27.0020.0010.30C7][.0000.0148.0002.3099] # <KATAKANA LETTER DE, KATAKANA VOICED ITERATION MARK>
30C6 3099 30FE ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B27.0020.0010.30C7][.0000.0148.0002.3099] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF83 FF9E 30FE ; [.2B27.0020.0011.30C6][.0000.0148.0002.3099][.2B27.0020.0010.30C7][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3067 309E ; [.2B27.0020.0011.3066][.0000.0148.0002.3099][.2B27.0020.0010.3067][.0000.0148.0002.3099] # <HIRAGANA LETTER DE, HIRAGANA VOICED ITERATION MARK>
3066 3099 309E ; [.2B27.0020.0011.3066][.0000.0148.0002.3099][.2B27.0020.0010.3067][.0000.0148.0002.3099] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C8 30FD ; [.2B28.0020.0011.30C8][.2B28.0020.0010.30C8] # <KATAKANA LETTER TO, KATAKANA ITERATION MARK>
FF84 30FD ; [.2B28.0020.0011.30C8][.2B28.0020.0010.30C8] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA ITERATION MARK>
3068 309D ; [.2B28.0020.0011.3068][.2B28.0020.0010.3068] # <HIRAGANA LETTER TO, HIRAGANA ITERATION MARK>
30C8 30FE ; [.2B28.0020.0011.30C8][.2B28.0020.0010.30C8][.0000.0148.0002.3099] # <KATAKANA LETTER TO, KATAKANA VOICED ITERATION MARK>
FF84 30FE ; [.2B28.0020.0011.30C8][.2B28.0020.0010.30C8][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA VOICED ITERATION MARK>
3068 309E ; [.2B28.0020.0011.3068][.2B28.0020.0010.3068][.0000.0148.0002.3099] # <HIRAGANA LETTER TO, HIRAGANA VOICED ITERATION MARK>
30C9 30FD ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B28.0020.0010.30C9] # <KATAKANA LETTER DO, KATAKANA ITERATION MARK>
30C8 3099 30FD ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B28.0020.0010.30C9] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF84 FF9E 30FD ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B28.0020.0010.30C9] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3069 309D ; [.2B28.0020.0011.3068][.0000.0148.0002.3099][.2B28.0020.0010.3069] # <HIRAGANA LETTER DO, HIRAGANA ITERATION MARK>
3068 3099 309D ; [.2B28.0020.0011.3068][.0000.0148.0002.3099][.2B28.0020.0010.3069] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C9 30FE ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B28.0020.0010.30C9][.0000.0148.0002.3099] # <KATAKANA LETTER DO, KATAKANA VOICED ITERATION MARK>
30C8 3099 30FE ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B28.0020.0010.30C9][.0000.0148.0002.3099] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF84 FF9E 30FE ; [.2B28.0020.0011.30C8][.0000.0148.0002.3099][.2B28.0020.0010.30C9][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3069 309E ; [.2B28.0020.0011.3068][.0000.0148.0002.3099][.2B28.0020.0010.3069][.0000.0148.0002.3099] # <HIRAGANA LETTER DO, HIRAGANA VOICED ITERATION MARK>
3068 3099 309E ; [.2B28.0020.0011.3068][.0000.0148.0002.3099][.2B28.0020.0010.3069][.0000.0148.0002.3099] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30CA 30FD ; [.2B29.0020.0011.30CA][.2B29.0020.0010.30CA] # <KATAKANA LETTER NA, KATAKANA ITERATION MARK>
FF85 30FD ; [.2B29.0020.0011.30CA][.2B29.0020.0010.30CA] # <HALFWIDTH KATAKANA LETTER NA, KATAKANA ITERATION MARK>
306A 309D ; [.2B29.0020.0011.306A][.2B29.0020.0010.306A] # <HIRAGANA LETTER NA, HIRAGANA ITERATION MARK>
30CB 30FD ; [.2B2A.0020.0011.30CB][.2B2A.0020.0010.30CB] # <KATAKANA LETTER NI, KATAKANA ITERATION MARK>
FF86 30FD ; [.2B2A.0020.0011.30CB][.2B2A.0020.0010.30CB] # <HALFWIDTH KATAKANA LETTER NI, KATAKANA ITERATION MARK>
306B 309D ; [.2B2A.0020.0011.306B][.2B2A.0020.0010.306B] # <HIRAGANA LETTER NI, HIRAGANA ITERATION MARK>
30CC 30FD ; [.2B2B.0020.0011.30CC][.2B2B.0020.0010.30CC] # <KATAKANA LETTER NU, KATAKANA ITERATION MARK>
FF87 30FD ; [.2B2B.0020.0011.30CC][.2B2B.0020.0010.30CC] # <HALFWIDTH KATAKANA LETTER NU, KATAKANA ITERATION MARK>
306C 309D ; [.2B2B.0020.0011.306C][.2B2B.0020.0010.306C] # <HIRAGANA LETTER NU, HIRAGANA ITERATION MARK>
30CD 30FD ; [.2B2C.0020.0011.30CD][.2B2C.0020.0010.30CD] # <KATAKANA LETTER NE, KATAKANA ITERATION MARK>
FF88 30FD ; [.2B2C.0020.0011.30CD][.2B2C.0020.0010.30CD] # <HALFWIDTH KATAKANA LETTER NE, KATAKANA ITERATION MARK>
306D 309D ; [.2B2C.0020.0011.306D][.2B2C.0020.0010.306D] # <HIRAGANA LETTER NE, HIRAGANA ITERATION MARK>
30CE 30FD ; [.2B2D.0020.0011.30CE][.2B2D.0020.0010.30CE] # <KATAKANA LETTER NO, KATAKANA ITERATION MARK>
FF89 30FD ; [.2B2D.0020.0011.30CE][.2B2D.0020.0010.30CE] # <HALFWIDTH KATAKANA LETTER NO, KATAKANA ITERATION MARK>
306E 309D ; [.2B2D.0020.0011.306E][.2B2D.0020.0010.306E] # <HIRAGANA LETTER NO, HIRAGANA ITERATION MARK>
30CF 30FD ; [.2B2E.0020.0011.30CF][.2B2E.0020.0010.30CF] # <KATAKANA LETTER HA, KATAKANA ITERATION MARK>
FF8A 30FD ; [.2B2E.0020.0011.30CF][.2B2E.0020.0010.30CF] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA ITERATION MARK>
306F 309D ; [.2B2E.0020.0011.306F][.2B2E.0020.0010.306F] # <HIRAGANA LETTER HA, HIRAGANA ITERATION MARK>
30CF 30FE ; [.2B2E.0020.0011.30CF][.2B2E.0020.0010.30CF][.0000.0148.0002.3099] # <KATAKANA LETTER HA, KATAKANA VOICED ITERATION MARK>
FF8A 30FE ; [.2B2E.0020.0011.30CF][.2B2E.0020.0010.30CF][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA VOICED ITERATION MARK>
306F 309E ; [.2B2E.0020.0011.306F][.2B2E.0020.0010.306F][.0000.0148.0002.3099] # <HIRAGANA LETTER HA, HIRAGANA VOICED ITERATION MARK>
30D0 30FD ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B2E.0020.0010.30D0] # <KATAKANA LETTER BA, KATAKANA ITERATION MARK>
30CF 3099 30FD ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B2E.0020.0010.30D0] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8A FF9E 30FD ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B2E.0020.0010.30D0] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3070 309D ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099][.2B2E.0020.0010.3070] # <HIRAGANA LETTER BA, HIRAGANA ITERATION MARK>
306F 3099 309D ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099][.2B2E.0020.0010.3070] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D0 30FE ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B2E.0020.0010.30D0][.0000.0148.0002.3099] # <KATAKANA LETTER BA, KATAKANA VOICED ITERATION MARK>
30CF 3099 30FE ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B2E.0020.0010.30D0][.0000.0148.0002.3099] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8A FF9E 30FE ; [.2B2E.0020.0011.30CF][.0000.0148.0002.3099][.2B2E.0020.0010.30D0][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3070 309E ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099][.2B2E.0020.0010.3070][.0000.0148.0002.3099] # <HIRAGANA LETTER BA, HIRAGANA VOICED ITERATION MARK>
306F 3099 309E ; [.2B2E.0020.0011.306F][.0000.0148.0002.3099][.2B2E.0020.0010.3070][.0000.0148.0002.3099] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D1 30FD ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B2E.0020.0010.30D1] # <KATAKANA LETTER PA, KATAKANA ITERATION MARK>
30CF 309A 30FD ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B2E.0020.0010.30D1] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8A FF9F 30FD ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B2E.0020.0010.30D1] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3071 309D ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A][.2B2E.0020.0010.3071] # <HIRAGANA LETTER PA, HIRAGANA ITERATION MARK>
306F 309A 309D ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A][.2B2E.0020.0010.3071] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D1 30FE ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B2E.0020.0010.30D1][.0000.0148.0002.3099] # <KATAKANA LETTER PA, KATAKANA VOICED ITERATION MARK>
30CF 309A 30FE ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B2E.0020.0010.30D1][.0000.0148.0002.3099] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8A FF9F 30FE ; [.2B2E.0020.0011.30CF][.0000.0149.0002.309A][.2B2E.0020.0010.30D1][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3071 309E ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A][.2B2E.0020.0010.3071][.0000.0148.0002.3099] # <HIRAGANA LETTER PA, HIRAGANA VOICED ITERATION MARK>
306F 309A 309E ; [.2B2E.0020.0011.306F][.0000.0149.0002.309A][.2B2E.0020.0010.3071][.0000.0148.0002.3099] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D2 30FD ; [.2B2F.0020.0011.30D2][.2B2F.0020.0010.30D2] # <KATAKANA LETTER HI, KATAKANA ITERATION MARK>
FF8B 30FD ; [.2B2F.0020.0011.30D2][.2B2F.0020.0010.30D2] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA ITERATION MARK>
3072 309D ; [.2B2F.0020.0011.3072][.2B2F.0020.0010.3072] # <HIRAGANA LETTER HI, HIRAGANA ITERATION MARK>
30D2 30FE ; [.2B2F.0020.0011.30D2][.2B2F.0020.0010.30D2][.0000.0148.0002.3099] # <KATAKANA LETTER HI, KATAKANA VOICED ITERATION MARK>
FF8B 30FE ; [.2B2F.0020.0011.30D2][.2B2F.0020.0010.30D2][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA VOICED ITERATION MARK>
3072 309E ; [.2B2F.0020.0011.3072][.2B2F.0020.0010.3072][.0000.0148.0002.3099] # <HIRAGANA LETTER HI, HIRAGANA VOICED ITERATION MARK>
30D3 30FD ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B2F.0020.0010.30D3] # <KATAKANA LETTER BI, KATAKANA ITERATION MARK>
30D2 3099 30FD ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B2F.0020.0010.30D3] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8B FF9E 30FD ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B2F.0020.0010.30D3] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3073 309D ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099][.2B2F.0020.0010.3073] # <HIRAGANA LETTER BI, HIRAGANA ITERATION MARK>
3072 3099 309D ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099][.2B2F.0020.0010.3073] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D3 30FE ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B2F.0020.0010.30D3][.0000.0148.0002.3099] # <KATAKANA LETTER BI, KATAKANA VOICED ITERATION MARK>
30D2 3099 30FE ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B2F.0020.0010.30D3][.0000.0148.0002.3099] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8B FF9E 30FE ; [.2B2F.0020.0011.30D2][.0000.0148.0002.3099][.2B2F.0020.0010.30D3][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3073 309E ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099][.2B2F.0020.0010.3073][.0000.0148.0002.3099] # <HIRAGANA LETTER BI, HIRAGANA VOICED ITERATION MARK>
3072 3099 309E ; [.2B2F.0020.0011.3072][.0000.0148.0002.3099][.2B2F.0020.0010.3073][.0000.0148.0002.3099] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D4 30FD ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B2F.0020.0010.30D4] # <KATAKANA LETTER PI, KATAKANA ITERATION MARK>
30D2 309A 30FD ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B2F.0020.0010.30D4] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8B FF9F 30FD ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B2F.0020.0010.30D4] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3074 309D ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A][.2B2F.0020.0010.3074] # <HIRAGANA LETTER PI, HIRAGANA ITERATION MARK>
3072 309A 309D ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A][.2B2F.0020.0010.3074] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D4 30FE ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B2F.0020.0010.30D4][.0000.0148.0002.3099] # <KATAKANA LETTER PI, KATAKANA VOICED ITERATION MARK>
30D2 309A 30FE ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B2F.0020.0010.30D4][.0000.0148.0002.3099] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8B FF9F 30FE ; [.2B2F.0020.0011.30D2][.0000.0149.0002.309A][.2B2F.0020.0010.30D4][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3074 309E ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A][.2B2F.0020.0010.3074][.0000.0148.0002.3099] # <HIRAGANA LETTER PI, HIRAGANA VOICED ITERATION MARK>
3072 309A 309E ; [.2B2F.0020.0011.3072][.0000.0149.0002.309A][.2B2F.0020.0010.3074][.0000.0148.0002.3099] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D5 30FD ; [.2B30.0020.0011.30D5][.2B30.0020.0010.30D5] # <KATAKANA LETTER HU, KATAKANA ITERATION MARK>
FF8C 30FD ; [.2B30.0020.0011.30D5][.2B30.0020.0010.30D5] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA ITERATION MARK>
3075 309D ; [.2B30.0020.0011.3075][.2B30.0020.0010.3075] # <HIRAGANA LETTER HU, HIRAGANA ITERATION MARK>
30D5 30FE ; [.2B30.0020.0011.30D5][.2B30.0020.0010.30D5][.0000.0148.0002.3099] # <KATAKANA LETTER HU, KATAKANA VOICED ITERATION MARK>
FF8C 30FE ; [.2B30.0020.0011.30D5][.2B30.0020.0010.30D5][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA VOICED ITERATION MARK>
3075 309E ; [.2B30.0020.0011.3075][.2B30.0020.0010.3075][.0000.0148.0002.3099] # <HIRAGANA LETTER HU, HIRAGANA VOICED ITERATION MARK>
30D6 30FD ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B30.0020.0010.30D6] # <KATAKANA LETTER BU, KATAKANA ITERATION MARK>
30D5 3099 30FD ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B30.0020.0010.30D6] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8C FF9E 30FD ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B30.0020.0010.30D6] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3076 309D ; [.2B30.0020.0011.3075][.0000.0148.0002.3099][.2B30.0020.0010.3076] # <HIRAGANA LETTER BU, HIRAGANA ITERATION MARK>
3075 3099 309D ; [.2B30.0020.0011.3075][.0000.0148.0002.3099][.2B30.0020.0010.3076] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D6 30FE ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B30.0020.0010.30D6][.0000.0148.0002.3099] # <KATAKANA LETTER BU, KATAKANA VOICED ITERATION MARK>
30D5 3099 30FE ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B30.0020.0010.30D6][.0000.0148.0002.3099] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8C FF9E 30FE ; [.2B30.0020.0011.30D5][.0000.0148.0002.3099][.2B30.0020.0010.30D6][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3076 309E ; [.2B30.0020.0011.3075][.0000.0148.0002.3099][.2B30.0020.0010.3076][.0000.0148.0002.3099] # <HIRAGANA LETTER BU, HIRAGANA VOICED ITERATION MARK>
3075 3099 309E ; [.2B30.0020.0011.3075][.0000.0148.0002.3099][.2B30.0020.0010.3076][.0000.0148.0002.3099] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D7 30FD ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B30.0020.0010.30D7] # <KATAKANA LETTER PU, KATAKANA ITERATION MARK>
30D5 309A 30FD ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B30.0020.0010.30D7] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8C FF9F 30FD ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B30.0020.0010.30D7] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3077 309D ; [.2B30.0020.0011.3075][.0000.0149.0002.309A][.2B30.0020.0010.3077] # <HIRAGANA LETTER PU, HIRAGANA ITERATION MARK>
3075 309A 309D ; [.2B30.0020.0011.3075][.0000.0149.0002.309A][.2B30.0020.0010.3077] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D7 30FE ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B30.0020.0010.30D7][.0000.0148.0002.3099] # <KATAKANA LETTER PU, KATAKANA VOICED ITERATION MARK>
30D5 309A 30FE ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B30.0020.0010.30D7][.0000.0148.0002.3099] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8C FF9F 30FE ; [.2B30.0020.0011.30D5][.0000.0149.0002.309A][.2B30.0020.0010.30D7][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3077 309E ; [.2B30.0020.0011.3075][.0000.0149.0002.309A][.2B30.0020.0010.3077][.0000.0148.0002.3099] # <HIRAGANA LETTER PU, HIRAGANA VOICED ITERATION MARK>
3075 309A 309E ; [.2B30.0020.0011.3075][.0000.0149.0002.309A][.2B30.0020.0010.3077][.0000.0148.0002.3099] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D8 30FD ; [.2B31.0020.0011.30D8][.2B31.0020.0010.30D8] # <KATAKANA LETTER HE, KATAKANA ITERATION MARK>
FF8D 30FD ; [.2B31.0020.0011.30D8][.2B31.0020.0010.30D8] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA ITERATION MARK>
3078 309D ; [.2B31.0020.0011.3078][.2B31.0020.0010.3078] # <HIRAGANA LETTER HE, HIRAGANA ITERATION MARK>
30D8 30FE ; [.2B31.0020.0011.30D8][.2B31.0020.0010.30D8][.0000.0148.0002.3099] # <KATAKANA LETTER HE, KATAKANA VOICED ITERATION MARK>
FF8D 30FE ; [.2B31.0020.0011.30D8][.2B31.0020.0010.30D8][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA VOICED ITERATION MARK>
3078 309E ; [.2B31.0020.0011.3078][.2B31.0020.0010.3078][.0000.0148.0002.3099] # <HIRAGANA LETTER HE, HIRAGANA VOICED ITERATION MARK>
30D9 30FD ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B31.0020.0010.30D9] # <KATAKANA LETTER BE, KATAKANA ITERATION MARK>
30D8 3099 30FD ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B31.0020.0010.30D9] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8D FF9E 30FD ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B31.0020.0010.30D9] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3079 309D ; [.2B31.0020.0011.3078][.0000.0148.0002.3099][.2B31.0020.0010.3079] # <HIRAGANA LETTER BE, HIRAGANA ITERATION MARK>
3078 3099 309D ; [.2B31.0020.0011.3078][.0000.0148.0002.3099][.2B31.0020.0010.3079] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D9 30FE ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B31.0020.0010.30D9][.0000.0148.0002.3099] # <KATAKANA LETTER BE, KATAKANA VOICED ITERATION MARK>
30D8 3099 30FE ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B31.0020.0010.30D9][.0000.0148.0002.3099] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8D FF9E 30FE ; [.2B31.0020.0011.30D8][.0000.0148.0002.3099][.2B31.0020.0010.30D9][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3079 309E ; [.2B31.0020.0011.3078][.0000.0148.0002.3099][.2B31.0020.0010.3079][.0000.0148.0002.3099] # <HIRAGANA LETTER BE, HIRAGANA VOICED ITERATION MARK>
3078 3099 309E ; [.2B31.0020.0011.3078][.0000.0148.0002.3099][.2B31.0020.0010.3079][.0000.0148.0002.3099] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DA 30FD ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B31.0020.0010.30DA] # <KATAKANA LETTER PE, KATAKANA ITERATION MARK>
30D8 309A 30FD ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B31.0020.0010.30DA] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8D FF9F 30FD ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B31.0020.0010.30DA] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
307A 309D ; [.2B31.0020.0011.3078][.0000.0149.0002.309A][.2B31.0020.0010.307A] # <HIRAGANA LETTER PE, HIRAGANA ITERATION MARK>
3078 309A 309D ; [.2B31.0020.0011.3078][.0000.0149.0002.309A][.2B31.0020.0010.307A] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DA 30FE ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B31.0020.0010.30DA][.0000.0148.0002.3099] # <KATAKANA LETTER PE, KATAKANA VOICED ITERATION MARK>
30D8 309A 30FE ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B31.0020.0010.30DA][.0000.0148.0002.3099] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8D FF9F 30FE ; [.2B31.0020.0011.30D8][.0000.0149.0002.309A][.2B31.0020.0010.30DA][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307A 309E ; [.2B31.0020.0011.3078][.0000.0149.0002.309A][.2B31.0020.0010.307A][.0000.0148.0002.3099] # <HIRAGANA LETTER PE, HIRAGANA VOICED ITERATION MARK>
3078 309A 309E ; [.2B31.0020.0011.3078][.0000.0149.0002.309A][.2B31.0020.0010.307A][.0000.0148.0002.3099] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DB 30FD ; [.2B32.0020.0011.30DB][.2B32.0020.0010.30DB] # <KATAKANA LETTER HO, KATAKANA ITERATION MARK>
FF8E 30FD ; [.2B32.0020.0011.30DB][.2B32.0020.0010.30DB] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA ITERATION MARK>
307B 309D ; [.2B32.0020.0011.307B][.2B32.0020.0010.307B] # <HIRAGANA LETTER HO, HIRAGANA ITERATION MARK>
30DB 30FE ; [.2B32.0020.0011.30DB][.2B32.0020.0010.30DB][.0000.0148.0002.3099] # <KATAKANA LETTER HO, KATAKANA VOICED ITERATION MARK>
FF8E 30FE ; [.2B32.0020.0011.30DB][.2B32.0020.0010.30DB][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA VOICED ITERATION MARK>
307B 309E ; [.2B32.0020.0011.307B][.2B32.0020.0010.307B][.0000.0148.0002.3099] # <HIRAGANA LETTER HO, HIRAGANA VOICED ITERATION MARK>
30DC 30FD ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B32.0020.0010.30DC] # <KATAKANA LETTER BO, KATAKANA ITERATION MARK>
30DB 3099 30FD ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B32.0020.0010.30DC] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8E FF9E 30FD ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B32.0020.0010.30DC] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
307C 309D ; [.2B32.0020.0011.307B][.0000.0148.0002.3099][.2B32.0020.0010.307C] # <HIRAGANA LETTER BO, HIRAGANA ITERATION MARK>
307B 3099 309D ; [.2B32.0020.0011.307B][.0000.0148.0002.3099][.2B32.0020.0010.307C] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DC 30FE ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B32.0020.0010.30DC][.0000.0148.0002.3099] # <KATAKANA LETTER BO, KATAKANA VOICED ITERATION MARK>
30DB 3099 30FE ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B32.0020.0010.30DC][.0000.0148.0002.3099] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8E FF9E 30FE ; [.2B32.0020.0011.30DB][.0000.0148.0002.3099][.2B32.0020.0010.30DC][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307C 309E ; [.2B32.0020.0011.307B][.0000.0148.0002.3099][.2B32.0020.0010.307C][.0000.0148.0002.3099] # <HIRAGANA LETTER BO, HIRAGANA VOICED ITERATION MARK>
307B 3099 309E ; [.2B32.0020.0011.307B][.0000.0148.0002.3099][.2B32.0020.0010.307C][.0000.0148.0002.3099] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DD 30FD ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B32.0020.0010.30DD] # <KATAKANA LETTER PO, KATAKANA ITERATION MARK>
30DB 309A 30FD ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B32.0020.0010.30DD] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8E FF9F 30FD ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B32.0020.0010.30DD] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
307D 309D ; [.2B32.0020.0011.307B][.0000.0149.0002.309A][.2B32.0020.0010.307D] # <HIRAGANA LETTER PO, HIRAGANA ITERATION MARK>
307B 309A 309D ; [.2B32.0020.0011.307B][.0000.0149.0002.309A][.2B32.0020.0010.307D] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DD 30FE ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B32.0020.0010.30DD][.0000.0148.0002.3099] # <KATAKANA LETTER PO, KATAKANA VOICED ITERATION MARK>
30DB 309A 30FE ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B32.0020.0010.30DD][.0000.0148.0002.3099] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8E FF9F 30FE ; [.2B32.0020.0011.30DB][.0000.0149.0002.309A][.2B32.0020.0010.30DD][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307D 309E ; [.2B32.0020.0011.307B][.0000.0149.0002.309A][.2B32.0020.0010.307D][.0000.0148.0002.3099] # <HIRAGANA LETTER PO, HIRAGANA VOICED ITERATION MARK>
307B 309A 309E ; [.2B32.0020.0011.307B][.0000.0149.0002.309A][.2B32.0020.0010.307D][.0000.0148.0002.3099] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DE 30FD ; [.2B33.0020.0011.30DE][.2B33.0020.0010.30DE] # <KATAKANA LETTER MA, KATAKANA ITERATION MARK>
FF8F 30FD ; [.2B33.0020.0011.30DE][.2B33.0020.0010.30DE] # <HALFWIDTH KATAKANA LETTER MA, KATAKANA ITERATION MARK>
307E 309D ; [.2B33.0020.0011.307E][.2B33.0020.0010.307E] # <HIRAGANA LETTER MA, HIRAGANA ITERATION MARK>
30DF 30FD ; [.2B34.0020.0011.30DF][.2B34.0020.0010.30DF] # <KATAKANA LETTER MI, KATAKANA ITERATION MARK>
FF90 30FD ; [.2B34.0020.0011.30DF][.2B34.0020.0010.30DF] # <HALFWIDTH KATAKANA LETTER MI, KATAKANA ITERATION MARK>
307F 309D ; [.2B34.0020.0011.307F][.2B34.0020.0010.307F] # <HIRAGANA LETTER MI, HIRAGANA ITERATION MARK>
30E0 30FD ; [.2B35.0020.0011.30E0][.2B35.0020.0010.30E0] # <KATAKANA LETTER MU, KATAKANA ITERATION MARK>
FF91 30FD ; [.2B35.0020.0011.30E0][.2B35.0020.0010.30E0] # <HALFWIDTH KATAKANA LETTER MU, KATAKANA ITERATION MARK>
3080 309D ; [.2B35.0020.0011.3080][.2B35.0020.0010.3080] # <HIRAGANA LETTER MU, HIRAGANA ITERATION MARK>
30E1 30FD ; [.2B36.0020.0011.30E1][.2B36.0020.0010.30E1] # <KATAKANA LETTER ME, KATAKANA ITERATION MARK>
FF92 30FD ; [.2B36.0020.0011.30E1][.2B36.0020.0010.30E1] # <HALFWIDTH KATAKANA LETTER ME, KATAKANA ITERATION MARK>
3081 309D ; [.2B36.0020.0011.3081][.2B36.0020.0010.3081] # <HIRAGANA LETTER ME, HIRAGANA ITERATION MARK>
30E2 30FD ; [.2B37.0020.0011.30E2][.2B37.0020.0010.30E2] # <KATAKANA LETTER MO, KATAKANA ITERATION MARK>
FF93 30FD ; [.2B37.0020.0011.30E2][.2B37.0020.0010.30E2] # <HALFWIDTH KATAKANA LETTER MO, KATAKANA ITERATION MARK>
3082 309D ; [.2B37.0020.0011.3082][.2B37.0020.0010.3082] # <HIRAGANA LETTER MO, HIRAGANA ITERATION MARK>
30E3 30FD ; [.2B38.0020.000F.30E3][.2B38.0020.0010.30E3] # <KATAKANA LETTER SMALL YA, KATAKANA ITERATION MARK>
FF6C 30FD ; [.2B38.0020.000F.30E3][.2B38.0020.0010.30E3] # <HALFWIDTH KATAKANA LETTER SMALL YA, KATAKANA ITERATION MARK>
3083 309D ; [.2B38.0020.000F.3083][.2B38.0020.0010.3083] # <HIRAGANA LETTER SMALL YA, HIRAGANA ITERATION MARK>
30E4 30FD ; [.2B38.0020.0011.30E4][.2B38.0020.0010.30E4] # <KATAKANA LETTER YA, KATAKANA ITERATION MARK>
FF94 30FD ; [.2B38.0020.0011.30E4][.2B38.0020.0010.30E4] # <HALFWIDTH KATAKANA LETTER YA, KATAKANA ITERATION MARK>
3084 309D ; [.2B38.0020.0011.3084][.2B38.0020.0010.3084] # <HIRAGANA LETTER YA, HIRAGANA ITERATION MARK>
30E5 30FD ; [.2B39.0020.000F.30E5][.2B39.0020.0010.30E5] # <KATAKANA LETTER SMALL YU, KATAKANA ITERATION MARK>
FF6D 30FD ; [.2B39.0020.000F.30E5][.2B39.0020.0010.30E5] # <HALFWIDTH KATAKANA LETTER SMALL YU, KATAKANA ITERATION MARK>
3085 309D ; [.2B39.0020.000F.3085][.2B39.0020.0010.3085] # <HIRAGANA LETTER SMALL YU, HIRAGANA ITERATION MARK>
30E6 30FD ; [.2B39.0020.0011.30E6][.2B39.0020.0010.30E6] # <KATAKANA LETTER YU, KATAKANA ITERATION MARK>
FF95 30FD ; [.2B39.0020.0011.30E6][.2B39.0020.0010.30E6] # <HALFWIDTH KATAKANA LETTER YU, KATAKANA ITERATION MARK>
3086 309D ; [.2B39.0020.0011.3086][.2B39.0020.0010.3086] # <HIRAGANA LETTER YU, HIRAGANA ITERATION MARK>
30E7 30FD ; [.2B3A.0020.000F.30E7][.2B3A.0020.0010.30E7] # <KATAKANA LETTER SMALL YO, KATAKANA ITERATION MARK>
FF6E 30FD ; [.2B3A.0020.000F.30E7][.2B3A.0020.0010.30E7] # <HALFWIDTH KATAKANA LETTER SMALL YO, KATAKANA ITERATION MARK>
3087 309D ; [.2B3A.0020.000F.3087][.2B3A.0020.0010.3087] # <HIRAGANA LETTER SMALL YO, HIRAGANA ITERATION MARK>
30E8 30FD ; [.2B3A.0020.0011.30E8][.2B3A.0020.0010.30E8] # <KATAKANA LETTER YO, KATAKANA ITERATION MARK>
FF96 30FD ; [.2B3A.0020.0011.30E8][.2B3A.0020.0010.30E8] # <HALFWIDTH KATAKANA LETTER YO, KATAKANA ITERATION MARK>
3088 309D ; [.2B3A.0020.0011.3088][.2B3A.0020.0010.3088] # <HIRAGANA LETTER YO, HIRAGANA ITERATION MARK>
30E9 30FD ; [.2B3B.0020.0011.30E9][.2B3B.0020.0010.30E9] # <KATAKANA LETTER RA, KATAKANA ITERATION MARK>
FF97 30FD ; [.2B3B.0020.0011.30E9][.2B3B.0020.0010.30E9] # <HALFWIDTH KATAKANA LETTER RA, KATAKANA ITERATION MARK>
3089 309D ; [.2B3B.0020.0011.3089][.2B3B.0020.0010.3089] # <HIRAGANA LETTER RA, HIRAGANA ITERATION MARK>
30EA 30FD ; [.2B3C.0020.0011.30EA][.2B3C.0020.0010.30EA] # <KATAKANA LETTER RI, KATAKANA ITERATION MARK>
FF98 30FD ; [.2B3C.0020.0011.30EA][.2B3C.0020.0010.30EA] # <HALFWIDTH KATAKANA LETTER RI, KATAKANA ITERATION MARK>
308A 309D ; [.2B3C.0020.0011.308A][.2B3C.0020.0010.308A] # <HIRAGANA LETTER RI, HIRAGANA ITERATION MARK>
30EB 30FD ; [.2B3D.0020.0011.30EB][.2B3D.0020.0010.30EB] # <KATAKANA LETTER RU, KATAKANA ITERATION MARK>
FF99 30FD ; [.2B3D.0020.0011.30EB][.2B3D.0020.0010.30EB] # <HALFWIDTH KATAKANA LETTER RU, KATAKANA ITERATION MARK>
308B 309D ; [.2B3D.0020.0011.308B][.2B3D.0020.0010.308B] # <HIRAGANA LETTER RU, HIRAGANA ITERATION MARK>
30EC 30FD ; [.2B3E.0020.0011.30EC][.2B3E.0020.0010.30EC] # <KATAKANA LETTER RE, KATAKANA ITERATION MARK>
FF9A 30FD ; [.2B3E.0020.0011.30EC][.2B3E.0020.0010.30EC] # <HALFWIDTH KATAKANA LETTER RE, KATAKANA ITERATION MARK>
308C 309D ; [.2B3E.0020.0011.308C][.2B3E.0020.0010.308C] # <HIRAGANA LETTER RE, HIRAGANA ITERATION MARK>
30ED 30FD ; [.2B3F.0020.0011.30ED][.2B3F.0020.0010.30ED] # <KATAKANA LETTER RO, KATAKANA ITERATION MARK>
FF9B 30FD ; [.2B3F.0020.0011.30ED][.2B3F.0020.0010.30ED] # <HALFWIDTH KATAKANA LETTER RO, KATAKANA ITERATION MARK>
308D 309D ; [.2B3F.0020.0011.308D][.2B3F.0020.0010.308D] # <HIRAGANA LETTER RO, HIRAGANA ITERATION MARK>
30EE 30FD ; [.2B40.0020.000F.30EE][.2B40.0020.0010.30EE] # <KATAKANA LETTER SMALL WA, KATAKANA ITERATION MARK>
308E 309D ; [.2B40.0020.000F.308E][.2B40.0020.0010.308E] # <HIRAGANA LETTER SMALL WA, HIRAGANA ITERATION MARK>
30EE 30FE ; [.2B40.0020.000F.30EE][.2B40.0020.0010.30EE][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL WA, KATAKANA VOICED ITERATION MARK>
308E 309E ; [.2B40.0020.000F.308E][.2B40.0020.0010.308E][.0000.0148.0002.3099] # <HIRAGANA LETTER SMALL WA, HIRAGANA VOICED ITERATION MARK>
30EF 30FD ; [.2B40.0020.0011.30EF][.2B40.0020.0010.30EF] # <KATAKANA LETTER WA, KATAKANA ITERATION MARK>
FF9C 30FD ; [.2B40.0020.0011.30EF][.2B40.0020.0010.30EF] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA ITERATION MARK>
308F 309D ; [.2B40.0020.0011.308F][.2B40.0020.0010.308F] # <HIRAGANA LETTER WA, HIRAGANA ITERATION MARK>
30EF 30FE ; [.2B40.0020.0011.30EF][.2B40.0020.0010.30EF][.0000.0148.0002.3099] # <KATAKANA LETTER WA, KATAKANA VOICED ITERATION MARK>
FF9C 30FE ; [.2B40.0020.0011.30EF][.2B40.0020.0010.30EF][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA VOICED ITERATION MARK>
308F 309E ; [.2B40.0020.0011.308F][.2B40.0020.0010.308F][.0000.0148.0002.3099] # <HIRAGANA LETTER WA, HIRAGANA VOICED ITERATION MARK>
30F0 30FD ; [.2B41.0020.0011.30F0][.2B41.0020.0010.30F0] # <KATAKANA LETTER WI, KATAKANA ITERATION MARK>
3090 309D ; [.2B41.0020.0011.3090][.2B41.0020.0010.3090] # <HIRAGANA LETTER WI, HIRAGANA ITERATION MARK>
30F0 30FE ; [.2B41.0020.0011.30F0][.2B41.0020.0010.30F0][.0000.0148.0002.3099] # <KATAKANA LETTER WI, KATAKANA VOICED ITERATION MARK>
3090 309E ; [.2B41.0020.0011.3090][.2B41.0020.0010.3090][.0000.0148.0002.3099] # <HIRAGANA LETTER WI, HIRAGANA VOICED ITERATION MARK>
30F1 30FD ; [.2B42.0020.0011.30F1][.2B42.0020.0010.30F1] # <KATAKANA LETTER WE, KATAKANA ITERATION MARK>
3091 309D ; [.2B42.0020.0011.3091][.2B42.0020.0010.3091] # <HIRAGANA LETTER WE, HIRAGANA ITERATION MARK>
30F1 30FE ; [.2B42.0020.0011.30F1][.2B42.0020.0010.30F1][.0000.0148.0002.3099] # <KATAKANA LETTER WE, KATAKANA VOICED ITERATION MARK>
3091 309E ; [.2B42.0020.0011.3091][.2B42.0020.0010.3091][.0000.0148.0002.3099] # <HIRAGANA LETTER WE, HIRAGANA VOICED ITERATION MARK>
30F2 30FD ; [.2B43.0020.0011.30F2][.2B43.0020.0010.30F2] # <KATAKANA LETTER WO, KATAKANA ITERATION MARK>
FF66 30FD ; [.2B43.0020.0011.30F2][.2B43.0020.0010.30F2] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA ITERATION MARK>
3092 309D ; [.2B43.0020.0011.3092][.2B43.0020.0010.3092] # <HIRAGANA LETTER WO, HIRAGANA ITERATION MARK>
30F2 30FE ; [.2B43.0020.0011.30F2][.2B43.0020.0010.30F2][.0000.0148.0002.3099] # <KATAKANA LETTER WO, KATAKANA VOICED ITERATION MARK>
FF66 30FE ; [.2B43.0020.0011.30F2][.2B43.0020.0010.30F2][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA VOICED ITERATION MARK>
3092 309E ; [.2B43.0020.0011.3092][.2B43.0020.0010.3092][.0000.0148.0002.3099] # <HIRAGANA LETTER WO, HIRAGANA VOICED ITERATION MARK>
30F3 30FD ; [.2B44.0020.0011.30F3][.2B44.0020.0010.30F3] # <KATAKANA LETTER N, KATAKANA ITERATION MARK>
FF9D 30FD ; [.2B44.0020.0011.30F3][.2B44.0020.0010.30F3] # <HALFWIDTH KATAKANA LETTER N, KATAKANA ITERATION MARK>
3093 309D ; [.2B44.0020.0011.3093][.2B44.0020.0010.3093] # <HIRAGANA LETTER N, HIRAGANA ITERATION MARK>
30F4 30FD ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0010.30F4] # <KATAKANA LETTER VU, KATAKANA ITERATION MARK>
30A6 3099 30FD ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0010.30F4] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF73 FF9E 30FD ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0010.30F4] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3094 309D ; [.2B17.0020.0011.3046][.0000.0148.0002.3099][.2B17.0020.0010.3094] # <HIRAGANA LETTER VU, HIRAGANA ITERATION MARK>
3046 3099 309D ; [.2B17.0020.0011.3046][.0000.0148.0002.3099][.2B17.0020.0010.3094] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30F4 30FE ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0010.30F4][.0000.0148.0002.3099] # <KATAKANA LETTER VU, KATAKANA VOICED ITERATION MARK>
30A6 3099 30FE ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0010.30F4][.0000.0148.0002.3099] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF73 FF9E 30FE ; [.2B17.0020.0011.30A6][.0000.0148.0002.3099][.2B17.0020.0010.30F4][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3094 309E ; [.2B17.0020.0011.3046][.0000.0148.0002.3099][.2B17.0020.0010.3094][.0000.0148.0002.3099] # <HIRAGANA LETTER VU, HIRAGANA VOICED ITERATION MARK>
3046 3099 309E ; [.2B17.0020.0011.3046][.0000.0148.0002.3099][.2B17.0020.0010.3094][.0000.0148.0002.3099] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30F5 30FD ; [.2B1A.0020.000F.30F5][.2B1A.0020.0010.30F5] # <KATAKANA LETTER SMALL KA, KATAKANA ITERATION MARK>
3095 309D ; [.2B1A.0020.000F.3095][.2B1A.0020.0010.3095] # <HIRAGANA LETTER SMALL KA, HIRAGANA ITERATION MARK>
30F5 30FE ; [.2B1A.0020.000F.30F5][.2B1A.0020.0010.30F5][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL KA, KATAKANA VOICED ITERATION MARK>
3095 309E ; [.2B1A.0020.000F.3095][.2B1A.0020.0010.3095][.0000.0148.0002.3099] # <HIRAGANA LETTER SMALL KA, HIRAGANA VOICED ITERATION MARK>
30F6 30FD ; [.2B1D.0020.000F.30F6][.2B1D.0020.0010.30F6] # <KATAKANA LETTER SMALL KE, KATAKANA ITERATION MARK>
3096 309D ; [.2B1D.0020.000F.3096][.2B1D.0020.0010.3096] # <HIRAGANA LETTER SMALL KE, HIRAGANA ITERATION MARK>
30F6 30FE ; [.2B1D.0020.000F.30F6][.2B1D.0020.0010.30F6][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL KE, KATAKANA VOICED ITERATION MARK>
3096 309E ; [.2B1D.0020.000F.3096][.2B1D.0020.0010.3096][.0000.0148.0002.3099] # <HIRAGANA LETTER SMALL KE, HIRAGANA VOICED ITERATION MARK>
30F7 30FD ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B40.0020.0010.30F7] # <KATAKANA LETTER VA, KATAKANA ITERATION MARK>
30EF 3099 30FD ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B40.0020.0010.30F7] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF9C FF9E 30FD ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B40.0020.0010.30F7] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F7 30FE ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B40.0020.0010.30F7][.0000.0148.0002.3099] # <KATAKANA LETTER VA, KATAKANA VOICED ITERATION MARK>
30EF 3099 30FE ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B40.0020.0010.30F7][.0000.0148.0002.3099] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF9C FF9E 30FE ; [.2B40.0020.0011.30EF][.0000.0148.0002.3099][.2B40.0020.0010.30F7][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30F8 30FD ; [.2B41.0020.0011.30F0][.0000.0148.0002.3099][.2B41.0020.0010.30F8] # <KATAKANA LETTER VI, KATAKANA ITERATION MARK>
30F0 3099 30FD ; [.2B41.0020.0011.30F0][.0000.0148.0002.3099][.2B41.0020.0010.30F8] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F8 30FE ; [.2B41.0020.0011.30F0][.0000.0148.0002.3099][.2B41.0020.0010.30F8][.0000.0148.0002.3099] # <KATAKANA LETTER VI, KATAKANA VOICED ITERATION MARK>
30F0 3099 30FE ; [.2B41.0020.0011.30F0][.0000.0148.0002.3099][.2B41.0020.0010.30F8][.0000.0148.0002.3099] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30F9 30FD ; [.2B42.0020.0011.30F1][.0000.0148.0002.3099][.2B42.0020.0010.30F9] # <KATAKANA LETTER VE, KATAKANA ITERATION MARK>
30F1 3099 30FD ; [.2B42.0020.0011.30F1][.0000.0148.0002.3099][.2B42.0020.0010.30F9] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F9 30FE ; [.2B42.0020.0011.30F1][.0000.0148.0002.3099][.2B42.0020.0010.30F9][.0000.0148.0002.3099] # <KATAKANA LETTER VE, KATAKANA VOICED ITERATION MARK>
30F1 3099 30FE ; [.2B42.0020.0011.30F1][.0000.0148.0002.3099][.2B42.0020.0010.30F9][.0000.0148.0002.3099] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30FA 30FD ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B43.0020.0010.30FA] # <KATAKANA LETTER VO, KATAKANA ITERATION MARK>
30F2 3099 30FD ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B43.0020.0010.30FA] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF66 FF9E 30FD ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B43.0020.0010.30FA] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30FA 30FE ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B43.0020.0010.30FA][.0000.0148.0002.3099] # <KATAKANA LETTER VO, KATAKANA VOICED ITERATION MARK>
30F2 3099 30FE ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B43.0020.0010.30FA][.0000.0148.0002.3099] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF66 FF9E 30FE ; [.2B43.0020.0011.30F2][.0000.0148.0002.3099][.2B43.0020.0010.30FA][.0000.0148.0002.3099] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
31F0 30FD ; [.2B1C.0020.000F.31F0][.2B1C.0020.0010.31F0] # <KATAKANA LETTER SMALL KU, KATAKANA ITERATION MARK>
31F0 30FE ; [.2B1C.0020.000F.31F0][.2B1C.0020.0010.31F0][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL KU, KATAKANA VOICED ITERATION MARK>
31F1 30FD ; [.2B20.0020.000F.31F1][.2B20.0020.0010.31F1] # <KATAKANA LETTER SMALL SI, KATAKANA ITERATION MARK>
31F1 30FE ; [.2B20.0020.000F.31F1][.2B20.0020.0010.31F1][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL SI, KATAKANA VOICED ITERATION MARK>
31F2 30FD ; [.2B21.0020.000F.31F2][.2B21.0020.0010.31F2] # <KATAKANA LETTER SMALL SU, KATAKANA ITERATION MARK>
31F2 30FE ; [.2B21.0020.000F.31F2][.2B21.0020.0010.31F2][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL SU, KATAKANA VOICED ITERATION MARK>
31F3 30FD ; [.2B28.0020.000F.31F3][.2B28.0020.0010.31F3] # <KATAKANA LETTER SMALL TO, KATAKANA ITERATION MARK>
31F3 30FE ; [.2B28.0020.000F.31F3][.2B28.0020.0010.31F3][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL TO, KATAKANA VOICED ITERATION MARK>
31F4 30FD ; [.2B2B.0020.000F.31F4][.2B2B.0020.0010.31F4] # <KATAKANA LETTER SMALL NU, KATAKANA ITERATION MARK>
31F5 30FD ; [.2B2E.0020.000F.31F5][.2B2E.0020.0010.31F5] # <KATAKANA LETTER SMALL HA, KATAKANA ITERATION MARK>
31F5 30FE ; [.2B2E.0020.000F.31F5][.2B2E.0020.0010.31F5][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL HA, KATAKANA VOICED ITERATION MARK>
31F6 30FD ; [.2B2F.0020.000F.31F6][.2B2F.0020.0010.31F6] # <KATAKANA LETTER SMALL HI, KATAKANA ITERATION MARK>
31F6 30FE ; [.2B2F.0020.000F.31F6][.2B2F.0020.0010.31F6][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL HI, KATAKANA VOICED ITERATION MARK>
31F7 30FD ; [.2B30.0020.000F.31F7][.2B30.0020.0010.31F7] # <KATAKANA LETTER SMALL HU, KATAKANA ITERATION MARK>
31F7 30FE ; [.2B30.0020.000F.31F7][.2B30.0020.0010.31F7][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL HU, KATAKANA VOICED ITERATION MARK>
31F8 30FD ; [.2B31.0020.000F.31F8][.2B31.0020.0010.31F8] # <KATAKANA LETTER SMALL HE, KATAKANA ITERATION MARK>
31F8 30FE ; [.2B31.0020.000F.31F8][.2B31.0020.0010.31F8][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL HE, KATAKANA VOICED ITERATION MARK>
31F9 30FD ; [.2B32.0020.000F.31F9][.2B32.0020.0010.31F9] # <KATAKANA LETTER SMALL HO, KATAKANA ITERATION MARK>
31F9 30FE ; [.2B32.0020.000F.31F9][.2B32.0020.0010.31F9][.0000.0148.0002.3099] # <KATAKANA LETTER SMALL HO, KATAKANA VOICED ITERATION MARK>
31FA 30FD ; [.2B35.0020.000F.31FA][.2B35.0020.0010.31FA] # <KATAKANA LETTER SMALL MU, KATAKANA ITERATION MARK>
31FB 30FD ; [.2B3B.0020.000F.31FB][.2B3B.0020.0010.31FB] # <KATAKANA LETTER SMALL RA, KATAKANA ITERATION MARK>
31FC 30FD ; [.2B3C.0020.000F.31FC][.2B3C.0020.0010.31FC] # <KATAKANA LETTER SMALL RI, KATAKANA ITERATION MARK>
31FD 30FD ; [.2B3D.0020.000F.31FD][.2B3D.0020.0010.31FD] # <KATAKANA LETTER SMALL RU, KATAKANA ITERATION MARK>
31FE 30FD ; [.2B3E.0020.000F.31FE][.2B3E.0020.0010.31FE] # <KATAKANA LETTER SMALL RE, KATAKANA ITERATION MARK>
31FF 30FD ; [.2B3F.0020.000F.31FF][.2B3F.0020.0010.31FF] # <KATAKANA LETTER SMALL RO, KATAKANA ITERATION MARK>
ENTRY
};
