# S6

Sparrow6 command line client and plugin manager.

# Usage

help:

    s6 --help

actions:

    s6 $action|$options $thing

# Plugins

Sparrow plugins - are portable Sparrow tasks.

## update index

    s6 --index-update

## upload plugin

    s6 --upload

    s6 --install --force $plugin # forceful upload, even if a higher version is installed

## install plugin

    s6 --install $plugin

    s6 --install --force $plugin # reinstall plugin

## run plugin

Run plugin

    s6 --plg-run $plugin

For example:

    s6 --plg-run timetest

Run plugin with parameters:

    s6 --plg-run $plugin@param1=value1,param2=value2

For example:

    s6 --plg-run bash@command=uptime,debug=1

    sudo env PATH=$PATH env SP6_REPO=$SP6_REPO s6 --plg-run user@name=sparrow,action=create

To run multiple plugins use `+` sign:

    s6 --plg-run directory@path=/tmp/foo,action=create+file@content='hello world',target=/tmp/foo/hello.txt

    sudo env PATH=$PATH env SP6_REPO=$SP6_REPO s6 --plg-run group@name=brirds,\
    action=create+user@name=sparrow,password=123456,groups=brirds,action=create

## show plugin manual

    s6 --plg-man $plugin

# Repository

Repository is a storage for sparrow plugins. Repository allows to search and installs plugins.
More about sparrow repositories read at [documentation/repository](https://github.com/melezhik/Sparrow6/blob/master/documentation/repository.md).

Repository commands:

## show repository info

    s6 --repo-info

## initialize local repository

    s6 --repo-init /path/to/repo/root

# Modules

Module is a collection of Sparrow tasks run sequentially.

## run module

    s6 --module-run $module@param1=value1,param2=value2

For example:

    s6 --module-run Archive@source=/home/melezhik/archive.tar.gz,target=/tmp/foo2,verbose=1

# Sparrow tasks

Sparrow tasks are scripts written on Sparrow compatible languages.

## sparrow tasks list

    s6 --task-list

List tasks limited by subfolder:

    s6 --task-list tasks/folder

List tasks filtered by Raku regexp:

    s6 --task-list "regexp"

For example:

    s6 --task-list 'foo || bar || baz'

## run sparrow task

    s6 --task-run task/path

You can pass parameters and run multiple tasks as you do with sparrow plugins:

    s6 --task-run task/path@param1=value1,param2=value2

    s6 --task-run task/path1+task/path2

## show sparrow task

    s6 --task-cat task/path

## delete sparrow task

    s6 --sparrow-del task/path

# Raku tasks

Raku tasks are high level scenarios to run Sparrow tasks written on Sparrow compatible languages.

## raku tasks list

    s6 --rt-list

## run raku task

    s6 --rt-run task/path

## create/update raku task

    s6 --rt-set task/path

## show raku task

    s6 --rt-cat task/path

## delete raku task

    s6 --rt-del task/path

# options

* `--verbose`   

Enable verbose mode, adds some low detail messages.

 * `--debug`   

Enable debug mode, even more messages.

# Author

Alexey Melezhik

# Thanks to

God as the One Who inspires me in my life!
