#!/usr/bin/perl -w
#
#    timezone.pl
#
#    $Id: timezone.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

# why is POSIX required to run?
use POSIX qw(locale_h errno strftime);
use utf8;

use ExtUtils::testlib;
use ICU::TimeZone;

print __FILE__.' '.__LINE__."\n";
my $tz = ICU::TimeZone->createTimeZone('PST');
print "getDisplayName = ".$tz->getDisplayName()."\n";

ICU::TimeZone->setDefault($tz);

my @ids = ICU::TimeZone->createAvailableIDs(-5*60*60*1000);
foreach my $id (sort(@ids)) {
    print "$id\n";
}

exit(0);
