// Autogenerated by Mojo::Alien::rollup 1.01
const fs = require('fs');
const pkg = require('./package.json');
const path = require('path');

const assetsDir = process.env.ROLLUP_ASSETS_DIR || path.resolve(__dirname, 'assets');
const isDev = process.env.NODE_ENV !== 'production';
const outDir = process.env.ROLLUP_OUT_DIR || path.resolve(__dirname, 'dist');
const ts = parseInt((new Date().getTime() / 1000), 10).toString(16);

function outPath(name) {
  return path.resolve(outDir, name.replace(/\[hash\]/, isDev ? 'development' : ts));
}

const config = {
  input: path.resolve(assetsDir, 'index.js'),
  output: {format: 'iife', sourcemap: true},
  plugins: [],
  watch: {clearScreen: false},
};

const includeFile = path.resolve(assetsDir, 'rollup.config.d', 'include.js');
if (fs.existsSync(includeFile)) require(includeFile)(config, {isDev});

if (!config.output.dir && !config.output.file) config.output.file = outPath(pkg.name.replace(/\W+/g, '-') + '.[hash].js');

module.exports = config;
