# -*- perl -*-

# t/004_normalize_version_number.t

use 5.010;
use CPAN::Mini::Visit::Simple::Auxiliary qw(
    normalize_version_number
);
use Test::More tests =>  8;

my @got = ();
my ($expected, $vn);

while (my $n = <DATA>) {
    chomp $n;
    push @got, normalize_version_number($n);
}

$expected = [ qw(
    2.0000100002
    2.0000100003
    3.0000500001
    3.0000900009
    4.0000100000
    0.0000200001
    0.0000900002
    0.0000900001
    3.0000000005
    0.0000600000
    1.0000000003
    6.0000000012
    6.0000200007
    6.0000200008
    1.0000100001
    1.0000000000
    1.0000000001
    1.0000200002
    0.0000300002
    0.0000500001
    3.0000200001
    4.0000000001
    0.0000000004
    0.0000000005
    3.0000000003
    0.0000000005
    0.0000200000
    1.0000000003
    1.0000200002
    5.0003000001
    0.0000300001
    0.0000100006
    0.0000100008
    0.0000200008
    0.0000000013
    0.0000000016
    0.0000300002
    0.0000400000
    0.0002100008
    0.0002100009
    0.0000500031
    0.0000500033
    3.0000200004
    3.0000500008
    1.0009900016
    1.0000000014
    1.0000000001
    1.0000100002
    2.0000000004
    1.0000800001
    1.0000200001
    1.0000300006
    0.0000300001
    0.0000300001
    0.0000300002
    0.0000100000
    0.0000300000
    0.0000800005
    0.0000000001
    0.0000000002
    2.0000400000
    2.0000600000
    0.0000000003
    0.0000100000
    0.0001700001
    4.0001300000
    3.0000100009
    3.0000200005
    3.0000300000
    0.0001900008
    0.0000300005
    0.0000300006
    3.0000000008
    2.0000000026
    2.0000200002
    0.0000000001
    0.0000200001
    0.0000000003
    0.0000000004
    0.0000000002
    0.0000000003
    0.0000300002
    0.0000400001
    7.000060000000016
    7.000070000500000
    1.0005500001
    0.0000500004
    0.0000600005
    0.0000700001
    0.0000700010
    0.0000700011
    0.0000700017
    0.0000700007
    2.0000000006
    2.0000000010
    0.0000700004
    0.0000200001
    1.0000500002
    1.0000600002
    0.0000500018
    0.0000500014
    0.0000100002
    0.0000100004
    0.0000100004
    0.0000100015
    0.0000200002
    2.0000100001
    2.0000100003
    2.0000100009
    1.0000600002
    0.0000100000
    0.0000100003
    2.0000800001
    0.0000100001
    0.0000100002
    3.0000100048
    4.0000000043
    0.000050000700001
    0.0000500008
    0.0000500001
    0.0000600000
    0.0000000040
    0.0000000058
    0.000040000100001
    0.0000400004
    0.000040000500001
    0.0000000003
    0.0000000004
    1.0000000001
    2.0000000001
    2.0000400004
    1.0000000004
    1.0000000005
    0.0003100001
    1.0000000000
    1.0000000001
    0.0000000011
    0.0000000012
    0.0000000013
    0.0000000014
    0.0000000015
    0.0000000002
    0.0000000021
    0.0000000003
    0.0000000006
    0.0000000020
) ];
is_deeply( \@got, $expected,
    "Version numbers normalized as expected" );

$vn = '003.3.4.567';
is( normalize_version_number($vn), '3.000030000400567',
    "Got expected normalization for $vn" );

$vn = '0030.3.4.567';
is( normalize_version_number($vn), '30.000030000400567',
    "Got expected normalization for $vn" );

$vn = '3.2';
is( normalize_version_number($vn), '3.00002',
    "Got expected normalization for $vn" );

$vn = '.002.9';
is( normalize_version_number($vn), '0.0000200009',
    "Got expected normalization for $vn" );

$vn = 'v0.2.2';
is( normalize_version_number($vn), '0.0000200002',
    "Got expected normalization for $vn" );

$vn = 'v2.2.2';
is( normalize_version_number($vn), '2.0000200002',
    "Got expected normalization for $vn" );

$vn = 'v.2.2';
is( normalize_version_number($vn), '0.0000200002',
    "Got expected normalization for $vn" );



__DATA__
2.1.2 
2.1.3 
3.5.1 
3.9.9 
4.1.0 
0.02.1 
0.9.02 
0.9.1 
3.000.005 
0.6.0 
1.0.3 
6.0.12 
6.2.7 
6.2.8 
1.1.1 
1.0.0 
1.0.1 
1.2.2 
0.3.2 
0.5.1 
3.2.001 
4.0.001 
0.0.4 
0.0.5 
3.0.3 
0.0.5 
0.2.0 
1.0.3 
1.2.2 
5.30.1 
0.3.1 
0.1.6 
0.1.8 
0.2.8 
0.0.13 
0.0.16 
0.3.2 
0.4.0 
0.21.8 
0.21.9 
0.5.31 
0.5.33 
3.2.4 
3.5.8 
1.99.16 
1.0.14 
1.0.1 
1.1.2 
2.0.4 
1.8.1 
1.2.1 
1.3.6 
0.3.1 
0.3.1 
0.3.2 
0.1.0 
0.3.0 
0.8.5 
0.0.1 
0.0.2 
2.4.0 
2.6.0 
0.0.3 
0.1.0 
0.17.1 
4.13.00 
3.1.9 
3.2.5 
3.3.0 
0.19.8 
0.3.5 
0.3.6 
3.0.8 
2.0.26 
2.2.2 
0.0.1 
0.2.1 
0.0.3 
0.0.4 
0.0.2 
0.0.3 
0.3.2 
0.4.1 
7.6.00.16 
7.7.05.00 
1.55.1 
0.5.4 
0.6.5 
0.7.1 
0.7.10 
0.7.11 
0.7.17 
0.7.7 
2.00.06 
2.00.10 
0.7.4 
0.2.1 
1.5.2 
1.6.2 
0.05.18 
0.5.14 
0.01.02 
0.01.04 
0.01.04 
0.01.15 
0.02.02 
2.1.1 
2.1.3 
2.1.9 
1.006.2 
0.1.0 
0.1.3 
2.08.01 
0.1.1 
0.1.2 
03.01.048 
04.00.043 
0.5.7.1 
0.5.8 
0.5.1 
0.6.0 
0.0.40 
0.0.58 
0.4.1.1 
0.4.4 
0.4.5.1 
0.0.3 
0.0.4 
1.0.1 
2.0.1 
2.4.4 
1.0.4 
1.0.5 
0.31.1 
1.0.0 
1.0.1 
0.0.11 
0.0.12 
0.0.13 
0.0.14 
0.0.15 
0.0.2 
0.0.21 
0.0.3 
0.0.6 
0.0.20 
