/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DateTimeValue;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int useWhenCode;
    private int xslUseWhenCode;
    private int defaultNamespaceCode;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack defaultNamespaceStack = new Stack();
    private DateTimeValue currentDateTime = DateTimeValue.getCurrentDateTime(null);

    public UseWhenFilter(Receiver next) {
        super(next);
    }

    public void setStartTagBuffer(StartTagBuffer startTag) {
        this.startTag = startTag;
    }

    public void open() throws XPathException {
        this.useWhenCode = this.getNamePool().allocate("", "", "use-when") & 0xFFFFF;
        this.xslUseWhenCode = this.getNamePool().allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "use-when");
        this.defaultNamespaceCode = this.getNamePool().allocate("", "", "xpath-default-namespace");
        this.nextReceiver.open();
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.defaultNamespaceStack.push(this.startTag.getAttribute(this.defaultNamespaceCode));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            block9: {
                String useWhen = elemName.isInNamespace("http://www.w3.org/1999/XSL/Transform") ? this.startTag.getAttribute(this.useWhenCode) : this.startTag.getAttribute(this.xslUseWhenCode);
                if (useWhen != null) {
                    LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
                    try {
                        boolean b = this.evaluateUseWhen(useWhen, lp.getLineNumber(locationId));
                        if (b) break block9;
                        int fp = elemName.allocateNameCode(this.getNamePool()) & 0xFFFFF;
                        if (fp == 199 || fp == 202) {
                            this.emptyStylesheetElement = true;
                            break block9;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException e) {
                        XPathException err = new XPathException("Error in use-when expression. " + e.getMessage());
                        ExpressionLocation loc = new ExpressionLocation();
                        loc.setSystemId(lp.getSystemId(locationId));
                        loc.setLineNumber(lp.getLineNumber(locationId));
                        err.setLocator(loc);
                        err.setErrorCodeQName(e.getErrorCodeQName());
                        try {
                            this.getPipelineConfiguration().getErrorListener().fatalError(err);
                        }
                        catch (TransformerException tex) {
                            throw XPathException.makeXPathException(tex);
                        }
                        err.setHasBeenReported(true);
                        throw err;
                    }
                }
            }
            this.nextReceiver.startElement(elemName, typeCode, locationId, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceBinding, properties);
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) {
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }

    public boolean evaluateUseWhen(String expression, int locationId) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag);
        LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
        staticContext.setBaseURI(lp.getSystemId(locationId));
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
        Expression expr = ExpressionTool.make(expression, staticContext, staticContext, 0, 0, lp.getLineNumber(locationId), null);
        expr.setContainer(staticContext);
        ItemType contextItemType = Type.ITEM_TYPE;
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(contextItemType, true);
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext, staticContext.getExecutable());
        expr = visitor.typeCheck(expr, cit);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        dynamicContext.openStackFrame(stackFrameMap);
        return expr.effectiveBooleanValue(dynamicContext);
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String href, String base) throws TransformerException {
            throw new TransformerException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

