# Generated by default/object.tt
package Paws::LexRuntimeV2::DialogAction;
  use Moose;
  has SlotToElicit => (is => 'ro', isa => 'Str', request_name => 'slotToElicit', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::DialogAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::DialogAction object:

  $service_obj->Method(Att1 => { SlotToElicit => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::DialogAction object:

  $result = $service_obj->Method(...);
  $result->Att1->SlotToElicit

=head1 DESCRIPTION

The next action that Amazon Lex V2 should take.

=head1 ATTRIBUTES


=head2 SlotToElicit => Str

The name of the slot that should be elicited from the user.


=head2 B<REQUIRED> Type => Str

The next action that the bot should take in its interaction with the
user. The possible values are:

=over

=item *

C<Close> - Indicates that there will not be a response from the user.
For example, the statement "Your order has been placed" does not
require a response.

=item *

C<ConfirmIntent> - The next action is asking the user if the intent is
complete and ready to be fulfilled. This is a yes/no question such as
"Place the order?"

=item *

C<Delegate> - The next action is determined by Amazon Lex V2.

=item *

C<ElicitSlot> - The next action is to elicit a slot value from the
user.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

