
package Paws::SageMaker::DescribeMonitoringSchedule;
  use Moose;
  has MonitoringScheduleName => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeMonitoringSchedule');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SageMaker::DescribeMonitoringScheduleResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::DescribeMonitoringSchedule - Arguments for method DescribeMonitoringSchedule on L<Paws::SageMaker>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeMonitoringSchedule on the
L<Amazon SageMaker Service|Paws::SageMaker> service. Use the attributes of this class
as arguments to method DescribeMonitoringSchedule.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeMonitoringSchedule.

=head1 SYNOPSIS

    my $api.sagemaker = Paws->service('SageMaker');
    my $DescribeMonitoringScheduleResponse =
      $api . sagemaker->DescribeMonitoringSchedule(
      MonitoringScheduleName => 'MyMonitoringScheduleName',

      );

    # Results:
    my $CreationTime  = $DescribeMonitoringScheduleResponse->CreationTime;
    my $EndpointName  = $DescribeMonitoringScheduleResponse->EndpointName;
    my $FailureReason = $DescribeMonitoringScheduleResponse->FailureReason;
    my $LastModifiedTime =
      $DescribeMonitoringScheduleResponse->LastModifiedTime;
    my $LastMonitoringExecutionSummary =
      $DescribeMonitoringScheduleResponse->LastMonitoringExecutionSummary;
    my $MonitoringScheduleArn =
      $DescribeMonitoringScheduleResponse->MonitoringScheduleArn;
    my $MonitoringScheduleConfig =
      $DescribeMonitoringScheduleResponse->MonitoringScheduleConfig;
    my $MonitoringScheduleName =
      $DescribeMonitoringScheduleResponse->MonitoringScheduleName;
    my $MonitoringScheduleStatus =
      $DescribeMonitoringScheduleResponse->MonitoringScheduleStatus;
    my $MonitoringType = $DescribeMonitoringScheduleResponse->MonitoringType;

    # Returns a L<Paws::SageMaker::DescribeMonitoringScheduleResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/api.sagemaker/DescribeMonitoringSchedule>

=head1 ATTRIBUTES


=head2 B<REQUIRED> MonitoringScheduleName => Str

Name of a previously created monitoring schedule.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeMonitoringSchedule in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

