# This Makefile.PL for SNMP-OID-Translate was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.35.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

# inserted by Dist::Zilla::Plugin::CheckLib 0.006
use Devel::CheckLib;
check_lib_or_exit(
    header => [ 'net-snmp/net-snmp-config.h', 'net-snmp/net-snmp-includes.h' ],
    lib => 'netsnmp',
);

use 5.008000;
use ExtUtils::MakeMaker;

#this is needed for CPAN because we have no way to tell the system they need
# to download the MIBS first.  If we don't do this we'll get fail reports for
# all systems that don't have snmp-mibs-downloader

my $found=0;
my $mibdirs = qx(net-snmp-config --default-mibdirs);
chomp($mibdirs);
for(split(/:/,$mibdirs)) {
    if (-d $_ && glob "$_/IF-MIB*") {
        $found=1;
    }
}

if (!$found) {
    print "need snmp-mibs-downloader package on debian-based systems\n";
    exit 0; # exit 0 to avoid CPAN Testers fail report
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "an XS module for SNMP translateObj",
  "AUTHOR" => "Robert Drake <rdrake\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckLib" => "0.9",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "SNMP-OID-Translate",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008000",
  "NAME" => "SNMP::OID::Translate",
  "PREREQ_PM" => {
    "DynaLoader" => 0,
    "Exporter" => 0,
    "strict" => 0,
    "vars" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => 0
  },
  "VERSION" => "0.0005",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    LIBS => '-lnetsnmp',
);

my %FallbackPrereqs = (
  "DynaLoader" => 0,
  "Exporter" => 0,
  "Test::More" => 0,
  "strict" => 0,
  "vars" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
