NAME
    RISCOS::Throwback -- provide throwback for perl

SYNOPSIS
        use RISCOS::Throwback;


DESCRIPTION
    `RISCOS::Throwback' attaches handlers to capture messages
    generated by `die' and `warn' and send them via the throwback
    system to a text editor, providing a rapid way to go to the
    source code that generated the error.

    The module works by attaching to perl's `$SIG{__DIE__}' and
    `$SIG{__WARN__}' handlers, parsing the error messages that it
    receives, and forwarding them to `DDEUtils'. Unfortunately
    messages generated by `yyerror' due to syntax errors detected by
    the lexer do not use `$SIG{__DIE__}', but are printed direct to
    `STDERR', so there is no simple way to capture this text.

    The module provides two subroutines to allow the user to
    generate throwback.

    throwback <filename>, <line>, <seriousness>, <message>
        Send an "error" message for the specified file.
        *seriousness* values are:

    0 warning

    1 error

    2 serious error


    throwback_info <filename>, <line>, <message>
        Sends an "informational message" for the specified file.


BUGS
    As noted, perl doesn't (yet) allow capture of all errors found
    while parsing the script. Also, the pattern matcher doesn't
    always correctly extract the line number from the message, which
    creates spurious line numbers in the text editor's throwback
    window. Ultimately what is needed is a well defined `C' hook
    inside perl for capturing diagnostic output.

    There is no option to make the line-number and filename in
    runtime errors and warnings refer to the last filehandle and
    line, rather than the script line.

    Throwback navely assumes that a script name of '-', '-e' or
    'eval 1' refers to a file.

    Throwback appears to be giving double messages for syntax errors
    inside modules. I presume this is due to problems with `eval'
    and `__DIE__' handlers. (the handler is called once inside the
    `eval', and a second time from the cleanup performed by `use'
    after (failing) to pass the module).

AUTHOR
    Nicholas Clark <nick@unfortu.net>

