NAME
    RISCOS::Font --perl interface to fonts and the font manager

SYNOPSIS
         use RISCOS::Font;
         $font = RISCOS::Font->new('Homerton.Medium',12);
         @bbox = $font->StringBBox('Hello World');


DESCRIPTION
    `RISCOS::Font' provides an interface to the Font manager
    allowing programs to use outline fonts. Currently only functions
    to calculate the dimensions of strings and characters are
    implemented, principally for the DrawFile Text object and the
    TextArea parser. `RISCOS::Font' automatically keeps track of the
    fonts in use, freeing a font handle with `XFont_LoseFont' when
    the last reference goes out of scope. Functionality is provided
    both as methods on `RISCOS::Font' objects and as functions that
    take a text description of the font to use. This description is
    passed as a reference to an array of parameters for `new'.

  Subroutines/Methods

    new <name> <xpoints> <ypoints> <xdpi> <ydpi>
        `new' returns a `RISCOS::Font' object referring to the
        specifed font, creating a new object if necessary. As
        object's destructor calls `XFont_LoseFont' when the last
        reference to it is destroyed, `RISCOS::Font' keeps track of
        font handles without programmer intervention. One out of
        *xpoints* and *ypoints* must be specified, and if only one
        is specified both default to this value. If *xdpi* or *ydpi*
        are undefined then 0 is passed to `XFont_FindFont' to use
        the default dpi.

    Clone
        `Clone' returns a copy of the `RISCOS::Font' object.

    PointX

    PointX
        `PointX' and `PointY' return the X and Y point sizes
        respectively.

    Name
        In scalar context `Name' returns the font's name. In array
        context returns `(*Name*, *PointX*, *PointY*)'.

    CharBBox <character>

    font_char_bbox <font> <character>
        returns the bounding box of the specified character in
        millipoints.

    StringBBox <text> [<flags> [<transform>]]

    font_string_bbox <font> <text> [<flags> [<transform>]]
        returns the bounding box (in millipoints) of the specified
        text(which may contain font control sequences). In array
        context returns the bounding box, in scalar context a
        reference to the bounding box array. This function is
        similar to `XFont_StringBBox' except that it will return
        `(0,0,0,0') for an empty string and that it will add the
        width of any trailing space. *transform* if defined should
        point to a transformation matrix, and *flags* are:

                    bit 0	perform kerning
                    bit 1	wrting direction is right to left


    Split <text> <split> <flags> <x> <y> <transform>

    font_split_string <font> <text> <split> <flags> <x> <y> <transform>
        returns the longest substring that fits within the specified
        coordinates, splitting the text at the specified character
        (or any if `undef' is specified). In scalar context returns
        the split string, in list context returns `(*text*, *x*,
        *y*, `\@bbox')' where *x*, *y* gives the position of the
        split, and *bbox* is a reference to an array containing the
        bounding box of the split string (the string starts at 0,0).
        *flags* and *transform* are as for `StringBBox'.


BUGS
    `StringBBox' doesn't match the behaviour of `XFont_ScanString',
    because `XFont_ScanString' is illogical when it comes to spaces.
    The "raw" bounding box of `"a "' is eqivalent to `"a"', while
    the "raw" bounding box of `"a "' is equivalent to the total
    width of `"a "' (*i.e.* the position where the next character
    would start). This is presumably because spaces are stated as
    having a bounding box of (0, 0, 0, 0) and the SWI navely
    positions each space at the correct place along the string and
    merges the bounding box. Hence strings like `"_ "' have a
    "bounding box" that neither gives the region of printed ink, nor
    the total width of the string. This is a bug on Acorn's part,
    because the bounding box is defined as (inclusive, inclusive,
    exclusive, exclusive), hence (0, 0, 0, 0) should be recognised
    as illegal (and hence special case).

AUTHOR
    Nicholas Clark <nick@unfortu.net>

