/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.SkinElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;

public class Skin
extends SkinElement {
    private int nrImages;
    private int hsize;
    private int vsize;
    private int ulX;
    private int ulY;
    private int lrX;
    private int lrY;
    private boolean noBorder = false;

    public Skin(String fileName, int nrImages, int ulX, int ulY, int lrX, int lrY) {
        super(fileName, true);
        this.nrImages = nrImages;
        this.ulX = ulX;
        this.ulY = ulY;
        this.lrX = lrX;
        this.lrY = lrY;
        this.calculateSizes();
    }

    public Skin(String fileName, int nrImages, int roundedSize) {
        this(fileName, nrImages, roundedSize, roundedSize, roundedSize, roundedSize);
        if (roundedSize == 0) {
            this.noBorder = true;
        }
    }

    public void draw(Graphics g, int index, int sizeX, int sizeY) {
        Graphics2D g2 = (Graphics2D)g;
        int offset = index * this.getHsize();
        if (!this.noBorder) {
            g2.drawImage(this.getImage(), 0, 0, this.ulX, this.ulY, offset + 0, 0, offset + this.ulX, this.ulY, null);
            g2.drawImage(this.getImage(), this.ulX, 0, sizeX - this.lrX, this.ulY, offset + this.ulX, 0, offset + this.hsize - this.lrX, this.ulY, null);
            g2.drawImage(this.getImage(), sizeX - this.lrX, 0, sizeX, this.ulY, offset + this.hsize - this.lrX, 0, offset + this.hsize, this.ulY, null);
            g2.drawImage(this.getImage(), 0, this.ulY, this.ulX, sizeY - this.lrY, offset + 0, this.ulY, offset + this.ulX, this.vsize - this.lrY, null);
            g2.drawImage(this.getImage(), sizeX - this.lrX, this.ulY, sizeX, sizeY - this.lrY, offset + this.hsize - this.lrX, this.ulY, offset + this.hsize, this.vsize - this.lrY, null);
            g2.drawImage(this.getImage(), 0, sizeY - this.lrY, this.ulX, sizeY, offset + 0, this.vsize - this.lrY, offset + this.ulX, this.vsize, null);
            g2.drawImage(this.getImage(), this.ulX, sizeY - this.lrY, sizeX - this.lrX, sizeY, offset + this.ulX, this.vsize - this.lrY, offset + this.hsize - this.lrX, this.vsize, null);
            g2.drawImage(this.getImage(), sizeX - this.lrX, sizeY - this.lrY, sizeX, sizeY, offset + this.hsize - this.lrX, this.vsize - this.lrY, offset + this.hsize, this.vsize, null);
            g2.drawImage(this.getImage(), this.ulX, this.ulY, sizeX - this.lrX, sizeY - this.lrY, offset + this.ulX, this.ulY, offset + this.hsize - this.lrX, this.vsize - this.lrY, null);
        } else {
            g.drawImage(this.getImage(), 0, 0, sizeX, sizeY, offset, 0, offset + this.hsize, this.vsize, null);
        }
    }

    public void draw(Graphics g, int index, int x, int y, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        if (!this.noBorder) {
            g.drawImage(this.getImage(), x + 0, y + 0, x + this.ulX, y + this.ulY, offset + 0, 0, offset + this.ulX, this.ulY, null);
            g.drawImage(this.getImage(), x + this.ulX, y + 0, x + sizeX - this.lrX, y + this.ulY, offset + this.ulX, 0, offset + this.hsize - this.lrX, this.ulY, null);
            g.drawImage(this.getImage(), x + sizeX - this.lrX, y + 0, x + sizeX, y + this.ulY, offset + this.hsize - this.lrX, 0, offset + this.hsize, this.ulY, null);
            g.drawImage(this.getImage(), x + 0, y + this.ulY, x + this.ulX, y + sizeY - this.lrY, offset + 0, this.ulY, offset + this.ulX, this.vsize - this.lrY, null);
            g.drawImage(this.getImage(), x + sizeX - this.lrX, y + this.ulY, x + sizeX, y + sizeY - this.lrY, offset + this.hsize - this.lrX, this.ulY, offset + this.hsize, this.vsize - this.lrY, null);
            g.drawImage(this.getImage(), x + 0, y + sizeY - this.lrY, x + this.ulX, y + sizeY, offset + 0, this.vsize - this.lrY, offset + this.ulX, this.vsize, null);
            g.drawImage(this.getImage(), x + this.ulX, y + sizeY - this.lrY, x + sizeX - this.lrX, y + sizeY, offset + this.ulX, this.vsize - this.lrY, offset + this.hsize - this.lrX, this.vsize, null);
            g.drawImage(this.getImage(), x + sizeX - this.lrX, y + sizeY - this.lrY, x + sizeX, y + sizeY, offset + this.hsize - this.lrX, this.vsize - this.lrY, offset + this.hsize, this.vsize, null);
            g.drawImage(this.getImage(), x + this.ulX, y + this.ulY, x + sizeX - this.lrX, y + sizeY - this.lrY, offset + this.ulX, this.ulY, offset + this.hsize - this.lrX, this.vsize - this.lrY, null);
        } else {
            g.drawImage(this.getImage(), x, y, x + sizeX, y + sizeY, offset, 0, offset + this.hsize, this.vsize, null);
        }
    }

    public void drawCentered(Graphics g, int index, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        int w = this.getHsize();
        int h = this.getVsize();
        int sx = (sizeX - w) / 2;
        int sy = (sizeY - h) / 2;
        g.drawImage(this.getImage(), sx, sy, sx + w, sy + h, offset, 0, offset + w, h, null);
    }

    public void drawCentered(Graphics g, int index, int x, int y, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        int w = this.getHsize();
        int h = this.getVsize();
        int sx = (sizeX - w) / 2;
        int sy = (sizeY - h) / 2;
        g.drawImage(this.getImage(), x + sx, y + sy, x + sx + w, y + sy + h, offset, 0, offset + w, h, null);
    }

    public int getHsize() {
        return this.hsize;
    }

    public int getVsize() {
        return this.vsize;
    }

    public Dimension getSize() {
        return new Dimension(this.hsize, this.vsize);
    }

    protected void calculateSizes() {
        this.hsize = this.getImage().getWidth(null) / this.nrImages;
        this.vsize = this.getImage().getHeight(null);
    }

    Color dark(Color c, int factor) {
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        if (factor <= 0 || c.getAlpha() < 255) {
            return c;
        }
        if (factor < 100) {
            return this.light(c, 10000 / factor);
        }
        int vi = (int)(hsv[2] * 255.0f);
        vi = 100 * vi / factor;
        float v = (float)vi / 255.0f;
        return Color.getHSBColor(hsv[0], hsv[1], v);
    }

    Color light(Color c, int factor) {
        if (factor <= 0) {
            return c;
        }
        if (factor < 100) {
            return this.dark(c, 10000 / factor);
        }
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float s = hsv[1];
        float v = hsv[2];
        System.out.print("LIGHT V : " + v);
        v = (float)factor * v / 100.0f;
        if (v > 1.0f) {
            v = 1.0f;
        }
        if (v > 255.0f) {
            if ((s -= v - 255.0f) < 0.0f) {
                s = 0.0f;
            }
            v = 255.0f;
        }
        return Color.getHSBColor(hsv[0], hsv[1], v);
    }

    Color colour(Color src, Color bg) {
        boolean blend = false;
        int srcR = src.getRed();
        int srcG = src.getGreen();
        int srcB = src.getBlue();
        int alpha = bg.getAlpha();
        int delta = 255 - bg.getRed();
        int destR = (srcR += 20) - delta;
        int destG = (srcG += 20) - delta;
        int destB = (srcB += 20) - delta;
        if (destR < 0) {
            destR = 0;
        }
        if (destG < 0) {
            destG = 0;
        }
        if (destB < 0) {
            destB = 0;
        }
        if (destR > 255) {
            destR = 255;
        }
        if (destG > 255) {
            destG = 255;
        }
        if (destB > 255) {
            destB = 255;
        }
        if (blend && alpha != 255 && alpha != 0) {
            float srcPercent = (float)alpha / 255.0f;
            float destPercent = 1.0f - srcPercent;
            destR = (int)(srcPercent * (float)destR + destPercent * (float)bg.getRed());
            destG = (int)(srcPercent * (float)destG + destPercent * (float)bg.getGreen());
            destB = (int)(srcPercent * (float)destB + destPercent * (float)bg.getBlue());
            alpha = 255;
        }
        return new Color(destR, destG, destB, alpha);
    }

    private Color colourSinglePixel(int x, int y, int pixel, Color c) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return this.colour(c, new Color(red, green, blue, alpha));
    }

    public void colourImage() {
        int x = 0;
        int y = 0;
        int w = this.hsize * this.nrImages;
        int h = this.vsize;
        BufferedImage newImage = new BufferedImage(w, h, 6);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(this.getImage(), x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        Graphics g = newImage.getGraphics();
        Color colourWith = null;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (i == 0 || i == 117) {
                    colourWith = LiquidLookAndFeel.getBackgroundColor();
                } else if (i == 39 || i == 156) {
                    colourWith = LiquidLookAndFeel.getButtonBackground();
                } else if (i == 78) {
                    colourWith = this.dark(LiquidLookAndFeel.getButtonBackground(), 115);
                }
                g.setColor(this.colourSinglePixel(x + i, y + j, pixels[j * w + i], colourWith));
                g.drawLine(x + i, y + j, x + i, y + j);
            }
        }
        this.setImage(newImage);
    }
}

