#ifndef _BC_MACROS_H
#define _BC_MACROS_H

/* if prototypes are needed */
#ifdef _STDC_
#define PARAMS(x) 	x
#else
#define PARAMS(x) 	()
#endif

#define TRUE 		1
#define FALSE		0
#define NULL		0
#define OK		0
#define ERROR		1

#define BIBCARD_NAME            "Bibcard (IAM)"
#define	VERSION_NO		"1.11"

#define BIBPATHVAR 		"BIBINPUTS"
#define HOMEVAR                 "HOME"
#define ABBREVCODE		'#'

#define NEW_BIB_NAME		"New.bib"
#define BIB_EXTENSION		".bib"
#define CLIPFILE_TEMP_PFX 	"clip_"	/* max 5 char */
#define TEMP_DIR                "/tmp/"

#define AGREP_COMMAND           "/usr/local/bin/agrep"
#define AGREP_TEMP_FILE_PFX     "agrep"	/* max 5 char */

#ifdef UPPERCASE
#define ANNOTE_TOKEN		"ANNOTE"
#define PREAMBLE_TOKEN		"PREAMBLE"
#define STRING_TOKEN		"STRING"
#else
#define ANNOTE_TOKEN            "annote"
#define PREAMBLE_TOKEN          "preamble"
#define NON_STD_TOKEN           "string"
#endif

#define UPDATE_ON               0
#define UPDATE_OFF              1
#define STD_NUM_OF_FIELDS       23

/* define the location menu (if -DLOCATION_FIELD
   in Makefile is set) */
#define LOCATION_MENU_1         "IAM BIBLIO "
#define LOCATION_MENU_2         "Archiv FCG "
#define LOCATION_MENU_3         "Archiv FKI "
/*
#define LOCATION_MENU_4         ""
#define LOCATION_MENU_5         ""
#define LOCATION_MENU_6         ""
#define LOCATION_MENU_7         ""
#define LOCATION_MENU_8         ""
#define LOCATION_MENU_9         ""
*/


/* the number of find fields in the find popup (+2 for year) */
#define	NUM_OF_FIND_FIELDS	(5 + 2)

/* set the default find fields. Lool at bc_globals.c for the token  */
#define DEFAULT_FIND_FIELD1	"CITEKEY"
#define DEFAULT_FIND_FIELD2	"AUTHOR"
#define DEFAULT_FIND_FIELD3     "TITLE"
#define DEFAULT_FIND_FIELD4	""
#define DEFAULT_FIND_FIELD5	""

/* set the default find properties */
#define DEFAULT_FIND_CONNECT        0	/* 0 => AND	1=> OR */
#define DEFAULT_FIND_FINDMETHOD     0	/* 0 => normal	1=> fuzzy */
#define DEFAULT_FIND_IGNORE_CASE    1	/* 0 => no	1=> yes */
#define DEFAULT_FIND_FUZZY_DISTANCE 1	/* 0..8 */
#define DEFAULT_FIND_SELECT_IN_LIST 1	/* 0 => no	1=> yes */

/* set other defaults */
#define DEFAULT_UPDATE          UPDATE_ON
#define DEFAULT_MAX_TOTAL_FOR_LIST      2000 /* 0 .. 9999 */

/* messages are printed to */
#define PRINT_TO		stderr	/* stderr or stdout */

/* set the position of the first line */
#define LINE_1_XV_Y		40

/* set the default distance between the lines */
#define DEFAULT_OFFSET_XV_Y		24

/* set max standard lines */
#define MAX_STD_LINES           19

/* set the distance between two fields in the same line */
#define OFFSET_XV_X	230

/* set the size of the reference field */
#define REF_TYPE_SIZE		80

/* set range for expand event */
#define EXPAND_RANGE_Y		(offset_xv_y - 5)

/* set the distance for the popup windwos */
#define POPUP_DIST		60

/* set pushpin in the expand window */
#define EXPAND_POPUP_PUSHPIN	TRUE

/* set the number of reference types */
#define NUM_OF_REF_TYPES	14

/* set the default refernce type. Look at bc_globals.c for the number */
#define DEFAULT_REF_TYPE	0
#define DEFAULT_FIND_REF_TYPE	(NUM_OF_REF_TYPES + 0)

/* set the positions of the fields */
#define CITEKEY_XV_X 		312
#define ADDRESS_XV_X		66
#define AUTHOR_XV_X		57
#define BOOKTITLE_XV_X		60
#define CHAPTER_XV_X		67
#define EDITION_XV_X		73
#define EDITOR_XV_X		63
#define HOWPUBLISHED_XV_X	18
#define INSTITUTION_XV_X	48
#define JOURNAL_XV_X		70
#define KEY_XV_X		342
#define MESSAGE_OPTIONAL_XV_X	30
#define MESSAGE_OR_1_XV_X       30
#define MESSAGE_OR_2_XV_X	30
#define MESSAGE_AND_OR_XV_X	30
#define MESSAGE_USER_FIELDS_XV_X 56
#define MESSAGE_REQUIRED_XV_X   30
#define MONTH_BUTTON_XV_X	78
#define MONTH_XV_X		162
#define NOTE_XV_X		90
#define NUMBER_XV_X		66
#define ORGANIZATION_XV_X	32
#define PAGES_XV_X		81
#define PUBLISHER_XV_X		54
#define REF_TYPE_XV_X		14
#define SCHOOL_XV_X		76
#define SERIES_XV_X		77
#define TITLE_XV_X		89
#define TYPE_XV_X		88
#define VOLUME_XV_X		69
#define YEAR_XV_X		90

#ifdef CROSS_REF_KEY_FIELD
#define CROSSREF_XV_X		30
#endif

#ifdef LOCATION_FIELD
#define LOCATION_BUTTON_XV_X	64
#define LOCATION_XV_X		163
#endif

#ifdef SIGNATURE_FIELD
#define SIGNATURE_XV_X          56
#endif

#ifdef CRINDEX_FIELD
#define CRINDEX_XV_X            68
#endif

#ifdef KEYWORDS_FIELD
#define KEYWORDS_XV_X           54
#endif

#ifdef DATE_FIELD
#define DATE_XV_X               88
#endif

#ifdef ISBN_FIELD
#define ISBN_XV_X               50
#endif


#define FIELDLEFT 		'{'	/* can be either '{' or '"' */
#define FIELDRIGHT 		'}'	/* can be either '}' or '"' */
#define LD_ERROR 		98
#define CLIP_UPDATE_TIME 	10000	/* usec */


#define FILE_OFFSET_TOKEN       8	/* 5 , 8 */
#define FILE_OFFSET_FIELD      18	/* 12,18 */


/* some fine macros */

/*
 * #include <malloc.h> #include <strings.h>
 */

#define SET_STR(x, new){\
	if (x) free(x);\
	if (new)\
		x = strdup(new);\
	else\
		x = new;\
	}


#define ADD_TO(x,s){\
	if (!x) {SET_STR(x,s);} \
	else if (s) { \
		x = realloc(x,strlen(x)+strlen(s)+1); \
		strcat(x,s); \
		};\
	}


#define TOLOWER(c) (isupper(c) ? tolower(c) : (c))


#endif				/* of _BC_MACROS_H */
