/* output.c - C4P Output Routines
   Time-stamp: "97/01/03 17:45:42 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>

#include "common.h"

static int halting;

static FILE *file_table[2];
static FILE *cur_file;
static int cur_file_num;

static char out_buf[BUF_SIZE];
static unsigned buf_ptr;
static unsigned chars_in_buf;
unsigned curly_brace_level;
unsigned extra_indent;
unsigned c_file_line_count;

static int last_char;

#if ! defined (min)
#define min(a,b)	(((a) < (b)) ? (a) : (b))
#endif

#if ! defined (max)
#define max(a,b)	(((a) > (b)) ? (a) : (b))
#endif

static void
flush_buf (void)

{
  if (chars_in_buf == BUF_SIZE)
    fwrite (out_buf + buf_ptr, 1, BUF_SIZE - buf_ptr, cur_file);
  if (buf_ptr > 0)
    fwrite (out_buf, 1, buf_ptr, cur_file);
  buf_ptr = 0;
  chars_in_buf = 0;
}

unsigned
get_buf_mark (void)

{
  return (buf_ptr);
}

char *
get_buf_text (char *string,
	      unsigned buf_mark,
	      unsigned count)

{
  unsigned n;

  buf_mark %= BUF_SIZE;

  if (count == 0)
    if (buf_mark < buf_ptr)
      count = buf_ptr - buf_mark;
    else
      count = BUF_SIZE - (buf_mark - buf_ptr);

  n = min (count, (unsigned) BUF_SIZE - buf_mark);

  memcpy (string, out_buf + buf_mark, n);
  if (n < count)
    memcpy (string + n, out_buf, count - n);

  string[count] = 0;

  return (string);
}

void
out_buf_over (unsigned buf_mark,
	      const char *string,
	      unsigned count)

{
  unsigned n;

  if (count == 0)
    if (buf_mark < buf_ptr)
      count = buf_ptr - buf_mark;
    else
      count = BUF_SIZE - (buf_mark - buf_ptr);

  n = min (count, (unsigned) BUF_SIZE - buf_mark);

  memcpy (out_buf + buf_mark, string, n);
  if (n < count)
    memcpy (out_buf, string + n, count - n);
}

void
open_file (unsigned filnum,
	   const char *file_name)

{
  if ((file_table[filnum] = fopen (file_name, "wb")) == 0)
    perror (file_name);
  if (filnum == C_FILE_NUM)
    c_file_line_count = 0;
}

void
close_file (unsigned filnum)

{
  flush_buf ();
  fclose (file_table[filnum]);
}

void
reopen_file (unsigned filnum,
	     const char *file_name)

{
  flush_buf ();
  fclose (file_table[filnum]);
  open_file (filnum, file_name);
}

static void
put_char (int c)

{
  if (chars_in_buf == BUF_SIZE)
    fputc (out_buf[buf_ptr], cur_file);
  else
    chars_in_buf++;
  out_buf[buf_ptr] = (char) c;
  buf_ptr = (buf_ptr + 1) % BUF_SIZE;
}

int macroizing;

static void
out_char (int c)

{
  unsigned i;

  if (last_char == '\n')
    {
      for (i = 0; i < (curly_brace_level + extra_indent) * 2; i++)
	put_char (' ');
      if (cur_file_num == C_FILE_NUM)
	c_file_line_count++;
    }
  if (c == '\n' && macroizing)
    put_char ('\\');
  put_char (c);
  last_char = c;
}

void
out_stop (void)

{
  halting = 1;
}

void
out_resume (void)

{
  halting = 0;
}

void
out_form (const char *fmt,...)

{
  va_list ap;
  char buf[256];

  if (halting)
    return;

  va_start (ap, fmt);
  vsprintf (buf, fmt, ap);
  va_end (ap);
  out_s (buf);
}

void
out_s (const char *s)

{
  if (!halting)
    for (; *s; last_char = *s, s++)
      out_char (*s);
}

void
redir_file (int filnum)

{
  flush_buf ();
  if (filnum >= 0)
    {
      cur_file = file_table[filnum];
      last_char = '\n';
    }
  cur_file_num = (int) filnum;
}

void
translate_char (int c)

{
  switch (c)
    {
      case '\'':
      out_s ("\\\'");
      break;
    case '\\':
      out_s ("\\\\");
      break;
    default:
      out_char (c);
      break;
    }
}

void
translate_string (const char *s)

{
  while (*s)
    {
      switch (*s)
	{
	  case '"':
	  out_s ("\\\"");
	  break;
	case '\\':
	  out_s ("\\\\");
	  break;
	default:
	  out_char (*s);
	  break;
	}
      s++;
    }
}

void
out_init (void)

{
  ;
}
