/*
 * MakeTeXls-R.rexx -- create or rebuild "ls-R".
 *
 * Copyright (C) 1997 by Andreas Scherer
 * This ARexx program is free software; the author gives unlimited
 * permission to copy, distribute, and modify it.
 */

Options FailAt 21 /* Handle all error levels in this script */

TEMPFILE = "ls-R.temp" /* Intermediate file */
OUTFILE = "ls-R" /* Resulting output file */

/*
 * I have been informed about problems with "ls" programs other than
 * "ls 4.7 ljr" as shipped with AmiWeb2c.  Most likely corrupt output
 * is caused by different options.  Unfortunately, both users who
 * reported similar problems refrained from providing examples, so
 * all I can do is make my version an ARexx variable.  I would be
 * very grateful for concrete information about different "ls" options.
 *
 * To create a correct "ls-R" file the following format is essential:
 *
 *    <DEVICE>:<Current directory>
 *    <All subdirectories of the current directory>
 *    <All files in the current directory>
 *
 *    <DEVICE>:<First subdirectory of the current directory>
 *    <All subdirectories of the first subdirectory of the CD>
 *    <All files in the first subdirectory of the CD>
 *
 *    <DEVICE>:<Second subdirectory of the current directory>
 *    <All subdirectories of the second subdirectory of the CD>
 *    <All files in the second subdirectory of the CD>
 *
 * And so on.  If you really want to use a different "ls" program,
 * try the one coming with AmiWeb2c with the "-1R" option and replace
 * LSCOMMAND by an invocation string of your "ls" brand to produce
 * such a list format.  For example, the UNIX version of "ls" is
 * invoked with the "-LAR" option in the original "MakeTeXls-R".
 */
LSCOMMAND = "ls -1R"

Address COMMAND /* We use a lot of external commands */

/*
 * Produce the top entries of "ls-R".  The "AmiWeb2c:" part will eventually
 * be replaced by "./:"; Kpathsea will use relative file lookup.
 */
'echo "AmiWeb2c:"  >' TEMPFILE
'echo "bibtex"    >>' TEMPFILE
'echo "dvips"     >>' TEMPFILE
'echo "etex"      >>' TEMPFILE
'echo "fonts"     >>' TEMPFILE
'echo "makeindex" >>' TEMPFILE
'echo "metafont"  >>' TEMPFILE
'echo "metapost"  >>' TEMPFILE
'echo "omega"     >>' TEMPFILE
'echo "pdftex"    >>' TEMPFILE
'echo "tex"       >>' TEMPFILE
'echo "web2c"     >>' TEMPFILE

/*
 * The following entries are essential to a TDS-conforming installation.
 * However, not all of these are always necessary, e.g., "fonts/type1"
 * will only be used for PostScript fonts.
 */
DIRECTORIES = "bibtex dvips etex fonts/afm fonts/gf fonts/pk fonts/source"
DIRECTORIES = DIRECTORIES "fonts/tfm fonts/type1 fonts/vf makeindex"
DIRECTORIES = DIRECTORIES "metafont metapost omega pdftex tex web2c"

/*
 * Apply "ls" to this set of (sub)directories one at a time, but only
 * to existing entries.  This will create a temporary version of "ls-R".
 */
Parse Value DIRECTORIES With DIRECTORY DIRECTORIES

Do While "" ~= DIRECTORY
  If Exists( DIRECTORY ) Then Do
    'echo "" >>' TEMPFILE
    LSCOMMAND '>>' TEMPFILE DIRECTORY
  End
  Parse Value DIRECTORIES With DIRECTORY DIRECTORIES
End

/*
 * Apply "sed" to the intermediate version of "ls-R" to fix the
 * directory entries.  Three modifications are applied:
 *
 *    - Append a colon to all directories.
 *    - Replace the current directory including
 *      the device name with "dot-slash".
 *    - Replace the top-most entry with "dot-slash-colon".
 *      "There can be only one!".
 */
CURRENTDIR = Pragma( 'Directory' )

SEDCOMMAND = 'sed -e "s@\(.**\):\(.**\)@\1:\2:@"'
SEDCOMMAND = SEDCOMMAND '-e "s@'CURRENTDIR'/@./@"'
SEDCOMMAND = SEDCOMMAND '-e "s@\(.**\)::@./:@"'
SEDCOMMAND = SEDCOMMAND TEMPFILE '>' OUTFILE

SEDCOMMAND /* Invoke this (long) command string */

/*
 * Cleanup and Exit
 */
'delete' TEMPFILE 'quiet'

Exit 0

/*
 * End of program.
 */
