/*
 * This ARexx script creates all `SMakefile's used in setting up the
 * programs of the AmiWeb2c distribution.  To set or modify compiler
 * options you should first check the files "make/common.smake" and
 * "make/paths.smake" and change things if necessary before running
 * this script (by the incantation "rx configure").
 *
 * Copyright (C) 1995, 1997 by Andreas Scherer.
 * This configuration script is free software; the author gives
 * unlimited permission to copy, distribute, and modify it.
 *
 * Implementing UNIX software on the Amiga faces us with two major
 * difficulties: `configure' can't be used because of the limited
 * capabilities of the (standard) Amiga CLI, and SMake can't CD into
 * other directories.  Anyway, both inconveniences can be overcome
 * with the help of ARexx, although most of the functionality of the
 * UNIX `configure/make' mechanism is lost.  You should keep your
 * fingers crossed when running this script.
 */

Address COMMAND /* We will run external programs. */

NL = '0a'x /* `new line' character. */

/*
 * Save the name of the root directory, i.e., `<something>/web2c-7.2'.
*/
HOMEDIR = Pragma('Directory')

/*
 * We want to configure (and install) the following (sub)directories.
 */
INSTALL_DIRS = "kpathsea web2c dtl dvidvi dviljk dvipsk gsftopk lacheck"
INSTALL_DIRS = INSTALL_DIRS "makeindexk musixflx ps2pkm seetexk tex4htk"
INSTALL_SUBDIRS = "web2c/doc web2c/lib web2c/mpware web2c/web2c web2c/otps"
INSTALL_SUBDIRS = INSTALL_SUBDIRS "web2c/pdftexdir"
INSTALL_SUBSUBDIRS = "web2c/pdftexdir/zlib web2c/pdftexdir/libpng"

/*
 * The following lines constitute the best part of the whole Amiga port
 * of the UNIX Web2c system, followed closely be the various SMakefile.in
 * and *.smake files.  This code was taken from UNIX `configure' and after
 * some fiddling actually works on the Amiga!  However, this code is as
 * tricky as it looks, because we have to take care of ARexx (mixture of
 * single and double quotes), SED (which will be called twice on more or
 * less the same commands), and AmigaOS (double asterisks and `+' for
 * `continue command line').
 */
SED_COMMAND = 'sed -n "/^ac_include/s%ac_include[ 	]**\(.**\)%'
SED_COMMAND = SED_COMMAND || '\\\@^&@r \1\+' || NL
SED_COMMAND = SED_COMMAND || '\\\@^&@d%p"'

/*
 * Subdirectories of `/web2c' search for the include files one level up.
 */
SED_SUBDIR = 'sed -e "s@top_srcdir[ 	]**=[ 	]**\.@top_srcdir = ..@"'
SED_SUBDIR = SED_SUBDIR '-e "s@kpathsea_parent[ 	]**=[ 	]**\.\.@'
SED_SUBDIR = SED_SUBDIR || 'kpathsea_parent = ..\/..@"'

/*
 * Subsubdirectories of `/web2c' search for the include files two levels up.
 */
SED_SUBSUBDIR = 'sed -e "s@top_srcdir[ 	]**=[ 	]**\.@top_srcdir = ..\/..@"'
SED_SUBSUBDIR = SED_SUBSUBDIR '-e "s@kpathsea_parent[ 	]**=[ 	]**\.\.@'
SED_SUBSUBDIR = SED_SUBSUBDIR || 'kpathsea_parent = ..\/..\/..@"'

/*
 * Create the necessary SMakefiles in the main directories.
 */
Parse Value INSTALL_DIRS With INSTALL_DIR INSTALL_DIRS

Do While "" ~= INSTALL_DIR
  Pragma('Directory', HOMEDIR"/"INSTALL_DIR)

  Say "Configuring `"Pragma('Directory')".'"

  SED_COMMAND "SMakefile.in > configure.sed"
  delete force SMakefile quiet
  "sed -f configure.sed SMakefile.in > SMakefile"
  delete configure.sed quiet

  Parse Value INSTALL_DIRS With INSTALL_DIR INSTALL_DIRS
End

/*
 * Create the necessary SMakefiles in the /web2c subdirectories.
 */
Parse Value INSTALL_SUBDIRS With INSTALL_DIR INSTALL_SUBDIRS

Do While "" ~= INSTALL_DIR
  Pragma('Directory', HOMEDIR"/"INSTALL_DIR)

  Say "Configuring `"Pragma('Directory')".'"

  SED_COMMAND "SMakefile.in > configure.sed"
  delete force SMakefile quiet
  "sed -f configure.sed SMakefile.in > SMakefile.temp"
  SED_SUBDIR "SMakefile.temp > SMakefile"
  delete configure.sed SMakefile.temp quiet

  Parse Value INSTALL_SUBDIRS With INSTALL_DIR INSTALL_SUBDIRS
End

/*
 * Create the necessary SMakefiles in the /web2c subsubdirectories.
 */
Parse Value INSTALL_SUBSUBDIRS With INSTALL_DIR INSTALL_SUBSUBDIRS

Do While "" ~= INSTALL_DIR
  Pragma('Directory', HOMEDIR"/"INSTALL_DIR)

  Say "Configuring `"Pragma('Directory')".'"

  SED_COMMAND "SMakefile.in > configure.sed"
  delete force SMakefile quiet
  "sed -f configure.sed SMakefile.in > SMakefile.temp"
  SED_SUBSUBDIR "SMakefile.temp > SMakefile"
  delete configure.sed SMakefile.temp quiet

  Parse Value INSTALL_SUBSUBDIRS With INSTALL_DIR INSTALL_SUBSUBDIRS
End

/*
 * Come home again.
 */
Pragma('Directory',HOMEDIR)

Say "Finished.  You may now run `rx install' to actually compile the programs."

Exit 0

/*
 * EOF configure.rexx
 */
