/*
 * Convert WEB programs not needing special treatment to C.
 *
 * Copyright (C) 1995, 1997 by Andreas Scherer.
 * This conversion script is free software; the author gives
 * unlimited permission to copy, distribute, and modify it.
 *
 * The single argument to this script is the basename part of
 * the Pascal source to be converted to its C equivalent.
 */

Address COMMAND

SRCDIR = GetClip( "SRCDIR" );
If "" = SRCDIR Then SRCDIR = "."

USAGE = "Usage: rx convert <basefile>."

Parse Arg BASEFILE .

If "-" = SubStr(BASEFILE,1,1) Then Do
  Say BASEFILE"?"
  Say USAGE
  Exit 1
End

If "" = BASEFILE Then Do
  Say "Missing basefile argument."
  Say USAGE
  Exit 1
End

PASCALFILE = BASEFILE".p"
CFILE      = BASEFILE".c"

/*
 * This is for tangleboot if the build and source directories are different.
 */
If ~Open('READ_TEST',PASCALFILE,"Read") Then
  PASCALFILE = SRCDIR"/"PASCALFILE

/*
 * We use cpascal.h by default instead of config.h because straight C
 * routines can only be confused by the definitions for `chr', etc.
 */
HFILE = "cpascal.h"
MORE_DEFINES = ""
WEB2C_OPTIONS = "-c"BASEFILE
PRECMD = "copy temp.pre temp.web2c quiet"
MIDCMD = "copy temp.mid temp.fixwrites quiet"
FIXWRITES_OPTIONS = ""
OUTPUT = "> "CFILE
OUTPUT_FILES = CFILE BASEFILE".h"
POSTCMD = "type temp.post "OUTPUT

Select
  When "bibtex" = BASEFILE Then
    MIDCMD = "sed -f "SRCDIR"/web2c/cvtbib.sed temp.mid > temp.fixwrites"

  When "mf" = BASEFILE | "mp" = BASEFILE Then Do
  /* MF and MP are almost the same. */
    MORE_DEFINES = SRCDIR"/web2c/texmf.defines" SRCDIR"/web2c/mfmp.defines"
    PRECMD = "sed -f "SRCDIR"/web2c/cvtmf1.sed temp.pre > temp.web2c"
    WEB2C_OPTIONS = "-m -c"BASEFILE"coerce"
    HFILE = "texmfmp.h"
    MIDCMD = "sed -f "SRCDIR"/web2c/cvtmf2.sed temp.mid > temp.fixwrites"
    POSTCMD = "web2c/splitup "BASEFILE" < temp.post"
    CFILE = BASEFILE"2.c" /* last output file, or thereabouts */
    OUTPUT = ""
    OUTPUT_FILES = BASEFILE"0.c" BASEFILE"1.c" BASEFILE"2.c"
    OUTPUT_FILES = OUTPUT_FILES BASEFILE"ini.c" BASEFILE"d.h"
    OUTPUT_FILES = OUTPUT_FILES BASEFILE"coerce.h"
  End

  When "tex" = BASEFILE | "etex" = BASEFILE | "pdftex" = BASEFILE | "omega" = BASEFILE Then Do
  /* TeX, e-TeX, omega, and pdftex are almost (but not quite) the same. */
    MORE_DEFINES = SRCDIR"/web2c/texmf.defines"
    If "pdftex" = BASEFILE | "omega" = BASEFILE Then
      MORE_DEFINES = MORE_DEFINES SRCDIR"/"BASEFILE"dir/"BASEFILE".defines"
    WEB2C_OPTIONS = "-t -c"BASEFILE"coerce"
    HFILE = "texmfmp.h"
    FIXWRITES_OPTIONS = "-t"
    POSTCMD = "web2c/splitup" BASEFILE "< temp.post"
    CFILE = BASEFILE"2.c" /* last output file, or thereabouts */
    OUTPUT = ""
    OUTPUT_FILES = BASEFILE"?.c" BASEFILE"ini.c" BASEFILE"d.h"
    OUTPUT_FILES = OUTPUT_FILES BASEFILE"coerce.h"
  End

  Otherwise Do
    /* ARexx needs a `default' label, but this isn't used here. */
  End
END

/*
 * Do it.
 */
type SRCDIR"/web2c/common.defines > temp.pre"
type MORE_DEFINES PASCALFILE ">> temp.pre"
PRECMD /* convert `temp.pre' to `temp.web2c' somehow */
delete "temp.pre quiet"
"web2c/web2c -h"HFILE WEB2C_OPTIONS "< temp.web2c > temp.mid"
delete "temp.web2c quiet"
MIDCMD /* convert `temp.mid' to `temp.fixwrites' somehow */
delete "temp.mid quiet"
"web2c/fixwrites" FIXWRITES_OPTIONS BASEFILE "< temp.fixwrites > temp.post"
delete "temp.fixwrites quiet"
POSTCMD /* convert `temp.post' to the final OUTPUT somehow */
delete "temp.post quiet"

/*
 * The Amiga does not provide a decent pipe mechanism, so the comment of
 * the UNIX sh-script is of little use here.  Anyway, we check if the
 * final CFILE is either empty or contains the error marker we put in.
 */
If Open('C_FILE',CFILE,"Read") Then Do
  DUMMY = ReadCh('C_FILE',1)
  C_FILE_EMPTY = EOF('C_FILE') /* Hope this is `0'! */
  DUMMY = Close('C_FILE')
End
Else
  C_FILE_EMPTY = 1

grep "@error@" OUTPUT_FILES "> grep.out"

If Open('GREP_OUT',"grep.out","Read") Then Do
  DUMMY = ReadCh('GREP_OUT',1)
  GREP_ERROR = EOF('GREP_OUT') /* Pray this is `1'! */
  DUMMY = Close('GREP_OUT')
  delete "grep.out quiet"
End
Else
  GREP_ERROR = 0

If C_FILE_EMPTY | ~GREP_ERROR Then Do
  TMPDIR = "T:"
  /* Don't just delete it, since it may be useful for debugging. */
  Say "rx convert: conversion of "PASCALFILE" failed, moving dregs:"
  CMD = "copy "OUTPUT_FILES TMPDIR
  Say "rx convert: "CMD
  CMD "quiet"
  CMD = "delete "OUTPUT_FILES
  Say "rx convert: "CMD
  CMD "quiet"
  Exit 1
End

Select
  When "bibtex" = BASEFILE Then Do
    'sed -e "s/(buftype)//g" -e "s/(pdstype)//g" <bibtex.h >xbibtex.h'
    copy "xbibtex.h bibtex.h quiet"
    delete "xbibtex.h quiet"
  End

  When "mf" = BASEFILE | "mp" = BASEFILE Then Do
    wait 2 /* so timestamps are definitely later, to avoid make weirdness */
    type BASEFILE"coerce.h" SRCDIR"/web2c/coerce.mf > x"BASEFILE"coerce.h"
    copy "x"BASEFILE"coerce.h" BASEFILE"coerce.h quiet"
    delete "x"BASEFILE"coerce.h quiet"
    touch BASEFILE"d.h"
  End

  When "tex" = BASEFILE | "etex" = BASEFILE | "pdftex" = BASEFILE | "omega" = BASEFILE Then Do
    wait 2
    type BASEFILE"coerce.h" SRCDIR"/web2c/coerce.tex > x"BASEFILE"coerce.h"
    copy "x"BASEFILE"coerce.h" BASEFILE"coerce.h quiet"
    delete "x"BASEFILE"coerce.h quiet"
    touch BASEFILE"d.h"
  End

  Otherwise Do
  End
End

Exit 0
