/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_data_limits.h"
 *                                    created: 21/10/97 {1:00:56 pm} 
 *                                last update: 19/11/97 {1:59:04 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  21/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_data_limits_
#define _Cpptcl_cpptcl_data_limits_
 
class tcl_object;

//@Section: Cpptcl library
///
template <class T>
class limit_ {
  public:
    ///
    limit_(const char* i=0):_items(i){}
    ///
    virtual ~limit_(void) {}
    ///
    virtual T value(const tcl_object* read_from) const=0;
    ///
    bool itemised(void) const { return (_items ? true : false );}
    ///
    const char* items(void) const {return _items;}
  private:
    ///
    const char* _items;
};
  
//@Section: Cpptcl library
///
template <class T>
class limit_fixed: public limit_<T> {
	public:	
	  ///
	  limit_fixed(T t, const char* i=0):limit_<T>(i),_t(t){}
	  ~limit_fixed(void) {}
	  ///
	  T value(const tcl_object* /* read_from */) const {return _t;}
	private:
	  ///
	  T _t;
};
/*
//@Section: Cpptcl library
///
template <class T>
class limit_var: public limit_<T> {
	public:
	  ///
	  const bool itemised;
	  ///
	  limit_var(const char* _n);
	 ~limit_var(void) {}
	  ///
	  T value(const cpx_with_info* read_from) const;
	private:
	  ///
	  const char* _name;
};
*/
 
#endif
