/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "meta_object.cc"
 *                                    created: 25/10/97 {7:26:32 pm} 
 *                                last update: 16/12/97 {10:26:27 am} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "meta_object.h"
#include "tcl_object.h"
#include "cpptcl_init.h"

const Tcl_Obj* operator >> (const Tcl_Obj* o, member_reader& mem) {
	tcl_args_reader t(o);
	cpp_mem * i = mem.obj;
	t >> *i;
	return o;
}

tcl_args& object_reader::write(tcl_args& arg) {
	obj->tcl_command_entry_point(arg);
	return arg;
}

tcl_args& member_reader::write(tcl_args& arg) {
	if(obj->embedded()) {
		if (!container) {
			return arg;
		}
		arg.container = container;
	}
	obj->parse_tcl_command(arg);
	return arg;
}

tcl_args& config_opt::write(tcl_args& arg) {
	if(obj->embedded()) {
		if (!container) {
			return arg;
		}
		arg.container = container;
	}
	obj->configure_member(arg);
	return arg;
}

tcl_args& meta_reader::write(tcl_args& arg) {
	return arg;
}

tcl_args& member_reader::read_name(tcl_args& arg) {
	obj = (cpp_mem*) container->configuration_option(arg,
							container->meta_info(),required->type);
	if(!obj)
		arg.no_match();
	return arg;
}

tcl_args& object_reader::read_name(tcl_args& arg) {
	// we pretend it's a type, since that's what we read
	// from the command line, although in fact we find an
	// 'meta_object' straightaway.
	arg.set_conversion_type(type());
	CHECK_ARGS(arg);
	tcl_interaction* t = Cpptcl_ConvertToTypedObject(arg,arg[0],required);
	if(t) {
		obj = t;
		arg.parsed_so_far << t;
	} else {
		arg.signal_error(tcl_args::Conversion);
	}
	arg.read_done();
	return arg;
}
tcl_args& meta_reader::read_name(tcl_args& arg) {
	// we pretend it's a type, since that's what we read
	// from the command line, although in fact we find an
	// 'meta_object' straightaway.
	arg.set_conversion_type(type());
	const char* t;
	arg.const_string_read(t);
	if(t){
		const meta_object* i = tcl_base::metaobject->find_meta_info(t,required);
		if(i) {
			meta = i;
			arg.parsed_so_far << t;
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}

