/* This file was changed from original MYASSIST.E                        */
/* by Vladimir Kisil on 26.01.98 in order to fit TeX needs               */
/* I was using advises of Petr Mikulik                                   */
/**************************************************************************/
/*                 E3/EOS2/EPM Syntax Assistance Version 2.0              */
/*                   Sven Guyet, 03/92  (DSGUYE at DUESVM1)               */
/**************************************************************************/
/* See MYASSIST.DOC for detailed informations.                            */
/*                                                                        */
/* To include MYASSIST into your E configuration copy the following       */
/* 5 lines to your MYKEYS.E (or MYSTUFF.E) file:                          */
/*         compile if defined (WANT_MY_ASSIST)                            */
/*            compile if WANT_MY_ASSIST                                   */
/*               include 'myassist.e'                                     */
/*            compile endif                                               */
/*         compile endif                                                  */
/*                                                                        */
/* Copy the following 2 lines to your MYCNF.E:                            */
/*         const                                                          */
/*            WANT_MY_ASSIST = 1                                          */
/*                                                                        */
/* Now, if you wish to leave out MYASSIST temporarily, you can simply     */
/* set WANT_MY_ASSIST to 0 in your MYCNF.E, and it will be omitted.       */
/*                                                                        */
/* To get syntax assistance, type the abbreviated keyword and press ALT-H.*/
/* The cursor position must be WITHIN or ON ONE OF THE BLANKS AFTER       */
/* the desired keyword prior pressing ALT-H.                              */
/*                                                                        */
/* To change the default syntax assistance filename, type 'sf' or         */
/* 'syntaxfile' followed by the new filename at the command line.         */
/*                                                                        */
/* To get information about the default syntax assistance filename, type  */
/* 'sf' or 'syntaxfile' without any parameters at the command line.       */
/**************************************************************************/

; Code starts here

/* Start addition by VK & PM */

tryinclude 'mycnf.e'

compile if not defined(TEX_EXTENSIONS)
   TEX_FILETYPES  = 'TEX LATEX STY CLS DTX'
   TEX_EXTENSIONS = 'TEX LATEX STY CLS DTX'
compile endif

/* End addition by VK & PM */

definit
   universal ACTUAL_FILE_NAME,SYNTAX_FILE_NAME,svensinfo,synfile
   svensinfo='SVENs_E_assistant 2.0.t: '
   ACTUAL_FILE_NAME=''            /* Initialize syntax assistance filename*/
   synfile  =''
   compile if defined(my_syntax_filename)
      SYNTAX_FILE_NAME = upcase(my_syntax_filename)
   compile else
      SYNTAX_FILE_NAME = 'MYSYNTAX.ASI'
   compile endif /* SYNTAX_FILE_NAME */

defc sf, syntaxfile =
   universal SYNTAX_FILE_NAME,svensinfo,synfile
   uparg=upcase(arg(1))
   call mysfquit()                /* Quit actual syntax assistance file    */
   if uparg <>'' then             /* Set new default syntax assistance file*/
      SYNTAX_FILE_NAME = uparg
   endif
   sayerror svensinfo'Default syntax file name is 'SYNTAX_FILE_NAME''

def a_h =                         /* ALT-H is normally not defined in E    */
compile if EVERSION > 5           /* and can easily be remembered as       */
    if .line then                 /* "alternative help"                    */
compile else
    if .line and (not command_state()) then
compile endif
       call myassist()
    endif

defproc mysfquit
   universal synfile
   if synfile<>'' then
      GETFILEID curfile
      ACTIVATEFILE synfile; GETFILEID synfile
      if synfile<>curfile then
         'quit'
      endif
      synfile=''
      ACTIVATEFILE curfile
   endif
   return

defproc myassist
   universal ACTUAL_FILE_NAME,SYNTAX_FILE_NAME,svensinfo,synfile
   GETFILEID curfile
   if synfile <> '' then
      ACTIVATEFILE synfile; GETFILEID synfile
      if synfile=curfile then
         synfile=''
      endif
      ACTIVATEFILE curfile
   endif

   ext = filetype()               /* Get file type (file name extension)   */
   if (wordpos(filetype(), TEX_EXTENSIONS)) then    /* added by VK&PM */
       ext='tex'
   endif
   sfile = 'MYAS_'ext'.ASI'       /* Set corresponding syntax file name    */
   if ACTUAL_FILE_NAME <> sfile then
      compile if EVERSION > 4     /* Look for the syntax file              */
         findfile newsynfile, sfile, '','D'
      compile else
         findfile newsynfile, sfile,EPATH
      compile endif
      if rc then                  /* If all that fails, try standard path  */
         findfile newsynfile, sfile, 'PATH'
      endif
      if not rc then              /* New file found: quit current file     */
         call mysfquit()
         ACTUAL_FILE_NAME = sfile
      else                        /* New file not found: set default file  */
         if ACTUAL_FILE_NAME <> SYNTAX_FILE_NAME then
            call mysfquit()
            ACTUAL_FILE_NAME = SYNTAX_FILE_NAME
         endif
      endif
   endif

   if synfile = '' then           /* Syntax assistance file not yet active,*/
      compile if EVERSION > 4     /* so load it now                        */
         findfile synfile, ACTUAL_FILE_NAME, '','D'
      compile else
         findfile synfile, ACTUAL_FILE_NAME,EPATH
      compile endif
      if rc then                  /* If all that fails, try standard path  */
         findfile synfile, ACTUAL_FILE_NAME, 'PATH'
         if rc then
            synfile=''
            sayerror svensinfo'ERROR: Syntax file 'ACTUAL_FILE_NAME' not found'
            return
         endif
      endif
compile if EVERSION < 5           /* Load E syntax assistance file into    */
      'e /h 'synfile              /* the hidden ring (user shouldn't see it*/
compile else                      /* during a normal E session!!!)         */
      'e 'synfile                 /* EPM doesn't have a /H option;         */
      .visible = 0                /* instead, set .visible off             */
compile endif
      if rc then
         synfile=''
         sayerror svensinfo'ERROR: Syntax file can not be loaded; enough memory?'
         return
      endif
      GETFILEID synfile,ACTUAL_FILE_NAME
      ACTIVATEFILE curfile
   endif

   if curfile = synfile then
      sayerror svensinfo'ERROR: Syntax assistance denied within E syntax file'
      return
   endif
   curcol=.col      /* Added by VK; take cursor position */
   call psave_pos(savepos)                   /* Save the cursor position   */
/* Four lines commented by VK; we need for TeX that any non-alphabetical 
character will be a delimiter for abbreviation */
--   call pbegin_word()                        /* Get search word       */
--   wleft=.col
--  call pend_word()
--   wright=.col+1
   curline=.line 
   getline line
/* Here we add an alternative search procedure. VK */
   wright=lastpos(':a',line,curcol,'x')
   wright=pos('~:a',line,wright,'x')
   wleft=lastpos('~:a',line,wright-1,'x')+1
   if wright==0 then
      wright= length(line)
   endif
/* End of addition. VK */
   lineleft =substr(line,1,wleft-1)          /* Save first part of line  */
   blanks   =substr(' ',1,wleft-1)
   searchwrd=substr(line,wleft,wright-wleft) /* Save search word           */
   linerest =substr(line,wright)             /* Save rest of the line      */
   if searchwrd  = ' ' then
      sayerror svensinfo'ERROR: No search word encountered'
      call prestore_pos(savepos)             /* Restore the user's mark    */
      return
   endif

   sayerror svensinfo'searching ...'
   call psave_mark(savemark)                 /* Save the user's mark       */
compile if EVERSION > 4
   getsearch savesearch /* Save the user's search string, so c_F will work */
compile endif
compile if EVERSION > 5
   display -2                   /* Don't want to see "Not found" messages  */
compile endif
   start      = 1
   hits       = 0
   searchstep = 1
   ACTIVATEFILE synfile; TOP; begin_line
   /* Look for first presence of search word with explanation in the same  */
   /* line (append a blank character to the search word).                  */
   call pset_mark(1,.last,1,length(searchwrd)+1,'BLOCK',synfile)
   'xcom l 'searchwrd'  cm'
   if rc then
      searchstep = 2
      TOP; begin_line
      /* Look for first presence of search word with explanation in a      */
      /* following line.                                                   */
       call pset_mark(1,.last,1,length(searchwrd),'BLOCK',synfile)
      'xcom l 'searchwrd' cm'
   endif

   while not rc do
      if searchstep = 2 then
         while not rc do
            getline line,.line,synfile
            if upcase(line) = upcase(searchwrd) then
               leave
            else
               REPEATFIND
            endif
         endwhile
         if rc then
            leave
         endif
      endif

      loop
         tab_word                   /* Move to the second word of the line */
         getline line,.line,synfile /* Get the contents of the line        */
         if upcase(line) = upcase(searchwrd) then
            if .line >= .last then
compile if EVERSION > 5
               display 2       /* Restore display of non-critical errors   */
compile endif
               sayerror svensinfo'ERROR: Blank definition line encountered for 'searchwrd''
               ACTIVATEFILE curfile
compile if EVERSION > 4                /* Restore the user's search        */
               setsearch savesearch    /* string, so c_F will work         */
compile endif
               call prestore_mark(savemark) /* Restore the user's mark     */
               call prestore_pos(savepos)   /* Restore the cursor position */
               return
            endif
            .line = .line+1
            .col = 1
         else
            leave
         endif
      endloop

      hits     = hits+1
      syncol   = .col
      synspace = substr(' ',1,syncol-1) /* Get the indentation             */
      syntax   = substr(line,syncol)    /* Get the description             */
      synline  = .line
      curscol  = 0
      cursrow  = 0
      go_on    = 1
      while go_on do
         go_on = 0; nextsyntax = ''; lineright=linerest
         if synline < .last then
            synline = synline+1   /* Examine whether the next lines belong */
            getline line,synline  /* to the same description               */
            if substr(line,1,syncol-1) = synspace then /* Ok, save the     */
               nextsyntax = substr(line,syncol)        /* description      */
               lineright  = ''
               go_on    = 1
            endif
         endif
         ACTIVATEFILE curfile
         marker = POS('',syntax)
         if marker > 0 then
            syntax  = SUBSTR(syntax,1,marker-1) || SUBSTR(syntax,marker+1)
            curscol = LENGTH(blanks)+marker
            cursrow = curline
         endif
         if start then
            replaceline lineleft||syntax||lineright
            start = 0
         else
            insertline blanks||syntax||lineright,curline
         endif
         syntax   = nextsyntax
         curline  = curline+1
         ACTIVATEFILE synfile
      endwhile

      lineleft = blanks
      linerest = ''

      if hits=1 then lastline=curline-1; endif  /* Save end of first hit   */
      REPEATFIND
      if rc then
         if searchstep = 1 then
            searchstep = 2
            TOP; begin_line
            /* Look for first presence of search word                      */
            call pset_mark(1,.last,1,length(searchwrd),'BLOCK',synfile)
            'xcom l 'searchwrd' cm'
         endif
      endif
   endwhile

compile if EVERSION > 4           /* Restore the user's search string,     */
   setsearch savesearch           /* so c_F will work                      */
compile endif

compile if EVERSION > 5
   display 2                   /* Restore display of non-critical errors   */
compile endif
   call prestore_mark(savemark)             /* Restore the user's mark     */

   ACTIVATEFILE curfile
   if not hits then
      sayerror svensinfo'No syntax definition found for 'searchwrd''
      call prestore_pos(savepos)            /* Restore the cursor position */
   else
      sayerror svensinfo'E syntax assistance executed for 'searchwrd''
      if curscol > 0 then
         .col  = curscol       /* If marker was found within replacement   */
         .line = cursrow       /* string, position the cursor              */
         if not INSERTSTATE() then
            INSERTTOGGLE
         endif
      else
         .line = lastline; end_line  /* otherwise, position at the end     */
      endif
   endif

   return
