:
#set -ex
set -ex

if [ "x$VNDEVICE" = "x" ] ; then
	VNDEVICE=vn0
fi
export BLOCKSIZE=512

if [ "$1" = "-s" ]; then
	do_size="yes"; shift
else
	do_size=""
fi

FSIMG=$1; shift
RD=$1 ; shift
MNT=$1 ; shift
FSSIZE=$1 ; shift
FSPROTO=$1 ; shift
FSINODE=$1 ; shift
FSLABEL=$1 ; shift

deadlock=20

while true 
do
	rm -f ${FSIMG}

	if [ ! -b /dev/${VNDEVICE} -o ! -c /dev/r${VNDEVICE} ] ; then 
		( cd /dev && sh MAKEDEV ${VNDEVICE} )
	fi

	umount /dev/${VNDEVICE} 2>/dev/null || true

	umount ${MNT} 2>/dev/null || true

	vnconfig -u /dev/r${VNDEVICE} 2>/dev/null || true

	dd of=${FSIMG} if=/dev/zero count=${FSSIZE} bs=1k 2>/dev/null
	# this suppresses the `invalid primary partition table: no magic'
	awk 'BEGIN {printf "%c%c", 85, 170}' |\
	    dd of=${FSIMG} obs=1 seek=510 conv=notrunc 2>/dev/null

#	vnconfig -s labels -c /dev/r${VNDEVICE} ${FSIMG}
	vnconfig -r labels -c /dev/r${VNDEVICE} ${FSIMG}

	#sed '/^minimum:/,$d' /etc/disktab > /etc/disktab.tmp
	sed '/^minimum:/,/^$/d' /etc/disktab > /etc/disktab.tmp
	cat /etc/disktab.tmp > /etc/disktab
	rm -f /etc/disktab.tmp
	(
	a=`expr ${FSSIZE} \* 2`
	echo 
	echo "minimum:ty=mfs:se#512:nt#1:rm#300:\\"
	#echo "	:ns#$a:nc#1:\\"
	echo "	:ns#$a:nc#1:sb#512:\\"
	echo "	:pa#$a:oa#0:ba#4096:fa#512:\\"
	echo "	:pc#$a:oc#0:bc#4096:fc#512:"
	echo
	) >> /etc/disktab

	#disklabel -Brw /dev/r${VNDEVICE} ${FSLABEL}	# 3.1
	disklabel -Brw -b ${RD}/trees/98bin/boot/boot1 \
		-s ${RD}/trees/98bin/boot/boot2 /dev/r${VNDEVICE} ${FSLABEL}

	#if [ -x /sbin/newfs.228 ]; then
	#    #/sbin/newfs.228 -i ${FSINODE} -T ${FSLABEL} -o space /dev/r${VNDEVICE}c
	#    /sbin/newfs.228 -i ${FSINODE} -T ${FSLABEL} -m 0 -p 0 -x 0 -o space /dev/r${VNDEVICE}c
	#else
	    newfs -i ${FSINODE} -T ${FSLABEL} -o space /dev/r${VNDEVICE}c
	#fi

	mount /dev/${VNDEVICE}c ${MNT}

	if [ -d ${FSPROTO} ]; then
		(set -e && cd ${FSPROTO} && find . -print | cpio -dump ${MNT})
	else
		cp -p ${FSPROTO} ${MNT}
	fi

	df -ki ${MNT}

	set `df -ki ${MNT} | tail -1`

	umount ${MNT}
	vnconfig -u /dev/r${VNDEVICE} 2>/dev/null || true

	echo ">>> Filesystem is ${FSSIZE} K, $4 left"
	echo ">>>     ${FSINODE} bytes/inode, $7 left"
	if [ "${do_size}" ]; then
		echo ${FSSIZE} > ${FSIMG}.size
	fi
	break;
done
