/*
 * The new sysinstall program.
 *
 * This is probably the last attempt in the `sysinstall' line, the next
 * generation being slated for what's essentially a complete rewrite.
 *
 * $FreeBSD: src/release/sysinstall/doc.c,v 1.23.2.4 1999/12/19 22:28:53 jkh Exp $
 *
 * Copyright (c) 1995
 *	Jordan Hubbard.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    verbatim and that no modifications are made prior to this
 *    point in the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JORDAN HUBBARD ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JORDAN HUBBARD OR HIS PETS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, LIFE OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.

 *
 */

#include "sysinstall.h"

/*
 * This is called from the main menu.  Try to find a copy of Lynx from somewhere
 * and fire it up on the first copy of the handbook we can find.
 */
int
docBrowser(dialogMenuItem *self)
{
    int ret;
    char *browser = variable_get(VAR_BROWSER_PACKAGE);

    if (RunningAsInit && !strstr(variable_get(SYSTEM_STATE), "install")) {
	KANJI_MESSAGE("ߤޤ! Υץ, ƥΥ󥹥ȡ봰λΤ߻Ѥ\n"
	"ޤ.");
	msgConfirm(KM("This option may only be used after the system is installed, sorry!"));
	return DITEM_FAILURE;
    }

    /* First, make sure we have whatever browser we've chosen is here */
    if (!package_exists(browser)) {
	ret = package_add(browser);
    	if (DITEM_STATUS(ret) != DITEM_SUCCESS) {
	    KANJI_MESSAGE("%s HTML ֥饦ѥå򥤥󥹥ȡޤ.\n"
	    "ǥꤵƤ뤫ΤƤ, ƻԤƤ.");
	    msgConfirm(KM("Unable to install the %s HTML browser package.  You may\n"
		       "wish to verify that your media is configured correctly and\n"
		       "try again."), browser);
	    return ret;
	}
    }

    if (!file_executable(variable_get(VAR_BROWSER_BINARY))) {
	KANJI_MESSAGE("%s ѥå򥤥󥹥ȡ뤷ϤǤ\n"
	"%s ˥Хʥ꤬Ĥ\n"
	"ޤ! ѥåɤƤ (ǥ˥塼򻲾) Ѥ\n"
	"ƻ, Ѳ뤫Ĵ٤Ʋ.\n\n"
	"󥹥ȡ뤬ǤƤʤ褦ʤΤ, ǤŸƤС\n"
	"õ뤳Ȥ򤪴ᤷޤ. Ԥʤäƹޤ?");
	if (!msgYesNo(KM("Hmmm.  The %s package claims to have installed, but I can't\n"
		      "find its binary in %s!  You may wish to try a different\n"
		      "location to load the package from (go to Media menu) and see if that\n"
		      "makes a difference.\n\n"
		      "I suggest that we remove the version that was extracted since it does\n"
		      "not appear to be correct.   Would you like me to do that now?"),
		      browser, variable_get(VAR_BROWSER_BINARY)))
	    vsystem("pkg_delete %s %s", !strcmp(variable_get(VAR_CPIO_VERBOSITY), "high") ? "-v" : "", browser);
	return DITEM_FAILURE;
    }

    /* Run browser on the appropriate doc */
    if (dmenuOpenSimple(&MenuHTMLDoc, FALSE))
	return DITEM_SUCCESS;
    else
	return DITEM_FAILURE;
}

/* Try to show one of the documents requested from the HTML doc menu */
int
docShowDocument(dialogMenuItem *self)
{
    char tmp[512], target[512];
    char *where = NULL;
    char *browser = variable_get(VAR_BROWSER_BINARY);
    char *str = self->prompt;
#ifdef	DOCJP
    int ret;
    int docjp = 0;
    char *jphandbook = variable_get(VAR_JPHB_PKG);
#endif	/* DOCJP */

    if (!file_executable(browser)) {
	KANJI_MESSAGE("%s ˥֥饦Ĥޤ!\n"
	"ץ󥨥ǥåȤǧƤ.");
	msgConfirm(KM("Can't find the browser in %s!  Please ensure that it's\n"
		   "properly set in the Options editor."), browser);
	return DITEM_FAILURE;
    }
    if (!strstr(str, "Home"))
	where = "http://www.freebsd.org";
    else if (!strstr(str, "Other")) {
	KANJI_MESSAGE("ɤߤ URL ϤƤ.");
	where = msgGetInput("http://www.freebsd.org", KM("Please enter the URL of the location you wish to visit."));
    }
    else if (!strstr(str, "FAQ")) {
	strcpy(target, "/usr/share/doc/faq/index.html");
	if (!file_readable(target))
	    strcpy(target, "http://www.freebsd.org/FAQ");
	where = target;
    }
    else if (!strcmp(str, "Handbook")) {
	strcpy(target, "/usr/share/doc/handbook/index.html");
	if (!file_readable(target))
	    strcpy(target, "http://www.freebsd.org/handbook");
	where = target;
    }
#ifdef	DOCJP
    else if (language == LANG_JAPANESE && !strcmp(str, "JP-Handbook")) {
	if (!package_exists(jphandbook)) {
	    ret = package_add(jphandbook);
	    if (DITEM_STATUS(ret) != DITEM_SUCCESS) {
		KANJI_MESSAGE("%s ѥå򥤥󥹥ȡޤ.\n"
		"ǥꤵƤ뤫ΤƤ, ƻԤƤ.");
		msgConfirm(KM("Unable to install the %s package.  You may\n"
			   "wish to verify that your media is configured correctly and\n"
			   "try again."), jphandbook);
		return ret;
	    }
	}
	strcpy(target, variable_get(VAR_JPHB_PATH));
	strcat(target, "/handbook.html");
	if (!file_readable(target))
	    strcpy(target, "http://www.jp.freebsd.org/");
	where = target;
    }
    docjp = 1;
#endif
    if (where) {
#ifdef	DOCJP
	if (docjp) {
	    sprintf(tmp, "echo \"character_set=Japanese (EUC)\" > /usr/share/doc/ja_JP.EUC/handbook/.lynxrc ; HOME=/usr/share/doc/ja_JP.EUC/handbook; export HOME ; cd $HOME; %s %s", browser, where);
	}
	else {
	    sprintf(tmp, "%s %s", browser, where);
	}
#else
	sprintf(tmp, "%s %s", browser, where);
#endif
	systemExecute(tmp);
	return DITEM_SUCCESS;
    }
    else {
	KANJI_MESSAGE("ʤʸ˥ޤ! bin ۥե\n"
	"ɤƤޤ? ͥåȥˤĤʤäƤޤ?");
	msgConfirm(KM("Hmmmmm!  I can't seem to access the documentation you selected!\n"
		   "Have you loaded the bin distribution?  Is your network connected?"));
	return DITEM_FAILURE;
    }
}
