/*
 * The new sysinstall program.
 *
 * This is probably the last program in the `sysinstall' line - the next
 * generation being essentially a complete rewrite.
 *
 * $FreeBSD: src/release/sysinstall/menus.c,v 1.180.2.43 1999/12/22 01:49:08 jkh Exp $
 *
 * Copyright (c) 1995
 *	Jordan Hubbard.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    verbatim and that no modifications are made prior to this
 *    point in the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JORDAN HUBBARD ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JORDAN HUBBARD OR HIS PETS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, LIFE OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/* All the system menus go here.
 *
 * Hardcoded things like version number strings will disappear from
 * these menus just as soon as I add the code for doing inline variable
 * expansion.
 */
#ifdef KANJI_ONLY
#define MenuIndex_j		MenuIndex
#define MenuInitial_j		MenuInitial
#define MenuDocumentation_j	MenuDocumentation
#define MenuMouseType_j		MenuMouseType
#define MenuMousePort_j		MenuMousePort
#define MenuMouse_j		MenuMouse
#define	MenuXF86Config_j	MenuXF86Config
#define MenuXDesktops_j		MenuXDesktops
#define MenuMediaCDROM_j	MenuMediaCDROM
#define MenuMediaFloppy_j	MenuMediaFloppy
#define MenuMediaDOS_j		MenuMediaDOS
#define MenuMediaFTP_j		MenuMediaFTP
#define MenuMediaTape_j		MenuMediaTape
#define MenuNetworkDevice_j	MenuNetworkDevice
#define MenuMedia_j		MenuMedia
#define MenuDistributions_j	MenuDistributions
#define MenuSubDistributions_j	MenuSubDistributions
#define MenuDESDistributions_j	MenuDESDistributions
#define MenuSrcDistributions_j	MenuSrcDistributions
#define Menu98SrcDistributions_j	Menu98SrcDistributions
#define MenuXF86Select_j	MenuXF86Select
#define MenuXF86SelectCore_j	MenuXF86SelectCore
#define MenuXF86SelectFonts_j	MenuXF86SelectFonts
#define MenuXF86SelectServer_j	MenuXF86SelectServer
#define	MenuXF86SelectPC98Server_j	MenuXF86SelectPC98Server
#define MenuDiskDevices_j	MenuDiskDevices
#define MenuHTMLDoc_j		MenuHTMLDoc
#define MenuInstallCustom_j	MenuInstallCustom
#ifndef PC98
#define MenuMBRType_j		MenuMBRType
#endif
#define MenuConfigure_j		MenuConfigure
#define MenuStartup_j		MenuStartup
#define MenuNetworking_j	MenuNetworking
#define MenuNTP_j		MenuNTP
#define MenuSyscons_j		MenuSyscons
#ifndef PC98
#define MenuSysconsKeymap_j	MenuSysconsKeymap
#define MenuSysconsKeyrate_j	MenuSysconsKeyrate
#endif
#define MenuSysconsSaver_j	MenuSysconsSaver
#define MenuSysconsScrnmap_j	/* */
#define MenuSysconsFont_j	/* */
#define MenuUsermgmt_j		MenuUsermgmt
#define MenuInstKbd_j		/* */
#define MenuFixit_j		MenuFixit
#ifdef PCCARD
#define MenuPCCardBeep_j	MenuPCCardBeep
#define MenuPCCardEther_j	MenuPCCardEther
#define MenuPCICMem_j		MenuPCICMem
#ifdef USERCONFIG_IGNIRQ
#define MenuCardIgnoreIRQ_j	MenuCardIgnoreIRQ
#else
#define MenuCardIRQ_j		MenuCardIRQ
#endif 
#endif /* PCCARD */
#endif	/* KANJI_ONLY */

/*  "....+....1....+....2....+....3....+....4....+....5....+....6....+....7\n" */

DMenu MenuIndex_j = {
    DMENU_NORMAL_TYPE,
    /* "ǽκ", */
    "̥ޥɰ",

#ifdef PC98
"Υ˥塼ϤΥץ (sysinstall) Υȥåץ٥εǽ, ե
٥åȽǺˤΤǤ. [RETURN] ǥץưǤޤ. κ
ڡȴ, [TAB-RETURN] ǥ󥻥򤹤뤳Ȥǽλ
뤳ȤǤޤ.",

"ROLL UP  ROLL DOWN Ȥ᤯ư뤳ȤǤޤ!",
#else
"Υ˥塼ϤΥץ (sysinstall) Υȥåץ٥εǽ, ե
٥åȽǺˤΤǤ. [ENTER] ǥץưǤޤ. κ
ڡȴ, [TAB-ENTER] ǥ󥻥򤹤뤳Ȥǽλ
뤳ȤǤޤ.",

"PageUp  PageDown Ȥ᤯ư뤳ȤǤޤ!",
#endif

    NULL,
    { 
      { "A ƿ̾ FTP",		"Anonymous FTP ꤹ",	dmenuVarCheck, configAnonFTP, NULL, "anon_ftp" },
      { "C ߥå",		"ڥǥ󥰤Ƥ¹Ԥ (!)", NULL, installCustomCommit },
      { "C 󥽡",	"ƥॳ󥽡ư򥫥ޥ", NULL, dmenuSubmenu, NULL, &MenuSyscons },
      { "C ",		"ƥ˥塼",		NULL, dmenuSubmenu, NULL, &MenuConfigure },
      { "D ǥХ,ޥ",	"ޥ˥塼",		NULL, dmenuSubmenu, NULL, &MenuMouse },
      { "D ǥեȤΥ",	"ǥեȤ",	NULL, dispatch_load_floppy },
      { "D ǥ٥",	"ǥΥ٥롦ǥ",	NULL, diskLabelEditor },
      { "D ۥե,",	"ۥեΥ롼",		NULL, dmenuSubmenu, NULL, &MenuDistributions },
      { "D ۥե,",	"FreeBSD ۥ˥塼",	NULL, dmenuSubmenu, NULL, &MenuSubDistributions },
      { "D ۥե,DES",	"DES ۥ˥塼",		NULL, dmenuSubmenu, NULL, &MenuDESDistributions },
      { "D ۥե,ȯ", "ȯۥե", checkDistDeveloper, distSetDeveloper },
      { "D ۥե,src",	"Src ۥեΥ˥塼",	NULL, dmenuSubmenu, NULL, &MenuSrcDistributions },
#if defined(PC98) && defined(PC98SRC)
      { "D ۥե,98src",	"98src ۥեΥ˥塼",	NULL, dmenuSubmenu, NULL, &Menu98SrcDistributions },
#endif /* defined(PC98) && defined(PC98SRC) */
      { "D ۥե,X ȯ", "X ȯۥե",	checkDistXDeveloper, distSetXDeveloper },
      { "D ۥե,ͥ", "ͥ볫ȯۥե", checkDistKernDeveloper, distSetKernDeveloper },
      { "D ۥե,桼", "ʿŪ桼ۥե", checkDistUser, distSetUser },
      { "D ۥե,X 桼", "X 桼ۥե",	checkDistXUser, distSetXUser },
      { "D ۥե, ɲ", "ɲäʪ򥤥󥹥ȡ",	NULL, distExtractAll },
      { "D ۥե,XFree86", "XFree86 ۥ˥塼",	NULL, distSetXF86 },
      { "D ʸ",		"󥹥ȡβ, README, ¾", NULL, dmenuSubmenu, NULL, &MenuDocumentation },
      { "D ʸ,README",	"README ե",		NULL, dmenuDisplayFile, NULL, "readme" },
#ifdef PC98
      { "D ʸ,󥹥ȡ 98", "FreeBSD(98) 󥹥ȡ륬", NULL, dmenuDisplayFile, NULL, "install.98" },
#else
      { "D ʸ,ϡɥ",	"ϡɥ",		NULL, dmenuDisplayFile, NULL, "hardware" },	/* Upper ? */
      { "D ʸ,󥹥ȡ",	"󥹥ȡ륬",	NULL, dmenuDisplayFile, NULL, "install" },	/* Upper ? */
#endif
      { "D ʸ,",	"˴ؤ",	NULL, dmenuDisplayFile, NULL, "COPYRIGHT" },
      { "D ʸ,꡼",	"꡼Ρ",	NULL, dmenuDisplayFile, NULL, "relnotes" },	/* Upper ? */
#ifdef PC98
      { "D ʸ, 98",	"FreeBSD(98) ˴ؤ",	NULL, dmenuDisplayFile, NULL, "Copyright.98" },
      { "D ʸ,꡼ 98",	"FreeBSD(98) ꡼Ρ",		NULL, dmenuDisplayFile, NULL, "Relnote.98" },
#endif
      { "D ʸ,HTML",		"HTML ʸ˥塼",	NULL, docBrowser },
#ifdef PCCARD
      { "D ʸ,PC-card",	"PC-card (PAO package) 󥹥ȡ륬", NULL, dmenuDisplayFile, NULL, "pccard" },	/* Upper ? */
#endif	/* PCCARD */
      { "D ѿ",		"(ǥХå) ʥѿפ.", NULL, dump_variables },
      { "E ۵ѥ",	"۵ѤΥۥեåư.",	NULL, installFixitHoloShell },
#ifdef __i386__
      { "F Fdisk",		"ǥΥѡƥ󡦥ǥ",	NULL, diskPartitionEditor },
#endif
      { "F Fixit",		"CDROM ޤϥեåԡν⡼.",	NULL, dmenuSubmenu, NULL, &MenuFixit },
      { "F FTP ",		"FTP ߥ顼ȤΥꥹ",		NULL, dmenuSubmenu, NULL, &MenuMediaFTP },
      { "G ȥ",	"󥿡ե֤ΥѥåȤž", dmenuVarCheck, dmenuToggleVariable, NULL, "gateway=YES" },
      { "H ʸ,HTML",		"HTML ʸ˥塼",	NULL, docBrowser },
      { "I 󥹥ȡ,鿴",	"鿴ѥƥ।󥹥ȡ",	NULL, installNovice },
      { "I 󥹥ȡ,®",	"®󥹥ȡ",	NULL, installExpress },
      { "I 󥹥ȡ,",	"।󥹥ȡ˥塼",	NULL, dmenuSubmenu, NULL, &MenuInstallCustom },
      { "L ٥",		"ǥ٥륨ǥ",	NULL, diskLabelEditor },
      { "M ǥ",		"ȥåץ٥ǥ˥塼",	NULL, dmenuSubmenu, NULL, &MenuMedia },
      { "M ǥ,ơ",	"ơץ󥹥ȡǥ",	NULL, mediaSetTape },
      { "M ǥ,NFS",	"NFS 󥹥ȡǥ",	NULL, mediaSetNFS },
      { "M ǥ,եåԡ", "եåԡ󥹥ȡǥ",	NULL, mediaSetFloppy },
      { "M ǥ,CDROM",	"CDROM 󥹥ȡǥ",	NULL, mediaSetCDROM },
      { "M ǥ,DOS",	"DOS 󥹥ȡǥ",	NULL, mediaSetDOS },
      { "M ǥ,UFS",	"UFS 󥹥ȡǥ",	NULL, mediaSetUFS },
#ifdef UFS_MO
      { "M ǥ,UFS MO PDS", "UFS MO  PDS 󥹥ȡǥ",	NULL, mediaSetUFSMO },
#endif
      { "M ǥ,FTP",	"FTP 󥹥ȡǥ",	NULL, mediaSetFTP },
      { "M ǥ,FTP Passive", "Passive FTP 󥹥ȡǥ", NULL, mediaSetFTPPassive },
      { "N ͥåȥ󥿡", "ͥåȥ󥿡ե",	NULL, tcpMenuSelect },
      { "N ͥåȥӥ", "ͥåȥӥ˥塼",	NULL, dmenuSubmenu, NULL, &MenuNetworking },
      { "N NFS,饤",	"NFS 饤ȥե饰",		dmenuVarCheck, dmenuToggleVariable, NULL, "nfs_client=YES" },
      { "N NFS,",		"NFS Хե饰",			dmenuVarCheck, configNFSServer, NULL, "nfs_server_enable=YES" },
      { "N NTP ˥塼",	"NTP ˥塼",			NULL, dmenuSubmenu, NULL, &MenuNTP },
      { "O ץ",		"ץ󥨥ǥ",			NULL, optionsEditor },
      { "P ѥå",		"Packages 쥯",		NULL, configPackages },
      { "P ѡƥ",	"ǥ饤(PC-ѡƥ)ǥ",	NULL, diskPartitionEditor },
      /*			"ǥ饤(PC-ѡƥ)ǥ|X" <- ޤǤɽʤ */
      { "P PCNFSD",		"PC-NFS ǧڥФư",		dmenuVarCheck, configPCNFSD, NULL, "pcnfsd" },
      { "R Root ѥ",	"ƥѥѥɤ",	NULL, dmenuSystemCommand, NULL, "passwd root" },
      /* AT ܸǤΥåȰۤʤ */
      /* { "R Router",		"롼ƥ󥰥ǡ (ǥե: routed)", NULL, configRouter, NULL, "router" }, */
      { "R Router",		"롼ƥ󥰥ǡ (ά: routed)", NULL, configRouter, NULL, "router" },
      { "S Syscons",		"ƥॳ󥽡˥塼",	NULL, dmenuSubmenu, NULL, &MenuSyscons },
#ifndef PC98
      { "S Syscons,ե",	"󥽡륹꡼ե",	  NULL, dmenuSubmenu, NULL, &MenuSysconsFont },
      { "S Syscons,ޥå",	"󥽡륭ޥå˥塼",	NULL, dmenuSubmenu, NULL, &MenuSysconsKeymap },
      { "S Syscons,졼",	"󥽡륭졼˥塼",	NULL, dmenuSubmenu, NULL, &MenuSysconsKeyrate },
#endif
      { "S Syscons,",	"󥽡륹꡼󥻡˥塼", NULL, dmenuSubmenu, NULL, &MenuSysconsSaver },
#ifndef	PC98
      { "S Syscons, ꡼ޥå",	"󥽡륹꡼ޥå˥塼",	NULL, dmenuSubmenu, NULL, &MenuSysconsScrnmap },
#endif
      { "T ॾ",	"ƥΥॾ",		NULL, dmenuSystemCommand, NULL, "tzsetup" },
      { "U åץ졼",	"¸ƥΥåץ졼",		NULL, installUpgrade },
      { "U ˡ",		"å-˥塼ƥλˡ",	NULL, dmenuDisplayFile, NULL, "usage" },
      { "U 桼",		"桼ȥ롼׾ɲ",		NULL, dmenuSubmenu, NULL, &MenuUsermgmt },
      { "X XFree86,ե",	"XFree86 ե˥塼",		NULL, dmenuSubmenu, NULL, &MenuXF86SelectFonts },
      { "X XFree86,",	"XFree86 ˥塼",		NULL, dmenuSubmenu, NULL, &MenuXF86SelectServer },
#ifdef __i386__
      { "X XFree86,PC98",	"XFree86 PC98ѥ˥塼",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectPC98Server },
#endif
      { NULL } },
};


/* The initial installation menu */
DMenu MenuInitial_j = {
    DMENU_NORMAL_TYPE,
    "/stand/sysinstall Main Menu",			/* title */
#ifdef PC98
"FreeBSD Υ󥹥ȥ졼ġؤ褦. ʲΥץ
ɤ줫, ץ̾κǽ 1 ʸǤĤȤŪΥץ
򤷤Ʋ. [RETURN] 򲡤ȤǤΥץư뤳
Ǥޤ. [TAB-RETURN] ǥ˥塼ȴ뤳ȤǤޤ.", /* prompt */
#else
"FreeBSD Υ󥹥ȥ졼ġؤ褦. ʲΥץ
ץΤɤ줫, ץ̾κǽ 1 ʸǤĤȤ
ŪΥץ򤷤Ʋ. [ENTER] 򲡤ȤǤΥץ
ư뤳ȤǤޤ. [TAB-ENTER] ǥ˥塼ȴ뤳ȤǤޤ.", /* prompt */
#endif
    /*"F1: 󥹥ȡ륬",			/ * help line */
    "F1 򲡤Х󥹥ȡ륬ɤɤޤ",		/* help line */
#ifdef PC98
    "install.98",					/* help file */
#else
    "install",						/* help file */
#endif
{{ "" },
  { "X Ƴλ",	NULL, NULL, dmenuExit },
  { " U ˡ",	"å - Υ˥塼ƥλˡ",	NULL, dmenuDisplayFile, NULL, "usage" },
  { "N 鿴",	"鿴ѥ󥹥ȡ򳫻Ϥ (ӥʡ)",		NULL, installNovice },
  { "E ®",	"å󥹥ȡ򳫻Ϥ (äʿ)",	NULL, installExpress },
  { " C ", "।󥹥ȡ򳫻Ϥ ()",		NULL, dmenuSubmenu, NULL, &MenuInstallCustom },
  { "C ",	"󥹥ȡ FreeBSD Ԥʤ",		NULL, dmenuSubmenu, NULL, &MenuConfigure },
  { "D ʸ",	"󥹥ȡ˴ؤ, README, ¾",		NULL, dmenuSubmenu, NULL, &MenuDocumentation },
#ifndef	PC98
  { "K ޥå", "ܡɥפ",				NULL, dmenuSubmenu, NULL, &MenuSysconsKeymap },
#endif
  { "O ץ", "Ƽ磻󥹥ȡ륪ץǧꤹ",	NULL, optionsEditor },
  { "F Fixit",	"CDROM/եåԡѤ⡼ɤ˰ܤ",		NULL, dmenuSubmenu, NULL, &MenuFixit },
  { "U åץ졼",	"¸Υƥ򥢥åץ졼ɤ",		NULL, installUpgrade },
  { "L Υ", "ǥեȤ",			NULL, dispatch_load_floppy },
  /* { "I ", "Ƶǽ˴ؤѸ콸",				NULL, dmenuSubmenu, NULL, &MenuIndex }, */
  { "I ",	"̥ޥɰ",					NULL, dmenuSubmenu, NULL, &MenuIndex },
  { NULL } },
};

/* The main documentation menu */
DMenu MenuDocumentation_j = {
    DMENU_NORMAL_TYPE,
#ifdef PC98
    "FreeBSD(98) ɥơ˥塼",
#else
    "FreeBSD ɥơ˥塼",
#endif
#ifdef PC98
"ϤƤΥ桼, FreeBSD Υ󥹥ȡˡ⤷塼ȥ
Ǥ륤󥹥ȡɥȤɤɬפǤ礦. Ūʾ
˴ؤƤ, README եɤ߲.",
#else
"⤷ʤϡɥιˤĤ, Դʾ, FreeBSD Τ
˥ƥۤ褦ȤƤ, ϡɥɤɤ߲
! ϤƤΥ桼, FreeBSD Υ󥹥ȡˡ⤷塼
ȥꥢǤ륤󥹥ȡɥȤɤɬפǤ礦. Ū
˴ؤƤ, README եɤ߲.",
#endif
    /* "F1: إ", */
    "F1 򲡤Хإפɽޤ.",
    "usage",
{ { "X λ",	"Υ˥塼λ (ξ)",		NULL, dmenuExit },
  { "1 README",	"Ū FreeBSD ˴ؤ뵭. ɤǲ!",	NULL, dmenuDisplayFile, NULL, "readme" },	/* Upper ? */
#ifdef PC98
  { "2 󥹥ȡ 98","FreeBSD(98) Υ󥹥ȡ⤹륬",	NULL, dmenuDisplayFile,	NULL, "install.98" },
  { "3 ","FreeBSD ",			NULL, dmenuDisplayFile,	NULL, "COPYRIGHT" },
  { "4 ꡼","FreeBSD ΤΥС˴ؤ꡼Ρ",	NULL, dmenuDisplayFile, NULL, "relnotes" },
  { "5  98","FreeBSD(98) ",			NULL, dmenuDisplayFile,	NULL, "Copyright.98" },
  { "6 ꡼ 98","FreeBSD(98) ΤΥС˴ؤ꡼Ρ",	NULL, dmenuDisplayFile, NULL, "Relnote.98" },
  { "7 硼ȥå","sysinstall Υ硼ȥåȤˤĤ",	NULL, dmenuDisplayFile, NULL, "shortcuts" },
  { "8 HTML ʸ","HTML ɥơɤ (󥹥ȡ)",	NULL, docBrowser },
#if defined(PCCARD)
  { "P PC-card", "PC  (PAO ѥå) 󥹥ȡ륬", NULL, dmenuDisplayFile, NULL, "pccard" },
#endif  /* PCCARD */
#else
  { "2 ϡɥ","PC ϡɥΤ FreeBSD ХХ륬",		NULL, dmenuDisplayFile,	NULL, "hardware" },	/* Upper ? */
  { "3 󥹥ȡ","FreeBSD Υ󥹥ȡ⤹륬",		NULL, dmenuDisplayFile,	NULL, "install" },	/* Upper ? */
  { "4 ","FreeBSD ",			NULL, dmenuDisplayFile,	NULL, "COPYRIGHT" },
  { "5 ꡼","FreeBSD ΤΥС˴ؤ꡼Ρ",	NULL, dmenuDisplayFile, NULL, "relnotes" },	/* Upper ? */
  { "6 硼ȥå","sysinstall Υ硼ȥåȤˤĤ",	NULL, dmenuDisplayFile, NULL, "shortcuts" },
  { "7 HTML ʸ","HTML ɥơɤ (󥹥ȡ)",	NULL, docBrowser },
  { "8 I18N","󥹥ȡιݲ (ܸ첽ʤ) β",	NULL, dmenuDisplayFile, NULL, "i18n" },
#if defined(PCCARD)
  { "P PC-card", "PC  (PAO ѥå) 󥹥ȡ륬", NULL, dmenuDisplayFile, NULL, "pccard" },
#endif  /* PCCARD */
#endif
  { NULL } },
};

DMenu MenuMouseType_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "ޥΥץȥ륿פ",
    "ԳΤʤ \"A ư\" Ǥ. ˥Х PS/2 ޥ\n"
    "ưޤ. PnP ɸ򥵥ݡȤƤʤޥʤ饷ꥢޥȤ\n"
    "ưʤǤ礦. , ۤ뤳ȤϤޤ.  ¿Σܥ\n"
    "ꥢޥ \"Microsoft\", \"MouseMan\" ѥ֥Ǥ. ܥ\n"
    "ꥢޥ \"MouseSystems\", \"MouseMan\" ѥ֥Ǥ礦.\n"
    "⤷ޥ˥ۥ뤬, \"IntelliMouse\" ѥ֥Ǥ礦.",
    NULL,
    NULL,
    { { "1 ư",		"Хޥ, PS/2 ޥ PnP ꥢޥ",	
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=auto" },
      { "2 GlidePoint",	"ץ GlidePoint ѥå (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=glidepoint" },
      { "3 Hitachi",	"Ω֥å (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mmhittab" },
      { "4 IntelliMouse",	"Microsoft IntelliMouse (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=intellimouse" },
      { "5 Logitech",	"Logitech ץȥ (ǥ) (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=logitech" },
      { "6 Microsoft",	"Microsoft ץȥ (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=microsoft" },
      { "7 MM Series",	"MM ꡼ץȥ (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mmseries" },
      { "8 MouseMan",	"Logitech MouseMan/TrackMan models (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mouseman" },
      { "9 MouseSystems",	"MouseSystems ץȥ (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mousesystems" },
      { "A ThinkingMouse","Kensington ThinkingMouse (ꥢ)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=thinkingmouse" },
      { NULL } },
};

DMenu MenuMousePort_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "Υ˥塼ޥݡȤ",
    "åץȥå/Ρȥ֥åԥ塼Ȥ߹ߥݥƥ󥰥ǥХ\n"
    " PS/2 Ǥ.",
    NULL,
    NULL,
    { { "1 COM1",	"COM1 Υꥢޥ (/dev/cuaa0)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa0" },
      { "2 COM2",	"COM2 Υꥢޥ (/dev/cuaa1)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa1" },
      { "3 COM3",	"COM3 Υꥢޥ (/dev/cuaa2)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa2" },
#ifdef PC98
      /* { "BusMouse", "PC98 ɸޥ, Logitech, MS ޤ ATI Хޥ (/dev/mse0)", */
      { "4 BusMouse", "PC98 ɸޥ, ¾ΥХޥ (/dev/mse0)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/mse0" },
#else
      { "4 COM4",	"COM4 Υꥢޥ (/dev/cuaa3)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa3" },
      { "5 BusMouse", "Logitech, ATI or MS bus mouse (/dev/mse0)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/mse0" },
      { "6 PS/2",	"PS/2 style mouse (/dev/psm0)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/psm0" },
#endif
      { NULL } },
};

DMenu MenuMouse_j = {
    DMENU_NORMAL_TYPE,
    "ޥԤäƤ",
    "ޥǡäƤХƥȥ󥽡ǥƥȤ򥫥å&ڡ\n"
    "ȤǤޤ. ޥΥݡ, ץȥ륿פȥޥǡư\n"
    "ɤꤷƤ. ⤷Τ褦ʵǽפʤ 4 ܤΥޥ\n"
    "ǡߤ򤷤Ƥ.\n"
    ", ޥǡưʤ, ޥ֤Ȥ \"/dev/sysmouse\"\n"
    " \"SysMouse\" ޤ, 桼ƥƥ餻(˥\n"
    ")ΥޥץȥȤ \"MouseSystems\" 򵭽ҤǤޤ.\n",
    NULL,
    NULL,
    { { "X λ",	"Υ˥塼ȴ (ξ)", NULL, dmenuExit },
      { "1 Type",	"ޥץȥ륿פ", NULL, dmenuSubmenu, NULL, &MenuMouseType },
      { "2 Port",	"ޥݡȤ", NULL, dmenuSubmenu, NULL, &MenuMousePort },
      { "3 Enable",	"ޥǡƥȥ󤹤", NULL, mousedTest, NULL, NULL },
      { "4 Disable",	"ޥǡߤ", NULL, mousedDisable, NULL, NULL },
      { NULL } },
};

DMenu MenuXF86Config_j = {
#ifdef PC98
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    /* "XFree86 Υե졼󡦥ġǲ.", */
    "XFree86 ιġǲ.",
"XF86Setup, xf86config  AT ߴѤΥåȥåסġǤ. 
XF98Setup ǤޤԤʤ, /usr/X11R6/lib/X11/XF86Config.98
 XF86Config ˥ԡ, ƼδĶ˹碌ԽƲ.",
#if 0
"AT ߴѤΥåȥåסġǤ. ǰʤ鸽 PC98 ǤϻѤ
ޤ. PC98 Ѥˤ XF98Setup, xf98config Ǥ, ޤԴ
Ǥ. /usr/X11R6/lib/X11/XF86Config.98  XF86Config ˥ԡ,
ƼδĶ˹碌ԽƲ.",
#endif
    NULL,
    NULL,
    { { "X λ",	"Υ˥塼ȴ (ξ)", NULL, dmenuExit },
      /* ĹƲ̤꤭ʤ */
      /* { "XF86Setup",	"ե륰եå XFree86 ե졼ġ.", */
      { "XF86Setup",	"ե륰եå XFree86 ġ.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=XF86Setup" },
      /* { "xf86config",	"륹ץȥ١ XFree86 ե졼ġ.", */
      { "xf86config",	"륹ץȥ١ XFree86 ġ.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=xf86config" },
      { "XF98Setup",	"(PC98) ե륰եå XFree86 ġ.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=XF98Setup" },
      { "XDesktop",	"åȥå׺Ѥ X ǥǥȥå׹Ԥ.",
	NULL, dmenuSubmenu, NULL, &MenuXDesktops },
      { NULL } },
#else
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "Ȥ XFree86 Υե졼󡦥ġǲ.",
#ifdef __alpha__
    "Due to problems with the VGA16 server right now, only the\n"
    "text-mode configuration tool (xf86config) is currently supported.",
#else
    "ǽΥġ, XF86Setup, ϥե롦եåưˤ\n"
    " VGA16 ФɬפǤ (ǥեȤ򤵤٤ΤǤ,\n"
    "򤫤鳰 ʥåȥåסġȤʤʤޤ).\n"
    "2ܤΥġ, xf86config,  ñʥ륹ץȥ١\n"
    "ġǿΥ桼ˤ ޤͥޤ, \n"
    "ưʤ褦ʾǤưǽޤ.",
#endif
    NULL,
    NULL,
    { { "X λ",	"Υ˥塼ȴ (ξ)", NULL, dmenuExit },
#ifdef __alpha__
      { "xf86config",	"Shell-script based XFree86 configuration tool.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=xf86config" },
#else
      /* { "XF86Setup",	"ե롦եå XFree86 ե졼󡦥ġȤ.", */
      { "XF86Setup",	"ե롦եå XFree86 ġȤ.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=XF86Setup" },
      /* { "xf86config",	"륹ץȡ١ XFree86 ե졼󡦥ġȤ.", */
      { "xf86config",	"륹ץȡ١ XFree86 ġȤ.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=xf86config" },
      { "XF98Setup",	"Fully graphical XFree86 configuration tool (PC98).",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=XF98Setup" },
#endif
      { "XDesktop",	"X already set up, just do desktop configuration.",
	NULL, dmenuSubmenu, NULL, &MenuXDesktops },
      { NULL } },
#endif
};

DMenu MenuXDesktops_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "ѤǥեȤ X ǥȥåפǤ.",
    "άȤ, XFree86 ä˻꤬ʤ twm(1)\n"
    "ޥͥ㡼ܤˤХ˥ǥȥåפˤʤޤ.  X\n"
    "ɸʤʤΤ̤˥ɤΤɬפȤʤ\n"
    "ޤ. ʤ, ⤷󥹥ȡ뤷ƤΤŬʥե\n"
    "ѥå˥Ǥʤ鼡Υǥȥåפ\n"
    "ȤǤޤ.",
    NULL,
    NULL,
    { { "X λ",	"Υ˥塼ȴ (ξ)", NULL, dmenuExit },
      { "1 KDE",		"K ǥȥå״Ķ.",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=kde" },
      { "2 GNOME + Afterstep",	"GNOME + Afterstep ɥޥͥ㡼.",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=gnome" },
      { "3 GNOME + Enlightenment","GNOME + E ɥޥͥ㡼",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=enlightenment" },
      { "4 Afterstep",	"եƥåץɥޥͥ㡼",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=afterstep" },
      { "5 Windowmaker",	"ɥᥤɥޥͥ㡼",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=windowmaker" },
      { "6 fvwm2",	"fvwm2 ɥޥͥ㡼",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=fvwm" },
      { NULL } },
};

DMenu MenuMediaCDROM_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "CDROM Υפ򤷤Ʋ",
"FreeBSD  FreeBSD ۥեޤ CDROM , ľ
󥹥ȡ뤹뤳ȤǤޤ. ⤷ʤʣ CDROM ɥ饤
äƤ뤿ˤΥ˥塼ɽƤΤʤ, ʲ 
CDROM ɥ饤֤Τ, ɤ줫򥤥󥹥ȡѥɥ饤֤Ȥ򤷤
.",
    /* "F1: 󥹥ȡ륬ɤɤ", */
    "F1 򲡤Х󥹥ȡ륬ɤɤޤ",
#ifdef PC98
    "install.98",
#else
    "install",
#endif
    { { NULL } },
};

DMenu MenuMediaFloppy_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "եåԡɥ饤֤򤷤Ʋ",
    "ʣΥɥ饤֤¸ߤƤޤ. 󥹥ȡ˻Ѥɥ饤֤\n"
    "ꤷƲ.",
    NULL,
    NULL,
    { { NULL } },
};

DMenu MenuMediaDOS_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "DOS ѡƥ򤷤Ʋ",
"FreeBSD  DOS ѡƥ󤫤ľܥ󥹥ȡǤޤ. 
Ŭڤʥե뷲, 󥹥ȡ DOS ѡƥ˥ԡ
Ƥɬפޤ. ⤷νǤƤʤ, DOS ǥ֡
Ȥƥ󥹥ȡ뤷ۥե DOS ѡƥ
\"FREEBSD\" ֥ǥ쥯ȥ˥ԡƲ. 줬ȺѤ
, FreeBSD ۥե뷲Ƥ DOS ѡƥ
򤷤Ʋ.",
    /* "F1: 󥹥ȡ륬ɤɤ", */
    "F1 򲡤Х󥹥ȡ륬ɤɤޤ",
#ifdef PC98
    "install.98",
#else
    "install",
#endif
    { { NULL } },
};

DMenu MenuMediaFTP_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "FreeBSD FTP ۥȤ򤷤Ʋ",
"ʲΥꥹȤ, äȤᤤ, 뤤ϡ֤¾פΥȤ
򤷤Ʋ. ʤ, Τ٤ƤΥȤ, ۥåȰʾ
ΤΤäƤȤϸ¤ʤȤȤ˵ĤƲ. 
ۥȤΤߤ, ۥեäƤ뤳ȤݾڤƤޤ.",
    "ǤᤤȤ򤷤Ʋ!",
#ifdef PC98
    "install.98",
#else
    "install",
#endif
{ { "P 켡ۥ",	"ftp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AS("=ftp://ftp.freebsd.org/pub/FreeBSD/releases/") },
      { "U URL", "ꥹȤˤʤȤ URLǻꤹ", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=other" },
      { " 4.0 SNAP С", "current.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AS("=ftp://current.freebsd.org/pub/FreeBSD/snapshots/") },
      { " 3.0 SNAP С", "releng3.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AS("=ftp://releng3.freebsd.org/pub/FreeBSD/snapshots/") },
#ifdef PC98
#define FTP_JP
#include "pc98site.h"
#undef FTP_JP
#endif
#ifdef PCCARD
#ifdef PC98
  { "PAO98 ", "daemon.jp.freebsd.org (pao98bin, pao98src)", NULL, dmenuSetVariable, NULL,
    	VAR_FTP_PATH "=ftp://daemon.jp.freebsd.org/pub/FreeBSD-jp/PAO/PC98/" },
#else
  { "PAO ", "daemon.jp.freebsd.org (paobin, paosrc)", NULL, dmenuSetVariable, NULL,
    	VAR_FTP_PATH "=ftp://daemon.jp.freebsd.org/pub/FreeBSD-jp/PAO/flp/" },
#endif
#endif /* PCCARD */
  { "A 를",	"ftp.ar.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.ar.freebsd.org") },
  { " A ȥꥢ",	"ftp.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.au.freebsd.org") },
  { " A ȥꥢ #2",	"ftp2.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.au.freebsd.org") },
  { " A ȥꥢ #3",	"ftp3.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.au.freebsd.org") },
  { " A ȥꥢ #4",	"ftp4.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.au.freebsd.org") },
  { " A ȥꥢ #5",	"ftp5.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.au.freebsd.org") },
  { "B ֥饸",	"ftp.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.br.freebsd.org") },
  { " B ֥饸 #2",	"ftp2.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.br.freebsd.org") },
  { " B ֥饸 #3",	"ftp3.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.br.freebsd.org") },
  { " B ֥饸 #4",	"ftp4.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.br.freebsd.org") },
  { " B ֥饸 #5",	"ftp5.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.br.freebsd.org") },
  { " B ֥饸 #6",	"ftp6.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp6.br.freebsd.org") },
  { " B ֥饸 #7",	"ftp7.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp7.br.freebsd.org") },
  { "C ʥ",		"ftp.ca.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.ca.freebsd.org") },
  { " C ", "ftp.cz.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.cz.freebsd.org") },
  { "D ǥޡ",	"ftp.dk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.dk.freebsd.org") },
  { " D ǥޡ #2",	"ftp2.dk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.dk.freebsd.org") },
  { "E ȥ˥",		"ftp.ee.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.ee.freebsd.org") },
  { "F ե",	"ftp.fi.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.fi.freebsd.org") },
  { " F ե",	"ftp.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.fr.freebsd.org") },
  { " F ե #2",	"ftp2.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.fr.freebsd.org") },
  { " F ե #3",	"ftp3.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.fr.freebsd.org") },
  { "G ɥ",		"ftp.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.de.freebsd.org") },
  { " G ɥ #2",	"ftp2.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.de.freebsd.org") },
  { " G ɥ #3",	"ftp3.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.de.freebsd.org") },
  { " G ɥ #4",	"ftp4.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.de.freebsd.org") },
  { " G ɥ #5",	"ftp5.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.de.freebsd.org") },
  { " G ɥ #6",	"ftp6.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp6.de.freebsd.org") },
  { " G ɥ #7",	"ftp7.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp7.de.freebsd.org") },
  { "H ",	"ftp.nl.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.nl.freebsd.org") },
  { " H ",	"ftp.hk.super.net", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.hk.super.net") },
  { "I ",	"ftp.is.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.is.freebsd.org") },
  { " I ",		"ftp.ie.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.ie.freebsd.org") },
  { " I 饨",	"ftp.il.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.il.freebsd.org") },
  { " I 饨 #2",	"ftp2.il.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.il.freebsd.org") },
#ifndef PC98
  { "J ",		"ftp.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.jp.freebsd.org") },
  { " J  #2",		"ftp2.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.jp.freebsd.org") },
  { " J  #3",		"ftp3.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.jp.freebsd.org") },
  { " J  #4",		"ftp4.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.jp.freebsd.org") },
  { " J  #5",		"ftp5.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.jp.freebsd.org") },
  { " J  #6",		"ftp6.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp6.jp.freebsd.org") },
#endif
  { "K ڹ",		"ftp.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.kr.freebsd.org") },
  { "K ڹ #2",		"ftp2.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.kr.freebsd.org") },
  { "K ڹ #3",	"ftp3.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.kr.freebsd.org") },
  { "K ڹ #4",	"ftp4.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.kr.freebsd.org") },
  { "K ڹ #5",	"ftp5.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.kr.freebsd.org") },
  { "N ˥塼",	"ftp.nz.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.nz.freebsd.org") },
  { "P ݡ",	"ftp.pl.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.pl.freebsd.org") },
  { " P ݥȥ",	"ftp.pt.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.pt.freebsd.org") },
  { " P ݥȥ #2",	"ftp2.pt.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.pt.freebsd.org") },
  { "R ",	"ftp.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.ru.freebsd.org") },
  { " R  #2",	"ftp2.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.ru.freebsd.org") },
  { " R  #3",	"ftp3.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.ru.freebsd.org") },
  { " R  #4",	"ftp4.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.ru.freebsd.org") },
  { "S Х¹",	"ftp.sk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.sk.freebsd.org") },
  { " S եꥫ",	"ftp.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.za.freebsd.org") },
  { " S եꥫ #2",	"ftp2.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.za.freebsd.org") },
  { " S եꥫ #3",	"ftp3.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.za.freebsd.org") },
  { " S եꥫ #4", "ftp4.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.za.freebsd.org") },
  { " S ڥ",	"ftp.es.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.es.freebsd.org") },
  { " S ڥ #2",	"ftp2.es.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.es.freebsd.org") },
  { " S ǥ",	"ftp.se.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.se.freebsd.org") },
  { " S ǥ #2",	"ftp2.se.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.se.freebsd.org") },
  { " S ǥ #3",	"ftp3.se.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.se.freebsd.org") },
  { "T ",		"ftp.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.tw.freebsd.org") },
  { " T  #2",	"ftp2.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.tw.freebsd.org") },
  { " T  #3",	"ftp3.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.tw.freebsd.org") },
  { " T ",		"ftp.nectec.or.th", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AS("=ftp://ftp.nectec.or.th/pub/mirrors/FreeBSD/") },
  { "U ꥹ",		"ftp.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.uk.freebsd.org") },
  { " U ꥹ #2",		"ftp2.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.uk.freebsd.org") },
  { " U ꥹ #3",		"ftp3.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.uk.freebsd.org") },
  { " U ꥹ #4",	"ftp4.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.uk.freebsd.org") },
  { " U ꥹ #5",	"ftp5.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.uk.freebsd.org") },
  { " U ꥫ罰",		"ftp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp.freebsd.org") },
  { " U ꥫ罰 #2",		"ftp2.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp2.freebsd.org") },
  { " U ꥫ罰 #3",		"ftp3.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp3.freebsd.org") },
  { " U ꥫ罰 #4",		"ftp4.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp4.freebsd.org") },
  { " U ꥫ罰 #5",		"ftp5.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp5.freebsd.org") },
  { " U ꥫ罰 #6",		"ftp6.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH _AP("=ftp://ftp6.freebsd.org") },
  { NULL } }
};

DMenu MenuMediaTape_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "ơץɥ饤֤Υפ򤷤Ʋ",
"FreeBSD ϥơץɥ饤֤饤󥹥ȡ뤹뤳ȤǤޤ. ,
Υ󥹥ȡˡ, 󥹥ȡɬפ̤˲ä, ʤ
礭ΰɬפȤޤ (ơץɥ饤֤ϥॢ
ŬʤΤ, 1 ѥǥơƤƤŸޤ). ⤷
˽ʬʶ֤ˤ, ʤΥƥǸФ줿ʲΥ
ХΤΤɤ줫򤷤Ʋ.",
    /* "F1: 󥹥ȡ륬ɤɤ", */
    "F1 򲡤Х󥹥ȡ륬ɤɤޤ",
#ifdef PC98
    "install.98",
#else
    "install",
#endif
    { { NULL } },
};

DMenu MenuNetworkDevice_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "ͥåȥ󥿡եξɬפǤ",
"⤷ʤ, ͥåȤľ³ΤǤϤʤ, ꥢǥХ
ͳ PPP Ѥˤ, ޤŪΤ˲桹󶡤
Ƥ ppp 桼ƥƥѤ, ӥץХ˥
ʤФʤޤ. ⤷ꥢǥХ SLIP ѤƤ
, Ūʥꥢ³ꤷޤ. ޤ, ü \"laplink\" 
֥Ѥ, ѥݡȷͳǺǶ (2.0R, 뤤Ϥ
ʹߤΥС)  FreeBSD Υޥȷǥ󥹥ȡ뤹뤳
Ǥޤ.",
    /* "F1: ͥåȥե졼ޥ˥奢ɤ", */
    /* "F1 򲡤Хͥåȥե졼ޥ˥奢뤬ɤޤ", */
    "F1 򲡤Хͥåȥե졼ޥ˥奢뤬ɤ",
    "network_device",
    { { NULL } },
};

/* The media selection menu */
DMenu MenuMedia_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "󥹥ȡǥ򤷤Ʋ",
"FreeBSD , եåԡ饤󥿡ͥåȾ FTP Ф˻ޤ, ޤ
ޤʰۤʤä󥹥ȡǥΥ󥹥ȡ뤬ǽǤ. ⤷ʤ
ݡȤƤ CDROM ɥ饤֤饤󥹥ȡ뤹ΤǤ, ϰ
ŪˤϺǹΥǥǤΤ, 줬ѤǤϤ¾Υǥ
饤󥹥ȡ뤹뤳ȤͤɬפϤޤ.",
    /* "F1: ޤޤʥǥפ˴ؤ뤵˾ܺ٤ʾ", */
    "F1 򲡤Фޤޤʥǥפ˴ؤ뤵˾ܺ٤ʾɽޤ",
    "media",
{ { "1 CDROM",		"FreeBSD CDROM 饤󥹥ȡ뤹",	NULL, mediaSetCDROM },
  { "2 FTP",		"FTP Ф饤󥹥ȡ뤹",	NULL, mediaSetFTPActive },
  /* { "3 FTP Passive",	"եͳ FTP Ф饤󥹥ȡ뤹", NULL, mediaSetFTPPassive }, */
  { "3 FTP Passive",	"եͳFTPФ饤󥹥ȡ뤹", NULL, mediaSetFTPPassive },
  { "4 DOS",		"DOS ѡƥ󤫤饤󥹥ȡ뤹",	NULL, mediaSetDOS },
  { "5 NFS",		"NFS 饤󥹥ȡ뤹",	NULL, mediaSetNFS },
  { "6 ե륷ƥ",	"¸Υե륷ƥफ饤󥹥ȡ뤹",	NULL, mediaSetUFS },
  { "7 եåԡ",		"եåԡǥΥåȤ饤󥹥ȡ뤹",	NULL, mediaSetFloppy },
  { "8 ơ",		"SCSI ޤ QIC ơפ饤󥹥ȡ뤹",	NULL, mediaSetTape },
#ifdef UFS_MO
  { "9 UFS MO, PDS",	"UFS MO  PDS 饤󥹥ȡ뤹",	NULL, mediaSetUFSMO },
#endif
  { "O ץ",	"ץ̤عԤ",		NULL, optionsEditor },
  { NULL } },
};

/* The distributions menu */
DMenu MenuDistributions_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "ۥե򤷤Ʋ",
    /* AT ܸǤΥåȰۤʤ */
#ifdef PC98
"ñΤ, ĤΡֽ礤ΡۥեΥåȤ󶡤
ޤ. , 桹ǤŬʥǥեȤǤȹͤ
ΤǤ. ⤷ʬۥե򤷤, ֥פ
򤷤Ʋ. ǽ˽礤Υѥå, 夫饫
ĴԤʤȤǤޤ. ܤ򤹤 [SPACE] 򲡤Ƥ
. ꤬λ, λιܤ򤹤뤫 [RETURN] 򲡤
.",
#else
"ñΤ, ĤΡֽ礤ΡۥեΥåȤ󶡤
ޤ. , 桹ǤŬʥǥեȤǤȹͤ
ΤǤ. ⤷ʬۥե򤷤, ֥פ
򤷤Ʋ. ǽ˽礤Υѥå, 夫饫
ĴԤʤȤǤޤ. ܤ򤹤 [SPACE] 򲡤Ƥ
. ꤬λ, λιܤ򤹤뤫 [ENTER] 򲡤
.",
#endif	/* PC98 */
    /* "F1: Υץ˴ؤܤ", */
    "F1 򲡤ФΥץ˴ؤܤɽޤ",
    "distributions",
{ { "X λ",		"Υ˥塼ȴ (ξ)",
	checkTrue,		dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",		", Хʥ, X Window System Хʥ",
	checkDistEverything,	distSetEverything },
  { "R ꥻå",	"򤵤줿ꥹȤꥻå",
	NULL,			distReset, NULL, NULL, ' ', ' ', ' ' },
  { "1 ȯ",	", Хʥ, ʸ, ",
	checkDistDeveloper, distSetDeveloper },
  { "2 X-ȯ",	"Ʊ + X Window System",
	checkDistXDeveloper, distSetXDeveloper },
  { "3 ͥ볫ȯ",	"Хʥ, ʸ, ͥΤߤΥ",
	checkDistKernDeveloper, distSetKernDeveloper },
  { "4 X-ͥ볫ȯ",	"Ʊ + X Window System",
	checkDistXKernDeveloper, distSetXKernDeveloper },
  { "5 桼",		"ʿŪ桼 - ХʥʸΤ",
	checkDistUser, distSetUser },
  { "6 X-桼",	"Ʊ + X Window System",
	checkDistXUser, distSetXUser },
  { "7 Ǿ",	"ǽʸ¤Ǿι",
	checkDistMinimum, distSetMinimum },
  { "8 ",	"ʬȤۥեΥåȤ",
    NULL, dmenuSubmenu, NULL, &MenuSubDistributions, '>', '>', '>' },
  { NULL } },
};

DMenu MenuSubDistributions_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "󥹥ȡ뤹ۥե",
#ifdef PC98
"󥹥ȡ뤷ۥեåƲ. Ǥ \"bin\"
 \"98bin\" ϤʤФޤ.
(ٹ) DES ۥե򥢥ꥫ罰񳰤˻Фʤǲ.
ϥꥫ罰Υ桼ΤߤΤΤΤǤ.",
#else
"󥹥ȡ뤷ۥեåƲ. Ǥ \"bin\"
ϤʤФޤ.
(ٹ) DES ۥե򥢥ꥫ罰񳰤˻Фʤǲ.
ϥꥫ罰Υ桼ΤߤΤΤΤǤ.",
#endif
    NULL,
    NULL,
{ { "X λ",	"Υ˥塼λ (ξ)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",		", Хʥ X Window System ΥХʥ",
	NULL, distSetEverything },
  { "R ꥻå",		"ʹߤƤꥻåȤ",
	NULL, distReset, NULL, NULL, ' ', ' ', ' ' },
  { " bin",		"Хʥۥե (ɬ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_BIN },
#ifdef PC98
  { " 98bin",		"PC98 ܥХʥ (ɬ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_98BIN },
#endif
#ifdef __i386__
  { " compat1x",		"FreeBSD 1.x Хʥߴ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT1X },
  { " compat20",		"FreeBSD 2.0 Хʥߴ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT20 },
  { " compat21",		"FreeBSD 2.1 Хʥߴ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT21 },
  { " compat22",		"FreeBSD 2.2.x  3.0 a.out Хʥߴ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT22 },
#if __FreeBSD__ > 3
  { " compat3x",		"FreeBSD 3.x Хʥߴ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT3X },
#endif
#endif
  { " DES",		"DES Ź沽 - ͢жػ!",
	DESFlagCheck, distSetDES },
  { " dict",		"ڥåե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_DICT },
  { " doc",		" FreeBSD 饤ɥ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_DOC },
#ifdef PC98
  { " 98doc",		"FreeBSD(98) ϥɥ֥åȥ饤ɥ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_98DOC },
#endif
  { " games",		" ()",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_GAMES },
  { " info",		"GNU info ե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_INFO },
  { " man",		"ƥޥ˥奢ڡ - 侩",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_MANPAGES },
  { " catman",		"եޥåȺѤߥƥޥ˥奢ڡ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_CATPAGES },
#ifdef JMAN
  { " jcatman",		"ܸեޥåȺѤߥƥޥ˥奢ڡ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_JCATPAGES },
#endif
  { " proflibs",		"ץեǤΥ饤֥",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PROFLIBS },
#if defined(PC98) && defined(PC98SRC)
  { " 98src",		"PC98ƤΥ",
	src98FlagCheck, distSet98Src },
#endif /* defined(PC98) && defined(PC98SRC) */
  { " src",		"DES ƤΥ",
	srcFlagCheck, distSetSrc },
  { " ports",	"FreeBSD Ports 쥯",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PORTS },
  { " local",	"ɲü",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_LOCAL},
  { " XFree86",		XFree86_3_X " ۥե",
	x11FlagCheck, distSetXF86 },
#ifdef PCCARD
#ifdef PC98
  { " pao98bin",	"PAO(98) Хʥۥե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PAOBIN },
  { " pao98src",	"PAO(98) ۥե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PAOSRC },
#else
  { " paobin",	"PAO Хʥۥե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PAOBIN },
  { " paosrc",	"PAO ۥե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PAOSRC },
#endif
#endif /* PCCARD */
  { NULL } },
};

DMenu MenuDESDistributions_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "󥹥ȡ뤷Ź沽򤷤Ʋ",
"󥹥ȡ뤷 DES ١̤ʰŹ沽ۥե򤷤
. , Υӥϥꥫ罰񳰤ؤΡ͢Ф϶
ߡפƤȤȤ˵ĤƲ. U.S. 񳰤ǤΥ
եȥۤƤˤĤƤ, ꡼ΡȤ򻲾ȤƲ
.",
    NULL,
    NULL,
{ { "X λ",	"Υ˥塼λ (ξ)",
    checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",		"ʹߤƤ򤹤",
	NULL,		setDES },
  { "R ꥻå",	"ʹߤƤꥻåȤ",
	NULL,		clearDES, NULL, NULL, ' ', ' ', ' ' },
  { " des",	" DES Ź沽ӥ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &DESDists, '[', 'X', ']', DIST_DES_DES, },
#if __FreeBSD__ > 3
  { " krb4",	"KerberosIV Ź沽ӥ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &DESDists, '[', 'X', ']', DIST_DES_KERBEROS4 },
#else
  { " krb",	"Kerberos Ź沽ӥ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &DESDists, '[', 'X', ']', DIST_DES_KERBEROS },
#endif
  { " skerbero",	"Kerberos IV Υ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &DESDists, '[', 'X', ']', DIST_DES_SKERBEROS },
  { " ssecure",	"DES Υ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &DESDists, '[', 'X', ']', DIST_DES_SSECURE },
  { " scrypto",	"ѡȤΥȥˤŹ楽",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &DESDists, '[', 'X', ']', DIST_DES_SCRYPTO },
  { NULL } },
};

DMenu MenuSrcDistributions_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS ,
    "󥹥ȡ뤹 src ֥ݡͥȤ򤷤Ʋ",
"󥹥ȡ뤷 FreeBSD ĥ꡼ΥݡͥȤå
Ʋ (RETURN Ǥʤ! 򥭡ȤȤ˺ʤ).",
    NULL,
    NULL,
{ { "E λ",	"Υ˥塼λ (ξ)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",	"ʹߤƤ򤹤",
	NULL,		setSrc },
  { "R ꥻå", "ʹߤƤꥻåȤ",
	NULL,		clearSrc, NULL, NULL, ' ', ' ', ' ' },
  { " base",	"/usr/src Υȥåץ٥ե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_BASE },
  { " contrib",	"/usr/src/contrib (ȥӥ塼ȥեȥ)",
	dmenuFlagCheck, dmenuSetFlag,	NULL, &SrcDists, '[', 'X', ']', DIST_SRC_CONTRIB },
  { " gnu",	"/usr/src/gnu (GNU ץȤΥեȥ)",
	dmenuFlagCheck, dmenuSetFlag,	NULL, &SrcDists, '[', 'X', ']', DIST_SRC_GNU },
  { " etc",	"/usr/src/etc (¿ʥƥե)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_ETC },
  { " games",	"/usr/src/games (̤̾!)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_GAMES },
  { " include",	"/usr/src/include (إåե)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_INCLUDE },
  { " lib",	"/usr/src/lib (ƥ饤֥)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_LIB },
  { " libexec",	"/usr/src/libexec (ƥץ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_LIBEXEC },
  { " release",	"/usr/src/release (꡼ġ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_RELEASE },
  { " bin",	"/usr/src/bin (ƥХʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_BIN },
  { " sbin",	"/usr/src/sbin (ƥХʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_SBIN },
  { " share",	"/usr/src/share (ɥȤȶͭե)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_SHARE },
  { " sys",	"/usr/src/sys (FreeBSD ͥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_SYS },
  { " ubin",	"/usr/src/usr.bin (桼Хʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_UBIN },
  { " usbin",	"/usr/src/usr.sbin (ŪƥХʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_USBIN },
  { NULL } },
};

#if defined(PC98) && defined(PC98SRC)
DMenu Menu98SrcDistributions_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS ,
    "󥹥ȡ뤹 98src ֥ݡͥȤ򤷤Ʋ",
"󥹥ȡ뤷 FreeBSD(98) ĥ꡼ΥݡͥȤå
Ʋ. share , ꥸʥΥ PC98
ѤΥ񤭤ޤ.",
/* PC98Ѥ˽ƤΤ etc, lib, lkm, release, sbin, share, sys,
ubin, usbin Ǥ.", */
    NULL,
    NULL,
{
  { "E λ",	"Υ˥塼λ (ξ)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",	"ʹߤƤ򤹤",
	NULL, set98Src },
  { "R ꥻå", "ʹߤƤꥻåȤ",
	NULL, clear98Src, NULL, NULL, ' ', ' ', ' ' },
  { " base",	"/usr/src Υȥåץ٥ե",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_BASE },
  { " contrib",	"/usr/src/contrib (ȥӥ塼ȥեȥ)",
	dmenuFlagCheck, dmenuSetFlag,	NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_CONTRIB },
#if 0
  { " gnu",	"/usr/src/gnu (GNU ץȤΥեȥ)",
	dmenuFlagCheck, dmenuSetFlag,	NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_GNU },
#endif
  { " etc",	"/usr/src/etc (¿ʥƥե)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_ETC },
#if 0
  { " games",	"/usr/src/games (̤̾!)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_GAMES },
  { " include",	"/usr/src/include (إåե)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_INCLUDE },
#endif
  { " lib",	"/usr/src/lib (ƥ饤֥)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_LIB },
#if 0
  { " libexec",	"/usr/src/libexec (ƥץ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_LIBEXEC },
#endif
  { " release",	"/usr/src/release (꡼ġ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_RELEASE },
#if 0
  { " bin",	"/usr/src/bin (ƥХʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_BIN },
#endif
  { " sbin",	"/usr/src/sbin (ƥХʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_SBIN },
  { " share",	"/usr/src/share (ɥȤȶͭե)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_SHARE },
  { " sys",	"/usr/src/sys (FreeBSD(98) ͥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_SYS },
  { " ubin",	"/usr/src/usr.bin (桼Хʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_UBIN },
  { " usbin",	"/usr/src/usr.sbin (ŪƥХʥ)",
	dmenuFlagCheck, dmenuSetFlag, NULL, &Src98Dists, '[', 'X', ']', DIST_SRC_USBIN },
  { NULL } },
};
#endif /* defined(PC98) && defined(PC98SRC) */

DMenu MenuXF86Select_j = {
    DMENU_NORMAL_TYPE,
    XFree86_3_X " ۥե",
XFree86_3_X " ۥե, ɬפȤ륳ݡͥȤ
Ʋ.",
    NULL,
    NULL,
{ { "X λ",	"Υ˥塼λ (ξ)",	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",	"XFree86 ۥեƤ򤹤",	NULL, setX11All },
  { "R ꥻå", "XFree86 ۥեꥻåȤ",	NULL, clearX11All },
  { "B ",	"ܥݡͥȥ˥塼 (ɬ)",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectCore },
  { "S ",	"X Х˥塼",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectServer },
  { "F ե",	"եȥåȥ˥塼",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectFonts },
  { NULL } },
};

DMenu MenuXF86SelectCore_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    XFree86_3_X " ܥݡͥ",
"󥹥ȡ뤷 XFree86 ܥݡͥȤ򤷤Ʋ.
Ǿ󥹥ȡǤ, bin, lib, set 򥤥󥹥ȡ뤷Ʋ.",
    NULL,
    NULL,
{ { "X λ",	"Υ˥塼λ (ξ)",
    checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",	"ʹߤƤ",
    NULL, setX11Misc },
  { "R ꥻå", "ʹߤƤꥻåȤ",
    NULL, clearX11Misc, NULL, NULL, ' ', ' ', ' ' },
  { " bin",	"饤ȥץꥱȶͭ饤֥",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_BIN },
  { " cfg",	"ե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_CFG },
  { " doc",	"README ȥ꡼Ρ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_DOC },
  { " html",	"HTML ʸե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_HTML },
  { " lib",	"¹Իɬפʥǡե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_LIB },
#ifdef __i386__
  { " lk98",	"PC98 ѥХ󥯥å",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_LKIT98 },
#endif
  { " lkit",	"¾ޥѥХ󥯥å",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_LKIT },
  { " man",	"ޥ˥奢ڡ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_MAN },
  { " prog",	"ץޤΤΥإåȥ饤֥",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_PROG },
  { " set",	"XFree86 åȥåץ桼ƥƥ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_SET },
#ifdef __i386__
  { " 9set",		"PC98  XFree86 åȥåץ桼ƥƥ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_9SET },
#endif
  { " sources",	XFree86_3_X " ɸॽ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_SRC },
  { " csources",	XFree86_3_X " contrib ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_CSRC },
  { NULL } },
};

DMenu MenuXF86SelectFonts_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "եȤξܺ٤",
"󥹥ȡ뤷ġΥեۥեåƲ.
Ф򥤥󥹥ȡ뤹¤, Ǥ, 75dpi  misc ΥեȤ
󥹥ȡ뤹ɬפޤ (ϥǥեȤ򤵤Ƥ
).",
    NULL,
    NULL,
{ { "X λ",	"Υ˥塼λ (ξ)",
    checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",	"ƤΥե",
    NULL, setX11Fonts },
  { "R ꥻå", "եΥꥻå",
    NULL, clearX11Fonts, NULL, NULL, ' ', ' ', ' ' },
  { " fnts",	"ɸ 75 DPI Ȥ¾Υե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_MISC },
  { " f100",	"100 DPI ե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_100 },
  { " fcyr",	"ʸե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_CYR },
  { " fscl",	"Speedo, Type ֥ե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_SCALE },
  { " non",	"ܸ, ʤ, ѸΥե",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_NON },
  { " server",	"եȥ",
    dmenuFlagCheck, dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_SERVER },
  { NULL } },
};

DMenu MenuXF86SelectServer_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "X Ф",
"󥹥ȡ뤷 X ФΥפåƲ. ⤷ʤ
եåɤǤɤΥФưΤ狼ʤ, SVGA 
VGA 16, PC98 ξ 9EGC  9840 ФѤǤ뤫Ȥ򤪴
ᤷޤ (VGA  Mono ΥФϤۤȤɤ LCD ǥץ쥤Ф
Ŭޤ).",
    NULL,
    NULL,
{ { "X λ",	"Υ˥塼λ (ξ)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { "A ",	"ʹߤƤ",
	NULL, setX11Servers },
  { "R ꥻå", "ʹߤƤꥻå",
	NULL, clearX11Servers, NULL, NULL, ' ', ' ', ' ' },
  { " SVGA",	"ɸ VGA ޤ Super VGA ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_SVGA },
  { " VGA16",	"ɸ 16  VGA ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_VGA16 },
  { " Mono",	"ɸΥǥץ쥤",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MONO },
  { " 3DL",	"8, 16  24 ӥåȥ顼 3D Labs ܡ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_3DL },
  { " 8514",	"8 ӥå (256 ) IBM 8514 ޤϸߴ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_8514 },
  { " AGX",	"8 ӥåȥ顼 AGX ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_AGX },
  { " I128",	"8, 16, 24 ӥåȥ顼 #9 Imagine I128 ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_I128 },
  { " Ma8",	"8 ӥåȥ顼 ATI Mach8 ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MACH8 },
  { " Ma32",	"8 ޤ 16 ӥå (65K ) ATI Mach32 ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MACH32 },
  { " Ma64",	"8 ޤ 16 ӥå (65K ) ATI Mach64 ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MACH64 },
  { " P9K",	"8, 16, 24 ӥåȥ顼 Weitek P9000 ١Υܡ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_P9000 },
  { " S3",	"8, 16, 24 ӥåȥ顼 S3 ١Υܡ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_S3 },
  { " S3V",	"8, 16, 24 ӥåȥ顼 S3 Virge ١Υܡ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_S3V },
  { " W32",	"8 ӥåȥ顼 ET4000/W32, /W32i ޤ /W32p ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_W32 },
#ifdef __i386__
  { " PC98",		"NEC PC98  X Ф [֥˥塼]",
	NULL,		dmenuSubmenu,	NULL, &MenuXF86SelectPC98Server, '>', ' ', '>', 0 },
#elif __alpha__
  { " TGA",		"TGA cards (alpha architecture only)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_TGA },
#endif
  { NULL } },
};

#ifdef __i386__
DMenu MenuXF86SelectPC98Server_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "PC98 XФ",
    "󥹥ȡ뤷 NEC PC98 X ФΥפ򤷤Ʋ. ⤷\n"
    "ʤΥեåɤǤɤΥФư뤫狼ʤ,\n"
    "9EGC 뤤 9480 ΥФ򤷤Ʋ (EGC ФϤۤȤɤ\n"
    "PC-9800 ǥץ쥤ФäŬޤ, 480 ФϤۤȤɤ\n"
    "PC-9821 ǥץ쥤ФŬޤ).",
    NULL,
    NULL,
    { { "X λ",	"Υ˥塼λ (ξ)",
	NULL,	dmenuExit },
      { " 9480",	"PC98 8 ӥå (256 ) PEGC-480 ⡼",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9480 },
      { " 9EGC",	"PC98 4 ӥå (16 ) EGC ⡼",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9EGC },
      { " 9GA9",	"PC98 GA-968V4/PCI (S3 968) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9GA9 },
      { " 9GAN",	"PC98 GANB-WAP (cirrus) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9GAN },
      { " 9LPW",	"PC98 PowerWindowLB (S3) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9LPW },
      { " 9MGA",		"PC98 MGA (Matrox) ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9MGA },
      { " 9NKV",	"PC98 NKV-NEC (cirrus) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9NKV },
      { " 9NS3",	"PC98 NEC (S3) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9NS3 },
      { " 9SPW",	"PC98 SKB-PowerWindow (S3) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9SPW },
      { " 9SVG",		"PC98 NEC ¢ CLGD755x ",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9SVG },
      { " 9TGU",	"PC98 Cyber9320  TGUI9680 ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9TGU },
      { " 9WEP",	"PC98 WAB-EP (cirrus) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9WEP },
      { " 9WS",	"PC98 WABS (cirrus) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9WS },
      { " 9WSN",	"PC98 WSN-A2F (cirrus) ",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9WSN },
      { NULL } }
};
#endif

DMenu MenuDiskDevices_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "ɥ饤֤򤷤Ʋ",
"󥹥ȥ졼Ԥʤɥ饤 (ʣǤ褤) 򤷤Ʋ.
⤷ʤ֡ȥѡƥǽΥɥ饤ְʳ֤
, ʣΥڥ졼ƥ󥰥ƥΥޥ˥󥹥ȡ뤷
ˤ, ֡ȥޥ͡ǥ󥹥ȡ뤹Ȥץ
ޤ. ɥ饤֤򤹤ˤ, ǥоݥǥ
ξ˰ư, [SPACE] 򲡤Ʋ. ˤϤ⤦
 [SPACE] 򲡤Ʋ.",
    /* "F1: ǥΥȥ˴ؤפʾ!", */
    "F1 򲡤ХǥΥȥ˴ؤפʾɽޤ!",
    "drives",
    { { NULL } },
};

DMenu MenuHTMLDoc_j = {
    DMENU_NORMAL_TYPE,
    "HTML ɥơݥ󥿤",
"ɤߤʸϤ򤷤Ʋ. ߤμפʥɥȤ FAQ ȥϥɥ֥å
Ǥ. ֤¾פ򤹤뤳Ȥ, URL ꤷƥ֥饦뤳ȤǤޤ.",
    /* "F1 ˾ܤإ", */
    "F1 򲡤Ф˾ܤإפɽޤ",
    "html",
{ { "X λ",	"Υ˥塼λ (ξ)",
    NULL,	dmenuExit },
  { "1 ϥɥ֥å",	"FreeBSD ϥɥ֥å",			NULL, docShowDocument },
#ifdef DOCJP
  { "2 ܸϥɥ֥å",	"ܸ FreeBSD ϥɥ֥å",	NULL, docShowDocument },
  { "3 FAQ",	"˻˽ФƤ˴ؤ륬",		NULL, docShowDocument },
  { "4 ۡ",	"FreeBSD ץȤΥۡڡ (ͥåȥɬ)", NULL, docShowDocument },
  { "5 ¾",	"URL Ϥ",				NULL, docShowDocument },
#else
  { "2 FAQ",	"˻˽ФƤ˴ؤ륬",		NULL, docShowDocument },
  { "3 ۡ",	"FreeBSD ץȤΥۡڡ (ͥåȥɬ)", NULL, docShowDocument },
  { "4 ¾",	"URL Ϥ",				NULL, docShowDocument },
#endif /* DOCJP*/
  { NULL } },
};

/* The main installation menu */
DMenu MenuInstallCustom_j = {
    DMENU_NORMAL_TYPE,
    "।󥹥ȥ졼󥪥ץ",
"ϥ।󥹥ȥ졼Υ˥塼Ǥ. 󥹥ȡ뤷
ۥեϲ, ɤ˥󥹥ȡ뤹뤫, ɤ饤󥹥ȡ
뤫, FreeBSD ˤɤǥƤ뤫, ʤɤ򤳤Υ˥塼
ꤹ뤳ȤǤޤ.",
    /* "F1: 󥹥ȡ륬", */
    "F1 򲡤Х󥹥ȡ륬ɤɤޤ",
#ifdef PC98
    "install.98",
#else
    "install",
#endif
{ { "X λ",		"Υ˥塼λ (ξ)", NULL, dmenuExit },
  { "1 ץ",	"ޤޤʥ󥹥ȡ륪ץ",	NULL, optionsEditor },
#ifdef __alpha__
      { "2 Label",		"Label disk partitions",		NULL, diskLabelEditor },
      { "3 Distributions",	"Select distribution(s) to extract",	NULL, dmenuSubmenu, NULL, &MenuDistributions },
      { "4 Media",		"Choose the installation media type",	NULL, dmenuSubmenu, NULL, &MenuMedia },
      { "5 Commit",		"Perform any pending Partition/Label/Extract actions", NULL, installCustomCommit },
#else
  { "2 ѡƥ",	"FreeBSD ؤΥǥ֤γ",	NULL, diskPartitionEditor },
  { "3 ٥",		"ƤѡƥؤΥ٥",	NULL, diskLabelEditor },
  { "4 ۥե",	"Ÿۥե",		NULL, dmenuSubmenu, NULL, &MenuDistributions },
  { "5 ǥ",	"󥹥ȡǥ",		NULL, dmenuSubmenu, NULL, &MenuMedia },
  { "6 ߥå",	"ѡƥ, ٥, Ÿºݤ˹Ԥʤ", NULL, installCustomCommit },
#endif
  { NULL } },
};

#ifndef PC98
/* MBR type menu */
DMenu MenuMBRType_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "overwrite me",		/* will be disk specific label */
"FreeBSD ˤ, ֡Ȼ FreeBSD ¾Υڥ졼ƥ󥰥ƥ
Ǥ֡ȥ쥯°Ƥޤ. ⤷ʤʣΥǥ
ͭƤ, 2 ܤΥǥ֡ȤȤ,
֡ȥ쥯ˤäƤεǽ¸뤳ȤǤޤ. ⤷֡
쥯פʾ, 촹ϡɸפ
Ʋ. ⤷, ޥ֡ȥ쥳ɤ񤭴ʤ,
̵פ򤷤Ʋ.",
    /* "F1: 󥹥ȡ륬", */
    "F1 򲡤Хɥ饤֡åȥåפɤޤ",
    "install",
{ { "B BootMgr",	"FreeBSD ֡ȥޥ͡򥤥󥹥ȡ",
    dmenuRadioCheck, dmenuSetValue, NULL, &BootMgr },
  { "S ɸ",	"ɸ MBR 򥤥󥹥ȡ뤹 (֡ȥޥ͡ʤ)",
    dmenuRadioCheck, dmenuSetValue, NULL, &BootMgr, '(', '*', ')', 1 },
  { "N ̵",	"ޥ֡ȥ쥳ɤѹʤ",
    dmenuRadioCheck, dmenuSetValue, NULL, &BootMgr, '(', '*', ')', 2 },
  { NULL } },
};
#endif	/* PC98 */

#ifdef AT_KANJI
static int
passwdRoot(dialogMenuItem *self)
{
    if (language == LANG_ENGLISH) {
	systemExecute("passwd root");
    }
    else {
	msgConfirm(
"饤ǥ󥹥ȡեåԡǤ, εǽϸ, ХΤ
˻ѤǤޤ. Ƶưľ root ǥ,
    passwd root
, passwd ޥɤѤ root ΥѥɤꤷƲ.");
    }

    return 0;
}
#endif	/* AT_KANJI */

/* Final configuration menu */
DMenu MenuConfigure_j = {
    DMENU_NORMAL_TYPE,
    "FreeBSD ˥塼",	/* title */
"⤷Ǥ FreeBSD 򥤥󥹥ȡ뤷Ƥ, Υ˥塼ѤƤʤ
Υե졼˹碌ޥԤʤȤǤޤ. 
˥塼ΤäȤפʵǽȤƤ, ۥեˤϴޤޤʤ֥
ɥѡƥץեȥɤ߹िΥѥå桼ƥƥޤ.",
    /* "F1: Υץ˴ؤ뤵˾ܺ٤ʾ", */
    "F1 򲡤ФΥץ˴ؤ뤵˾ܺ٤ʾɽޤ",
    "configure",
{ { "X λ",	"Υ˥塼λ (ξ)",
    NULL, dmenuExit },
  { " D ۥե", "ɲäʪ򥤥󥹥ȡ",
	NULL, distExtractAll },
  { " P ѥå",	"FreeBSD Ѥ˥ѥå줿եȤΥ󥹥ȡ",
	NULL, configPackages },
#ifdef AT_KANJI
  { " R Root ѥ",	"ƥԤΥѥɤ",
	NULL, passwdRoot},
#else
  { " R Root ѥ",	"ƥԤΥѥɤ",
	NULL,	dmenuSystemCommand, NULL, "passwd root" },
#endif	/* AT_KANJI */
  { " L ٥",	"ǥ٥롦ǥ",
	NULL, diskLabelEditor },
#ifdef __i386__
  { " F Fdisk",	"ǥ饤(PC-Υѡƥ)ǥ",
	NULL, diskPartitionEditor },
#endif
  { " U 桼",	"桼ȥ롼׾ɲ",
	NULL, dmenuSubmenu, NULL, &MenuUsermgmt },
  { " C 󥽡",	"󥽡ưΥޥ",
	NULL, dmenuSubmenu, NULL, &MenuSyscons },
  { " T ॾ",	"ʤνǤ륿ॾ",
	NULL, dmenuSystemCommand, NULL, "tzsetup" },
  { " M ǥ",	"󥹥ȡǥΥפλ",
	NULL, dmenuSubmenu, NULL, &MenuMedia	},
#if 0
  { " M ޥ",	"ޥ",
	NULL, dmenuSubmenu, NULL, &MenuMouse, NULL },
#endif
  { " M ޥ",		"ޥμ",
	NULL, dmenuSubmenu, NULL, &MenuMouse, NULL },
  { " N ͥåȥ",	"ͥåȥ",
	NULL, dmenuSubmenu, NULL, &MenuNetworking },
  { " S ȥå",	"ƥॹȥåץӥ",
	NULL,	dmenuSubmenu, NULL, &MenuStartup },
  { " O ץ",	"ޤޤʥ󥹥ȡ륪ץ",
	NULL, optionsEditor },
  { " X XFree86",	"XFree86 С",
	NULL, configXSetup },
  { " D Desktop",	"XFree86 ǥȥåפ",
	NULL, configXDesktop },
  { " H HTML ʸ",	"HTML ʸ˥塼˰ư (󥹥ȡͭ)",
	NULL, docBrowser },
  { NULL } },
};

DMenu MenuStartup_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "ȥåץӥ˥塼",
    "Υ˥塼ˤä, ʤΥƥεưԤȤ\n"
    "ޤ. ܤ򤹤ˤϥڡѤȤȤ˺\n"
    "ʤ褦. ꥿󥭡򲡤 (¾Υåܥå˥塼Ʊ\n"
    "ͤ) Υ˥塼Ͻλޤ.",
    NULL,
    NULL,
    { { "E λ",	"Υ˥塼λ (ξ)",
	checkTrue,	dmenuExit, NULL, NULL, '<', '<', '<' },
      { " APM",	"APM (Ÿ) ӥ (˥åץȥå)",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "apm_enable=YES" },
      { " apmd",		"APM ٥ȴƻǡư",
	dmenuVarCheck, dmenuToggleVariable, NULL, "apmd_enable=YES" },
      { " apmd flags",	"apmd Υե饰 (ͭ줿)",
	dmenuVarCheck, dmenuISetVariable, NULL, "apmd_flags" },
      { " pccard",	"PC  (PCMCIA) ͭ (˥åץȥå)",
	dmenuVarCheck, dmenuToggleVariable, NULL, "pccard_enable=YES" },
      { " p pccard mem",	"PC ɤΥꥢɥ쥹 (ͭ줿)",
	dmenuVarCheck, dmenuISetVariable, NULL, "pccard_mem" },
#ifdef PCCARD
      { "pccard beep",	"PC ȴޤΥɥ⡼",
	NULL, dmenuSubmenu, NULL, &MenuPCCardBeep },
      { "pccard ether",	"ꤹ PC ɥͥåȥǥХΥꥹ",
	dmenuVarCheck, dmenuISetVariable, NULL, "pccard_ether" },
      { "pccard ifconfig", "PC ɥͥåȥ󥿥ե",
	NULL, tcpPCCardMenuSelect },
#else /* not PCCARD */
      { "pccard ifconfig", "ꤹ PC ɥͥåȥǥХΥꥹ",
	dmenuVarCheck, dmenuISetVariable, NULL, "pccard_ifconfig" },
#endif /* PCCARD */
      { "dhcp client",	"DHCP 饤ȤΥѥ",
	dmenuVarCheck, dmenuISetVariable, NULL, "dhcp_program" },
      { "dhcpc flags",	"DHCP 饤ȤΥե饰",
	dmenuVarCheck, dmenuISetVariable, NULL, "dhcp_flags" },
      { " ",		" -- ", NULL,	NULL, NULL, NULL, ' ', ' ', ' ' },
      { " s ץ",	"ץȤΤǥ쥯ȥΥꥹ",
	dmenuVarCheck, dmenuISetVariable, NULL, "local_startup" },
      { " n named",	"ΥۥȾǥ͡ॵФư",
	dmenuVarCheck, dmenuToggleVariable, NULL, "named_enable=YES" },
      { " n namedե饰",	"named ΥǥեȤΥե饰 (ͭ줿)",
	dmenuVarCheck, dmenuISetVariable, NULL, "named_flags" },
      { " n NIS饤",	"ΥۥȤ NIS 饤ȤȤ.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "nis_client_enable=YES" },
      { " n NIS ɥᥤ̾",	"(ǽʤ)NIS ɥᥤ̾ꤹ",
	dmenuVarCheck, dmenuISetVariable, NULL, "nisdomainname" },
      { " n NIS",	"ΥۥȤ NIS ФȤ.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "nis_server_enable=YES" },
      { " ",		" -- ", NULL,	NULL, NULL, NULL, ' ', ' ', ' ' },
      { " a ƥ",	"ΥۥȤǥץƥ󥰤Ԥ.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "accounting_enable=YES" },
      { " l lpd",		"ΥۥȤ˥ץ󥿤 lpd ư.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "lpd_enable=YES" },
#ifdef __i386__
      { " l linux",	"ΥۥȤ Linux Хʥ¹Ԥ.",
	dmenuVarCheck, configLinux, NULL, VAR_LINUX_ENABLE "=YES" },
      { " S SCO",	"ΥۥȤ IBCS2 Хʥ¹Ԥ.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "ibcs2_enable=YES" },
#endif
      { " q quotas",	"ΥۥȤǵư quota åԤ.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "check_quotas=YES" },
      { NULL } },
};

DMenu MenuNetworking_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "ͥåȥӥ˥塼",
"ͥåȥǥХ (ڤӥۥ̾, ȥ, ͡ॵФʤɤ
ޤޤʥѥ᡼)  FreeBSD Υ󥹥ȡβǤǤꤵƤ
Ǥ礦. Υ˥塼Ǥ, ʤΥƥΥͥåȥ˴ؤ뤽¾
Ԥʤޤ.",
    NULL,
    NULL,
{ { "E λ",	"Υ˥塼λ (ξ)",
    checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
  { " I 󥿡ե",	"̤Υͥåȥ󥿡ե",
    NULL, tcpMenuSelect },
  { " N NFS 饤",	"NFS 饤ȤȤꤹ",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "nfs_client_enable=YES" },
  { " N NFS ",	"NFS ФȤꤹ",
	dmenuVarCheck, configNFSServer, NULL, "nfs_server_enable=YES" },
  { " A AMD",	"Υޥǥȥޥ󥿥ӥ󶡤",
	dmenuVarCheck, dmenuToggleVariable, NULL, "amd_enable=YES" },
  { " A AMD ե饰",	"AMD ӥΥե饰 (ͭʾ)",
	dmenuVarCheck, dmenuISetVariable, NULL, "amd_flags" },
  { " T TCP Extensions",	"RFC1323  RFC1544 TCP extentions ͭ?",
	dmenuVarCheck, dmenuToggleVariable, NULL, "tcp_extensions=YES" },
  { " G ȥ",	"󥿡ե֤ǥѥåȤž",
    dmenuVarCheck, dmenuToggleVariable, NULL, "gateway=YES" },
  { " N Ntpdate",	"ƱФ",
    dmenuVarCheck,	dmenuSubmenu, NULL, &MenuNTP, '[', 'X', ']', "ntpdate_enable=YES" },
  /* Ĺ̤ʤ */
  /* { "router",		"롼ƥ󥰥ǡ (ǥե: routed)", */
  { " r router",		"롼ƥ󥰥ǡ (ά: routed)",
    dmenuVarCheck, configRouter, NULL, "router" },
  { " R Rwhod",		"rwho ǡư",
    dmenuVarCheck, dmenuToggleVariable, NULL, "rwhod_enable=YES" },
  { " A ƿ̾ FTP",		"Υޥ anonymous FTP դ",
    dmenuVarCheck, configAnonFTP, NULL, "anon_ftp" },
#if 0
  { " W WEB ",	"Υޥ WWW ФȤꤹ",
    dmenuVarCheck, configApache, NULL, "apache_httpd" },
  { " S Samba",		"LanManager (NETBUI) Ѥ Samba 򥤥󥹥ȡ",
    dmenuVarCheck, configSamba, NULL, "samba" },
#endif
  { " P PCNFSD",		"PC-NFS 饤ѤǧڥФư",
    dmenuVarCheck, configPCNFSD, NULL, "pcnfsd" },
  { NULL } },
};

DMenu MenuNTP_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "NTPDATE Ф",
"¿λƱФ󥿡ͥåȤˤƥѥ֥åѤΤ˳
Ƥޤ. ʤλפ٤ݤĤ, Ǥ¤ᤤФ
ޤ礦.",
    "餬ץ󥢥Ƥץ饤ޥ NTP ФǤ",
    NULL,
{ { "N ʤ",			"ntp Сʤ",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=NO,ntpdate_flags=none" },
  { "O ¾",			"ΥꥹˤʤȤ",
	dmenuVarsCheck, configNTP, NULL, NULL },
  { "A ȥꥢ",		"ntp.syd.dms.csiro.au (HP 5061 ӡ)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.syd.dms.csiro.au" },
  { " C ʥ",			"tick.usask.ca (GOES å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=tick.usask.ca" },
  { "F ե",		"canon.inria.fr (TDF å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=canon.inria.fr" },
  { "G ɥ",			"ntps1-{0,1,2}.uni-erlangen.de (GPS å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntps1-0.uni-erlangen.de" },
  { " G ɥ #2",		"ntps1-0.cs.tu-berlin.de (GPS å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntps1-0.cs.tu-berlin.de" },
  { "J ",			"clock.nc.fukuoka-u.ac.jp (GPS å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=clock.nc.fukuoka-u.ac.jp" },
  { " J  #2",		"clock.tl.fukuoka-u.ac.jp (GPS å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=clock.tl.fukuoka-u.ac.jp" },
  { "N ",		"ntp0.nl.net (GPS å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp0.nl.net" },
  { " N Υ륦",		"timehost.ifi.uio.no (NTP å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=timehost.ifi.uio.no" },
  { "S ǥ",		"Time1.Stupi.SE (/GPS)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=Time1.Stupi.SE" },
  { " S ",			"swisstime.ethz.ch (DCF77 å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=swisstime.ethz.ch" },
  { "U ꥫ쳤",		"bitsy.mit.edu (WWV å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=bitsy.mit.edu" },
  { " U ꥫ쳤 #2",	"otc1.psu.edu (WWV å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=otc1.psu.edu" },
  { " U ꥫ #1",	"clepsydra.dec.com (GOES å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=clepsydra.dec.com" },
  { " U ꥫ #2",	"clock.llnl.gov (WWVB å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=clock.llnl.gov" },
  { " U ꥫ",		"ncar.ucar.edu (WWVB å)",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ncar.ucar.edu" },
  { NULL } },
};

DMenu MenuSyscons_j = {
    DMENU_NORMAL_TYPE,
    "ƥॳ󥽡",
"FreeBSD Υǥեȥƥॳ󥽡ɥ饤Ф, ޤޤꥪ
ץäƤ, ߤ˱򤬤Ǥޤ. ꤬ä
Cancel 򤷤Ʋ.",
    "ƥॳ󥽡",
    NULL,
{
  { "X λ",		"Υ˥塼λ (ξ)", NULL, dmenuExit },
#ifdef PC98
  { "S ",		"꡼󥻡Ф",	NULL, dmenuSubmenu, NULL, &MenuSysconsSaver },
#else
  { "1 ե",	"꡼եȤ",	  NULL, dmenuSubmenu, NULL, &MenuSysconsFont },
  { "2 ޥå",	"ܡɥޥåפ",	NULL, dmenuSubmenu, NULL, &MenuSysconsKeymap },
  { "3 ԡ",	"ԡȤδֳ֤",	NULL, dmenuSubmenu, NULL, &MenuSysconsKeyrate },
  { "4 ",		"꡼󥻡Ф",	NULL, dmenuSubmenu, NULL, &MenuSysconsSaver },
  { "5 ꡼ޥå",	"꡼ޥåפ",	NULL, dmenuSubmenu, NULL, &MenuSysconsScrnmap },
#endif
  { NULL } },
};

#ifndef PC98
DMenu MenuSysconsKeymap_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "ƥॳ󥽡륭ޥå",
    /* AT ܸǤΥåȰۤʤ */
    "FreeBSD Υǥեȥƥॳ󥽡ɥ饤 (syscons) , ǥե\n"
    "ȤɸΡ֥ꥫפΥܡɥޥåפꤵƤޤ. ¾\n"
    "Υ桼 (ޤ̤ΥܡɤѤƤ) , Υ\n"
    "ޥåפ򤹤뤳ȤǤޤ.\n"
    "󥹥ȡ鼫Ȥ ANSIʸåȤΰȤ褦ˤΤɬפ\n"
    "ʬΤ߻ȤΤǤ뤳Ȥ. ˾ޥåפϸ (ž夲\n"
    ") ¸ޤ.",
    /* "ܡɥޥåפ", */
    "ܡɥޥåפ򤷤Ʋ",
    NULL,
{ { "Belgian", "٥륮 ISOޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=be.iso" },
  { " Brazil CP850", "֥饸 CP850ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=br275.cp850" },
  { " Brazil ISO (accent)",	"֥饸 ISO ޥå (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=br275.iso.acc" },
  { " Brazil ISO", "֥饸 ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=br275.iso" },
  { "Croatian ISO", " ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=hr.iso" },
  { "Danish CP865", "ǥޡ ɥڡ 865 ޥåkeymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=danish.cp865" },
  { " Danish ISO", "ǥޡ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=danish.iso" },
  { "Estonian ISO", "ȥ˥ ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=estonian.iso" },
  { " Estonian ISO 15", "ȥ˥ ISO 8859-15 ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=estonian.iso15" },
  { " Estonian CP850", "ȥ˥ Code Page 850 ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=estonian.cp850" },
  { " Finnish CP850", "Finnish Code Page 850 ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=finnish.cp850" },
  { " Finnish ISO", "Finnish ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=finnish.iso" },
  { " French ISO (accent)", "ե ISO ޥå (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=fr.iso.acc" },
  { " French ISO", "ե ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=fr.iso" },
  { "German CP850", "ɥ ɥڡ 850 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=german.cp850"	},
  { " German ISO", "ɥ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=german.iso" },
  { "Hungarian 101", "ϥ󥬥꡼ ISO ޥå (101 key)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=hu.iso2.101keys" },
  { " Hungarian 102", "ϥ󥬥꡼ ISO ޥå (102 key)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=hu.iso2.102keys" },
  { "Icelandic (accent)", " ISO ޥå (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=icelandic.iso.acc" },
  { " Icelandic",	" ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=icelandic.iso" },
  { " Italian", "ꥢ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=it.iso" },
  { "Latin American", "ƥ󥢥ꥫ ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=lat-amer" },
  { "Japanese 106", " 106 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=jp.106" },
  { "Norway ISO", "Υ륦 ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=norwegian.iso" },
  { "Polish ISO", "ݡ ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=pl_PL.ISO_8859-2" },
  { " Portuguese (accent)", "ݥȥ ISO ޥå (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=pt.iso.acc" },
  { " Portuguese", "ݥȥ ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=pt.iso" },
  { "Russia CP866", " CP866 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=ru.cp866" },
  { " Russia KOI8-R", " KOI8-R ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=ru.koi8-r" },
  { "Slovenian", "Slovenian ISO ޥå",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=si.iso.acc" },
  { " Spanish (accent)", "ڥ ISO ޥå (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=spanish.iso.acc" },
  { " Spanish", "ڥ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=spanish.iso" },
  { " Swedish CP850", "ǥ ɥڡ 850 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swedish.cp850" },
  { " Swedish ISO", "ǥ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swedish.iso" },
  { " Swiss French ISO (accent)", " ե󥹸 ISO ޥå (accent keys)", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissfrench.iso.acc" },
  { " Swiss French ISO", " ե󥹸 ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissfrench.iso" },
  { " Swiss French CP850", " ե󥹸 Code Page 850 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissfrench.cp850" },
  { " Swiss German ISO (accent)", " ɥĸ ISO ޥå (accent keys)", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissgerman.iso.acc" },
  { " Swiss German ISO", " ɥĸ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissgerman.iso" },
  { " Swiss German CP850", " ɥĸ Code Page 850 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissgerman.cp850" },
  { "U.K. CP850", "ꥹ ɥڡ 850 ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=uk.cp850" },
  { " U.K. ISO", "ꥹ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=uk.iso" },
  { " U.S. Dvorak", "ꥫ Dvorak ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.dvorak" },
  { " U.S. ISO", "ꥫ ISO ޥå", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.iso" },
  { NULL } },
};

DMenu MenuSysconsKeyrate_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "ƥॳ󥽡륭ܡɥԡȥ졼",
"Υ˥塼, ³ΥԡȤ®٤Ǥޤ.",
    "ܡɥԡȥ졼Ȥ򤷤Ʋ",
    NULL,
{ { "L ®", "®Υܡɥԡȥ졼", dmenuVarCheck, dmenuSetVariable, NULL, "keyrate=slow" },
  { "N ̾", "̾Ρץܡɥԡȥ졼", dmenuVarCheck, dmenuSetVariable, NULL, "keyrate=normal" },
  { "H ®", "®Υܡɥԡȥ졼", dmenuVarCheck, dmenuSetVariable, NULL, "keyrate=fast" },
  { "D ǥե", "ǥեȤΥܡɥԡȥ졼", dmenuVarCheck, dmenuSetVariable, NULL, "keyrate=NO" },
  { NULL } },
};
#endif	/* PC98 */

DMenu MenuSysconsSaver_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "ƥॳ󥽡륹꡼󥻡",
"ǥեȤǤ, 󥽡ɥ饤Фϥɥ֤ˤʤäǤ̤ʽ
Ԥʤޤ. ⤷ʤ˥Ÿξ֤ΤޤĹ֤ƤΤ
, ƤդɤˤΥ꡼󥻡ФΤΤɤ줫ͭ
Ƥɬפ뤫Τޤ.",
    "꡼󥻡Ф򤷤Ʋ",
    NULL,
{
#ifdef PC98
  { "1 ֥",	"ñ˥꡼֥󥯤ˤ",
	dmenuVarCheck, configSaver, NULL, "saver=blank" },
  { "2 ǡ",	"\"BSD ǡ\" ˥᥹꡼ (ƥ)",
	dmenuVarCheck, configSaver, NULL, "saver=daemon" },
  { "3 ͡",	"FreeBSD ֥͡פ̤",
	dmenuVarCheck, configSaver, NULL, "saver=snake" },
  { "4 ",	"֥饭׸",
	dmenuVarCheck, configSaver, NULL, "saver=star" },
#else
  { "1 ֥",	"ñ˥꡼֥󥯤ˤ",
	dmenuVarCheck, configSaver, NULL, "saver=blank" },
  { "2 ǡ",	"\"BSD ǡ\" ˥᥹꡼ (ƥ)",
	dmenuVarCheck, configSaver, NULL, "saver=daemon" },
  { "3 Fade",		"Fade out effect screen saver",
	dmenuVarCheck, configSaver, NULL, "saver=fade" },
  { "4 Fire",		"Flames effect screen saver",
	dmenuVarCheck, configSaver, NULL, "saver=fire" },
  { "5 Green",	"\"Green\" ϥ⡼ (˥ݡȤƤ)",
	dmenuVarCheck, configSaver, NULL, "saver=green" },
  { "6 Logo",		"\"BSD Daemon\" animated screen saver (graphics)",
	dmenuVarCheck, configSaver, NULL, "saver=logo" },
  { "7 Rain",		"Rain drops screen saver",
	dmenuVarCheck, configSaver, NULL, "saver=rain" },
  { "8 ͡",	"FreeBSD ֥͡פ̤",
	dmenuVarCheck, configSaver, NULL, "saver=snake" },
  { "9 ",	"֥饭׸",
	dmenuVarCheck, configSaver, NULL, "saver=star" },
  { "W Warp",	"A \"stars warping\" effect",
	dmenuVarCheck, configSaver, NULL, "saver=warp" },
#endif
  { "T ॢ",	"꡼󥻡ФΥॢȴֳ֤ꤹ",
	NULL, configSaverTimeout, NULL, NULL, ' ', ' ', ' ' },
  { NULL } },
};

#ifndef	PC98
DMenu MenuSysconsScrnmap = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "ƥॳ󥽡륹꡼ޥå",
    /*"ΥեȤɤʤ, ʬ PC ǤϥǥեȤ\n"
    "IBM 437 ʸåȤʸɽޤ. ʤ, Unix \n"
    "Ǥ ʸåȤ¿˻Ȥޤ. ʬ衼åѤ\n"
    "񡹤Ǥ, 㤨 ISO 8859-1 ޤޤ.\n"
    "Ⱦʬʸ ANSI ΤǤ뤿, ꥫΥ桼ϰ㤤\n"
    "Ĥޤ.\n"
    "ʤΥϡɥǿեȤɤ뤳Ȥǽ\n"
    "ʤ, ץ򤹤ɤǤ礦. ʤ, 줬\n"
    "Բǽʥϡɥ (e.g. Υץ) Ǥ, ꡼\n"
    "ޥåפ ʤΥϡɥɽǤǤɤʸɽ\n"
    "Ǥ礦.",*/
"̤ʥեȤɤʤ, ۤȤɤ PC ϡɥϥ
եȤ IBM 437 ʸåȤɽޤ.  Unix Ǥ,
ʸåȤϤۤȤѤƤޤ. 㤨, ۤȤɤ
衼åѽǤ, ISO 8859-1 ѤƤޤ. ʸ
ȤβȾʬ ANSI Ǥ뤿, ꥫΥ桼Ϥΰ㤤ܤ
ȤϵǤ礦.
⤷ʤΥϡɥɽեȤɤǤ,
Υץ򤹤뤳ȤǤޤ. , Τ褦ʤ
Բǽʾ (: ץ) Ǥ, ʤΥϡɥǤǤ
¤ǹκȤ뤳ȤˤʤǤ礦.",
    "꡼ޥåפ򤷤Ʋ",
    NULL,
{ { "N ʤ", "꡼ޥåפʤ, ǥեȤΥեȤ", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=NO" },
  { "K KOI8-R to IBM866", " KOI8-R  IBM 866 ꡼ޥåפ", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=koi8-r2cp866" },
  { "I ISO 8859-1 to IBM437", " ISO 8859-1  IBM 437 ꡼ޥåפ", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=iso-8859-1_to_cp437" },
  { NULL } },
};

DMenu MenuSysconsFont = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "ƥॳ󥽡ե",
    /*"ΥեȤɤʤ, ʬ PC ǤϥǥեȤ\n"
    "IBM 437 ʸåȤʸɽޤ. ʤ, Unix \n"
    "Ǥ ʸåȤ¿˻Ȥޤ. ʬ衼åѤ\n"
    "񡹤Ǥ, 㤨 ISO 8859-1 ޤޤ.\n"
    "Ⱦʬʸ ANSI ΤǤ뤿, ꥫΥ桼ϰ㤤\n"
    "Ĥޤ, 30ޤ 50ԤǻѤ뤿˥եȤ\n"
    "⤷ޤ.\n"
    "⤷ ʤΥϡɥեȤɤ뵡ǽ\n"
    "Ĥʤ, ʲŬʥեȤֻǤޤ.",*/
"̤ʥեȤɤʤ, ۤȤɤ PC ϡɥϥ
եȤ IBM 437 ʸåȤɽޤ.  Unix Ǥ,
ʸåȤϤۤȤѤƤޤ. 㤨, ۤȤɤ
衼åѽǤ, ISO 8859-1 ѤƤޤ. ʸ
ȤβȾʬ ANSI Ǥ뤿, ꥫΥ桼Ϥΰ㤤ܤ
ȤϵǤ礦. Τ褦ʾǤäƤ, 30 Ԥ 50 Ԥ
ǥץ쥤Ѥˤ, եȤɤɬפ
礦.
⤷ʤΥϡɥɽեȤɤǤ,
ΥեȤΤŬʤΤ򤹤뤳ȤǤޤ.",
    "եȤ򤷤Ʋ",
    NULL,
{ { "1 ̵", "ǥեȤΥեȤȤ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=NO,font8x14=NO,font8x16=NO" },
  { "2 IBM 437", "Ѹ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=cp437-8x8,font8x14=cp437-8x14,font8x16=cp437-8x16" },
  { "3 IBM 850", "衼å, IBM 󥳡ǥ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=cp850-8x8,font8x14=cp850-8x14,font8x16=cp850-8x16" },
  { "4 IBM 865", "Υ륦, IBM 󥳡ǥ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=cp865-8x8,font8x14=cp865-8x14,font8x16=cp865-8x16" },
  { "5 IBM 866", ", IBM 󥳡ǥ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=cp866-8x8,font8x14=cp866-8x14,font8x16=cp866-8x16" },
  { "6 ISO 8859-1", "衼å, ISO 󥳡ǥ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=iso-8x8,font8x14=iso-8x14,font8x16=iso-8x16" },
  { "7 KOI8-R", ", KOI8-R 󥳡ǥ", dmenuVarCheck, dmenuSetVariables, NULL,
    "font8x8=koi8-r-8x8,font8x14=koi8-r-8x14,font8x16=koi8-r-8x16" },
  { "8 SWISS", "Ѹ, better resolution",	dmenuVarCheck,	dmenuSetVariables, NULL,
    "font8x8=swiss-8x8,font8x14=NO,font8x16=swiss-8x16" },
  { NULL } },
};
#endif

DMenu MenuUsermgmt_j = {
    DMENU_NORMAL_TYPE,
    "Ȥȥ桼롼פδ",
    "Υ֥˥塼Ǥϥ桼롼פȥ󡦥Ȥ\n"
    "Ǥޤ.\n",
    "桼롼פȥȤ",
    NULL,
    { { "X λ",		"Υ˥塼λ (ξ)", NULL, dmenuExit },
      { "U 桼",	"Ȥ򥷥ƥɲ.",	NULL, userAddUser },
      { "G 롼",	"桼롼פ򥷥ƥɲ.",	NULL, userAddGroup },
  { NULL } },
};

#ifdef AT_KANJI
DMenu MenuInstKbd = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "ܡɤμ򤷤Ʋ",	/* title */
    "ܸ쥤󥹥ȡǤ, 󥹥ȡ餬Ѥ륭ܡɤμ򤹤
ȤǤޤ. , 101 Ѹ쥭ܡɤ 106 ܸ쥭ܡɤ
ǽȤʤäƤޤ.
ʤ, ꤷƤϥ󥹥ȡˤȿǤޤ. 󥹥ȡ
 106 ܡѤ, 󥹥ȡȽλˡ
ץ˥塼֥ޥåספ, ǡܸ 106 ܡɡ
򤷤Ʋ. 101 Ѹ쥭ܡɤξäˤΤ褦ʽɬפ
ޤ.",	/* prompt */
    "F1: ܸǥ󥹥ȡեåԡ˴ؤ",	/* help line */
    "japanese",	/* help file */
{ { "1 Ѹ 101 ܡ", "󥹥ȡ˱Ѹ 101 ܡɤ",
      dmenuVarCheck, dmenuSetVariable, NULL, "instkbd=us" },
  { "2 ܸ 106 ܡ", "󥹥ȡܸ 106 ܡɤ",
      dmenuVarCheck, dmenuSetVariable, NULL, "instkbd=jp" },
  { NULL } },
};
#endif /* AT_KANJI */

DMenu MenuFixit_j = {
    DMENU_NORMAL_TYPE,
    "fixit ץ򤷤Ʋ",
    "\"fixit\" ⡼ɤˤ 3̤ˡޤ:\n"
    "- 2ܤ FreeBSD CDROM ȤǤޤ, ξˤ FreeBSD \n"
    "  ޥɤȥ桼ƥƥեѤǤޤ,\n"
    "- ¤줿 (餯Ѳ줿) fixit եåԤȤȤ\n"
    "- Ǥޤ, ޤ϶۵ѤΥưǤޤ, ξϤǤ˺\n"
    "  ѲǽʥޥɤΥ֥åȤ¤ޤ.",
    "F1 򲡤ȽμˤĤƤΤܺ٤ʾɽޤ",
    "fixit",
{ { "X λ",	"Υ˥塼λ (ξ)",		NULL, dmenuExit },
  { "1 CDROM",	"ʪ 2ܤ \"饤\" CDROMȤ",	NULL, installFixitCDROM },
  { "2 Floppy",	"fixit 줿եåԤȤ",		NULL, installFixitFloppy },
  { "3 Shell",	"۵ѥۥեåư",	NULL, installFixitHoloShell },
  { NULL } },
};

#ifdef PCCARD
DMenu MenuPCCardBeep_j = {
    DMENU_RADIO_TYPE | DMENU_SELECTION_RETURNS,
    "PC ɥɥ⡼ɤ",
    "pccard_beep  0 ꤵȡPC ɤȴϥȥ⡼\n"
    "ˤʤޤ⤷줬 1 ޤ 2 ꤵȡɤȴ\n"
    "ݤ˥ޥ󤬥ӡײȯޤ1  2 Ϥ줾졢ץӡ \n"
    "⡼ɤȥǥ⡼ɤбޤ (ǥե: 2)",
    "F1 Ǥ˾ܤإ",
    "pccard",
    { { "0",           "ȥ⡼",
        dmenuVarCheck,  dmenuSetVariable, NULL, "pccard_beep=0" },
      { "1",           "ץӡץ⡼",
        dmenuVarCheck,  dmenuSetVariable, NULL, "pccard_beep=1" },
      { "2",           "ǥ⡼",
        dmenuVarCheck,  dmenuSetVariable, NULL, "pccard_beep=2" },
      { NULL } },
};

DMenu MenuPCCardEther_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "PC ɥͥåȥ󥿥ե",
    "pccard_ether ˥ꥹȤ줿٤ƤΥ󥿡եб ifconfig\n"
    "ΰꤹ롣⤷ѿͤ \"DHCP\" ˥åȤƤ顢DHCP\n"
    "(Dynamic Host Configuration Protocol) 饤ȤưŪб륤\n"
    "󥿡եФƵư",
    "F1 Ǥ˾ܤإ",
    "pccard",
    { { NULL } },
};

DMenu MenuPCICMem_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "PC ɥȥ餬Ѥե꡼ʥɥ쥹ꤷƲ",
    "PC ɥȥϥɾ뤿˥ΰѤ\n"
    ". ¾ΥǥХˤäƻѤƤʤɥ쥹ꤷƲ.\n"
    "⤷ʤΥϡɥФƾܤͤ狼ʤ, \n"
#ifdef PC98
    "ޤޤˤƤƤ (ǥե == 0xd0000).\n"
    "PC98 NS/A, Ne, NX/C, NL/R ѤƤʤ, Ǥ [DA] \n"
    "ꤷƲ",
#else /* PC98 */
    "ޤޤˤƤƤ (ǥե == 0xd0000).",
#endif /* PC98 */
    "F1 Ǥ˾ܤإ",
    "pccard",
    {	{ "Default", "I/O address 0xd0000 - 0xd3fff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=0"},
	{ "D4", "I/O address 0xd4000 - 0xd7fff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=1"},
	{ "D8", "I/O address 0xd8000 - 0xdbfff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=2"},
	{ "DC", "I/O address 0xdc000 - 0xdffff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=3"},
#ifdef PC98
	{ "DA", "I/O address 0xda000 - 0xdbfff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=4"},
#endif /* PC98 */
	{ NULL } },
};

#ifdef USERCONFIG_IGNIRQ
DMenu MenuCardIgnoreIRQ_j = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "PC ɥȥ餬ѤǤʤ IRQ ꤷƲ",
    "PC ѤѤ뤳ȤǤʤ IRQ 򤷤Ʋ.",
    "F1 Ǥ˾ܤإ",
    "pccard",
#ifdef PC98
    {	{ "IRQ  3(INT  0)", "2nd ꥢ, ¢ǥ",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<3)},
    	{ "IRQ  5(INT  1)", "ֳ̿, SCSI 󥿥ե",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<5)},
    	{ "IRQ  6(INT  2)", "PC ɥȥ (ǥե)",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<6)},
    	{ "IRQ 10(INT 41)", "()",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<10)},
    	{ "IRQ 12(INT  5)", "¢",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<12)},
#else /*PC98*/
#not implemented.
#endif /*PC98*/
	{ NULL } },
};
#else /* USERCONFIG_IGNIRQ */
DMenu MenuCardIRQ_j = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "Please select IRQs that CANNOT be used by PC-cards",
    "PC ɤѡ֤ǤʤIRQ ꤷƲ. Ȥ, ⤷ \n"
    "Υ󥹥ȡեåԡˤäƸФǤʤɥɤ\n"
    "줬 IRQ 5 ѤƤʤ, Υ˥塼 IRQ 5 \n"
    "ɬפޤ. ⤷ CardBus ޥѤƤʤ,\n"
    "Option 3פ뤤ϡOption 4פ򤹤ɬפ뤫Τޤ.\n",
    "F1 Ǥ˾ܤإ",
    "pccard",
    {	{ "Default", "IRQ  1 Ĥͽ󤵤Ƥޤ",
	    NULL, dmenuSetVariable, NULL, "_cardirq=0"},
	{ "Option 1", "IRQ 5 (: IRQ 5 ˥ɥ)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=1"},
	{ "Option 2", "IRQ 10 (: IRQ 10 ˥ɥ)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=2"},
	{ "Option 3", "IRQ 1-9 (: CardBus ޥ)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=3"},
	{ "Option 4", "IRQ 1-10 (: CardBus ޥ)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=4"},
	{ NULL } },
};
#endif /* USERCONFIG_IGNIRQ */
#endif /* PCCARD */
