/*
 * PC-card support for sysinstall
 *
 * $FreeBSD: src/release/sysinstall/pccard.c,v 1.5.2.3 1999/12/15 01:32:34 jkh Exp $
 *
 * Copyright (c) 1997-1999
 *	Tatsumi Hosokawa <hosokawa@jp.FreeBSD.org>.  All rights reserved.
 *
 * This software may be used, modified, copied, and distributed, in
 * both source and binary form provided that the above copyright and
 * these terms are retained. Under no circumstances is the author
 * responsible for the proper functioning of this software, nor does
 * the author assume any responsibility for damages incurred with its
 * use.
 */
/*
 * modified for PAO(98) boot floppy image
 * by Tomohiko Kurahashi <kura@tim.hi-ho.ne.jp>
 */

#include "sysinstall.h"
#include <sys/fcntl.h>
#include <sys/time.h>
#include <pccard/cardinfo.h>

#ifdef	PCCARD

int	pccard_mode = 0;

#ifndef KANJI_ONLY
DMenu MenuPCICMem = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "Please select free address area used by PC-card controller",
    "PC-card controller uses memory area to get card information.\n"
    "Please specify an address that is not used by other devices.\n"
    "If you're uncertain of detailed specification of your hardware,\n"
#ifdef PC98
    "leave it untouched (default == 0xd0000).\n"
    "If you use PC98 NS/A, Ne, NX/C or NL/R, please select [DA]\n"
    "here.",
#else /* PC98 */
    "leave it untouched (default == 0xd0000).",
#endif /* PC98 */
    "Press F1 for more HELP",
    "pccard",
    {	{ "Default",  "I/O address 0xd0000 - 0xd3fff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=0"},
	{ "D4", "I/O address 0xd4000 - 0xd7fff",
	    NULL, dmenuSetVariable, NULL, "_pcicmem=1"},
	{ "D8", "I/O address 0xd8000 - 0xdbfff",
	    NULL,  dmenuSetVariable, NULL, "_pcicmem=2"},
	{ "DC", "I/O address 0xdc000 - 0xdffff",
	    NULL,  dmenuSetVariable, NULL, "_pcicmem=3"},
#ifdef PC98
	{ "DA", "I/O address 0xda000 - 0xdbfff",
	    NULL,  dmenuSetVariable, NULL, "_pcicmem=4"},
#endif /* PC98 */
	{ NULL } },
};

#ifdef USERCONFIG_IGNIRQ
DMenu MenuCardIgnoreIRQ = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "Please select IRQs that CANNOT be used by PC-cards",
    "Please check IRQs that cannot be available to PC-card.",
    "Press F1 for more HELP",
    "pccard",
#ifdef PC98
    {	{ "IRQ  3(INT  0)", "2nd serial port, internal modem",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<3)},
    	{ "IRQ  5(INT  1)", "Infrared communication, SCSI I/F",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<5)},
    	{ "IRQ  6(INT  2)", "PC-card Controller (Default)",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<6)},
    	{ "IRQ 10(INT 41)", "(free)",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<10)},
    	{ "IRQ 12(INT  5)", "Internal sound",
	    dmenuFlagCheck, dmenuSetFlag, NULL, &pccard_ignirq, '[', 'X', ']', (1<<12)},
#else /* PC98 */
#not implemented.
#endif /* PC98 */
	{ NULL } },
};
#else /* USERCONFIG_IGNIRQ */
DMenu MenuCardIRQ = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "Please select IRQs that CANNOT be used by PC-cards",
    "Please specify an IRQs that CANNOT be used by PC-card.\n"
    "For example, if you have a sound card that can't be probed by\n"
    "this installation floppy and it uses IRQ 5, you have to specify\n"
    "IRQ 5 from this menu.  If you're using CardBus machine, you may\n"
    "have to use \"Option 3\" or \"Option 4\".\n",
    "Press F1 for more HELP",
    "pccard",
    {	{ "Default",  "No IRQ is reserved",
	    NULL, dmenuSetVariable, NULL, "_cardirq=0"},
	{ "Option 1", "IRQ 5 (ex. soundcard on IRQ 5)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=1"},
	{ "Option 2", "IRQ 10 (ex. soundcard on IRQ 10)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=2"},
	{ "Option 3", "IRQ 1-9 (ex. CardBus machine)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=3"},
	{ "Option 4", "IRQ 1-10 (ex. CardBus machine)",
	    NULL, dmenuSetVariable, NULL, "_cardirq=4"},
	{ NULL } },
};
#endif /*USERCONFIG_IGNIRQ*/
#endif /* !KANJI_ONLY */

#ifdef USERCONFIG_IGNIRQ
#ifdef PC98
u_short pccard_ignirq = (1<<6);	/* IRQ6 is used by PCIC in default */
#else
u_short pccard_ignirq = 0;
#endif

static
void setCardIgnoreIRQs(ignirqs)
char *ignirqs;
{
    int irq;

    dmenuOpenSimple(&MenuCardIgnoreIRQ, FALSE);

    ignirqs[0] = '\0';
    for(irq = 0; irq < 16; irq++) {
	if(pccard_ignirq & (1<<irq))
	    sprintf(&ignirqs[strlen(ignirqs)], "-i %d ", irq);
    }
}
#endif /* USERCONFIG_IGNIRQ */

void
pccardInitialize(void)
{
    int fd;
    int t;
    int	pcic_mem = 0xd0000;
    char card_device[16];
#ifdef USERCONFIG_IGNIRQ
#ifdef PC98
    char card_irq[31];		/* (max num of available IRQs * 6 + 1)bytes */
#else
#not implemented.
#endif
#else /* USERCONFIG_IGNIRQ */
    char *card_irq = "";
#endif
    char *spcic_mem;
#ifndef USERCONFIG_IGNIRQ
    char *scard_irq;
#endif
    char pccardd_cmd[256];
    WINDOW *w;

    if (!RunningAsInit && !Fake) {
	/* It's not my job... */
	return;
    }

    sprintf(card_device, CARD_DEVICE, 0);

    if ((fd = open(card_device, O_RDWR)) < 0) {
	msgDebug("Can't open PC-card controller %s.\n", card_device);
	return;
    } else {
	close(fd);
	KANJI_MESSAGE("PC ɥåȤդޤ\n"
		      "󥹥ȡǥ PC ɥǥХѤޤ\n");
	if (msgYesNo(KM("Found PC-card slot(s).\n"
			"Use PC-card device as installation media?\n")))
	    return;
    }

    /* Enable to PAO binary and source distributions */
    pccard_mode = 1;

    dmenuOpenSimple(&MenuPCICMem, FALSE);
    spcic_mem = variable_get("_pcicmem");
#ifndef USERCONFIG_IGNIRQ
    dmenuOpenSimple(&MenuCardIRQ, FALSE);
    scard_irq = variable_get("_cardirq");
#endif

    sscanf(spcic_mem, "%d", &t);
    switch (t) {
      case 0:
	pcic_mem = 0xd0000;
	variable_set2("pccard_mem", "DEFAULT", 1);
	break;
      case 1:
	pcic_mem = 0xd4000;
	variable_set2("pccard_mem", "0xd4000", 1);
	break;
      case 2:
	pcic_mem = 0xd8000;
	variable_set2("pccard_mem", "0xd8000", 1);
	break;
      case 3:
	pcic_mem = 0xdc000;
	variable_set2("pccard_mem", "0xdc000", 1);
	break;
#ifdef PC98
      case 4:
	pcic_mem = 0xda000;
	variable_set2("pccard_mem", "0xda000", 1);
	break;
#endif /*PC98*/
    }

#ifdef USERCONFIG_IGNIRQ
    setCardIgnoreIRQs(card_irq);
#else
    sscanf(scard_irq, "%d", &t);

    switch (t) {
      case 0:
	card_irq = " ";
	break;
      case 1:
	card_irq = " -i 5 ";
	break;
      case 2:
	card_irq = " -i 10 ";
	break;
      case 3:
	card_irq = " -i 1 -i 2 -i 3 -i 4 -i 5 -i 6 -i 7 -i 8 -i 9 ";
	break;
      case 4:
	card_irq = " -i 1 -i 2 -i 3 -i 4 -i 5 -i 6 -i 7 -i 8 -i 9 -i 10 ";
	break;
    }
#endif /* USERCONFIG_IGNIRQ */

    sprintf(card_device, CARD_DEVICE, 0);
    
    w = savescr();
    dialog_clear_norefresh();
    KANJI_MESSAGE(
    "줫 PC ɥȥȥɤνԤʤޤ⤷\n"
    "Υ󥹥ȡ PC ɥեåԡ鵯ưƤϡ줬\n"
    "󥹥ȡѥǥ (PC ɥͥåȡSCSI ) ȸ򴹤\n"
    "󥹤Ǥ󥹥ȡѥǥ [Enter] 򲡤Ʋ\n"
    "\n"
    "⤷ޤ PC ɥ󥹥ȡǥ³Ƥʤϡ\n"
    "³ [Enter] 򲡤Ʋ\n"
    "Ǥʤϡñ [Enter] 򲡤ƺȤ³ԤƲ");
    msgConfirm(KM("Now we start initializing PC-card controller and cards.\n"
	       "If you've executed this installer from a PC-card floppy\n"
	       "drive, this is the last chance to replace it with\n"
	       "installation media (PC-card Ethernet, SCSI, etc.).\n"
	       "Please insert installation media and press [Enter].\n"
	       "If you've not plugged the PC-card installation media\n"
	       "in yet, please plug it in now and press [Enter].\n"
	       "Otherwise, just press [Enter] to proceed."));

    dialog_clear();
    KANJI_MESSAGE("PC ɥȥƤޤ");
    msgNotify(KM("Initializing PC-card controller...."));
    
    if (!Fake) {
	if ((fd = open(card_device, O_RDWR)) < 0) {
	    KANJI_MESSAGE("PC ɥȥ %s Ǥޤ");
	    msgNotify(KM("Can't open PC-card controller %s.\n"),
		    card_device);
	    restorescr(w);
	    return;
	}

	if (ioctl(fd, PIOCRWMEM, &pcic_mem) < 0){
	    KANJI_MESSAGE("ioctl %s ϼԤޤ.\n");
	    msgNotify(KM("ioctl %s failed.\n"), card_device);
	    restorescr(w);
	    close(fd);
	    return;
	}
    }
    close(fd);

    strcpy(pccardd_cmd, "/stand/pccardd ");
    strcat(pccardd_cmd, card_irq);
    strcat(pccardd_cmd, " -n -z");

    variable_set2("pccardd_flags", card_irq, 1);

    vsystem(pccardd_cmd);
}

#endif	/* PCCARD */
