#!/bin/sh

# panic: refcount 0xfffff8001dd678e8 wraparound
# cpuid = 4
# time = 1580840365
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00e56517b0
# vpanic() at vpanic+0x185/frame 0xfffffe00e5651810
# panic() at panic+0x43/frame 0xfffffe00e5651870
# _refcount_update_saturated() at _refcount_update_saturated+0x15/frame 0xfffffe00e5651880
# refcount_release_last() at refcount_release_last+0x7c/frame 0xfffffe00e56518a0
# closef() at closef+0x1f7/frame 0xfffffe00e5651930
# fdescfree_fds() at fdescfree_fds+0x3c/frame 0xfffffe00e5651980
# fdescfree() at fdescfree+0x456/frame 0xfffffe00e5651a40
# exit1() at exit1+0x4f3/frame 0xfffffe00e5651ab0
# sys_sys_exit() at sys_sys_exit+0xd/frame 0xfffffe00e5651ac0
# amd64_syscall() at amd64_syscall+0x2f1/frame 0xfffffe00e5651bf0
# fast_syscall_common() at fast_syscall_common+0x101/frame 0xfffffe00e5651bf0
# --- syscall (1, FreeBSD ELF64, sys_sys_exit), rip = 0x8003d53ba, rsp = 0x7fffffffe9f8, rbp = 0x7fffffffea10 ---

# Fixed by r357554

. ../default.cfg
cat > /tmp/syzkaller1.c <<EOF

// https://syzkaller.appspot.com/bug?id=29c002256f2ce0d521d1ce007c74e456a37495a8
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i;
  for (i = 0; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  int i, call, thread;
  for (call = 0; call < 7; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 45);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

uint64_t r[3] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res;
  switch (call) {
  case 0:
    memcpy((void*)0x20000000, "./file0\000", 8);
    res = syscall(SYS_open, 0x20000000ul, 0x40000400000002c2ul, 0ul);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0ul);
    if (res != -1)
      r[1] = res;
    break;
  case 2:
    syscall(SYS_listen, r[1], 0);
    break;
  case 3:
    syscall(SYS_close, r[0]);
    break;
  case 4:
    syscall(SYS_accept, r[1], 0ul, 0ul);
    break;
  case 5:
    res = syscall(SYS_dup2, r[0], r[1]);
    if (res != -1)
      r[2] = res;
    break;
  case 6:
    syscall(SYS_mmap, 0x20ffd000ul, 0x1000ul, 0ul, 0x10ul, r[2], 0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 3ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller1 -Wall -Wextra -O2 /tmp/syzkaller1.c -lpthread ||
    exit 1

(cd /tmp; ./syzkaller1)

rm -f /tmp/syzkaller1 /tmp/syzkaller1.c /tmp/syzkaller1.core
exit 0
