#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_BIGN512V1

#ifndef __EC_PARAMS_BIGN512V1_H__
#define __EC_PARAMS_BIGN512V1_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 bign512v1_p[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(bign512v1_p);

#define CURVE_BIGN512V1_P_BITLEN 512
static const u8 bign512v1_p_bitlen[] = {
	0x02, 0x00,
};

TO_EC_STR_PARAM(bign512v1_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 bign512v1_r[] = {
	0x02, 0x39,
};

TO_EC_STR_PARAM(bign512v1_r);

static const u8 bign512v1_r_square[] = {
	0x04, 0xf0, 0xb1,
};

TO_EC_STR_PARAM(bign512v1_r_square);

static const u8 bign512v1_mpinv[] = {
	0x58, 0xa1, 0xf7, 0xe6, 0xce, 0x0f, 0x4c, 0x09,
};

TO_EC_STR_PARAM(bign512v1_mpinv);

static const u8 bign512v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(bign512v1_p_shift);

static const u8 bign512v1_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(bign512v1_p_normalized);

static const u8 bign512v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(bign512v1_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 bign512v1_r[] = {
	0x02, 0x39,
};

TO_EC_STR_PARAM(bign512v1_r);

static const u8 bign512v1_r_square[] = {
	0x04, 0xf0, 0xb1,
};

TO_EC_STR_PARAM(bign512v1_r_square);

static const u8 bign512v1_mpinv[] = {
	0xce, 0x0f, 0x4c, 0x09,
};

TO_EC_STR_PARAM(bign512v1_mpinv);

static const u8 bign512v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(bign512v1_p_shift);

static const u8 bign512v1_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(bign512v1_p_normalized);

static const u8 bign512v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(bign512v1_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 bign512v1_r[] = {
	0x02, 0x39,
};

TO_EC_STR_PARAM(bign512v1_r);

static const u8 bign512v1_r_square[] = {
	0x04, 0xf0, 0xb1,
};

TO_EC_STR_PARAM(bign512v1_r_square);

static const u8 bign512v1_mpinv[] = {
	0x4c, 0x09,
};

TO_EC_STR_PARAM(bign512v1_mpinv);

static const u8 bign512v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(bign512v1_p_shift);

static const u8 bign512v1_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(bign512v1_p_normalized);

static const u8 bign512v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(bign512v1_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 bign512v1_a[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc4,
};

TO_EC_STR_PARAM(bign512v1_a);

static const u8 bign512v1_b[] = {
	0x6c, 0xb4, 0x59, 0x44, 0x93, 0x3b, 0x8c, 0x43,
	0xd8, 0x8c, 0x5d, 0x6a, 0x60, 0xfd, 0x58, 0x89,
	0x5b, 0xc6, 0xa9, 0xee, 0xdd, 0x5d, 0x25, 0x51,
	0x17, 0xce, 0x13, 0xe3, 0xda, 0xad, 0xb0, 0x88,
	0x27, 0x11, 0xdc, 0xb5, 0xc4, 0x24, 0x5e, 0x95,
	0x29, 0x33, 0x00, 0x8c, 0x87, 0xac, 0xa2, 0x43,
	0xea, 0x86, 0x22, 0x27, 0x3a, 0x49, 0xa2, 0x7a,
	0x09, 0x34, 0x69, 0x98, 0xd6, 0x13, 0x9c, 0x90,
};

TO_EC_STR_PARAM(bign512v1_b);

#define CURVE_BIGN512V1_CURVE_ORDER_BITLEN 512
static const u8 bign512v1_curve_order[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xb2, 0xc0, 0x09, 0x2c, 0x01, 0x98, 0x00, 0x4e,
	0xf2, 0x6b, 0xeb, 0xb0, 0x2e, 0x21, 0x13, 0xf4,
	0x36, 0x1b, 0xca, 0xe5, 0x95, 0x56, 0xdf, 0x32,
	0xdc, 0xff, 0xad, 0x49, 0x0d, 0x06, 0x8e, 0xf1,
};

TO_EC_STR_PARAM(bign512v1_curve_order);

static const u8 bign512v1_gx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

TO_EC_STR_PARAM(bign512v1_gx);

static const u8 bign512v1_gy[] = {
	0xa8, 0x26, 0xff, 0x7a, 0xe4, 0x03, 0x76, 0x81,
	0xb1, 0x82, 0xe6, 0xf7, 0xa0, 0xd1, 0x8f, 0xab,
	0xb0, 0xab, 0x41, 0xb3, 0xb3, 0x61, 0xbc, 0xe2,
	0xd2, 0xed, 0xf8, 0x1b, 0x00, 0xcc, 0xca, 0xda,
	0x69, 0x73, 0xdd, 0xe2, 0x0e, 0xfa, 0x6f, 0xd2,
	0xff, 0x77, 0x73, 0x95, 0xee, 0xe8, 0x22, 0x61,
	0x67, 0xaa, 0x83, 0xb9, 0xc9, 0x4c, 0x0d, 0x04,
	0xb7, 0x92, 0xae, 0x6f, 0xce, 0xef, 0xed, 0xbd,
};

TO_EC_STR_PARAM(bign512v1_gy);

static const u8 bign512v1_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(bign512v1_gz);

static const u8 bign512v1_gen_order[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xb2, 0xc0, 0x09, 0x2c, 0x01, 0x98, 0x00, 0x4e,
	0xf2, 0x6b, 0xeb, 0xb0, 0x2e, 0x21, 0x13, 0xf4,
	0x36, 0x1b, 0xca, 0xe5, 0x95, 0x56, 0xdf, 0x32,
	0xdc, 0xff, 0xad, 0x49, 0x0d, 0x06, 0x8e, 0xf1,
};

TO_EC_STR_PARAM(bign512v1_gen_order);

#define CURVE_BIGN512V1_Q_BITLEN 512
static const u8 bign512v1_gen_order_bitlen[] = {
	0x02, 0x00,
};

TO_EC_STR_PARAM(bign512v1_gen_order_bitlen);

static const u8 bign512v1_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(bign512v1_cofactor);

static const u8 bign512v1_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(bign512v1_alpha_montgomery, 0);

static const u8 bign512v1_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(bign512v1_gamma_montgomery, 0);

static const u8 bign512v1_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(bign512v1_alpha_edwards, 0);

static const u8 bign512v1_name[] = "BIGN512V1";
TO_EC_STR_PARAM(bign512v1_name);

static const u8 bign512v1_oid[] = "1.2.112.0.2.0.34.101.45.3.3";
TO_EC_STR_PARAM(bign512v1_oid);

static const ec_str_params bign512v1_str_params = {
	.p = &bign512v1_p_str_param,
	.p_bitlen = &bign512v1_p_bitlen_str_param,
	.r = &bign512v1_r_str_param,
	.r_square = &bign512v1_r_square_str_param,
	.mpinv = &bign512v1_mpinv_str_param,
	.p_shift = &bign512v1_p_shift_str_param,
	.p_normalized = &bign512v1_p_normalized_str_param,
	.p_reciprocal = &bign512v1_p_reciprocal_str_param,
	.a = &bign512v1_a_str_param,
	.b = &bign512v1_b_str_param,
	.curve_order = &bign512v1_curve_order_str_param,
	.gx = &bign512v1_gx_str_param,
	.gy = &bign512v1_gy_str_param,
	.gz = &bign512v1_gz_str_param,
	.gen_order = &bign512v1_gen_order_str_param,
	.gen_order_bitlen = &bign512v1_gen_order_bitlen_str_param,
	.cofactor = &bign512v1_cofactor_str_param,
	.alpha_montgomery = &bign512v1_alpha_montgomery_str_param,
	.gamma_montgomery = &bign512v1_gamma_montgomery_str_param,
	.alpha_edwards = &bign512v1_alpha_edwards_str_param,
	.oid = &bign512v1_oid_str_param,
	.name = &bign512v1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_BIGN512V1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_BIGN512V1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_BIGN512V1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_BIGN512V1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_BIGN512V1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_BIGN512V1_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 1)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 1
#endif
#if (MAX_CURVE_NAME_LEN < 23)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 23
#endif

#endif /* __EC_PARAMS_BIGN512V1_H__ */

#endif /* WITH_CURVE_BIGN512V1 */
