/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <iostream.h>

#include "xhtmldecorator.h"
#include "xhtmltags.h"
#include "htmltags.h"
#include "colors.h"

// for globals
#include "globalostream.h"

XhtmlTagDecorator::XhtmlTagDecorator( TextGenerator *t, CharTranslator *ct, 
                                      char *ta, char *a, char *v ) :
  TagDecorator (t, ct, ta, a, v)
{
}

void
XhtmlTagDecorator::generateAttrVal() const
{
  (*sout) << " style=\"" << attr << ": " << val << "\"";
}

// XhtmlColorDecorator
XhtmlColorDecorator::XhtmlColorDecorator( TextGenerator *t, CharTranslator *tr,
                                          char *color ) :
  XhtmlTagDecorator( t, tr, SPAN_TAG, COLOR_TAG, color )
{
}

