%{
/*
 * Copyright (C) 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */                         

/*
  This scanner for PHP3 was written by
  Alain Barbet <alian@alianwebserver.com>
*/

/*
  Here a perl parser that extract php3 name of func from documentation:

#!/usr/bin/perl
my ($pre,$f);
my $u = $ARGV[0];
system("wget $u");
if ($u=~/(ref\..*)$/) { $f=$1;}
if ($f=~/ref\.(.*)\.html/)
  { $pre = $1; }
open(F,$f);
my $buf = "keyword_$pre(";
while (my $ligne = <F>)
  {
    chomp($ligne);
    if ($ligne=~/<dt><a href=".*">(.*)<\/a> (&\#8212;|_||&#151;)/i) 
	{ $buf.= $1."|"; }
  }
chop($buf);
$buf.=")\n";
print $buf;
close(F);

*/
static int lineno = 1 ; /* number of scanned lines */
//char linebuf[1024] ; /* current code line in the source */
//int tokenpos = 0 ; /* current token position in the current line */

//#include "tags.h"
//#include "tokens.h"
//#include "colors.h"
#include "genfun.h"

%}
%option prefix="php3_scanner_"
%option noyywrap

nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>

keyword1 (if|else|elseif|endif|do|while|for|break|continue|switch|require|include|global|class|dl|header|setcookie|function|is_array|return|unset)

keyword_adabas(ada_afetch|ada_autocommit|ada_close|ada_commit|ada_connect|ada_exec|ada_fetchrow|ada_fieldname|ada_fieldnum|ada_fieldtype|ada_freeresult|ada_numfields|ada_numrows|ada_result|ada_resultall|ada_rollback)

keyword_apache(apache_lookup_uri|apache_note|getallheaders|virtual)
keyword_aspell(aspell_new|aspell_check|aspell_check-raw|aspell_suggest)
keyword_bc(bcadd|bccomp|bcdiv|bcmod|bcmul|bcpow|bcscale|bcsqrt|bcsub)

keyword_array(array|array_push|array_pop|array_unshift|array_shift|array_slice|array_splice|array_merge|array_keys|array_values|array_walk|arsort|asort|compact|count|current|each|end|extract|in_array|key|ksort|list|next|pos|prev|range|reset|rsort|shuffle|sizeof|sort|uasort|uksort|usort)

keyword_calendar(JDToGregorian|GregorianToJD|JDToJulian|JulianToJD|JDToJewish|JewishToJD|JDToFrench|FrenchToJD|JDMonthName|JDDayOfWeek|easter_date|easter_days)

keyword_cpdf(cpdf_set_creator|cpdf_set_title|cpdf_set_subject|cpdf_set_keywords|cpdf_open|cpdf_close|cpdf_page_init|cpdf_finalize_page|cpdf_finalize|cpdf_output_buffer|cpdf_save_to_file|cpdf_set_current_page|cpdf_begin_text|cpdf_end_text|cpdf_show|cpdf_show_xy|cpdf_text|cpdf_set_font|cpdf_set_leading|cpdf_set_text_rendering|cpdf_set_horiz_scaling|cpdf_set_text_rise|cpdf_set_text_matrix|cpdf_set_text_pos|cpdf_set_char_spacing|cpdf_set_word_spacing|cpdf_continue_text|cpdf_stringwidth|cpdf_save|cpdf_restore|cpdf_translate|cpdf_scale|cpdf_rotate|cpdf_setflat|cpdf_setlinejoin|cpdf_setlinecap|cpdf_setmiterlimit|cpdf_setlinewidth|cpdf_setdash|cpdf_moveto|cpdf_rmoveto|cpdf_curveto|cpdf_lineto|cpdf_rlineto|cpdf_circle|cpdf_arc|cpdf_rect|cpdf_closepath|cpdf_stroke|cpdf_closepath_stroke|cpdf_fill|cpdf_fill_stroke|cpdf_closepath_fill_stroke|cpdf_clip|cpdf_setgray_fill|cpdf_setgray_stroke|cpdf_setgray|cpdf_setrgbcolor_fill|cpdf_setrgbcolor_stroke|cpdf_setrgbcolor|cpdf_add_outline|cpdf_set_page_animation|cpdf_import_jpeg|cpdf_place_inline_image|cpdf_add_annotation)

keyword_datetime(checkdate|date|strftime|gmstrftime|getdate|gettimeofday|gmdate|mktime|gmmktime|time|microtime)

keyword_dba(dba_close|dba_delete|dba_exists|dba_fetch|dba_firstkey|dba_insert|dba_nextkey|dba_popen|dba_open|dba_optimize|dba_replace|dba_sync)

keyword_dbase(dbase_create|dbase_open|dbase_close|dbase_pack|dbase_add_record|dbase_replace_record|dbase_delete_record|dbase_get_record|dbase_numfields|dbase_numrecords)

keyword_dbm(dbmopen|dbmclose|dbmexists|dbmfetch|dbminsert|dbmreplace|dbmdelete|dbmfirstkey|dbmnextkey|dblist)

keyword_dir(chdir|dir|closedir|opendir|readdir|rewinddir)

keyword_fdf(fdf_open|fdf_close|fdf_create|fdf_save|fdf_get_value|fdf_set_value|fdf_next_field_name|fdf_set_ap|fdf_set_status|fdf_get_status|fdf_set_file|fdf_get_file)

keyword_filesystem(basename|chgrp|chmod|chown|clearstatcache|copy|delete|dirname|diskfreespace|fclose|feof|fgetc|fgetcsv|fgets|fgetss|file|file_exists|fileatime|filectime|filegroup|fileinode|filemtime|fileowner|fileperms|filesize|filetype|flock|fopen|fpassthru|fputs|fread|fseek|ftell|fwrite|set_file_buffer|is_dir|is_executable|is_file|is_link|is_readable|is_writeable|link|linkinfo|mkdir|pclose|popen|readfile|readlink|rename|rewind|rmdir|stat|lstat|symlink|tempnam|touch|umask|unlink)

keyword_filepro(filepro|filepro_fieldname|filepro_fieldtype|filepro_fieldwidth|filepro_retrieve|filepro_fieldcount|filepro_rowcount)

keyword_hyperwave(hw_Children|hw_ChildrenObj|hw_Close|hw_Connect|hw_Cp|hw_Deleteobject|hw_DocByAnchor|hw_DocByAnchorObj|hw_DocumentAttributes|hw_DocumentBodyTag|hw_DocumentContent|hw_DocumentSetContent|hw_DocumentSize|hw_ErrorMsg|hw_EditText|hw_Error|hw_Free_Document|hw_GetParents|hw_GetParentsObj|hw_GetChildColl|hw_GetChildCollObj|hw_GetRemote|hw_GetRemoteChildren|hw_GetSrcByDestObj|hw_GetObject|hw_GetAndLock|hw_GetText|hw_GetObjectByQuery|hw_GetObjectByQueryObj|hw_GetObjectByQueryColl|hw_GetObjectByQueryCollObj|hw_GetChildDocColl|hw_GetChildDocCollObj|hw_GetAnchors|hw_GetAnchorsObj|hw_Mv|hw_Identify|hw_InCollections|hw_Info|hw_InsColl|hw_InsDoc|hw_InsertDocument|hw_InsertObject|hw_Modifyobject|hw_New_Document|hw_Objrec2Array|hw_OutputDocument|hw_pConnect|hw_PipeDocument|hw_Root|hw_Unlock|hw_Who|hw_Username)

keyword_image(GetImageSize|ImageArc|ImageChar|ImageCharChapitre|ImageColorAllocate|ImageColorTransparent|ImageCopyResized|ImageCreate|ImageCreateFromGif|ImageDashedLine|ImageDestroy|ImageFill|ImageFilledPolygon|ImageFilledRectangle|ImageFillToBorder|ImageFontHeight|ImageFontWidth|ImageGif|ImageInterlace|ImageLine|ImageLoadFont|ImagePolygon|ImageRectangle|ImageSetPixel|ImageString|ImageStringChapitre|ImageSX|ImageSY|ImageTTFBBox|ImageTTFText|ImageColorAt|ImageColorClosest|ImageColorExact|ImageColorResolve|ImageColorSet|ImageColorsForIndex|ImageColorsTotal|ImagePSLoadFont|ImagePSFreeFont|ImagePSEncodeFont|ImagePSText|ImagePSBBox)

keyword_imap(imap_append|imap_base64|imap_body|imap_check|imap_close|imap_createmailbox|imap_delete|imap_deletemailbox|imap_expunge|imap_fetchbody|imap_fetchstructure|imap_header|imap_headers|imap_listmailbox|imap_listsubscribed|imap_mail_copy|imap_mail_move|imap_num_msg|imap_num_recent|imap_open|imap_ping|imap_renamemailbox|imap_reopen|imap_subscribe|imap_undelete|imap_unsubscribe|imap_qprint|imap_8bit|imap_binary|imap_scanmailbox|imap_mailboxmsginfo|imap_rfc822_write_address|imap_rfc822_parse_adrlist|imap_setflag_full|imap_clearflag_full|imap_sort|imap_fetchheader|imap_uid)

keyword_info(error_log|error_reporting|getenv|get_cfg_var|get_current_user|get_magic_quotes_gpc|get_magic_quotes_runtime|getlastmod|getmyinode|getmypid|getmyuid|getrusage|phpinfo|phpversion|extension_loaded|putenv|set_magic_quotes_runtime|set_time_limit)

keyword_ifx(ifx_connect|ifx_pconnect|ifx_close|ifx_query|ifx_prepare|ifx_do|ifx_error|ifx_errormsg|ifx_affected_rows|ifx_getsqlca|ifx_fetch_row|ifx_htmltbl_result|ifx_fieldtypes|ifx_fieldproperties|ifx_num_fields|ifx_num_rows|ifx_free_result|ifx_create_char|ifx_free_char|ifx_update_char|ifx_get_char|ifx_create_blob|ifx_copy_blob|ifx_free_blob|ifx_get_blob|ifx_update_blob|ifx_blobinfile_mode|ifx_textasvarchar|ifx_byteasvarchar|ifx_nullformat|ifxus_create_slob|ifx_free_slob|ifxus_close_slob|ifxus_open_slob|ifxus_tell_slob|ifxus_seek_slob|ifxus_read_slob|ifxus_write_slob)

keyword_ibase(ibase_connect|ibase_pconnect|ibase_close|ibase_query|ibase_fetch_row|ibase_free_result|ibase_prepare|ibase_bind|ibase_execute|ibase_free_query|ibase_timefmt)

keyword_ldap(ldap_add|ldap_mod_add|ldap_mod_del|ldap_mod_replace|ldap_bind|ldap_close|ldap_connect|ldap_count_entries|ldap_delete|ldap_dn2ufn|ldap_explode_dn|ldap_first_attribute|ldap_first_entry|ldap_free_result|ldap_get_attributes|ldap_get_dn|ldap_get_entries|ldap_get_values|ldap_list|ldap_modify|ldap_next_attribute|ldap_next_entry|ldap_read|ldap_search|ldap_unbind)

keyword_math(Abs|Acos|Asin|Atan|Atan2|base_convert|BinDec|Ceil|Cos|DecBin|DecHex|DecOct|Exp|Floor|getrandmax|HexDec|Log|Log10|max|min|mt_rand|mt_srand|mt_getrandmax|number_format|OctDec|pi|pow|rand|round|Sin|Sqrt|srand|Tan)

keyword_mcrypt(mcrypt_get_cipher_name|mcrypt_get_block_size|mcrypt_get_key_size|mcrypt_create_iv|mcrypt_cbc|mcrypt_cfb|mcrypt_ecb|mcrypt_ofb)

keyword_mhash(mhash_get_hash_name|mhash_get_block_size|mhash_count|mhash)

keyword_misc(connection_aborted|connection_status|connection_timeout|eval|die|exit|function_exists|ignore_user_abort|iptcparse|leak|pack|register_shutdown_function|serialize|sleep|unpack|unserialize|uniqid|usleep)

keyword_msql(mysql_affected_rows|mysql_close|mysql_connect|mysql_create_db|mysql_data_seek|mysql_db_query|mysql_drop_db|mysql_errno|mysql_error|mysql_fetch_array|mysql_fetch_field|mysql_fetch_lengths|mysql_fetch_object|mysql_fetch_row|mysql_field_name|mysql_field_seek|mysql_field_table|mysql_field_type|mysql_field_flags|mysql_field_len|mysql_free_result|mysql_insert_id|mysql_list_fields|mysql_list_dbs|mysql_list_tables|mysql_num_fields|mysql_num_rows|mysql_pconnect|mysql_query|mysql_result|mysql_select_db|mysql_tablename|MySQL_NUMROWS)

keyword_mssql(mssql_close|mssql_connect|mssql_data_seek|mssql_fetch_array|mssql_fetch_field|mssql_fetch_object|mssql_fetch_row|mssql_field_seek|mssql_free_result|mssql_num_fields|mssql_num_rows|mssql_pconnect|mssql_query|mssql_result|mssql_select_db)

keyword_mysql(mysql_affected_rows|mysql_close|mysql_connect|mysql_create_db|mysql_data_seek|mysql_db_query|mysql_drop_db|mysql_errno|mysql_error|mysql_fetch_array|mysql_fetch_field|mysql_fetch_lengths|mysql_fetch_object|mysql_fetch_row|mysql_field_name|mysql_field_seek|mysql_field_table|mysql_field_type|mysql_field_flags|mysql_field_len|mysql_free_result|mysql_insert_id|mysql_list_fields|mysql_list_dbs|mysql_list_tables|mysql_num_fields|mysql_num_rows|mysql_pconnect|mysql_query|mysql_result|mysql_select_db|mysql_tablename)

keyword_sybase(sybase_affected_rows|sybase_close|sybase_connect|sybase_data_seek|sybase_fetch_array|sybase_fetch_field|sybase_fetch_object|sybase_fetch_row|sybase_field_seek|sybase_free_result|sybase_num_fields|sybase_num_rows|sybase_pconnect|sybase_query|sybase_result|sybase_select_db)

keyword_network(fsockopen|pfsockopen|set_socket_blocking|gethostbyaddr|gethostbyname|gethostbynamel|checkdnsrr|getmxrr|openlog|syslog|closelog|debugger_on|debugger_off)

keyword_odbc(odbc_autocommit|odbc_binmode|odbc_close|odbc_close_all|odbc_commit|odbc_connect|odbc_cursor|odbc_do|odbc_exec|odbc_execute|odbc_fetch_into|odbc_fetch_row|odbc_field_name|odbc_field_type|odbc_field_len|odbc_free_result|odbc_longreadlen|odbc_num_fields|odbc_pconnect|odbc_prepare|odbc_num_rows|odbc_result|odbc_result_all|odbc_rollback|odbc_setoption)

keyword_oci8(OCIDefineByName|OCIBindByName|OCILogon|OCIPLogon|OCINLogon|OCILogOff|OCIExecute|OCICommit|OCIRollback|OCINewDescriptor|OCIRowCount|OCINumCols|OCIResult|OCIFetch|OCIFetchInto|OCIFetchStatement|OCIColumnIsNULL|OCIColumnSize|OCIServerVersion|OCIStatementType|OCINewCursor|OCIFreeStatement|OCIFreeCursor|OCIColumnName|OCIColumnType|OCIParse|OCIError|OCIInternalDebug)

keyword_oracle(Ora_Bind|Ora_Close|Ora_ColumnName|Ora_ColumnType|Ora_Commit|Ora_CommitOff|Ora_CommitOn|Ora_Error|Ora_ErrorCode|Ora_Exec|Ora_Fetch|Ora_GetColumn|Ora_Logoff|Ora_Logon|Ora_Open|Ora_Parse|Ora_Rollback)

keyword_pcre(preg_match|preg_match_all|preg_replace|preg_split|preg_quote|preg_grep)

keyword_pdf(PDF_get_info|PDF_set_info_creator|PDF_set_info_title|PDF_set_info_subject|PDF_set_info_keywords|PDF_set_info_author|PDF_open|PDF_close|PDF_begin_page|PDF_end_page|PDF_show|PDF_show_xy|PDF_set_font|PDF_set_leading|PDF_set_text_rendering|PDF_set_horiz_scaling|PDF_set_text_rise|PDF_set_text_matrix|PDF_set_text_pos|PDF_set_char_spacing|PDF_set_word_spacing|PDF_continue_text|PDF_stringwidth|PDF_save|PDF_restore|PDF_translate|PDF_scale|PDF_rotate|PDF_setflat|PDF_setlinejoin|PDF_setlinecap|PDF_setmiterlimit|PDF_setlinewidth|PDF_setdash|PDF_moveto|PDF_curveto|PDF_lineto|PDF_circle|PDF_arc|PDF_rect|PDF_closepath|PDF_stroke|PDF_closepath_stroke|PDF_fill|PDF_fill_stroke|PDF_closepath_fill_stroke|PDF_endpath|PDF_clip|PDF_setgray_fill|PDF_setgray_stroke|PDF_setgray|PDF_setrgbcolor_fill|PDF_setrgbcolor_stroke|PDF_setrgbcolor|PDF_add_outline|PDF_set_transition|PDF_set_duration|PDF_open_gif|PDF_open_memory_image|PDF_open_jpeg|PDF_close_image|PDF_place_image|PDF_put_image|PDF_execute_image|pdf_add_annotation)

keyword_pgsql(pg_Close|pg_cmdTuples|pg_Connect|pg_DBname|pg_ErrorMessage|pg_Exec|pg_Fetch_Array|pg_Fetch_Object|pg_Fetch_Row|pg_FieldIsNull|pg_FieldName|pg_FieldNum|pg_FieldPrtLen|pg_FieldSize|pg_FieldType|pg_FreeResult|pg_GetLastOid|pg_Host|pg_loclose|pg_locreate|pg_loopen|pg_loread|pg_loreadall|pg_lounlink|pg_lowrite|pg_NumFields|pg_NumRows|pg_Options|pg_pConnect|pg_Port|pg_Result|pg_tty)

keyword_regex(ereg|ereg_replace|eregi|eregi_replace|split|sql_regcase)

keyword_sem(sem_get|sem_acquire|sem_release|shm_attach|shm_detach|shm_remove|shm_put_var|shm_get_var|shm_remove_var)

keyword_solid(solid_close|solid_connect|solid_exec|solid_fetchrow|solid_fieldname|solid_fieldnum|solid_freeresult|solid_numfields|solid_numrows|solid_result)

keyword_snmp(snmpget|snmpset|snmpwalk|snmpwalkoid|snmp_get_quick_print|snmp_set_quick_print)

keyword_strings(AddSlashes|bin2hex|Chop|Chr|chunk_split|convert_cyr_string|crypt|echo|explode|flush|get_meta_tags|htmlspecialchars|htmlentities|implode|join|ltrim|md5|nl2br|Ord|parse_str|print|printf|quoted_printable_decode|QuoteMeta|rawurldecode|rawurlencode|setlocale|similar_text|soundex|sprintf|strchr|strcmp|strcspn|strip_tags|StripSlashes|strlen|strrpos|strpos|strrchr|strrev|strspn|strstr|strtok|strtolower|strtoupper|str_replace|strtr|substr|trim|ucfirst|ucwords)

keyword_url(parse_url|urldecode|urlencode|base64_encode|base64_decode)
keyword_vmailmgr(vm_adduser|vm_addalias|vm_passwd|vm_delalias|vm_deluser)

keyword_wddx(wddx_serialize_value|wddx_serialize_vars|wddx_packet_start|wddx_packet_end|wddx_add_vars|wddx_deserialize)

keyword_zlib(gzclose|gzeof|gzfile|gzgetc|gzgets|gzgetss|gzopen|gzpassthru|gzputs|gzread|gzrewind|gzseek|gztell|readgzfile|gzwrite)

keyword_xml(xml_parser_create|xml_set_element_handler|xml_set_character_data_handler|xml_set_processing_instruction_handler|xml_set_default_handler|xml_set_unparsed_entity_decl_handler|xml_set_notation_decl_handler|xml_set_external_entity_ref_handler|xml_parse|xml_get_error_code|xml_error_string|xml_get_current_line_number|xml_get_current_column_number|xml_get_current_byte_index|xml_parser_free|xml_parser_set_option|xml_parser_get_option|utf8_decode|utf8_encode)

keyword ({keyword1}|{keyword_adabas}|{keyword_mcrypt}|{keyword_pdf}|{keyword_apache}|{keyword_fdf}|{keyword_mhash}|{keyword_pgsql}|{keyword_array}|{keyword_filepro}|{keyword_misc}|{keyword_regex}|{keyword_filesystem}|{keyword_msql}|{keyword_sem}|{keyword_aspell}|{keyword_hyperwave}|{keyword_snmp}|{keyword_bc}|{keyword_ibase}|{keyword_mssql}|{keyword_solid}|{keyword_calendar}|{keyword_ifx}|{keyword_mysql}|{keyword_strings}|{keyword_cpdf}|{keyword_image}|{keyword_network}|{keyword_sybase}|{keyword_datetime}|{keyword_url}|{keyword_dba}|{keyword_imap}|{keyword_oci8}|{keyword_vmailmgr}|{keyword_dbase}|{keyword_info}|{keyword_odbc}|{keyword_wddx}|{keyword_dbm}|{keyword_ldap}|{keyword_oracle}|{keyword_xml}|{keyword_dir}|{keyword_math}|{keyword_pcre}|{keyword_zlib})

symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]
cbracket [\{\}]

funccall    {IDE}/{wspace}*({templspec})?{wspace}*\(

%%

<INITIAL>"#" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another # during a comment we simply
      treat it as a ordinary string */
 }

<INITIAL>"/*" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
<INITIAL>"/*".*"*/" { generateComment( yytext ) ;  }

<COMMENT_STATE>\n { 
   endComment (""); 
   ++lineno;
   generateNewLine() ;
   startComment ("");
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"*/" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"//" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\n { 
   endString (""); 
   ++lineno;
   generateNewLine() ;
   startString ("");
}
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }

<INITIAL>{keyword}/{wspace}*\( { generateKeyWord( yytext ) ; }
<INITIAL>($[0-9a-zA-Z_]*) { generateBaseType( yytext ) ; }
<INITIAL>(@[0-9a-zA-Z_]*) { generateBaseType( yytext ) ; }
<INITIAL>(%[0-9a-zA-Z_]*) { generateBaseType( yytext ) ; }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>\<[^\"\n ]*\> { generateString (yytext); }

<INITIAL>[a-zA-Z_]([a-zA-Z0-9_])* { generate_normal( yytext ) ; }

\t {
        generateTab() ;
}

. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%
/*
void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
*/
/* vim:set ft=flex expandtab cindent tabstop=4 softtabstop=4 shiftwidth=4 textwidth=0: */
