--
-- This file is part of TALER
-- Copyright (C) 2023 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE receipts_issued
  (receipt_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,blinded_sig BYTEA[] NOT NULL
  ,charity_id BIGINT NOT NULL REFERENCES charities (charity_id) ON DELETE CASCADE
  ,receipt_hash BYTEA PRIMARY KEY CHECK (LENGTH(receipt_hash)=64)
  ,amount taler_amount NOT NULL
  );
COMMENT ON TABLE receipts_issued
  IS 'Table containing the issued blinded donation receipts.';
COMMENT ON COLUMN receipts_issued.blinded_sig
  IS 'Array of blinded signatures. Blind signed BKPs by the Donau';
COMMENT ON COLUMN receipts_issued.receipt_hash
  IS 'Hash value over all the blinded donation receipt received plus the hash of the donation units public key.';
