/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_unit.h
 * @brief implementation of the select_unit function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_SELECT_UNIT_H
#define PG_SELECT_UNIT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Lookup a measurement unit by identifier.
 *
 * @param cls closure
 * @param instance_id instance owning the unit
 * @param unit_id symbolic identifier
 * @param[out] ud unit details on success; may be NULL to test for existence
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_select_unit (void *cls,
                    const char *instance_id,
                    const char *unit_id,
                    struct TALER_MERCHANTDB_UnitDetails *ud);

#endif
