/*
 This file is part of GNU Anastasis
 (C) 2021-2022 Anastasis SARL

 GNU Anastasis is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Anastasis is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License along with
 GNU Anastasis; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import {
  ChallengeFeedbackStatus,
  ReducerState,
} from "@gnu-taler/anastasis-core";
import { reducerStatesExample } from "../../../utils/index.js";
import { authMethods as TestedComponent, KnownAuthMethods } from "./index.js";
import * as tests from "@gnu-taler/web-util/testing";
import { AmountString } from "@gnu-taler/taler-util";

export default {
  title: "Auth method: Question solve",
  component: TestedComponent,
  args: {
    order: 5,
  },
  argTypes: {
    onUpdate: { action: "onUpdate" },
    onBack: { action: "onBack" },
  },
};

const type: KnownAuthMethods = "question";

export const WithoutFeedback = tests.createExample(
  TestedComponent[type].solve,
  {
    id: "uuid-1",
  },
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information: {
      challenges: [
        {
          instructions: "does P equals NP?",
          type: "question",
          uuid: "uuid-1",
        },
      ],
      policies: [],
    },
    selected_challenge_uuid: "uuid-1",
  } as ReducerState,
);

const recovery_information = {
  challenges: [
    {
      instructions: "does P equal NP?",
      type: "question",
      uuid: "ASDASDSAD!1",
    },
  ],
  policies: [],
};

export const CodeInFileFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.CodeInFile,
        filename: "asd",
        display_hint: "hint",
      },
    },
  } as ReducerState,
);

export const CodeSentFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.CodeSent,
        address_hint: "asdasd",
        display_hint: "qweqweqw",
      },
    },
  } as ReducerState,
);

export const SolvedFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.Solved,
      },
    },
  } as ReducerState,
);

export const ServerFailureFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.ServerFailure,
        http_status: 500,
      },
    },
  } as ReducerState,
);

export const TruthUnknownFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.TruthUnknown,
      },
    },
  } as ReducerState,
);

export const TalerPaymentFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.TalerPayment,
        payment_secret: "secret",
        provider: "asdasdas",
        taler_pay_uri: "taler://pay/...",
      },
    },
  } as ReducerState,
);

export const UnsupportedFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.Unsupported,
        unsupported_method: "method",
      },
    },
  } as ReducerState,
);

export const RateLimitExceededFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.RateLimitExceeded,
      },
    },
  } as ReducerState,
);

export const IbanInstructionsFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.IbanInstructions,
        challenge_amount: "EUR:1" as AmountString,
        target_iban: "DE12345789000",
        target_business_name: "Data Loss Incorporated",
        wire_transfer_subject: "Anastasis 987654321",
        answer_code: 987654321,
      },
    },
  } as ReducerState,
);

export const IncorrectAnswerFeedback = tests.createExample(
  TestedComponent[type].solve,
  {},
  {
    ...reducerStatesExample.challengeSolving,
    recovery_information,
    selected_challenge_uuid: "ASDASDSAD!1",
    challenge_feedback: {
      "ASDASDSAD!1": {
        state: ChallengeFeedbackStatus.IncorrectAnswer,
      },
    },
  } as ReducerState,
);
