// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: cc/arduino/cli/commands/v1/commands.proto

package commands

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ArduinoCoreService_Create_FullMethodName                            = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Create"
	ArduinoCoreService_Init_FullMethodName                              = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Init"
	ArduinoCoreService_Destroy_FullMethodName                           = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Destroy"
	ArduinoCoreService_UpdateIndex_FullMethodName                       = "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateIndex"
	ArduinoCoreService_UpdateLibrariesIndex_FullMethodName              = "/cc.arduino.cli.commands.v1.ArduinoCoreService/UpdateLibrariesIndex"
	ArduinoCoreService_Version_FullMethodName                           = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Version"
	ArduinoCoreService_NewSketch_FullMethodName                         = "/cc.arduino.cli.commands.v1.ArduinoCoreService/NewSketch"
	ArduinoCoreService_LoadSketch_FullMethodName                        = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LoadSketch"
	ArduinoCoreService_ArchiveSketch_FullMethodName                     = "/cc.arduino.cli.commands.v1.ArduinoCoreService/ArchiveSketch"
	ArduinoCoreService_SetSketchDefaults_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/SetSketchDefaults"
	ArduinoCoreService_BoardDetails_FullMethodName                      = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardDetails"
	ArduinoCoreService_BoardList_FullMethodName                         = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardList"
	ArduinoCoreService_BoardListAll_FullMethodName                      = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListAll"
	ArduinoCoreService_BoardSearch_FullMethodName                       = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardSearch"
	ArduinoCoreService_BoardIdentify_FullMethodName                     = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardIdentify"
	ArduinoCoreService_BoardListWatch_FullMethodName                    = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BoardListWatch"
	ArduinoCoreService_Compile_FullMethodName                           = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Compile"
	ArduinoCoreService_PlatformInstall_FullMethodName                   = "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformInstall"
	ArduinoCoreService_PlatformDownload_FullMethodName                  = "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformDownload"
	ArduinoCoreService_PlatformUninstall_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformUninstall"
	ArduinoCoreService_PlatformUpgrade_FullMethodName                   = "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformUpgrade"
	ArduinoCoreService_Upload_FullMethodName                            = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Upload"
	ArduinoCoreService_UploadUsingProgrammer_FullMethodName             = "/cc.arduino.cli.commands.v1.ArduinoCoreService/UploadUsingProgrammer"
	ArduinoCoreService_SupportedUserFields_FullMethodName               = "/cc.arduino.cli.commands.v1.ArduinoCoreService/SupportedUserFields"
	ArduinoCoreService_ListProgrammersAvailableForUpload_FullMethodName = "/cc.arduino.cli.commands.v1.ArduinoCoreService/ListProgrammersAvailableForUpload"
	ArduinoCoreService_BurnBootloader_FullMethodName                    = "/cc.arduino.cli.commands.v1.ArduinoCoreService/BurnBootloader"
	ArduinoCoreService_PlatformSearch_FullMethodName                    = "/cc.arduino.cli.commands.v1.ArduinoCoreService/PlatformSearch"
	ArduinoCoreService_LibraryDownload_FullMethodName                   = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryDownload"
	ArduinoCoreService_LibraryInstall_FullMethodName                    = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryInstall"
	ArduinoCoreService_LibraryUpgrade_FullMethodName                    = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUpgrade"
	ArduinoCoreService_ZipLibraryInstall_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/ZipLibraryInstall"
	ArduinoCoreService_GitLibraryInstall_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/GitLibraryInstall"
	ArduinoCoreService_LibraryUninstall_FullMethodName                  = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUninstall"
	ArduinoCoreService_LibraryUpgradeAll_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryUpgradeAll"
	ArduinoCoreService_LibraryResolveDependencies_FullMethodName        = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryResolveDependencies"
	ArduinoCoreService_LibrarySearch_FullMethodName                     = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibrarySearch"
	ArduinoCoreService_LibraryList_FullMethodName                       = "/cc.arduino.cli.commands.v1.ArduinoCoreService/LibraryList"
	ArduinoCoreService_Monitor_FullMethodName                           = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Monitor"
	ArduinoCoreService_EnumerateMonitorPortSettings_FullMethodName      = "/cc.arduino.cli.commands.v1.ArduinoCoreService/EnumerateMonitorPortSettings"
	ArduinoCoreService_Debug_FullMethodName                             = "/cc.arduino.cli.commands.v1.ArduinoCoreService/Debug"
	ArduinoCoreService_IsDebugSupported_FullMethodName                  = "/cc.arduino.cli.commands.v1.ArduinoCoreService/IsDebugSupported"
	ArduinoCoreService_GetDebugConfig_FullMethodName                    = "/cc.arduino.cli.commands.v1.ArduinoCoreService/GetDebugConfig"
	ArduinoCoreService_CheckForArduinoCLIUpdates_FullMethodName         = "/cc.arduino.cli.commands.v1.ArduinoCoreService/CheckForArduinoCLIUpdates"
	ArduinoCoreService_CleanDownloadCacheDirectory_FullMethodName       = "/cc.arduino.cli.commands.v1.ArduinoCoreService/CleanDownloadCacheDirectory"
	ArduinoCoreService_ConfigurationSave_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/ConfigurationSave"
	ArduinoCoreService_ConfigurationOpen_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/ConfigurationOpen"
	ArduinoCoreService_ConfigurationGet_FullMethodName                  = "/cc.arduino.cli.commands.v1.ArduinoCoreService/ConfigurationGet"
	ArduinoCoreService_SettingsEnumerate_FullMethodName                 = "/cc.arduino.cli.commands.v1.ArduinoCoreService/SettingsEnumerate"
	ArduinoCoreService_SettingsGetValue_FullMethodName                  = "/cc.arduino.cli.commands.v1.ArduinoCoreService/SettingsGetValue"
	ArduinoCoreService_SettingsSetValue_FullMethodName                  = "/cc.arduino.cli.commands.v1.ArduinoCoreService/SettingsSetValue"
)

// ArduinoCoreServiceClient is the client API for ArduinoCoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// The main Arduino Platform service API.
type ArduinoCoreServiceClient interface {
	// Create a new Arduino Core instance.
	Create(ctx context.Context, in *CreateRequest, opts ...grpc.CallOption) (*CreateResponse, error)
	// Initializes an existing Arduino Core instance by loading platforms and
	// libraries.
	Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[InitResponse], error)
	// Destroy an instance of the Arduino Core Service.
	Destroy(ctx context.Context, in *DestroyRequest, opts ...grpc.CallOption) (*DestroyResponse, error)
	// Update package index of the Arduino Core Service.
	UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UpdateIndexResponse], error)
	// Update libraries index.
	UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UpdateLibrariesIndexResponse], error)
	// Get the version of Arduino CLI in use.
	Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error)
	// Create a new Sketch.
	NewSketch(ctx context.Context, in *NewSketchRequest, opts ...grpc.CallOption) (*NewSketchResponse, error)
	// Returns all files composing a Sketch.
	LoadSketch(ctx context.Context, in *LoadSketchRequest, opts ...grpc.CallOption) (*LoadSketchResponse, error)
	// Creates a zip file containing all files of specified Sketch.
	ArchiveSketch(ctx context.Context, in *ArchiveSketchRequest, opts ...grpc.CallOption) (*ArchiveSketchResponse, error)
	// Sets the sketch default FQBN and Port Address/Protocol in
	// the sketch project file (sketch.yaml). These metadata can be retrieved
	// using LoadSketch.
	SetSketchDefaults(ctx context.Context, in *SetSketchDefaultsRequest, opts ...grpc.CallOption) (*SetSketchDefaultsResponse, error)
	// Requests details about a board.
	BoardDetails(ctx context.Context, in *BoardDetailsRequest, opts ...grpc.CallOption) (*BoardDetailsResponse, error)
	// List the boards currently connected to the computer.
	BoardList(ctx context.Context, in *BoardListRequest, opts ...grpc.CallOption) (*BoardListResponse, error)
	// List all the boards provided by installed platforms.
	BoardListAll(ctx context.Context, in *BoardListAllRequest, opts ...grpc.CallOption) (*BoardListAllResponse, error)
	// Search boards in installed and not installed Platforms.
	BoardSearch(ctx context.Context, in *BoardSearchRequest, opts ...grpc.CallOption) (*BoardSearchResponse, error)
	// Identify a board using the given properties.
	BoardIdentify(ctx context.Context, in *BoardIdentifyRequest, opts ...grpc.CallOption) (*BoardIdentifyResponse, error)
	// List boards connection and disconnected events.
	BoardListWatch(ctx context.Context, in *BoardListWatchRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[BoardListWatchResponse], error)
	// Compile an Arduino sketch.
	Compile(ctx context.Context, in *CompileRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[CompileResponse], error)
	// Download and install a platform and its tool dependencies.
	PlatformInstall(ctx context.Context, in *PlatformInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformInstallResponse], error)
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(ctx context.Context, in *PlatformDownloadRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformDownloadResponse], error)
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(ctx context.Context, in *PlatformUninstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformUninstallResponse], error)
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(ctx context.Context, in *PlatformUpgradeRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformUpgradeResponse], error)
	// Upload a compiled sketch to a board.
	Upload(ctx context.Context, in *UploadRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UploadResponse], error)
	// Upload a compiled sketch to a board using a programmer.
	UploadUsingProgrammer(ctx context.Context, in *UploadUsingProgrammerRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UploadUsingProgrammerResponse], error)
	// Returns the list of users fields necessary to upload to that board
	// using the specified protocol.
	SupportedUserFields(ctx context.Context, in *SupportedUserFieldsRequest, opts ...grpc.CallOption) (*SupportedUserFieldsResponse, error)
	// List programmers available for a board.
	ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadRequest, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResponse, error)
	// Burn bootloader to a board.
	BurnBootloader(ctx context.Context, in *BurnBootloaderRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[BurnBootloaderResponse], error)
	// Search for a platform in the platforms indexes.
	PlatformSearch(ctx context.Context, in *PlatformSearchRequest, opts ...grpc.CallOption) (*PlatformSearchResponse, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(ctx context.Context, in *LibraryDownloadRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryDownloadResponse], error)
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(ctx context.Context, in *LibraryInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryInstallResponse], error)
	// Upgrade a library to the newest version available.
	LibraryUpgrade(ctx context.Context, in *LibraryUpgradeRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryUpgradeResponse], error)
	// Install a library from a Zip File.
	ZipLibraryInstall(ctx context.Context, in *ZipLibraryInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ZipLibraryInstallResponse], error)
	// Download and install a library from a git url.
	GitLibraryInstall(ctx context.Context, in *GitLibraryInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GitLibraryInstallResponse], error)
	// Uninstall an Arduino library.
	LibraryUninstall(ctx context.Context, in *LibraryUninstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryUninstallResponse], error)
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryUpgradeAllResponse], error)
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesRequest, opts ...grpc.CallOption) (*LibraryResolveDependenciesResponse, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(ctx context.Context, in *LibrarySearchRequest, opts ...grpc.CallOption) (*LibrarySearchResponse, error)
	// List the installed libraries.
	LibraryList(ctx context.Context, in *LibraryListRequest, opts ...grpc.CallOption) (*LibraryListResponse, error)
	// Open a monitor connection to a board port.
	Monitor(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[MonitorRequest, MonitorResponse], error)
	// Returns the parameters that can be set in the MonitorRequest calls.
	EnumerateMonitorPortSettings(ctx context.Context, in *EnumerateMonitorPortSettingsRequest, opts ...grpc.CallOption) (*EnumerateMonitorPortSettingsResponse, error)
	// Start a debug session and communicate with the debugger tool.
	Debug(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[DebugRequest, DebugResponse], error)
	// Determine if debugging is suported given a specific configuration.
	IsDebugSupported(ctx context.Context, in *IsDebugSupportedRequest, opts ...grpc.CallOption) (*IsDebugSupportedResponse, error)
	// Query the debugger information given a specific configuration.
	GetDebugConfig(ctx context.Context, in *GetDebugConfigRequest, opts ...grpc.CallOption) (*GetDebugConfigResponse, error)
	// Check for updates to the Arduino CLI.
	CheckForArduinoCLIUpdates(ctx context.Context, in *CheckForArduinoCLIUpdatesRequest, opts ...grpc.CallOption) (*CheckForArduinoCLIUpdatesResponse, error)
	// Clean the download cache directory (where archives are downloaded).
	CleanDownloadCacheDirectory(ctx context.Context, in *CleanDownloadCacheDirectoryRequest, opts ...grpc.CallOption) (*CleanDownloadCacheDirectoryResponse, error)
	// Writes the settings currently stored in memory in a YAML file.
	ConfigurationSave(ctx context.Context, in *ConfigurationSaveRequest, opts ...grpc.CallOption) (*ConfigurationSaveResponse, error)
	// Read the settings from a YAML file.
	ConfigurationOpen(ctx context.Context, in *ConfigurationOpenRequest, opts ...grpc.CallOption) (*ConfigurationOpenResponse, error)
	// Get the current configuration.
	ConfigurationGet(ctx context.Context, in *ConfigurationGetRequest, opts ...grpc.CallOption) (*ConfigurationGetResponse, error)
	// Enumerate all the keys/values pairs available in the configuration.
	SettingsEnumerate(ctx context.Context, in *SettingsEnumerateRequest, opts ...grpc.CallOption) (*SettingsEnumerateResponse, error)
	// Get a single configuration value.
	SettingsGetValue(ctx context.Context, in *SettingsGetValueRequest, opts ...grpc.CallOption) (*SettingsGetValueResponse, error)
	// Set a single configuration value.
	SettingsSetValue(ctx context.Context, in *SettingsSetValueRequest, opts ...grpc.CallOption) (*SettingsSetValueResponse, error)
}

type arduinoCoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArduinoCoreServiceClient(cc grpc.ClientConnInterface) ArduinoCoreServiceClient {
	return &arduinoCoreServiceClient{cc}
}

func (c *arduinoCoreServiceClient) Create(ctx context.Context, in *CreateRequest, opts ...grpc.CallOption) (*CreateResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[InitResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[0], ArduinoCoreService_Init_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[InitRequest, InitResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_InitClient = grpc.ServerStreamingClient[InitResponse]

func (c *arduinoCoreServiceClient) Destroy(ctx context.Context, in *DestroyRequest, opts ...grpc.CallOption) (*DestroyResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DestroyResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_Destroy_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UpdateIndexResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[1], ArduinoCoreService_UpdateIndex_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UpdateIndexRequest, UpdateIndexResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UpdateIndexClient = grpc.ServerStreamingClient[UpdateIndexResponse]

func (c *arduinoCoreServiceClient) UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UpdateLibrariesIndexResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[2], ArduinoCoreService_UpdateLibrariesIndex_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UpdateLibrariesIndexRequest, UpdateLibrariesIndexResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UpdateLibrariesIndexClient = grpc.ServerStreamingClient[UpdateLibrariesIndexResponse]

func (c *arduinoCoreServiceClient) Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(VersionResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_Version_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) NewSketch(ctx context.Context, in *NewSketchRequest, opts ...grpc.CallOption) (*NewSketchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NewSketchResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_NewSketch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LoadSketch(ctx context.Context, in *LoadSketchRequest, opts ...grpc.CallOption) (*LoadSketchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LoadSketchResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_LoadSketch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ArchiveSketch(ctx context.Context, in *ArchiveSketchRequest, opts ...grpc.CallOption) (*ArchiveSketchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ArchiveSketchResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_ArchiveSketch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) SetSketchDefaults(ctx context.Context, in *SetSketchDefaultsRequest, opts ...grpc.CallOption) (*SetSketchDefaultsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetSketchDefaultsResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_SetSketchDefaults_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardDetails(ctx context.Context, in *BoardDetailsRequest, opts ...grpc.CallOption) (*BoardDetailsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BoardDetailsResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_BoardDetails_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardList(ctx context.Context, in *BoardListRequest, opts ...grpc.CallOption) (*BoardListResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BoardListResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_BoardList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardListAll(ctx context.Context, in *BoardListAllRequest, opts ...grpc.CallOption) (*BoardListAllResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BoardListAllResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_BoardListAll_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardSearch(ctx context.Context, in *BoardSearchRequest, opts ...grpc.CallOption) (*BoardSearchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BoardSearchResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_BoardSearch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardIdentify(ctx context.Context, in *BoardIdentifyRequest, opts ...grpc.CallOption) (*BoardIdentifyResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BoardIdentifyResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_BoardIdentify_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BoardListWatch(ctx context.Context, in *BoardListWatchRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[BoardListWatchResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[3], ArduinoCoreService_BoardListWatch_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[BoardListWatchRequest, BoardListWatchResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_BoardListWatchClient = grpc.ServerStreamingClient[BoardListWatchResponse]

func (c *arduinoCoreServiceClient) Compile(ctx context.Context, in *CompileRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[CompileResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[4], ArduinoCoreService_Compile_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[CompileRequest, CompileResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_CompileClient = grpc.ServerStreamingClient[CompileResponse]

func (c *arduinoCoreServiceClient) PlatformInstall(ctx context.Context, in *PlatformInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformInstallResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[5], ArduinoCoreService_PlatformInstall_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[PlatformInstallRequest, PlatformInstallResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformInstallClient = grpc.ServerStreamingClient[PlatformInstallResponse]

func (c *arduinoCoreServiceClient) PlatformDownload(ctx context.Context, in *PlatformDownloadRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformDownloadResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[6], ArduinoCoreService_PlatformDownload_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[PlatformDownloadRequest, PlatformDownloadResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformDownloadClient = grpc.ServerStreamingClient[PlatformDownloadResponse]

func (c *arduinoCoreServiceClient) PlatformUninstall(ctx context.Context, in *PlatformUninstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformUninstallResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[7], ArduinoCoreService_PlatformUninstall_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[PlatformUninstallRequest, PlatformUninstallResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformUninstallClient = grpc.ServerStreamingClient[PlatformUninstallResponse]

func (c *arduinoCoreServiceClient) PlatformUpgrade(ctx context.Context, in *PlatformUpgradeRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PlatformUpgradeResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[8], ArduinoCoreService_PlatformUpgrade_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[PlatformUpgradeRequest, PlatformUpgradeResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformUpgradeClient = grpc.ServerStreamingClient[PlatformUpgradeResponse]

func (c *arduinoCoreServiceClient) Upload(ctx context.Context, in *UploadRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UploadResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[9], ArduinoCoreService_Upload_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UploadRequest, UploadResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UploadClient = grpc.ServerStreamingClient[UploadResponse]

func (c *arduinoCoreServiceClient) UploadUsingProgrammer(ctx context.Context, in *UploadUsingProgrammerRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[UploadUsingProgrammerResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[10], ArduinoCoreService_UploadUsingProgrammer_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UploadUsingProgrammerRequest, UploadUsingProgrammerResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UploadUsingProgrammerClient = grpc.ServerStreamingClient[UploadUsingProgrammerResponse]

func (c *arduinoCoreServiceClient) SupportedUserFields(ctx context.Context, in *SupportedUserFieldsRequest, opts ...grpc.CallOption) (*SupportedUserFieldsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SupportedUserFieldsResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_SupportedUserFields_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadRequest, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListProgrammersAvailableForUploadResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_ListProgrammersAvailableForUpload_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) BurnBootloader(ctx context.Context, in *BurnBootloaderRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[BurnBootloaderResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[11], ArduinoCoreService_BurnBootloader_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[BurnBootloaderRequest, BurnBootloaderResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_BurnBootloaderClient = grpc.ServerStreamingClient[BurnBootloaderResponse]

func (c *arduinoCoreServiceClient) PlatformSearch(ctx context.Context, in *PlatformSearchRequest, opts ...grpc.CallOption) (*PlatformSearchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PlatformSearchResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_PlatformSearch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibraryDownload(ctx context.Context, in *LibraryDownloadRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryDownloadResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[12], ArduinoCoreService_LibraryDownload_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LibraryDownloadRequest, LibraryDownloadResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryDownloadClient = grpc.ServerStreamingClient[LibraryDownloadResponse]

func (c *arduinoCoreServiceClient) LibraryInstall(ctx context.Context, in *LibraryInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryInstallResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[13], ArduinoCoreService_LibraryInstall_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LibraryInstallRequest, LibraryInstallResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryInstallClient = grpc.ServerStreamingClient[LibraryInstallResponse]

func (c *arduinoCoreServiceClient) LibraryUpgrade(ctx context.Context, in *LibraryUpgradeRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryUpgradeResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[14], ArduinoCoreService_LibraryUpgrade_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LibraryUpgradeRequest, LibraryUpgradeResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryUpgradeClient = grpc.ServerStreamingClient[LibraryUpgradeResponse]

func (c *arduinoCoreServiceClient) ZipLibraryInstall(ctx context.Context, in *ZipLibraryInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ZipLibraryInstallResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[15], ArduinoCoreService_ZipLibraryInstall_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ZipLibraryInstallRequest, ZipLibraryInstallResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_ZipLibraryInstallClient = grpc.ServerStreamingClient[ZipLibraryInstallResponse]

func (c *arduinoCoreServiceClient) GitLibraryInstall(ctx context.Context, in *GitLibraryInstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GitLibraryInstallResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[16], ArduinoCoreService_GitLibraryInstall_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GitLibraryInstallRequest, GitLibraryInstallResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_GitLibraryInstallClient = grpc.ServerStreamingClient[GitLibraryInstallResponse]

func (c *arduinoCoreServiceClient) LibraryUninstall(ctx context.Context, in *LibraryUninstallRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryUninstallResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[17], ArduinoCoreService_LibraryUninstall_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LibraryUninstallRequest, LibraryUninstallResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryUninstallClient = grpc.ServerStreamingClient[LibraryUninstallResponse]

func (c *arduinoCoreServiceClient) LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LibraryUpgradeAllResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[18], ArduinoCoreService_LibraryUpgradeAll_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LibraryUpgradeAllRequest, LibraryUpgradeAllResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryUpgradeAllClient = grpc.ServerStreamingClient[LibraryUpgradeAllResponse]

func (c *arduinoCoreServiceClient) LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesRequest, opts ...grpc.CallOption) (*LibraryResolveDependenciesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LibraryResolveDependenciesResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_LibraryResolveDependencies_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibrarySearch(ctx context.Context, in *LibrarySearchRequest, opts ...grpc.CallOption) (*LibrarySearchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LibrarySearchResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_LibrarySearch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) LibraryList(ctx context.Context, in *LibraryListRequest, opts ...grpc.CallOption) (*LibraryListResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LibraryListResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_LibraryList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Monitor(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[MonitorRequest, MonitorResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[19], ArduinoCoreService_Monitor_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[MonitorRequest, MonitorResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_MonitorClient = grpc.BidiStreamingClient[MonitorRequest, MonitorResponse]

func (c *arduinoCoreServiceClient) EnumerateMonitorPortSettings(ctx context.Context, in *EnumerateMonitorPortSettingsRequest, opts ...grpc.CallOption) (*EnumerateMonitorPortSettingsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EnumerateMonitorPortSettingsResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_EnumerateMonitorPortSettings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) Debug(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[DebugRequest, DebugResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ArduinoCoreService_ServiceDesc.Streams[20], ArduinoCoreService_Debug_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[DebugRequest, DebugResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_DebugClient = grpc.BidiStreamingClient[DebugRequest, DebugResponse]

func (c *arduinoCoreServiceClient) IsDebugSupported(ctx context.Context, in *IsDebugSupportedRequest, opts ...grpc.CallOption) (*IsDebugSupportedResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsDebugSupportedResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_IsDebugSupported_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) GetDebugConfig(ctx context.Context, in *GetDebugConfigRequest, opts ...grpc.CallOption) (*GetDebugConfigResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetDebugConfigResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_GetDebugConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) CheckForArduinoCLIUpdates(ctx context.Context, in *CheckForArduinoCLIUpdatesRequest, opts ...grpc.CallOption) (*CheckForArduinoCLIUpdatesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CheckForArduinoCLIUpdatesResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_CheckForArduinoCLIUpdates_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) CleanDownloadCacheDirectory(ctx context.Context, in *CleanDownloadCacheDirectoryRequest, opts ...grpc.CallOption) (*CleanDownloadCacheDirectoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CleanDownloadCacheDirectoryResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_CleanDownloadCacheDirectory_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ConfigurationSave(ctx context.Context, in *ConfigurationSaveRequest, opts ...grpc.CallOption) (*ConfigurationSaveResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ConfigurationSaveResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_ConfigurationSave_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ConfigurationOpen(ctx context.Context, in *ConfigurationOpenRequest, opts ...grpc.CallOption) (*ConfigurationOpenResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ConfigurationOpenResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_ConfigurationOpen_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) ConfigurationGet(ctx context.Context, in *ConfigurationGetRequest, opts ...grpc.CallOption) (*ConfigurationGetResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ConfigurationGetResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_ConfigurationGet_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) SettingsEnumerate(ctx context.Context, in *SettingsEnumerateRequest, opts ...grpc.CallOption) (*SettingsEnumerateResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SettingsEnumerateResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_SettingsEnumerate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) SettingsGetValue(ctx context.Context, in *SettingsGetValueRequest, opts ...grpc.CallOption) (*SettingsGetValueResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SettingsGetValueResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_SettingsGetValue_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreServiceClient) SettingsSetValue(ctx context.Context, in *SettingsSetValueRequest, opts ...grpc.CallOption) (*SettingsSetValueResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SettingsSetValueResponse)
	err := c.cc.Invoke(ctx, ArduinoCoreService_SettingsSetValue_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArduinoCoreServiceServer is the server API for ArduinoCoreService service.
// All implementations must embed UnimplementedArduinoCoreServiceServer
// for forward compatibility.
//
// The main Arduino Platform service API.
type ArduinoCoreServiceServer interface {
	// Create a new Arduino Core instance.
	Create(context.Context, *CreateRequest) (*CreateResponse, error)
	// Initializes an existing Arduino Core instance by loading platforms and
	// libraries.
	Init(*InitRequest, grpc.ServerStreamingServer[InitResponse]) error
	// Destroy an instance of the Arduino Core Service.
	Destroy(context.Context, *DestroyRequest) (*DestroyResponse, error)
	// Update package index of the Arduino Core Service.
	UpdateIndex(*UpdateIndexRequest, grpc.ServerStreamingServer[UpdateIndexResponse]) error
	// Update libraries index.
	UpdateLibrariesIndex(*UpdateLibrariesIndexRequest, grpc.ServerStreamingServer[UpdateLibrariesIndexResponse]) error
	// Get the version of Arduino CLI in use.
	Version(context.Context, *VersionRequest) (*VersionResponse, error)
	// Create a new Sketch.
	NewSketch(context.Context, *NewSketchRequest) (*NewSketchResponse, error)
	// Returns all files composing a Sketch.
	LoadSketch(context.Context, *LoadSketchRequest) (*LoadSketchResponse, error)
	// Creates a zip file containing all files of specified Sketch.
	ArchiveSketch(context.Context, *ArchiveSketchRequest) (*ArchiveSketchResponse, error)
	// Sets the sketch default FQBN and Port Address/Protocol in
	// the sketch project file (sketch.yaml). These metadata can be retrieved
	// using LoadSketch.
	SetSketchDefaults(context.Context, *SetSketchDefaultsRequest) (*SetSketchDefaultsResponse, error)
	// Requests details about a board.
	BoardDetails(context.Context, *BoardDetailsRequest) (*BoardDetailsResponse, error)
	// List the boards currently connected to the computer.
	BoardList(context.Context, *BoardListRequest) (*BoardListResponse, error)
	// List all the boards provided by installed platforms.
	BoardListAll(context.Context, *BoardListAllRequest) (*BoardListAllResponse, error)
	// Search boards in installed and not installed Platforms.
	BoardSearch(context.Context, *BoardSearchRequest) (*BoardSearchResponse, error)
	// Identify a board using the given properties.
	BoardIdentify(context.Context, *BoardIdentifyRequest) (*BoardIdentifyResponse, error)
	// List boards connection and disconnected events.
	BoardListWatch(*BoardListWatchRequest, grpc.ServerStreamingServer[BoardListWatchResponse]) error
	// Compile an Arduino sketch.
	Compile(*CompileRequest, grpc.ServerStreamingServer[CompileResponse]) error
	// Download and install a platform and its tool dependencies.
	PlatformInstall(*PlatformInstallRequest, grpc.ServerStreamingServer[PlatformInstallResponse]) error
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(*PlatformDownloadRequest, grpc.ServerStreamingServer[PlatformDownloadResponse]) error
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(*PlatformUninstallRequest, grpc.ServerStreamingServer[PlatformUninstallResponse]) error
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(*PlatformUpgradeRequest, grpc.ServerStreamingServer[PlatformUpgradeResponse]) error
	// Upload a compiled sketch to a board.
	Upload(*UploadRequest, grpc.ServerStreamingServer[UploadResponse]) error
	// Upload a compiled sketch to a board using a programmer.
	UploadUsingProgrammer(*UploadUsingProgrammerRequest, grpc.ServerStreamingServer[UploadUsingProgrammerResponse]) error
	// Returns the list of users fields necessary to upload to that board
	// using the specified protocol.
	SupportedUserFields(context.Context, *SupportedUserFieldsRequest) (*SupportedUserFieldsResponse, error)
	// List programmers available for a board.
	ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadRequest) (*ListProgrammersAvailableForUploadResponse, error)
	// Burn bootloader to a board.
	BurnBootloader(*BurnBootloaderRequest, grpc.ServerStreamingServer[BurnBootloaderResponse]) error
	// Search for a platform in the platforms indexes.
	PlatformSearch(context.Context, *PlatformSearchRequest) (*PlatformSearchResponse, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(*LibraryDownloadRequest, grpc.ServerStreamingServer[LibraryDownloadResponse]) error
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(*LibraryInstallRequest, grpc.ServerStreamingServer[LibraryInstallResponse]) error
	// Upgrade a library to the newest version available.
	LibraryUpgrade(*LibraryUpgradeRequest, grpc.ServerStreamingServer[LibraryUpgradeResponse]) error
	// Install a library from a Zip File.
	ZipLibraryInstall(*ZipLibraryInstallRequest, grpc.ServerStreamingServer[ZipLibraryInstallResponse]) error
	// Download and install a library from a git url.
	GitLibraryInstall(*GitLibraryInstallRequest, grpc.ServerStreamingServer[GitLibraryInstallResponse]) error
	// Uninstall an Arduino library.
	LibraryUninstall(*LibraryUninstallRequest, grpc.ServerStreamingServer[LibraryUninstallResponse]) error
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(*LibraryUpgradeAllRequest, grpc.ServerStreamingServer[LibraryUpgradeAllResponse]) error
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesRequest) (*LibraryResolveDependenciesResponse, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(context.Context, *LibrarySearchRequest) (*LibrarySearchResponse, error)
	// List the installed libraries.
	LibraryList(context.Context, *LibraryListRequest) (*LibraryListResponse, error)
	// Open a monitor connection to a board port.
	Monitor(grpc.BidiStreamingServer[MonitorRequest, MonitorResponse]) error
	// Returns the parameters that can be set in the MonitorRequest calls.
	EnumerateMonitorPortSettings(context.Context, *EnumerateMonitorPortSettingsRequest) (*EnumerateMonitorPortSettingsResponse, error)
	// Start a debug session and communicate with the debugger tool.
	Debug(grpc.BidiStreamingServer[DebugRequest, DebugResponse]) error
	// Determine if debugging is suported given a specific configuration.
	IsDebugSupported(context.Context, *IsDebugSupportedRequest) (*IsDebugSupportedResponse, error)
	// Query the debugger information given a specific configuration.
	GetDebugConfig(context.Context, *GetDebugConfigRequest) (*GetDebugConfigResponse, error)
	// Check for updates to the Arduino CLI.
	CheckForArduinoCLIUpdates(context.Context, *CheckForArduinoCLIUpdatesRequest) (*CheckForArduinoCLIUpdatesResponse, error)
	// Clean the download cache directory (where archives are downloaded).
	CleanDownloadCacheDirectory(context.Context, *CleanDownloadCacheDirectoryRequest) (*CleanDownloadCacheDirectoryResponse, error)
	// Writes the settings currently stored in memory in a YAML file.
	ConfigurationSave(context.Context, *ConfigurationSaveRequest) (*ConfigurationSaveResponse, error)
	// Read the settings from a YAML file.
	ConfigurationOpen(context.Context, *ConfigurationOpenRequest) (*ConfigurationOpenResponse, error)
	// Get the current configuration.
	ConfigurationGet(context.Context, *ConfigurationGetRequest) (*ConfigurationGetResponse, error)
	// Enumerate all the keys/values pairs available in the configuration.
	SettingsEnumerate(context.Context, *SettingsEnumerateRequest) (*SettingsEnumerateResponse, error)
	// Get a single configuration value.
	SettingsGetValue(context.Context, *SettingsGetValueRequest) (*SettingsGetValueResponse, error)
	// Set a single configuration value.
	SettingsSetValue(context.Context, *SettingsSetValueRequest) (*SettingsSetValueResponse, error)
	mustEmbedUnimplementedArduinoCoreServiceServer()
}

// UnimplementedArduinoCoreServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedArduinoCoreServiceServer struct{}

func (UnimplementedArduinoCoreServiceServer) Create(context.Context, *CreateRequest) (*CreateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Init(*InitRequest, grpc.ServerStreamingServer[InitResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Init not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Destroy(context.Context, *DestroyRequest) (*DestroyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Destroy not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UpdateIndex(*UpdateIndexRequest, grpc.ServerStreamingServer[UpdateIndexResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UpdateIndex not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UpdateLibrariesIndex(*UpdateLibrariesIndexRequest, grpc.ServerStreamingServer[UpdateLibrariesIndexResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UpdateLibrariesIndex not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Version(context.Context, *VersionRequest) (*VersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Version not implemented")
}
func (UnimplementedArduinoCoreServiceServer) NewSketch(context.Context, *NewSketchRequest) (*NewSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewSketch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LoadSketch(context.Context, *LoadSketchRequest) (*LoadSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadSketch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ArchiveSketch(context.Context, *ArchiveSketchRequest) (*ArchiveSketchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveSketch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) SetSketchDefaults(context.Context, *SetSketchDefaultsRequest) (*SetSketchDefaultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSketchDefaults not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardDetails(context.Context, *BoardDetailsRequest) (*BoardDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardDetails not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardList(context.Context, *BoardListRequest) (*BoardListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardList not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardListAll(context.Context, *BoardListAllRequest) (*BoardListAllResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardListAll not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardSearch(context.Context, *BoardSearchRequest) (*BoardSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardSearch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardIdentify(context.Context, *BoardIdentifyRequest) (*BoardIdentifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardIdentify not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BoardListWatch(*BoardListWatchRequest, grpc.ServerStreamingServer[BoardListWatchResponse]) error {
	return status.Errorf(codes.Unimplemented, "method BoardListWatch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Compile(*CompileRequest, grpc.ServerStreamingServer[CompileResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Compile not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformInstall(*PlatformInstallRequest, grpc.ServerStreamingServer[PlatformInstallResponse]) error {
	return status.Errorf(codes.Unimplemented, "method PlatformInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformDownload(*PlatformDownloadRequest, grpc.ServerStreamingServer[PlatformDownloadResponse]) error {
	return status.Errorf(codes.Unimplemented, "method PlatformDownload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformUninstall(*PlatformUninstallRequest, grpc.ServerStreamingServer[PlatformUninstallResponse]) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUninstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformUpgrade(*PlatformUpgradeRequest, grpc.ServerStreamingServer[PlatformUpgradeResponse]) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUpgrade not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Upload(*UploadRequest, grpc.ServerStreamingServer[UploadResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Upload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) UploadUsingProgrammer(*UploadUsingProgrammerRequest, grpc.ServerStreamingServer[UploadUsingProgrammerResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UploadUsingProgrammer not implemented")
}
func (UnimplementedArduinoCoreServiceServer) SupportedUserFields(context.Context, *SupportedUserFieldsRequest) (*SupportedUserFieldsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SupportedUserFields not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadRequest) (*ListProgrammersAvailableForUploadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProgrammersAvailableForUpload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) BurnBootloader(*BurnBootloaderRequest, grpc.ServerStreamingServer[BurnBootloaderResponse]) error {
	return status.Errorf(codes.Unimplemented, "method BurnBootloader not implemented")
}
func (UnimplementedArduinoCoreServiceServer) PlatformSearch(context.Context, *PlatformSearchRequest) (*PlatformSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformSearch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryDownload(*LibraryDownloadRequest, grpc.ServerStreamingServer[LibraryDownloadResponse]) error {
	return status.Errorf(codes.Unimplemented, "method LibraryDownload not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryInstall(*LibraryInstallRequest, grpc.ServerStreamingServer[LibraryInstallResponse]) error {
	return status.Errorf(codes.Unimplemented, "method LibraryInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryUpgrade(*LibraryUpgradeRequest, grpc.ServerStreamingServer[LibraryUpgradeResponse]) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUpgrade not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ZipLibraryInstall(*ZipLibraryInstallRequest, grpc.ServerStreamingServer[ZipLibraryInstallResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ZipLibraryInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) GitLibraryInstall(*GitLibraryInstallRequest, grpc.ServerStreamingServer[GitLibraryInstallResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GitLibraryInstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryUninstall(*LibraryUninstallRequest, grpc.ServerStreamingServer[LibraryUninstallResponse]) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUninstall not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryUpgradeAll(*LibraryUpgradeAllRequest, grpc.ServerStreamingServer[LibraryUpgradeAllResponse]) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUpgradeAll not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesRequest) (*LibraryResolveDependenciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryResolveDependencies not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibrarySearch(context.Context, *LibrarySearchRequest) (*LibrarySearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibrarySearch not implemented")
}
func (UnimplementedArduinoCoreServiceServer) LibraryList(context.Context, *LibraryListRequest) (*LibraryListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryList not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Monitor(grpc.BidiStreamingServer[MonitorRequest, MonitorResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Monitor not implemented")
}
func (UnimplementedArduinoCoreServiceServer) EnumerateMonitorPortSettings(context.Context, *EnumerateMonitorPortSettingsRequest) (*EnumerateMonitorPortSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnumerateMonitorPortSettings not implemented")
}
func (UnimplementedArduinoCoreServiceServer) Debug(grpc.BidiStreamingServer[DebugRequest, DebugResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Debug not implemented")
}
func (UnimplementedArduinoCoreServiceServer) IsDebugSupported(context.Context, *IsDebugSupportedRequest) (*IsDebugSupportedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsDebugSupported not implemented")
}
func (UnimplementedArduinoCoreServiceServer) GetDebugConfig(context.Context, *GetDebugConfigRequest) (*GetDebugConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDebugConfig not implemented")
}
func (UnimplementedArduinoCoreServiceServer) CheckForArduinoCLIUpdates(context.Context, *CheckForArduinoCLIUpdatesRequest) (*CheckForArduinoCLIUpdatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckForArduinoCLIUpdates not implemented")
}
func (UnimplementedArduinoCoreServiceServer) CleanDownloadCacheDirectory(context.Context, *CleanDownloadCacheDirectoryRequest) (*CleanDownloadCacheDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CleanDownloadCacheDirectory not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ConfigurationSave(context.Context, *ConfigurationSaveRequest) (*ConfigurationSaveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigurationSave not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ConfigurationOpen(context.Context, *ConfigurationOpenRequest) (*ConfigurationOpenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigurationOpen not implemented")
}
func (UnimplementedArduinoCoreServiceServer) ConfigurationGet(context.Context, *ConfigurationGetRequest) (*ConfigurationGetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigurationGet not implemented")
}
func (UnimplementedArduinoCoreServiceServer) SettingsEnumerate(context.Context, *SettingsEnumerateRequest) (*SettingsEnumerateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SettingsEnumerate not implemented")
}
func (UnimplementedArduinoCoreServiceServer) SettingsGetValue(context.Context, *SettingsGetValueRequest) (*SettingsGetValueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SettingsGetValue not implemented")
}
func (UnimplementedArduinoCoreServiceServer) SettingsSetValue(context.Context, *SettingsSetValueRequest) (*SettingsSetValueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SettingsSetValue not implemented")
}
func (UnimplementedArduinoCoreServiceServer) mustEmbedUnimplementedArduinoCoreServiceServer() {}
func (UnimplementedArduinoCoreServiceServer) testEmbeddedByValue()                            {}

// UnsafeArduinoCoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ArduinoCoreServiceServer will
// result in compilation errors.
type UnsafeArduinoCoreServiceServer interface {
	mustEmbedUnimplementedArduinoCoreServiceServer()
}

func RegisterArduinoCoreServiceServer(s grpc.ServiceRegistrar, srv ArduinoCoreServiceServer) {
	// If the following call pancis, it indicates UnimplementedArduinoCoreServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ArduinoCoreService_ServiceDesc, srv)
}

func _ArduinoCoreService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Create(ctx, req.(*CreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Init_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Init(m, &grpc.GenericServerStream[InitRequest, InitResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_InitServer = grpc.ServerStreamingServer[InitResponse]

func _ArduinoCoreService_Destroy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Destroy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_Destroy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Destroy(ctx, req.(*DestroyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_UpdateIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateIndex(m, &grpc.GenericServerStream[UpdateIndexRequest, UpdateIndexResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UpdateIndexServer = grpc.ServerStreamingServer[UpdateIndexResponse]

func _ArduinoCoreService_UpdateLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateLibrariesIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UpdateLibrariesIndex(m, &grpc.GenericServerStream[UpdateLibrariesIndexRequest, UpdateLibrariesIndexResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UpdateLibrariesIndexServer = grpc.ServerStreamingServer[UpdateLibrariesIndexResponse]

func _ArduinoCoreService_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_Version_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).Version(ctx, req.(*VersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_NewSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NewSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).NewSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_NewSketch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).NewSketch(ctx, req.(*NewSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LoadSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LoadSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_LoadSketch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LoadSketch(ctx, req.(*LoadSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ArchiveSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveSketchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ArchiveSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_ArchiveSketch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ArchiveSketch(ctx, req.(*ArchiveSketchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_SetSketchDefaults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSketchDefaultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).SetSketchDefaults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_SetSketchDefaults_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).SetSketchDefaults(ctx, req.(*SetSketchDefaultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_BoardDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardDetails(ctx, req.(*BoardDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_BoardList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardList(ctx, req.(*BoardListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardListAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListAllRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardListAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_BoardListAll_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardListAll(ctx, req.(*BoardListAllRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_BoardSearch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardSearch(ctx, req.(*BoardSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardIdentify_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardIdentifyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).BoardIdentify(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_BoardIdentify_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).BoardIdentify(ctx, req.(*BoardIdentifyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BoardListWatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BoardListWatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).BoardListWatch(m, &grpc.GenericServerStream[BoardListWatchRequest, BoardListWatchResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_BoardListWatchServer = grpc.ServerStreamingServer[BoardListWatchResponse]

func _ArduinoCoreService_Compile_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CompileRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Compile(m, &grpc.GenericServerStream[CompileRequest, CompileResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_CompileServer = grpc.ServerStreamingServer[CompileResponse]

func _ArduinoCoreService_PlatformInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformInstall(m, &grpc.GenericServerStream[PlatformInstallRequest, PlatformInstallResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformInstallServer = grpc.ServerStreamingServer[PlatformInstallResponse]

func _ArduinoCoreService_PlatformDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformDownloadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformDownload(m, &grpc.GenericServerStream[PlatformDownloadRequest, PlatformDownloadResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformDownloadServer = grpc.ServerStreamingServer[PlatformDownloadResponse]

func _ArduinoCoreService_PlatformUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUninstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformUninstall(m, &grpc.GenericServerStream[PlatformUninstallRequest, PlatformUninstallResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformUninstallServer = grpc.ServerStreamingServer[PlatformUninstallResponse]

func _ArduinoCoreService_PlatformUpgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUpgradeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).PlatformUpgrade(m, &grpc.GenericServerStream[PlatformUpgradeRequest, PlatformUpgradeResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_PlatformUpgradeServer = grpc.ServerStreamingServer[PlatformUpgradeResponse]

func _ArduinoCoreService_Upload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).Upload(m, &grpc.GenericServerStream[UploadRequest, UploadResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UploadServer = grpc.ServerStreamingServer[UploadResponse]

func _ArduinoCoreService_UploadUsingProgrammer_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadUsingProgrammerRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).UploadUsingProgrammer(m, &grpc.GenericServerStream[UploadUsingProgrammerRequest, UploadUsingProgrammerResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_UploadUsingProgrammerServer = grpc.ServerStreamingServer[UploadUsingProgrammerResponse]

func _ArduinoCoreService_SupportedUserFields_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SupportedUserFieldsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).SupportedUserFields(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_SupportedUserFields_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).SupportedUserFields(ctx, req.(*SupportedUserFieldsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ListProgrammersAvailableForUpload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgrammersAvailableForUploadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ListProgrammersAvailableForUpload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_ListProgrammersAvailableForUpload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ListProgrammersAvailableForUpload(ctx, req.(*ListProgrammersAvailableForUploadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_BurnBootloader_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BurnBootloaderRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).BurnBootloader(m, &grpc.GenericServerStream[BurnBootloaderRequest, BurnBootloaderResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_BurnBootloaderServer = grpc.ServerStreamingServer[BurnBootloaderResponse]

func _ArduinoCoreService_PlatformSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).PlatformSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_PlatformSearch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).PlatformSearch(ctx, req.(*PlatformSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibraryDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryDownloadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryDownload(m, &grpc.GenericServerStream[LibraryDownloadRequest, LibraryDownloadResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryDownloadServer = grpc.ServerStreamingServer[LibraryDownloadResponse]

func _ArduinoCoreService_LibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryInstall(m, &grpc.GenericServerStream[LibraryInstallRequest, LibraryInstallResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryInstallServer = grpc.ServerStreamingServer[LibraryInstallResponse]

func _ArduinoCoreService_LibraryUpgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUpgradeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUpgrade(m, &grpc.GenericServerStream[LibraryUpgradeRequest, LibraryUpgradeResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryUpgradeServer = grpc.ServerStreamingServer[LibraryUpgradeResponse]

func _ArduinoCoreService_ZipLibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ZipLibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).ZipLibraryInstall(m, &grpc.GenericServerStream[ZipLibraryInstallRequest, ZipLibraryInstallResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_ZipLibraryInstallServer = grpc.ServerStreamingServer[ZipLibraryInstallResponse]

func _ArduinoCoreService_GitLibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GitLibraryInstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).GitLibraryInstall(m, &grpc.GenericServerStream[GitLibraryInstallRequest, GitLibraryInstallResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_GitLibraryInstallServer = grpc.ServerStreamingServer[GitLibraryInstallResponse]

func _ArduinoCoreService_LibraryUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUninstallRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUninstall(m, &grpc.GenericServerStream[LibraryUninstallRequest, LibraryUninstallResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryUninstallServer = grpc.ServerStreamingServer[LibraryUninstallResponse]

func _ArduinoCoreService_LibraryUpgradeAll_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUpgradeAllRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServiceServer).LibraryUpgradeAll(m, &grpc.GenericServerStream[LibraryUpgradeAllRequest, LibraryUpgradeAllResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_LibraryUpgradeAllServer = grpc.ServerStreamingServer[LibraryUpgradeAllResponse]

func _ArduinoCoreService_LibraryResolveDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryResolveDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibraryResolveDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_LibraryResolveDependencies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibraryResolveDependencies(ctx, req.(*LibraryResolveDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibrarySearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibrarySearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibrarySearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_LibrarySearch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibrarySearch(ctx, req.(*LibrarySearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_LibraryList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).LibraryList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_LibraryList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).LibraryList(ctx, req.(*LibraryListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Monitor_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArduinoCoreServiceServer).Monitor(&grpc.GenericServerStream[MonitorRequest, MonitorResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_MonitorServer = grpc.BidiStreamingServer[MonitorRequest, MonitorResponse]

func _ArduinoCoreService_EnumerateMonitorPortSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnumerateMonitorPortSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).EnumerateMonitorPortSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_EnumerateMonitorPortSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).EnumerateMonitorPortSettings(ctx, req.(*EnumerateMonitorPortSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_Debug_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArduinoCoreServiceServer).Debug(&grpc.GenericServerStream[DebugRequest, DebugResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ArduinoCoreService_DebugServer = grpc.BidiStreamingServer[DebugRequest, DebugResponse]

func _ArduinoCoreService_IsDebugSupported_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsDebugSupportedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).IsDebugSupported(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_IsDebugSupported_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).IsDebugSupported(ctx, req.(*IsDebugSupportedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_GetDebugConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDebugConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).GetDebugConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_GetDebugConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).GetDebugConfig(ctx, req.(*GetDebugConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_CheckForArduinoCLIUpdates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckForArduinoCLIUpdatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).CheckForArduinoCLIUpdates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_CheckForArduinoCLIUpdates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).CheckForArduinoCLIUpdates(ctx, req.(*CheckForArduinoCLIUpdatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_CleanDownloadCacheDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CleanDownloadCacheDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).CleanDownloadCacheDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_CleanDownloadCacheDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).CleanDownloadCacheDirectory(ctx, req.(*CleanDownloadCacheDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ConfigurationSave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigurationSaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ConfigurationSave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_ConfigurationSave_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ConfigurationSave(ctx, req.(*ConfigurationSaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ConfigurationOpen_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigurationOpenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ConfigurationOpen(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_ConfigurationOpen_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ConfigurationOpen(ctx, req.(*ConfigurationOpenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_ConfigurationGet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigurationGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).ConfigurationGet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_ConfigurationGet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).ConfigurationGet(ctx, req.(*ConfigurationGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_SettingsEnumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingsEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).SettingsEnumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_SettingsEnumerate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).SettingsEnumerate(ctx, req.(*SettingsEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_SettingsGetValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingsGetValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).SettingsGetValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_SettingsGetValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).SettingsGetValue(ctx, req.(*SettingsGetValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCoreService_SettingsSetValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingsSetValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServiceServer).SettingsSetValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArduinoCoreService_SettingsSetValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServiceServer).SettingsSetValue(ctx, req.(*SettingsSetValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ArduinoCoreService_ServiceDesc is the grpc.ServiceDesc for ArduinoCoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ArduinoCoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.cli.commands.v1.ArduinoCoreService",
	HandlerType: (*ArduinoCoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _ArduinoCoreService_Create_Handler,
		},
		{
			MethodName: "Destroy",
			Handler:    _ArduinoCoreService_Destroy_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _ArduinoCoreService_Version_Handler,
		},
		{
			MethodName: "NewSketch",
			Handler:    _ArduinoCoreService_NewSketch_Handler,
		},
		{
			MethodName: "LoadSketch",
			Handler:    _ArduinoCoreService_LoadSketch_Handler,
		},
		{
			MethodName: "ArchiveSketch",
			Handler:    _ArduinoCoreService_ArchiveSketch_Handler,
		},
		{
			MethodName: "SetSketchDefaults",
			Handler:    _ArduinoCoreService_SetSketchDefaults_Handler,
		},
		{
			MethodName: "BoardDetails",
			Handler:    _ArduinoCoreService_BoardDetails_Handler,
		},
		{
			MethodName: "BoardList",
			Handler:    _ArduinoCoreService_BoardList_Handler,
		},
		{
			MethodName: "BoardListAll",
			Handler:    _ArduinoCoreService_BoardListAll_Handler,
		},
		{
			MethodName: "BoardSearch",
			Handler:    _ArduinoCoreService_BoardSearch_Handler,
		},
		{
			MethodName: "BoardIdentify",
			Handler:    _ArduinoCoreService_BoardIdentify_Handler,
		},
		{
			MethodName: "SupportedUserFields",
			Handler:    _ArduinoCoreService_SupportedUserFields_Handler,
		},
		{
			MethodName: "ListProgrammersAvailableForUpload",
			Handler:    _ArduinoCoreService_ListProgrammersAvailableForUpload_Handler,
		},
		{
			MethodName: "PlatformSearch",
			Handler:    _ArduinoCoreService_PlatformSearch_Handler,
		},
		{
			MethodName: "LibraryResolveDependencies",
			Handler:    _ArduinoCoreService_LibraryResolveDependencies_Handler,
		},
		{
			MethodName: "LibrarySearch",
			Handler:    _ArduinoCoreService_LibrarySearch_Handler,
		},
		{
			MethodName: "LibraryList",
			Handler:    _ArduinoCoreService_LibraryList_Handler,
		},
		{
			MethodName: "EnumerateMonitorPortSettings",
			Handler:    _ArduinoCoreService_EnumerateMonitorPortSettings_Handler,
		},
		{
			MethodName: "IsDebugSupported",
			Handler:    _ArduinoCoreService_IsDebugSupported_Handler,
		},
		{
			MethodName: "GetDebugConfig",
			Handler:    _ArduinoCoreService_GetDebugConfig_Handler,
		},
		{
			MethodName: "CheckForArduinoCLIUpdates",
			Handler:    _ArduinoCoreService_CheckForArduinoCLIUpdates_Handler,
		},
		{
			MethodName: "CleanDownloadCacheDirectory",
			Handler:    _ArduinoCoreService_CleanDownloadCacheDirectory_Handler,
		},
		{
			MethodName: "ConfigurationSave",
			Handler:    _ArduinoCoreService_ConfigurationSave_Handler,
		},
		{
			MethodName: "ConfigurationOpen",
			Handler:    _ArduinoCoreService_ConfigurationOpen_Handler,
		},
		{
			MethodName: "ConfigurationGet",
			Handler:    _ArduinoCoreService_ConfigurationGet_Handler,
		},
		{
			MethodName: "SettingsEnumerate",
			Handler:    _ArduinoCoreService_SettingsEnumerate_Handler,
		},
		{
			MethodName: "SettingsGetValue",
			Handler:    _ArduinoCoreService_SettingsGetValue_Handler,
		},
		{
			MethodName: "SettingsSetValue",
			Handler:    _ArduinoCoreService_SettingsSetValue_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Init",
			Handler:       _ArduinoCoreService_Init_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateIndex",
			Handler:       _ArduinoCoreService_UpdateIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateLibrariesIndex",
			Handler:       _ArduinoCoreService_UpdateLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardListWatch",
			Handler:       _ArduinoCoreService_BoardListWatch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Compile",
			Handler:       _ArduinoCoreService_Compile_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformInstall",
			Handler:       _ArduinoCoreService_PlatformInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformDownload",
			Handler:       _ArduinoCoreService_PlatformDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUninstall",
			Handler:       _ArduinoCoreService_PlatformUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUpgrade",
			Handler:       _ArduinoCoreService_PlatformUpgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upload",
			Handler:       _ArduinoCoreService_Upload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UploadUsingProgrammer",
			Handler:       _ArduinoCoreService_UploadUsingProgrammer_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BurnBootloader",
			Handler:       _ArduinoCoreService_BurnBootloader_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryDownload",
			Handler:       _ArduinoCoreService_LibraryDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryInstall",
			Handler:       _ArduinoCoreService_LibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUpgrade",
			Handler:       _ArduinoCoreService_LibraryUpgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ZipLibraryInstall",
			Handler:       _ArduinoCoreService_ZipLibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GitLibraryInstall",
			Handler:       _ArduinoCoreService_GitLibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUninstall",
			Handler:       _ArduinoCoreService_LibraryUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUpgradeAll",
			Handler:       _ArduinoCoreService_LibraryUpgradeAll_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Monitor",
			Handler:       _ArduinoCoreService_Monitor_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Debug",
			Handler:       _ArduinoCoreService_Debug_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "cc/arduino/cli/commands/v1/commands.proto",
}
