/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/meshes/meshes.h"


namespace Avogadro::QtPlugins {

class MeshesFactory : public QObject, public QtGui::ScenePluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ScenePluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ScenePluginFactory)

public:
  explicit MeshesFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ScenePlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new Meshes(parent_);
    object->setObjectName("Meshes");
    return object;
  }

  QString identifier() const override { return "Meshes"; }

  QString description() const override { return "Surface and mesh rendering"; }

};

} // namespace Avogadro::QtPlugins

#include "MeshesPlugin.moc"
