/* notifications_view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from notifications_view.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 * Copyright 2014 Josh Klar <j@iv597.com> (original Budgie work, prior to Budgie 10)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "budgie-private.h"
#include <float.h>
#include <math.h>

#define BUDGIE_NOTIFICATIONS_VIEW_BUDGIE_PANEL_SCHEMA "com.solus-project.budgie-panel"
#define BUDGIE_NOTIFICATIONS_VIEW_BUDGIE_RAVEN_SCHEMA "com.solus-project.budgie-raven"
#define BUDGIE_NOTIFICATIONS_VIEW_APPLICATION_SCHEMA "org.gnome.desktop.notifications.application"
#define BUDGIE_NOTIFICATIONS_VIEW_APPLICATION_PREFIX "/org/gnome/desktop/notifications/application"
#define BUDGIE_NOTIFICATIONS_VIEW_TOTAL_MAX_NOTIFICATIONS ((guint) 500)
#define BUDGIE_NOTIFICATIONS_VIEW_DEFAULT_MAX_PERGROUP ((guint) 25)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_NOTIFICATION_PLACEHOLDER_0_PROPERTY,
	BUDGIE_NOTIFICATION_PLACEHOLDER_NUM_PROPERTIES
};
static GParamSpec* budgie_notification_placeholder_properties[BUDGIE_NOTIFICATION_PLACEHOLDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BUDGIE_DISPATCHER_NOTIFICATION_ADDED_SIGNAL,
	BUDGIE_DISPATCHER_NOTIFICATION_CLOSED_SIGNAL,
	BUDGIE_DISPATCHER_NUM_SIGNALS
};
static guint budgie_dispatcher_signals[BUDGIE_DISPATCHER_NUM_SIGNALS] = {0};
typedef GDBusProxy BudgieDispatcherProxy;
typedef GDBusProxyClass BudgieDispatcherProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	BUDGIE_RAVEN_INTERFACE_CLEAR_ALL_NOTIFICATIONS_SIGNAL,
	BUDGIE_RAVEN_INTERFACE_NUM_SIGNALS
};
static guint budgie_raven_interface_signals[BUDGIE_RAVEN_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy BudgieRavenInterfaceProxy;
typedef GDBusProxyClass BudgieRavenInterfaceProxyClass;
enum  {
	BUDGIE_NOTIFICATIONS_VIEW_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_VIEW_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_view_properties[BUDGIE_NOTIFICATIONS_VIEW_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _BudgieNotificationsViewPrivate {
	guint max_per_group;
	BudgieHeaderWidget* header;
	GtkButton* button_mute;
	GtkButton* clear_notifications_button;
	GtkListBox* listbox;
	GtkImage* image_notifications_disabled;
	GtkImage* image_notifications_enabled;
	gboolean _do_not_disturb;
	BudgieNotificationSort _sort_mode;
	BudgieDispatcher* dispatcher;
	GHashTable* notifications;
	gint notification_count;
	GSettings* budgie_settings;
	GSettings* raven_settings;
	BudgieRavenInterface* raven;
};

struct _Block3Data {
	int _ref_count_;
	BudgieNotificationsView* self;
	BudgieNotificationGroup* group;
};

static gpointer budgie_notification_placeholder_parent_class = NULL;
static gint BudgieNotificationsView_private_offset;
static gpointer budgie_notifications_view_parent_class = NULL;

static GType budgie_notification_placeholder_get_type_once (void);
static void g_cclosure_user_marshal_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT (GClosure * closure,
                                                                                         GValue * return_value,
                                                                                         guint n_param_values,
                                                                                         const GValue * param_values,
                                                                                         gpointer invocation_hint,
                                                                                         gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_STRING_ENUM (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static GType budgie_dispatcher_get_type_once (void);
static void budgie_dispatcher_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _dbus_handle_budgie_dispatcher_notification_added (BudgieDispatcher* self,
                                                        GVariant* parameters);
static void _dbus_handle_budgie_dispatcher_notification_closed (BudgieDispatcher* self,
                                                         GVariant* parameters);
static gboolean budgie_dispatcher_proxy_get_do_not_disturb (BudgieDispatcher* self,
                                                     GError** error);
static void budgie_dispatcher_proxy_toggle_do_not_disturb (BudgieDispatcher* self,
                                                    GError** error);
static gboolean budgie_dispatcher_dbus_proxy_get_notifications_paused (BudgieDispatcher* self);
static void budgie_dispatcher_dbus_proxy_set_notifications_paused (BudgieDispatcher* self,
                                                            gboolean value);
static void budgie_dispatcher_proxy_budgie_dispatcher_interface_init (BudgieDispatcherIface* iface);
static void _dbus_budgie_dispatcher_get_do_not_disturb (BudgieDispatcher* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_dispatcher_toggle_do_not_disturb (BudgieDispatcher* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void budgie_dispatcher_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* budgie_dispatcher_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static GVariant* _dbus_budgie_dispatcher_get_notifications_paused (BudgieDispatcher* self);
static gboolean budgie_dispatcher_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_budgie_dispatcher_set_notifications_paused (BudgieDispatcher* self,
                                                       GVariant* _value);
static void _dbus_budgie_dispatcher_notification_added (GObject* _sender,
                                                 const gchar* app_name,
                                                 guint32 id,
                                                 const gchar* app_icon,
                                                 const gchar* summary,
                                                 const gchar* body,
                                                 gchar** actions,
                                                 gint actions_length1,
                                                 GHashTable* hints,
                                                 gint32 expire_timeout,
                                                 gpointer* _data);
static void _dbus_budgie_dispatcher_notification_closed (GObject* _sender,
                                                  guint32 id,
                                                  const gchar* app_name,
                                                  BudgieNotificationCloseReason reason,
                                                  gpointer* _data);
static void _budgie_dispatcher_unregister_object (gpointer user_data);
static GType budgie_raven_interface_get_type_once (void);
static void budgie_raven_interface_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static void _dbus_handle_budgie_raven_interface_clear_all_notifications (BudgieRavenInterface* self,
                                                                  GVariant* parameters);
static void budgie_raven_interface_proxy_budgie_raven_interface_interface_init (BudgieRavenInterfaceIface* iface);
static void budgie_raven_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* budgie_raven_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean budgie_raven_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _dbus_budgie_raven_interface_clear_all_notifications (GObject* _sender,
                                                           gpointer* _data);
static void _budgie_raven_interface_unregister_object (gpointer user_data);
static void budgie_notifications_view_on_dbus_get (BudgieNotificationsView* self,
                                            GObject* o,
                                            GAsyncResult* res);
static void budgie_notifications_view_on_notification_added (BudgieNotificationsView* self,
                                                      const gchar* app_name,
                                                      guint32 id,
                                                      const gchar* app_icon,
                                                      const gchar* summary,
                                                      const gchar* body,
                                                      gchar** actions,
                                                      gint actions_length1,
                                                      GHashTable* hints,
                                                      gint32 expire_timeout);
static void _budgie_notifications_view_on_notification_added_budgie_dispatcher_notification_added (BudgieDispatcher* _sender,
                                                                                            const gchar* app_name,
                                                                                            guint32 id,
                                                                                            const gchar* app_icon,
                                                                                            const gchar* summary,
                                                                                            const gchar* body,
                                                                                            gchar** actions,
                                                                                            gint actions_length1,
                                                                                            GHashTable* hints,
                                                                                            gint32 expire_timeout,
                                                                                            gpointer self);
static void budgie_notifications_view_on_notification_closed (BudgieNotificationsView* self,
                                                       guint32 id,
                                                       const gchar* app_name,
                                                       BudgieNotificationCloseReason reason);
static void _budgie_notifications_view_on_notification_closed_budgie_dispatcher_notification_closed (BudgieDispatcher* _sender,
                                                                                              guint32 id,
                                                                                              const gchar* app_name,
                                                                                              BudgieNotificationCloseReason reason,
                                                                                              gpointer self);
static void budgie_notifications_view_set_do_not_disturb (BudgieNotificationsView* self,
                                                   gboolean value);
static gboolean budgie_notifications_view_get_do_not_disturb (BudgieNotificationsView* self);
static void budgie_notifications_view_on_raven_get (BudgieNotificationsView* self,
                                             GObject* o,
                                             GAsyncResult* res);
static void budgie_notifications_view_clear_all (BudgieNotificationsView* self);
static void _budgie_notifications_view_clear_all_budgie_raven_interface_clear_all_notifications (BudgieRavenInterface* _sender,
                                                                                          gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static BudgieNotificationGroup* budgie_notifications_view_get_notification_group (BudgieNotificationsView* self,
                                                                           const gchar* name);
static BudgieNotificationSort budgie_notifications_view_get_sort_mode (BudgieNotificationsView* self);
static void ___lambda11_ (Block3Data* _data3_,
                   const gchar* name);
static void budgie_notifications_view_update_child_count (BudgieNotificationsView* self);
static void ____lambda11__budgie_notification_group_dismissed_group (BudgieNotificationGroup* _sender,
                                                              const gchar* app_name,
                                                              gpointer self);
static void ___lambda20_ (BudgieNotificationsView* self,
                   guint32 id);
static void ____lambda20__budgie_notification_group_dismissed_notification (BudgieNotificationGroup* _sender,
                                                                     guint32 id,
                                                                     gpointer self);
static void budgie_notifications_view_adjust_max_per_group (BudgieNotificationsView* self,
                                                     guint newmax,
                                                     gboolean trim);
static void budgie_notifications_view_check_notification_allocation (BudgieNotificationsView* self,
                                                              guint len);
static void budgie_notifications_view_do_not_disturb_toggle (BudgieNotificationsView* self);
static void budgie_notifications_view_set_sort_mode (BudgieNotificationsView* self,
                                              BudgieNotificationSort value);
static GObject * budgie_notifications_view_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _budgie_notifications_view_clear_all_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _budgie_notifications_view_do_not_disturb_toggle_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _budgie_notifications_view___lambda21_ (BudgieNotificationsView* self,
                                             const gchar* key);
static void __lambda22_ (BudgieNotificationsView* self,
                  GtkWidget* row);
static void ___lambda22__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void __budgie_notifications_view___lambda21__g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static void _budgie_notifications_view_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                                   GAsyncResult* res,
                                                                   gpointer self);
static void _budgie_notifications_view_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static void budgie_notifications_view_finalize (GObject * obj);
static GType budgie_notifications_view_get_type_once (void);
static void _vala_budgie_notifications_view_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_budgie_notifications_view_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_get_do_not_disturb_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_dispatcher_dbus_arg_info_get_do_not_disturb_in[] = {NULL};
static const GDBusArgInfo * const _budgie_dispatcher_dbus_arg_info_get_do_not_disturb_out[] = {&_budgie_dispatcher_dbus_arg_info_get_do_not_disturb_result, NULL};
static const GDBusMethodInfo _budgie_dispatcher_dbus_method_info_get_do_not_disturb = {-1, "GetDoNotDisturb", (GDBusArgInfo **) (&_budgie_dispatcher_dbus_arg_info_get_do_not_disturb_in), (GDBusArgInfo **) (&_budgie_dispatcher_dbus_arg_info_get_do_not_disturb_out), NULL};
static const GDBusArgInfo * const _budgie_dispatcher_dbus_arg_info_toggle_do_not_disturb_in[] = {NULL};
static const GDBusArgInfo * const _budgie_dispatcher_dbus_arg_info_toggle_do_not_disturb_out[] = {NULL};
static const GDBusMethodInfo _budgie_dispatcher_dbus_method_info_toggle_do_not_disturb = {-1, "ToggleDoNotDisturb", (GDBusArgInfo **) (&_budgie_dispatcher_dbus_arg_info_toggle_do_not_disturb_in), (GDBusArgInfo **) (&_budgie_dispatcher_dbus_arg_info_toggle_do_not_disturb_out), NULL};
static const GDBusMethodInfo * const _budgie_dispatcher_dbus_method_info[] = {&_budgie_dispatcher_dbus_method_info_get_do_not_disturb, &_budgie_dispatcher_dbus_method_info_toggle_do_not_disturb, NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_app_icon = {-1, "app_icon", "s", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_summary = {-1, "summary", "s", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_body = {-1, "body", "s", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_actions = {-1, "actions", "as", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_hints = {-1, "hints", "a{sv}", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_added_expire_timeout = {-1, "expire_timeout", "i", NULL};
static const GDBusArgInfo * const _budgie_dispatcher_dbus_arg_info_notification_added[] = {&_budgie_dispatcher_dbus_arg_info_notification_added_app_name, &_budgie_dispatcher_dbus_arg_info_notification_added_id, &_budgie_dispatcher_dbus_arg_info_notification_added_app_icon, &_budgie_dispatcher_dbus_arg_info_notification_added_summary, &_budgie_dispatcher_dbus_arg_info_notification_added_body, &_budgie_dispatcher_dbus_arg_info_notification_added_actions, &_budgie_dispatcher_dbus_arg_info_notification_added_hints, &_budgie_dispatcher_dbus_arg_info_notification_added_expire_timeout, NULL};
static const GDBusSignalInfo _budgie_dispatcher_dbus_signal_info_notification_added = {-1, "NotificationAdded", (GDBusArgInfo **) (&_budgie_dispatcher_dbus_arg_info_notification_added), NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_closed_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_closed_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _budgie_dispatcher_dbus_arg_info_notification_closed_reason = {-1, "reason", "i", NULL};
static const GDBusArgInfo * const _budgie_dispatcher_dbus_arg_info_notification_closed[] = {&_budgie_dispatcher_dbus_arg_info_notification_closed_id, &_budgie_dispatcher_dbus_arg_info_notification_closed_app_name, &_budgie_dispatcher_dbus_arg_info_notification_closed_reason, NULL};
static const GDBusSignalInfo _budgie_dispatcher_dbus_signal_info_notification_closed = {-1, "NotificationClosed", (GDBusArgInfo **) (&_budgie_dispatcher_dbus_arg_info_notification_closed), NULL};
static const GDBusSignalInfo * const _budgie_dispatcher_dbus_signal_info[] = {&_budgie_dispatcher_dbus_signal_info_notification_added, &_budgie_dispatcher_dbus_signal_info_notification_closed, NULL};
static const GDBusPropertyInfo _budgie_dispatcher_dbus_property_info_notifications_paused = {-1, "NotificationsPaused", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _budgie_dispatcher_dbus_property_info[] = {&_budgie_dispatcher_dbus_property_info_notifications_paused, NULL};
static const GDBusInterfaceInfo _budgie_dispatcher_dbus_interface_info = {-1, "org.buddiesofbudgie.budgie.Dispatcher", (GDBusMethodInfo **) (&_budgie_dispatcher_dbus_method_info), (GDBusSignalInfo **) (&_budgie_dispatcher_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_dispatcher_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_dispatcher_dbus_interface_vtable = {budgie_dispatcher_dbus_interface_method_call, budgie_dispatcher_dbus_interface_get_property, budgie_dispatcher_dbus_interface_set_property};
static const GDBusMethodInfo * const _budgie_raven_interface_dbus_method_info[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_interface_dbus_arg_info_clear_all_notifications[] = {NULL};
static const GDBusSignalInfo _budgie_raven_interface_dbus_signal_info_clear_all_notifications = {-1, "ClearAllNotifications", (GDBusArgInfo **) (&_budgie_raven_interface_dbus_arg_info_clear_all_notifications), NULL};
static const GDBusSignalInfo * const _budgie_raven_interface_dbus_signal_info[] = {&_budgie_raven_interface_dbus_signal_info_clear_all_notifications, NULL};
static const GDBusPropertyInfo * const _budgie_raven_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_raven_interface_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_budgie_raven_interface_dbus_method_info), (GDBusSignalInfo **) (&_budgie_raven_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_raven_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_raven_interface_dbus_interface_vtable = {budgie_raven_interface_dbus_interface_method_call, budgie_raven_interface_dbus_interface_get_property, budgie_raven_interface_dbus_interface_set_property};

BudgieNotificationPlaceholder*
budgie_notification_placeholder_construct (GType object_type)
{
	BudgieNotificationPlaceholder * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkImage* image = NULL;
	GtkImage* _tmp1_;
	GtkLabel* label = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	self = (BudgieNotificationPlaceholder*) g_object_new (object_type, "spacing", 6, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "dim-label");
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("notification-alert-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	gtk_image_set_pixel_size (image, 64);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) image, FALSE, FALSE, (guint) 6);
	_tmp2_ = g_strdup_printf ("<big>%s</big>", _ ("Nothing to see here"));
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	label = _tmp5_;
	gtk_label_set_use_markup (label, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	return self;
}

BudgieNotificationPlaceholder*
budgie_notification_placeholder_new (void)
{
	return budgie_notification_placeholder_construct (BUDGIE_TYPE_NOTIFICATION_PLACEHOLDER);
}

static void
budgie_notification_placeholder_class_init (BudgieNotificationPlaceholderClass * klass,
                                            gpointer klass_data)
{
	budgie_notification_placeholder_parent_class = g_type_class_peek_parent (klass);
}

static void
budgie_notification_placeholder_instance_init (BudgieNotificationPlaceholder * self,
                                               gpointer klass)
{
}

/**
* Simple placeholder to use when there are no notifications
*/
static GType
budgie_notification_placeholder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationPlaceholderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_placeholder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationPlaceholder), 0, (GInstanceInitFunc) budgie_notification_placeholder_instance_init, NULL };
	GType budgie_notification_placeholder_type_id;
	budgie_notification_placeholder_type_id = g_type_register_static (gtk_box_get_type (), "BudgieNotificationPlaceholder", &g_define_type_info, 0);
	return budgie_notification_placeholder_type_id;
}

GType
budgie_notification_placeholder_get_type (void)
{
	static volatile gsize budgie_notification_placeholder_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_placeholder_type_id__once)) {
		GType budgie_notification_placeholder_type_id;
		budgie_notification_placeholder_type_id = budgie_notification_placeholder_get_type_once ();
		g_once_init_leave (&budgie_notification_placeholder_type_id__once, budgie_notification_placeholder_type_id);
	}
	return budgie_notification_placeholder_type_id__once;
}

gboolean
budgie_dispatcher_get_do_not_disturb (BudgieDispatcher* self,
                                      GError** error)
{
	BudgieDispatcherIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BUDGIE_DISPATCHER_GET_INTERFACE (self);
	if (_iface_->get_do_not_disturb) {
		return _iface_->get_do_not_disturb (self, error);
	}
	return FALSE;
}

void
budgie_dispatcher_toggle_do_not_disturb (BudgieDispatcher* self,
                                         GError** error)
{
	BudgieDispatcherIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_DISPATCHER_GET_INTERFACE (self);
	if (_iface_->toggle_do_not_disturb) {
		_iface_->toggle_do_not_disturb (self, error);
	}
}

gboolean
budgie_dispatcher_get_notifications_paused (BudgieDispatcher* self)
{
	BudgieDispatcherIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BUDGIE_DISPATCHER_GET_INTERFACE (self);
	if (_iface_->get_notifications_paused) {
		return _iface_->get_notifications_paused (self);
	}
	return FALSE;
}

void
budgie_dispatcher_set_notifications_paused (BudgieDispatcher* self,
                                            gboolean value)
{
	BudgieDispatcherIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_DISPATCHER_GET_INTERFACE (self);
	if (_iface_->set_notifications_paused) {
		_iface_->set_notifications_paused (self, value);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT (GClosure * closure,
                                                                                    GValue * return_value,
                                                                                    guint n_param_values,
                                                                                    const GValue * param_values,
                                                                                    gpointer invocation_hint,
                                                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT) (gpointer data1, const char* arg_1, guint32 arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gpointer arg_6, gint arg_7, gpointer arg_8, gint32 arg_9, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 10);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boxed (param_values + 6), g_value_get_int (param_values + 7), g_value_get_boxed (param_values + 8), g_value_get_int (param_values + 9), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_STRING_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_STRING_ENUM) (gpointer data1, guint32 arg_1, const char* arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), g_value_get_enum (param_values + 3), data2);
}

static void
budgie_dispatcher_default_init (BudgieDispatcherIface * iface,
                                gpointer iface_data)
{
	budgie_dispatcher_signals[BUDGIE_DISPATCHER_NOTIFICATION_ADDED_SIGNAL] = g_signal_new ("notification-added", BUDGIE_TYPE_DISPATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT_STRING_STRING_STRING_BOXED_INT_BOXED_INT, G_TYPE_NONE, 9, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT, G_TYPE_HASH_TABLE, G_TYPE_INT);
	budgie_dispatcher_signals[BUDGIE_DISPATCHER_NOTIFICATION_CLOSED_SIGNAL] = g_signal_new ("notification-closed", BUDGIE_TYPE_DISPATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING_ENUM, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_STRING, BUDGIE_TYPE_NOTIFICATION_CLOSE_REASON);
}

static GType
budgie_dispatcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieDispatcherIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_dispatcher_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_dispatcher_type_id;
	budgie_dispatcher_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieDispatcher", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_dispatcher_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_dispatcher_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_dispatcher_proxy_get_type);
	g_type_set_qdata (budgie_dispatcher_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.buddiesofbudgie.budgie.Dispatcher");
	g_type_set_qdata (budgie_dispatcher_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_dispatcher_dbus_interface_info));
	g_type_set_qdata (budgie_dispatcher_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_dispatcher_register_object);
	return budgie_dispatcher_type_id;
}

GType
budgie_dispatcher_get_type (void)
{
	static volatile gsize budgie_dispatcher_type_id__once = 0;
	if (g_once_init_enter (&budgie_dispatcher_type_id__once)) {
		GType budgie_dispatcher_type_id;
		budgie_dispatcher_type_id = budgie_dispatcher_get_type_once ();
		g_once_init_leave (&budgie_dispatcher_type_id__once, budgie_dispatcher_type_id);
	}
	return budgie_dispatcher_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieDispatcherProxy, budgie_dispatcher_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_DISPATCHER, budgie_dispatcher_proxy_budgie_dispatcher_interface_init) )
static void
budgie_dispatcher_proxy_class_init (BudgieDispatcherProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_dispatcher_proxy_g_signal;
}

static void
_dbus_handle_budgie_dispatcher_notification_added (BudgieDispatcher* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* app_name = NULL;
	GVariant* _tmp0_;
	guint32 id = 0U;
	GVariant* _tmp1_;
	gchar* app_icon = NULL;
	GVariant* _tmp2_;
	gchar* summary = NULL;
	GVariant* _tmp3_;
	gchar* body = NULL;
	GVariant* _tmp4_;
	gchar** actions = NULL;
	gint actions_length1;
	GVariant* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length;
	gint _tmp6__size;
	gint _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	GHashTable* hints = NULL;
	GVariant* _tmp9_;
	GHashTable* _tmp10_;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gint32 expire_timeout = 0;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	app_name = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	app_icon = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	summary = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	body = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	actions_length1 = 0;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (gchar*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (gchar*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	actions_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	actions = _tmp6_;
	g_variant_unref (_tmp5_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp10_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp11_, _tmp9_);
	while (g_variant_iter_loop (&_tmp11_, "{?*}", &_tmp12_, &_tmp13_)) {
		g_hash_table_insert (_tmp10_, g_variant_dup_string (_tmp12_, NULL), g_variant_get_variant (_tmp13_));
	}
	hints = _tmp10_;
	g_variant_unref (_tmp9_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	expire_timeout = g_variant_get_int32 (_tmp14_);
	g_variant_unref (_tmp14_);
	g_signal_emit_by_name (self, "notification-added", app_name, id, app_icon, summary, body, actions, actions_length1, hints, expire_timeout);
	_g_free0 (app_name);
	_g_free0 (app_icon);
	_g_free0 (summary);
	_g_free0 (body);
	actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (hints);
}

static void
_dbus_handle_budgie_dispatcher_notification_closed (BudgieDispatcher* self,
                                                    GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint32 id = 0U;
	GVariant* _tmp15_;
	gchar* app_name = NULL;
	GVariant* _tmp16_;
	BudgieNotificationCloseReason reason = 0;
	GVariant* _tmp17_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp15_);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	app_name = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_get_int32 (_tmp17_);
	g_variant_unref (_tmp17_);
	g_signal_emit_by_name (self, "notification-closed", id, app_name, reason);
	_g_free0 (app_name);
}

static void
budgie_dispatcher_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	if (strcmp (signal_name, "NotificationAdded") == 0) {
		_dbus_handle_budgie_dispatcher_notification_added ((BudgieDispatcher*) proxy, parameters);
	} else if (strcmp (signal_name, "NotificationClosed") == 0) {
		_dbus_handle_budgie_dispatcher_notification_closed ((BudgieDispatcher*) proxy, parameters);
	}
}

static void
budgie_dispatcher_proxy_init (BudgieDispatcherProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_dispatcher_dbus_interface_info));
}

static gboolean
budgie_dispatcher_proxy_get_do_not_disturb (BudgieDispatcher* self,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp20_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.buddiesofbudgie.budgie.Dispatcher", "GetDoNotDisturb");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp18_ = FALSE;
		return _tmp18_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp19_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp19_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp20_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp20_);
	g_variant_unref (_tmp20_);
	g_object_unref (_reply_message);
	return _result;
}

static void
budgie_dispatcher_proxy_toggle_do_not_disturb (BudgieDispatcher* self,
                                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.buddiesofbudgie.budgie.Dispatcher", "ToggleDoNotDisturb");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
budgie_dispatcher_dbus_proxy_get_notifications_paused (BudgieDispatcher* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "NotificationsPaused");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.buddiesofbudgie.budgie.Dispatcher"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("NotificationsPaused"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp21_ = FALSE;
			return _tmp21_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
budgie_dispatcher_dbus_proxy_set_notifications_paused (BudgieDispatcher* self,
                                                       gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.buddiesofbudgie.budgie.Dispatcher"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("NotificationsPaused"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
budgie_dispatcher_proxy_budgie_dispatcher_interface_init (BudgieDispatcherIface* iface)
{
	iface->get_do_not_disturb = budgie_dispatcher_proxy_get_do_not_disturb;
	iface->toggle_do_not_disturb = budgie_dispatcher_proxy_toggle_do_not_disturb;
	iface->get_notifications_paused = budgie_dispatcher_dbus_proxy_get_notifications_paused;
	iface->set_notifications_paused = budgie_dispatcher_dbus_proxy_set_notifications_paused;
}

static void
_dbus_budgie_dispatcher_get_do_not_disturb (BudgieDispatcher* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_dispatcher_get_do_not_disturb (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_dispatcher_toggle_do_not_disturb (BudgieDispatcher* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_dispatcher_toggle_do_not_disturb (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_dispatcher_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetDoNotDisturb") == 0) {
		_dbus_budgie_dispatcher_get_do_not_disturb (object, parameters, invocation);
	} else if (strcmp (method_name, "ToggleDoNotDisturb") == 0) {
		_dbus_budgie_dispatcher_toggle_do_not_disturb (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_budgie_dispatcher_get_notifications_paused (BudgieDispatcher* self)
{
	gboolean result;
	GVariant* _reply;
	result = budgie_dispatcher_get_notifications_paused (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
budgie_dispatcher_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NotificationsPaused") == 0) {
		return _dbus_budgie_dispatcher_get_notifications_paused (object);
	}
	return NULL;
}

static void
_dbus_budgie_dispatcher_set_notifications_paused (BudgieDispatcher* self,
                                                  GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	budgie_dispatcher_set_notifications_paused (self, value);
}

static gboolean
budgie_dispatcher_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NotificationsPaused") == 0) {
		_dbus_budgie_dispatcher_set_notifications_paused (object, value);
		return TRUE;
	}
	return FALSE;
}

static void
_dbus_budgie_dispatcher_notification_added (GObject* _sender,
                                            const gchar* app_name,
                                            guint32 id,
                                            const gchar* app_icon,
                                            const gchar* summary,
                                            const gchar* body,
                                            gchar** actions,
                                            gint actions_length1,
                                            GHashTable* hints,
                                            gint32 expire_timeout,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	GVariantBuilder _tmp25_;
	GHashTableIter _tmp26_;
	gpointer _tmp27_;
	gpointer _tmp28_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_icon));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (summary));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (body));
	_tmp22_ = actions;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("as"));
	for (_tmp24_ = 0; _tmp24_ < actions_length1; _tmp24_++) {
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string (*_tmp22_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp23_));
	g_hash_table_iter_init (&_tmp26_, hints);
	g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp27_;
		_value = (GVariant*) _tmp28_;
		g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp25_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (expire_timeout));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.budgie.Dispatcher", "NotificationAdded", _arguments, NULL);
}

static void
_dbus_budgie_dispatcher_notification_closed (GObject* _sender,
                                             guint32 id,
                                             const gchar* app_name,
                                             BudgieNotificationCloseReason reason,
                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.budgie.Dispatcher", "NotificationClosed", _arguments, NULL);
}

guint
budgie_dispatcher_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_dispatcher_dbus_interface_info), &_budgie_dispatcher_dbus_interface_vtable, data, _budgie_dispatcher_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "notification-added", (GCallback) _dbus_budgie_dispatcher_notification_added, data);
	g_signal_connect (object, "notification-closed", (GCallback) _dbus_budgie_dispatcher_notification_closed, data);
	return result;
}

static void
_budgie_dispatcher_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_dispatcher_notification_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_dispatcher_notification_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
budgie_raven_interface_default_init (BudgieRavenInterfaceIface * iface,
                                     gpointer iface_data)
{
	budgie_raven_interface_signals[BUDGIE_RAVEN_INTERFACE_CLEAR_ALL_NOTIFICATIONS_SIGNAL] = g_signal_new ("clear-all-notifications", BUDGIE_TYPE_RAVEN_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
budgie_raven_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_raven_interface_type_id;
	budgie_raven_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieRavenInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_raven_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_raven_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_raven_interface_proxy_get_type);
	g_type_set_qdata (budgie_raven_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Raven");
	g_type_set_qdata (budgie_raven_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_raven_interface_dbus_interface_info));
	g_type_set_qdata (budgie_raven_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_raven_interface_register_object);
	return budgie_raven_interface_type_id;
}

GType
budgie_raven_interface_get_type (void)
{
	static volatile gsize budgie_raven_interface_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_interface_type_id__once)) {
		GType budgie_raven_interface_type_id;
		budgie_raven_interface_type_id = budgie_raven_interface_get_type_once ();
		g_once_init_leave (&budgie_raven_interface_type_id__once, budgie_raven_interface_type_id);
	}
	return budgie_raven_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieRavenInterfaceProxy, budgie_raven_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_RAVEN_INTERFACE, budgie_raven_interface_proxy_budgie_raven_interface_interface_init) )
static void
budgie_raven_interface_proxy_class_init (BudgieRavenInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_raven_interface_proxy_g_signal;
}

static void
_dbus_handle_budgie_raven_interface_clear_all_notifications (BudgieRavenInterface* self,
                                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "clear-all-notifications");
}

static void
budgie_raven_interface_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
	if (strcmp (signal_name, "ClearAllNotifications") == 0) {
		_dbus_handle_budgie_raven_interface_clear_all_notifications ((BudgieRavenInterface*) proxy, parameters);
	}
}

static void
budgie_raven_interface_proxy_init (BudgieRavenInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_raven_interface_dbus_interface_info));
}

static void
budgie_raven_interface_proxy_budgie_raven_interface_interface_init (BudgieRavenInterfaceIface* iface)
{
}

static void
budgie_raven_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
budgie_raven_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_raven_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_budgie_raven_interface_clear_all_notifications (GObject* _sender,
                                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ClearAllNotifications", _arguments, NULL);
}

guint
budgie_raven_interface_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_raven_interface_dbus_interface_info), &_budgie_raven_interface_dbus_interface_vtable, data, _budgie_raven_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "clear-all-notifications", (GCallback) _dbus_budgie_raven_interface_clear_all_notifications, data);
	return result;
}

static void
_budgie_raven_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_interface_clear_all_notifications, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_notifications_view_get_instance_private (BudgieNotificationsView* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsView_private_offset);
}

static void
_budgie_notifications_view_on_notification_added_budgie_dispatcher_notification_added (BudgieDispatcher* _sender,
                                                                                       const gchar* app_name,
                                                                                       guint32 id,
                                                                                       const gchar* app_icon,
                                                                                       const gchar* summary,
                                                                                       const gchar* body,
                                                                                       gchar** actions,
                                                                                       gint actions_length1,
                                                                                       GHashTable* hints,
                                                                                       gint32 expire_timeout,
                                                                                       gpointer self)
{
	budgie_notifications_view_on_notification_added ((BudgieNotificationsView*) self, app_name, id, app_icon, summary, body, actions, actions_length1, hints, expire_timeout);
}

static void
_budgie_notifications_view_on_notification_closed_budgie_dispatcher_notification_closed (BudgieDispatcher* _sender,
                                                                                         guint32 id,
                                                                                         const gchar* app_name,
                                                                                         BudgieNotificationCloseReason reason,
                                                                                         gpointer self)
{
	budgie_notifications_view_on_notification_closed ((BudgieNotificationsView*) self, id, app_name, reason);
}

static void
budgie_notifications_view_on_dbus_get (BudgieNotificationsView* self,
                                       GObject* o,
                                       GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieDispatcher* _tmp0_ = NULL;
		BudgieDispatcher* _tmp1_;
		BudgieDispatcher* _tmp2_;
		BudgieDispatcher* _tmp3_;
		BudgieDispatcher* _tmp4_;
		BudgieDispatcher* _tmp5_;
		gboolean _tmp6_ = FALSE;
		BudgieDispatcher* _tmp7_;
		GtkImage* _tmp8_ = NULL;
		gboolean _tmp9_;
		GtkButton* _tmp12_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieDispatcher*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieDispatcher*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->dispatcher);
		self->priv->dispatcher = _tmp3_;
		_tmp4_ = self->priv->dispatcher;
		g_signal_connect_object (_tmp4_, "notification-added", (GCallback) _budgie_notifications_view_on_notification_added_budgie_dispatcher_notification_added, self, 0);
		_tmp5_ = self->priv->dispatcher;
		g_signal_connect_object (_tmp5_, "notification-closed", (GCallback) _budgie_notifications_view_on_notification_closed_budgie_dispatcher_notification_closed, self, 0);
		_tmp7_ = self->priv->dispatcher;
		_tmp6_ = budgie_dispatcher_get_do_not_disturb (_tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		budgie_notifications_view_set_do_not_disturb (self, _tmp6_);
		_tmp9_ = self->priv->_do_not_disturb;
		if (_tmp9_) {
			GtkImage* _tmp10_;
			_tmp10_ = self->priv->image_notifications_disabled;
			_tmp8_ = _tmp10_;
		} else {
			GtkImage* _tmp11_;
			_tmp11_ = self->priv->image_notifications_enabled;
			_tmp8_ = _tmp11_;
		}
		_tmp12_ = self->priv->button_mute;
		gtk_button_set_image (_tmp12_, (GtkWidget*) _tmp8_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("notifications_view.vala:186: Unable to connect to notifications dispat" \
"cher: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_budgie_notifications_view_clear_all_budgie_raven_interface_clear_all_notifications (BudgieRavenInterface* _sender,
                                                                                     gpointer self)
{
	budgie_notifications_view_clear_all ((BudgieNotificationsView*) self);
}

static void
budgie_notifications_view_on_raven_get (BudgieNotificationsView* self,
                                        GObject* o,
                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieRavenInterface* _tmp0_ = NULL;
		BudgieRavenInterface* _tmp1_;
		BudgieRavenInterface* _tmp2_;
		BudgieRavenInterface* _tmp3_;
		BudgieRavenInterface* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieRavenInterface*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieRavenInterface*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven);
		self->priv->raven = _tmp3_;
		_tmp4_ = self->priv->raven;
		g_signal_connect_object (_tmp4_, "clear-all-notifications", (GCallback) _budgie_notifications_view_clear_all_budgie_raven_interface_clear_all_notifications, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("notifications_view.vala:195: Unable to connect to Raven via DBUS: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
budgie_notifications_view_on_notification_added (BudgieNotificationsView* self,
                                                 const gchar* app_name,
                                                 guint32 id,
                                                 const gchar* app_icon,
                                                 const gchar* summary,
                                                 const gchar* body,
                                                 gchar** actions,
                                                 gint actions_length1,
                                                 GHashTable* hints,
                                                 gint32 expire_timeout)
{
	BudgieNotification* notification = NULL;
	BudgieNotification* _tmp0_;
	GHashTable* _tmp1_;
	BudgieNotification* _tmp2_;
	BudgieNotification* _tmp3_;
	gchar* settings_app_name = NULL;
	BudgieNotification* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GSettings* application_settings = NULL;
	GSettingsSchemaSource* _tmp13_;
	GSettingsSchema* _tmp14_;
	GSettingsSchema* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	gboolean no_popup = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_name != NULL);
	g_return_if_fail (app_icon != NULL);
	g_return_if_fail (summary != NULL);
	g_return_if_fail (body != NULL);
	g_return_if_fail (hints != NULL);
	_tmp0_ = budgie_notification_new (id, app_name, app_icon, summary, body, actions, actions_length1, hints, (guint) expire_timeout);
	notification = _tmp0_;
	_tmp1_ = self->priv->notifications;
	_tmp2_ = notification;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	g_hash_table_insert (_tmp1_, (gpointer) ((guintptr) id), _tmp3_);
	_tmp4_ = notification;
	_tmp5_ = budgie_notification_get_app_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	settings_app_name = _tmp7_;
	if (g_hash_table_contains (hints, "desktop-entry")) {
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = g_hash_table_lookup (hints, "desktop-entry");
		_tmp9_ = g_variant_get_string ((GVariant*) _tmp8_, NULL);
		_tmp10_ = string_replace (_tmp9_, ".", "-");
		_tmp11_ = _tmp10_;
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
		_g_free0 (settings_app_name);
		settings_app_name = _tmp12_;
		_g_free0 (_tmp11_);
	}
	_tmp13_ = g_settings_schema_source_get_default ();
	_tmp14_ = g_settings_schema_source_lookup (_tmp13_, BUDGIE_NOTIFICATIONS_VIEW_APPLICATION_SCHEMA, TRUE);
	_tmp15_ = _tmp14_;
	_tmp16_ = settings_app_name;
	_tmp17_ = g_strdup_printf ("%s/%s/", BUDGIE_NOTIFICATIONS_VIEW_APPLICATION_PREFIX, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_settings_new_full (_tmp15_, NULL, _tmp18_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	_g_settings_schema_unref0 (_tmp15_);
	application_settings = _tmp20_;
	_tmp23_ = self->priv->_do_not_disturb;
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		BudgieDispatcher* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = self->priv->dispatcher;
		_tmp25_ = budgie_dispatcher_get_notifications_paused (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		GSettings* _tmp27_;
		_tmp27_ = application_settings;
		_tmp21_ = !g_settings_get_boolean (_tmp27_, "show-banners");
	}
	no_popup = _tmp21_;
	if (no_popup) {
		BudgieNotification* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = notification;
		_tmp29_ = budgie_notification_get_app_name (_tmp28_);
		_tmp30_ = _tmp29_;
		budgie_notifications_view_on_notification_closed (self, id, _tmp30_, BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED);
	}
	_g_object_unref0 (application_settings);
	_g_free0 (settings_app_name);
	_g_object_unref0 (notification);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieNotificationsView* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->group);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
___lambda11_ (Block3Data* _data3_,
              const gchar* name)
{
	BudgieNotificationsView* self;
	BudgieNotificationGroup* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BudgieRaven* _tmp3_;
	BudgieNotificationGroup* _tmp4_;
	self = _data3_->self;
	g_return_if_fail (name != NULL);
	_tmp0_ = _data3_->group;
	_tmp1_ = budgie_notification_group_get_noti_count (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->notification_count = self->priv->notification_count - _tmp2_;
	budgie_notifications_view_update_child_count (self);
	_tmp3_ = budgie_raven_get_instance ();
	budgie_raven_ReadNotifications (_tmp3_);
	_tmp4_ = _data3_->group;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
}

static void
____lambda11__budgie_notification_group_dismissed_group (BudgieNotificationGroup* _sender,
                                                         const gchar* app_name,
                                                         gpointer self)
{
	___lambda11_ (self, app_name);
}

static void
___lambda20_ (BudgieNotificationsView* self,
              guint32 id)
{
	gint _tmp0_;
	BudgieRaven* _tmp1_;
	_tmp0_ = self->priv->notification_count;
	self->priv->notification_count = _tmp0_ - 1;
	budgie_notifications_view_update_child_count (self);
	_tmp1_ = budgie_raven_get_instance ();
	budgie_raven_ReadNotifications (_tmp1_);
}

static void
____lambda20__budgie_notification_group_dismissed_notification (BudgieNotificationGroup* _sender,
                                                                guint32 id,
                                                                gpointer self)
{
	___lambda20_ ((BudgieNotificationsView*) self, id);
}

static void
budgie_notifications_view_on_notification_closed (BudgieNotificationsView* self,
                                                  guint32 id,
                                                  const gchar* app_name,
                                                  BudgieNotificationCloseReason reason)
{
	Block3Data* _data3_;
	BudgieNotification* notification = NULL;
	GHashTable* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar** spam_apps = NULL;
	GSettings* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint spam_apps_length1;
	gint _spam_apps_size_;
	gchar** spam_categories = NULL;
	GSettings* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint spam_categories_length1;
	gint _spam_categories_size_;
	const gchar* _tmp9_ = NULL;
	BudgieNotification* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* app_id = NULL;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	BudgieNotification* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean should_store = FALSE;
	BudgieNotificationGroup* _tmp28_ = NULL;
	BudgieNotification* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	BudgieNotificationGroup* _tmp32_;
	BudgieNotificationGroup* _tmp37_;
	BudgieNotificationGroup* _tmp38_;
	BudgieNotificationGroup* _tmp46_;
	BudgieNotification* _tmp47_;
	BudgieNotificationGroup* _tmp48_;
	gint _tmp49_;
	BudgieRaven* _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_name != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->notifications;
	_tmp2_ = g_hash_table_steal_extended (_tmp0_, (gpointer) ((guintptr) id), (gpointer) ((guintptr) NULL), &_tmp1_);
	_g_object_unref0 (notification);
	notification = (BudgieNotification*) _tmp1_;
	if (!_tmp2_) {
		_g_object_unref0 (notification);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	if (reason != BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED) {
		_g_object_unref0 (notification);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp3_ = self->priv->budgie_settings;
	_tmp5_ = _tmp4_ = g_settings_get_strv (_tmp3_, BUDGIE_ROOT_KEY_SPAM_APPS);
	spam_apps = _tmp5_;
	spam_apps_length1 = _vala_array_length (_tmp4_);
	_spam_apps_size_ = spam_apps_length1;
	_tmp6_ = self->priv->budgie_settings;
	_tmp8_ = _tmp7_ = g_settings_get_strv (_tmp6_, BUDGIE_ROOT_KEY_SPAM_CATEGORIES);
	spam_categories = _tmp8_;
	spam_categories_length1 = _vala_array_length (_tmp7_);
	_spam_categories_size_ = spam_categories_length1;
	_tmp10_ = notification;
	_tmp11_ = budgie_notification_get_app_id (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp9_ = _tmp12_;
	if (_tmp9_ == NULL) {
		BudgieNotification* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = notification;
		_tmp14_ = budgie_notification_get_app_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = _tmp15_;
	}
	_tmp16_ = g_strdup (_tmp9_);
	app_id = _tmp16_;
	_tmp19_ = notification;
	_tmp20_ = budgie_notification_get_category (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		BudgieNotification* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp22_ = notification;
		_tmp23_ = budgie_notification_get_category (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = spam_categories;
		_tmp25__length1 = spam_categories_length1;
		_tmp18_ = _vala_string_array_contains (_tmp25_, _tmp25__length1, _tmp24_);
	} else {
		_tmp18_ = FALSE;
	}
	if (!_tmp18_) {
		const gchar* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp26_ = app_id;
		_tmp27_ = spam_apps;
		_tmp27__length1 = spam_apps_length1;
		_tmp17_ = !_vala_string_array_contains (_tmp27_, _tmp27__length1, _tmp26_);
	} else {
		_tmp17_ = FALSE;
	}
	should_store = _tmp17_;
	if (!should_store) {
		_g_free0 (app_id);
		spam_categories = (_vala_array_free (spam_categories, spam_categories_length1, (GDestroyNotify) g_free), NULL);
		spam_apps = (_vala_array_free (spam_apps, spam_apps_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (notification);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp29_ = notification;
	_tmp30_ = budgie_notification_get_app_name (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = budgie_notifications_view_get_notification_group (self, _tmp31_);
	_tmp28_ = _tmp32_;
	if (_tmp28_ == NULL) {
		BudgieNotification* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		BudgieNotificationGroup* _tmp36_;
		_tmp33_ = notification;
		_tmp34_ = budgie_notification_get_app_id (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = budgie_notifications_view_get_notification_group (self, _tmp35_);
		_g_object_unref0 (_tmp28_);
		_tmp28_ = _tmp36_;
	}
	_tmp37_ = _tmp28_;
	_tmp28_ = NULL;
	_data3_->group = _tmp37_;
	_tmp38_ = _data3_->group;
	if (_tmp38_ == NULL) {
		BudgieNotification* _tmp39_;
		BudgieNotificationSort _tmp40_;
		BudgieNotificationGroup* _tmp41_;
		GtkListBox* _tmp42_;
		BudgieNotificationGroup* _tmp43_;
		BudgieNotificationGroup* _tmp44_;
		BudgieNotificationGroup* _tmp45_;
		_tmp39_ = notification;
		_tmp40_ = self->priv->_sort_mode;
		_tmp41_ = budgie_notification_group_new (_tmp39_, _tmp40_, self->priv->max_per_group);
		g_object_ref_sink (_tmp41_);
		_g_object_unref0 (_data3_->group);
		_data3_->group = _tmp41_;
		_tmp42_ = self->priv->listbox;
		_tmp43_ = _data3_->group;
		gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
		_tmp44_ = _data3_->group;
		g_signal_connect_data (_tmp44_, "dismissed-group", (GCallback) ____lambda11__budgie_notification_group_dismissed_group, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp45_ = _data3_->group;
		g_signal_connect_object (_tmp45_, "dismissed-notification", (GCallback) ____lambda20__budgie_notification_group_dismissed_notification, self, 0);
	}
	_tmp46_ = _data3_->group;
	_tmp47_ = notification;
	budgie_notification_group_add_notification (_tmp46_, id, _tmp47_);
	_tmp48_ = _data3_->group;
	gtk_widget_show_all ((GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->notification_count;
	self->priv->notification_count = _tmp49_ + 1;
	budgie_notifications_view_update_child_count (self);
	_tmp50_ = budgie_raven_get_instance ();
	budgie_raven_UnreadNotifications (_tmp50_);
	_g_object_unref0 (_tmp28_);
	_g_free0 (app_id);
	spam_categories = (_vala_array_free (spam_categories, spam_categories_length1, (GDestroyNotify) g_free), NULL);
	spam_apps = (_vala_array_free (spam_apps, spam_apps_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (notification);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static BudgieNotificationGroup*
budgie_notifications_view_get_notification_group (BudgieNotificationsView* self,
                                                  const gchar* name)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	BudgieNotificationGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (name == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
		group_collection = _tmp1_;
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			GtkWidget* group = NULL;
			group = (GtkWidget*) group_it->data;
			{
				GtkWidget* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = group;
				_tmp3_ = budgie_notification_group_get_app_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup));
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, name) == 0) {
					GtkWidget* _tmp5_;
					BudgieNotificationGroup* _tmp6_;
					_tmp5_ = group;
					_tmp6_ = _g_object_ref0 (BUDGIE_IS_NOTIFICATION_GROUP (_tmp5_) ? ((BudgieNotificationGroup*) _tmp5_) : NULL);
					result = _tmp6_;
					(group_collection == NULL) ? NULL : (group_collection = (g_list_free (group_collection), NULL));
					return result;
				}
			}
		}
		(group_collection == NULL) ? NULL : (group_collection = (g_list_free (group_collection), NULL));
	}
	result = NULL;
	return result;
}

static void
budgie_notifications_view_adjust_max_per_group (BudgieNotificationsView* self,
                                                guint newmax,
                                                gboolean trim)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
		group_collection = _tmp1_;
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			GtkWidget* group = NULL;
			group = (GtkWidget*) group_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = group;
				budgie_notification_group_set_group_max_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup), self->priv->max_per_group);
				if (trim) {
					GtkWidget* _tmp3_;
					_tmp3_ = group;
					budgie_notification_group_limit_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup));
				}
			}
		}
		(group_collection == NULL) ? NULL : (group_collection = (g_list_free (group_collection), NULL));
	}
}

static void
budgie_notifications_view_check_notification_allocation (BudgieNotificationsView* self,
                                                         guint len)
{
	guint n_groups = 0U;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	guint newmax = 0U;
	gboolean trim = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	n_groups = _tmp3_;
	newmax = self->priv->max_per_group;
	trim = FALSE;
	if (n_groups == ((guint) 0)) {
		newmax = BUDGIE_NOTIFICATIONS_VIEW_DEFAULT_MAX_PERGROUP;
	} else {
		if (len > BUDGIE_NOTIFICATIONS_VIEW_TOTAL_MAX_NOTIFICATIONS) {
			newmax = (guint) (((gfloat) BUDGIE_NOTIFICATIONS_VIEW_TOTAL_MAX_NOTIFICATIONS) / ((gfloat) n_groups));
			trim = TRUE;
		} else {
			gboolean _tmp4_ = FALSE;
			if (self->priv->max_per_group < BUDGIE_NOTIFICATIONS_VIEW_DEFAULT_MAX_PERGROUP) {
				_tmp4_ = (n_groups * (self->priv->max_per_group + 1)) <= BUDGIE_NOTIFICATIONS_VIEW_TOTAL_MAX_NOTIFICATIONS;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				newmax = (guint) (((gfloat) BUDGIE_NOTIFICATIONS_VIEW_TOTAL_MAX_NOTIFICATIONS) / ((gfloat) n_groups));
			}
		}
	}
	if (newmax != self->priv->max_per_group) {
		self->priv->max_per_group = newmax;
		budgie_notifications_view_adjust_max_per_group (self, newmax, trim);
	}
}

static void
budgie_notifications_view_update_child_count (BudgieNotificationsView* self)
{
	gchar* text = NULL;
	BudgieRaven* _tmp2_;
	BudgieHeaderWidget* _tmp3_;
	const gchar* _tmp4_;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	text = NULL;
	if (self->priv->notification_count > 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf (ngettext ("%u unread notification", "%u unread notifications", (gulong) self->priv->notification_count), (guint) self->priv->notification_count);
		_g_free0 (text);
		text = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("No unread notifications"));
		_g_free0 (text);
		text = _tmp1_;
	}
	_tmp2_ = budgie_raven_get_instance ();
	budgie_raven_set_notification_count (_tmp2_, (guint) self->priv->notification_count);
	_tmp3_ = self->priv->header;
	_tmp4_ = text;
	budgie_header_widget_set_text (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->clear_notifications_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, self->priv->notification_count > 0);
	budgie_notifications_view_check_notification_allocation (self, (guint) self->priv->notification_count);
	_g_free0 (text);
}

static void
budgie_notifications_view_clear_all (BudgieNotificationsView* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	BudgieRaven* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	self->priv->notification_count = 0;
	budgie_notifications_view_update_child_count (self);
	_tmp3_ = budgie_raven_get_instance ();
	budgie_raven_ReadNotifications (_tmp3_);
}

static void
budgie_notifications_view_do_not_disturb_toggle (BudgieNotificationsView* self)
{
	gboolean _tmp0_;
	GtkImage* _tmp1_ = NULL;
	gboolean _tmp2_;
	GtkButton* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_do_not_disturb;
	budgie_notifications_view_set_do_not_disturb (self, !_tmp0_);
	_tmp2_ = self->priv->_do_not_disturb;
	if (!_tmp2_) {
		GtkImage* _tmp3_;
		_tmp3_ = self->priv->image_notifications_enabled;
		_tmp1_ = _tmp3_;
	} else {
		GtkImage* _tmp4_;
		_tmp4_ = self->priv->image_notifications_disabled;
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = self->priv->button_mute;
	gtk_button_set_image (_tmp5_, (GtkWidget*) _tmp1_);
	{
		BudgieDispatcher* _tmp6_;
		_tmp6_ = self->priv->dispatcher;
		budgie_dispatcher_toggle_do_not_disturb (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("notifications_view.vala:369: Unable to toggle Do Not Disturb: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

BudgieNotificationsView*
budgie_notifications_view_construct (GType object_type)
{
	BudgieNotificationsView * self = NULL;
	self = (BudgieNotificationsView*) g_object_new (object_type, NULL);
	return self;
}

BudgieNotificationsView*
budgie_notifications_view_new (void)
{
	return budgie_notifications_view_construct (BUDGIE_TYPE_NOTIFICATIONS_VIEW);
}

static gboolean
budgie_notifications_view_get_do_not_disturb (BudgieNotificationsView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_do_not_disturb;
	return result;
}

static void
budgie_notifications_view_set_do_not_disturb (BudgieNotificationsView* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_do_not_disturb = value;
}

static BudgieNotificationSort
budgie_notifications_view_get_sort_mode (BudgieNotificationsView* self)
{
	BudgieNotificationSort result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_mode;
	return result;
}

static void
budgie_notifications_view_set_sort_mode (BudgieNotificationsView* self,
                                         BudgieNotificationSort value)
{
	g_return_if_fail (self != NULL);
	self->priv->_sort_mode = value;
}

static void
_budgie_notifications_view_clear_all_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	budgie_notifications_view_clear_all ((BudgieNotificationsView*) self);
}

static void
_budgie_notifications_view_do_not_disturb_toggle_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	budgie_notifications_view_do_not_disturb_toggle ((BudgieNotificationsView*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda22_ (BudgieNotificationsView* self,
             GtkWidget* row)
{
	BudgieNotificationGroup* group = NULL;
	GtkWidget* _tmp0_;
	BudgieNotificationGroup* _tmp1_;
	BudgieNotificationGroup* _tmp2_;
	BudgieNotificationSort _tmp3_;
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_NOTIFICATION_GROUP (_tmp0_) ? ((BudgieNotificationGroup*) _tmp0_) : NULL);
	group = _tmp1_;
	_tmp2_ = group;
	_tmp3_ = self->priv->_sort_mode;
	budgie_notification_group_set_sort_mode (_tmp2_, _tmp3_);
	_g_object_unref0 (group);
}

static void
___lambda22__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda22_ ((BudgieNotificationsView*) self, widget);
}

static void
_budgie_notifications_view___lambda21_ (BudgieNotificationsView* self,
                                        const gchar* key)
{
	GSettings* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->raven_settings;
	budgie_notifications_view_set_sort_mode (self, (BudgieNotificationSort) g_settings_get_enum (_tmp0_, key));
	_tmp1_ = self->priv->listbox;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda22__gtk_callback, self);
}

static void
__budgie_notifications_view___lambda21__g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	_budgie_notifications_view___lambda21_ ((BudgieNotificationsView*) self, key);
}

static void
_budgie_notifications_view_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self)
{
	budgie_notifications_view_on_dbus_get ((BudgieNotificationsView*) self, source_object, res);
	g_object_unref (self);
}

static void
_budgie_notifications_view_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	budgie_notifications_view_on_raven_get ((BudgieNotificationsView*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
budgie_notifications_view_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsView * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkButton* _tmp14_;
	GtkImage* _tmp15_;
	GtkBox* control_buttons = NULL;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkButton* _tmp18_;
	GtkBox* _tmp19_;
	GtkButton* _tmp20_;
	GtkBox* _tmp21_;
	BudgieHeaderWidget* _tmp22_;
	BudgieHeaderWidget* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	BudgieHeaderWidget* _tmp26_;
	GHashFunc _tmp27_;
	GEqualFunc _tmp28_;
	GHashTable* _tmp29_;
	GtkScrolledWindow* scrolledwindow = NULL;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkListBox* _tmp35_;
	GtkListBox* _tmp36_;
	BudgieNotificationPlaceholder* placeholder = NULL;
	BudgieNotificationPlaceholder* _tmp37_;
	GtkListBox* _tmp38_;
	BudgieNotificationPlaceholder* _tmp39_;
	GtkScrolledWindow* _tmp40_;
	GtkListBox* _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (budgie_notifications_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsView);
	_tmp0_ = g_settings_new (BUDGIE_NOTIFICATIONS_VIEW_BUDGIE_PANEL_SCHEMA);
	_g_object_unref0 (self->priv->budgie_settings);
	self->priv->budgie_settings = _tmp0_;
	_tmp1_ = g_settings_new (BUDGIE_NOTIFICATIONS_VIEW_BUDGIE_RAVEN_SCHEMA);
	_g_object_unref0 (self->priv->raven_settings);
	self->priv->raven_settings = _tmp1_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "raven-notifications-view");
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-all-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->clear_notifications_button);
	self->priv->clear_notifications_button = _tmp3_;
	_tmp4_ = self->priv->clear_notifications_button;
	gtk_button_set_relief (_tmp4_, GTK_RELIEF_NONE);
	_tmp5_ = self->priv->clear_notifications_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->clear_notifications_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->clear_notifications_button;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, "clear-all-notifications");
	_tmp9_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->button_mute);
	self->priv->button_mute = _tmp9_;
	_tmp10_ = self->priv->button_mute;
	gtk_button_set_relief (_tmp10_, GTK_RELIEF_NONE);
	_tmp11_ = self->priv->button_mute;
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = self->priv->button_mute;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "do-not-disturb");
	_tmp14_ = self->priv->button_mute;
	_tmp15_ = self->priv->image_notifications_enabled;
	gtk_button_set_image (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp16_);
	control_buttons = _tmp16_;
	_tmp17_ = control_buttons;
	_tmp18_ = self->priv->button_mute;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, FALSE, FALSE, (guint) 0);
	_tmp19_ = control_buttons;
	_tmp20_ = self->priv->clear_notifications_button;
	gtk_box_pack_start (_tmp19_, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	_tmp21_ = control_buttons;
	_tmp22_ = budgie_header_widget_new (_ ("No new notifications"), "notification-alert-symbolic", FALSE, NULL, (GtkWidget*) _tmp21_);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp22_;
	_tmp23_ = self->priv->header;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp23_, 6);
	_tmp24_ = self->priv->clear_notifications_button;
	g_signal_connect_object (_tmp24_, "clicked", (GCallback) _budgie_notifications_view_clear_all_gtk_button_clicked, self, 0);
	_tmp25_ = self->priv->button_mute;
	g_signal_connect_object (_tmp25_, "clicked", (GCallback) _budgie_notifications_view_do_not_disturb_toggle_gtk_button_clicked, self, 0);
	_tmp26_ = self->priv->header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp26_, FALSE, FALSE, (guint) 0);
	_tmp27_ = g_direct_hash;
	_tmp28_ = g_direct_equal;
	_tmp29_ = g_hash_table_new_full (_tmp27_, _tmp28_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp29_;
	self->priv->notification_count = 0;
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp30_);
	scrolledwindow = _tmp30_;
	_tmp31_ = scrolledwindow;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
	gtk_style_context_add_class (_tmp32_, "raven-background");
	_tmp33_ = scrolledwindow;
	gtk_scrolled_window_set_policy (_tmp33_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp34_ = scrolledwindow;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
	_tmp35_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp35_;
	_tmp36_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp36_, GTK_SELECTION_NONE);
	_tmp37_ = budgie_notification_placeholder_new ();
	g_object_ref_sink (_tmp37_);
	placeholder = _tmp37_;
	_tmp38_ = self->priv->listbox;
	_tmp39_ = placeholder;
	gtk_list_box_set_placeholder (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = scrolledwindow;
	_tmp41_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->raven_settings;
	g_signal_connect_object (_tmp42_, "changed::notification-sort", (GCallback) __budgie_notifications_view___lambda21__g_settings_changed, self, 0);
	_tmp43_ = self->priv->raven_settings;
	budgie_notifications_view_set_sort_mode (self, (BudgieNotificationSort) g_settings_get_enum (_tmp43_, "notification-sort"));
	gtk_widget_show_all ((GtkWidget*) self);
	budgie_notifications_view_update_child_count (self);
	g_async_initable_new_async (BUDGIE_TYPE_DISPATCHER_PROXY, 0, NULL, _budgie_notifications_view_on_dbus_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_NOTIFICATION_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_NOTIFICATION_DBUS_OBJECT_PATH, "g-interface-name", "org.buddiesofbudgie.budgie.Dispatcher", NULL);
	g_async_initable_new_async (BUDGIE_TYPE_RAVEN_INTERFACE_PROXY, 0, NULL, _budgie_notifications_view_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Raven", NULL);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (scrolledwindow);
	_g_object_unref0 (control_buttons);
	return obj;
}

static void
budgie_notifications_view_class_init (BudgieNotificationsViewClass * klass,
                                      gpointer klass_data)
{
	budgie_notifications_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_view_finalize;
}

static void
budgie_notifications_view_instance_init (BudgieNotificationsView * self,
                                         gpointer klass)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	self->priv = budgie_notifications_view_get_instance_private (self);
	self->priv->max_per_group = BUDGIE_NOTIFICATIONS_VIEW_DEFAULT_MAX_PERGROUP;
	self->priv->header = NULL;
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("notification-disabled-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	self->priv->image_notifications_disabled = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("notification-alert-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	self->priv->image_notifications_enabled = _tmp1_;
	self->priv->_do_not_disturb = FALSE;
	self->priv->_sort_mode = BUDGIE_NOTIFICATION_SORT_NEW_OLD;
}

static void
budgie_notifications_view_finalize (GObject * obj)
{
	BudgieNotificationsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsView);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->button_mute);
	_g_object_unref0 (self->priv->clear_notifications_button);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->image_notifications_disabled);
	_g_object_unref0 (self->priv->image_notifications_enabled);
	_g_object_unref0 (self->priv->dispatcher);
	_g_hash_table_unref0 (self->priv->notifications);
	_g_object_unref0 (self->priv->budgie_settings);
	_g_object_unref0 (self->priv->raven_settings);
	_g_object_unref0 (self->priv->raven);
	G_OBJECT_CLASS (budgie_notifications_view_parent_class)->finalize (obj);
}

static GType
budgie_notifications_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsView), 0, (GInstanceInitFunc) budgie_notifications_view_instance_init, NULL };
	GType budgie_notifications_view_type_id;
	budgie_notifications_view_type_id = g_type_register_static (gtk_box_get_type (), "BudgieNotificationsView", &g_define_type_info, 0);
	BudgieNotificationsView_private_offset = g_type_add_instance_private (budgie_notifications_view_type_id, sizeof (BudgieNotificationsViewPrivate));
	return budgie_notifications_view_type_id;
}

GType
budgie_notifications_view_get_type (void)
{
	static volatile gsize budgie_notifications_view_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_view_type_id__once)) {
		GType budgie_notifications_view_type_id;
		budgie_notifications_view_type_id = budgie_notifications_view_get_type_once ();
		g_once_init_leave (&budgie_notifications_view_type_id__once, budgie_notifications_view_type_id);
	}
	return budgie_notifications_view_type_id__once;
}

static void
_vala_budgie_notifications_view_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BudgieNotificationsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_view_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BudgieNotificationsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATIONS_VIEW, BudgieNotificationsView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

