/* manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "plugin.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "budgie-private.h"
#include <budgie-config.h>
#include <gobject/gvaluecollector.h>
#include "session.h"
#include "raven.h"
#include <theme-manager.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>
#include <libpeas/peas.h>
#include <cairo-gobject.h>
#include <stdio.h>

#define BUDGIE_DBUS_NAME "org.budgie_desktop.Panel"
#define BUDGIE_DBUS_OBJECT_PATH "/org/budgie_desktop/Panel"
#define BUDGIE_MAX_SLOTS ((guint) 4)
#define BUDGIE_ROOT_SCHEMA "com.solus-project.budgie-panel"
#define BUDGIE_TOPLEVEL_SCHEMA "com.solus-project.budgie-panel.panel"
#define BUDGIE_TOPLEVEL_PREFIX "/com/solus-project/budgie-panel/panels"
#define BUDGIE_APPLET_SCHEMA "com.solus-project.budgie-panel.applet"
#define BUDGIE_APPLET_PREFIX "/com/solus-project/budgie-panel/applets"
#define BUDGIE_RAVEN_SCHEMA "com.solus-project.budgie-raven"
#define BUDGIE_ROOT_KEY_PANELS "panels"
#define BUDGIE_PANEL_KEY_POSITION "location"
#define BUDGIE_PANEL_KEY_TRANSPARENCY "transparency"
#define BUDGIE_PANEL_KEY_APPLETS "applets"
#define BUDGIE_PANEL_KEY_DARK_THEME "dark-theme"
#define BUDGIE_PANEL_KEY_SIZE "size"
#define BUDGIE_PANEL_KEY_SPACING "spacing"
#define BUDGIE_PANEL_KEY_AUTOHIDE "autohide"
#define BUDGIE_PANEL_KEY_SHADOW "enable-shadow"
#define BUDGIE_PANEL_KEY_DOCK_MODE "dock-mode"
#define BUDGIE_PANEL_KEY_REGIONS "theme-regions"
#define BUDGIE_PANEL_KEY_MIGRATION "migration-level"
#define BUDGIE_PANEL_KEY_LAYOUT "layout"
#define BUDGIE_RAVEN_KEY_POSITION "raven-position"
#define BUDGIE_BUDGIE_MIGRATION_LEVEL 1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SCREEN (budgie_screen_get_type ())
#define BUDGIE_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREEN, BudgieScreen))
#define BUDGIE_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREEN, BudgieScreenClass))
#define BUDGIE_IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREEN))
#define BUDGIE_IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREEN))
#define BUDGIE_SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREEN, BudgieScreenClass))

typedef struct _BudgieScreen BudgieScreen;
typedef struct _BudgieScreenClass BudgieScreenClass;
typedef struct _BudgieScreenPrivate BudgieScreenPrivate;
enum  {
	BUDGIE_SCREEN_0_PROPERTY,
	BUDGIE_SCREEN_NUM_PROPERTIES
};
static GParamSpec* budgie_screen_properties[BUDGIE_SCREEN_NUM_PROPERTIES];

#define BUDGIE_TYPE_PANEL_MANAGER_IFACE (budgie_panel_manager_iface_get_type ())
#define BUDGIE_PANEL_MANAGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIface))
#define BUDGIE_PANEL_MANAGER_IFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIfaceClass))
#define BUDGIE_IS_PANEL_MANAGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_MANAGER_IFACE))
#define BUDGIE_IS_PANEL_MANAGER_IFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_MANAGER_IFACE))
#define BUDGIE_PANEL_MANAGER_IFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIfaceClass))

typedef struct _BudgiePanelManagerIface BudgiePanelManagerIface;
typedef struct _BudgiePanelManagerIfaceClass BudgiePanelManagerIfaceClass;
typedef struct _BudgiePanelManagerIfacePrivate BudgiePanelManagerIfacePrivate;

#define BUDGIE_TYPE_PANEL_MANAGER (budgie_panel_manager_get_type ())
#define BUDGIE_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManager))
#define BUDGIE_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))
#define BUDGIE_IS_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_IS_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_PANEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))

typedef struct _BudgiePanelManager BudgiePanelManager;
typedef struct _BudgiePanelManagerClass BudgiePanelManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieParamSpecPanelManagerIface BudgieParamSpecPanelManagerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BudgiePanelManagerPrivate BudgiePanelManagerPrivate;

#define BUDGIE_TYPE_PANEL (budgie_panel_get_type ())
#define BUDGIE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL, BudgiePanel))
#define BUDGIE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL, BudgiePanelClass))
#define BUDGIE_IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL))
#define BUDGIE_IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL))
#define BUDGIE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL, BudgiePanelClass))

typedef struct _BudgiePanel BudgiePanel;
typedef struct _BudgiePanelClass BudgiePanelClass;

#define BUDGIE_TYPE_PANEL_PLUGIN_MANAGER (budgie_panel_plugin_manager_get_type ())
#define BUDGIE_PANEL_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManager))
#define BUDGIE_PANEL_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManagerClass))
#define BUDGIE_IS_PANEL_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER))
#define BUDGIE_IS_PANEL_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER))
#define BUDGIE_PANEL_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManagerClass))

typedef struct _BudgiePanelPluginManager BudgiePanelPluginManager;
typedef struct _BudgiePanelPluginManagerClass BudgiePanelPluginManagerClass;

#define BUDGIE_TYPE_SETTINGS_WINDOW (budgie_settings_window_get_type ())
#define BUDGIE_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindow))
#define BUDGIE_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindowClass))
#define BUDGIE_IS_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_WINDOW))
#define BUDGIE_IS_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_WINDOW))
#define BUDGIE_SETTINGS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindowClass))

typedef struct _BudgieSettingsWindow BudgieSettingsWindow;
typedef struct _BudgieSettingsWindowClass BudgieSettingsWindowClass;
enum  {
	BUDGIE_PANEL_MANAGER_0_PROPERTY,
	BUDGIE_PANEL_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_panel_manager_properties[BUDGIE_PANEL_MANAGER_NUM_PROPERTIES];
#define _budgie_panel_manager_iface_unref0(var) ((var == NULL) ? NULL : (var = (budgie_panel_manager_iface_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _budgie_raven_plugin_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_raven_plugin_manager_unref (var), NULL)))
#define _budgie_panel_plugin_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_panel_plugin_manager_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgiePanelManagerRegisterWithSessionData BudgiePanelManagerRegisterWithSessionData;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _BudgiePanelPluginManagerPrivate BudgiePanelPluginManagerPrivate;
typedef enum  {
	UUID_UUID_FLAGS_LOWER_CASE = 1 << 0,
	UUID_UUID_FLAGS_UPPER_CASE = 1 << 1,
	UUID_UUID_FLAGS_DEFAULT_CASE = 1 << 2,
	UUID_UUID_FLAGS_RANDOM_TYPE = 1 << 3,
	UUID_UUID_FLAGS_DEFAULT_TYPE = 1 << 4,
	UUID_UUID_FLAGS_TIME_TYPE = 1 << 5,
	UUID_UUID_FLAGS_TIME_SAFE_TYPE = 1 << 6
} LibUUIDUUIDFlags;

#define UUID_TYPE_UUID_FLAGS (uuid_uuid_flags_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _BudgieScreen {
	GObject parent_instance;
	BudgieScreenPrivate * priv;
	BudgiePanelPosition slots;
	GdkRectangle area;
};

struct _BudgieScreenClass {
	GObjectClass parent_class;
};

struct _BudgiePanelManagerIface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgiePanelManagerIfacePrivate * priv;
};

struct _BudgiePanelManagerIfaceClass {
	GTypeClass parent_class;
	void (*finalize) (BudgiePanelManagerIface *self);
};

struct _BudgiePanelManagerIfacePrivate {
	BudgiePanelManager* manager;
};

struct _BudgieParamSpecPanelManagerIface {
	GParamSpec parent_instance;
};

struct _BudgiePanelManager {
	BudgieDesktopManager parent_instance;
	BudgiePanelManagerPrivate * priv;
};

struct _BudgiePanelManagerClass {
	BudgieDesktopManagerClass parent_class;
};

struct _BudgiePanelManagerPrivate {
	BudgiePanelManagerIface* iface;
	gboolean setup;
	gboolean reset;
	LibSessionSessionClient* sclient;
	GHashTable* screens;
	GHashTable* panels;
	gint primary_monitor;
	GSettings* settings;
	GSettings* raven_settings;
	BudgieRaven* raven;
	BudgieRavenPosition raven_position;
	BudgieRavenPluginManager* raven_plugin_manager;
	BudgiePanelPluginManager* panel_plugin_manager;
	BudgieThemeManager* theme_manager;
	BudgieSettingsWindow* settings_window;
	WnckScreen* wnck_screen;
	GList* window_list;
	gchar* default_layout;
};

struct _BudgiePanelManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgiePanelManager* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	LibSessionSessionClient* _tmp4_;
};

struct _Block1Data {
	int _ref_count_;
	BudgiePanelManager* self;
	WnckWindow* window;
};

struct _Block2Data {
	int _ref_count_;
	BudgiePanelManager* self;
	WnckWindow* window;
};

struct _Block3Data {
	int _ref_count_;
	BudgiePanelManager* self;
	gboolean found;
};

struct _BudgiePanelPluginManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgiePanelPluginManagerPrivate * priv;
	gboolean migrate_load_requirements_met;
};

struct _BudgiePanelPluginManagerClass {
	GTypeClass parent_class;
	void (*finalize) (BudgiePanelPluginManager *self);
};

static gpointer budgie_screen_parent_class = NULL;
static gint BudgiePanelManagerIface_private_offset;
static gpointer budgie_panel_manager_iface_parent_class = NULL;
static gint BudgiePanelManager_private_offset;
static gpointer budgie_panel_manager_parent_class = NULL;

VALA_EXTERN GType budgie_screen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreen, g_object_unref)
VALA_EXTERN BudgieScreen* budgie_screen_new (void);
VALA_EXTERN BudgieScreen* budgie_screen_construct (GType object_type);
static void budgie_screen_finalize (GObject * obj);
static GType budgie_screen_get_type_once (void);
VALA_EXTERN gpointer budgie_panel_manager_iface_ref (gpointer instance);
VALA_EXTERN void budgie_panel_manager_iface_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_panel_manager_iface (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void budgie_value_set_panel_manager_iface (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void budgie_value_take_panel_manager_iface (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_panel_manager_iface (const GValue* value);
VALA_EXTERN GType budgie_panel_manager_iface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelManagerIface, budgie_panel_manager_iface_unref)
VALA_EXTERN guint budgie_panel_manager_iface_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN GType budgie_panel_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelManager, g_object_unref)
VALA_EXTERN BudgiePanelManagerIface* budgie_panel_manager_iface_new (BudgiePanelManager* manager);
VALA_EXTERN BudgiePanelManagerIface* budgie_panel_manager_iface_construct (GType object_type,
                                                               BudgiePanelManager* manager);
VALA_EXTERN gchar* budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self,
                                               GError** error);
VALA_EXTERN void budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self,
                                                gint action,
                                                GError** error);
VALA_EXTERN void budgie_panel_manager_activate_action (BudgiePanelManager* self,
                                           gint action);
VALA_EXTERN void budgie_panel_manager_iface_OpenSettings (BudgiePanelManagerIface* self,
                                              GError** error);
VALA_EXTERN void budgie_panel_manager_open_settings (BudgiePanelManager* self);
static void budgie_panel_manager_iface_finalize (BudgiePanelManagerIface * obj);
static GType budgie_panel_manager_iface_get_type_once (void);
static void _dbus_budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_budgie_panel_manager_iface_OpenSettings (BudgiePanelManagerIface* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void budgie_panel_manager_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* budgie_panel_manager_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static gboolean budgie_panel_manager_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _budgie_panel_manager_iface_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanel, g_object_unref)
VALA_EXTERN gpointer budgie_panel_plugin_manager_ref (gpointer instance);
VALA_EXTERN void budgie_panel_plugin_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_panel_plugin_manager (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void budgie_value_set_panel_plugin_manager (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void budgie_value_take_panel_plugin_manager (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_panel_plugin_manager (const GValue* value);
VALA_EXTERN GType budgie_panel_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelPluginManager, budgie_panel_plugin_manager_unref)
VALA_EXTERN GType budgie_settings_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsWindow, g_object_unref)
VALA_EXTERN gboolean budgie_panel_activate_action (BudgiePanel* self,
                                       gint remote_action);
static void budgie_panel_manager_end_session (BudgiePanelManager* self,
                                       gboolean quit);
static void budgie_panel_manager_register_with_session_data_free (gpointer _data);
static void budgie_panel_manager_register_with_session (BudgiePanelManager* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean budgie_panel_manager_register_with_session_finish (BudgiePanelManager* self,
                                                            GAsyncResult* _res_);
static gboolean budgie_panel_manager_register_with_session_co (BudgiePanelManagerRegisterWithSessionData* _data_);
static void budgie_panel_manager_register_with_session_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void __lambda27_ (BudgiePanelManager* self);
static void ___lambda27__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                                guint flags,
                                                                gpointer self);
static void __lambda28_ (BudgiePanelManager* self);
static void ___lambda28__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                          guint flags,
                                                          gpointer self);
static void __lambda29_ (BudgiePanelManager* self);
static void ___lambda29__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                                   gpointer self);
VALA_EXTERN BudgiePanelManager* budgie_panel_manager_new (gboolean reset);
VALA_EXTERN BudgiePanelManager* budgie_panel_manager_construct (GType object_type,
                                                    gboolean reset);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void budgie_panel_manager_do_dynamic_transparency_setup (BudgiePanelManager* self);
static void __lambda30_ (BudgiePanelManager* self,
                  WnckWindow* window);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda31_ (Block1Data* _data1_);
VALA_EXTERN void budgie_panel_manager_check_windows (BudgiePanelManager* self);
static void ___lambda31__wnck_window_state_changed (WnckWindow* _sender,
                                             WnckWindowState changed_mask,
                                             WnckWindowState new_state,
                                             gpointer self);
static void ___lambda30__gfunc (gconstpointer data,
                         gpointer self);
static void budgie_panel_manager_window_opened (BudgiePanelManager* self,
                                         WnckWindow* window);
static void _budgie_panel_manager_window_opened_wnck_screen_window_opened (WnckScreen* _sender,
                                                                    WnckWindow* window,
                                                                    gpointer self);
static void budgie_panel_manager_window_closed (BudgiePanelManager* self,
                                         WnckWindow* window);
static void _budgie_panel_manager_window_closed_wnck_screen_window_closed (WnckScreen* _sender,
                                                                    WnckWindow* window,
                                                                    gpointer self);
static void budgie_panel_manager_active_window_changed (BudgiePanelManager* self);
static void _budgie_panel_manager_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                    WnckWindow* previous_window,
                                                                                    gpointer self);
static void _budgie_panel_manager_check_windows_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                               WnckWorkspace* previous_workspace,
                                                                               gpointer self);
static void budgie_panel_manager_check_window_intersections (BudgiePanelManager* self,
                                                      WnckWindow* window);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda32_ (Block2Data* _data2_);
static void ___lambda32__wnck_window_state_changed (WnckWindow* _sender,
                                             WnckWindowState changed_mask,
                                             WnckWindowState new_state,
                                             gpointer self);
static void __lambda33_ (BudgiePanelManager* self,
                  WnckWindow* window);
static void ___lambda33__wnck_window_geometry_changed (WnckWindow* _sender,
                                                gpointer self);
static gboolean budgie_panel_manager_window_intersects_panel (BudgiePanelManager* self,
                                                       BudgieToplevel* panel,
                                                       WnckWindow* window);
static gboolean budgie_panel_manager_window_on_primary (BudgiePanelManager* self,
                                                 WnckWindow* window);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void budgie_panel_manager_set_panel_transparent (BudgiePanelManager* self,
                                                 gboolean transparent,
                                                 gboolean raven_force);
static void __lambda8_ (Block3Data* _data3_,
                 WnckWindow* window);
static void ___lambda8__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN void budgie_panel_set_transparent (BudgiePanel* self,
                                   gboolean transparent);
VALA_EXTERN void budgie_panel_set_occluded (BudgiePanel* self,
                                gboolean occluded);
VALA_EXTERN void budgie_panel_manager_reset_dconf_path (BudgiePanelManager* self,
                                            GSettings* settings);
VALA_EXTERN BudgieAppletInfo* budgie_panel_manager_get_applet (BudgiePanelManager* self,
                                                   const gchar* key);
static gchar* budgie_panel_manager_create_panel_path (BudgiePanelManager* self,
                                               const gchar* uuid);
VALA_EXTERN void budgie_panel_manager_on_monitors_changed (BudgiePanelManager* self);
VALA_EXTERN void budgie_panel_update_geometry (BudgiePanel* self,
                                   GdkRectangle* screen,
                                   BudgiePanelPosition position,
                                   gint size);
static void budgie_panel_manager_on_bus_acquired (BudgiePanelManager* self,
                                           GDBusConnection* conn);
VALA_EXTERN void budgie_panel_manager_on_name_acquired (BudgiePanelManager* self,
                                            GDBusConnection* conn,
                                            const gchar* name);
static void budgie_panel_manager_do_setup (BudgiePanelManager* self);
static void budgie_panel_manager_do_reset (BudgiePanelManager* self);
static void budgie_panel_manager_do_live_reset (BudgiePanelManager* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _budgie_panel_manager_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                            gpointer self);
static void _budgie_panel_manager_on_monitors_changed_gdk_screen_size_changed (GdkScreen* _sender,
                                                                        gpointer self);
static void __lambda34_ (BudgiePanelManager* self);
static void budgie_panel_manager_update_screen (BudgiePanelManager* self);
static void ___lambda34__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
VALA_EXTERN BudgiePanelPluginManager* budgie_panel_plugin_manager_new (void);
VALA_EXTERN BudgiePanelPluginManager* budgie_panel_plugin_manager_construct (GType object_type);
static void budgie_panel_manager_on_settings_requested (BudgiePanelManager* self);
static void _budgie_panel_manager_on_settings_requested_budgie_raven_request_settings_ui (BudgieRaven* _sender,
                                                                                   gpointer self);
static gboolean budgie_panel_manager_load_panels (BudgiePanelManager* self);
static void budgie_panel_manager_create_default (BudgiePanelManager* self,
                                          const gchar* layout_name);
static void budgie_panel_manager_perform_migration (BudgiePanelManager* self,
                                             gint current_migration_level);
static void __lambda35_ (BudgiePanelManager* self,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda35__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void budgie_panel_perform_migration (BudgiePanel* self,
                                     gint current_migration_level);
static GList* budgie_panel_manager_real_get_panel_plugins (BudgieDesktopManager* base);
VALA_EXTERN GList* budgie_panel_plugin_manager_get_all_plugins (BudgiePanelPluginManager* self);
static GList* budgie_panel_manager_real_get_raven_plugins (BudgieDesktopManager* base);
static void budgie_panel_manager_real_rescan_panel_plugins (BudgieDesktopManager* base);
VALA_EXTERN void budgie_panel_plugin_manager_rescan_plugins (BudgiePanelPluginManager* self);
static void budgie_panel_manager_real_rescan_raven_plugins (BudgieDesktopManager* base);
VALA_EXTERN BudgiePanelPosition budgie_panel_manager_get_first_position (BudgiePanelManager* self,
                                                             gint monitor);
static guint budgie_panel_manager_real_slots_available (BudgieDesktopManager* base);
static guint budgie_panel_manager_real_slots_used (BudgieDesktopManager* base);
static void budgie_panel_manager_load_panel (BudgiePanelManager* self,
                                      const gchar* uuid,
                                      gboolean configure);
VALA_EXTERN BudgiePanel* budgie_panel_new (BudgiePanelManager* manager,
                               BudgiePanelPluginManager* plugin_manager,
                               const gchar* uuid,
                               GSettings* settings);
VALA_EXTERN BudgiePanel* budgie_panel_construct (GType object_type,
                                     BudgiePanelManager* manager,
                                     BudgiePanelPluginManager* plugin_manager,
                                     const gchar* uuid,
                                     GSettings* settings);
static void budgie_panel_manager_show_panel (BudgiePanelManager* self,
                                      const gchar* uuid,
                                      BudgiePanelPosition position,
                                      BudgiePanelTransparency transparency,
                                      BudgieAutohidePolicy policy,
                                      gboolean dock_mode,
                                      gboolean shadow_visible,
                                      gint spacing);
static void budgie_panel_manager_set_shadow (BudgiePanelManager* self,
                                      const gchar* uuid,
                                      gboolean visible);
static void budgie_panel_manager_real_set_size (BudgieDesktopManager* base,
                                         const gchar* uuid,
                                         gint size);
static void budgie_panel_manager_real_set_spacing (BudgieDesktopManager* base,
                                            const gchar* uuid,
                                            gint spacing);
VALA_EXTERN void budgie_panel_update_spacing (BudgiePanel* self);
static void budgie_panel_manager_real_set_placement (BudgieDesktopManager* base,
                                              const gchar* uuid,
                                              BudgiePanelPosition position);
static void budgie_panel_manager_real_set_transparency (BudgieDesktopManager* base,
                                                 const gchar* uuid,
                                                 BudgiePanelTransparency transparency);
VALA_EXTERN void budgie_panel_update_transparency (BudgiePanel* self,
                                       BudgiePanelTransparency transparency);
static void budgie_panel_manager_real_set_autohide (BudgieDesktopManager* base,
                                             const gchar* uuid,
                                             BudgieAutohidePolicy policy);
VALA_EXTERN void budgie_panel_set_autohide_policy (BudgiePanel* self,
                                       BudgieAutohidePolicy policy);
static void budgie_panel_manager_real_set_dock_mode (BudgieDesktopManager* base,
                                              const gchar* uuid,
                                              gboolean dock_mode);
VALA_EXTERN void budgie_panel_update_shadow (BudgiePanel* self,
                                 gboolean visible);
static gboolean budgie_panel_manager_is_panel_huggable (BudgiePanelManager* self,
                                                 BudgieToplevel* panel);
static void budgie_panel_manager_set_raven_position (BudgiePanelManager* self,
                                              BudgieToplevel* left,
                                              BudgieToplevel* right,
                                              GdkRectangle* raven_screen);
static void budgie_panel_manager_real_create_new_panel (BudgieDesktopManager* base);
static void budgie_panel_manager_create_panel (BudgiePanelManager* self,
                                        const gchar* name,
                                        GKeyFile* new_defaults);
static void budgie_panel_manager_real_delete_panel (BudgieDesktopManager* base,
                                             const gchar* uuid);
static void budgie_panel_manager_set_panels (BudgiePanelManager* self);
VALA_EXTERN void budgie_panel_destroy_children (BudgiePanel* self);
VALA_EXTERN GType uuid_uuid_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* uuid_new (LibUUIDUUIDFlags flags);
VALA_EXTERN void budgie_panel_create_default_layout (BudgiePanel* self,
                                         const gchar* name,
                                         GKeyFile* config);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void budgie_panel_manager_create_system_default (BudgiePanelManager* self);
static gboolean budgie_panel_manager_load_default_from_config (BudgiePanelManager* self,
                                                        const gchar* uri);
static void budgie_panel_manager_on_name_lost (BudgiePanelManager* self,
                                        GDBusConnection* conn,
                                        const gchar* name);
VALA_EXTERN void budgie_panel_manager_serve (BudgiePanelManager* self,
                                 gboolean replace);
static void _budgie_panel_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self);
static void _budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                         const gchar* name,
                                                                         gpointer self);
static void _budgie_panel_manager_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection,
                                                                 const gchar* name,
                                                                 gpointer self);
static GList* budgie_panel_manager_real_get_panels (BudgieDesktopManager* base);
static gboolean __lambda12_ (BudgiePanelManager* self);
VALA_EXTERN BudgieSettingsWindow* budgie_settings_window_new (BudgieDesktopManager* manager);
VALA_EXTERN BudgieSettingsWindow* budgie_settings_window_construct (GType object_type,
                                                        BudgieDesktopManager* manager);
static void ___lambda26_ (BudgiePanelManager* self);
static void ____lambda26__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static gboolean ___lambda12__gsource_func (gpointer self);
static void budgie_panel_manager_finalize (GObject * obj);
static GType budgie_panel_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar* BUDGIE_MIGRATION_1_APPLETS[2] = {"User Indicator", "Raven Trigger"};
static const GDBusArgInfo _budgie_panel_manager_iface_dbus_arg_info_get_version_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_get_version_in[] = {NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_get_version_out[] = {&_budgie_panel_manager_iface_dbus_arg_info_get_version_result, NULL};
static const GDBusMethodInfo _budgie_panel_manager_iface_dbus_method_info_get_version = {-1, "GetVersion", (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_get_version_in), (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_get_version_out), NULL};
static const GDBusArgInfo _budgie_panel_manager_iface_dbus_arg_info_ActivateAction_action = {-1, "action", "i", NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_ActivateAction_in[] = {&_budgie_panel_manager_iface_dbus_arg_info_ActivateAction_action, NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_ActivateAction_out[] = {NULL};
static const GDBusMethodInfo _budgie_panel_manager_iface_dbus_method_info_ActivateAction = {-1, "ActivateAction", (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_ActivateAction_in), (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_ActivateAction_out), NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_OpenSettings_in[] = {NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_OpenSettings_out[] = {NULL};
static const GDBusMethodInfo _budgie_panel_manager_iface_dbus_method_info_OpenSettings = {-1, "OpenSettings", (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_OpenSettings_in), (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_OpenSettings_out), NULL};
static const GDBusMethodInfo * const _budgie_panel_manager_iface_dbus_method_info[] = {&_budgie_panel_manager_iface_dbus_method_info_get_version, &_budgie_panel_manager_iface_dbus_method_info_ActivateAction, &_budgie_panel_manager_iface_dbus_method_info_OpenSettings, NULL};
static const GDBusSignalInfo * const _budgie_panel_manager_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_panel_manager_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_panel_manager_iface_dbus_interface_info = {-1, "org.budgie_desktop.Panel", (GDBusMethodInfo **) (&_budgie_panel_manager_iface_dbus_method_info), (GDBusSignalInfo **) (&_budgie_panel_manager_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_panel_manager_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_panel_manager_iface_dbus_interface_vtable = {budgie_panel_manager_iface_dbus_interface_method_call, budgie_panel_manager_iface_dbus_interface_get_property, budgie_panel_manager_iface_dbus_interface_set_property};

BudgieScreen*
budgie_screen_construct (GType object_type)
{
	BudgieScreen * self = NULL;
	self = (BudgieScreen*) g_object_new (object_type, NULL);
	return self;
}

BudgieScreen*
budgie_screen_new (void)
{
	return budgie_screen_construct (BUDGIE_TYPE_SCREEN);
}

static void
budgie_screen_class_init (BudgieScreenClass * klass,
                          gpointer klass_data)
{
	budgie_screen_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_screen_finalize;
}

static void
budgie_screen_instance_init (BudgieScreen * self,
                             gpointer klass)
{
}

static void
budgie_screen_finalize (GObject * obj)
{
	BudgieScreen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SCREEN, BudgieScreen);
	G_OBJECT_CLASS (budgie_screen_parent_class)->finalize (obj);
}

/**
* Available slots
*/
static GType
budgie_screen_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieScreen), 0, (GInstanceInitFunc) budgie_screen_instance_init, NULL };
	GType budgie_screen_type_id;
	budgie_screen_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieScreen", &g_define_type_info, 0);
	return budgie_screen_type_id;
}

GType
budgie_screen_get_type (void)
{
	static volatile gsize budgie_screen_type_id__once = 0;
	if (g_once_init_enter (&budgie_screen_type_id__once)) {
		GType budgie_screen_type_id;
		budgie_screen_type_id = budgie_screen_get_type_once ();
		g_once_init_leave (&budgie_screen_type_id__once, budgie_screen_type_id);
	}
	return budgie_screen_type_id__once;
}

static inline gpointer
budgie_panel_manager_iface_get_instance_private (BudgiePanelManagerIface* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePanelManagerIface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgiePanelManagerIface*
budgie_panel_manager_iface_construct (GType object_type,
                                      BudgiePanelManager* manager)
{
	BudgiePanelManagerIface* self = NULL;
	BudgiePanelManager* _tmp0_;
	self = (BudgiePanelManagerIface*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	return self;
}

BudgiePanelManagerIface*
budgie_panel_manager_iface_new (BudgiePanelManager* manager)
{
	return budgie_panel_manager_iface_construct (BUDGIE_TYPE_PANEL_MANAGER_IFACE, manager);
}

gchar*
budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self,
                                        GError** error)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (BUDGIE_VERSION);
	result = _tmp0_;
	return result;
}

void
budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self,
                                           gint action,
                                           GError** error)
{
	BudgiePanelManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	budgie_panel_manager_activate_action (_tmp0_, action);
}

void
budgie_panel_manager_iface_OpenSettings (BudgiePanelManagerIface* self,
                                         GError** error)
{
	BudgiePanelManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	budgie_panel_manager_open_settings (_tmp0_);
}

static void
budgie_value_panel_manager_iface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_panel_manager_iface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_panel_manager_iface_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_panel_manager_iface_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_panel_manager_iface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_panel_manager_iface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_panel_manager_iface_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgiePanelManagerIface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_panel_manager_iface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_panel_manager_iface_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	BudgiePanelManagerIface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_panel_manager_iface_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_panel_manager_iface (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	BudgieParamSpecPanelManagerIface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_PANEL_MANAGER_IFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_panel_manager_iface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_MANAGER_IFACE), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_panel_manager_iface (GValue* value,
                                      gpointer v_object)
{
	BudgiePanelManagerIface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_panel_manager_iface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_panel_manager_iface_unref (old);
	}
}

void
budgie_value_take_panel_manager_iface (GValue* value,
                                       gpointer v_object)
{
	BudgiePanelManagerIface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_panel_manager_iface_unref (old);
	}
}

static void
budgie_panel_manager_iface_class_init (BudgiePanelManagerIfaceClass * klass,
                                       gpointer klass_data)
{
	budgie_panel_manager_iface_parent_class = g_type_class_peek_parent (klass);
	((BudgiePanelManagerIfaceClass *) klass)->finalize = budgie_panel_manager_iface_finalize;
	g_type_class_adjust_private_offset (klass, &BudgiePanelManagerIface_private_offset);
}

static void
budgie_panel_manager_iface_instance_init (BudgiePanelManagerIface * self,
                                          gpointer klass)
{
	self->priv = budgie_panel_manager_iface_get_instance_private (self);
	self->priv->manager = NULL;
	self->ref_count = 1;
}

static void
budgie_panel_manager_iface_finalize (BudgiePanelManagerIface * obj)
{
	BudgiePanelManagerIface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIface);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->manager);
}

static GType
budgie_panel_manager_iface_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_panel_manager_iface_init, budgie_value_panel_manager_iface_free_value, budgie_value_panel_manager_iface_copy_value, budgie_value_panel_manager_iface_peek_pointer, "p", budgie_value_panel_manager_iface_collect_value, "p", budgie_value_panel_manager_iface_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelManagerIfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_manager_iface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanelManagerIface), 0, (GInstanceInitFunc) budgie_panel_manager_iface_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_panel_manager_iface_type_id;
	budgie_panel_manager_iface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgiePanelManagerIface", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (budgie_panel_manager_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_panel_manager_iface_register_object);
	BudgiePanelManagerIface_private_offset = g_type_add_instance_private (budgie_panel_manager_iface_type_id, sizeof (BudgiePanelManagerIfacePrivate));
	return budgie_panel_manager_iface_type_id;
}

GType
budgie_panel_manager_iface_get_type (void)
{
	static volatile gsize budgie_panel_manager_iface_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_manager_iface_type_id__once)) {
		GType budgie_panel_manager_iface_type_id;
		budgie_panel_manager_iface_type_id = budgie_panel_manager_iface_get_type_once ();
		g_once_init_leave (&budgie_panel_manager_iface_type_id__once, budgie_panel_manager_iface_type_id);
	}
	return budgie_panel_manager_iface_type_id__once;
}

gpointer
budgie_panel_manager_iface_ref (gpointer instance)
{
	BudgiePanelManagerIface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_panel_manager_iface_unref (gpointer instance)
{
	BudgiePanelManagerIface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_PANEL_MANAGER_IFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_panel_manager_iface_get_version (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint action = 0;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	budgie_panel_manager_iface_ActivateAction (self, action, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_panel_manager_iface_OpenSettings (BudgiePanelManagerIface* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_panel_manager_iface_OpenSettings (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_panel_manager_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetVersion") == 0) {
		_dbus_budgie_panel_manager_iface_get_version (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateAction") == 0) {
		_dbus_budgie_panel_manager_iface_ActivateAction (object, parameters, invocation);
	} else if (strcmp (method_name, "OpenSettings") == 0) {
		_dbus_budgie_panel_manager_iface_OpenSettings (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_panel_manager_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_panel_manager_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_panel_manager_iface_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_panel_manager_iface_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_panel_manager_iface_dbus_interface_info), &_budgie_panel_manager_iface_dbus_interface_vtable, data, _budgie_panel_manager_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_panel_manager_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	budgie_panel_manager_iface_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_panel_manager_get_instance_private (BudgiePanelManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePanelManager_private_offset);
}

void
budgie_panel_manager_activate_action (BudgiePanelManager* self,
                                      gint action)
{
	const gchar* uuid = NULL;
	BudgiePanel* panel = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	uuid = NULL;
	panel = NULL;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgiePanel* _tmp4_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		uuid = (const gchar*) _tmp1_;
		panel = (BudgiePanel*) _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = panel;
		if (budgie_panel_activate_action (_tmp4_, action)) {
			break;
		}
	}
}

static void
budgie_panel_manager_end_session (BudgiePanelManager* self,
                                  gboolean quit)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (quit) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp0_;
		_tmp0_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp0_, TRUE, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("manager.vala:191: Unable to respond to session manager! %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_panel_manager_register_with_session_data_free (gpointer _data)
{
	BudgiePanelManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgiePanelManagerRegisterWithSessionData, _data_);
}

static void
budgie_panel_manager_register_with_session (BudgiePanelManager* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	BudgiePanelManagerRegisterWithSessionData* _data_;
	BudgiePanelManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgiePanelManagerRegisterWithSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_panel_manager_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_panel_manager_register_with_session_co (_data_);
}

static gboolean
budgie_panel_manager_register_with_session_finish (BudgiePanelManager* self,
                                                   GAsyncResult* _res_)
{
	gboolean result;
	BudgiePanelManagerRegisterWithSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
budgie_panel_manager_register_with_session_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	BudgiePanelManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_panel_manager_register_with_session_co (_data_);
}

static void
__lambda27_ (BudgiePanelManager* self)
{
	budgie_panel_manager_end_session (self, FALSE);
}

static void
___lambda27__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender,
                                                           guint flags,
                                                           gpointer self)
{
	__lambda27_ ((BudgiePanelManager*) self);
}

static void
__lambda28_ (BudgiePanelManager* self)
{
	budgie_panel_manager_end_session (self, FALSE);
}

static void
___lambda28__lib_session_session_client_end_session (LibSessionSessionClient* _sender,
                                                     guint flags,
                                                     gpointer self)
{
	__lambda28_ ((BudgiePanelManager*) self);
}

static void
__lambda29_ (BudgiePanelManager* self)
{
	budgie_panel_manager_end_session (self, TRUE);
}

static void
___lambda29__lib_session_session_client_stop (LibSessionSessionClient* _sender,
                                              gpointer self)
{
	__lambda29_ ((BudgiePanelManager*) self);
}

static gboolean
budgie_panel_manager_register_with_session_co (BudgiePanelManagerRegisterWithSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	lib_session_register_with_session ("budgie-panel", budgie_panel_manager_register_with_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
	_g_object_unref0 (_data_->self->priv->sclient);
	_data_->self->priv->sclient = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "query-end-session", (GCallback) ___lambda27__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "end-session", (GCallback) ___lambda28__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp4_, "stop", (GCallback) ___lambda29__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

BudgiePanelManager*
budgie_panel_manager_construct (GType object_type,
                                gboolean reset)
{
	BudgiePanelManager * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	self = (BudgiePanelManager*) g_object_new (object_type, NULL);
	self->priv->reset = reset;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->screens);
	self->priv->screens = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->panels);
	self->priv->panels = _tmp5_;
	return self;
}

BudgiePanelManager*
budgie_panel_manager_new (gboolean reset)
{
	return budgie_panel_manager_construct (BUDGIE_TYPE_PANEL_MANAGER, reset);
}

/**
* Initial setup of the dynamic transparency routine
* Executed after the initial setup of the panel manager
*/
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgiePanelManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda31_ (Block1Data* _data1_)
{
	BudgiePanelManager* self;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
	if (wnck_window_is_skip_pager (_data1_->window)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = wnck_window_is_skip_tasklist (_data1_->window);
	}
	if (_tmp0_) {
		return;
	}
	budgie_panel_manager_check_windows (self);
}

static void
___lambda31__wnck_window_state_changed (WnckWindow* _sender,
                                        WnckWindowState changed_mask,
                                        WnckWindowState new_state,
                                        gpointer self)
{
	__lambda31_ (self);
}

static void
__lambda30_ (BudgiePanelManager* self,
             WnckWindow* window)
{
	Block1Data* _data1_;
	WnckWindow* _tmp0_;
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data1_->window);
	_data1_->window = _tmp0_;
	self->priv->window_list = g_list_append (self->priv->window_list, _data1_->window);
	g_signal_connect_data (_data1_->window, "state-changed", (GCallback) ___lambda31__wnck_window_state_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
___lambda30__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda30_ ((BudgiePanelManager*) self, (WnckWindow*) data);
}

static void
_budgie_panel_manager_window_opened_wnck_screen_window_opened (WnckScreen* _sender,
                                                               WnckWindow* window,
                                                               gpointer self)
{
	budgie_panel_manager_window_opened ((BudgiePanelManager*) self, window);
}

static void
_budgie_panel_manager_window_closed_wnck_screen_window_closed (WnckScreen* _sender,
                                                               WnckWindow* window,
                                                               gpointer self)
{
	budgie_panel_manager_window_closed ((BudgiePanelManager*) self, window);
}

static void
_budgie_panel_manager_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                               WnckWindow* previous_window,
                                                                               gpointer self)
{
	budgie_panel_manager_active_window_changed ((BudgiePanelManager*) self);
}

static void
_budgie_panel_manager_check_windows_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                          WnckWorkspace* previous_workspace,
                                                                          gpointer self)
{
	budgie_panel_manager_check_windows ((BudgiePanelManager*) self);
}

static void
budgie_panel_manager_do_dynamic_transparency_setup (BudgiePanelManager* self)
{
	WnckScreen* _tmp0_;
	WnckScreen* _tmp1_;
	WnckScreen* _tmp2_;
	GList* _tmp3_;
	WnckScreen* _tmp4_;
	WnckScreen* _tmp5_;
	WnckScreen* _tmp6_;
	WnckScreen* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->wnck_screen);
	self->priv->wnck_screen = _tmp1_;
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (g_list_free (self->priv->window_list), NULL));
	self->priv->window_list = NULL;
	_tmp2_ = self->priv->wnck_screen;
	_tmp3_ = wnck_screen_get_windows (_tmp2_);
	g_list_foreach (_tmp3_, ___lambda30__gfunc, self);
	_tmp4_ = self->priv->wnck_screen;
	g_signal_connect_object (_tmp4_, "window-opened", (GCallback) _budgie_panel_manager_window_opened_wnck_screen_window_opened, self, 0);
	_tmp5_ = self->priv->wnck_screen;
	g_signal_connect_object (_tmp5_, "window-closed", (GCallback) _budgie_panel_manager_window_closed_wnck_screen_window_closed, self, 0);
	_tmp6_ = self->priv->wnck_screen;
	g_signal_connect_object (_tmp6_, "active-window-changed", (GCallback) _budgie_panel_manager_active_window_changed_wnck_screen_active_window_changed, self, 0);
	_tmp7_ = self->priv->wnck_screen;
	g_signal_connect_object (_tmp7_, "active-workspace-changed", (GCallback) _budgie_panel_manager_check_windows_wnck_screen_active_workspace_changed, self, 0);
}

static void
budgie_panel_manager_active_window_changed (BudgiePanelManager* self)
{
	WnckScreen* _tmp0_;
	WnckWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	budgie_panel_manager_check_windows (self);
	_tmp0_ = self->priv->wnck_screen;
	_tmp1_ = wnck_screen_get_active_window (_tmp0_);
	budgie_panel_manager_check_window_intersections (self, _tmp1_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgiePanelManager* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->window);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda32_ (Block2Data* _data2_)
{
	BudgiePanelManager* self;
	gboolean _tmp0_ = FALSE;
	self = _data2_->self;
	if (wnck_window_is_skip_pager (_data2_->window)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = wnck_window_is_skip_tasklist (_data2_->window);
	}
	if (_tmp0_) {
		return;
	}
	budgie_panel_manager_check_windows (self);
}

static void
___lambda32__wnck_window_state_changed (WnckWindow* _sender,
                                        WnckWindowState changed_mask,
                                        WnckWindowState new_state,
                                        gpointer self)
{
	__lambda32_ (self);
}

static void
__lambda33_ (BudgiePanelManager* self,
             WnckWindow* window)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (window != NULL);
	if (wnck_window_is_skip_pager (window)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = wnck_window_is_skip_tasklist (window);
	}
	if (_tmp0_) {
		return;
	}
	budgie_panel_manager_check_window_intersections (self, window);
}

static void
___lambda33__wnck_window_geometry_changed (WnckWindow* _sender,
                                           gpointer self)
{
	__lambda33_ ((BudgiePanelManager*) self, _sender);
}

static void
budgie_panel_manager_window_opened (BudgiePanelManager* self,
                                    WnckWindow* window)
{
	Block2Data* _data2_;
	WnckWindow* _tmp0_;
	GList* element = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data2_->window);
	_data2_->window = _tmp0_;
	_tmp1_ = self->priv->window_list;
	_tmp2_ = g_list_find (_tmp1_, _data2_->window);
	element = _tmp2_;
	_tmp3_ = element;
	if (_tmp3_ != NULL) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	self->priv->window_list = g_list_append (self->priv->window_list, _data2_->window);
	g_signal_connect_data (_data2_->window, "state-changed", (GCallback) ___lambda32__wnck_window_state_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_object (_data2_->window, "geometry-changed", (GCallback) ___lambda33__wnck_window_geometry_changed, self, G_CONNECT_AFTER);
	budgie_panel_manager_check_windows (self);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
budgie_panel_manager_window_closed (BudgiePanelManager* self,
                                    WnckWindow* window)
{
	GList* element = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->window_list;
	_tmp1_ = g_list_find (_tmp0_, window);
	element = _tmp1_;
	_tmp2_ = element;
	if (_tmp2_ == NULL) {
		return;
	}
	self->priv->window_list = g_list_remove_all (self->priv->window_list, window);
	budgie_panel_manager_check_windows (self);
}

/**
* Determine if the given panel and window intersect in geometry.
* The panel is buffered by a predetermined pad amount which allows
* for intelligent hiding behavior, i.e. when the window gets close to
* the panel, it should start the hide.
*/
static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static gboolean
budgie_panel_manager_window_intersects_panel (BudgiePanelManager* self,
                                              BudgieToplevel* panel,
                                              WnckWindow* window)
{
	static const gint pad_amount = 15;
	GdkRectangle win = {0};
	GdkRectangle pan = {0};
	gboolean _tmp0_ = FALSE;
	WnckScreen* _tmp2_;
	WnckWindow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GdkRectangle _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&win, 0, sizeof (GdkRectangle));
	memset (&pan, 0, sizeof (GdkRectangle));
	if (window == NULL) {
		GList* _tmp1_;
		_tmp1_ = self->priv->window_list;
		_tmp0_ = vala_g_list_is_empty (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->wnck_screen;
	_tmp3_ = wnck_screen_get_active_window (_tmp2_);
	if (window != _tmp3_) {
		result = FALSE;
		return result;
	}
	if (wnck_window_is_skip_pager (window)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = wnck_window_is_skip_tasklist (window);
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	wnck_window_get_geometry (window, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	win.x = _tmp5_;
	win.y = _tmp6_;
	win.width = _tmp7_;
	win.height = _tmp8_;
	gtk_window_get_position ((GtkWindow*) panel, &_tmp9_, &_tmp10_);
	pan.x = _tmp9_;
	pan.y = _tmp10_;
	gtk_window_get_size ((GtkWindow*) panel, &_tmp11_, &_tmp12_);
	pan.width = _tmp11_;
	pan.height = _tmp12_;
	pan.x = pan.x - pad_amount;
	pan.width = pan.width + (2 * pad_amount);
	pan.y = pan.y - pad_amount;
	pan.height = pan.height + (2 * pad_amount);
	_tmp13_ = pan;
	result = gdk_rectangle_intersect (&win, &_tmp13_, NULL);
	return result;
}

/**
* Check all windows against all panels for intersections
*
* An intersection is classified by a buffer zone match to allow dodging
* "near" windows automatically.
*/
static void
budgie_panel_manager_check_window_intersections (BudgiePanelManager* self,
                                                 WnckWindow* window)
{
	BudgiePanel* panel = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	panel = NULL;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		BudgiePanel* _tmp3_;
		BudgiePanel* _tmp4_;
		BudgieAutohidePolicy _tmp5_;
		BudgieAutohidePolicy _tmp6_;
		gboolean b = FALSE;
		BudgiePanel* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gboolean bn = FALSE;
		BudgiePanel* _tmp10_;
		BudgiePanel* _tmp11_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		_g_object_unref0 (panel);
		_tmp3_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
		panel = _tmp3_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = panel;
		_tmp5_ = budgie_toplevel_get_autohide ((BudgieToplevel*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != BUDGIE_AUTOHIDE_POLICY_INTELLIGENT) {
			continue;
		}
		_tmp7_ = panel;
		_tmp8_ = budgie_toplevel_get_intersected ((BudgieToplevel*) _tmp7_);
		_tmp9_ = _tmp8_;
		b = _tmp9_;
		_tmp10_ = panel;
		bn = budgie_panel_manager_window_intersects_panel (self, (BudgieToplevel*) _tmp10_, window);
		if (b == bn) {
			continue;
		}
		_tmp11_ = panel;
		budgie_toplevel_set_intersected ((BudgieToplevel*) _tmp11_, bn);
	}
	_g_object_unref0 (panel);
}

/**
* Determine if the window is on the primary screen, i.e. where the main
* budgie panels will show
* note wnck window geometry includes scale factors
*/
static gboolean
budgie_panel_manager_window_on_primary (BudgiePanelManager* self,
                                        WnckWindow* window)
{
	GdkRectangle area = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	BudgieScreen* primary = NULL;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	BudgieScreen* _tmp6_;
	GdkScreen* scr = NULL;
	GdkScreen* _tmp7_;
	GdkScreen* _tmp8_;
	GdkDisplay* dis = NULL;
	GdkDisplay* _tmp9_;
	GdkDisplay* _tmp10_;
	gint scale = 0;
	GdkMonitor* _tmp11_;
	GdkRectangle calc = {0};
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	GdkRectangle _tmp14_;
	GdkRectangle _tmp15_;
	GdkRectangle _tmp16_ = {0};
	GdkRectangle _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&area, 0, sizeof (GdkRectangle));
	wnck_window_get_geometry (window, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	area.x = _tmp0_;
	area.y = _tmp1_;
	area.width = _tmp2_;
	area.height = _tmp3_;
	_tmp4_ = self->priv->screens;
	_tmp5_ = g_hash_table_lookup (_tmp4_, (gpointer) ((gintptr) self->priv->primary_monitor));
	_tmp6_ = _g_object_ref0 ((BudgieScreen*) _tmp5_);
	primary = _tmp6_;
	_tmp7_ = gdk_screen_get_default ();
	_tmp8_ = _g_object_ref0 (_tmp7_);
	scr = _tmp8_;
	_tmp9_ = gdk_screen_get_display (scr);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	dis = _tmp10_;
	_tmp11_ = gdk_display_get_monitor (dis, self->priv->primary_monitor);
	scale = gdk_monitor_get_scale_factor (_tmp11_);
	_tmp12_ = primary->area;
	_tmp13_ = primary->area;
	_tmp14_ = primary->area;
	_tmp15_ = primary->area;
	_tmp16_.x = _tmp12_.x * scale;
	_tmp16_.y = _tmp13_.y * scale;
	_tmp16_.width = _tmp14_.width * scale;
	_tmp16_.height = _tmp15_.height * scale;
	calc = _tmp16_;
	_tmp17_ = calc;
	result = gdk_rectangle_intersect (&area, &_tmp17_, NULL);
	_g_object_unref0 (dis);
	_g_object_unref0 (scr);
	_g_object_unref0 (primary);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgiePanelManager* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda8_ (Block3Data* _data3_,
            WnckWindow* window)
{
	BudgiePanelManager* self;
	gboolean _tmp0_ = FALSE;
	gboolean is_maximized = FALSE;
	WnckWorkspace* _tmp1_;
	WnckScreen* _tmp2_;
	WnckWorkspace* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	self = _data3_->self;
	g_return_if_fail (window != NULL);
	if (wnck_window_is_maximized_horizontally (window)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = wnck_window_is_maximized_vertically (window);
	}
	is_maximized = _tmp0_;
	_tmp1_ = wnck_window_get_workspace (window);
	_tmp2_ = self->priv->wnck_screen;
	_tmp3_ = wnck_screen_get_active_workspace (_tmp2_);
	if (_tmp1_ != _tmp3_) {
		return;
	}
	if (wnck_window_is_skip_pager (window)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = wnck_window_is_skip_tasklist (window);
	}
	if (_tmp4_) {
		return;
	}
	if (!budgie_panel_manager_window_on_primary (self, window)) {
		return;
	}
	if (is_maximized) {
		_tmp5_ = !wnck_window_is_minimized (window);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_data3_->found = TRUE;
		return;
	}
}

static void
___lambda8__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda8_ (self, (WnckWindow*) data);
}

void
budgie_panel_manager_check_windows (BudgiePanelManager* self)
{
	Block3Data* _data3_;
	BudgieRaven* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->raven;
	if (budgie_raven_get_expanded (_tmp0_)) {
		budgie_panel_manager_set_panel_transparent (self, FALSE, TRUE);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_data3_->found = FALSE;
	_tmp1_ = self->priv->window_list;
	g_list_foreach (_tmp1_, ___lambda8__gfunc, _data3_);
	budgie_panel_manager_set_panel_transparent (self, !_data3_->found, FALSE);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
budgie_panel_manager_set_panel_transparent (BudgiePanelManager* self,
                                            gboolean transparent,
                                            gboolean raven_force)
{
	BudgiePanel* panel = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	panel = NULL;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		BudgiePanel* _tmp3_;
		BudgiePanel* _tmp4_;
		BudgiePanelTransparency _tmp5_;
		BudgiePanelTransparency _tmp6_;
		BudgiePanel* _tmp8_;
		BudgieAutohidePolicy _tmp9_;
		BudgieAutohidePolicy _tmp10_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		_g_object_unref0 (panel);
		_tmp3_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
		panel = _tmp3_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = panel;
		_tmp5_ = budgie_toplevel_get_transparency ((BudgieToplevel*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == BUDGIE_PANEL_TRANSPARENCY_DYNAMIC) {
			BudgiePanel* _tmp7_;
			_tmp7_ = panel;
			budgie_panel_set_transparent (_tmp7_, transparent);
		}
		_tmp8_ = panel;
		_tmp9_ = budgie_toplevel_get_autohide ((BudgieToplevel*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == BUDGIE_AUTOHIDE_POLICY_AUTOMATIC) {
			gboolean _tmp11_ = FALSE;
			BudgiePanel* _tmp12_;
			if (raven_force) {
				_tmp11_ = transparent;
			} else {
				_tmp11_ = !transparent;
			}
			_tmp12_ = panel;
			budgie_panel_set_occluded (_tmp12_, _tmp11_);
		}
	}
	_g_object_unref0 (panel);
}

/**
* Attempt to reset the given path
*/
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

void
budgie_panel_manager_reset_dconf_path (BudgiePanelManager* self,
                                       GSettings* settings)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* argv[4] = {0};
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_[4] = {0};
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (settings == NULL) {
		return;
	}
	g_object_get (settings, "path", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	path = _tmp1_;
	g_settings_sync ();
	g_object_get (settings, "path", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_g_free0 (path);
		return;
	}
	_tmp6_ = g_strdup ("dconf");
	_tmp7_ = g_strdup ("reset");
	_tmp8_ = g_strdup ("-f");
	_tmp9_ = path;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_[0] = _tmp6_;
	_tmp11_[1] = _tmp7_;
	_tmp11_[2] = _tmp8_;
	_tmp11_[3] = _tmp10_;
	memcpy (argv, _tmp11_, 4 * sizeof (gchar*));
	_tmp12_ = path;
	g_message ("manager.vala:442: Resetting dconf path: %s", _tmp12_);
	{
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = _vala_g_strjoinv (" ", argv, (gint) 4);
		_tmp14_ = _tmp13_;
		g_spawn_command_line_sync (_tmp14_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = path;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("manager.vala:446: Failed to reset dconf path %s: %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_vala_array_destroy (argv, 4, (GDestroyNotify) g_free);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_settings_sync ();
	_vala_array_destroy (argv, 4, (GDestroyNotify) g_free);
	_g_free0 (path);
}

BudgieAppletInfo*
budgie_panel_manager_get_applet (BudgiePanelManager* self,
                                 const gchar* key)
{
	BudgieAppletInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	result = NULL;
	return result;
}

static gchar*
budgie_panel_manager_create_panel_path (BudgiePanelManager* self,
                                        const gchar* uuid)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s/{%s}/", BUDGIE_TOPLEVEL_PREFIX, uuid);
	result = _tmp0_;
	return result;
}

/**
* Discover all possible monitors, and move things accordingly.
* In future we'll support per-monitor panels, but for now everything
* must be in one of the edges on the primary monitor
*/
void
budgie_panel_manager_on_monitors_changed (BudgiePanelManager* self)
{
	GdkScreen* scr = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkDisplay* dis = NULL;
	GdkScreen* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GHashTableIter iter = {0};
	const gchar* uuid = NULL;
	BudgiePanel* panel = NULL;
	BudgieScreen* primary = NULL;
	BudgiePanel* top = NULL;
	BudgiePanel* bottom = NULL;
	GHashTable* _tmp5_;
	GHashTable* _tmp22_;
	gconstpointer _tmp23_;
	GdkRectangle raven_screen = {0};
	GHashTable* _tmp24_;
	BudgieScreen* _tmp47_;
	GdkRectangle _tmp48_;
	BudgiePanel* _tmp49_;
	BudgiePanel* _tmp56_;
	BudgieRaven* _tmp60_;
	GdkRectangle _tmp61_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	scr = _tmp1_;
	_tmp2_ = scr;
	_tmp3_ = gdk_screen_get_display (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	dis = _tmp4_;
	top = NULL;
	bottom = NULL;
	_tmp5_ = self->priv->screens;
	g_hash_table_remove_all (_tmp5_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GdkDisplay* _tmp8_;
				GdkMonitor* mon = NULL;
				GdkDisplay* _tmp9_;
				GdkMonitor* _tmp10_;
				GdkMonitor* _tmp11_;
				GdkRectangle usable_area = {0};
				GdkMonitor* _tmp12_;
				GdkRectangle _tmp13_ = {0};
				BudgieScreen* screen = NULL;
				BudgieScreen* _tmp14_;
				BudgieScreen* _tmp15_;
				GdkRectangle _tmp16_;
				BudgieScreen* _tmp17_;
				GHashTable* _tmp18_;
				BudgieScreen* _tmp19_;
				BudgieScreen* _tmp20_;
				GdkMonitor* _tmp21_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = dis;
				if (!(i < gdk_display_get_n_monitors (_tmp8_))) {
					break;
				}
				_tmp9_ = dis;
				_tmp10_ = gdk_display_get_monitor (_tmp9_, i);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				mon = _tmp11_;
				_tmp12_ = mon;
				gdk_monitor_get_geometry (_tmp12_, &_tmp13_);
				usable_area = _tmp13_;
				_tmp14_ = budgie_screen_new ();
				screen = _tmp14_;
				_tmp15_ = screen;
				_tmp16_ = usable_area;
				_tmp15_->area = _tmp16_;
				_tmp17_ = screen;
				_tmp17_->slots = BUDGIE_PANEL_POSITION_NONE;
				_tmp18_ = self->priv->screens;
				_tmp19_ = screen;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				g_hash_table_insert (_tmp18_, (gpointer) ((gintptr) i), _tmp20_);
				_tmp21_ = mon;
				if (gdk_monitor_is_primary (_tmp21_)) {
					self->priv->primary_monitor = i;
				}
				_g_object_unref0 (screen);
				_g_object_unref0 (mon);
			}
		}
	}
	_tmp22_ = self->priv->screens;
	_tmp23_ = g_hash_table_lookup (_tmp22_, (gpointer) ((gintptr) self->priv->primary_monitor));
	primary = (BudgieScreen*) _tmp23_;
	_tmp24_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp24_);
	while (TRUE) {
		gconstpointer _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_;
		BudgiePanel* _tmp28_;
		BudgieScreen* _tmp29_;
		GdkRectangle _tmp30_;
		BudgiePanel* _tmp31_;
		BudgiePanelPosition _tmp32_;
		BudgiePanelPosition _tmp33_;
		BudgiePanel* _tmp34_;
		BudgiePanelPosition _tmp35_;
		BudgiePanelPosition _tmp36_;
		BudgieScreen* _tmp42_;
		BudgieScreen* _tmp43_;
		BudgiePanel* _tmp44_;
		BudgiePanelPosition _tmp45_;
		BudgiePanelPosition _tmp46_;
		_tmp27_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp25_), (gpointer*) (&_tmp26_));
		uuid = (const gchar*) _tmp25_;
		panel = (BudgiePanel*) _tmp26_;
		if (!_tmp27_) {
			break;
		}
		_tmp28_ = panel;
		_tmp29_ = primary;
		_tmp30_ = _tmp29_->area;
		_tmp31_ = panel;
		_tmp32_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp31_);
		_tmp33_ = _tmp32_;
		budgie_panel_update_geometry (_tmp28_, &_tmp30_, _tmp33_, 0);
		_tmp34_ = panel;
		_tmp35_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp36_ == BUDGIE_PANEL_POSITION_TOP) {
			BudgiePanel* _tmp37_;
			_tmp37_ = panel;
			top = _tmp37_;
		} else {
			BudgiePanel* _tmp38_;
			BudgiePanelPosition _tmp39_;
			BudgiePanelPosition _tmp40_;
			_tmp38_ = panel;
			_tmp39_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ == BUDGIE_PANEL_POSITION_BOTTOM) {
				BudgiePanel* _tmp41_;
				_tmp41_ = panel;
				bottom = _tmp41_;
			}
		}
		_tmp42_ = primary;
		_tmp43_ = primary;
		_tmp44_ = panel;
		_tmp45_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp43_->slots = _tmp43_->slots | _tmp46_;
	}
	_tmp47_ = primary;
	_tmp48_ = _tmp47_->area;
	raven_screen = _tmp48_;
	_tmp49_ = top;
	if (_tmp49_ != NULL) {
		BudgiePanel* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		BudgiePanel* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		_tmp50_ = top;
		_tmp51_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) _tmp50_);
		_tmp52_ = _tmp51_;
		raven_screen.y = raven_screen.y + _tmp52_;
		_tmp53_ = top;
		_tmp54_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) _tmp53_);
		_tmp55_ = _tmp54_;
		raven_screen.height = raven_screen.height - _tmp55_;
	}
	_tmp56_ = bottom;
	if (_tmp56_ != NULL) {
		BudgiePanel* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		_tmp57_ = bottom;
		_tmp58_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) _tmp57_);
		_tmp59_ = _tmp58_;
		raven_screen.height = raven_screen.height - _tmp59_;
	}
	_tmp60_ = self->priv->raven;
	_tmp61_ = raven_screen;
	budgie_raven_update_geometry (_tmp60_, &_tmp61_);
	_g_object_unref0 (dis);
	_g_object_unref0 (scr);
}

static void
budgie_panel_manager_on_bus_acquired (BudgiePanelManager* self,
                                      GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		BudgiePanelManagerIface* _tmp0_;
		BudgiePanelManagerIface* _tmp1_;
		_tmp0_ = budgie_panel_manager_iface_new (self);
		_budgie_panel_manager_iface_unref0 (self->priv->iface);
		self->priv->iface = _tmp0_;
		_tmp1_ = self->priv->iface;
		budgie_panel_manager_iface_register_object (_tmp1_, conn, BUDGIE_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = e->message;
		fprintf (_tmp2_, "Error registering PanelManager: %s\n", _tmp3_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
budgie_panel_manager_on_name_acquired (BudgiePanelManager* self,
                                       GDBusConnection* conn,
                                       const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	self->priv->setup = TRUE;
	budgie_panel_manager_do_setup (self);
	budgie_panel_manager_do_dynamic_transparency_setup (self);
}

/**
* Reset the entire panel configuration
*/
static void
budgie_panel_manager_do_reset (BudgiePanelManager* self)
{
	GSettings* s = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_message ("manager.vala:544: Resetting budgie-panel configuration to defaults");
	_tmp0_ = g_settings_new (BUDGIE_ROOT_SCHEMA);
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = g_settings_get_string (_tmp1_, BUDGIE_PANEL_KEY_LAYOUT);
	_g_free0 (self->priv->default_layout);
	self->priv->default_layout = _tmp2_;
	_tmp3_ = s;
	budgie_panel_manager_reset_dconf_path (self, _tmp3_);
	_tmp4_ = g_settings_new (BUDGIE_ROOT_SCHEMA);
	_g_object_unref0 (s);
	s = _tmp4_;
	_tmp5_ = s;
	_tmp6_ = self->priv->default_layout;
	g_settings_set_string (_tmp5_, BUDGIE_PANEL_KEY_LAYOUT, _tmp6_);
	_g_object_unref0 (s);
}

/**
* Reset after a failed load
*/
static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
budgie_panel_manager_do_live_reset (BudgiePanelManager* self)
{
	gchar** toplevel_ids = NULL;
	gint toplevel_ids_length1;
	gint _toplevel_ids_size_;
	GList* _tmp0_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_message ("manager.vala:557: Resetting budgie-panel configuration due to failed l" \
"oad");
	toplevel_ids = NULL;
	toplevel_ids_length1 = 0;
	_toplevel_ids_size_ = toplevel_ids_length1;
	_tmp0_ = budgie_desktop_manager_get_panels ((BudgieDesktopManager*) self);
	{
		GList* toplevel_collection = NULL;
		GList* toplevel_it = NULL;
		toplevel_collection = _tmp0_;
		for (toplevel_it = toplevel_collection; toplevel_it != NULL; toplevel_it = toplevel_it->next) {
			BudgieToplevel* _tmp1_;
			BudgieToplevel* toplevel = NULL;
			_tmp1_ = _g_object_ref0 ((BudgieToplevel*) toplevel_it->data);
			toplevel = _tmp1_;
			{
				BudgieToplevel* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp2_ = toplevel;
				_tmp3_ = budgie_toplevel_get_uuid (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strdup (_tmp4_);
				_vala_array_add1 (&toplevel_ids, &toplevel_ids_length1, &_toplevel_ids_size_, _tmp5_);
				_g_object_unref0 (toplevel);
			}
		}
		(toplevel_collection == NULL) ? NULL : (toplevel_collection = (_g_list_free__g_object_unref0_ (toplevel_collection), NULL));
	}
	_tmp6_ = toplevel_ids;
	_tmp6__length1 = toplevel_ids_length1;
	if (_tmp6_ != NULL) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = toplevel_ids;
		_tmp7__length1 = toplevel_ids_length1;
		{
			gchar** toplevel_id_collection = NULL;
			gint toplevel_id_collection_length1 = 0;
			gint _toplevel_id_collection_size_ = 0;
			gint toplevel_id_it = 0;
			toplevel_id_collection = _tmp7_;
			toplevel_id_collection_length1 = _tmp7__length1;
			for (toplevel_id_it = 0; toplevel_id_it < toplevel_id_collection_length1; toplevel_id_it = toplevel_id_it + 1) {
				gchar* _tmp8_;
				gchar* toplevel_id = NULL;
				_tmp8_ = g_strdup (toplevel_id_collection[toplevel_id_it]);
				toplevel_id = _tmp8_;
				{
					const gchar* _tmp9_;
					_tmp9_ = toplevel_id;
					budgie_desktop_manager_delete_panel ((BudgieDesktopManager*) self, _tmp9_);
					_g_free0 (toplevel_id);
				}
			}
		}
	}
	budgie_panel_manager_do_reset (self);
	toplevel_ids = (_vala_array_free (toplevel_ids, toplevel_ids_length1, (GDestroyNotify) g_free), NULL);
}

/**
* Initial setup, once we've owned the dbus name
* i.e. no risk of dying
*/
static void
_budgie_panel_manager_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                       gpointer self)
{
	budgie_panel_manager_on_monitors_changed ((BudgiePanelManager*) self);
}

static void
_budgie_panel_manager_on_monitors_changed_gdk_screen_size_changed (GdkScreen* _sender,
                                                                   gpointer self)
{
	budgie_panel_manager_on_monitors_changed ((BudgiePanelManager*) self);
}

static void
__lambda34_ (BudgiePanelManager* self)
{
	BudgieRavenPosition new_position = 0;
	GSettings* _tmp0_;
	_tmp0_ = self->priv->raven_settings;
	new_position = (BudgieRavenPosition) g_settings_get_enum (_tmp0_, BUDGIE_RAVEN_KEY_POSITION);
	if (new_position != self->priv->raven_position) {
		self->priv->raven_position = new_position;
		budgie_panel_manager_update_screen (self);
	}
}

static void
___lambda34__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda34_ ((BudgiePanelManager*) self);
}

static void
_budgie_panel_manager_on_settings_requested_budgie_raven_request_settings_ui (BudgieRaven* _sender,
                                                                              gpointer self)
{
	budgie_panel_manager_on_settings_requested ((BudgiePanelManager*) self);
}

static void
__lambda35_ (BudgiePanelManager* self,
             GObject* o,
             GAsyncResult* res)
{
	gboolean success = FALSE;
	g_return_if_fail (res != NULL);
	success = budgie_panel_manager_register_with_session_finish (self, res);
	if (!success) {
		g_message ("manager.vala:644: Failed to register with Session manager");
	}
}

static void
___lambda35__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda35_ ((BudgiePanelManager*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_panel_manager_do_setup (BudgiePanelManager* self)
{
	GdkScreen* scr = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkDisplay* dis = NULL;
	GdkScreen* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkScreen* _tmp10_;
	GdkScreen* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	GSettings* _tmp17_;
	gchar* _tmp18_;
	BudgieThemeManager* _tmp19_;
	BudgieRavenPluginManager* _tmp20_;
	BudgiePanelPluginManager* _tmp21_;
	BudgieRavenPluginManager* _tmp22_;
	BudgieRaven* _tmp23_;
	BudgieRaven* _tmp24_;
	BudgieRaven* _tmp25_;
	gint current_migration_level = 0;
	GSettings* _tmp26_;
	GSettings* _tmp28_;
	g_return_if_fail (self != NULL);
	if (self->priv->reset) {
		budgie_panel_manager_do_reset (self);
	}
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	scr = _tmp1_;
	_tmp2_ = scr;
	_tmp3_ = gdk_screen_get_display (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	dis = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GdkDisplay* _tmp7_;
				GdkDisplay* _tmp8_;
				GdkMonitor* _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = dis;
				if (!(i < gdk_display_get_n_monitors (_tmp7_))) {
					break;
				}
				_tmp8_ = dis;
				_tmp9_ = gdk_display_get_monitor (_tmp8_, i);
				if (gdk_monitor_is_primary (_tmp9_)) {
					self->priv->primary_monitor = i;
				}
			}
		}
	}
	_tmp10_ = scr;
	g_signal_connect_object (_tmp10_, "monitors-changed", (GCallback) _budgie_panel_manager_on_monitors_changed_gdk_screen_monitors_changed, self, 0);
	_tmp11_ = scr;
	g_signal_connect_object (_tmp11_, "size-changed", (GCallback) _budgie_panel_manager_on_monitors_changed_gdk_screen_size_changed, self, 0);
	_tmp12_ = g_settings_new (BUDGIE_ROOT_SCHEMA);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp12_;
	_tmp13_ = g_settings_new (BUDGIE_RAVEN_SCHEMA);
	_g_object_unref0 (self->priv->raven_settings);
	self->priv->raven_settings = _tmp13_;
	_tmp14_ = self->priv->raven_settings;
	self->priv->raven_position = (BudgieRavenPosition) g_settings_get_enum (_tmp14_, BUDGIE_RAVEN_KEY_POSITION);
	_tmp15_ = self->priv->raven_settings;
	_tmp16_ = g_strconcat ("changed::", BUDGIE_RAVEN_KEY_POSITION, NULL);
	g_signal_connect_object (_tmp15_, _tmp16_, (GCallback) ___lambda34__g_settings_changed, self, 0);
	_g_free0 (_tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_get_string (_tmp17_, BUDGIE_PANEL_KEY_LAYOUT);
	_g_free0 (self->priv->default_layout);
	self->priv->default_layout = _tmp18_;
	_tmp19_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp19_;
	_tmp20_ = budgie_raven_plugin_manager_new ();
	_budgie_raven_plugin_manager_unref0 (self->priv->raven_plugin_manager);
	self->priv->raven_plugin_manager = _tmp20_;
	_tmp21_ = budgie_panel_plugin_manager_new ();
	_budgie_panel_plugin_manager_unref0 (self->priv->panel_plugin_manager);
	self->priv->panel_plugin_manager = _tmp21_;
	_tmp22_ = self->priv->raven_plugin_manager;
	_tmp23_ = budgie_raven_new ((BudgieDesktopManager*) self, _tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->raven);
	self->priv->raven = _tmp23_;
	_tmp24_ = self->priv->raven;
	g_signal_connect_object (_tmp24_, "request-settings-ui", (GCallback) _budgie_panel_manager_on_settings_requested_budgie_raven_request_settings_ui, self, 0);
	wnck_set_client_type (WNCK_CLIENT_TYPE_PAGER);
	budgie_panel_manager_on_monitors_changed (self);
	_tmp25_ = self->priv->raven;
	budgie_raven_setup_dbus (_tmp25_);
	_tmp26_ = self->priv->settings;
	current_migration_level = g_settings_get_int (_tmp26_, BUDGIE_PANEL_KEY_MIGRATION);
	if (!budgie_panel_manager_load_panels (self)) {
		const gchar* _tmp27_;
		g_message ("manager.vala:628: Creating default panel layout");
		_tmp27_ = self->priv->default_layout;
		budgie_panel_manager_create_default (self, _tmp27_);
	} else {
		budgie_panel_manager_perform_migration (self, current_migration_level);
	}
	_tmp28_ = self->priv->settings;
	g_settings_set_int (_tmp28_, BUDGIE_PANEL_KEY_MIGRATION, BUDGIE_BUDGIE_MIGRATION_LEVEL);
	budgie_panel_manager_register_with_session (self, ___lambda35__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (dis);
	_g_object_unref0 (scr);
}

/**
* Attempts to perform the relevant migration operations by
* finding a migratable panel and calling its migratory function
*/
static void
budgie_panel_manager_perform_migration (BudgiePanelManager* self,
                                        gint current_migration_level)
{
	BudgiePanel* top = NULL;
	BudgiePanel* last = NULL;
	BudgiePanelPluginManager* _tmp0_;
	gchar* key = NULL;
	BudgiePanel* val = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	BudgiePanel* _tmp14_;
	BudgiePanel* _tmp17_;
	g_return_if_fail (self != NULL);
	top = NULL;
	last = NULL;
	if (current_migration_level >= BUDGIE_BUDGIE_MIGRATION_LEVEL) {
		_g_object_unref0 (last);
		_g_object_unref0 (top);
		return;
	}
	_tmp0_ = self->priv->panel_plugin_manager;
	if (_tmp0_->migrate_load_requirements_met) {
		g_message ("manager.vala:664: Budgie Migration skipped due to user meeting migrati" \
"on requirements");
		_g_object_unref0 (last);
		_g_object_unref0 (top);
		return;
	}
	g_message ("manager.vala:668: Budgie Migration initiated");
	key = NULL;
	val = NULL;
	_tmp1_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		gchar* _tmp5_;
		BudgiePanel* _tmp6_;
		BudgiePanel* _tmp7_;
		BudgiePanelPosition _tmp8_;
		BudgiePanelPosition _tmp9_;
		BudgiePanel* _tmp12_;
		BudgiePanel* _tmp13_;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		_g_free0 (key);
		_tmp5_ = g_strdup ((const gchar*) _tmp2_);
		key = _tmp5_;
		_g_object_unref0 (val);
		_tmp6_ = _g_object_ref0 ((BudgiePanel*) _tmp3_);
		val = _tmp6_;
		if (!_tmp4_) {
			break;
		}
		_tmp7_ = val;
		_tmp8_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == BUDGIE_PANEL_POSITION_TOP) {
			BudgiePanel* _tmp10_;
			BudgiePanel* _tmp11_;
			_tmp10_ = val;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (top);
			top = _tmp11_;
		}
		_tmp12_ = val;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (last);
		last = _tmp13_;
	}
	_tmp14_ = top;
	if (_tmp14_ != NULL) {
		BudgiePanel* _tmp15_;
		BudgiePanel* _tmp16_;
		_tmp15_ = top;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (last);
		last = _tmp16_;
	}
	_tmp17_ = last;
	budgie_panel_perform_migration (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BUDGIE_TYPE_PANEL, BudgiePanel), current_migration_level);
	_g_object_unref0 (val);
	_g_free0 (key);
	_g_object_unref0 (last);
	_g_object_unref0 (top);
}

static GList*
budgie_panel_manager_real_get_panel_plugins (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	BudgiePanelPluginManager* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->panel_plugin_manager;
	_tmp1_ = budgie_panel_plugin_manager_get_all_plugins (_tmp0_);
	result = _tmp1_;
	return result;
}

static GList*
budgie_panel_manager_real_get_raven_plugins (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	BudgieRavenPluginManager* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->raven_plugin_manager;
	_tmp1_ = budgie_raven_plugin_manager_get_all_plugins (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
budgie_panel_manager_real_rescan_panel_plugins (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	BudgiePanelPluginManager* _tmp0_;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->panel_plugin_manager;
	budgie_panel_plugin_manager_rescan_plugins (_tmp0_);
}

static void
budgie_panel_manager_real_rescan_raven_plugins (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	BudgieRavenPluginManager* _tmp0_;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->raven_plugin_manager;
	budgie_raven_plugin_manager_rescan_plugins (_tmp0_);
}

/**
* Find the next available position on the given monitor
*/
BudgiePanelPosition
budgie_panel_manager_get_first_position (BudgiePanelManager* self,
                                         gint monitor)
{
	GHashTable* _tmp0_;
	BudgieScreen* screen = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	BudgieScreen* _tmp3_;
	BudgieScreen* _tmp4_;
	BudgiePanelPosition result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->screens;
	if (!g_hash_table_contains (_tmp0_, (gpointer) ((gintptr) monitor))) {
		g_error ("manager.vala:710: No screen for monitor: %d - This should never happen" \
"!", monitor);
	}
	_tmp1_ = self->priv->screens;
	_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((gintptr) monitor));
	_tmp3_ = _g_object_ref0 ((BudgieScreen*) _tmp2_);
	screen = _tmp3_;
	_tmp4_ = screen;
	if ((_tmp4_->slots & BUDGIE_PANEL_POSITION_TOP) == 0) {
		result = BUDGIE_PANEL_POSITION_TOP;
		_g_object_unref0 (screen);
		return result;
	} else {
		BudgieScreen* _tmp5_;
		_tmp5_ = screen;
		if ((_tmp5_->slots & BUDGIE_PANEL_POSITION_BOTTOM) == 0) {
			result = BUDGIE_PANEL_POSITION_BOTTOM;
			_g_object_unref0 (screen);
			return result;
		} else {
			BudgieScreen* _tmp6_;
			_tmp6_ = screen;
			if ((_tmp6_->slots & BUDGIE_PANEL_POSITION_LEFT) == 0) {
				result = BUDGIE_PANEL_POSITION_LEFT;
				_g_object_unref0 (screen);
				return result;
			} else {
				BudgieScreen* _tmp7_;
				_tmp7_ = screen;
				if ((_tmp7_->slots & BUDGIE_PANEL_POSITION_RIGHT) == 0) {
					result = BUDGIE_PANEL_POSITION_RIGHT;
					_g_object_unref0 (screen);
					return result;
				} else {
					result = BUDGIE_PANEL_POSITION_NONE;
					_g_object_unref0 (screen);
					return result;
				}
			}
		}
	}
}

/**
* Determine how many slots are available
*/
static guint
budgie_panel_manager_real_slots_available (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	GHashTable* _tmp0_;
	guint result;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->panels;
	result = BUDGIE_MAX_SLOTS - g_hash_table_size (_tmp0_);
	return result;
}

/**
* Determine how many slots have been used
*/
static guint
budgie_panel_manager_real_slots_used (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	GHashTable* _tmp0_;
	guint result;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->panels;
	result = g_hash_table_size (_tmp0_);
	return result;
}

/**
* Load a panel by the given UUID, and optionally configure it
*/
static void
budgie_panel_manager_load_panel (BudgiePanelManager* self,
                                 const gchar* uuid,
                                 gboolean configure)
{
	GHashTable* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	BudgiePanelPosition position = 0U;
	BudgiePanelTransparency transparency = 0U;
	BudgieAutohidePolicy policy = 0U;
	gboolean dock_mode = FALSE;
	gboolean shadow_visible = FALSE;
	gint size = 0;
	gint spacing = 0;
	GSettings* settings = NULL;
	const gchar* _tmp2_;
	GSettings* _tmp3_;
	BudgiePanel* panel = NULL;
	BudgiePanelPluginManager* _tmp4_;
	GSettings* _tmp5_;
	BudgiePanel* _tmp6_;
	GHashTable* _tmp7_;
	gchar* _tmp8_;
	BudgiePanel* _tmp9_;
	BudgiePanel* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	BudgiePanel* _tmp17_;
	GSettings* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	if (g_hash_table_contains (_tmp0_, uuid)) {
		return;
	}
	_tmp1_ = budgie_panel_manager_create_panel_path (self, uuid);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_settings_new_with_path (BUDGIE_TOPLEVEL_SCHEMA, _tmp2_);
	settings = _tmp3_;
	_tmp4_ = self->priv->panel_plugin_manager;
	_tmp5_ = settings;
	_tmp6_ = budgie_panel_new (self, _tmp4_, uuid, _tmp5_);
	g_object_ref_sink (_tmp6_);
	panel = _tmp6_;
	_tmp7_ = self->priv->panels;
	_tmp8_ = g_strdup (uuid);
	_tmp9_ = panel;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	g_hash_table_insert (_tmp7_, _tmp8_, _tmp10_);
	if (!configure) {
		_g_object_unref0 (panel);
		_g_object_unref0 (settings);
		_g_free0 (path);
		return;
	}
	_tmp11_ = settings;
	position = (BudgiePanelPosition) g_settings_get_enum (_tmp11_, BUDGIE_PANEL_KEY_POSITION);
	_tmp12_ = settings;
	transparency = (BudgiePanelTransparency) g_settings_get_enum (_tmp12_, BUDGIE_PANEL_KEY_TRANSPARENCY);
	_tmp13_ = settings;
	policy = (BudgieAutohidePolicy) g_settings_get_enum (_tmp13_, BUDGIE_PANEL_KEY_AUTOHIDE);
	_tmp14_ = settings;
	dock_mode = g_settings_get_boolean (_tmp14_, BUDGIE_PANEL_KEY_DOCK_MODE);
	_tmp15_ = settings;
	shadow_visible = g_settings_get_boolean (_tmp15_, BUDGIE_PANEL_KEY_SHADOW);
	_tmp16_ = settings;
	size = g_settings_get_int (_tmp16_, BUDGIE_PANEL_KEY_SIZE);
	_tmp17_ = panel;
	budgie_toplevel_set_intended_size ((BudgieToplevel*) _tmp17_, (gint) size);
	_tmp18_ = settings;
	spacing = (gint) g_settings_get_int (_tmp18_, BUDGIE_PANEL_KEY_SPACING);
	budgie_panel_manager_show_panel (self, uuid, position, transparency, policy, dock_mode, shadow_visible, spacing);
	_g_object_unref0 (panel);
	_g_object_unref0 (settings);
	_g_free0 (path);
}

static void
budgie_panel_manager_show_panel (BudgiePanelManager* self,
                                 const gchar* uuid,
                                 BudgiePanelPosition position,
                                 BudgiePanelTransparency transparency,
                                 BudgieAutohidePolicy policy,
                                 gboolean dock_mode,
                                 gboolean shadow_visible,
                                 gint spacing)
{
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgieScreen* scr = NULL;
	BudgiePanel* _tmp3_;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	BudgieScreen* _tmp6_;
	BudgieScreen* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:784: Asked to show non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = self->priv->screens;
	_tmp5_ = g_hash_table_lookup (_tmp4_, (gpointer) ((gintptr) self->priv->primary_monitor));
	scr = (BudgieScreen*) _tmp5_;
	_tmp6_ = scr;
	_tmp7_ = scr;
	_tmp7_->slots = _tmp7_->slots | position;
	budgie_desktop_manager_set_placement ((BudgieDesktopManager*) self, uuid, position);
	budgie_desktop_manager_set_transparency ((BudgieDesktopManager*) self, uuid, transparency);
	budgie_desktop_manager_set_autohide ((BudgieDesktopManager*) self, uuid, policy);
	budgie_desktop_manager_set_dock_mode ((BudgieDesktopManager*) self, uuid, dock_mode);
	budgie_panel_manager_set_shadow (self, uuid, shadow_visible);
	budgie_desktop_manager_set_spacing ((BudgieDesktopManager*) self, uuid, spacing);
	_g_object_unref0 (panel);
}

/**
* Set size of the given panel
*/
static void
budgie_panel_manager_real_set_size (BudgieDesktopManager* base,
                                    const gchar* uuid,
                                    gint size)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgiePanel* _tmp3_;
	BudgiePanel* _tmp4_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:805: Asked to resize non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = panel;
	budgie_toplevel_set_intended_size ((BudgieToplevel*) _tmp4_, size);
	budgie_panel_manager_update_screen (self);
	_g_object_unref0 (panel);
}

/**
* Set spacing of the given panel
*/
static void
budgie_panel_manager_real_set_spacing (BudgieDesktopManager* base,
                                       const gchar* uuid,
                                       gint spacing)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgiePanel* _tmp3_;
	BudgiePanel* _tmp4_;
	BudgiePanel* _tmp5_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:820: Asked to resize non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = panel;
	budgie_toplevel_set_intended_spacing ((BudgieToplevel*) _tmp4_, spacing);
	_tmp5_ = panel;
	budgie_panel_update_spacing (_tmp5_);
	_g_object_unref0 (panel);
}

/**
* Enforce panel placement
*/
static void
budgie_panel_manager_real_set_placement (BudgieDesktopManager* base,
                                         const gchar* uuid,
                                         BudgiePanelPosition position)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	gchar* key = NULL;
	BudgiePanel* val = NULL;
	BudgiePanel* conflict = NULL;
	BudgiePanel* _tmp3_;
	BudgieScreen* area = NULL;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	BudgieScreen* _tmp6_;
	BudgiePanelPosition old = 0U;
	BudgiePanel* _tmp7_;
	BudgiePanelPosition _tmp8_;
	BudgiePanelPosition _tmp9_;
	GHashTableIter iter = {0};
	GHashTable* _tmp12_;
	BudgiePanel* _tmp23_;
	BudgiePanel* _tmp24_;
	BudgiePanel* _tmp42_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	key = NULL;
	val = NULL;
	conflict = NULL;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:838: Trying to move non-existent panel: %s", uuid);
		_g_object_unref0 (conflict);
		_g_object_unref0 (val);
		_g_free0 (key);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = self->priv->screens;
	_tmp5_ = g_hash_table_lookup (_tmp4_, (gpointer) ((gintptr) self->priv->primary_monitor));
	_tmp6_ = _g_object_ref0 ((BudgieScreen*) _tmp5_);
	area = _tmp6_;
	_tmp7_ = panel;
	_tmp8_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp7_);
	_tmp9_ = _tmp8_;
	old = _tmp9_;
	if (old == position) {
		GFlagsValue* _tmp10_;
		GFlagsValue* _tmp11_;
		_tmp10_ = g_flags_get_first_value (g_type_class_ref (budgie_panel_position_get_type ()), old);
		_tmp11_ = g_flags_get_first_value (g_type_class_ref (budgie_panel_position_get_type ()), position);
		g_warning ("manager.vala:846: Attempting to move panel to the same position it's a" \
"lready in: %s %s %s", uuid, (_tmp10_ != NULL) ? _tmp10_->value_name : NULL, (_tmp11_ != NULL) ? _tmp11_->value_name : NULL);
		_g_object_unref0 (area);
		_g_object_unref0 (conflict);
		_g_object_unref0 (val);
		_g_free0 (key);
		_g_object_unref0 (panel);
		return;
	}
	_tmp12_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp12_);
	while (TRUE) {
		gconstpointer _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		gboolean _tmp15_;
		gchar* _tmp16_;
		BudgiePanel* _tmp17_;
		BudgiePanel* _tmp18_;
		BudgiePanelPosition _tmp19_;
		BudgiePanelPosition _tmp20_;
		_tmp15_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp13_), (gpointer*) (&_tmp14_));
		_g_free0 (key);
		_tmp16_ = g_strdup ((const gchar*) _tmp13_);
		key = _tmp16_;
		_g_object_unref0 (val);
		_tmp17_ = _g_object_ref0 ((BudgiePanel*) _tmp14_);
		val = _tmp17_;
		if (!_tmp15_) {
			break;
		}
		_tmp18_ = val;
		_tmp19_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ == position) {
			BudgiePanel* _tmp21_;
			BudgiePanel* _tmp22_;
			_tmp21_ = val;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_g_object_unref0 (conflict);
			conflict = _tmp22_;
			break;
		}
	}
	_tmp23_ = panel;
	gtk_widget_hide ((GtkWidget*) _tmp23_);
	_tmp24_ = conflict;
	if (_tmp24_ != NULL) {
		BudgiePanel* _tmp25_;
		BudgiePanel* _tmp26_;
		BudgieScreen* _tmp27_;
		GdkRectangle _tmp28_;
		BudgiePanel* _tmp29_;
		BudgiePanel* _tmp30_;
		BudgiePanel* _tmp31_;
		BudgieScreen* _tmp32_;
		GdkRectangle _tmp33_;
		BudgiePanel* _tmp34_;
		_tmp25_ = conflict;
		gtk_widget_hide ((GtkWidget*) _tmp25_);
		_tmp26_ = conflict;
		_tmp27_ = area;
		_tmp28_ = _tmp27_->area;
		budgie_panel_update_geometry (_tmp26_, &_tmp28_, old, 0);
		_tmp29_ = conflict;
		gtk_widget_show ((GtkWidget*) _tmp29_);
		_tmp30_ = panel;
		gtk_widget_hide ((GtkWidget*) _tmp30_);
		_tmp31_ = panel;
		_tmp32_ = area;
		_tmp33_ = _tmp32_->area;
		budgie_panel_update_geometry (_tmp31_, &_tmp33_, position, 0);
		_tmp34_ = panel;
		gtk_widget_show ((GtkWidget*) _tmp34_);
	} else {
		BudgieScreen* _tmp35_;
		BudgieScreen* _tmp36_;
		BudgieScreen* _tmp37_;
		BudgieScreen* _tmp38_;
		BudgiePanel* _tmp39_;
		BudgieScreen* _tmp40_;
		GdkRectangle _tmp41_;
		_tmp35_ = area;
		_tmp36_ = area;
		_tmp36_->slots = _tmp36_->slots ^ old;
		_tmp37_ = area;
		_tmp38_ = area;
		_tmp38_->slots = _tmp38_->slots | position;
		_tmp39_ = panel;
		_tmp40_ = area;
		_tmp41_ = _tmp40_->area;
		budgie_panel_update_geometry (_tmp39_, &_tmp41_, position, 0);
	}
	budgie_panel_manager_update_screen (self);
	_tmp42_ = panel;
	gtk_widget_show ((GtkWidget*) _tmp42_);
	_g_object_unref0 (area);
	_g_object_unref0 (conflict);
	_g_object_unref0 (val);
	_g_free0 (key);
	_g_object_unref0 (panel);
}

/**
* Set panel transparency
*/
static void
budgie_panel_manager_real_set_transparency (BudgieDesktopManager* base,
                                            const gchar* uuid,
                                            BudgiePanelTransparency transparency)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgiePanel* _tmp3_;
	BudgiePanel* _tmp4_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:887: Trying to set transparency on non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = panel;
	budgie_panel_update_transparency (_tmp4_, transparency);
	_g_object_unref0 (panel);
}

static void
budgie_panel_manager_real_set_autohide (BudgieDesktopManager* base,
                                        const gchar* uuid,
                                        BudgieAutohidePolicy policy)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgiePanel* _tmp3_;
	BudgiePanel* _tmp4_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:899: Trying to set autohide on non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = panel;
	budgie_panel_set_autohide_policy (_tmp4_, policy);
	budgie_panel_manager_update_screen (self);
	_g_object_unref0 (panel);
}

/**
* Set panel dock mode
*/
static void
budgie_panel_manager_real_set_dock_mode (BudgieDesktopManager* base,
                                         const gchar* uuid,
                                         gboolean dock_mode)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgiePanel* _tmp3_;
	BudgiePanel* _tmp4_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:915: Trying to set dock mode on non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = panel;
	budgie_toplevel_set_dock_mode ((BudgieToplevel*) _tmp4_, dock_mode);
	budgie_panel_manager_update_screen (self);
	_g_object_unref0 (panel);
}

static void
budgie_panel_manager_set_shadow (BudgiePanelManager* self,
                                 const gchar* uuid,
                                 gboolean visible)
{
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgiePanel* _tmp3_;
	BudgiePanel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgiePanel*) _tmp1_);
	panel = _tmp2_;
	_tmp3_ = panel;
	if (_tmp3_ == NULL) {
		g_warning ("manager.vala:929: Trying to set dock mode on non-existent panel: %s", uuid);
		_g_object_unref0 (panel);
		return;
	}
	_tmp4_ = panel;
	budgie_panel_update_shadow (_tmp4_, visible);
	_g_object_unref0 (panel);
}

/**
* Force update geometry for all panels
*/
static void
budgie_panel_manager_update_screen (BudgiePanelManager* self)
{
	BudgieToplevel* top = NULL;
	BudgieToplevel* bottom = NULL;
	BudgieToplevel* right = NULL;
	BudgieToplevel* left = NULL;
	GdkRectangle raven_screen = {0};
	gchar* key = NULL;
	BudgiePanel* val = NULL;
	BudgieScreen* area = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgieScreen* _tmp2_;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_;
	GHashTableIter iter2 = {0};
	GHashTable* _tmp20_;
	gchar* key2 = NULL;
	BudgiePanel* val2 = NULL;
	BudgieScreen* _tmp65_;
	GdkRectangle _tmp66_;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	BudgieToplevel* _tmp69_;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	BudgieToplevel* _tmp84_;
	BudgieRaven* _tmp106_;
	GdkRectangle _tmp107_;
	g_return_if_fail (self != NULL);
	top = NULL;
	bottom = NULL;
	right = NULL;
	left = NULL;
	key = NULL;
	val = NULL;
	_tmp0_ = self->priv->screens;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) self->priv->primary_monitor));
	_tmp2_ = _g_object_ref0 ((BudgieScreen*) _tmp1_);
	area = _tmp2_;
	_tmp3_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp3_);
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_;
		gchar* _tmp7_;
		BudgiePanel* _tmp8_;
		BudgiePanel* _tmp9_;
		BudgiePanelPosition _tmp10_;
		BudgiePanelPosition _tmp11_;
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
		_g_free0 (key);
		_tmp7_ = g_strdup ((const gchar*) _tmp4_);
		key = _tmp7_;
		_g_object_unref0 (val);
		_tmp8_ = _g_object_ref0 ((BudgiePanel*) _tmp5_);
		val = _tmp8_;
		if (!_tmp6_) {
			break;
		}
		_tmp9_ = val;
		_tmp10_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp9_);
		_tmp11_ = _tmp10_;
		switch (_tmp11_) {
			case BUDGIE_PANEL_POSITION_TOP:
			{
				BudgiePanel* _tmp12_;
				BudgieToplevel* _tmp13_;
				_tmp12_ = val;
				_tmp13_ = _g_object_ref0 ((BudgieToplevel*) _tmp12_);
				_g_object_unref0 (top);
				top = _tmp13_;
				break;
			}
			case BUDGIE_PANEL_POSITION_BOTTOM:
			{
				BudgiePanel* _tmp14_;
				BudgieToplevel* _tmp15_;
				_tmp14_ = val;
				_tmp15_ = _g_object_ref0 ((BudgieToplevel*) _tmp14_);
				_g_object_unref0 (bottom);
				bottom = _tmp15_;
				break;
			}
			case BUDGIE_PANEL_POSITION_RIGHT:
			{
				BudgiePanel* _tmp16_;
				BudgieToplevel* _tmp17_;
				_tmp16_ = val;
				_tmp17_ = _g_object_ref0 ((BudgieToplevel*) _tmp16_);
				_g_object_unref0 (right);
				right = _tmp17_;
				break;
			}
			case BUDGIE_PANEL_POSITION_LEFT:
			{
				BudgiePanel* _tmp18_;
				BudgieToplevel* _tmp19_;
				_tmp18_ = val;
				_tmp19_ = _g_object_ref0 ((BudgieToplevel*) _tmp18_);
				_g_object_unref0 (left);
				left = _tmp19_;
				break;
			}
			default:
			{
				continue;
			}
		}
	}
	_tmp20_ = self->priv->panels;
	g_hash_table_iter_init (&iter2, _tmp20_);
	key2 = NULL;
	val2 = NULL;
	while (TRUE) {
		gconstpointer _tmp21_ = NULL;
		gconstpointer _tmp22_ = NULL;
		gboolean _tmp23_;
		gchar* _tmp24_;
		BudgiePanel* _tmp25_;
		BudgiePanel* _tmp26_;
		BudgiePanelPosition _tmp27_;
		BudgiePanelPosition _tmp28_;
		_tmp23_ = g_hash_table_iter_next (&iter2, (gpointer*) (&_tmp21_), (gpointer*) (&_tmp22_));
		_g_free0 (key2);
		_tmp24_ = g_strdup ((const gchar*) _tmp21_);
		key2 = _tmp24_;
		_g_object_unref0 (val2);
		_tmp25_ = _g_object_ref0 ((BudgiePanel*) _tmp22_);
		val2 = _tmp25_;
		if (!_tmp23_) {
			break;
		}
		_tmp26_ = val2;
		_tmp27_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp26_);
		_tmp28_ = _tmp27_;
		switch (_tmp28_) {
			case BUDGIE_PANEL_POSITION_LEFT:
			case BUDGIE_PANEL_POSITION_RIGHT:
			{
				GdkRectangle geom = {0};
				BudgieScreen* _tmp29_;
				GdkRectangle _tmp30_;
				BudgieScreen* _tmp31_;
				GdkRectangle _tmp32_;
				BudgieScreen* _tmp33_;
				GdkRectangle _tmp34_;
				BudgieScreen* _tmp35_;
				GdkRectangle _tmp36_;
				BudgieToplevel* _tmp37_;
				BudgieToplevel* _tmp44_;
				BudgiePanel* _tmp48_;
				GdkRectangle _tmp49_;
				BudgiePanel* _tmp50_;
				BudgiePanelPosition _tmp51_;
				BudgiePanelPosition _tmp52_;
				BudgiePanel* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				memset (&geom, 0, sizeof (GdkRectangle));
				_tmp29_ = area;
				_tmp30_ = _tmp29_->area;
				geom.x = _tmp30_.x;
				_tmp31_ = area;
				_tmp32_ = _tmp31_->area;
				geom.y = _tmp32_.y;
				_tmp33_ = area;
				_tmp34_ = _tmp33_->area;
				geom.width = _tmp34_.width;
				_tmp35_ = area;
				_tmp36_ = _tmp35_->area;
				geom.height = _tmp36_.height;
				_tmp37_ = top;
				if (budgie_panel_manager_is_panel_huggable (self, _tmp37_)) {
					BudgieToplevel* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					BudgieToplevel* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					_tmp38_ = top;
					_tmp39_ = budgie_toplevel_get_intended_size (_tmp38_);
					_tmp40_ = _tmp39_;
					geom.y = geom.y + _tmp40_;
					_tmp41_ = top;
					_tmp42_ = budgie_toplevel_get_intended_size (_tmp41_);
					_tmp43_ = _tmp42_;
					geom.height = geom.height - _tmp43_;
				}
				_tmp44_ = bottom;
				if (budgie_panel_manager_is_panel_huggable (self, _tmp44_)) {
					BudgieToplevel* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					_tmp45_ = bottom;
					_tmp46_ = budgie_toplevel_get_intended_size (_tmp45_);
					_tmp47_ = _tmp46_;
					geom.height = geom.height - _tmp47_;
				}
				_tmp48_ = val2;
				_tmp49_ = geom;
				_tmp50_ = val2;
				_tmp51_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = val2;
				_tmp54_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) _tmp53_);
				_tmp55_ = _tmp54_;
				budgie_panel_update_geometry (_tmp48_, &_tmp49_, _tmp52_, _tmp55_);
				break;
			}
			default:
			{
				BudgiePanel* _tmp56_;
				BudgieScreen* _tmp57_;
				GdkRectangle _tmp58_;
				BudgiePanel* _tmp59_;
				BudgiePanelPosition _tmp60_;
				BudgiePanelPosition _tmp61_;
				BudgiePanel* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				_tmp56_ = val2;
				_tmp57_ = area;
				_tmp58_ = _tmp57_->area;
				_tmp59_ = val2;
				_tmp60_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = val2;
				_tmp63_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) _tmp62_);
				_tmp64_ = _tmp63_;
				budgie_panel_update_geometry (_tmp56_, &_tmp58_, _tmp61_, _tmp64_);
				break;
			}
		}
	}
	_tmp65_ = area;
	_tmp66_ = _tmp65_->area;
	raven_screen = _tmp66_;
	_tmp69_ = top;
	if (_tmp69_ != NULL) {
		BudgieToplevel* _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp72_;
		_tmp70_ = top;
		_tmp71_ = budgie_toplevel_get_dock_mode (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp68_ = !_tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		BudgieToplevel* _tmp73_;
		BudgieAutohidePolicy _tmp74_;
		BudgieAutohidePolicy _tmp75_;
		_tmp73_ = top;
		_tmp74_ = budgie_toplevel_get_autohide (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp67_ = _tmp75_ == BUDGIE_AUTOHIDE_POLICY_NONE;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		BudgieToplevel* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		BudgieToplevel* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		_tmp76_ = top;
		_tmp77_ = budgie_toplevel_get_intended_size (_tmp76_);
		_tmp78_ = _tmp77_;
		raven_screen.y = raven_screen.y + _tmp78_;
		_tmp79_ = top;
		_tmp80_ = budgie_toplevel_get_intended_size (_tmp79_);
		_tmp81_ = _tmp80_;
		raven_screen.height = raven_screen.height - _tmp81_;
	}
	_tmp84_ = bottom;
	if (_tmp84_ != NULL) {
		BudgieToplevel* _tmp85_;
		gboolean _tmp86_;
		gboolean _tmp87_;
		_tmp85_ = bottom;
		_tmp86_ = budgie_toplevel_get_dock_mode (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp83_ = !_tmp87_;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		BudgieToplevel* _tmp88_;
		BudgieAutohidePolicy _tmp89_;
		BudgieAutohidePolicy _tmp90_;
		_tmp88_ = bottom;
		_tmp89_ = budgie_toplevel_get_autohide (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp82_ = _tmp90_ == BUDGIE_AUTOHIDE_POLICY_NONE;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		BudgieToplevel* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		_tmp91_ = bottom;
		_tmp92_ = budgie_toplevel_get_intended_size (_tmp91_);
		_tmp93_ = _tmp92_;
		raven_screen.height = raven_screen.height - _tmp93_;
	}
	switch (self->priv->raven_position) {
		case BUDGIE_RAVEN_POSITION_LEFT:
		{
			BudgieRaven* _tmp94_;
			BudgieToplevel* _tmp95_;
			_tmp94_ = self->priv->raven;
			budgie_raven_set_screen_edge (_tmp94_, GTK_POS_LEFT);
			_tmp95_ = left;
			if (_tmp95_ != NULL) {
				BudgieToplevel* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				_tmp96_ = left;
				_tmp97_ = budgie_toplevel_get_intended_size (_tmp96_);
				_tmp98_ = _tmp97_;
				raven_screen.x = raven_screen.x + _tmp98_;
			}
			break;
		}
		case BUDGIE_RAVEN_POSITION_RIGHT:
		{
			BudgieRaven* _tmp99_;
			BudgieToplevel* _tmp100_;
			_tmp99_ = self->priv->raven;
			budgie_raven_set_screen_edge (_tmp99_, GTK_POS_RIGHT);
			_tmp100_ = right;
			if (_tmp100_ != NULL) {
				BudgieToplevel* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				_tmp101_ = right;
				_tmp102_ = budgie_toplevel_get_intended_size (_tmp101_);
				_tmp103_ = _tmp102_;
				raven_screen.width = raven_screen.width - _tmp103_;
			}
			break;
		}
		default:
		case BUDGIE_RAVEN_POSITION_AUTOMATIC:
		{
			BudgieToplevel* _tmp104_;
			BudgieToplevel* _tmp105_;
			_tmp104_ = left;
			_tmp105_ = right;
			budgie_panel_manager_set_raven_position (self, _tmp104_, _tmp105_, &raven_screen);
			break;
		}
	}
	_tmp106_ = self->priv->raven;
	_tmp107_ = raven_screen;
	budgie_raven_update_geometry (_tmp106_, &_tmp107_);
	g_signal_emit_by_name ((BudgieDesktopManager*) self, "panels-changed");
	_g_object_unref0 (val2);
	_g_free0 (key2);
	_g_object_unref0 (area);
	_g_object_unref0 (val);
	_g_free0 (key);
	_g_object_unref0 (left);
	_g_object_unref0 (right);
	_g_object_unref0 (bottom);
	_g_object_unref0 (top);
}

static gboolean
budgie_panel_manager_is_panel_huggable (BudgiePanelManager* self,
                                        BudgieToplevel* panel)
{
	BudgieAutohidePolicy _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (panel == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = budgie_toplevel_get_autohide (panel);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUDGIE_AUTOHIDE_POLICY_NONE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = budgie_toplevel_get_dock_mode (panel);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

/**
 * Use the current panel layouts to figure out Raven's position.
 *
 * This function sets which side of the screen Raven should be on,
 * as well as Raven's position or width (if it's on the right side).
 */
static void
budgie_panel_manager_set_raven_position (BudgiePanelManager* self,
                                         BudgieToplevel* left,
                                         BudgieToplevel* right,
                                         GdkRectangle* raven_screen)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (raven_screen != NULL);
	if (left != NULL) {
		_tmp0_ = right == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (budgie_panel_manager_is_panel_huggable (self, left)) {
			BudgieRaven* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			_tmp1_ = self->priv->raven;
			budgie_raven_set_screen_edge (_tmp1_, GTK_POS_LEFT);
			_tmp2_ = budgie_toplevel_get_intended_size (left);
			_tmp3_ = _tmp2_;
			(*raven_screen).x = (*raven_screen).x + _tmp3_;
		} else {
			BudgieRaven* _tmp4_;
			_tmp4_ = self->priv->raven;
			budgie_raven_set_screen_edge (_tmp4_, GTK_POS_RIGHT);
		}
	} else {
		gboolean _tmp5_ = FALSE;
		if (right != NULL) {
			_tmp5_ = left == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			if (budgie_panel_manager_is_panel_huggable (self, right)) {
				gint _tmp6_;
				gint _tmp7_;
				BudgieRaven* _tmp8_;
				_tmp6_ = budgie_toplevel_get_intended_size (right);
				_tmp7_ = _tmp6_;
				(*raven_screen).width = (*raven_screen).width - _tmp7_;
				_tmp8_ = self->priv->raven;
				budgie_raven_set_screen_edge (_tmp8_, GTK_POS_RIGHT);
			} else {
				BudgieRaven* _tmp9_;
				_tmp9_ = self->priv->raven;
				budgie_raven_set_screen_edge (_tmp9_, GTK_POS_LEFT);
			}
		} else {
			gboolean _tmp10_ = FALSE;
			if (budgie_panel_manager_is_panel_huggable (self, left)) {
				_tmp10_ = !budgie_panel_manager_is_panel_huggable (self, right);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				BudgieRaven* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				_tmp11_ = self->priv->raven;
				budgie_raven_set_screen_edge (_tmp11_, GTK_POS_LEFT);
				_tmp12_ = budgie_toplevel_get_intended_size (left);
				_tmp13_ = _tmp12_;
				(*raven_screen).x = (*raven_screen).x + _tmp13_;
			} else {
				gboolean _tmp14_ = FALSE;
				if (budgie_panel_manager_is_panel_huggable (self, right)) {
					_tmp14_ = !budgie_panel_manager_is_panel_huggable (self, left);
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gint _tmp15_;
					gint _tmp16_;
					BudgieRaven* _tmp17_;
					_tmp15_ = budgie_toplevel_get_intended_size (right);
					_tmp16_ = _tmp15_;
					(*raven_screen).width = (*raven_screen).width - _tmp16_;
					_tmp17_ = self->priv->raven;
					budgie_raven_set_screen_edge (_tmp17_, GTK_POS_RIGHT);
				} else {
					BudgieRaven* _tmp18_;
					_tmp18_ = self->priv->raven;
					budgie_raven_set_screen_edge (_tmp18_, GTK_POS_RIGHT);
					if (right != NULL) {
						gint _tmp19_;
						gint _tmp20_;
						_tmp19_ = budgie_toplevel_get_intended_size (right);
						_tmp20_ = _tmp19_;
						(*raven_screen).width = (*raven_screen).width - _tmp20_;
					}
				}
			}
		}
	}
}

/**
* Load all known panels
*/
static gboolean
budgie_panel_manager_load_panels (BudgiePanelManager* self)
{
	gchar** panels = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint panels_length1;
	gint _panels_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, BUDGIE_ROOT_KEY_PANELS);
	panels = _tmp2_;
	panels_length1 = _vala_array_length (_tmp1_);
	_panels_size_ = panels_length1;
	_tmp3_ = panels;
	_tmp3__length1 = panels_length1;
	if (_tmp3__length1 == 0) {
		result = FALSE;
		panels = (_vala_array_free (panels, panels_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = panels;
	_tmp4__length1 = panels_length1;
	{
		gchar** uuid_collection = NULL;
		gint uuid_collection_length1 = 0;
		gint _uuid_collection_size_ = 0;
		gint uuid_it = 0;
		uuid_collection = _tmp4_;
		uuid_collection_length1 = _tmp4__length1;
		for (uuid_it = 0; uuid_it < uuid_collection_length1; uuid_it = uuid_it + 1) {
			gchar* _tmp5_;
			gchar* uuid = NULL;
			_tmp5_ = g_strdup (uuid_collection[uuid_it]);
			uuid = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = uuid;
				budgie_panel_manager_load_panel (self, _tmp6_, TRUE);
				_g_free0 (uuid);
			}
		}
	}
	budgie_panel_manager_update_screen (self);
	result = TRUE;
	panels = (_vala_array_free (panels, panels_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
budgie_panel_manager_real_create_new_panel (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	self = (BudgiePanelManager*) base;
	budgie_panel_manager_create_panel (self, NULL, NULL);
}

static void
budgie_panel_manager_real_delete_panel (BudgieDesktopManager* base,
                                        const gchar* uuid)
{
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgiePanel* _tmp2_;
	BudgieScreen* area = NULL;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	BudgieScreen* _tmp5_;
	BudgieScreen* _tmp6_;
	BudgieScreen* _tmp7_;
	BudgiePanel* _tmp8_;
	BudgiePanelPosition _tmp9_;
	BudgiePanelPosition _tmp10_;
	gchar* spath = NULL;
	BudgiePanel* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	BudgiePanel* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	BudgiePanel* _tmp19_;
	BudgiePanel* _tmp20_;
	GSettings* psettings = NULL;
	const gchar* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	if (budgie_desktop_manager_slots_used ((BudgieDesktopManager*) self) <= ((guint) 1)) {
		g_warning ("manager.vala:1115: Asked to delete final panel");
		return;
	}
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	panel = (BudgiePanel*) _tmp1_;
	_tmp2_ = panel;
	if (_tmp2_ == NULL) {
		g_warning ("manager.vala:1121: Asked to delete non-existent panel: %s", uuid);
		return;
	}
	_tmp3_ = self->priv->screens;
	_tmp4_ = g_hash_table_lookup (_tmp3_, (gpointer) ((gintptr) self->priv->primary_monitor));
	_tmp5_ = _g_object_ref0 ((BudgieScreen*) _tmp4_);
	area = _tmp5_;
	_tmp6_ = area;
	_tmp7_ = area;
	_tmp8_ = panel;
	_tmp9_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp7_->slots = _tmp7_->slots ^ _tmp10_;
	g_signal_emit_by_name ((BudgieDesktopManager*) self, "panel-deleted", uuid);
	_tmp11_ = panel;
	_tmp12_ = budgie_toplevel_get_uuid ((BudgieToplevel*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = budgie_panel_manager_create_panel_path (self, _tmp13_);
	spath = _tmp14_;
	_tmp15_ = self->priv->panels;
	_tmp16_ = panel;
	_tmp17_ = budgie_toplevel_get_uuid ((BudgieToplevel*) _tmp16_);
	_tmp18_ = _tmp17_;
	g_hash_table_steal (_tmp15_, _tmp18_);
	budgie_panel_manager_set_panels (self);
	budgie_panel_manager_update_screen (self);
	_tmp19_ = panel;
	budgie_panel_destroy_children (_tmp19_);
	_tmp20_ = panel;
	gtk_widget_destroy ((GtkWidget*) _tmp20_);
	_tmp21_ = spath;
	_tmp22_ = g_settings_new_with_path (BUDGIE_TOPLEVEL_SCHEMA, _tmp21_);
	psettings = _tmp22_;
	_tmp23_ = psettings;
	budgie_panel_manager_reset_dconf_path (self, _tmp23_);
	_g_object_unref0 (psettings);
	_g_free0 (spath);
	_g_object_unref0 (area);
}

static void
budgie_panel_manager_create_panel (BudgiePanelManager* self,
                                   const gchar* name,
                                   GKeyFile* new_defaults)
{
	BudgiePanelPosition position = 0U;
	BudgiePanelTransparency transparency = 0U;
	BudgieAutohidePolicy policy = 0U;
	gboolean dock_mode = FALSE;
	gboolean shadow_visible = FALSE;
	gint size = 0;
	gint spacing = 0;
	gboolean _tmp0_ = FALSE;
	gchar* uuid = NULL;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp41_;
	const gchar* _tmp42_;
	gconstpointer _tmp43_;
	BudgiePanel* _tmp44_;
	BudgiePanel* _tmp45_;
	const gchar* _tmp46_;
	BudgiePanel* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	position = BUDGIE_PANEL_POSITION_NONE;
	transparency = BUDGIE_PANEL_TRANSPARENCY_NONE;
	policy = BUDGIE_AUTOHIDE_POLICY_NONE;
	dock_mode = FALSE;
	shadow_visible = TRUE;
	size = -1;
	spacing = 2;
	if (budgie_desktop_manager_slots_available ((BudgieDesktopManager*) self) < ((guint) 1)) {
		g_warning ("manager.vala:1151: Asked to create panel with no slots available");
		return;
	}
	if (name != NULL) {
		_tmp0_ = new_defaults != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			gboolean _tmp1_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp23_ = FALSE;
			_tmp1_ = g_key_file_has_key (new_defaults, name, "Position", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp1_) {
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GQuark _tmp7_ = 0U;
				static GQuark _tmp6_label0 = 0;
				static GQuark _tmp6_label1 = 0;
				static GQuark _tmp6_label2 = 0;
				_tmp3_ = g_key_file_get_string (new_defaults, name, "Position", &_inner_error0_);
				_tmp2_ = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp4_ = g_utf8_strdown (_tmp2_, (gssize) -1);
				_tmp5_ = _tmp4_;
				_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
				g_free (_tmp5_);
				if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("top")))) {
					switch (0) {
						default:
						{
							position = BUDGIE_PANEL_POSITION_TOP;
							break;
						}
					}
				} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("left")))) {
					switch (0) {
						default:
						{
							position = BUDGIE_PANEL_POSITION_LEFT;
							break;
						}
					}
				} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("right")))) {
					switch (0) {
						default:
						{
							position = BUDGIE_PANEL_POSITION_RIGHT;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							position = BUDGIE_PANEL_POSITION_BOTTOM;
							break;
						}
					}
				}
				_g_free0 (_tmp2_);
			}
			_tmp8_ = g_key_file_has_key (new_defaults, name, "Size", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp8_) {
				gint _tmp9_ = 0;
				_tmp9_ = g_key_file_get_integer (new_defaults, name, "Size", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				size = _tmp9_;
			}
			_tmp10_ = g_key_file_has_key (new_defaults, name, "Spacing", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp10_) {
				gint _tmp11_ = 0;
				_tmp11_ = g_key_file_get_integer (new_defaults, name, "Spacing", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				spacing = _tmp11_;
			}
			_tmp12_ = g_key_file_has_key (new_defaults, name, "Dock", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp12_) {
				gboolean _tmp13_ = FALSE;
				_tmp13_ = g_key_file_get_boolean (new_defaults, name, "Dock", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				dock_mode = _tmp13_;
			}
			_tmp14_ = g_key_file_has_key (new_defaults, name, "Shadow", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp14_) {
				gboolean _tmp15_ = FALSE;
				_tmp15_ = g_key_file_get_boolean (new_defaults, name, "Shadow", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				shadow_visible = _tmp15_;
			}
			_tmp16_ = g_key_file_has_key (new_defaults, name, "Autohide", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp16_) {
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GQuark _tmp22_ = 0U;
				static GQuark _tmp21_label0 = 0;
				static GQuark _tmp21_label1 = 0;
				_tmp18_ = g_key_file_get_string (new_defaults, name, "Autohide", &_inner_error0_);
				_tmp17_ = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp19_ = g_utf8_strdown (_tmp17_, (gssize) -1);
				_tmp20_ = _tmp19_;
				_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
				g_free (_tmp20_);
				if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("automatic")))) {
					switch (0) {
						default:
						{
							policy = BUDGIE_AUTOHIDE_POLICY_AUTOMATIC;
							break;
						}
					}
				} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("intelligent")))) {
					switch (0) {
						default:
						{
							policy = BUDGIE_AUTOHIDE_POLICY_INTELLIGENT;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							policy = BUDGIE_AUTOHIDE_POLICY_NONE;
							break;
						}
					}
				}
				_g_free0 (_tmp17_);
			}
			_tmp23_ = g_key_file_has_key (new_defaults, name, "Transparency", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_tmp23_) {
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GQuark _tmp29_ = 0U;
				static GQuark _tmp28_label0 = 0;
				static GQuark _tmp28_label1 = 0;
				_tmp25_ = g_key_file_get_string (new_defaults, name, "Transparency", &_inner_error0_);
				_tmp24_ = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp26_ = g_utf8_strdown (_tmp24_, (gssize) -1);
				_tmp27_ = _tmp26_;
				_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
				g_free (_tmp27_);
				if (_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("always")))) {
					switch (0) {
						default:
						{
							transparency = BUDGIE_PANEL_TRANSPARENCY_ALWAYS;
							break;
						}
					}
				} else if (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("dynamic")))) {
					switch (0) {
						default:
						{
							transparency = BUDGIE_PANEL_TRANSPARENCY_DYNAMIC;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							transparency = BUDGIE_PANEL_TRANSPARENCY_NONE;
							break;
						}
					}
				}
				_g_free0 (_tmp24_);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp30_;
			const gchar* _tmp31_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp30_ = e;
			_tmp31_ = _tmp30_->message;
			g_warning ("manager.vala:1213: create_panel(): %s", _tmp31_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		position = budgie_panel_manager_get_first_position (self, self->priv->primary_monitor);
		if (position == BUDGIE_PANEL_POSITION_NONE) {
			g_critical ("manager.vala:1218: No slots available, this should not happen");
			return;
		}
	}
	_tmp32_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
	uuid = _tmp32_;
	_tmp33_ = uuid;
	budgie_panel_manager_load_panel (self, _tmp33_, FALSE);
	budgie_panel_manager_set_panels (self);
	_tmp34_ = uuid;
	budgie_panel_manager_show_panel (self, _tmp34_, position, transparency, policy, dock_mode, shadow_visible, spacing);
	if (new_defaults == NULL) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = name == NULL;
	}
	if (_tmp35_) {
		const gchar* _tmp36_;
		GHashTable* _tmp37_;
		const gchar* _tmp38_;
		gconstpointer _tmp39_;
		_tmp36_ = uuid;
		_tmp37_ = self->priv->panels;
		_tmp38_ = uuid;
		_tmp39_ = g_hash_table_lookup (_tmp37_, _tmp38_);
		g_signal_emit_by_name ((BudgieDesktopManager*) self, "panel-added", _tmp36_, (BudgieToplevel*) ((BudgiePanel*) _tmp39_));
		_g_free0 (uuid);
		return;
	}
	if (size > 0) {
		const gchar* _tmp40_;
		_tmp40_ = uuid;
		budgie_desktop_manager_set_size ((BudgieDesktopManager*) self, _tmp40_, size);
	}
	_tmp41_ = self->priv->panels;
	_tmp42_ = uuid;
	_tmp43_ = g_hash_table_lookup (_tmp41_, _tmp42_);
	_tmp44_ = _g_object_ref0 ((BudgiePanel*) _tmp43_);
	panel = _tmp44_;
	_tmp45_ = panel;
	budgie_panel_create_default_layout (_tmp45_, name, new_defaults);
	_tmp46_ = uuid;
	_tmp47_ = panel;
	g_signal_emit_by_name ((BudgieDesktopManager*) self, "panel-added", _tmp46_, (BudgieToplevel*) _tmp47_);
	_g_object_unref0 (panel);
	_g_free0 (uuid);
}

/**
* Update our known panels
*/
static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
budgie_panel_manager_set_panels (BudgiePanelManager* self)
{
	BudgiePanel* panel = NULL;
	const gchar* key = NULL;
	gchar** keys = NULL;
	gint keys_length1;
	gint _keys_size_;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GSettings* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	keys = NULL;
	keys_length1 = 0;
	_keys_size_ = keys_length1;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = (const gchar*) _tmp1_;
		panel = (BudgiePanel*) _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = key;
		_tmp5_ = g_strdup (_tmp4_);
		_vala_array_add2 (&keys, &keys_length1, &_keys_size_, _tmp5_);
	}
	_tmp6_ = self->priv->settings;
	_tmp7_ = keys;
	_tmp7__length1 = keys_length1;
	g_settings_set_strv (_tmp6_, BUDGIE_ROOT_KEY_PANELS, _tmp7_);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
}

static void
budgie_panel_manager_create_default (BudgiePanelManager* self,
                                     const gchar* layout_name)
{
	gchar** panel_dirs = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint panel_dirs_length1;
	gint _panel_dirs_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout_name != NULL);
	if (g_strcmp0 (layout_name, "default") == 0) {
		budgie_panel_manager_create_system_default (self);
		return;
	}
	_tmp0_ = g_strdup (BUDGIE_CONFDIR);
	_tmp1_ = g_strdup (BUDGIE_DATADIR);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	panel_dirs = _tmp2_;
	panel_dirs_length1 = 2;
	_panel_dirs_size_ = panel_dirs_length1;
	_tmp3_ = panel_dirs;
	_tmp3__length1 = panel_dirs_length1;
	{
		gchar** panel_dir_collection = NULL;
		gint panel_dir_collection_length1 = 0;
		gint _panel_dir_collection_size_ = 0;
		gint panel_dir_it = 0;
		panel_dir_collection = _tmp3_;
		panel_dir_collection_length1 = _tmp3__length1;
		for (panel_dir_it = 0; panel_dir_it < panel_dir_collection_length1; panel_dir_it = panel_dir_it + 1) {
			gchar* _tmp4_;
			gchar* panel_dir = NULL;
			_tmp4_ = g_strdup (panel_dir_collection[panel_dir_it]);
			panel_dir = _tmp4_;
			{
				gchar* path = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = panel_dir;
				_tmp6_ = g_strdup_printf ("file://%s/budgie-desktop/layouts/%s.layout", _tmp5_, layout_name);
				path = _tmp6_;
				_tmp7_ = path;
				if (budgie_panel_manager_load_default_from_config (self, _tmp7_)) {
					_g_free0 (path);
					_g_free0 (panel_dir);
					panel_dirs = (_vala_array_free (panel_dirs, panel_dirs_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
				_g_free0 (path);
				_g_free0 (panel_dir);
			}
		}
	}
	g_warning ("manager.vala:1279: Failed to find layout '%s'", layout_name);
	budgie_panel_manager_load_default_from_config (self, "resource:///com/solus-project/budgie/panel/panel.ini");
	panel_dirs = (_vala_array_free (panel_dirs, panel_dirs_length1, (GDestroyNotify) g_free), NULL);
}

/**
* Create new default panel layout
*/
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
budgie_panel_manager_create_system_default (BudgiePanelManager* self)
{
	gchar** system_configs = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint system_configs_length1;
	gint _system_configs_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = string_to_string (BUDGIE_CONFDIR);
	_tmp1_ = g_strconcat ("file://", _tmp0_, "/budgie-desktop/panel.ini", NULL);
	_tmp2_ = string_to_string (BUDGIE_DATADIR);
	_tmp3_ = g_strconcat ("file://", _tmp2_, "/budgie-desktop/panel.ini", NULL);
	_tmp4_ = g_strdup ("");
	_tmp5_ = g_new0 (gchar*, 3 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp3_;
	_tmp5_[2] = _tmp4_;
	system_configs = _tmp5_;
	system_configs_length1 = 3;
	_system_configs_size_ = system_configs_length1;
	_tmp6_ = system_configs;
	_tmp6__length1 = system_configs_length1;
	{
		gchar** filepath_collection = NULL;
		gint filepath_collection_length1 = 0;
		gint _filepath_collection_size_ = 0;
		gint filepath_it = 0;
		filepath_collection = _tmp6_;
		filepath_collection_length1 = _tmp6__length1;
		for (filepath_it = 0; filepath_it < filepath_collection_length1; filepath_it = filepath_it + 1) {
			gchar* _tmp7_;
			gchar* filepath = NULL;
			_tmp7_ = g_strdup (filepath_collection[filepath_it]);
			filepath = _tmp7_;
			{
				const gchar* _tmp8_;
				_tmp8_ = filepath;
				if (budgie_panel_manager_load_default_from_config (self, _tmp8_)) {
					_g_free0 (filepath);
					system_configs = (_vala_array_free (system_configs, system_configs_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
				_g_free0 (filepath);
			}
		}
	}
	budgie_panel_manager_load_default_from_config (self, "resource:///com/solus-project/budgie/panel/panel.ini");
	system_configs = (_vala_array_free (system_configs, system_configs_length1, (GDestroyNotify) g_free), NULL);
}

/**
* Attempt to load the configuration from the given URL
*/
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
budgie_panel_manager_load_default_from_config (BudgiePanelManager* self,
                                               const gchar* uri)
{
	GFile* f = NULL;
	GKeyFile* config_file = NULL;
	GKeyFile* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gchar* line = NULL;
	BudgiePanelPosition pos = 0U;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	f = NULL;
	_tmp0_ = g_key_file_new ();
	config_file = _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	line = NULL;
	{
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp7_;
		GKeyFile* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		GString* _tmp18_;
		_tmp2_ = g_file_new_for_uri (uri);
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		if (!g_file_query_exists (_tmp3_, NULL)) {
			result = FALSE;
			_g_free0 (line);
			_g_string_free0 (builder);
			_g_key_file_unref0 (config_file);
			_g_object_unref0 (f);
			return result;
		}
		_tmp5_ = f;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		dis = _tmp7_;
		while (TRUE) {
			gchar* _tmp8_ = NULL;
			GDataInputStream* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			GString* _tmp13_;
			const gchar* _tmp14_;
			_tmp9_ = dis;
			_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp4_);
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (line);
			line = _tmp11_;
			_tmp12_ = line;
			if (!(_tmp12_ != NULL)) {
				_g_free0 (_tmp8_);
				break;
			}
			_tmp13_ = builder;
			_tmp14_ = line;
			g_string_append_printf (_tmp13_, "%s\n", _tmp14_);
			_g_free0 (_tmp8_);
		}
		_tmp15_ = config_file;
		_tmp16_ = builder;
		_tmp17_ = _tmp16_->str;
		_tmp18_ = builder;
		g_key_file_load_from_data (_tmp15_, _tmp17_, (gsize) _tmp18_->len, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp4_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("manager.vala:1333: Failed to load default config: %s", _tmp20_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	{
		gboolean _tmp22_ = FALSE;
		GKeyFile* _tmp23_;
		gchar** panels = NULL;
		GKeyFile* _tmp24_;
		gsize _tmp25_ = 0;
		gchar** _tmp26_;
		gint panels_length1;
		gint _panels_size_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp23_ = config_file;
		_tmp22_ = g_key_file_has_key (_tmp23_, "Panels", "Panels", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		if (!_tmp22_) {
			g_warning ("manager.vala:1339: Config is missing required Panels section");
			result = FALSE;
			_g_free0 (line);
			_g_string_free0 (builder);
			_g_key_file_unref0 (config_file);
			_g_object_unref0 (f);
			return result;
		}
		_tmp24_ = config_file;
		_tmp26_ = g_key_file_get_string_list (_tmp24_, "Panels", "Panels", &_tmp25_, &_inner_error0_);
		panels = _tmp26_;
		panels_length1 = _tmp25_;
		_panels_size_ = panels_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp27_ = panels;
		_tmp27__length1 = panels_length1;
		{
			gchar** panel_collection = NULL;
			gint panel_collection_length1 = 0;
			gint _panel_collection_size_ = 0;
			gint panel_it = 0;
			panel_collection = _tmp27_;
			panel_collection_length1 = _tmp27__length1;
			for (panel_it = 0; panel_it < panel_collection_length1; panel_it = panel_it + 1) {
				gchar* _tmp28_;
				gchar* panel = NULL;
				_tmp28_ = g_strdup (panel_collection[panel_it]);
				panel = _tmp28_;
				{
					const gchar* _tmp29_;
					gchar* _tmp30_;
					GKeyFile* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp34_;
					GKeyFile* _tmp35_;
					_tmp29_ = panel;
					_tmp30_ = string_strip (_tmp29_);
					_g_free0 (panel);
					panel = _tmp30_;
					pos = BUDGIE_PANEL_POSITION_TOP;
					_tmp31_ = config_file;
					_tmp32_ = panel;
					if (!g_key_file_has_group (_tmp31_, _tmp32_)) {
						const gchar* _tmp33_;
						_tmp33_ = panel;
						g_warning ("manager.vala:1350: Missing Panel config: %s", _tmp33_);
						_g_free0 (panel);
						continue;
					}
					_tmp34_ = panel;
					_tmp35_ = config_file;
					budgie_panel_manager_create_panel (self, _tmp34_, _tmp35_);
					_g_free0 (panel);
				}
			}
		}
		panels = (_vala_array_free (panels, panels_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("manager.vala:1356: Error configuring panels!");
		budgie_panel_manager_do_live_reset (self);
		result = FALSE;
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp36_ = FALSE;
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp36_;
	}
	result = TRUE;
	_g_free0 (line);
	_g_string_free0 (builder);
	_g_key_file_unref0 (config_file);
	_g_object_unref0 (f);
	return result;
}

static void
budgie_panel_manager_on_name_lost (BudgiePanelManager* self,
                                   GDBusConnection* conn,
                                   const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	if (self->priv->setup) {
		g_message ("manager.vala:1365: Replaced existing budgie-panel");
	} else {
		g_message ("manager.vala:1367: Another panel is already running. Use --replace to " \
"replace it");
	}
	gtk_main_quit ();
}

static void
_budgie_panel_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self)
{
	budgie_panel_manager_on_bus_acquired ((BudgiePanelManager*) self, connection);
}

static void
_budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                    const gchar* name,
                                                                    gpointer self)
{
	budgie_panel_manager_on_name_acquired ((BudgiePanelManager*) self, connection, name);
}

static void
_budgie_panel_manager_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection,
                                                            const gchar* name,
                                                            gpointer self)
{
	budgie_panel_manager_on_name_lost ((BudgiePanelManager*) self, connection, name);
}

void
budgie_panel_manager_serve (BudgiePanelManager* self,
                            gboolean replace)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_DBUS_NAME, flags, (GClosure*) ((_budgie_panel_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_panel_manager_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_panel_manager_on_name_lost_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_panel_manager_on_name_lost_gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

static GList*
budgie_panel_manager_real_get_panels (BudgieDesktopManager* base)
{
	BudgiePanelManager * self;
	GList* list = NULL;
	const gchar* key = NULL;
	BudgiePanel* panel = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GList* result;
	self = (BudgiePanelManager*) base;
	list = NULL;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BudgiePanel* _tmp4_;
		BudgieToplevel* _tmp5_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = (const gchar*) _tmp1_;
		panel = (BudgiePanel*) _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = panel;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel));
		list = g_list_append (list, _tmp5_);
	}
	result = list;
	return result;
}

static void
budgie_panel_manager_on_settings_requested (BudgiePanelManager* self)
{
	g_return_if_fail (self != NULL);
	budgie_panel_manager_open_settings (self);
}

/**
* Open up the settings window on screen
*/
static void
___lambda26_ (BudgiePanelManager* self)
{
	_g_object_unref0 (self->priv->settings_window);
	self->priv->settings_window = NULL;
}

static void
____lambda26__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda26_ ((BudgiePanelManager*) self);
}

static gboolean
__lambda12_ (BudgiePanelManager* self)
{
	BudgieSettingsWindow* _tmp0_;
	BudgieSettingsWindow* _tmp9_;
	BudgieSettingsWindow* _tmp10_;
	GdkWindow* window = NULL;
	BudgieSettingsWindow* _tmp11_;
	GdkWindow* _tmp12_;
	GdkWindow* _tmp13_;
	GdkWindow* _tmp14_;
	gboolean result;
	_tmp0_ = self->priv->settings_window;
	if (_tmp0_ == NULL) {
		BudgieSettingsWindow* _tmp1_;
		BudgieSettingsWindow* _tmp2_;
		GList* _tmp3_;
		_tmp1_ = budgie_settings_window_new ((BudgieDesktopManager*) self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->settings_window);
		self->priv->settings_window = _tmp1_;
		_tmp2_ = self->priv->settings_window;
		g_signal_connect_object ((GtkWidget*) _tmp2_, "destroy", (GCallback) ____lambda26__gtk_widget_destroy, self, 0);
		_tmp3_ = budgie_desktop_manager_get_panels ((BudgieDesktopManager*) self);
		{
			GList* panel_collection = NULL;
			GList* panel_it = NULL;
			panel_collection = _tmp3_;
			for (panel_it = panel_collection; panel_it != NULL; panel_it = panel_it->next) {
				BudgieToplevel* _tmp4_;
				BudgieToplevel* panel = NULL;
				_tmp4_ = _g_object_ref0 ((BudgieToplevel*) panel_it->data);
				panel = _tmp4_;
				{
					BudgieToplevel* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					BudgieToplevel* _tmp8_;
					_tmp5_ = panel;
					_tmp6_ = budgie_toplevel_get_uuid (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = panel;
					g_signal_emit_by_name ((BudgieDesktopManager*) self, "panel-added", _tmp7_, _tmp8_);
					_g_object_unref0 (panel);
				}
			}
			(panel_collection == NULL) ? NULL : (panel_collection = (_g_list_free__g_object_unref0_ (panel_collection), NULL));
		}
	}
	_tmp9_ = self->priv->settings_window;
	gtk_window_present ((GtkWindow*) _tmp9_);
	_tmp10_ = self->priv->settings_window;
	gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->settings_window;
	_tmp12_ = gtk_widget_get_window ((GtkWidget*) _tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	window = _tmp13_;
	_tmp14_ = window;
	if (_tmp14_ != NULL) {
		GdkWindow* _tmp15_;
		_tmp15_ = window;
		gdk_window_focus (_tmp15_, (guint32) GDK_CURRENT_TIME);
	}
	result = FALSE;
	_g_object_unref0 (window);
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((BudgiePanelManager*) self);
	return result;
}

void
budgie_panel_manager_open_settings (BudgiePanelManager* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

static void
budgie_panel_manager_class_init (BudgiePanelManagerClass * klass,
                                 gpointer klass_data)
{
	budgie_panel_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgiePanelManager_private_offset);
	((BudgieDesktopManagerClass *) klass)->get_panel_plugins = (GList* (*) (BudgieDesktopManager*)) budgie_panel_manager_real_get_panel_plugins;
	((BudgieDesktopManagerClass *) klass)->get_raven_plugins = (GList* (*) (BudgieDesktopManager*)) budgie_panel_manager_real_get_raven_plugins;
	((BudgieDesktopManagerClass *) klass)->rescan_panel_plugins = (void (*) (BudgieDesktopManager*)) budgie_panel_manager_real_rescan_panel_plugins;
	((BudgieDesktopManagerClass *) klass)->rescan_raven_plugins = (void (*) (BudgieDesktopManager*)) budgie_panel_manager_real_rescan_raven_plugins;
	((BudgieDesktopManagerClass *) klass)->slots_available = (guint (*) (BudgieDesktopManager*)) budgie_panel_manager_real_slots_available;
	((BudgieDesktopManagerClass *) klass)->slots_used = (guint (*) (BudgieDesktopManager*)) budgie_panel_manager_real_slots_used;
	((BudgieDesktopManagerClass *) klass)->set_size = (void (*) (BudgieDesktopManager*, const gchar*, gint)) budgie_panel_manager_real_set_size;
	((BudgieDesktopManagerClass *) klass)->set_spacing = (void (*) (BudgieDesktopManager*, const gchar*, gint)) budgie_panel_manager_real_set_spacing;
	((BudgieDesktopManagerClass *) klass)->set_placement = (void (*) (BudgieDesktopManager*, const gchar*, BudgiePanelPosition)) budgie_panel_manager_real_set_placement;
	((BudgieDesktopManagerClass *) klass)->set_transparency = (void (*) (BudgieDesktopManager*, const gchar*, BudgiePanelTransparency)) budgie_panel_manager_real_set_transparency;
	((BudgieDesktopManagerClass *) klass)->set_autohide = (void (*) (BudgieDesktopManager*, const gchar*, BudgieAutohidePolicy)) budgie_panel_manager_real_set_autohide;
	((BudgieDesktopManagerClass *) klass)->set_dock_mode = (void (*) (BudgieDesktopManager*, const gchar*, gboolean)) budgie_panel_manager_real_set_dock_mode;
	((BudgieDesktopManagerClass *) klass)->create_new_panel = (void (*) (BudgieDesktopManager*)) budgie_panel_manager_real_create_new_panel;
	((BudgieDesktopManagerClass *) klass)->delete_panel = (void (*) (BudgieDesktopManager*, const gchar*)) budgie_panel_manager_real_delete_panel;
	((BudgieDesktopManagerClass *) klass)->get_panels = (GList* (*) (BudgieDesktopManager*)) budgie_panel_manager_real_get_panels;
	G_OBJECT_CLASS (klass)->finalize = budgie_panel_manager_finalize;
}

static void
budgie_panel_manager_instance_init (BudgiePanelManager * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_panel_manager_get_instance_private (self);
	self->priv->setup = FALSE;
	self->priv->reset = FALSE;
	self->priv->primary_monitor = 0;
	self->priv->raven = NULL;
	self->priv->raven_plugin_manager = NULL;
	self->priv->panel_plugin_manager = NULL;
	self->priv->settings_window = NULL;
	_tmp0_ = g_strdup ("default");
	self->priv->default_layout = _tmp0_;
}

static void
budgie_panel_manager_finalize (GObject * obj)
{
	BudgiePanelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManager);
	_budgie_panel_manager_iface_unref0 (self->priv->iface);
	_g_object_unref0 (self->priv->sclient);
	_g_hash_table_unref0 (self->priv->screens);
	_g_hash_table_unref0 (self->priv->panels);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->raven_settings);
	_g_object_unref0 (self->priv->raven);
	_budgie_raven_plugin_manager_unref0 (self->priv->raven_plugin_manager);
	_budgie_panel_plugin_manager_unref0 (self->priv->panel_plugin_manager);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->settings_window);
	_g_object_unref0 (self->priv->wnck_screen);
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (g_list_free (self->priv->window_list), NULL));
	_g_free0 (self->priv->default_layout);
	G_OBJECT_CLASS (budgie_panel_manager_parent_class)->finalize (obj);
}

static GType
budgie_panel_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanelManager), 0, (GInstanceInitFunc) budgie_panel_manager_instance_init, NULL };
	GType budgie_panel_manager_type_id;
	budgie_panel_manager_type_id = g_type_register_static (BUDGIE_TYPE_DESKTOP_MANAGER, "BudgiePanelManager", &g_define_type_info, 0);
	BudgiePanelManager_private_offset = g_type_add_instance_private (budgie_panel_manager_type_id, sizeof (BudgiePanelManagerPrivate));
	return budgie_panel_manager_type_id;
}

GType
budgie_panel_manager_get_type (void)
{
	static volatile gsize budgie_panel_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_manager_type_id__once)) {
		GType budgie_panel_manager_type_id;
		budgie_panel_manager_type_id = budgie_panel_manager_get_type_once ();
		g_once_init_leave (&budgie_panel_manager_type_id__once, budgie_panel_manager_type_id);
	}
	return budgie_panel_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

