// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/plugin_curation.proto

package registryv1alpha1

import (
	v1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/image/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	pluginpb "google.golang.org/protobuf/types/pluginpb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// CuratedPluginVisibility defines the visibility options available
// for Curated Plugins.
type CuratedPluginVisibility int32

const (
	CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_UNSPECIFIED CuratedPluginVisibility = 0
	CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_PUBLIC      CuratedPluginVisibility = 1
	CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_PRIVATE     CuratedPluginVisibility = 2
)

// Enum value maps for CuratedPluginVisibility.
var (
	CuratedPluginVisibility_name = map[int32]string{
		0: "CURATED_PLUGIN_VISIBILITY_UNSPECIFIED",
		1: "CURATED_PLUGIN_VISIBILITY_PUBLIC",
		2: "CURATED_PLUGIN_VISIBILITY_PRIVATE",
	}
	CuratedPluginVisibility_value = map[string]int32{
		"CURATED_PLUGIN_VISIBILITY_UNSPECIFIED": 0,
		"CURATED_PLUGIN_VISIBILITY_PUBLIC":      1,
		"CURATED_PLUGIN_VISIBILITY_PRIVATE":     2,
	}
)

func (x CuratedPluginVisibility) Enum() *CuratedPluginVisibility {
	p := new(CuratedPluginVisibility)
	*p = x
	return p
}

func (x CuratedPluginVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CuratedPluginVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[0].Descriptor()
}

func (CuratedPluginVisibility) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[0]
}

func (x CuratedPluginVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The supported plugin registries for curated plugins.
type PluginRegistryType int32

const (
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED PluginRegistryType = 0
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_GO          PluginRegistryType = 1
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_NPM         PluginRegistryType = 2
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_MAVEN       PluginRegistryType = 3
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_SWIFT       PluginRegistryType = 4
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_PYTHON      PluginRegistryType = 5
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_CARGO       PluginRegistryType = 7
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_NUGET       PluginRegistryType = 8
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_CMAKE       PluginRegistryType = 9
)

// Enum value maps for PluginRegistryType.
var (
	PluginRegistryType_name = map[int32]string{
		0: "PLUGIN_REGISTRY_TYPE_UNSPECIFIED",
		1: "PLUGIN_REGISTRY_TYPE_GO",
		2: "PLUGIN_REGISTRY_TYPE_NPM",
		3: "PLUGIN_REGISTRY_TYPE_MAVEN",
		4: "PLUGIN_REGISTRY_TYPE_SWIFT",
		5: "PLUGIN_REGISTRY_TYPE_PYTHON",
		7: "PLUGIN_REGISTRY_TYPE_CARGO",
		8: "PLUGIN_REGISTRY_TYPE_NUGET",
		9: "PLUGIN_REGISTRY_TYPE_CMAKE",
	}
	PluginRegistryType_value = map[string]int32{
		"PLUGIN_REGISTRY_TYPE_UNSPECIFIED": 0,
		"PLUGIN_REGISTRY_TYPE_GO":          1,
		"PLUGIN_REGISTRY_TYPE_NPM":         2,
		"PLUGIN_REGISTRY_TYPE_MAVEN":       3,
		"PLUGIN_REGISTRY_TYPE_SWIFT":       4,
		"PLUGIN_REGISTRY_TYPE_PYTHON":      5,
		"PLUGIN_REGISTRY_TYPE_CARGO":       7,
		"PLUGIN_REGISTRY_TYPE_NUGET":       8,
		"PLUGIN_REGISTRY_TYPE_CMAKE":       9,
	}
)

func (x PluginRegistryType) Enum() *PluginRegistryType {
	p := new(PluginRegistryType)
	*p = x
	return p
}

func (x PluginRegistryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginRegistryType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[1].Descriptor()
}

func (PluginRegistryType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[1]
}

func (x PluginRegistryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// PluginLanguage is used to specify the output languages a plugin supports.
type PluginLanguage int32

const (
	PluginLanguage_PLUGIN_LANGUAGE_UNSPECIFIED PluginLanguage = 0
	PluginLanguage_PLUGIN_LANGUAGE_GO          PluginLanguage = 1
	PluginLanguage_PLUGIN_LANGUAGE_JAVASCRIPT  PluginLanguage = 2
	PluginLanguage_PLUGIN_LANGUAGE_TYPESCRIPT  PluginLanguage = 3
	PluginLanguage_PLUGIN_LANGUAGE_SWIFT       PluginLanguage = 4
	PluginLanguage_PLUGIN_LANGUAGE_CPP         PluginLanguage = 5
	PluginLanguage_PLUGIN_LANGUAGE_JAVA        PluginLanguage = 6
	PluginLanguage_PLUGIN_LANGUAGE_DART        PluginLanguage = 7
	PluginLanguage_PLUGIN_LANGUAGE_RUST        PluginLanguage = 8
	PluginLanguage_PLUGIN_LANGUAGE_PYTHON      PluginLanguage = 9
	PluginLanguage_PLUGIN_LANGUAGE_RUBY        PluginLanguage = 10
	PluginLanguage_PLUGIN_LANGUAGE_KOTLIN      PluginLanguage = 11
	PluginLanguage_PLUGIN_LANGUAGE_OBJECTIVE_C PluginLanguage = 12
	PluginLanguage_PLUGIN_LANGUAGE_PHP         PluginLanguage = 13
	PluginLanguage_PLUGIN_LANGUAGE_CSHARP      PluginLanguage = 14
	PluginLanguage_PLUGIN_LANGUAGE_SCALA       PluginLanguage = 15
	PluginLanguage_PLUGIN_LANGUAGE_C           PluginLanguage = 16
)

// Enum value maps for PluginLanguage.
var (
	PluginLanguage_name = map[int32]string{
		0:  "PLUGIN_LANGUAGE_UNSPECIFIED",
		1:  "PLUGIN_LANGUAGE_GO",
		2:  "PLUGIN_LANGUAGE_JAVASCRIPT",
		3:  "PLUGIN_LANGUAGE_TYPESCRIPT",
		4:  "PLUGIN_LANGUAGE_SWIFT",
		5:  "PLUGIN_LANGUAGE_CPP",
		6:  "PLUGIN_LANGUAGE_JAVA",
		7:  "PLUGIN_LANGUAGE_DART",
		8:  "PLUGIN_LANGUAGE_RUST",
		9:  "PLUGIN_LANGUAGE_PYTHON",
		10: "PLUGIN_LANGUAGE_RUBY",
		11: "PLUGIN_LANGUAGE_KOTLIN",
		12: "PLUGIN_LANGUAGE_OBJECTIVE_C",
		13: "PLUGIN_LANGUAGE_PHP",
		14: "PLUGIN_LANGUAGE_CSHARP",
		15: "PLUGIN_LANGUAGE_SCALA",
		16: "PLUGIN_LANGUAGE_C",
	}
	PluginLanguage_value = map[string]int32{
		"PLUGIN_LANGUAGE_UNSPECIFIED": 0,
		"PLUGIN_LANGUAGE_GO":          1,
		"PLUGIN_LANGUAGE_JAVASCRIPT":  2,
		"PLUGIN_LANGUAGE_TYPESCRIPT":  3,
		"PLUGIN_LANGUAGE_SWIFT":       4,
		"PLUGIN_LANGUAGE_CPP":         5,
		"PLUGIN_LANGUAGE_JAVA":        6,
		"PLUGIN_LANGUAGE_DART":        7,
		"PLUGIN_LANGUAGE_RUST":        8,
		"PLUGIN_LANGUAGE_PYTHON":      9,
		"PLUGIN_LANGUAGE_RUBY":        10,
		"PLUGIN_LANGUAGE_KOTLIN":      11,
		"PLUGIN_LANGUAGE_OBJECTIVE_C": 12,
		"PLUGIN_LANGUAGE_PHP":         13,
		"PLUGIN_LANGUAGE_CSHARP":      14,
		"PLUGIN_LANGUAGE_SCALA":       15,
		"PLUGIN_LANGUAGE_C":           16,
	}
)

func (x PluginLanguage) Enum() *PluginLanguage {
	p := new(PluginLanguage)
	*p = x
	return p
}

func (x PluginLanguage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginLanguage) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[2].Descriptor()
}

func (PluginLanguage) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[2]
}

func (x PluginLanguage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// NPMImportStyle is used to specify the import style the plugin supports.
type NPMImportStyle int32

const (
	NPMImportStyle_NPM_IMPORT_STYLE_UNSPECIFIED NPMImportStyle = 0
	NPMImportStyle_NPM_IMPORT_STYLE_MODULE      NPMImportStyle = 1
	NPMImportStyle_NPM_IMPORT_STYLE_COMMONJS    NPMImportStyle = 2
)

// Enum value maps for NPMImportStyle.
var (
	NPMImportStyle_name = map[int32]string{
		0: "NPM_IMPORT_STYLE_UNSPECIFIED",
		1: "NPM_IMPORT_STYLE_MODULE",
		2: "NPM_IMPORT_STYLE_COMMONJS",
	}
	NPMImportStyle_value = map[string]int32{
		"NPM_IMPORT_STYLE_UNSPECIFIED": 0,
		"NPM_IMPORT_STYLE_MODULE":      1,
		"NPM_IMPORT_STYLE_COMMONJS":    2,
	}
)

func (x NPMImportStyle) Enum() *NPMImportStyle {
	p := new(NPMImportStyle)
	*p = x
	return p
}

func (x NPMImportStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NPMImportStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[3].Descriptor()
}

func (NPMImportStyle) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[3]
}

func (x NPMImportStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// SwiftPlatformType is used to specify the platform type for a Swift plugins minimum compatible version.
type SwiftPlatformType int32

const (
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_UNSPECIFIED SwiftPlatformType = 0
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_MACOS       SwiftPlatformType = 1
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_IOS         SwiftPlatformType = 2
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_WATCHOS     SwiftPlatformType = 3
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_TVOS        SwiftPlatformType = 4
)

// Enum value maps for SwiftPlatformType.
var (
	SwiftPlatformType_name = map[int32]string{
		0: "SWIFT_PLATFORM_TYPE_UNSPECIFIED",
		1: "SWIFT_PLATFORM_TYPE_MACOS",
		2: "SWIFT_PLATFORM_TYPE_IOS",
		3: "SWIFT_PLATFORM_TYPE_WATCHOS",
		4: "SWIFT_PLATFORM_TYPE_TVOS",
	}
	SwiftPlatformType_value = map[string]int32{
		"SWIFT_PLATFORM_TYPE_UNSPECIFIED": 0,
		"SWIFT_PLATFORM_TYPE_MACOS":       1,
		"SWIFT_PLATFORM_TYPE_IOS":         2,
		"SWIFT_PLATFORM_TYPE_WATCHOS":     3,
		"SWIFT_PLATFORM_TYPE_TVOS":        4,
	}
)

func (x SwiftPlatformType) Enum() *SwiftPlatformType {
	p := new(SwiftPlatformType)
	*p = x
	return p
}

func (x SwiftPlatformType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SwiftPlatformType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[4].Descriptor()
}

func (SwiftPlatformType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[4]
}

func (x SwiftPlatformType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// PythonPackageType is used to specify the package type for a Python Generated SDK.
type PythonPackageType int32

const (
	PythonPackageType_PYTHON_PACKAGE_TYPE_UNSPECIFIED PythonPackageType = 0
	// Regular Python package, containing Python runtime code (`.py` files).
	PythonPackageType_PYTHON_PACKAGE_TYPE_RUNTIME PythonPackageType = 1
	// Stub-only package, containing only `.pyi` files.
	// Ref: https://peps.python.org/pep-0561/#stub-only-packages
	PythonPackageType_PYTHON_PACKAGE_TYPE_STUB_ONLY PythonPackageType = 2
)

// Enum value maps for PythonPackageType.
var (
	PythonPackageType_name = map[int32]string{
		0: "PYTHON_PACKAGE_TYPE_UNSPECIFIED",
		1: "PYTHON_PACKAGE_TYPE_RUNTIME",
		2: "PYTHON_PACKAGE_TYPE_STUB_ONLY",
	}
	PythonPackageType_value = map[string]int32{
		"PYTHON_PACKAGE_TYPE_UNSPECIFIED": 0,
		"PYTHON_PACKAGE_TYPE_RUNTIME":     1,
		"PYTHON_PACKAGE_TYPE_STUB_ONLY":   2,
	}
)

func (x PythonPackageType) Enum() *PythonPackageType {
	p := new(PythonPackageType)
	*p = x
	return p
}

func (x PythonPackageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PythonPackageType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[5].Descriptor()
}

func (PythonPackageType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[5]
}

func (x PythonPackageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// DotnetTargetFramework specifies the target framework for dotnet plugins.
// This is not meant to be an exhaustive list - most plugins should target a
// netstandard version.
// Reference: https://learn.microsoft.com/en-us/dotnet/standard/frameworks
type DotnetTargetFramework int32

const (
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_UNSPECIFIED     DotnetTargetFramework = 0
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0 DotnetTargetFramework = 1
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1 DotnetTargetFramework = 2
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2 DotnetTargetFramework = 3
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3 DotnetTargetFramework = 4
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4 DotnetTargetFramework = 5
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5 DotnetTargetFramework = 6
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6 DotnetTargetFramework = 7
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0 DotnetTargetFramework = 8
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1 DotnetTargetFramework = 9
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_5_0         DotnetTargetFramework = 10
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_6_0         DotnetTargetFramework = 11
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_7_0         DotnetTargetFramework = 12
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_8_0         DotnetTargetFramework = 13
)

// Enum value maps for DotnetTargetFramework.
var (
	DotnetTargetFramework_name = map[int32]string{
		0:  "DOTNET_TARGET_FRAMEWORK_UNSPECIFIED",
		1:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0",
		2:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1",
		3:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2",
		4:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3",
		5:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4",
		6:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5",
		7:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6",
		8:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0",
		9:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1",
		10: "DOTNET_TARGET_FRAMEWORK_NET_5_0",
		11: "DOTNET_TARGET_FRAMEWORK_NET_6_0",
		12: "DOTNET_TARGET_FRAMEWORK_NET_7_0",
		13: "DOTNET_TARGET_FRAMEWORK_NET_8_0",
	}
	DotnetTargetFramework_value = map[string]int32{
		"DOTNET_TARGET_FRAMEWORK_UNSPECIFIED":     0,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0": 1,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1": 2,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2": 3,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3": 4,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4": 5,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5": 6,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6": 7,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0": 8,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1": 9,
		"DOTNET_TARGET_FRAMEWORK_NET_5_0":         10,
		"DOTNET_TARGET_FRAMEWORK_NET_6_0":         11,
		"DOTNET_TARGET_FRAMEWORK_NET_7_0":         12,
		"DOTNET_TARGET_FRAMEWORK_NET_8_0":         13,
	}
)

func (x DotnetTargetFramework) Enum() *DotnetTargetFramework {
	p := new(DotnetTargetFramework)
	*p = x
	return p
}

func (x DotnetTargetFramework) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DotnetTargetFramework) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[6].Descriptor()
}

func (DotnetTargetFramework) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[6]
}

func (x DotnetTargetFramework) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// GoConfig is the configuration for a Go plugin.
type GoConfig struct {
	state                       protoimpl.MessageState      `protogen:"opaque.v1"`
	xxx_hidden_RuntimeLibraries *[]*GoConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	xxx_hidden_MinimumVersion   string                      `protobuf:"bytes,2,opt,name=minimum_version,json=minimumVersion,proto3"`
	xxx_hidden_BasePlugin       string                      `protobuf:"bytes,3,opt,name=base_plugin,json=basePlugin,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *GoConfig) Reset() {
	*x = GoConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoConfig) ProtoMessage() {}

func (x *GoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GoConfig) GetRuntimeLibraries() []*GoConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *GoConfig) GetMinimumVersion() string {
	if x != nil {
		return x.xxx_hidden_MinimumVersion
	}
	return ""
}

func (x *GoConfig) GetBasePlugin() string {
	if x != nil {
		return x.xxx_hidden_BasePlugin
	}
	return ""
}

func (x *GoConfig) SetRuntimeLibraries(v []*GoConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

func (x *GoConfig) SetMinimumVersion(v string) {
	x.xxx_hidden_MinimumVersion = v
}

func (x *GoConfig) SetBasePlugin(v string) {
	x.xxx_hidden_BasePlugin = v
}

type GoConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*GoConfig_RuntimeLibrary
	// The minimum Go version required by the plugin.
	MinimumVersion string
	// Optionally specifies an alternate base plugin like "remote/org/go-multi" instead of the default
	// "remote/protocolbuffers/go". If provided, the name must match one of the plugin dependencies in
	// the top-level deps field.
	//
	// This affects how imports are resolved - the specified plugin's import path will be used as the
	// base path for all generated code, replacing the default protocolbuffers/go import paths. Used
	// when depending on non-default BSR plugins.
	BasePlugin string
}

func (b0 GoConfig_builder) Build() *GoConfig {
	m0 := &GoConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	x.xxx_hidden_MinimumVersion = b.MinimumVersion
	x.xxx_hidden_BasePlugin = b.BasePlugin
	return m0
}

// NPMConfig is the configuration for a JavaScript NPM plugin.
type NPMConfig struct {
	state                              protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_RuntimeLibraries        *[]*NPMConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	xxx_hidden_RewriteImportPathSuffix string                       `protobuf:"bytes,2,opt,name=rewrite_import_path_suffix,json=rewriteImportPathSuffix,proto3"`
	xxx_hidden_ImportStyle             NPMImportStyle               `protobuf:"varint,3,opt,name=import_style,json=importStyle,proto3,enum=buf.alpha.registry.v1alpha1.NPMImportStyle"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *NPMConfig) Reset() {
	*x = NPMConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NPMConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NPMConfig) ProtoMessage() {}

func (x *NPMConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *NPMConfig) GetRuntimeLibraries() []*NPMConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *NPMConfig) GetRewriteImportPathSuffix() string {
	if x != nil {
		return x.xxx_hidden_RewriteImportPathSuffix
	}
	return ""
}

func (x *NPMConfig) GetImportStyle() NPMImportStyle {
	if x != nil {
		return x.xxx_hidden_ImportStyle
	}
	return NPMImportStyle_NPM_IMPORT_STYLE_UNSPECIFIED
}

func (x *NPMConfig) SetRuntimeLibraries(v []*NPMConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

func (x *NPMConfig) SetRewriteImportPathSuffix(v string) {
	x.xxx_hidden_RewriteImportPathSuffix = v
}

func (x *NPMConfig) SetImportStyle(v NPMImportStyle) {
	x.xxx_hidden_ImportStyle = v
}

type NPMConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*NPMConfig_RuntimeLibrary
	// Optionally define a configuration for rewriting import paths, a feature mainly
	// used for remote code generation in the BSR npm registry, which makes it possible
	// to serve the output of a BSR module and a plugin in an individual package.
	//
	// All plugins based on @bufbuild/protoplugin support the option "rewrite_imports".
	// Setting this value, i.e. "connectweb.js" or "pb.js", informs the BSR npm registry
	// that the plugin supports import rewrites with the given import suffix.
	RewriteImportPathSuffix string
	// The import style used for the "type" field in the package.json file.
	// This exists to support legacy plugins that require "commonjs" support.
	ImportStyle NPMImportStyle
}

func (b0 NPMConfig_builder) Build() *NPMConfig {
	m0 := &NPMConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	x.xxx_hidden_RewriteImportPathSuffix = b.RewriteImportPathSuffix
	x.xxx_hidden_ImportStyle = b.ImportStyle
	return m0
}

// MavenConfig is the configuration for a Maven plugin.
type MavenConfig struct {
	state                         protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_RuntimeLibraries   *[]*MavenConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	xxx_hidden_Compiler           *MavenConfig_CompilerConfig    `protobuf:"bytes,2,opt,name=compiler,proto3"`
	xxx_hidden_AdditionalRuntimes *[]*MavenConfig_RuntimeConfig  `protobuf:"bytes,3,rep,name=additional_runtimes,json=additionalRuntimes,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *MavenConfig) Reset() {
	*x = MavenConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig) ProtoMessage() {}

func (x *MavenConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MavenConfig) GetRuntimeLibraries() []*MavenConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *MavenConfig) GetCompiler() *MavenConfig_CompilerConfig {
	if x != nil {
		return x.xxx_hidden_Compiler
	}
	return nil
}

func (x *MavenConfig) GetAdditionalRuntimes() []*MavenConfig_RuntimeConfig {
	if x != nil {
		if x.xxx_hidden_AdditionalRuntimes != nil {
			return *x.xxx_hidden_AdditionalRuntimes
		}
	}
	return nil
}

func (x *MavenConfig) SetRuntimeLibraries(v []*MavenConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

func (x *MavenConfig) SetCompiler(v *MavenConfig_CompilerConfig) {
	x.xxx_hidden_Compiler = v
}

func (x *MavenConfig) SetAdditionalRuntimes(v []*MavenConfig_RuntimeConfig) {
	x.xxx_hidden_AdditionalRuntimes = &v
}

func (x *MavenConfig) HasCompiler() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Compiler != nil
}

func (x *MavenConfig) ClearCompiler() {
	x.xxx_hidden_Compiler = nil
}

type MavenConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*MavenConfig_RuntimeLibrary
	// Settings for the Java/Kotlin compiler used to compile the generated code.
	Compiler *MavenConfig_CompilerConfig
	// Optional additional runtimes supported by the plugin.
	AdditionalRuntimes []*MavenConfig_RuntimeConfig
}

func (b0 MavenConfig_builder) Build() *MavenConfig {
	m0 := &MavenConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	x.xxx_hidden_Compiler = b.Compiler
	x.xxx_hidden_AdditionalRuntimes = &b.AdditionalRuntimes
	return m0
}

// NugetConfig is the configuration for a NuGet C# plugin.
type NugetConfig struct {
	state                       protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_TargetFrameworks []DotnetTargetFramework        `protobuf:"varint,1,rep,packed,name=target_frameworks,json=targetFrameworks,proto3,enum=buf.alpha.registry.v1alpha1.DotnetTargetFramework"`
	xxx_hidden_RuntimeLibraries *[]*NugetConfig_RuntimeLibrary `protobuf:"bytes,2,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *NugetConfig) Reset() {
	*x = NugetConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NugetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NugetConfig) ProtoMessage() {}

func (x *NugetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *NugetConfig) GetTargetFrameworks() []DotnetTargetFramework {
	if x != nil {
		return x.xxx_hidden_TargetFrameworks
	}
	return nil
}

func (x *NugetConfig) GetRuntimeLibraries() []*NugetConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *NugetConfig) SetTargetFrameworks(v []DotnetTargetFramework) {
	x.xxx_hidden_TargetFrameworks = v
}

func (x *NugetConfig) SetRuntimeLibraries(v []*NugetConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

type NugetConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Target frameworks to build. At least one target framework is required.
	TargetFrameworks []DotnetTargetFramework
	// Optional runtime libraries required by the plugin's generated code.
	RuntimeLibraries []*NugetConfig_RuntimeLibrary
}

func (b0 NugetConfig_builder) Build() *NugetConfig {
	m0 := &NugetConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TargetFrameworks = b.TargetFrameworks
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	return m0
}

// CmakeConfig is the configuration for a Cmake C++ plugin.
type CmakeConfig struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CmakeConfig) Reset() {
	*x = CmakeConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CmakeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CmakeConfig) ProtoMessage() {}

func (x *CmakeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type CmakeConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 CmakeConfig_builder) Build() *CmakeConfig {
	m0 := &CmakeConfig{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type SwiftConfig struct {
	state                       protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_RuntimeLibraries *[]*SwiftConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *SwiftConfig) Reset() {
	*x = SwiftConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwiftConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwiftConfig) ProtoMessage() {}

func (x *SwiftConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SwiftConfig) GetRuntimeLibraries() []*SwiftConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *SwiftConfig) SetRuntimeLibraries(v []*SwiftConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

type SwiftConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*SwiftConfig_RuntimeLibrary
}

func (b0 SwiftConfig_builder) Build() *SwiftConfig {
	m0 := &SwiftConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	return m0
}

type PythonConfig struct {
	state                       protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_RuntimeLibraries *[]*PythonConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	xxx_hidden_RequiresPython   string                          `protobuf:"bytes,2,opt,name=requires_python,json=requiresPython,proto3"`
	xxx_hidden_PackageType      PythonPackageType               `protobuf:"varint,3,opt,name=package_type,json=packageType,proto3,enum=buf.alpha.registry.v1alpha1.PythonPackageType"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PythonConfig) Reset() {
	*x = PythonConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonConfig) ProtoMessage() {}

func (x *PythonConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PythonConfig) GetRuntimeLibraries() []*PythonConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *PythonConfig) GetRequiresPython() string {
	if x != nil {
		return x.xxx_hidden_RequiresPython
	}
	return ""
}

func (x *PythonConfig) GetPackageType() PythonPackageType {
	if x != nil {
		return x.xxx_hidden_PackageType
	}
	return PythonPackageType_PYTHON_PACKAGE_TYPE_UNSPECIFIED
}

func (x *PythonConfig) SetRuntimeLibraries(v []*PythonConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

func (x *PythonConfig) SetRequiresPython(v string) {
	x.xxx_hidden_RequiresPython = v
}

func (x *PythonConfig) SetPackageType(v PythonPackageType) {
	x.xxx_hidden_PackageType = v
}

type PythonConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RuntimeLibraries []*PythonConfig_RuntimeLibrary
	// requires_python is a PEP 440 Version Specifier that specifies the value of
	// the `Requires-Python` field in a metadata file.
	//
	// Ref:
	// - https://packaging.python.org/en/latest/specifications/core-metadata/#requires-python
	// - https://peps.python.org/pep-0440/
	RequiresPython string
	// package_type is the PythonPackageType that this plugin generates.
	PackageType PythonPackageType
}

func (b0 PythonConfig_builder) Build() *PythonConfig {
	m0 := &PythonConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	x.xxx_hidden_RequiresPython = b.RequiresPython
	x.xxx_hidden_PackageType = b.PackageType
	return m0
}

// CargoConfig specifies the Cargo Registry configuration for a Rust plugin.
type CargoConfig struct {
	state                       protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_RustVersion      string                         `protobuf:"bytes,1,opt,name=rust_version,json=rustVersion,proto3"`
	xxx_hidden_RuntimeLibraries *[]*CargoConfig_RuntimeLibrary `protobuf:"bytes,2,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *CargoConfig) Reset() {
	*x = CargoConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CargoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CargoConfig) ProtoMessage() {}

func (x *CargoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CargoConfig) GetRustVersion() string {
	if x != nil {
		return x.xxx_hidden_RustVersion
	}
	return ""
}

func (x *CargoConfig) GetRuntimeLibraries() []*CargoConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *CargoConfig) SetRustVersion(v string) {
	x.xxx_hidden_RustVersion = v
}

func (x *CargoConfig) SetRuntimeLibraries(v []*CargoConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

type CargoConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// rust_version specifies the minimum supported Rust version (MSRV) for the generated crate.
	// Ref: https://doc.rust-lang.org/cargo/reference/manifest.html#the-rust-version-field
	RustVersion string
	// runtime_libraries specifies the runtime dependencies for the generated crate. Optional.
	RuntimeLibraries []*CargoConfig_RuntimeLibrary
}

func (b0 CargoConfig_builder) Build() *CargoConfig {
	m0 := &CargoConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RustVersion = b.RustVersion
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	return m0
}

// RegistryConfig is the configuration for the remote registry of a plugin.
type RegistryConfig struct {
	state                     protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_RegistryConfig isRegistryConfig_RegistryConfig `protobuf_oneof:"registry_config"`
	xxx_hidden_Options        []string                        `protobuf:"bytes,10,rep,name=options,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *RegistryConfig) Reset() {
	*x = RegistryConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegistryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistryConfig) ProtoMessage() {}

func (x *RegistryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RegistryConfig) GetGoConfig() *GoConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_GoConfig); ok {
			return x.GoConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetNpmConfig() *NPMConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_NpmConfig); ok {
			return x.NpmConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetMavenConfig() *MavenConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_MavenConfig); ok {
			return x.MavenConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetSwiftConfig() *SwiftConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_SwiftConfig); ok {
			return x.SwiftConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetPythonConfig() *PythonConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_PythonConfig); ok {
			return x.PythonConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetCargoConfig() *CargoConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_CargoConfig); ok {
			return x.CargoConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetNugetConfig() *NugetConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_NugetConfig); ok {
			return x.NugetConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetCmakeConfig() *CmakeConfig {
	if x != nil {
		if x, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_CmakeConfig); ok {
			return x.CmakeConfig
		}
	}
	return nil
}

func (x *RegistryConfig) GetOptions() []string {
	if x != nil {
		return x.xxx_hidden_Options
	}
	return nil
}

func (x *RegistryConfig) SetGoConfig(v *GoConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_GoConfig{v}
}

func (x *RegistryConfig) SetNpmConfig(v *NPMConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_NpmConfig{v}
}

func (x *RegistryConfig) SetMavenConfig(v *MavenConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_MavenConfig{v}
}

func (x *RegistryConfig) SetSwiftConfig(v *SwiftConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_SwiftConfig{v}
}

func (x *RegistryConfig) SetPythonConfig(v *PythonConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_PythonConfig{v}
}

func (x *RegistryConfig) SetCargoConfig(v *CargoConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_CargoConfig{v}
}

func (x *RegistryConfig) SetNugetConfig(v *NugetConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_NugetConfig{v}
}

func (x *RegistryConfig) SetCmakeConfig(v *CmakeConfig) {
	if v == nil {
		x.xxx_hidden_RegistryConfig = nil
		return
	}
	x.xxx_hidden_RegistryConfig = &registryConfig_CmakeConfig{v}
}

func (x *RegistryConfig) SetOptions(v []string) {
	x.xxx_hidden_Options = v
}

func (x *RegistryConfig) HasRegistryConfig() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RegistryConfig != nil
}

func (x *RegistryConfig) HasGoConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_GoConfig)
	return ok
}

func (x *RegistryConfig) HasNpmConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_NpmConfig)
	return ok
}

func (x *RegistryConfig) HasMavenConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_MavenConfig)
	return ok
}

func (x *RegistryConfig) HasSwiftConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_SwiftConfig)
	return ok
}

func (x *RegistryConfig) HasPythonConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_PythonConfig)
	return ok
}

func (x *RegistryConfig) HasCargoConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_CargoConfig)
	return ok
}

func (x *RegistryConfig) HasNugetConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_NugetConfig)
	return ok
}

func (x *RegistryConfig) HasCmakeConfig() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_CmakeConfig)
	return ok
}

func (x *RegistryConfig) ClearRegistryConfig() {
	x.xxx_hidden_RegistryConfig = nil
}

func (x *RegistryConfig) ClearGoConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_GoConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearNpmConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_NpmConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearMavenConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_MavenConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearSwiftConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_SwiftConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearPythonConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_PythonConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearCargoConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_CargoConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearNugetConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_NugetConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

func (x *RegistryConfig) ClearCmakeConfig() {
	if _, ok := x.xxx_hidden_RegistryConfig.(*registryConfig_CmakeConfig); ok {
		x.xxx_hidden_RegistryConfig = nil
	}
}

const RegistryConfig_RegistryConfig_not_set_case case_RegistryConfig_RegistryConfig = 0
const RegistryConfig_GoConfig_case case_RegistryConfig_RegistryConfig = 1
const RegistryConfig_NpmConfig_case case_RegistryConfig_RegistryConfig = 2
const RegistryConfig_MavenConfig_case case_RegistryConfig_RegistryConfig = 3
const RegistryConfig_SwiftConfig_case case_RegistryConfig_RegistryConfig = 4
const RegistryConfig_PythonConfig_case case_RegistryConfig_RegistryConfig = 5
const RegistryConfig_CargoConfig_case case_RegistryConfig_RegistryConfig = 6
const RegistryConfig_NugetConfig_case case_RegistryConfig_RegistryConfig = 7
const RegistryConfig_CmakeConfig_case case_RegistryConfig_RegistryConfig = 8

func (x *RegistryConfig) WhichRegistryConfig() case_RegistryConfig_RegistryConfig {
	if x == nil {
		return RegistryConfig_RegistryConfig_not_set_case
	}
	switch x.xxx_hidden_RegistryConfig.(type) {
	case *registryConfig_GoConfig:
		return RegistryConfig_GoConfig_case
	case *registryConfig_NpmConfig:
		return RegistryConfig_NpmConfig_case
	case *registryConfig_MavenConfig:
		return RegistryConfig_MavenConfig_case
	case *registryConfig_SwiftConfig:
		return RegistryConfig_SwiftConfig_case
	case *registryConfig_PythonConfig:
		return RegistryConfig_PythonConfig_case
	case *registryConfig_CargoConfig:
		return RegistryConfig_CargoConfig_case
	case *registryConfig_NugetConfig:
		return RegistryConfig_NugetConfig_case
	case *registryConfig_CmakeConfig:
		return RegistryConfig_CmakeConfig_case
	default:
		return RegistryConfig_RegistryConfig_not_set_case
	}
}

type RegistryConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_RegistryConfig:
	GoConfig     *GoConfig
	NpmConfig    *NPMConfig
	MavenConfig  *MavenConfig
	SwiftConfig  *SwiftConfig
	PythonConfig *PythonConfig
	CargoConfig  *CargoConfig
	NugetConfig  *NugetConfig
	CmakeConfig  *CmakeConfig
	// -- end of xxx_hidden_RegistryConfig
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string
}

func (b0 RegistryConfig_builder) Build() *RegistryConfig {
	m0 := &RegistryConfig{}
	b, x := &b0, m0
	_, _ = b, x
	if b.GoConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_GoConfig{b.GoConfig}
	}
	if b.NpmConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_NpmConfig{b.NpmConfig}
	}
	if b.MavenConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_MavenConfig{b.MavenConfig}
	}
	if b.SwiftConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_SwiftConfig{b.SwiftConfig}
	}
	if b.PythonConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_PythonConfig{b.PythonConfig}
	}
	if b.CargoConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_CargoConfig{b.CargoConfig}
	}
	if b.NugetConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_NugetConfig{b.NugetConfig}
	}
	if b.CmakeConfig != nil {
		x.xxx_hidden_RegistryConfig = &registryConfig_CmakeConfig{b.CmakeConfig}
	}
	x.xxx_hidden_Options = b.Options
	return m0
}

type case_RegistryConfig_RegistryConfig protoreflect.FieldNumber

func (x case_RegistryConfig_RegistryConfig) String() string {
	md := file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isRegistryConfig_RegistryConfig interface {
	isRegistryConfig_RegistryConfig()
}

type registryConfig_GoConfig struct {
	GoConfig *GoConfig `protobuf:"bytes,1,opt,name=go_config,json=goConfig,proto3,oneof"`
}

type registryConfig_NpmConfig struct {
	NpmConfig *NPMConfig `protobuf:"bytes,2,opt,name=npm_config,json=npmConfig,proto3,oneof"`
}

type registryConfig_MavenConfig struct {
	MavenConfig *MavenConfig `protobuf:"bytes,3,opt,name=maven_config,json=mavenConfig,proto3,oneof"`
}

type registryConfig_SwiftConfig struct {
	SwiftConfig *SwiftConfig `protobuf:"bytes,4,opt,name=swift_config,json=swiftConfig,proto3,oneof"`
}

type registryConfig_PythonConfig struct {
	PythonConfig *PythonConfig `protobuf:"bytes,5,opt,name=python_config,json=pythonConfig,proto3,oneof"`
}

type registryConfig_CargoConfig struct {
	CargoConfig *CargoConfig `protobuf:"bytes,6,opt,name=cargo_config,json=cargoConfig,proto3,oneof"`
}

type registryConfig_NugetConfig struct {
	NugetConfig *NugetConfig `protobuf:"bytes,7,opt,name=nuget_config,json=nugetConfig,proto3,oneof"`
}

type registryConfig_CmakeConfig struct {
	CmakeConfig *CmakeConfig `protobuf:"bytes,8,opt,name=cmake_config,json=cmakeConfig,proto3,oneof"`
}

func (*registryConfig_GoConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_NpmConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_MavenConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_SwiftConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_PythonConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_CargoConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_NugetConfig) isRegistryConfig_RegistryConfig() {}

func (*registryConfig_CmakeConfig) isRegistryConfig_RegistryConfig() {}

type CuratedPluginReference struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner    string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name     string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Version  string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_Revision uint32                 `protobuf:"varint,4,opt,name=revision,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CuratedPluginReference) Reset() {
	*x = CuratedPluginReference{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPluginReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginReference) ProtoMessage() {}

func (x *CuratedPluginReference) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CuratedPluginReference) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *CuratedPluginReference) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CuratedPluginReference) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *CuratedPluginReference) GetRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_Revision
	}
	return 0
}

func (x *CuratedPluginReference) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *CuratedPluginReference) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CuratedPluginReference) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *CuratedPluginReference) SetRevision(v uint32) {
	x.xxx_hidden_Revision = v
}

type CuratedPluginReference_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the plugin, i.e. "library".
	Owner string
	// The name of the plugin, i.e. "connect-go".
	Name string
	// Semver-formatted plugin version.
	Version string
	// The revision for this plugin version.
	Revision uint32
}

func (b0 CuratedPluginReference_builder) Build() *CuratedPluginReference {
	m0 := &CuratedPluginReference{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Revision = b.Revision
	return m0
}

// CuratedPlugin represents a protoc plugin curated by Buf, such as protoc-gen-go.
type CuratedPlugin struct {
	state                           protoimpl.MessageState     `protogen:"opaque.v1"`
	xxx_hidden_Id                   string                     `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Owner                string                     `protobuf:"bytes,2,opt,name=owner,proto3"`
	xxx_hidden_Name                 string                     `protobuf:"bytes,3,opt,name=name,proto3"`
	xxx_hidden_RegistryType         PluginRegistryType         `protobuf:"varint,4,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType"`
	xxx_hidden_Version              string                     `protobuf:"bytes,5,opt,name=version,proto3"`
	xxx_hidden_ContainerImageDigest string                     `protobuf:"bytes,6,opt,name=container_image_digest,json=containerImageDigest,proto3"`
	xxx_hidden_CreateTime           *timestamppb.Timestamp     `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_Dependencies         *[]*CuratedPluginReference `protobuf:"bytes,9,rep,name=dependencies,proto3"`
	xxx_hidden_SourceUrl            string                     `protobuf:"bytes,10,opt,name=source_url,json=sourceUrl,proto3"`
	xxx_hidden_Description          string                     `protobuf:"bytes,11,opt,name=description,proto3"`
	xxx_hidden_RegistryConfig       *RegistryConfig            `protobuf:"bytes,12,opt,name=registry_config,json=registryConfig,proto3"`
	xxx_hidden_Revision             uint32                     `protobuf:"varint,13,opt,name=revision,proto3"`
	xxx_hidden_OutputLanguages      []PluginLanguage           `protobuf:"varint,14,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage"`
	xxx_hidden_SpdxLicenseId        string                     `protobuf:"bytes,15,opt,name=spdx_license_id,json=spdxLicenseId,proto3"`
	xxx_hidden_LicenseUrl           string                     `protobuf:"bytes,16,opt,name=license_url,json=licenseUrl,proto3"`
	xxx_hidden_Verified             bool                       `protobuf:"varint,17,opt,name=verified,proto3"`
	xxx_hidden_Visibility           CuratedPluginVisibility    `protobuf:"varint,18,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.CuratedPluginVisibility"`
	xxx_hidden_Deprecated           bool                       `protobuf:"varint,19,opt,name=deprecated,proto3"`
	xxx_hidden_DeprecationMessage   string                     `protobuf:"bytes,20,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	xxx_hidden_IntegrationGuideUrl  string                     `protobuf:"bytes,21,opt,name=integration_guide_url,json=integrationGuideUrl,proto3"`
	xxx_hidden_Doc                  string                     `protobuf:"bytes,22,opt,name=doc,proto3"`
	xxx_hidden_Collections          *[]*PluginCollection       `protobuf:"bytes,23,rep,name=collections,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *CuratedPlugin) Reset() {
	*x = CuratedPlugin{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPlugin) ProtoMessage() {}

func (x *CuratedPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CuratedPlugin) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *CuratedPlugin) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *CuratedPlugin) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CuratedPlugin) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.xxx_hidden_RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CuratedPlugin) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *CuratedPlugin) GetContainerImageDigest() string {
	if x != nil {
		return x.xxx_hidden_ContainerImageDigest
	}
	return ""
}

func (x *CuratedPlugin) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *CuratedPlugin) GetDependencies() []*CuratedPluginReference {
	if x != nil {
		if x.xxx_hidden_Dependencies != nil {
			return *x.xxx_hidden_Dependencies
		}
	}
	return nil
}

func (x *CuratedPlugin) GetSourceUrl() string {
	if x != nil {
		return x.xxx_hidden_SourceUrl
	}
	return ""
}

func (x *CuratedPlugin) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *CuratedPlugin) GetRegistryConfig() *RegistryConfig {
	if x != nil {
		return x.xxx_hidden_RegistryConfig
	}
	return nil
}

func (x *CuratedPlugin) GetRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_Revision
	}
	return 0
}

func (x *CuratedPlugin) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.xxx_hidden_OutputLanguages
	}
	return nil
}

func (x *CuratedPlugin) GetSpdxLicenseId() string {
	if x != nil {
		return x.xxx_hidden_SpdxLicenseId
	}
	return ""
}

func (x *CuratedPlugin) GetLicenseUrl() string {
	if x != nil {
		return x.xxx_hidden_LicenseUrl
	}
	return ""
}

func (x *CuratedPlugin) GetVerified() bool {
	if x != nil {
		return x.xxx_hidden_Verified
	}
	return false
}

func (x *CuratedPlugin) GetVisibility() CuratedPluginVisibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *CuratedPlugin) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *CuratedPlugin) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *CuratedPlugin) GetIntegrationGuideUrl() string {
	if x != nil {
		return x.xxx_hidden_IntegrationGuideUrl
	}
	return ""
}

func (x *CuratedPlugin) GetDoc() string {
	if x != nil {
		return x.xxx_hidden_Doc
	}
	return ""
}

func (x *CuratedPlugin) GetCollections() []*PluginCollection {
	if x != nil {
		if x.xxx_hidden_Collections != nil {
			return *x.xxx_hidden_Collections
		}
	}
	return nil
}

func (x *CuratedPlugin) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *CuratedPlugin) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *CuratedPlugin) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CuratedPlugin) SetRegistryType(v PluginRegistryType) {
	x.xxx_hidden_RegistryType = v
}

func (x *CuratedPlugin) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *CuratedPlugin) SetContainerImageDigest(v string) {
	x.xxx_hidden_ContainerImageDigest = v
}

func (x *CuratedPlugin) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *CuratedPlugin) SetDependencies(v []*CuratedPluginReference) {
	x.xxx_hidden_Dependencies = &v
}

func (x *CuratedPlugin) SetSourceUrl(v string) {
	x.xxx_hidden_SourceUrl = v
}

func (x *CuratedPlugin) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *CuratedPlugin) SetRegistryConfig(v *RegistryConfig) {
	x.xxx_hidden_RegistryConfig = v
}

func (x *CuratedPlugin) SetRevision(v uint32) {
	x.xxx_hidden_Revision = v
}

func (x *CuratedPlugin) SetOutputLanguages(v []PluginLanguage) {
	x.xxx_hidden_OutputLanguages = v
}

func (x *CuratedPlugin) SetSpdxLicenseId(v string) {
	x.xxx_hidden_SpdxLicenseId = v
}

func (x *CuratedPlugin) SetLicenseUrl(v string) {
	x.xxx_hidden_LicenseUrl = v
}

func (x *CuratedPlugin) SetVerified(v bool) {
	x.xxx_hidden_Verified = v
}

func (x *CuratedPlugin) SetVisibility(v CuratedPluginVisibility) {
	x.xxx_hidden_Visibility = v
}

func (x *CuratedPlugin) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *CuratedPlugin) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

func (x *CuratedPlugin) SetIntegrationGuideUrl(v string) {
	x.xxx_hidden_IntegrationGuideUrl = v
}

func (x *CuratedPlugin) SetDoc(v string) {
	x.xxx_hidden_Doc = v
}

func (x *CuratedPlugin) SetCollections(v []*PluginCollection) {
	x.xxx_hidden_Collections = &v
}

func (x *CuratedPlugin) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *CuratedPlugin) HasRegistryConfig() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RegistryConfig != nil
}

func (x *CuratedPlugin) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *CuratedPlugin) ClearRegistryConfig() {
	x.xxx_hidden_RegistryConfig = nil
}

type CuratedPlugin_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the plugin, which uniquely identifies the plugin.
	Id string
	// The owner of the plugin, i.e. "library".
	Owner string
	// The name of the plugin, i.e. "connect-go".
	Name string
	// The optional registry type of the plugin.
	RegistryType PluginRegistryType
	// Semver-formatted plugin version.
	Version string
	// The full container image digest associated with this plugin version including
	// the algorithm.
	// Ref: https://github.com/opencontainers/image-spec/blob/main/descriptor.md#digests
	ContainerImageDigest string
	// The creation time of the plugin.
	CreateTime *timestamppb.Timestamp
	// List of plugin dependencies.
	Dependencies []*CuratedPluginReference
	// Optionally specify the URL leading to the source code of the plugin, if available.
	SourceUrl string
	// Optionally specify a brief description of the plugin functionality.
	Description string
	// The configuration for the remote registry of the plugin.
	RegistryConfig *RegistryConfig
	// The revision for this plugin version.
	Revision uint32
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage
	// spdx_license_id is the license of the plugin, which should be one of the identifiers
	// defined in https://spdx.org/licenses
	SpdxLicenseId string
	// license_url specifies an optional URL for the plugin's license (if not using a standard spdx_license_id).
	LicenseUrl string
	// verified indicates the plugin has been verified. Verification is a property
	// of the BSR and cannot be set by end-users.
	Verified bool
	// Visibility indicates whether the plugin is public or private.
	Visibility CuratedPluginVisibility
	// Deprecated indicates whether the plugin is deprecated.
	Deprecated bool
	// Optionally specify a message to be displayed when the plugin is deprecated.
	DeprecationMessage string
	// The URL leading to the integration guide of the plugin, if available.
	IntegrationGuideUrl string
	// The configurable documentation of the Plugin.
	Doc string
	// The collections the Plugin belongs to.
	Collections []*PluginCollection
}

func (b0 CuratedPlugin_builder) Build() *CuratedPlugin {
	m0 := &CuratedPlugin{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_RegistryType = b.RegistryType
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_ContainerImageDigest = b.ContainerImageDigest
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_Dependencies = &b.Dependencies
	x.xxx_hidden_SourceUrl = b.SourceUrl
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_RegistryConfig = b.RegistryConfig
	x.xxx_hidden_Revision = b.Revision
	x.xxx_hidden_OutputLanguages = b.OutputLanguages
	x.xxx_hidden_SpdxLicenseId = b.SpdxLicenseId
	x.xxx_hidden_LicenseUrl = b.LicenseUrl
	x.xxx_hidden_Verified = b.Verified
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	x.xxx_hidden_IntegrationGuideUrl = b.IntegrationGuideUrl
	x.xxx_hidden_Doc = b.Doc
	x.xxx_hidden_Collections = &b.Collections
	return m0
}

// Plugin collections group related plugins, organizing them by functionality or ecosystem.
type PluginCollection struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PluginCollection) Reset() {
	*x = PluginCollection{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginCollection) ProtoMessage() {}

func (x *PluginCollection) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PluginCollection) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *PluginCollection) SetName(v string) {
	x.xxx_hidden_Name = v
}

type PluginCollection_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the collection.
	Name string
}

func (b0 PluginCollection_builder) Build() *PluginCollection {
	m0 := &PluginCollection{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	return m0
}

type GenerateCodeRequest struct {
	state                            protoimpl.MessageState      `protogen:"opaque.v1"`
	xxx_hidden_Image                 *v1.Image                   `protobuf:"bytes,1,opt,name=image,proto3"`
	xxx_hidden_Requests              *[]*PluginGenerationRequest `protobuf:"bytes,2,rep,name=requests,proto3"`
	xxx_hidden_IncludeImports        bool                        `protobuf:"varint,3,opt,name=include_imports,json=includeImports,proto3"`
	xxx_hidden_IncludeWellKnownTypes bool                        `protobuf:"varint,4,opt,name=include_well_known_types,json=includeWellKnownTypes,proto3"`
	unknownFields                    protoimpl.UnknownFields
	sizeCache                        protoimpl.SizeCache
}

func (x *GenerateCodeRequest) Reset() {
	*x = GenerateCodeRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateCodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCodeRequest) ProtoMessage() {}

func (x *GenerateCodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GenerateCodeRequest) GetImage() *v1.Image {
	if x != nil {
		return x.xxx_hidden_Image
	}
	return nil
}

func (x *GenerateCodeRequest) GetRequests() []*PluginGenerationRequest {
	if x != nil {
		if x.xxx_hidden_Requests != nil {
			return *x.xxx_hidden_Requests
		}
	}
	return nil
}

func (x *GenerateCodeRequest) GetIncludeImports() bool {
	if x != nil {
		return x.xxx_hidden_IncludeImports
	}
	return false
}

func (x *GenerateCodeRequest) GetIncludeWellKnownTypes() bool {
	if x != nil {
		return x.xxx_hidden_IncludeWellKnownTypes
	}
	return false
}

func (x *GenerateCodeRequest) SetImage(v *v1.Image) {
	x.xxx_hidden_Image = v
}

func (x *GenerateCodeRequest) SetRequests(v []*PluginGenerationRequest) {
	x.xxx_hidden_Requests = &v
}

func (x *GenerateCodeRequest) SetIncludeImports(v bool) {
	x.xxx_hidden_IncludeImports = v
}

func (x *GenerateCodeRequest) SetIncludeWellKnownTypes(v bool) {
	x.xxx_hidden_IncludeWellKnownTypes = v
}

func (x *GenerateCodeRequest) HasImage() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Image != nil
}

func (x *GenerateCodeRequest) ClearImage() {
	x.xxx_hidden_Image = nil
}

type GenerateCodeRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The image to run plugins against to generate the desired file outputs.
	//
	// All image files that are not imports and not well-known types will be generated.
	// If you want to filter what files are generated, modify the image.
	// If you want to include imports, set include_imports.
	Image    *v1.Image
	Requests []*PluginGenerationRequest
	// Include imports from the Image in generation. If include_imports is also set
	// in one of requests, use the request's value for that plugin.
	IncludeImports bool
	// Include Well-Known Types from the Image in generation.
	//
	// include_imports must be set if include_well_known_types is set. If include_well_known_types
	// is also set in one of requests, use the request's value for that plugin.
	IncludeWellKnownTypes bool
}

func (b0 GenerateCodeRequest_builder) Build() *GenerateCodeRequest {
	m0 := &GenerateCodeRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Image = b.Image
	x.xxx_hidden_Requests = &b.Requests
	x.xxx_hidden_IncludeImports = b.IncludeImports
	x.xxx_hidden_IncludeWellKnownTypes = b.IncludeWellKnownTypes
	return m0
}

type GenerateCodeResponse struct {
	state                protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_Responses *[]*PluginGenerationResponse `protobuf:"bytes,1,rep,name=responses,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GenerateCodeResponse) Reset() {
	*x = GenerateCodeResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateCodeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCodeResponse) ProtoMessage() {}

func (x *GenerateCodeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GenerateCodeResponse) GetResponses() []*PluginGenerationResponse {
	if x != nil {
		if x.xxx_hidden_Responses != nil {
			return *x.xxx_hidden_Responses
		}
	}
	return nil
}

func (x *GenerateCodeResponse) SetResponses(v []*PluginGenerationResponse) {
	x.xxx_hidden_Responses = &v
}

type GenerateCodeResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Responses from each plugin execution.
	// The order of each response matches the order in the GenerateCodeRequest.
	Responses []*PluginGenerationResponse
}

func (b0 GenerateCodeResponse_builder) Build() *GenerateCodeResponse {
	m0 := &GenerateCodeResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Responses = &b.Responses
	return m0
}

// Request for performing code generation using the specified plugin.
type PluginGenerationRequest struct {
	state                            protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_PluginReference       *CuratedPluginReference `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_Options               []string                `protobuf:"bytes,2,rep,name=options,proto3"`
	xxx_hidden_IncludeImports        bool                    `protobuf:"varint,3,opt,name=include_imports,json=includeImports,proto3,oneof"`
	xxx_hidden_IncludeWellKnownTypes bool                    `protobuf:"varint,4,opt,name=include_well_known_types,json=includeWellKnownTypes,proto3,oneof"`
	XXX_raceDetectHookData           protoimpl.RaceDetectHookData
	XXX_presence                     [1]uint32
	unknownFields                    protoimpl.UnknownFields
	sizeCache                        protoimpl.SizeCache
}

func (x *PluginGenerationRequest) Reset() {
	*x = PluginGenerationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginGenerationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginGenerationRequest) ProtoMessage() {}

func (x *PluginGenerationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PluginGenerationRequest) GetPluginReference() *CuratedPluginReference {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *PluginGenerationRequest) GetOptions() []string {
	if x != nil {
		return x.xxx_hidden_Options
	}
	return nil
}

func (x *PluginGenerationRequest) GetIncludeImports() bool {
	if x != nil {
		return x.xxx_hidden_IncludeImports
	}
	return false
}

func (x *PluginGenerationRequest) GetIncludeWellKnownTypes() bool {
	if x != nil {
		return x.xxx_hidden_IncludeWellKnownTypes
	}
	return false
}

func (x *PluginGenerationRequest) SetPluginReference(v *CuratedPluginReference) {
	x.xxx_hidden_PluginReference = v
}

func (x *PluginGenerationRequest) SetOptions(v []string) {
	x.xxx_hidden_Options = v
}

func (x *PluginGenerationRequest) SetIncludeImports(v bool) {
	x.xxx_hidden_IncludeImports = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 4)
}

func (x *PluginGenerationRequest) SetIncludeWellKnownTypes(v bool) {
	x.xxx_hidden_IncludeWellKnownTypes = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 3, 4)
}

func (x *PluginGenerationRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *PluginGenerationRequest) HasIncludeImports() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *PluginGenerationRequest) HasIncludeWellKnownTypes() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 3)
}

func (x *PluginGenerationRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *PluginGenerationRequest) ClearIncludeImports() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_IncludeImports = false
}

func (x *PluginGenerationRequest) ClearIncludeWellKnownTypes() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 3)
	x.xxx_hidden_IncludeWellKnownTypes = false
}

type PluginGenerationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin to execute.
	PluginReference *CuratedPluginReference
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string
	// Include imports from the Image in generation.
	IncludeImports *bool
	// Include Well-Known Types from the Image in generation.
	//
	// include_imports must be set if include_well_known_types is set.
	IncludeWellKnownTypes *bool
}

func (b0 PluginGenerationRequest_builder) Build() *PluginGenerationRequest {
	m0 := &PluginGenerationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_Options = b.Options
	if b.IncludeImports != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 4)
		x.xxx_hidden_IncludeImports = *b.IncludeImports
	}
	if b.IncludeWellKnownTypes != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 3, 4)
		x.xxx_hidden_IncludeWellKnownTypes = *b.IncludeWellKnownTypes
	}
	return m0
}

// Response from code generation for a given plugin.
type PluginGenerationResponse struct {
	state               protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Response *pluginpb.CodeGeneratorResponse `protobuf:"bytes,1,opt,name=response,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PluginGenerationResponse) Reset() {
	*x = PluginGenerationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginGenerationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginGenerationResponse) ProtoMessage() {}

func (x *PluginGenerationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PluginGenerationResponse) GetResponse() *pluginpb.CodeGeneratorResponse {
	if x != nil {
		return x.xxx_hidden_Response
	}
	return nil
}

func (x *PluginGenerationResponse) SetResponse(v *pluginpb.CodeGeneratorResponse) {
	x.xxx_hidden_Response = v
}

func (x *PluginGenerationResponse) HasResponse() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Response != nil
}

func (x *PluginGenerationResponse) ClearResponse() {
	x.xxx_hidden_Response = nil
}

type PluginGenerationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Generated code from the plugin.
	Response *pluginpb.CodeGeneratorResponse
}

func (b0 PluginGenerationResponse_builder) Build() *PluginGenerationResponse {
	m0 := &PluginGenerationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Response = b.Response
	return m0
}

type DeleteCuratedPluginRequest struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner   string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name    string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Version string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *DeleteCuratedPluginRequest) Reset() {
	*x = DeleteCuratedPluginRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCuratedPluginRequest) ProtoMessage() {}

func (x *DeleteCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *DeleteCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *DeleteCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *DeleteCuratedPluginRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *DeleteCuratedPluginRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *DeleteCuratedPluginRequest) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type DeleteCuratedPluginRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the plugin to delete.
	Owner string
	// The name of the plugin to delete.
	Name string
	// Version is the plugin version and is optional. If this field is not set then delete all versions,
	// otherwise delete only the specified version which includes all revisions.
	Version string
}

func (b0 DeleteCuratedPluginRequest_builder) Build() *DeleteCuratedPluginRequest {
	m0 := &DeleteCuratedPluginRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	return m0
}

type DeleteCuratedPluginResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteCuratedPluginResponse) Reset() {
	*x = DeleteCuratedPluginResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCuratedPluginResponse) ProtoMessage() {}

func (x *DeleteCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteCuratedPluginResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteCuratedPluginResponse_builder) Build() *DeleteCuratedPluginResponse {
	m0 := &DeleteCuratedPluginResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type CreateCuratedPluginRequest struct {
	state                           protoimpl.MessageState     `protogen:"opaque.v1"`
	xxx_hidden_Owner                string                     `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name                 string                     `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_RegistryType         PluginRegistryType         `protobuf:"varint,3,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType"`
	xxx_hidden_Version              string                     `protobuf:"bytes,4,opt,name=version,proto3"`
	xxx_hidden_ContainerImageDigest string                     `protobuf:"bytes,5,opt,name=container_image_digest,json=containerImageDigest,proto3"`
	xxx_hidden_Dependencies         *[]*CuratedPluginReference `protobuf:"bytes,7,rep,name=dependencies,proto3"`
	xxx_hidden_SourceUrl            string                     `protobuf:"bytes,8,opt,name=source_url,json=sourceUrl,proto3"`
	xxx_hidden_Description          string                     `protobuf:"bytes,9,opt,name=description,proto3"`
	xxx_hidden_RegistryConfig       *RegistryConfig            `protobuf:"bytes,12,opt,name=registry_config,json=registryConfig,proto3"`
	xxx_hidden_Revision             uint32                     `protobuf:"varint,13,opt,name=revision,proto3"`
	xxx_hidden_OutputLanguages      []PluginLanguage           `protobuf:"varint,14,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage"`
	xxx_hidden_SpdxLicenseId        string                     `protobuf:"bytes,15,opt,name=spdx_license_id,json=spdxLicenseId,proto3"`
	xxx_hidden_LicenseUrl           string                     `protobuf:"bytes,16,opt,name=license_url,json=licenseUrl,proto3"`
	xxx_hidden_Visibility           CuratedPluginVisibility    `protobuf:"varint,17,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.CuratedPluginVisibility"`
	xxx_hidden_IntegrationGuideUrl  string                     `protobuf:"bytes,18,opt,name=integration_guide_url,json=integrationGuideUrl,proto3"`
	xxx_hidden_Deprecated           bool                       `protobuf:"varint,19,opt,name=deprecated,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *CreateCuratedPluginRequest) Reset() {
	*x = CreateCuratedPluginRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCuratedPluginRequest) ProtoMessage() {}

func (x *CreateCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.xxx_hidden_RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CreateCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetContainerImageDigest() string {
	if x != nil {
		return x.xxx_hidden_ContainerImageDigest
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDependencies() []*CuratedPluginReference {
	if x != nil {
		if x.xxx_hidden_Dependencies != nil {
			return *x.xxx_hidden_Dependencies
		}
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetSourceUrl() string {
	if x != nil {
		return x.xxx_hidden_SourceUrl
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetRegistryConfig() *RegistryConfig {
	if x != nil {
		return x.xxx_hidden_RegistryConfig
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_Revision
	}
	return 0
}

func (x *CreateCuratedPluginRequest) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.xxx_hidden_OutputLanguages
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetSpdxLicenseId() string {
	if x != nil {
		return x.xxx_hidden_SpdxLicenseId
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetLicenseUrl() string {
	if x != nil {
		return x.xxx_hidden_LicenseUrl
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetVisibility() CuratedPluginVisibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *CreateCuratedPluginRequest) GetIntegrationGuideUrl() string {
	if x != nil {
		return x.xxx_hidden_IntegrationGuideUrl
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *CreateCuratedPluginRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *CreateCuratedPluginRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CreateCuratedPluginRequest) SetRegistryType(v PluginRegistryType) {
	x.xxx_hidden_RegistryType = v
}

func (x *CreateCuratedPluginRequest) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *CreateCuratedPluginRequest) SetContainerImageDigest(v string) {
	x.xxx_hidden_ContainerImageDigest = v
}

func (x *CreateCuratedPluginRequest) SetDependencies(v []*CuratedPluginReference) {
	x.xxx_hidden_Dependencies = &v
}

func (x *CreateCuratedPluginRequest) SetSourceUrl(v string) {
	x.xxx_hidden_SourceUrl = v
}

func (x *CreateCuratedPluginRequest) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *CreateCuratedPluginRequest) SetRegistryConfig(v *RegistryConfig) {
	x.xxx_hidden_RegistryConfig = v
}

func (x *CreateCuratedPluginRequest) SetRevision(v uint32) {
	x.xxx_hidden_Revision = v
}

func (x *CreateCuratedPluginRequest) SetOutputLanguages(v []PluginLanguage) {
	x.xxx_hidden_OutputLanguages = v
}

func (x *CreateCuratedPluginRequest) SetSpdxLicenseId(v string) {
	x.xxx_hidden_SpdxLicenseId = v
}

func (x *CreateCuratedPluginRequest) SetLicenseUrl(v string) {
	x.xxx_hidden_LicenseUrl = v
}

func (x *CreateCuratedPluginRequest) SetVisibility(v CuratedPluginVisibility) {
	x.xxx_hidden_Visibility = v
}

func (x *CreateCuratedPluginRequest) SetIntegrationGuideUrl(v string) {
	x.xxx_hidden_IntegrationGuideUrl = v
}

func (x *CreateCuratedPluginRequest) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *CreateCuratedPluginRequest) HasRegistryConfig() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RegistryConfig != nil
}

func (x *CreateCuratedPluginRequest) ClearRegistryConfig() {
	x.xxx_hidden_RegistryConfig = nil
}

type CreateCuratedPluginRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the plugin, i.e. "library".
	Owner string
	// The name of the plugin, i.e. "connect-go".
	Name string
	// The optional registry type of the plugin.
	RegistryType PluginRegistryType
	// Semver-formatted plugin version.
	Version string
	// The full container image digest associated with this plugin version including
	// the algorithm.
	// Ref: https://github.com/opencontainers/image-spec/blob/main/descriptor.md#digests
	ContainerImageDigest string
	// List of plugin dependencies.
	Dependencies []*CuratedPluginReference
	// The URL leading to the source code of the plugin, if available.
	SourceUrl string
	// A brief description of the plugin functionality.
	Description string
	// The configuration for the remote registry of the plugin.
	RegistryConfig *RegistryConfig
	// The revision for this plugin version.
	Revision uint32
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage
	// spdx_license_id is the license of the plugin, which should be one of the identifiers
	// defined in https://spdx.org/licenses
	SpdxLicenseId string
	// license_url specifies an optional URL for the plugin's license (if not using a standard spdx_license_id).
	LicenseUrl string
	// Visibility indicates whether the plugin is public or private.
	Visibility CuratedPluginVisibility
	// The URL leading to the integration guide of the plugin, if available.
	IntegrationGuideUrl string
	// The deprecation status of the plugin.
	Deprecated bool
}

func (b0 CreateCuratedPluginRequest_builder) Build() *CreateCuratedPluginRequest {
	m0 := &CreateCuratedPluginRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_RegistryType = b.RegistryType
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_ContainerImageDigest = b.ContainerImageDigest
	x.xxx_hidden_Dependencies = &b.Dependencies
	x.xxx_hidden_SourceUrl = b.SourceUrl
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_RegistryConfig = b.RegistryConfig
	x.xxx_hidden_Revision = b.Revision
	x.xxx_hidden_OutputLanguages = b.OutputLanguages
	x.xxx_hidden_SpdxLicenseId = b.SpdxLicenseId
	x.xxx_hidden_LicenseUrl = b.LicenseUrl
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_IntegrationGuideUrl = b.IntegrationGuideUrl
	x.xxx_hidden_Deprecated = b.Deprecated
	return m0
}

type CreateCuratedPluginResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Configuration *CuratedPlugin         `protobuf:"bytes,1,opt,name=configuration,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *CreateCuratedPluginResponse) Reset() {
	*x = CreateCuratedPluginResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCuratedPluginResponse) ProtoMessage() {}

func (x *CreateCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateCuratedPluginResponse) GetConfiguration() *CuratedPlugin {
	if x != nil {
		return x.xxx_hidden_Configuration
	}
	return nil
}

func (x *CreateCuratedPluginResponse) SetConfiguration(v *CuratedPlugin) {
	x.xxx_hidden_Configuration = v
}

func (x *CreateCuratedPluginResponse) HasConfiguration() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Configuration != nil
}

func (x *CreateCuratedPluginResponse) ClearConfiguration() {
	x.xxx_hidden_Configuration = nil
}

type CreateCuratedPluginResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The created plugin.
	Configuration *CuratedPlugin
}

func (b0 CreateCuratedPluginResponse_builder) Build() *CreateCuratedPluginResponse {
	m0 := &CreateCuratedPluginResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Configuration = b.Configuration
	return m0
}

type ListCuratedPluginsRequest struct {
	state                             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize               uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken              string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse                bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	xxx_hidden_SupportsRemotePackages bool                   `protobuf:"varint,4,opt,name=supports_remote_packages,json=supportsRemotePackages,proto3"`
	xxx_hidden_IncludeDeprecated      bool                   `protobuf:"varint,5,opt,name=include_deprecated,json=includeDeprecated,proto3"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *ListCuratedPluginsRequest) Reset() {
	*x = ListCuratedPluginsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCuratedPluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCuratedPluginsRequest) ProtoMessage() {}

func (x *ListCuratedPluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCuratedPluginsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListCuratedPluginsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListCuratedPluginsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListCuratedPluginsRequest) GetSupportsRemotePackages() bool {
	if x != nil {
		return x.xxx_hidden_SupportsRemotePackages
	}
	return false
}

func (x *ListCuratedPluginsRequest) GetIncludeDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_IncludeDeprecated
	}
	return false
}

func (x *ListCuratedPluginsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListCuratedPluginsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListCuratedPluginsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

func (x *ListCuratedPluginsRequest) SetSupportsRemotePackages(v bool) {
	x.xxx_hidden_SupportsRemotePackages = v
}

func (x *ListCuratedPluginsRequest) SetIncludeDeprecated(v bool) {
	x.xxx_hidden_IncludeDeprecated = v
}

type ListCuratedPluginsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
	// If true, will only return plugins which support remote packages (registry_type is set).
	SupportsRemotePackages bool
	// If true, will include deprecated plugins.
	IncludeDeprecated bool
}

func (b0 ListCuratedPluginsRequest_builder) Build() *ListCuratedPluginsRequest {
	m0 := &ListCuratedPluginsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	x.xxx_hidden_SupportsRemotePackages = b.SupportsRemotePackages
	x.xxx_hidden_IncludeDeprecated = b.IncludeDeprecated
	return m0
}

type ListCuratedPluginsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Plugins       *[]*CuratedPlugin      `protobuf:"bytes,1,rep,name=plugins,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListCuratedPluginsResponse) Reset() {
	*x = ListCuratedPluginsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCuratedPluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCuratedPluginsResponse) ProtoMessage() {}

func (x *ListCuratedPluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCuratedPluginsResponse) GetPlugins() []*CuratedPlugin {
	if x != nil {
		if x.xxx_hidden_Plugins != nil {
			return *x.xxx_hidden_Plugins
		}
	}
	return nil
}

func (x *ListCuratedPluginsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListCuratedPluginsResponse) SetPlugins(v []*CuratedPlugin) {
	x.xxx_hidden_Plugins = &v
}

func (x *ListCuratedPluginsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListCuratedPluginsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Plugins []*CuratedPlugin
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListCuratedPluginsResponse_builder) Build() *ListCuratedPluginsResponse {
	m0 := &ListCuratedPluginsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Plugins = &b.Plugins
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type GetLatestCuratedPluginRequest struct {
	state                             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner                  string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name                   string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Version                string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_Revision               uint32                 `protobuf:"varint,4,opt,name=revision,proto3"`
	xxx_hidden_SupportsRemotePackages bool                   `protobuf:"varint,5,opt,name=supports_remote_packages,json=supportsRemotePackages,proto3"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *GetLatestCuratedPluginRequest) Reset() {
	*x = GetLatestCuratedPluginRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLatestCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestCuratedPluginRequest) ProtoMessage() {}

func (x *GetLatestCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLatestCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_Revision
	}
	return 0
}

func (x *GetLatestCuratedPluginRequest) GetSupportsRemotePackages() bool {
	if x != nil {
		return x.xxx_hidden_SupportsRemotePackages
	}
	return false
}

func (x *GetLatestCuratedPluginRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetLatestCuratedPluginRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetLatestCuratedPluginRequest) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *GetLatestCuratedPluginRequest) SetRevision(v uint32) {
	x.xxx_hidden_Revision = v
}

func (x *GetLatestCuratedPluginRequest) SetSupportsRemotePackages(v bool) {
	x.xxx_hidden_SupportsRemotePackages = v
}

type GetLatestCuratedPluginRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the plugin, i.e. "library".
	Owner string
	// The name of the plugin, i.e. "connect-go".
	Name string
	// Both version (semver-formatted) and revision are optional, which means
	// return the latest plugin.
	// If version is set, but revision is omitted, then return the latest
	// revision for that version.
	// If version and revision are both set, return specific plugin.
	// It is an error to set a revision without a corresponding version.
	Version  string
	Revision uint32
	// If true, will only return versions (and revisions) which support remote packages (registry_type is set).
	SupportsRemotePackages bool
}

func (b0 GetLatestCuratedPluginRequest_builder) Build() *GetLatestCuratedPluginRequest {
	m0 := &GetLatestCuratedPluginRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Revision = b.Revision
	x.xxx_hidden_SupportsRemotePackages = b.SupportsRemotePackages
	return m0
}

type GetLatestCuratedPluginResponse struct {
	state               protoimpl.MessageState            `protogen:"opaque.v1"`
	xxx_hidden_Plugin   *CuratedPlugin                    `protobuf:"bytes,1,opt,name=plugin,proto3"`
	xxx_hidden_Versions *[]*CuratedPluginVersionRevisions `protobuf:"bytes,2,rep,name=versions,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetLatestCuratedPluginResponse) Reset() {
	*x = GetLatestCuratedPluginResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLatestCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestCuratedPluginResponse) ProtoMessage() {}

func (x *GetLatestCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLatestCuratedPluginResponse) GetPlugin() *CuratedPlugin {
	if x != nil {
		return x.xxx_hidden_Plugin
	}
	return nil
}

func (x *GetLatestCuratedPluginResponse) GetVersions() []*CuratedPluginVersionRevisions {
	if x != nil {
		if x.xxx_hidden_Versions != nil {
			return *x.xxx_hidden_Versions
		}
	}
	return nil
}

func (x *GetLatestCuratedPluginResponse) SetPlugin(v *CuratedPlugin) {
	x.xxx_hidden_Plugin = v
}

func (x *GetLatestCuratedPluginResponse) SetVersions(v []*CuratedPluginVersionRevisions) {
	x.xxx_hidden_Versions = &v
}

func (x *GetLatestCuratedPluginResponse) HasPlugin() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Plugin != nil
}

func (x *GetLatestCuratedPluginResponse) ClearPlugin() {
	x.xxx_hidden_Plugin = nil
}

type GetLatestCuratedPluginResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Plugin *CuratedPlugin
	// versions is a semver-sorted list in descending order.
	Versions []*CuratedPluginVersionRevisions
}

func (b0 GetLatestCuratedPluginResponse_builder) Build() *GetLatestCuratedPluginResponse {
	m0 := &GetLatestCuratedPluginResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Plugin = b.Plugin
	x.xxx_hidden_Versions = &b.Versions
	return m0
}

type CuratedPluginVersionRevisions struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version   string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	xxx_hidden_Revisions []uint32               `protobuf:"varint,2,rep,packed,name=revisions,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *CuratedPluginVersionRevisions) Reset() {
	*x = CuratedPluginVersionRevisions{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPluginVersionRevisions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginVersionRevisions) ProtoMessage() {}

func (x *CuratedPluginVersionRevisions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CuratedPluginVersionRevisions) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *CuratedPluginVersionRevisions) GetRevisions() []uint32 {
	if x != nil {
		return x.xxx_hidden_Revisions
	}
	return nil
}

func (x *CuratedPluginVersionRevisions) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *CuratedPluginVersionRevisions) SetRevisions(v []uint32) {
	x.xxx_hidden_Revisions = v
}

type CuratedPluginVersionRevisions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Version string
	// revisions is a sorted list in descending order.
	Revisions []uint32
}

func (b0 CuratedPluginVersionRevisions_builder) Build() *CuratedPluginVersionRevisions {
	m0 := &CuratedPluginVersionRevisions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Revisions = b.Revisions
	return m0
}

// RuntimeLibrary describes the runtime library dependency of the generated code.
type GoConfig_RuntimeLibrary struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Module  string                 `protobuf:"bytes,1,opt,name=module,proto3"`
	xxx_hidden_Version string                 `protobuf:"bytes,2,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GoConfig_RuntimeLibrary) Reset() {
	*x = GoConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoConfig_RuntimeLibrary) ProtoMessage() {}

func (x *GoConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GoConfig_RuntimeLibrary) GetModule() string {
	if x != nil {
		return x.xxx_hidden_Module
	}
	return ""
}

func (x *GoConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GoConfig_RuntimeLibrary) SetModule(v string) {
	x.xxx_hidden_Module = v
}

func (x *GoConfig_RuntimeLibrary) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GoConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the runtime library module, i.e. "google.golang.org/protobuf".
	Module string
	// The version of the runtime library, i.e. "v1.27.1".
	Version string
}

func (b0 GoConfig_RuntimeLibrary_builder) Build() *GoConfig_RuntimeLibrary {
	m0 := &GoConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Module = b.Module
	x.xxx_hidden_Version = b.Version
	return m0
}

// RuntimeLibrary describes the runtime library dependency of the generated code.
type NPMConfig_RuntimeLibrary struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Package string                 `protobuf:"bytes,1,opt,name=package,proto3"`
	xxx_hidden_Version string                 `protobuf:"bytes,2,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *NPMConfig_RuntimeLibrary) Reset() {
	*x = NPMConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NPMConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NPMConfig_RuntimeLibrary) ProtoMessage() {}

func (x *NPMConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *NPMConfig_RuntimeLibrary) GetPackage() string {
	if x != nil {
		return x.xxx_hidden_Package
	}
	return ""
}

func (x *NPMConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *NPMConfig_RuntimeLibrary) SetPackage(v string) {
	x.xxx_hidden_Package = v
}

func (x *NPMConfig_RuntimeLibrary) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type NPMConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the runtime library package, i.e. "@grpc/grpc-js".
	Package string
	// The version of the runtime library, i.e. "^1.27.1".
	Version string
}

func (b0 NPMConfig_RuntimeLibrary_builder) Build() *NPMConfig_RuntimeLibrary {
	m0 := &NPMConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Package = b.Package
	x.xxx_hidden_Version = b.Version
	return m0
}

// RuntimeLibrary describes a runtime dependency of the generated code.
type MavenConfig_RuntimeLibrary struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_GroupId    string                 `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3"`
	xxx_hidden_ArtifactId string                 `protobuf:"bytes,2,opt,name=artifact_id,json=artifactId,proto3"`
	xxx_hidden_Version    string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_Classifier string                 `protobuf:"bytes,4,opt,name=classifier,proto3"`
	xxx_hidden_Extension  string                 `protobuf:"bytes,5,opt,name=extension,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *MavenConfig_RuntimeLibrary) Reset() {
	*x = MavenConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_RuntimeLibrary) ProtoMessage() {}

func (x *MavenConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MavenConfig_RuntimeLibrary) GetGroupId() string {
	if x != nil {
		return x.xxx_hidden_GroupId
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetArtifactId() string {
	if x != nil {
		return x.xxx_hidden_ArtifactId
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetClassifier() string {
	if x != nil {
		return x.xxx_hidden_Classifier
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetExtension() string {
	if x != nil {
		return x.xxx_hidden_Extension
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) SetGroupId(v string) {
	x.xxx_hidden_GroupId = v
}

func (x *MavenConfig_RuntimeLibrary) SetArtifactId(v string) {
	x.xxx_hidden_ArtifactId = v
}

func (x *MavenConfig_RuntimeLibrary) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *MavenConfig_RuntimeLibrary) SetClassifier(v string) {
	x.xxx_hidden_Classifier = v
}

func (x *MavenConfig_RuntimeLibrary) SetExtension(v string) {
	x.xxx_hidden_Extension = v
}

type MavenConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	GroupId    string
	ArtifactId string
	Version    string
	Classifier string
	Extension  string
}

func (b0 MavenConfig_RuntimeLibrary_builder) Build() *MavenConfig_RuntimeLibrary {
	m0 := &MavenConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_GroupId = b.GroupId
	x.xxx_hidden_ArtifactId = b.ArtifactId
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Classifier = b.Classifier
	x.xxx_hidden_Extension = b.Extension
	return m0
}

// CompilerConfig contains configuration for the Java and/or Kotlin compiler used when compiling the generated code.
type MavenConfig_CompilerConfig struct {
	state             protoimpl.MessageState            `protogen:"opaque.v1"`
	xxx_hidden_Java   *MavenConfig_CompilerJavaConfig   `protobuf:"bytes,1,opt,name=java,proto3"`
	xxx_hidden_Kotlin *MavenConfig_CompilerKotlinConfig `protobuf:"bytes,2,opt,name=kotlin,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *MavenConfig_CompilerConfig) Reset() {
	*x = MavenConfig_CompilerConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_CompilerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_CompilerConfig) ProtoMessage() {}

func (x *MavenConfig_CompilerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MavenConfig_CompilerConfig) GetJava() *MavenConfig_CompilerJavaConfig {
	if x != nil {
		return x.xxx_hidden_Java
	}
	return nil
}

func (x *MavenConfig_CompilerConfig) GetKotlin() *MavenConfig_CompilerKotlinConfig {
	if x != nil {
		return x.xxx_hidden_Kotlin
	}
	return nil
}

func (x *MavenConfig_CompilerConfig) SetJava(v *MavenConfig_CompilerJavaConfig) {
	x.xxx_hidden_Java = v
}

func (x *MavenConfig_CompilerConfig) SetKotlin(v *MavenConfig_CompilerKotlinConfig) {
	x.xxx_hidden_Kotlin = v
}

func (x *MavenConfig_CompilerConfig) HasJava() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Java != nil
}

func (x *MavenConfig_CompilerConfig) HasKotlin() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Kotlin != nil
}

func (x *MavenConfig_CompilerConfig) ClearJava() {
	x.xxx_hidden_Java = nil
}

func (x *MavenConfig_CompilerConfig) ClearKotlin() {
	x.xxx_hidden_Kotlin = nil
}

type MavenConfig_CompilerConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Java   *MavenConfig_CompilerJavaConfig
	Kotlin *MavenConfig_CompilerKotlinConfig
}

func (b0 MavenConfig_CompilerConfig_builder) Build() *MavenConfig_CompilerConfig {
	m0 := &MavenConfig_CompilerConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Java = b.Java
	x.xxx_hidden_Kotlin = b.Kotlin
	return m0
}

// CompilerJavaConfig contains settings for the Java compiler.
type MavenConfig_CompilerJavaConfig struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Encoding string                 `protobuf:"bytes,1,opt,name=encoding,proto3"`
	xxx_hidden_Release  int32                  `protobuf:"varint,2,opt,name=release,proto3"`
	xxx_hidden_Source   int32                  `protobuf:"varint,3,opt,name=source,proto3"`
	xxx_hidden_Target   int32                  `protobuf:"varint,4,opt,name=target,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *MavenConfig_CompilerJavaConfig) Reset() {
	*x = MavenConfig_CompilerJavaConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_CompilerJavaConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_CompilerJavaConfig) ProtoMessage() {}

func (x *MavenConfig_CompilerJavaConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MavenConfig_CompilerJavaConfig) GetEncoding() string {
	if x != nil {
		return x.xxx_hidden_Encoding
	}
	return ""
}

func (x *MavenConfig_CompilerJavaConfig) GetRelease() int32 {
	if x != nil {
		return x.xxx_hidden_Release
	}
	return 0
}

func (x *MavenConfig_CompilerJavaConfig) GetSource() int32 {
	if x != nil {
		return x.xxx_hidden_Source
	}
	return 0
}

func (x *MavenConfig_CompilerJavaConfig) GetTarget() int32 {
	if x != nil {
		return x.xxx_hidden_Target
	}
	return 0
}

func (x *MavenConfig_CompilerJavaConfig) SetEncoding(v string) {
	x.xxx_hidden_Encoding = v
}

func (x *MavenConfig_CompilerJavaConfig) SetRelease(v int32) {
	x.xxx_hidden_Release = v
}

func (x *MavenConfig_CompilerJavaConfig) SetSource(v int32) {
	x.xxx_hidden_Source = v
}

func (x *MavenConfig_CompilerJavaConfig) SetTarget(v int32) {
	x.xxx_hidden_Target = v
}

type MavenConfig_CompilerJavaConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// File encoding (default: UTF-8).
	Encoding string
	// Release version (default: 8).
	Release int32
	// Source version (default: 8).
	Source int32
	// Target version (default: 8).
	Target int32
}

func (b0 MavenConfig_CompilerJavaConfig_builder) Build() *MavenConfig_CompilerJavaConfig {
	m0 := &MavenConfig_CompilerJavaConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Encoding = b.Encoding
	x.xxx_hidden_Release = b.Release
	x.xxx_hidden_Source = b.Source
	x.xxx_hidden_Target = b.Target
	return m0
}

// CompilerKotlinConfig contains settings for the Kotlin compiler.
type MavenConfig_CompilerKotlinConfig struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version         string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	xxx_hidden_ApiVersion      string                 `protobuf:"bytes,2,opt,name=api_version,json=apiVersion,proto3"`
	xxx_hidden_JvmTarget       string                 `protobuf:"bytes,3,opt,name=jvm_target,json=jvmTarget,proto3"`
	xxx_hidden_LanguageVersion string                 `protobuf:"bytes,4,opt,name=language_version,json=languageVersion,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *MavenConfig_CompilerKotlinConfig) Reset() {
	*x = MavenConfig_CompilerKotlinConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_CompilerKotlinConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_CompilerKotlinConfig) ProtoMessage() {}

func (x *MavenConfig_CompilerKotlinConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MavenConfig_CompilerKotlinConfig) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) GetApiVersion() string {
	if x != nil {
		return x.xxx_hidden_ApiVersion
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) GetJvmTarget() string {
	if x != nil {
		return x.xxx_hidden_JvmTarget
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) GetLanguageVersion() string {
	if x != nil {
		return x.xxx_hidden_LanguageVersion
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *MavenConfig_CompilerKotlinConfig) SetApiVersion(v string) {
	x.xxx_hidden_ApiVersion = v
}

func (x *MavenConfig_CompilerKotlinConfig) SetJvmTarget(v string) {
	x.xxx_hidden_JvmTarget = v
}

func (x *MavenConfig_CompilerKotlinConfig) SetLanguageVersion(v string) {
	x.xxx_hidden_LanguageVersion = v
}

type MavenConfig_CompilerKotlinConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Version of the Kotlin compiler used to compile the generated code.
	Version string
	// Version of the Kotlin API to target.
	ApiVersion string
	// Target version of the JVM bytecode (default: 1.8).
	JvmTarget string
	// Kotlin language version used for source compatibility.
	LanguageVersion string
}

func (b0 MavenConfig_CompilerKotlinConfig_builder) Build() *MavenConfig_CompilerKotlinConfig {
	m0 := &MavenConfig_CompilerKotlinConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_ApiVersion = b.ApiVersion
	x.xxx_hidden_JvmTarget = b.JvmTarget
	x.xxx_hidden_LanguageVersion = b.LanguageVersion
	return m0
}

// RuntimeConfig allows configuring additional runtimes (like the 'lite' runtime).
// They can use different runtime dependencies and plugin options.
type MavenConfig_RuntimeConfig struct {
	state                       protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_Name             string                         `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_RuntimeLibraries *[]*MavenConfig_RuntimeLibrary `protobuf:"bytes,2,rep,name=runtime_libraries,json=runtimeLibraries,proto3"`
	xxx_hidden_Options          []string                       `protobuf:"bytes,3,rep,name=options,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *MavenConfig_RuntimeConfig) Reset() {
	*x = MavenConfig_RuntimeConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_RuntimeConfig) ProtoMessage() {}

func (x *MavenConfig_RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MavenConfig_RuntimeConfig) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *MavenConfig_RuntimeConfig) GetRuntimeLibraries() []*MavenConfig_RuntimeLibrary {
	if x != nil {
		if x.xxx_hidden_RuntimeLibraries != nil {
			return *x.xxx_hidden_RuntimeLibraries
		}
	}
	return nil
}

func (x *MavenConfig_RuntimeConfig) GetOptions() []string {
	if x != nil {
		return x.xxx_hidden_Options
	}
	return nil
}

func (x *MavenConfig_RuntimeConfig) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *MavenConfig_RuntimeConfig) SetRuntimeLibraries(v []*MavenConfig_RuntimeLibrary) {
	x.xxx_hidden_RuntimeLibraries = &v
}

func (x *MavenConfig_RuntimeConfig) SetOptions(v []string) {
	x.xxx_hidden_Options = v
}

type MavenConfig_RuntimeConfig_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name             string
	RuntimeLibraries []*MavenConfig_RuntimeLibrary
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string
}

func (b0 MavenConfig_RuntimeConfig_builder) Build() *MavenConfig_RuntimeConfig {
	m0 := &MavenConfig_RuntimeConfig{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_RuntimeLibraries = &b.RuntimeLibraries
	x.xxx_hidden_Options = b.Options
	return m0
}

// RuntimeLibrary describes a NuGet package dependency of the generated code.
// Ref: https://learn.microsoft.com/en-us/dotnet/core/tools/dependencies#the-packagereference-element
type NugetConfig_RuntimeLibrary struct {
	state                       protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_Name             string                  `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Version          string                  `protobuf:"bytes,2,opt,name=version,proto3"`
	xxx_hidden_TargetFrameworks []DotnetTargetFramework `protobuf:"varint,3,rep,packed,name=target_frameworks,json=targetFrameworks,proto3,enum=buf.alpha.registry.v1alpha1.DotnetTargetFramework"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *NugetConfig_RuntimeLibrary) Reset() {
	*x = NugetConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NugetConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NugetConfig_RuntimeLibrary) ProtoMessage() {}

func (x *NugetConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *NugetConfig_RuntimeLibrary) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *NugetConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *NugetConfig_RuntimeLibrary) GetTargetFrameworks() []DotnetTargetFramework {
	if x != nil {
		return x.xxx_hidden_TargetFrameworks
	}
	return nil
}

func (x *NugetConfig_RuntimeLibrary) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *NugetConfig_RuntimeLibrary) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *NugetConfig_RuntimeLibrary) SetTargetFrameworks(v []DotnetTargetFramework) {
	x.xxx_hidden_TargetFrameworks = v
}

type NugetConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the NuGet package (also known as the package ID).
	Name string
	// The version of the NuGet package (supports ranges).
	// Ref: https://learn.microsoft.com/en-us/nuget/concepts/package-versioning#version-ranges
	Version string
	// Optional target frameworks. If specified, these dependencies will be
	// conditionally added when building for the specified target framework.
	TargetFrameworks []DotnetTargetFramework
}

func (b0 NugetConfig_RuntimeLibrary_builder) Build() *NugetConfig_RuntimeLibrary {
	m0 := &NugetConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_TargetFrameworks = b.TargetFrameworks
	return m0
}

// RuntimeLibrary describes a runtime library dependency of the generated code.
type SwiftConfig_RuntimeLibrary struct {
	state                    protoimpl.MessageState                  `protogen:"opaque.v1"`
	xxx_hidden_Source        string                                  `protobuf:"bytes,1,opt,name=source,proto3"`
	xxx_hidden_Package       string                                  `protobuf:"bytes,2,opt,name=package,proto3"`
	xxx_hidden_Version       string                                  `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_Products      []string                                `protobuf:"bytes,4,rep,name=products,proto3"`
	xxx_hidden_Platforms     *[]*SwiftConfig_RuntimeLibrary_Platform `protobuf:"bytes,5,rep,name=platforms,proto3"`
	xxx_hidden_SwiftVersions []string                                `protobuf:"bytes,6,rep,name=swift_versions,json=swiftVersions,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *SwiftConfig_RuntimeLibrary) Reset() {
	*x = SwiftConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwiftConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwiftConfig_RuntimeLibrary) ProtoMessage() {}

func (x *SwiftConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SwiftConfig_RuntimeLibrary) GetSource() string {
	if x != nil {
		return x.xxx_hidden_Source
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary) GetPackage() string {
	if x != nil {
		return x.xxx_hidden_Package
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary) GetProducts() []string {
	if x != nil {
		return x.xxx_hidden_Products
	}
	return nil
}

func (x *SwiftConfig_RuntimeLibrary) GetPlatforms() []*SwiftConfig_RuntimeLibrary_Platform {
	if x != nil {
		if x.xxx_hidden_Platforms != nil {
			return *x.xxx_hidden_Platforms
		}
	}
	return nil
}

func (x *SwiftConfig_RuntimeLibrary) GetSwiftVersions() []string {
	if x != nil {
		return x.xxx_hidden_SwiftVersions
	}
	return nil
}

func (x *SwiftConfig_RuntimeLibrary) SetSource(v string) {
	x.xxx_hidden_Source = v
}

func (x *SwiftConfig_RuntimeLibrary) SetPackage(v string) {
	x.xxx_hidden_Package = v
}

func (x *SwiftConfig_RuntimeLibrary) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *SwiftConfig_RuntimeLibrary) SetProducts(v []string) {
	x.xxx_hidden_Products = v
}

func (x *SwiftConfig_RuntimeLibrary) SetPlatforms(v []*SwiftConfig_RuntimeLibrary_Platform) {
	x.xxx_hidden_Platforms = &v
}

func (x *SwiftConfig_RuntimeLibrary) SetSwiftVersions(v []string) {
	x.xxx_hidden_SwiftVersions = v
}

type SwiftConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The source of the runtime library package, e.g. https://github.com/apple/swift-protobuf.git.
	Source string
	// The name of the runtime library package, e.g. "swift-protobuf".
	Package string
	// The version of the runtime library, e.g. "1.21.0".
	Version string
	// The products exported by the runtime library, e.g. "SwiftProtobuf".
	Products []string
	// The minimum compatible platform versions of the runtime library.
	Platforms []*SwiftConfig_RuntimeLibrary_Platform
	// The supported Swift language versions of the runtime library, e.g. ".v5".
	SwiftVersions []string
}

func (b0 SwiftConfig_RuntimeLibrary_builder) Build() *SwiftConfig_RuntimeLibrary {
	m0 := &SwiftConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Source = b.Source
	x.xxx_hidden_Package = b.Package
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Products = b.Products
	x.xxx_hidden_Platforms = &b.Platforms
	x.xxx_hidden_SwiftVersions = b.SwiftVersions
	return m0
}

// The minimum compatible platform versions of the runtime library.
type SwiftConfig_RuntimeLibrary_Platform struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name    SwiftPlatformType      `protobuf:"varint,1,opt,name=name,proto3,enum=buf.alpha.registry.v1alpha1.SwiftPlatformType"`
	xxx_hidden_Version string                 `protobuf:"bytes,2,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *SwiftConfig_RuntimeLibrary_Platform) Reset() {
	*x = SwiftConfig_RuntimeLibrary_Platform{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwiftConfig_RuntimeLibrary_Platform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwiftConfig_RuntimeLibrary_Platform) ProtoMessage() {}

func (x *SwiftConfig_RuntimeLibrary_Platform) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SwiftConfig_RuntimeLibrary_Platform) GetName() SwiftPlatformType {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return SwiftPlatformType_SWIFT_PLATFORM_TYPE_UNSPECIFIED
}

func (x *SwiftConfig_RuntimeLibrary_Platform) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary_Platform) SetName(v SwiftPlatformType) {
	x.xxx_hidden_Name = v
}

func (x *SwiftConfig_RuntimeLibrary_Platform) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type SwiftConfig_RuntimeLibrary_Platform_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the platform.
	Name SwiftPlatformType
	// The minimum compatible version of the platform.
	Version string
}

func (b0 SwiftConfig_RuntimeLibrary_Platform_builder) Build() *SwiftConfig_RuntimeLibrary_Platform {
	m0 := &SwiftConfig_RuntimeLibrary_Platform{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	return m0
}

type PythonConfig_RuntimeLibrary struct {
	state                              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_DependencySpecification string                 `protobuf:"bytes,1,opt,name=dependency_specification,json=dependencySpecification,proto3"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *PythonConfig_RuntimeLibrary) Reset() {
	*x = PythonConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonConfig_RuntimeLibrary) ProtoMessage() {}

func (x *PythonConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PythonConfig_RuntimeLibrary) GetDependencySpecification() string {
	if x != nil {
		return x.xxx_hidden_DependencySpecification
	}
	return ""
}

func (x *PythonConfig_RuntimeLibrary) SetDependencySpecification(v string) {
	x.xxx_hidden_DependencySpecification = v
}

type PythonConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// dependency_specification is a PEP 508 Dependency Specification.
	// Ref: https://peps.python.org/pep-0508/
	DependencySpecification string
}

func (b0 PythonConfig_RuntimeLibrary_builder) Build() *PythonConfig_RuntimeLibrary {
	m0 := &PythonConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_DependencySpecification = b.DependencySpecification
	return m0
}

// RuntimeLibrary specifies a runtime dependency for a generated crate.
// It is the subset of a full Cargo dependency specification, which contains
// fields that are irrelevant for Generated SDKs.
// Ref: https://doc.rust-lang.org/cargo/reference/specifying-dependencies.html
type CargoConfig_RuntimeLibrary struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name               string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_VersionRequirement string                 `protobuf:"bytes,2,opt,name=version_requirement,json=versionRequirement,proto3"`
	xxx_hidden_DefaultFeatures    bool                   `protobuf:"varint,3,opt,name=default_features,json=defaultFeatures,proto3"`
	xxx_hidden_Features           []string               `protobuf:"bytes,4,rep,name=features,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *CargoConfig_RuntimeLibrary) Reset() {
	*x = CargoConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CargoConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CargoConfig_RuntimeLibrary) ProtoMessage() {}

func (x *CargoConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CargoConfig_RuntimeLibrary) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CargoConfig_RuntimeLibrary) GetVersionRequirement() string {
	if x != nil {
		return x.xxx_hidden_VersionRequirement
	}
	return ""
}

func (x *CargoConfig_RuntimeLibrary) GetDefaultFeatures() bool {
	if x != nil {
		return x.xxx_hidden_DefaultFeatures
	}
	return false
}

func (x *CargoConfig_RuntimeLibrary) GetFeatures() []string {
	if x != nil {
		return x.xxx_hidden_Features
	}
	return nil
}

func (x *CargoConfig_RuntimeLibrary) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CargoConfig_RuntimeLibrary) SetVersionRequirement(v string) {
	x.xxx_hidden_VersionRequirement = v
}

func (x *CargoConfig_RuntimeLibrary) SetDefaultFeatures(v bool) {
	x.xxx_hidden_DefaultFeatures = v
}

func (x *CargoConfig_RuntimeLibrary) SetFeatures(v []string) {
	x.xxx_hidden_Features = v
}

type CargoConfig_RuntimeLibrary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// name specifies the name of the dependency.
	Name string
	// version_requirement specifies the version requirement of the dependency.
	VersionRequirement string
	// default_features specifies whether or not default features will be enabled for the dependency.
	DefaultFeatures bool
	// features specifies the features enabled for the dependency.
	Features []string
}

func (b0 CargoConfig_RuntimeLibrary_builder) Build() *CargoConfig_RuntimeLibrary {
	m0 := &CargoConfig_RuntimeLibrary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_VersionRequirement = b.VersionRequirement
	x.xxx_hidden_DefaultFeatures = b.DefaultFeatures
	x.xxx_hidden_Features = b.Features
	return m0
}

var File_buf_alpha_registry_v1alpha1_plugin_curation_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc = "" +
	"\n" +
	"1buf/alpha/registry/v1alpha1/plugin_curation.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a\x1ebuf/alpha/image/v1/image.proto\x1a%google/protobuf/compiler/plugin.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xfb\x01\n" +
	"\bGoConfig\x12a\n" +
	"\x11runtime_libraries\x18\x01 \x03(\v24.buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibraryR\x10runtimeLibraries\x12'\n" +
	"\x0fminimum_version\x18\x02 \x01(\tR\x0eminimumVersion\x12\x1f\n" +
	"\vbase_plugin\x18\x03 \x01(\tR\n" +
	"basePlugin\x1aB\n" +
	"\x0eRuntimeLibrary\x12\x16\n" +
	"\x06module\x18\x01 \x01(\tR\x06module\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\"\xc2\x02\n" +
	"\tNPMConfig\x12b\n" +
	"\x11runtime_libraries\x18\x01 \x03(\v25.buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibraryR\x10runtimeLibraries\x12;\n" +
	"\x1arewrite_import_path_suffix\x18\x02 \x01(\tR\x17rewriteImportPathSuffix\x12N\n" +
	"\fimport_style\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.NPMImportStyleR\vimportStyle\x1aD\n" +
	"\x0eRuntimeLibrary\x12\x18\n" +
	"\apackage\x18\x01 \x01(\tR\apackage\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\"\xd3\b\n" +
	"\vMavenConfig\x12d\n" +
	"\x11runtime_libraries\x18\x01 \x03(\v27.buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibraryR\x10runtimeLibraries\x12S\n" +
	"\bcompiler\x18\x02 \x01(\v27.buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfigR\bcompiler\x12g\n" +
	"\x13additional_runtimes\x18\x03 \x03(\v26.buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfigR\x12additionalRuntimes\x1a\xa4\x01\n" +
	"\x0eRuntimeLibrary\x12\x19\n" +
	"\bgroup_id\x18\x01 \x01(\tR\agroupId\x12\x1f\n" +
	"\vartifact_id\x18\x02 \x01(\tR\n" +
	"artifactId\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1e\n" +
	"\n" +
	"classifier\x18\x04 \x01(\tR\n" +
	"classifier\x12\x1c\n" +
	"\textension\x18\x05 \x01(\tR\textension\x1a\xb8\x01\n" +
	"\x0eCompilerConfig\x12O\n" +
	"\x04java\x18\x01 \x01(\v2;.buf.alpha.registry.v1alpha1.MavenConfig.CompilerJavaConfigR\x04java\x12U\n" +
	"\x06kotlin\x18\x02 \x01(\v2=.buf.alpha.registry.v1alpha1.MavenConfig.CompilerKotlinConfigR\x06kotlin\x1az\n" +
	"\x12CompilerJavaConfig\x12\x1a\n" +
	"\bencoding\x18\x01 \x01(\tR\bencoding\x12\x18\n" +
	"\arelease\x18\x02 \x01(\x05R\arelease\x12\x16\n" +
	"\x06source\x18\x03 \x01(\x05R\x06source\x12\x16\n" +
	"\x06target\x18\x04 \x01(\x05R\x06target\x1a\x9b\x01\n" +
	"\x14CompilerKotlinConfig\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12\x1f\n" +
	"\vapi_version\x18\x02 \x01(\tR\n" +
	"apiVersion\x12\x1d\n" +
	"\n" +
	"jvm_target\x18\x03 \x01(\tR\tjvmTarget\x12)\n" +
	"\x10language_version\x18\x04 \x01(\tR\x0flanguageVersion\x1a\xa3\x01\n" +
	"\rRuntimeConfig\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12d\n" +
	"\x11runtime_libraries\x18\x02 \x03(\v27.buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibraryR\x10runtimeLibraries\x12\x18\n" +
	"\aoptions\x18\x03 \x03(\tR\aoptions\"\xf6\x02\n" +
	"\vNugetConfig\x12_\n" +
	"\x11target_frameworks\x18\x01 \x03(\x0e22.buf.alpha.registry.v1alpha1.DotnetTargetFrameworkR\x10targetFrameworks\x12d\n" +
	"\x11runtime_libraries\x18\x02 \x03(\v27.buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibraryR\x10runtimeLibraries\x1a\x9f\x01\n" +
	"\x0eRuntimeLibrary\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12_\n" +
	"\x11target_frameworks\x18\x03 \x03(\x0e22.buf.alpha.registry.v1alpha1.DotnetTargetFrameworkR\x10targetFrameworks\"\r\n" +
	"\vCmakeConfig\"\xdf\x03\n" +
	"\vSwiftConfig\x12d\n" +
	"\x11runtime_libraries\x18\x01 \x03(\v27.buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibraryR\x10runtimeLibraries\x1a\xe9\x02\n" +
	"\x0eRuntimeLibrary\x12\x16\n" +
	"\x06source\x18\x01 \x01(\tR\x06source\x12\x18\n" +
	"\apackage\x18\x02 \x01(\tR\apackage\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1a\n" +
	"\bproducts\x18\x04 \x03(\tR\bproducts\x12^\n" +
	"\tplatforms\x18\x05 \x03(\v2@.buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.PlatformR\tplatforms\x12%\n" +
	"\x0eswift_versions\x18\x06 \x03(\tR\rswiftVersions\x1ah\n" +
	"\bPlatform\x12B\n" +
	"\x04name\x18\x01 \x01(\x0e2..buf.alpha.registry.v1alpha1.SwiftPlatformTypeR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\"\xbe\x02\n" +
	"\fPythonConfig\x12e\n" +
	"\x11runtime_libraries\x18\x01 \x03(\v28.buf.alpha.registry.v1alpha1.PythonConfig.RuntimeLibraryR\x10runtimeLibraries\x12'\n" +
	"\x0frequires_python\x18\x02 \x01(\tR\x0erequiresPython\x12Q\n" +
	"\fpackage_type\x18\x03 \x01(\x0e2..buf.alpha.registry.v1alpha1.PythonPackageTypeR\vpackageType\x1aK\n" +
	"\x0eRuntimeLibrary\x129\n" +
	"\x18dependency_specification\x18\x01 \x01(\tR\x17dependencySpecification\"\xb5\x02\n" +
	"\vCargoConfig\x12!\n" +
	"\frust_version\x18\x01 \x01(\tR\vrustVersion\x12d\n" +
	"\x11runtime_libraries\x18\x02 \x03(\v27.buf.alpha.registry.v1alpha1.CargoConfig.RuntimeLibraryR\x10runtimeLibraries\x1a\x9c\x01\n" +
	"\x0eRuntimeLibrary\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12/\n" +
	"\x13version_requirement\x18\x02 \x01(\tR\x12versionRequirement\x12)\n" +
	"\x10default_features\x18\x03 \x01(\bR\x0fdefaultFeatures\x12\x1a\n" +
	"\bfeatures\x18\x04 \x03(\tR\bfeatures\"\xaf\x05\n" +
	"\x0eRegistryConfig\x12D\n" +
	"\tgo_config\x18\x01 \x01(\v2%.buf.alpha.registry.v1alpha1.GoConfigH\x00R\bgoConfig\x12G\n" +
	"\n" +
	"npm_config\x18\x02 \x01(\v2&.buf.alpha.registry.v1alpha1.NPMConfigH\x00R\tnpmConfig\x12M\n" +
	"\fmaven_config\x18\x03 \x01(\v2(.buf.alpha.registry.v1alpha1.MavenConfigH\x00R\vmavenConfig\x12M\n" +
	"\fswift_config\x18\x04 \x01(\v2(.buf.alpha.registry.v1alpha1.SwiftConfigH\x00R\vswiftConfig\x12P\n" +
	"\rpython_config\x18\x05 \x01(\v2).buf.alpha.registry.v1alpha1.PythonConfigH\x00R\fpythonConfig\x12M\n" +
	"\fcargo_config\x18\x06 \x01(\v2(.buf.alpha.registry.v1alpha1.CargoConfigH\x00R\vcargoConfig\x12M\n" +
	"\fnuget_config\x18\a \x01(\v2(.buf.alpha.registry.v1alpha1.NugetConfigH\x00R\vnugetConfig\x12M\n" +
	"\fcmake_config\x18\b \x01(\v2(.buf.alpha.registry.v1alpha1.CmakeConfigH\x00R\vcmakeConfig\x12\x18\n" +
	"\aoptions\x18\n" +
	" \x03(\tR\aoptionsB\x11\n" +
	"\x0fregistry_configJ\x04\b\t\x10\n" +
	"\"x\n" +
	"\x16CuratedPluginReference\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1a\n" +
	"\brevision\x18\x04 \x01(\rR\brevision\"\xb3\b\n" +
	"\rCuratedPlugin\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x14\n" +
	"\x05owner\x18\x02 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12T\n" +
	"\rregistry_type\x18\x04 \x01(\x0e2/.buf.alpha.registry.v1alpha1.PluginRegistryTypeR\fregistryType\x12\x18\n" +
	"\aversion\x18\x05 \x01(\tR\aversion\x124\n" +
	"\x16container_image_digest\x18\x06 \x01(\tR\x14containerImageDigest\x12;\n" +
	"\vcreate_time\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12W\n" +
	"\fdependencies\x18\t \x03(\v23.buf.alpha.registry.v1alpha1.CuratedPluginReferenceR\fdependencies\x12\x1d\n" +
	"\n" +
	"source_url\x18\n" +
	" \x01(\tR\tsourceUrl\x12 \n" +
	"\vdescription\x18\v \x01(\tR\vdescription\x12T\n" +
	"\x0fregistry_config\x18\f \x01(\v2+.buf.alpha.registry.v1alpha1.RegistryConfigR\x0eregistryConfig\x12\x1a\n" +
	"\brevision\x18\r \x01(\rR\brevision\x12V\n" +
	"\x10output_languages\x18\x0e \x03(\x0e2+.buf.alpha.registry.v1alpha1.PluginLanguageR\x0foutputLanguages\x12&\n" +
	"\x0fspdx_license_id\x18\x0f \x01(\tR\rspdxLicenseId\x12\x1f\n" +
	"\vlicense_url\x18\x10 \x01(\tR\n" +
	"licenseUrl\x12\x1a\n" +
	"\bverified\x18\x11 \x01(\bR\bverified\x12T\n" +
	"\n" +
	"visibility\x18\x12 \x01(\x0e24.buf.alpha.registry.v1alpha1.CuratedPluginVisibilityR\n" +
	"visibility\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x13 \x01(\bR\n" +
	"deprecated\x12/\n" +
	"\x13deprecation_message\x18\x14 \x01(\tR\x12deprecationMessage\x122\n" +
	"\x15integration_guide_url\x18\x15 \x01(\tR\x13integrationGuideUrl\x12\x10\n" +
	"\x03doc\x18\x16 \x01(\tR\x03doc\x12O\n" +
	"\vcollections\x18\x17 \x03(\v2-.buf.alpha.registry.v1alpha1.PluginCollectionR\vcollections\"&\n" +
	"\x10PluginCollection\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"\xfa\x01\n" +
	"\x13GenerateCodeRequest\x12/\n" +
	"\x05image\x18\x01 \x01(\v2\x19.buf.alpha.image.v1.ImageR\x05image\x12P\n" +
	"\brequests\x18\x02 \x03(\v24.buf.alpha.registry.v1alpha1.PluginGenerationRequestR\brequests\x12'\n" +
	"\x0finclude_imports\x18\x03 \x01(\bR\x0eincludeImports\x127\n" +
	"\x18include_well_known_types\x18\x04 \x01(\bR\x15includeWellKnownTypes\"k\n" +
	"\x14GenerateCodeResponse\x12S\n" +
	"\tresponses\x18\x01 \x03(\v25.buf.alpha.registry.v1alpha1.PluginGenerationResponseR\tresponses\"\xb0\x02\n" +
	"\x17PluginGenerationRequest\x12^\n" +
	"\x10plugin_reference\x18\x01 \x01(\v23.buf.alpha.registry.v1alpha1.CuratedPluginReferenceR\x0fpluginReference\x12\x18\n" +
	"\aoptions\x18\x02 \x03(\tR\aoptions\x12,\n" +
	"\x0finclude_imports\x18\x03 \x01(\bH\x00R\x0eincludeImports\x88\x01\x01\x12<\n" +
	"\x18include_well_known_types\x18\x04 \x01(\bH\x01R\x15includeWellKnownTypes\x88\x01\x01B\x12\n" +
	"\x10_include_importsB\x1b\n" +
	"\x19_include_well_known_types\"g\n" +
	"\x18PluginGenerationResponse\x12K\n" +
	"\bresponse\x18\x01 \x01(\v2/.google.protobuf.compiler.CodeGeneratorResponseR\bresponse\"`\n" +
	"\x1aDeleteCuratedPluginRequest\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\"\x1d\n" +
	"\x1bDeleteCuratedPluginResponse\"\xc3\x06\n" +
	"\x1aCreateCuratedPluginRequest\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12T\n" +
	"\rregistry_type\x18\x03 \x01(\x0e2/.buf.alpha.registry.v1alpha1.PluginRegistryTypeR\fregistryType\x12\x18\n" +
	"\aversion\x18\x04 \x01(\tR\aversion\x124\n" +
	"\x16container_image_digest\x18\x05 \x01(\tR\x14containerImageDigest\x12W\n" +
	"\fdependencies\x18\a \x03(\v23.buf.alpha.registry.v1alpha1.CuratedPluginReferenceR\fdependencies\x12\x1d\n" +
	"\n" +
	"source_url\x18\b \x01(\tR\tsourceUrl\x12 \n" +
	"\vdescription\x18\t \x01(\tR\vdescription\x12T\n" +
	"\x0fregistry_config\x18\f \x01(\v2+.buf.alpha.registry.v1alpha1.RegistryConfigR\x0eregistryConfig\x12\x1a\n" +
	"\brevision\x18\r \x01(\rR\brevision\x12V\n" +
	"\x10output_languages\x18\x0e \x03(\x0e2+.buf.alpha.registry.v1alpha1.PluginLanguageR\x0foutputLanguages\x12&\n" +
	"\x0fspdx_license_id\x18\x0f \x01(\tR\rspdxLicenseId\x12\x1f\n" +
	"\vlicense_url\x18\x10 \x01(\tR\n" +
	"licenseUrl\x12T\n" +
	"\n" +
	"visibility\x18\x11 \x01(\x0e24.buf.alpha.registry.v1alpha1.CuratedPluginVisibilityR\n" +
	"visibility\x122\n" +
	"\x15integration_guide_url\x18\x12 \x01(\tR\x13integrationGuideUrl\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x13 \x01(\bR\n" +
	"deprecated\"o\n" +
	"\x1bCreateCuratedPluginResponse\x12P\n" +
	"\rconfiguration\x18\x01 \x01(\v2*.buf.alpha.registry.v1alpha1.CuratedPluginR\rconfiguration\"\xda\x01\n" +
	"\x19ListCuratedPluginsRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\x128\n" +
	"\x18supports_remote_packages\x18\x04 \x01(\bR\x16supportsRemotePackages\x12-\n" +
	"\x12include_deprecated\x18\x05 \x01(\bR\x11includeDeprecated\"\x8a\x01\n" +
	"\x1aListCuratedPluginsResponse\x12D\n" +
	"\aplugins\x18\x01 \x03(\v2*.buf.alpha.registry.v1alpha1.CuratedPluginR\aplugins\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xb9\x01\n" +
	"\x1dGetLatestCuratedPluginRequest\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1a\n" +
	"\brevision\x18\x04 \x01(\rR\brevision\x128\n" +
	"\x18supports_remote_packages\x18\x05 \x01(\bR\x16supportsRemotePackages\"\xbc\x01\n" +
	"\x1eGetLatestCuratedPluginResponse\x12B\n" +
	"\x06plugin\x18\x01 \x01(\v2*.buf.alpha.registry.v1alpha1.CuratedPluginR\x06plugin\x12V\n" +
	"\bversions\x18\x02 \x03(\v2:.buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisionsR\bversions\"W\n" +
	"\x1dCuratedPluginVersionRevisions\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12\x1c\n" +
	"\trevisions\x18\x02 \x03(\rR\trevisions*\x91\x01\n" +
	"\x17CuratedPluginVisibility\x12)\n" +
	"%CURATED_PLUGIN_VISIBILITY_UNSPECIFIED\x10\x00\x12$\n" +
	" CURATED_PLUGIN_VISIBILITY_PUBLIC\x10\x01\x12%\n" +
	"!CURATED_PLUGIN_VISIBILITY_PRIVATE\x10\x02*\xda\x02\n" +
	"\x12PluginRegistryType\x12$\n" +
	" PLUGIN_REGISTRY_TYPE_UNSPECIFIED\x10\x00\x12\x1b\n" +
	"\x17PLUGIN_REGISTRY_TYPE_GO\x10\x01\x12\x1c\n" +
	"\x18PLUGIN_REGISTRY_TYPE_NPM\x10\x02\x12\x1e\n" +
	"\x1aPLUGIN_REGISTRY_TYPE_MAVEN\x10\x03\x12\x1e\n" +
	"\x1aPLUGIN_REGISTRY_TYPE_SWIFT\x10\x04\x12\x1f\n" +
	"\x1bPLUGIN_REGISTRY_TYPE_PYTHON\x10\x05\x12\x1e\n" +
	"\x1aPLUGIN_REGISTRY_TYPE_CARGO\x10\a\x12\x1e\n" +
	"\x1aPLUGIN_REGISTRY_TYPE_NUGET\x10\b\x12\x1e\n" +
	"\x1aPLUGIN_REGISTRY_TYPE_CMAKE\x10\t\"\x04\b\x06\x10\x06*\x1cPLUGIN_REGISTRY_TYPE_ARCHIVE*\xe5\x03\n" +
	"\x0ePluginLanguage\x12\x1f\n" +
	"\x1bPLUGIN_LANGUAGE_UNSPECIFIED\x10\x00\x12\x16\n" +
	"\x12PLUGIN_LANGUAGE_GO\x10\x01\x12\x1e\n" +
	"\x1aPLUGIN_LANGUAGE_JAVASCRIPT\x10\x02\x12\x1e\n" +
	"\x1aPLUGIN_LANGUAGE_TYPESCRIPT\x10\x03\x12\x19\n" +
	"\x15PLUGIN_LANGUAGE_SWIFT\x10\x04\x12\x17\n" +
	"\x13PLUGIN_LANGUAGE_CPP\x10\x05\x12\x18\n" +
	"\x14PLUGIN_LANGUAGE_JAVA\x10\x06\x12\x18\n" +
	"\x14PLUGIN_LANGUAGE_DART\x10\a\x12\x18\n" +
	"\x14PLUGIN_LANGUAGE_RUST\x10\b\x12\x1a\n" +
	"\x16PLUGIN_LANGUAGE_PYTHON\x10\t\x12\x18\n" +
	"\x14PLUGIN_LANGUAGE_RUBY\x10\n" +
	"\x12\x1a\n" +
	"\x16PLUGIN_LANGUAGE_KOTLIN\x10\v\x12\x1f\n" +
	"\x1bPLUGIN_LANGUAGE_OBJECTIVE_C\x10\f\x12\x17\n" +
	"\x13PLUGIN_LANGUAGE_PHP\x10\r\x12\x1a\n" +
	"\x16PLUGIN_LANGUAGE_CSHARP\x10\x0e\x12\x19\n" +
	"\x15PLUGIN_LANGUAGE_SCALA\x10\x0f\x12\x15\n" +
	"\x11PLUGIN_LANGUAGE_C\x10\x10*n\n" +
	"\x0eNPMImportStyle\x12 \n" +
	"\x1cNPM_IMPORT_STYLE_UNSPECIFIED\x10\x00\x12\x1b\n" +
	"\x17NPM_IMPORT_STYLE_MODULE\x10\x01\x12\x1d\n" +
	"\x19NPM_IMPORT_STYLE_COMMONJS\x10\x02*\xb3\x01\n" +
	"\x11SwiftPlatformType\x12#\n" +
	"\x1fSWIFT_PLATFORM_TYPE_UNSPECIFIED\x10\x00\x12\x1d\n" +
	"\x19SWIFT_PLATFORM_TYPE_MACOS\x10\x01\x12\x1b\n" +
	"\x17SWIFT_PLATFORM_TYPE_IOS\x10\x02\x12\x1f\n" +
	"\x1bSWIFT_PLATFORM_TYPE_WATCHOS\x10\x03\x12\x1c\n" +
	"\x18SWIFT_PLATFORM_TYPE_TVOS\x10\x04*|\n" +
	"\x11PythonPackageType\x12#\n" +
	"\x1fPYTHON_PACKAGE_TYPE_UNSPECIFIED\x10\x00\x12\x1f\n" +
	"\x1bPYTHON_PACKAGE_TYPE_RUNTIME\x10\x01\x12!\n" +
	"\x1dPYTHON_PACKAGE_TYPE_STUB_ONLY\x10\x02*\xe9\x04\n" +
	"\x15DotnetTargetFramework\x12'\n" +
	"#DOTNET_TARGET_FRAMEWORK_UNSPECIFIED\x10\x00\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0\x10\x01\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1\x10\x02\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2\x10\x03\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3\x10\x04\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4\x10\x05\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5\x10\x06\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6\x10\a\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0\x10\b\x12+\n" +
	"'DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1\x10\t\x12#\n" +
	"\x1fDOTNET_TARGET_FRAMEWORK_NET_5_0\x10\n" +
	"\x12#\n" +
	"\x1fDOTNET_TARGET_FRAMEWORK_NET_6_0\x10\v\x12#\n" +
	"\x1fDOTNET_TARGET_FRAMEWORK_NET_7_0\x10\f\x12#\n" +
	"\x1fDOTNET_TARGET_FRAMEWORK_NET_8_0\x10\r2\xdd\x04\n" +
	"\x15PluginCurationService\x12\x8a\x01\n" +
	"\x12ListCuratedPlugins\x126.buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest\x1a7.buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse\"\x03\x90\x02\x01\x12\x8d\x01\n" +
	"\x13CreateCuratedPlugin\x127.buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest\x1a8.buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse\"\x03\x90\x02\x02\x12\x96\x01\n" +
	"\x16GetLatestCuratedPlugin\x12:.buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest\x1a;.buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse\"\x03\x90\x02\x01\x12\x8d\x01\n" +
	"\x13DeleteCuratedPlugin\x127.buf.alpha.registry.v1alpha1.DeleteCuratedPluginRequest\x1a8.buf.alpha.registry.v1alpha1.DeleteCuratedPluginResponse\"\x03\x90\x02\x022\x8c\x01\n" +
	"\x15CodeGenerationService\x12s\n" +
	"\fGenerateCode\x120.buf.alpha.registry.v1alpha1.GenerateCodeRequest\x1a1.buf.alpha.registry.v1alpha1.GenerateCodeResponseB\xa0\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x13PluginCurationProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes = []any{
	(CuratedPluginVisibility)(0),                // 0: buf.alpha.registry.v1alpha1.CuratedPluginVisibility
	(PluginRegistryType)(0),                     // 1: buf.alpha.registry.v1alpha1.PluginRegistryType
	(PluginLanguage)(0),                         // 2: buf.alpha.registry.v1alpha1.PluginLanguage
	(NPMImportStyle)(0),                         // 3: buf.alpha.registry.v1alpha1.NPMImportStyle
	(SwiftPlatformType)(0),                      // 4: buf.alpha.registry.v1alpha1.SwiftPlatformType
	(PythonPackageType)(0),                      // 5: buf.alpha.registry.v1alpha1.PythonPackageType
	(DotnetTargetFramework)(0),                  // 6: buf.alpha.registry.v1alpha1.DotnetTargetFramework
	(*GoConfig)(nil),                            // 7: buf.alpha.registry.v1alpha1.GoConfig
	(*NPMConfig)(nil),                           // 8: buf.alpha.registry.v1alpha1.NPMConfig
	(*MavenConfig)(nil),                         // 9: buf.alpha.registry.v1alpha1.MavenConfig
	(*NugetConfig)(nil),                         // 10: buf.alpha.registry.v1alpha1.NugetConfig
	(*CmakeConfig)(nil),                         // 11: buf.alpha.registry.v1alpha1.CmakeConfig
	(*SwiftConfig)(nil),                         // 12: buf.alpha.registry.v1alpha1.SwiftConfig
	(*PythonConfig)(nil),                        // 13: buf.alpha.registry.v1alpha1.PythonConfig
	(*CargoConfig)(nil),                         // 14: buf.alpha.registry.v1alpha1.CargoConfig
	(*RegistryConfig)(nil),                      // 15: buf.alpha.registry.v1alpha1.RegistryConfig
	(*CuratedPluginReference)(nil),              // 16: buf.alpha.registry.v1alpha1.CuratedPluginReference
	(*CuratedPlugin)(nil),                       // 17: buf.alpha.registry.v1alpha1.CuratedPlugin
	(*PluginCollection)(nil),                    // 18: buf.alpha.registry.v1alpha1.PluginCollection
	(*GenerateCodeRequest)(nil),                 // 19: buf.alpha.registry.v1alpha1.GenerateCodeRequest
	(*GenerateCodeResponse)(nil),                // 20: buf.alpha.registry.v1alpha1.GenerateCodeResponse
	(*PluginGenerationRequest)(nil),             // 21: buf.alpha.registry.v1alpha1.PluginGenerationRequest
	(*PluginGenerationResponse)(nil),            // 22: buf.alpha.registry.v1alpha1.PluginGenerationResponse
	(*DeleteCuratedPluginRequest)(nil),          // 23: buf.alpha.registry.v1alpha1.DeleteCuratedPluginRequest
	(*DeleteCuratedPluginResponse)(nil),         // 24: buf.alpha.registry.v1alpha1.DeleteCuratedPluginResponse
	(*CreateCuratedPluginRequest)(nil),          // 25: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest
	(*CreateCuratedPluginResponse)(nil),         // 26: buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse
	(*ListCuratedPluginsRequest)(nil),           // 27: buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest
	(*ListCuratedPluginsResponse)(nil),          // 28: buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse
	(*GetLatestCuratedPluginRequest)(nil),       // 29: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest
	(*GetLatestCuratedPluginResponse)(nil),      // 30: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse
	(*CuratedPluginVersionRevisions)(nil),       // 31: buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisions
	(*GoConfig_RuntimeLibrary)(nil),             // 32: buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibrary
	(*NPMConfig_RuntimeLibrary)(nil),            // 33: buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibrary
	(*MavenConfig_RuntimeLibrary)(nil),          // 34: buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibrary
	(*MavenConfig_CompilerConfig)(nil),          // 35: buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig
	(*MavenConfig_CompilerJavaConfig)(nil),      // 36: buf.alpha.registry.v1alpha1.MavenConfig.CompilerJavaConfig
	(*MavenConfig_CompilerKotlinConfig)(nil),    // 37: buf.alpha.registry.v1alpha1.MavenConfig.CompilerKotlinConfig
	(*MavenConfig_RuntimeConfig)(nil),           // 38: buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfig
	(*NugetConfig_RuntimeLibrary)(nil),          // 39: buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibrary
	(*SwiftConfig_RuntimeLibrary)(nil),          // 40: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary
	(*SwiftConfig_RuntimeLibrary_Platform)(nil), // 41: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.Platform
	(*PythonConfig_RuntimeLibrary)(nil),         // 42: buf.alpha.registry.v1alpha1.PythonConfig.RuntimeLibrary
	(*CargoConfig_RuntimeLibrary)(nil),          // 43: buf.alpha.registry.v1alpha1.CargoConfig.RuntimeLibrary
	(*timestamppb.Timestamp)(nil),               // 44: google.protobuf.Timestamp
	(*v1.Image)(nil),                            // 45: buf.alpha.image.v1.Image
	(*pluginpb.CodeGeneratorResponse)(nil),      // 46: google.protobuf.compiler.CodeGeneratorResponse
}
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs = []int32{
	32, // 0: buf.alpha.registry.v1alpha1.GoConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibrary
	33, // 1: buf.alpha.registry.v1alpha1.NPMConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibrary
	3,  // 2: buf.alpha.registry.v1alpha1.NPMConfig.import_style:type_name -> buf.alpha.registry.v1alpha1.NPMImportStyle
	34, // 3: buf.alpha.registry.v1alpha1.MavenConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibrary
	35, // 4: buf.alpha.registry.v1alpha1.MavenConfig.compiler:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig
	38, // 5: buf.alpha.registry.v1alpha1.MavenConfig.additional_runtimes:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfig
	6,  // 6: buf.alpha.registry.v1alpha1.NugetConfig.target_frameworks:type_name -> buf.alpha.registry.v1alpha1.DotnetTargetFramework
	39, // 7: buf.alpha.registry.v1alpha1.NugetConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibrary
	40, // 8: buf.alpha.registry.v1alpha1.SwiftConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary
	42, // 9: buf.alpha.registry.v1alpha1.PythonConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.PythonConfig.RuntimeLibrary
	5,  // 10: buf.alpha.registry.v1alpha1.PythonConfig.package_type:type_name -> buf.alpha.registry.v1alpha1.PythonPackageType
	43, // 11: buf.alpha.registry.v1alpha1.CargoConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.CargoConfig.RuntimeLibrary
	7,  // 12: buf.alpha.registry.v1alpha1.RegistryConfig.go_config:type_name -> buf.alpha.registry.v1alpha1.GoConfig
	8,  // 13: buf.alpha.registry.v1alpha1.RegistryConfig.npm_config:type_name -> buf.alpha.registry.v1alpha1.NPMConfig
	9,  // 14: buf.alpha.registry.v1alpha1.RegistryConfig.maven_config:type_name -> buf.alpha.registry.v1alpha1.MavenConfig
	12, // 15: buf.alpha.registry.v1alpha1.RegistryConfig.swift_config:type_name -> buf.alpha.registry.v1alpha1.SwiftConfig
	13, // 16: buf.alpha.registry.v1alpha1.RegistryConfig.python_config:type_name -> buf.alpha.registry.v1alpha1.PythonConfig
	14, // 17: buf.alpha.registry.v1alpha1.RegistryConfig.cargo_config:type_name -> buf.alpha.registry.v1alpha1.CargoConfig
	10, // 18: buf.alpha.registry.v1alpha1.RegistryConfig.nuget_config:type_name -> buf.alpha.registry.v1alpha1.NugetConfig
	11, // 19: buf.alpha.registry.v1alpha1.RegistryConfig.cmake_config:type_name -> buf.alpha.registry.v1alpha1.CmakeConfig
	1,  // 20: buf.alpha.registry.v1alpha1.CuratedPlugin.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	44, // 21: buf.alpha.registry.v1alpha1.CuratedPlugin.create_time:type_name -> google.protobuf.Timestamp
	16, // 22: buf.alpha.registry.v1alpha1.CuratedPlugin.dependencies:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	15, // 23: buf.alpha.registry.v1alpha1.CuratedPlugin.registry_config:type_name -> buf.alpha.registry.v1alpha1.RegistryConfig
	2,  // 24: buf.alpha.registry.v1alpha1.CuratedPlugin.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	0,  // 25: buf.alpha.registry.v1alpha1.CuratedPlugin.visibility:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVisibility
	18, // 26: buf.alpha.registry.v1alpha1.CuratedPlugin.collections:type_name -> buf.alpha.registry.v1alpha1.PluginCollection
	45, // 27: buf.alpha.registry.v1alpha1.GenerateCodeRequest.image:type_name -> buf.alpha.image.v1.Image
	21, // 28: buf.alpha.registry.v1alpha1.GenerateCodeRequest.requests:type_name -> buf.alpha.registry.v1alpha1.PluginGenerationRequest
	22, // 29: buf.alpha.registry.v1alpha1.GenerateCodeResponse.responses:type_name -> buf.alpha.registry.v1alpha1.PluginGenerationResponse
	16, // 30: buf.alpha.registry.v1alpha1.PluginGenerationRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	46, // 31: buf.alpha.registry.v1alpha1.PluginGenerationResponse.response:type_name -> google.protobuf.compiler.CodeGeneratorResponse
	1,  // 32: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	16, // 33: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.dependencies:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	15, // 34: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.registry_config:type_name -> buf.alpha.registry.v1alpha1.RegistryConfig
	2,  // 35: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	0,  // 36: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.visibility:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVisibility
	17, // 37: buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse.configuration:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	17, // 38: buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse.plugins:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	17, // 39: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse.plugin:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	31, // 40: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse.versions:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisions
	36, // 41: buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig.java:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.CompilerJavaConfig
	37, // 42: buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig.kotlin:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.CompilerKotlinConfig
	34, // 43: buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibrary
	6,  // 44: buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibrary.target_frameworks:type_name -> buf.alpha.registry.v1alpha1.DotnetTargetFramework
	41, // 45: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.platforms:type_name -> buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.Platform
	4,  // 46: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.Platform.name:type_name -> buf.alpha.registry.v1alpha1.SwiftPlatformType
	27, // 47: buf.alpha.registry.v1alpha1.PluginCurationService.ListCuratedPlugins:input_type -> buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest
	25, // 48: buf.alpha.registry.v1alpha1.PluginCurationService.CreateCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest
	29, // 49: buf.alpha.registry.v1alpha1.PluginCurationService.GetLatestCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest
	23, // 50: buf.alpha.registry.v1alpha1.PluginCurationService.DeleteCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.DeleteCuratedPluginRequest
	19, // 51: buf.alpha.registry.v1alpha1.CodeGenerationService.GenerateCode:input_type -> buf.alpha.registry.v1alpha1.GenerateCodeRequest
	28, // 52: buf.alpha.registry.v1alpha1.PluginCurationService.ListCuratedPlugins:output_type -> buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse
	26, // 53: buf.alpha.registry.v1alpha1.PluginCurationService.CreateCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse
	30, // 54: buf.alpha.registry.v1alpha1.PluginCurationService.GetLatestCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse
	24, // 55: buf.alpha.registry.v1alpha1.PluginCurationService.DeleteCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.DeleteCuratedPluginResponse
	20, // 56: buf.alpha.registry.v1alpha1.CodeGenerationService.GenerateCode:output_type -> buf.alpha.registry.v1alpha1.GenerateCodeResponse
	52, // [52:57] is the sub-list for method output_type
	47, // [47:52] is the sub-list for method input_type
	47, // [47:47] is the sub-list for extension type_name
	47, // [47:47] is the sub-list for extension extendee
	0,  // [0:47] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init() }
func file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init() {
	if File_buf_alpha_registry_v1alpha1_plugin_curation_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8].OneofWrappers = []any{
		(*registryConfig_GoConfig)(nil),
		(*registryConfig_NpmConfig)(nil),
		(*registryConfig_MavenConfig)(nil),
		(*registryConfig_SwiftConfig)(nil),
		(*registryConfig_PythonConfig)(nil),
		(*registryConfig_CargoConfig)(nil),
		(*registryConfig_NugetConfig)(nil),
		(*registryConfig_CmakeConfig)(nil),
	}
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc)),
			NumEnums:      7,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_plugin_curation_proto = out.File
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs = nil
}
