// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package recorder

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PutRecorderIDReader is a Reader for the PutRecorderID structure.
type PutRecorderIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutRecorderIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPutRecorderIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 201:
		result := NewPutRecorderIDCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewPutRecorderIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPutRecorderIDFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /recorder/{id}] PutRecorderID", response, response.Code())
	}
}

// NewPutRecorderIDOK creates a PutRecorderIDOK with default headers values
func NewPutRecorderIDOK() *PutRecorderIDOK {
	return &PutRecorderIDOK{}
}

/*
PutRecorderIDOK describes a response with status code 200, with default header values.

Updated
*/
type PutRecorderIDOK struct {
}

// IsSuccess returns true when this put recorder Id o k response has a 2xx status code
func (o *PutRecorderIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put recorder Id o k response has a 3xx status code
func (o *PutRecorderIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put recorder Id o k response has a 4xx status code
func (o *PutRecorderIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this put recorder Id o k response has a 5xx status code
func (o *PutRecorderIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this put recorder Id o k response a status code equal to that given
func (o *PutRecorderIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the put recorder Id o k response
func (o *PutRecorderIDOK) Code() int {
	return 200
}

func (o *PutRecorderIDOK) Error() string {
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdOK", 200)
}

func (o *PutRecorderIDOK) String() string {
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdOK", 200)
}

func (o *PutRecorderIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutRecorderIDCreated creates a PutRecorderIDCreated with default headers values
func NewPutRecorderIDCreated() *PutRecorderIDCreated {
	return &PutRecorderIDCreated{}
}

/*
PutRecorderIDCreated describes a response with status code 201, with default header values.

Created
*/
type PutRecorderIDCreated struct {
}

// IsSuccess returns true when this put recorder Id created response has a 2xx status code
func (o *PutRecorderIDCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put recorder Id created response has a 3xx status code
func (o *PutRecorderIDCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put recorder Id created response has a 4xx status code
func (o *PutRecorderIDCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this put recorder Id created response has a 5xx status code
func (o *PutRecorderIDCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this put recorder Id created response a status code equal to that given
func (o *PutRecorderIDCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the put recorder Id created response
func (o *PutRecorderIDCreated) Code() int {
	return 201
}

func (o *PutRecorderIDCreated) Error() string {
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdCreated", 201)
}

func (o *PutRecorderIDCreated) String() string {
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdCreated", 201)
}

func (o *PutRecorderIDCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutRecorderIDForbidden creates a PutRecorderIDForbidden with default headers values
func NewPutRecorderIDForbidden() *PutRecorderIDForbidden {
	return &PutRecorderIDForbidden{}
}

/*
PutRecorderIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PutRecorderIDForbidden struct {
}

// IsSuccess returns true when this put recorder Id forbidden response has a 2xx status code
func (o *PutRecorderIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put recorder Id forbidden response has a 3xx status code
func (o *PutRecorderIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put recorder Id forbidden response has a 4xx status code
func (o *PutRecorderIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this put recorder Id forbidden response has a 5xx status code
func (o *PutRecorderIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this put recorder Id forbidden response a status code equal to that given
func (o *PutRecorderIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the put recorder Id forbidden response
func (o *PutRecorderIDForbidden) Code() int {
	return 403
}

func (o *PutRecorderIDForbidden) Error() string {
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdForbidden", 403)
}

func (o *PutRecorderIDForbidden) String() string {
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdForbidden", 403)
}

func (o *PutRecorderIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutRecorderIDFailure creates a PutRecorderIDFailure with default headers values
func NewPutRecorderIDFailure() *PutRecorderIDFailure {
	return &PutRecorderIDFailure{}
}

/*
PutRecorderIDFailure describes a response with status code 500, with default header values.

Error while creating recorder
*/
type PutRecorderIDFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this put recorder Id failure response has a 2xx status code
func (o *PutRecorderIDFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put recorder Id failure response has a 3xx status code
func (o *PutRecorderIDFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put recorder Id failure response has a 4xx status code
func (o *PutRecorderIDFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this put recorder Id failure response has a 5xx status code
func (o *PutRecorderIDFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this put recorder Id failure response a status code equal to that given
func (o *PutRecorderIDFailure) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the put recorder Id failure response
func (o *PutRecorderIDFailure) Code() int {
	return 500
}

func (o *PutRecorderIDFailure) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdFailure %s", 500, payload)
}

func (o *PutRecorderIDFailure) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /recorder/{id}][%d] putRecorderIdFailure %s", 500, payload)
}

func (o *PutRecorderIDFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *PutRecorderIDFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
