// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetHealthzParams creates a new GetHealthzParams object
// with the default values initialized.
func NewGetHealthzParams() GetHealthzParams {

	var (
		// initialize parameters with default values

		requireK8sConnectivityDefault = bool(true)
	)

	return GetHealthzParams{
		RequireK8sConnectivity: &requireK8sConnectivityDefault,
	}
}

// GetHealthzParams contains all the bound params for the get healthz operation
// typically these are obtained from a http.Request
//
// swagger:parameters GetHealthz
type GetHealthzParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Brief will return a brief representation of the Cilium status.

	  In: header
	*/
	Brief *bool
	/*If set to true, failure of the agent to connect to the Kubernetes control plane will cause the agent's health status to also fail.

	  In: header
	  Default: true
	*/
	RequireK8sConnectivity *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetHealthzParams() beforehand.
func (o *GetHealthzParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	if err := o.bindBrief(r.Header[http.CanonicalHeaderKey("brief")], true, route.Formats); err != nil {
		res = append(res, err)
	}

	if err := o.bindRequireK8sConnectivity(r.Header[http.CanonicalHeaderKey("require-k8s-connectivity")], true, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindBrief binds and validates parameter Brief from header.
func (o *GetHealthzParams) bindBrief(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("brief", "header", "bool", raw)
	}
	o.Brief = &value

	return nil
}

// bindRequireK8sConnectivity binds and validates parameter RequireK8sConnectivity from header.
func (o *GetHealthzParams) bindRequireK8sConnectivity(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewGetHealthzParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("require-k8s-connectivity", "header", "bool", raw)
	}
	o.RequireK8sConnectivity = &value

	return nil
}
