/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "cinnamon-calendar.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64_INT64_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectInt64Int64BooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint64 arg_since,
        gint64 arg_until,
        gboolean arg_force_reload,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectInt64Int64BooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectInt64Int64BooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int64 (param_values + 2),
              g_marshal_value_peek_int64 (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.cinnamon.CalendarServer
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CinnamonCalendarServer
 * @title: CinnamonCalendarServer
 * @short_description: Generated C code for the org.cinnamon.CalendarServer D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link> D-Bus interface in C.
 */

enum
{
  CINNAMON__CALENDAR_SERVER_EVENTS_ADDED_OR_UPDATED,
  CINNAMON__CALENDAR_SERVER_EVENTS_REMOVED,
  CINNAMON__CALENDAR_SERVER_CLIENT_DISAPPEARED,
};

static unsigned CINNAMON__CALENDAR_SERVER_SIGNALS[3] = { 0 };

/* ---- Introspection data for org.cinnamon.CalendarServer ---- */

static const _ExtendedGDBusArgInfo _cinnamon_calendar_server_method_info_set_time_range_IN_ARG_since =
{
  {
    -1,
    (gchar *) "since",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cinnamon_calendar_server_method_info_set_time_range_IN_ARG_until =
{
  {
    -1,
    (gchar *) "until",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cinnamon_calendar_server_method_info_set_time_range_IN_ARG_force_reload =
{
  {
    -1,
    (gchar *) "force_reload",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cinnamon_calendar_server_method_info_set_time_range_IN_ARG_pointers[] =
{
  &_cinnamon_calendar_server_method_info_set_time_range_IN_ARG_since.parent_struct,
  &_cinnamon_calendar_server_method_info_set_time_range_IN_ARG_until.parent_struct,
  &_cinnamon_calendar_server_method_info_set_time_range_IN_ARG_force_reload.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cinnamon_calendar_server_method_info_set_time_range =
{
  {
    -1,
    (gchar *) "SetTimeRange",
    (GDBusArgInfo **) &_cinnamon_calendar_server_method_info_set_time_range_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-time-range",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cinnamon_calendar_server_method_info_exit =
{
  {
    -1,
    (gchar *) "Exit",
    NULL,
    NULL,
    NULL
  },
  "handle-exit",
  FALSE
};

static const GDBusMethodInfo * const _cinnamon_calendar_server_method_info_pointers[] =
{
  &_cinnamon_calendar_server_method_info_set_time_range.parent_struct,
  &_cinnamon_calendar_server_method_info_exit.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _cinnamon_calendar_server_signal_info_events_added_or_updated_ARG_events =
{
  {
    -1,
    (gchar *) "events",
    (gchar *) "a(sssbxxx)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cinnamon_calendar_server_signal_info_events_added_or_updated_ARG_pointers[] =
{
  &_cinnamon_calendar_server_signal_info_events_added_or_updated_ARG_events.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _cinnamon_calendar_server_signal_info_events_added_or_updated =
{
  {
    -1,
    (gchar *) "EventsAddedOrUpdated",
    (GDBusArgInfo **) &_cinnamon_calendar_server_signal_info_events_added_or_updated_ARG_pointers,
    NULL
  },
  "events-added-or-updated"
};

static const _ExtendedGDBusArgInfo _cinnamon_calendar_server_signal_info_events_removed_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cinnamon_calendar_server_signal_info_events_removed_ARG_pointers[] =
{
  &_cinnamon_calendar_server_signal_info_events_removed_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _cinnamon_calendar_server_signal_info_events_removed =
{
  {
    -1,
    (gchar *) "EventsRemoved",
    (GDBusArgInfo **) &_cinnamon_calendar_server_signal_info_events_removed_ARG_pointers,
    NULL
  },
  "events-removed"
};

static const _ExtendedGDBusArgInfo _cinnamon_calendar_server_signal_info_client_disappeared_ARG_source_uid =
{
  {
    -1,
    (gchar *) "source_uid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cinnamon_calendar_server_signal_info_client_disappeared_ARG_pointers[] =
{
  &_cinnamon_calendar_server_signal_info_client_disappeared_ARG_source_uid.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _cinnamon_calendar_server_signal_info_client_disappeared =
{
  {
    -1,
    (gchar *) "ClientDisappeared",
    (GDBusArgInfo **) &_cinnamon_calendar_server_signal_info_client_disappeared_ARG_pointers,
    NULL
  },
  "client-disappeared"
};

static const GDBusSignalInfo * const _cinnamon_calendar_server_signal_info_pointers[] =
{
  &_cinnamon_calendar_server_signal_info_events_added_or_updated.parent_struct,
  &_cinnamon_calendar_server_signal_info_events_removed.parent_struct,
  &_cinnamon_calendar_server_signal_info_client_disappeared.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cinnamon_calendar_server_property_info_since =
{
  {
    -1,
    (gchar *) "Since",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "since",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cinnamon_calendar_server_property_info_until =
{
  {
    -1,
    (gchar *) "Until",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "until",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cinnamon_calendar_server_property_info_status =
{
  {
    -1,
    (gchar *) "Status",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "status",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _cinnamon_calendar_server_property_info_pointers[] =
{
  &_cinnamon_calendar_server_property_info_since.parent_struct,
  &_cinnamon_calendar_server_property_info_until.parent_struct,
  &_cinnamon_calendar_server_property_info_status.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cinnamon_calendar_server_interface_info =
{
  {
    -1,
    (gchar *) "org.cinnamon.CalendarServer",
    (GDBusMethodInfo **) &_cinnamon_calendar_server_method_info_pointers,
    (GDBusSignalInfo **) &_cinnamon_calendar_server_signal_info_pointers,
    (GDBusPropertyInfo **) &_cinnamon_calendar_server_property_info_pointers,
    NULL
  },
  "calendar-server",
};


/**
 * cinnamon_calendar_server_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cinnamon_calendar_server_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cinnamon_calendar_server_interface_info.parent_struct;
}

/**
 * cinnamon_calendar_server_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CinnamonCalendarServer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cinnamon_calendar_server_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "since");
  g_object_class_override_property (klass, property_id_begin++, "until");
  g_object_class_override_property (klass, property_id_begin++, "status");
  return property_id_begin - 1;
}


inline static void
cinnamon_calendar_server_signal_marshal_events_added_or_updated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cinnamon_calendar_server_signal_marshal_events_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cinnamon_calendar_server_signal_marshal_client_disappeared (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cinnamon_calendar_server_method_marshal_set_time_range (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64_INT64_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cinnamon_calendar_server_method_marshal_exit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CinnamonCalendarServer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link>.
 */

/**
 * CinnamonCalendarServerIface:
 * @parent_iface: The parent interface.
 * @handle_exit: Handler for the #CinnamonCalendarServer::handle-exit signal.
 * @handle_set_time_range: Handler for the #CinnamonCalendarServer::handle-set-time-range signal.
 * @get_since: Getter for the #CinnamonCalendarServer:since property.
 * @get_status: Getter for the #CinnamonCalendarServer:status property.
 * @get_until: Getter for the #CinnamonCalendarServer:until property.
 * @client_disappeared: Handler for the #CinnamonCalendarServer::client-disappeared signal.
 * @events_added_or_updated: Handler for the #CinnamonCalendarServer::events-added-or-updated signal.
 * @events_removed: Handler for the #CinnamonCalendarServer::events-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link>.
 */

typedef CinnamonCalendarServerIface CinnamonCalendarServerInterface;
G_DEFINE_INTERFACE (CinnamonCalendarServer, cinnamon_calendar_server, G_TYPE_OBJECT)

static void
cinnamon_calendar_server_default_init (CinnamonCalendarServerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CinnamonCalendarServer::handle-set-time-range:
   * @object: A #CinnamonCalendarServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_since: Argument passed by remote caller.
   * @arg_until: Argument passed by remote caller.
   * @arg_force_reload: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-CalendarServer.SetTimeRange">SetTimeRange()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cinnamon_calendar_server_complete_set_time_range() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-time-range",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CinnamonCalendarServerIface, handle_set_time_range),
    g_signal_accumulator_true_handled,
    NULL,
      cinnamon_calendar_server_method_marshal_set_time_range,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64, G_TYPE_INT64, G_TYPE_BOOLEAN);

  /**
   * CinnamonCalendarServer::handle-exit:
   * @object: A #CinnamonCalendarServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-cinnamon-CalendarServer.Exit">Exit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cinnamon_calendar_server_complete_exit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-exit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CinnamonCalendarServerIface, handle_exit),
    g_signal_accumulator_true_handled,
    NULL,
      cinnamon_calendar_server_method_marshal_exit,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * CinnamonCalendarServer::events-added-or-updated:
   * @object: A #CinnamonCalendarServer.
   * @arg_events: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-cinnamon-CalendarServer.EventsAddedOrUpdated">"EventsAddedOrUpdated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CINNAMON__CALENDAR_SERVER_SIGNALS[CINNAMON__CALENDAR_SERVER_EVENTS_ADDED_OR_UPDATED] =
    g_signal_new ("events-added-or-updated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CinnamonCalendarServerIface, events_added_or_updated),
      NULL,
      NULL,
      cinnamon_calendar_server_signal_marshal_events_added_or_updated,
      G_TYPE_NONE,
      1, G_TYPE_VARIANT);

  /**
   * CinnamonCalendarServer::events-removed:
   * @object: A #CinnamonCalendarServer.
   * @arg_ids: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-cinnamon-CalendarServer.EventsRemoved">"EventsRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CINNAMON__CALENDAR_SERVER_SIGNALS[CINNAMON__CALENDAR_SERVER_EVENTS_REMOVED] =
    g_signal_new ("events-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CinnamonCalendarServerIface, events_removed),
      NULL,
      NULL,
      cinnamon_calendar_server_signal_marshal_events_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * CinnamonCalendarServer::client-disappeared:
   * @object: A #CinnamonCalendarServer.
   * @arg_source_uid: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-cinnamon-CalendarServer.ClientDisappeared">"ClientDisappeared"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CINNAMON__CALENDAR_SERVER_SIGNALS[CINNAMON__CALENDAR_SERVER_CLIENT_DISAPPEARED] =
    g_signal_new ("client-disappeared",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CinnamonCalendarServerIface, client_disappeared),
      NULL,
      NULL,
      cinnamon_calendar_server_signal_marshal_client_disappeared,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * CinnamonCalendarServer:since:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-cinnamon-CalendarServer.Since">"Since"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("since", "Since", "Since", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CinnamonCalendarServer:until:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-cinnamon-CalendarServer.Until">"Until"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("until", "Until", "Until", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CinnamonCalendarServer:status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-cinnamon-CalendarServer.Status">"Status"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("status", "Status", "Status", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cinnamon_calendar_server_get_since: (skip)
 * @object: A #CinnamonCalendarServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-cinnamon-CalendarServer.Since">"Since"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
cinnamon_calendar_server_get_since (CinnamonCalendarServer *object)
{
  g_return_val_if_fail (CINNAMON_IS_CALENDAR_SERVER (object), 0);

  return CINNAMON_CALENDAR_SERVER_GET_IFACE (object)->get_since (object);
}

/**
 * cinnamon_calendar_server_set_since: (skip)
 * @object: A #CinnamonCalendarServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-cinnamon-CalendarServer.Since">"Since"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cinnamon_calendar_server_set_since (CinnamonCalendarServer *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "since", value, NULL);
}

/**
 * cinnamon_calendar_server_get_until: (skip)
 * @object: A #CinnamonCalendarServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-cinnamon-CalendarServer.Until">"Until"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
cinnamon_calendar_server_get_until (CinnamonCalendarServer *object)
{
  g_return_val_if_fail (CINNAMON_IS_CALENDAR_SERVER (object), 0);

  return CINNAMON_CALENDAR_SERVER_GET_IFACE (object)->get_until (object);
}

/**
 * cinnamon_calendar_server_set_until: (skip)
 * @object: A #CinnamonCalendarServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-cinnamon-CalendarServer.Until">"Until"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cinnamon_calendar_server_set_until (CinnamonCalendarServer *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "until", value, NULL);
}

/**
 * cinnamon_calendar_server_get_status: (skip)
 * @object: A #CinnamonCalendarServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-cinnamon-CalendarServer.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
cinnamon_calendar_server_get_status (CinnamonCalendarServer *object)
{
  g_return_val_if_fail (CINNAMON_IS_CALENDAR_SERVER (object), 0);

  return CINNAMON_CALENDAR_SERVER_GET_IFACE (object)->get_status (object);
}

/**
 * cinnamon_calendar_server_set_status: (skip)
 * @object: A #CinnamonCalendarServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-cinnamon-CalendarServer.Status">"Status"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cinnamon_calendar_server_set_status (CinnamonCalendarServer *object, guint value)
{
  g_object_set (G_OBJECT (object), "status", value, NULL);
}

/**
 * cinnamon_calendar_server_emit_events_added_or_updated:
 * @object: A #CinnamonCalendarServer.
 * @arg_events: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-cinnamon-CalendarServer.EventsAddedOrUpdated">"EventsAddedOrUpdated"</link> D-Bus signal.
 */
void
cinnamon_calendar_server_emit_events_added_or_updated (
    CinnamonCalendarServer *object,
    GVariant *arg_events)
{
  g_signal_emit (object, CINNAMON__CALENDAR_SERVER_SIGNALS[CINNAMON__CALENDAR_SERVER_EVENTS_ADDED_OR_UPDATED], 0, arg_events);
}

/**
 * cinnamon_calendar_server_emit_events_removed:
 * @object: A #CinnamonCalendarServer.
 * @arg_ids: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-cinnamon-CalendarServer.EventsRemoved">"EventsRemoved"</link> D-Bus signal.
 */
void
cinnamon_calendar_server_emit_events_removed (
    CinnamonCalendarServer *object,
    const gchar *arg_ids)
{
  g_signal_emit (object, CINNAMON__CALENDAR_SERVER_SIGNALS[CINNAMON__CALENDAR_SERVER_EVENTS_REMOVED], 0, arg_ids);
}

/**
 * cinnamon_calendar_server_emit_client_disappeared:
 * @object: A #CinnamonCalendarServer.
 * @arg_source_uid: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-cinnamon-CalendarServer.ClientDisappeared">"ClientDisappeared"</link> D-Bus signal.
 */
void
cinnamon_calendar_server_emit_client_disappeared (
    CinnamonCalendarServer *object,
    const gchar *arg_source_uid)
{
  g_signal_emit (object, CINNAMON__CALENDAR_SERVER_SIGNALS[CINNAMON__CALENDAR_SERVER_CLIENT_DISAPPEARED], 0, arg_source_uid);
}

/**
 * cinnamon_calendar_server_call_set_time_range:
 * @proxy: A #CinnamonCalendarServerProxy.
 * @arg_since: Argument to pass with the method invocation.
 * @arg_until: Argument to pass with the method invocation.
 * @arg_force_reload: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-CalendarServer.SetTimeRange">SetTimeRange()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cinnamon_calendar_server_call_set_time_range_finish() to get the result of the operation.
 *
 * See cinnamon_calendar_server_call_set_time_range_sync() for the synchronous, blocking version of this method.
 */
void
cinnamon_calendar_server_call_set_time_range (
    CinnamonCalendarServer *proxy,
    gint64 arg_since,
    gint64 arg_until,
    gboolean arg_force_reload,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetTimeRange",
    g_variant_new ("(xxb)",
                   arg_since,
                   arg_until,
                   arg_force_reload),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cinnamon_calendar_server_call_set_time_range_finish:
 * @proxy: A #CinnamonCalendarServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cinnamon_calendar_server_call_set_time_range().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cinnamon_calendar_server_call_set_time_range().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cinnamon_calendar_server_call_set_time_range_finish (
    CinnamonCalendarServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cinnamon_calendar_server_call_set_time_range_sync:
 * @proxy: A #CinnamonCalendarServerProxy.
 * @arg_since: Argument to pass with the method invocation.
 * @arg_until: Argument to pass with the method invocation.
 * @arg_force_reload: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-CalendarServer.SetTimeRange">SetTimeRange()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cinnamon_calendar_server_call_set_time_range() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cinnamon_calendar_server_call_set_time_range_sync (
    CinnamonCalendarServer *proxy,
    gint64 arg_since,
    gint64 arg_until,
    gboolean arg_force_reload,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetTimeRange",
    g_variant_new ("(xxb)",
                   arg_since,
                   arg_until,
                   arg_force_reload),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cinnamon_calendar_server_call_exit:
 * @proxy: A #CinnamonCalendarServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-cinnamon-CalendarServer.Exit">Exit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cinnamon_calendar_server_call_exit_finish() to get the result of the operation.
 *
 * See cinnamon_calendar_server_call_exit_sync() for the synchronous, blocking version of this method.
 */
void
cinnamon_calendar_server_call_exit (
    CinnamonCalendarServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Exit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cinnamon_calendar_server_call_exit_finish:
 * @proxy: A #CinnamonCalendarServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cinnamon_calendar_server_call_exit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cinnamon_calendar_server_call_exit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cinnamon_calendar_server_call_exit_finish (
    CinnamonCalendarServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cinnamon_calendar_server_call_exit_sync:
 * @proxy: A #CinnamonCalendarServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-cinnamon-CalendarServer.Exit">Exit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cinnamon_calendar_server_call_exit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cinnamon_calendar_server_call_exit_sync (
    CinnamonCalendarServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Exit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cinnamon_calendar_server_complete_set_time_range:
 * @object: A #CinnamonCalendarServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-CalendarServer.SetTimeRange">SetTimeRange()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cinnamon_calendar_server_complete_set_time_range (
    CinnamonCalendarServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cinnamon_calendar_server_complete_exit:
 * @object: A #CinnamonCalendarServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-cinnamon-CalendarServer.Exit">Exit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cinnamon_calendar_server_complete_exit (
    CinnamonCalendarServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CinnamonCalendarServerProxy:
 *
 * The #CinnamonCalendarServerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CinnamonCalendarServerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CinnamonCalendarServerProxy.
 */

struct _CinnamonCalendarServerProxyPrivate
{
  GData *qdata;
};

static void cinnamon_calendar_server_proxy_iface_init (CinnamonCalendarServerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CinnamonCalendarServerProxy, cinnamon_calendar_server_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CinnamonCalendarServerProxy)
                         G_IMPLEMENT_INTERFACE (CINNAMON_TYPE_CALENDAR_SERVER, cinnamon_calendar_server_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CinnamonCalendarServerProxy, cinnamon_calendar_server_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CINNAMON_TYPE_CALENDAR_SERVER, cinnamon_calendar_server_proxy_iface_init))

#endif
static void
cinnamon_calendar_server_proxy_finalize (GObject *object)
{
  CinnamonCalendarServerProxy *proxy = CINNAMON_CALENDAR_SERVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cinnamon_calendar_server_proxy_parent_class)->finalize (object);
}

static void
cinnamon_calendar_server_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cinnamon_calendar_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cinnamon_calendar_server_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.cinnamon.CalendarServer: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cinnamon_calendar_server_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cinnamon_calendar_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.cinnamon.CalendarServer", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cinnamon_calendar_server_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cinnamon_calendar_server_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cinnamon_calendar_server_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CINNAMON_TYPE_CALENDAR_SERVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CINNAMON_TYPE_CALENDAR_SERVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cinnamon_calendar_server_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CinnamonCalendarServerProxy *proxy = CINNAMON_CALENDAR_SERVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cinnamon_calendar_server_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cinnamon_calendar_server_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint64 
cinnamon_calendar_server_proxy_get_since (CinnamonCalendarServer *object)
{
  CinnamonCalendarServerProxy *proxy = CINNAMON_CALENDAR_SERVER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Since");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
cinnamon_calendar_server_proxy_get_until (CinnamonCalendarServer *object)
{
  CinnamonCalendarServerProxy *proxy = CINNAMON_CALENDAR_SERVER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Until");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
cinnamon_calendar_server_proxy_get_status (CinnamonCalendarServer *object)
{
  CinnamonCalendarServerProxy *proxy = CINNAMON_CALENDAR_SERVER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Status");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
cinnamon_calendar_server_proxy_init (CinnamonCalendarServerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cinnamon_calendar_server_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CINNAMON_TYPE_CALENDAR_SERVER_PROXY, CinnamonCalendarServerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cinnamon_calendar_server_interface_info ());
}

static void
cinnamon_calendar_server_proxy_class_init (CinnamonCalendarServerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cinnamon_calendar_server_proxy_finalize;
  gobject_class->get_property = cinnamon_calendar_server_proxy_get_property;
  gobject_class->set_property = cinnamon_calendar_server_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cinnamon_calendar_server_proxy_g_signal;
  proxy_class->g_properties_changed = cinnamon_calendar_server_proxy_g_properties_changed;

  cinnamon_calendar_server_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CinnamonCalendarServerProxyPrivate));
#endif
}

static void
cinnamon_calendar_server_proxy_iface_init (CinnamonCalendarServerIface *iface)
{
  iface->get_since = cinnamon_calendar_server_proxy_get_since;
  iface->get_until = cinnamon_calendar_server_proxy_get_until;
  iface->get_status = cinnamon_calendar_server_proxy_get_status;
}

/**
 * cinnamon_calendar_server_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cinnamon_calendar_server_proxy_new_finish() to get the result of the operation.
 *
 * See cinnamon_calendar_server_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cinnamon_calendar_server_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CINNAMON_TYPE_CALENDAR_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.cinnamon.CalendarServer", NULL);
}

/**
 * cinnamon_calendar_server_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cinnamon_calendar_server_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cinnamon_calendar_server_proxy_new().
 *
 * Returns: (transfer full) (type CinnamonCalendarServerProxy): The constructed proxy object or %NULL if @error is set.
 */
CinnamonCalendarServer *
cinnamon_calendar_server_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CINNAMON_CALENDAR_SERVER (ret);
  else
    return NULL;
}

/**
 * cinnamon_calendar_server_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cinnamon_calendar_server_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CinnamonCalendarServerProxy): The constructed proxy object or %NULL if @error is set.
 */
CinnamonCalendarServer *
cinnamon_calendar_server_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CINNAMON_TYPE_CALENDAR_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.cinnamon.CalendarServer", NULL);
  if (ret != NULL)
    return CINNAMON_CALENDAR_SERVER (ret);
  else
    return NULL;
}


/**
 * cinnamon_calendar_server_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cinnamon_calendar_server_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cinnamon_calendar_server_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cinnamon_calendar_server_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cinnamon_calendar_server_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CINNAMON_TYPE_CALENDAR_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.cinnamon.CalendarServer", NULL);
}

/**
 * cinnamon_calendar_server_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cinnamon_calendar_server_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cinnamon_calendar_server_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CinnamonCalendarServerProxy): The constructed proxy object or %NULL if @error is set.
 */
CinnamonCalendarServer *
cinnamon_calendar_server_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CINNAMON_CALENDAR_SERVER (ret);
  else
    return NULL;
}

/**
 * cinnamon_calendar_server_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cinnamon_calendar_server_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cinnamon_calendar_server_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CinnamonCalendarServerProxy): The constructed proxy object or %NULL if @error is set.
 */
CinnamonCalendarServer *
cinnamon_calendar_server_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CINNAMON_TYPE_CALENDAR_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.cinnamon.CalendarServer", NULL);
  if (ret != NULL)
    return CINNAMON_CALENDAR_SERVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CinnamonCalendarServerSkeleton:
 *
 * The #CinnamonCalendarServerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CinnamonCalendarServerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CinnamonCalendarServerSkeleton.
 */

struct _CinnamonCalendarServerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cinnamon_calendar_server_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CINNAMON_TYPE_CALENDAR_SERVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CINNAMON_TYPE_CALENDAR_SERVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cinnamon_calendar_server_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cinnamon_calendar_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cinnamon_calendar_server_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cinnamon_calendar_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cinnamon_calendar_server_skeleton_vtable =
{
  _cinnamon_calendar_server_skeleton_handle_method_call,
  _cinnamon_calendar_server_skeleton_handle_get_property,
  _cinnamon_calendar_server_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cinnamon_calendar_server_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cinnamon_calendar_server_interface_info ();
}

static GDBusInterfaceVTable *
cinnamon_calendar_server_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cinnamon_calendar_server_skeleton_vtable;
}

static GVariant *
cinnamon_calendar_server_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cinnamon_calendar_server_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cinnamon_calendar_server_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cinnamon_calendar_server_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cinnamon_calendar_server_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.CalendarServer", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cinnamon_calendar_server_emit_changed (gpointer user_data);

static void
cinnamon_calendar_server_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cinnamon_calendar_server_emit_changed (skeleton);
}

static void
_cinnamon_calendar_server_on_signal_events_added_or_updated (
    CinnamonCalendarServer *object,
    GVariant *arg_events)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a(sssbxxx))",
                   arg_events));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.CalendarServer", "EventsAddedOrUpdated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_cinnamon_calendar_server_on_signal_events_removed (
    CinnamonCalendarServer *object,
    const gchar *arg_ids)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_ids));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.CalendarServer", "EventsRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_cinnamon_calendar_server_on_signal_client_disappeared (
    CinnamonCalendarServer *object,
    const gchar *arg_source_uid)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_source_uid));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.cinnamon.CalendarServer", "ClientDisappeared",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void cinnamon_calendar_server_skeleton_iface_init (CinnamonCalendarServerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CinnamonCalendarServerSkeleton, cinnamon_calendar_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CinnamonCalendarServerSkeleton)
                         G_IMPLEMENT_INTERFACE (CINNAMON_TYPE_CALENDAR_SERVER, cinnamon_calendar_server_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CinnamonCalendarServerSkeleton, cinnamon_calendar_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CINNAMON_TYPE_CALENDAR_SERVER, cinnamon_calendar_server_skeleton_iface_init))

#endif
static void
cinnamon_calendar_server_skeleton_finalize (GObject *object)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cinnamon_calendar_server_skeleton_parent_class)->finalize (object);
}

static void
cinnamon_calendar_server_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cinnamon_calendar_server_emit_changed (gpointer user_data)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.cinnamon.CalendarServer",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cinnamon_calendar_server_schedule_emit_changed (CinnamonCalendarServerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cinnamon_calendar_server_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cinnamon_calendar_server_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cinnamon_calendar_server_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cinnamon_calendar_server_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cinnamon_calendar_server_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cinnamon_calendar_server_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cinnamon_calendar_server_skeleton_init (CinnamonCalendarServerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cinnamon_calendar_server_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CINNAMON_TYPE_CALENDAR_SERVER_SKELETON, CinnamonCalendarServerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
}

static gint64 
cinnamon_calendar_server_skeleton_get_since (CinnamonCalendarServer *object)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int64 (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
cinnamon_calendar_server_skeleton_get_until (CinnamonCalendarServer *object)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int64 (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
cinnamon_calendar_server_skeleton_get_status (CinnamonCalendarServer *object)
{
  CinnamonCalendarServerSkeleton *skeleton = CINNAMON_CALENDAR_SERVER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cinnamon_calendar_server_skeleton_class_init (CinnamonCalendarServerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cinnamon_calendar_server_skeleton_finalize;
  gobject_class->get_property = cinnamon_calendar_server_skeleton_get_property;
  gobject_class->set_property = cinnamon_calendar_server_skeleton_set_property;
  gobject_class->notify       = cinnamon_calendar_server_skeleton_notify;


  cinnamon_calendar_server_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cinnamon_calendar_server_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cinnamon_calendar_server_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cinnamon_calendar_server_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cinnamon_calendar_server_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CinnamonCalendarServerSkeletonPrivate));
#endif
}

static void
cinnamon_calendar_server_skeleton_iface_init (CinnamonCalendarServerIface *iface)
{
  iface->events_added_or_updated = _cinnamon_calendar_server_on_signal_events_added_or_updated;
  iface->events_removed = _cinnamon_calendar_server_on_signal_events_removed;
  iface->client_disappeared = _cinnamon_calendar_server_on_signal_client_disappeared;
  iface->get_since = cinnamon_calendar_server_skeleton_get_since;
  iface->get_until = cinnamon_calendar_server_skeleton_get_until;
  iface->get_status = cinnamon_calendar_server_skeleton_get_status;
}

/**
 * cinnamon_calendar_server_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-cinnamon-CalendarServer.top_of_page">org.cinnamon.CalendarServer</link>.
 *
 * Returns: (transfer full) (type CinnamonCalendarServerSkeleton): The skeleton object.
 */
CinnamonCalendarServer *
cinnamon_calendar_server_skeleton_new (void)
{
  return CINNAMON_CALENDAR_SERVER (g_object_new (CINNAMON_TYPE_CALENDAR_SERVER_SKELETON, NULL));
}

