// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: h2c.proto

package h2c

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ListenRequest struct {
	Addr     string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	ConnId   string `protobuf:"bytes,3,opt,name=connId,proto3" json:"connId,omitempty"`
	Data     []byte `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	Close    bool   `protobuf:"varint,5,opt,name=close,proto3" json:"close,omitempty"`
}

func (m *ListenRequest) Reset()      { *m = ListenRequest{} }
func (*ListenRequest) ProtoMessage() {}
func (*ListenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c81c9c611bd5641, []int{0}
}
func (m *ListenRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListenRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListenRequest.Merge(m, src)
}
func (m *ListenRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListenRequest proto.InternalMessageInfo

func (m *ListenRequest) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

func (m *ListenRequest) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ListenRequest) GetConnId() string {
	if m != nil {
		return m.ConnId
	}
	return ""
}

func (m *ListenRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ListenRequest) GetClose() bool {
	if m != nil {
		return m.Close
	}
	return false
}

type ListenResponse struct {
	Addr   string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	ConnId string `protobuf:"bytes,2,opt,name=connId,proto3" json:"connId,omitempty"`
	Data   []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	Close  bool   `protobuf:"varint,4,opt,name=close,proto3" json:"close,omitempty"`
}

func (m *ListenResponse) Reset()      { *m = ListenResponse{} }
func (*ListenResponse) ProtoMessage() {}
func (*ListenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c81c9c611bd5641, []int{1}
}
func (m *ListenResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListenResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListenResponse.Merge(m, src)
}
func (m *ListenResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListenResponse proto.InternalMessageInfo

func (m *ListenResponse) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

func (m *ListenResponse) GetConnId() string {
	if m != nil {
		return m.ConnId
	}
	return ""
}

func (m *ListenResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ListenResponse) GetClose() bool {
	if m != nil {
		return m.Close
	}
	return false
}

func init() {
	proto.RegisterType((*ListenRequest)(nil), "dagger.h2c.ListenRequest")
	proto.RegisterType((*ListenResponse)(nil), "dagger.h2c.ListenResponse")
}

func init() { proto.RegisterFile("h2c.proto", fileDescriptor_3c81c9c611bd5641) }

var fileDescriptor_3c81c9c611bd5641 = []byte{
	// 277 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x90, 0xb1, 0x4e, 0xb4, 0x40,
	0x14, 0x85, 0xe7, 0x2e, 0x2c, 0xd9, 0xbd, 0xf9, 0xff, 0x2d, 0x26, 0xc6, 0x20, 0xc5, 0x0d, 0xd9,
	0x8a, 0x8a, 0x18, 0xac, 0x6c, 0xb5, 0x32, 0xb1, 0x22, 0xda, 0xd8, 0xe1, 0x30, 0x2e, 0x26, 0x64,
	0x66, 0x05, 0xb6, 0xd7, 0x37, 0xf0, 0x31, 0x7c, 0x14, 0x4b, 0xca, 0x2d, 0x65, 0x68, 0x2c, 0xf7,
	0x11, 0x8c, 0x83, 0xba, 0x9a, 0xd0, 0x9d, 0x33, 0x27, 0x73, 0xbf, 0x93, 0x83, 0xf3, 0x22, 0x11,
	0xf1, 0xba, 0xd2, 0x8d, 0xe6, 0x98, 0x67, 0xab, 0x95, 0xac, 0xe2, 0x22, 0x11, 0xcb, 0x27, 0xc0,
	0xff, 0x97, 0xf7, 0x75, 0x23, 0x55, 0x2a, 0x1f, 0x36, 0xb2, 0x6e, 0x38, 0x47, 0x37, 0xcb, 0xf3,
	0xca, 0x87, 0x10, 0xa2, 0x79, 0x6a, 0x35, 0x0f, 0x70, 0x66, 0xbf, 0x0a, 0x5d, 0xfa, 0x13, 0xfb,
	0xfe, 0xe3, 0xf9, 0x21, 0x7a, 0x42, 0x2b, 0x75, 0x91, 0xfb, 0x8e, 0x4d, 0xbe, 0xdc, 0xe7, 0x9d,
	0x3c, 0x6b, 0x32, 0xdf, 0x0d, 0x21, 0xfa, 0x97, 0x5a, 0xcd, 0x0f, 0x70, 0x2a, 0x4a, 0x5d, 0x4b,
	0x7f, 0x1a, 0x42, 0x34, 0x4b, 0x07, 0xb3, 0xbc, 0xc3, 0xc5, 0x77, 0x85, 0x7a, 0xad, 0x55, 0x2d,
	0x47, 0x3b, 0xec, 0x39, 0x93, 0x51, 0x8e, 0x33, 0xc6, 0x71, 0x7f, 0x71, 0x92, 0x6b, 0x5c, 0x5c,
	0x6d, 0x94, 0x92, 0xe5, 0x40, 0x93, 0x15, 0x3f, 0x47, 0x6f, 0xd0, 0xfc, 0x28, 0xde, 0x8f, 0x12,
	0xff, 0x19, 0x24, 0x08, 0xc6, 0xa2, 0xa1, 0x68, 0x04, 0xc7, 0x70, 0x76, 0xda, 0x76, 0xc4, 0xb6,
	0x1d, 0xb1, 0x5d, 0x47, 0xf0, 0x68, 0x08, 0x5e, 0x0c, 0xc1, 0xab, 0x21, 0x68, 0x0d, 0xc1, 0x9b,
	0x21, 0x78, 0x37, 0xc4, 0x76, 0x86, 0xe0, 0xb9, 0x27, 0xd6, 0xf6, 0xc4, 0xb6, 0x3d, 0xb1, 0x1b,
	0xa7, 0x48, 0xc4, 0xad, 0x67, 0x57, 0x3c, 0xf9, 0x08, 0x00, 0x00, 0xff, 0xff, 0x41, 0xf8, 0x3e,
	0x41, 0x9d, 0x01, 0x00, 0x00,
}

func (this *ListenRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListenRequest)
	if !ok {
		that2, ok := that.(ListenRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Addr != that1.Addr {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.ConnId != that1.ConnId {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if this.Close != that1.Close {
		return false
	}
	return true
}
func (this *ListenResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListenResponse)
	if !ok {
		that2, ok := that.(ListenResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Addr != that1.Addr {
		return false
	}
	if this.ConnId != that1.ConnId {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if this.Close != that1.Close {
		return false
	}
	return true
}
func (this *ListenRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&h2c.ListenRequest{")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "ConnId: "+fmt.Sprintf("%#v", this.ConnId)+",\n")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "Close: "+fmt.Sprintf("%#v", this.Close)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListenResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&h2c.ListenResponse{")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "ConnId: "+fmt.Sprintf("%#v", this.ConnId)+",\n")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "Close: "+fmt.Sprintf("%#v", this.Close)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringH2C(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TunnelListenerClient is the client API for TunnelListener service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TunnelListenerClient interface {
	Listen(ctx context.Context, opts ...grpc.CallOption) (TunnelListener_ListenClient, error)
}

type tunnelListenerClient struct {
	cc *grpc.ClientConn
}

func NewTunnelListenerClient(cc *grpc.ClientConn) TunnelListenerClient {
	return &tunnelListenerClient{cc}
}

func (c *tunnelListenerClient) Listen(ctx context.Context, opts ...grpc.CallOption) (TunnelListener_ListenClient, error) {
	stream, err := c.cc.NewStream(ctx, &_TunnelListener_serviceDesc.Streams[0], "/dagger.h2c.TunnelListener/Listen", opts...)
	if err != nil {
		return nil, err
	}
	x := &tunnelListenerListenClient{stream}
	return x, nil
}

type TunnelListener_ListenClient interface {
	Send(*ListenRequest) error
	Recv() (*ListenResponse, error)
	grpc.ClientStream
}

type tunnelListenerListenClient struct {
	grpc.ClientStream
}

func (x *tunnelListenerListenClient) Send(m *ListenRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *tunnelListenerListenClient) Recv() (*ListenResponse, error) {
	m := new(ListenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TunnelListenerServer is the server API for TunnelListener service.
type TunnelListenerServer interface {
	Listen(TunnelListener_ListenServer) error
}

// UnimplementedTunnelListenerServer can be embedded to have forward compatible implementations.
type UnimplementedTunnelListenerServer struct {
}

func (*UnimplementedTunnelListenerServer) Listen(srv TunnelListener_ListenServer) error {
	return status.Errorf(codes.Unimplemented, "method Listen not implemented")
}

func RegisterTunnelListenerServer(s *grpc.Server, srv TunnelListenerServer) {
	s.RegisterService(&_TunnelListener_serviceDesc, srv)
}

func _TunnelListener_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TunnelListenerServer).Listen(&tunnelListenerListenServer{stream})
}

type TunnelListener_ListenServer interface {
	Send(*ListenResponse) error
	Recv() (*ListenRequest, error)
	grpc.ServerStream
}

type tunnelListenerListenServer struct {
	grpc.ServerStream
}

func (x *tunnelListenerListenServer) Send(m *ListenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *tunnelListenerListenServer) Recv() (*ListenRequest, error) {
	m := new(ListenRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _TunnelListener_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dagger.h2c.TunnelListener",
	HandlerType: (*TunnelListenerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Listen",
			Handler:       _TunnelListener_Listen_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "h2c.proto",
}

func (m *ListenRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListenRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Close {
		i--
		if m.Close {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ConnId) > 0 {
		i -= len(m.ConnId)
		copy(dAtA[i:], m.ConnId)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.ConnId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Addr) > 0 {
		i -= len(m.Addr)
		copy(dAtA[i:], m.Addr)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.Addr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListenResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListenResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Close {
		i--
		if m.Close {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ConnId) > 0 {
		i -= len(m.ConnId)
		copy(dAtA[i:], m.ConnId)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.ConnId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Addr) > 0 {
		i -= len(m.Addr)
		copy(dAtA[i:], m.Addr)
		i = encodeVarintH2C(dAtA, i, uint64(len(m.Addr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintH2C(dAtA []byte, offset int, v uint64) int {
	offset -= sovH2C(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ListenRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	l = len(m.ConnId)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	if m.Close {
		n += 2
	}
	return n
}

func (m *ListenResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	l = len(m.ConnId)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovH2C(uint64(l))
	}
	if m.Close {
		n += 2
	}
	return n
}

func sovH2C(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozH2C(x uint64) (n int) {
	return sovH2C(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ListenRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListenRequest{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`ConnId:` + fmt.Sprintf("%v", this.ConnId) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Close:` + fmt.Sprintf("%v", this.Close) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListenResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListenResponse{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`ConnId:` + fmt.Sprintf("%v", this.ConnId) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Close:` + fmt.Sprintf("%v", this.Close) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringH2C(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ListenRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowH2C
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConnId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Close", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Close = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipH2C(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthH2C
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListenResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowH2C
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConnId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthH2C
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthH2C
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Close", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Close = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipH2C(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthH2C
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipH2C(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowH2C
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowH2C
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthH2C
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupH2C
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthH2C
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthH2C        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowH2C          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupH2C = fmt.Errorf("proto: unexpected end of group")
)
