/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#include<QStringBuilder>

#include "src/datovka_shared/app_version_info.h"

#define textLineNL(text) \
	(QString("‣ ") % (text) % QLatin1String("<br>"))

QString AppVersionInfo::releaseNewsText(void)
{
	QString content;

	content.append(textLineNL(tr("Fixed error when authenticating messages from ZFO files.")));
	content.append(textLineNL(tr("Showing restamping status as plain text and not as an error.")));
	content.append(textLineNL(tr("Unsent messages can be saved as drafts.")));
	content.append(textLineNL(tr("Periodic backup notification and default backup target can be set in preferences.")));
	content.append(textLineNL(tr("Fixed error in copying external files when splitting monolithic message databases.")));

	return content;
}
