// This file is generated by kconfig_compiler_kf6 from easyeffects_db_autogain.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_AUTOGAIN_H
#define DB_AUTOGAIN_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <qqmlintegration.h>

namespace db {

class Autogain : public KConfigBaseEE
{
  Q_OBJECT
  QML_ELEMENT
  QML_UNCREATABLE("")
  public:

    Autogain( const QString & masterGroup, const QString & instanceIndex );
    ~Autogain() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set target
    */
    void setTarget( double v )
    {
      if (v < -100)
      {
        qDebug() << "setTarget: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 0)
      {
        qDebug() << "setTarget: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mTarget && !isTargetImmutable()) {
        mTarget = v;
        Q_EMIT targetChanged();
      }
    }

    Q_PROPERTY(double target READ target WRITE setTarget NOTIFY targetChanged)
    Q_PROPERTY(bool isTargetImmutable READ isTargetImmutable CONSTANT)
    Q_PROPERTY(double defaultTargetValue READ defaultTargetValue CONSTANT)
    /**
      Get target
    */
    double target() const
    {
      return mTarget;
    }

    /**
      Is target Immutable
    */
    bool isTargetImmutable() const
    {
      return isImmutable( QStringLiteral( "target" ) );
    }

    /**
      Get target default value
    */
    double defaultTargetValue() const
    {
        return defaultTargetValue_helper();
    }

    /**
      Set referenceLabels
    */
    void setReferenceLabels( const QStringList & v )
    {
      if (v != mReferenceLabels && !isReferenceLabelsImmutable()) {
        mReferenceLabels = v;
        Q_EMIT referenceLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList referenceLabels READ referenceLabels WRITE setReferenceLabels NOTIFY referenceLabelsChanged)
    Q_PROPERTY(bool isReferenceLabelsImmutable READ isReferenceLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultReferenceLabelsValue READ defaultReferenceLabelsValue CONSTANT)
    /**
      Get referenceLabels
    */
    QStringList referenceLabels() const
    {
      return mReferenceLabels;
    }

    /**
      Is referenceLabels Immutable
    */
    bool isReferenceLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "referenceLabels" ) );
    }

    /**
      Get referenceLabels default value
    */
    QStringList defaultReferenceLabelsValue() const
    {
        return defaultReferenceLabelsValue_helper();
    }

    /**
      Set Reference
    */
    void setReference( int v )
    {
      if (v != mReference && !isReferenceImmutable()) {
        mReference = v;
        Q_EMIT referenceChanged();
      }
    }

    Q_PROPERTY(int reference READ reference WRITE setReference NOTIFY referenceChanged)
    Q_PROPERTY(bool isReferenceImmutable READ isReferenceImmutable CONSTANT)
    Q_PROPERTY(int defaultReferenceValue READ defaultReferenceValue CONSTANT)
    /**
      Get Reference
    */
    int reference() const
    {
      return mReference;
    }

    /**
      Is Reference Immutable
    */
    bool isReferenceImmutable() const
    {
      return isImmutable( QStringLiteral( "reference" ) );
    }

    /**
      Get Reference default value
    */
    int defaultReferenceValue() const
    {
        return defaultReferenceValue_helper();
    }

    /**
      Set maximumHistory
    */
    void setMaximumHistory( int v )
    {
      if (v < 6)
      {
        qDebug() << "setMaximumHistory: value " << v << " is less than the minimum value of 6";
        v = 6;
      }

      if (v > 3600)
      {
        qDebug() << "setMaximumHistory: value " << v << " is greater than the maximum value of 3600";
        v = 3600;
      }

      if (v != mMaximumHistory && !isMaximumHistoryImmutable()) {
        mMaximumHistory = v;
        Q_EMIT maximumHistoryChanged();
      }
    }

    Q_PROPERTY(int maximumHistory READ maximumHistory WRITE setMaximumHistory NOTIFY maximumHistoryChanged)
    Q_PROPERTY(bool isMaximumHistoryImmutable READ isMaximumHistoryImmutable CONSTANT)
    Q_PROPERTY(int defaultMaximumHistoryValue READ defaultMaximumHistoryValue CONSTANT)
    /**
      Get maximumHistory
    */
    int maximumHistory() const
    {
      return mMaximumHistory;
    }

    /**
      Is maximumHistory Immutable
    */
    bool isMaximumHistoryImmutable() const
    {
      return isImmutable( QStringLiteral( "maximumHistory" ) );
    }

    /**
      Get maximumHistory default value
    */
    int defaultMaximumHistoryValue() const
    {
        return defaultMaximumHistoryValue_helper();
    }

    /**
      Set silenceThreshold
    */
    void setSilenceThreshold( double v )
    {
      if (v < -100)
      {
        qDebug() << "setSilenceThreshold: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 0)
      {
        qDebug() << "setSilenceThreshold: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mSilenceThreshold && !isSilenceThresholdImmutable()) {
        mSilenceThreshold = v;
        Q_EMIT silenceThresholdChanged();
      }
    }

    Q_PROPERTY(double silenceThreshold READ silenceThreshold WRITE setSilenceThreshold NOTIFY silenceThresholdChanged)
    Q_PROPERTY(bool isSilenceThresholdImmutable READ isSilenceThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultSilenceThresholdValue READ defaultSilenceThresholdValue CONSTANT)
    /**
      Get silenceThreshold
    */
    double silenceThreshold() const
    {
      return mSilenceThreshold;
    }

    /**
      Is silenceThreshold Immutable
    */
    bool isSilenceThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "silenceThreshold" ) );
    }

    /**
      Get silenceThreshold default value
    */
    double defaultSilenceThresholdValue() const
    {
        return defaultSilenceThresholdValue_helper();
    }

    /**
      Set forceSilence
    */
    void setForceSilence( bool v )
    {
      if (v != mForceSilence && !isForceSilenceImmutable()) {
        mForceSilence = v;
        Q_EMIT forceSilenceChanged();
      }
    }

    Q_PROPERTY(bool forceSilence READ forceSilence WRITE setForceSilence NOTIFY forceSilenceChanged)
    Q_PROPERTY(bool isForceSilenceImmutable READ isForceSilenceImmutable CONSTANT)
    Q_PROPERTY(bool defaultForceSilenceValue READ defaultForceSilenceValue CONSTANT)
    /**
      Get forceSilence
    */
    bool forceSilence() const
    {
      return mForceSilence;
    }

    /**
      Is forceSilence Immutable
    */
    bool isForceSilenceImmutable() const
    {
      return isImmutable( QStringLiteral( "forceSilence" ) );
    }

    /**
      Get forceSilence default value
    */
    bool defaultForceSilenceValue() const
    {
        return defaultForceSilenceValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalTargetChanged = 4,
      signalReferenceLabelsChanged = 5,
      signalReferenceChanged = 6,
      signalMaximumHistoryChanged = 7,
      signalSilenceThresholdChanged = 8,
      signalForceSilenceChanged = 9
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void targetChanged();

    void referenceLabelsChanged();

    void referenceChanged();

    void maximumHistoryChanged();

    void silenceThresholdChanged();

    void forceSilenceChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Autogain#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    double mTarget;
    double defaultTargetValue_helper() const;
    QStringList mReferenceLabels;
    QStringList defaultReferenceLabelsValue_helper() const;
    int mReference;
    int defaultReferenceValue_helper() const;
    int mMaximumHistory;
    int defaultMaximumHistoryValue_helper() const;
    double mSilenceThreshold;
    double defaultSilenceThresholdValue_helper() const;
    bool mForceSilence;
    bool defaultForceSilenceValue_helper() const;
};

}

#endif

