// Code generated by smithy-go-codegen DO NOT EDIT.

package autoscaling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/autoscaling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Launches a specified number of instances in an Auto Scaling group. Returns
//
// instance IDs and other details if launch is successful or error details if
// launch is unsuccessful.
func (c *Client) LaunchInstances(ctx context.Context, params *LaunchInstancesInput, optFns ...func(*Options)) (*LaunchInstancesOutput, error) {
	if params == nil {
		params = &LaunchInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "LaunchInstances", params, optFns, c.addOperationLaunchInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*LaunchInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type LaunchInstancesInput struct {

	//  The name of the Auto Scaling group to launch instances into.
	//
	// This member is required.
	AutoScalingGroupName *string

	//  A unique, case-sensitive identifier to ensure idempotency of the request.
	//
	// This member is required.
	ClientToken *string

	//  The number of instances to launch. Although this value can exceed 100 for
	// instance weights, the actual instance count is limited to 100 instances per
	// launch.
	//
	// This member is required.
	RequestedCapacity *int32

	//  A list of Availability Zone IDs where instances should be launched. Must match
	// or be included in the group's AZ configuration. You cannot specify both
	// AvailabilityZones and AvailabilityZoneIds. Required for multi-AZ groups,
	// optional for single-AZ groups.
	AvailabilityZoneIds []string

	//  The Availability Zones for the instance launch. Must match or be included in
	// the Auto Scaling group's Availability Zone configuration. Either
	// AvailabilityZones or SubnetIds must be specified for groups with multiple
	// Availability Zone configurations.
	AvailabilityZones []string

	//  Specifies whether to retry asynchronously if the synchronous launch fails.
	// Valid values are NONE (default, no async retry) and
	// RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with group
	// configuration).
	RetryStrategy types.RetryStrategy

	//  The subnet IDs for the instance launch. Either AvailabilityZones or SubnetIds
	// must be specified. If both are specified, the subnets must reside in the
	// specified Availability Zones.
	SubnetIds []string

	noSmithyDocumentSerde
}

type LaunchInstancesOutput struct {

	//  The name of the Auto Scaling group where the instances were launched.
	AutoScalingGroupName *string

	//  The idempotency token used for the request, either customer-specified or
	// auto-generated.
	ClientToken *string

	//  A list of errors encountered during the launch attempt including details about
	// failed instance launches with their corresponding error codes and messages.
	Errors []types.LaunchInstancesError

	//  A list of successfully launched instances including details such as instance
	// type, Availability Zone, subnet, lifecycle state, and instance IDs.
	Instances []types.InstanceCollection

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationLaunchInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpLaunchInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpLaunchInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "LaunchInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opLaunchInstancesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpLaunchInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opLaunchInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpLaunchInstances struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpLaunchInstances) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpLaunchInstances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*LaunchInstancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *LaunchInstancesInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opLaunchInstancesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpLaunchInstances{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opLaunchInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "LaunchInstances",
	}
}
